/**
 * Copyright (c) 2023, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { CommonNS } from "../../../models";

/**
 * NOTES: No need to care about the max-len for this file since it's easier to
 * translate the strings to other languages easily with editor translation tools.
 */
/* eslint-disable max-len */
export const common: CommonNS = {
    "access": "Zugriff",
    "actions": "Aktionen",
    "activate": "aktivieren Sie",
    "active": "Aktiv",
    "add": "Hinzufügen",
    "addKey": "Geheimnis hinzufügen",
    "addURL": "URL hinzufügen",
    "all": "Alle",
    "applicationName": "Anwendungsname",
    "applications": "Anwendungen",
    "approvalStatus": "Freigabestand",
    "approve": "Genehmigen",
    "apps": "Anwendungen",
    "assignee": "Beauftragter",
    "assignees": "Beauftragte",
    "authentication": "Authentifizierung",
    "authenticator": "Authentifikator",
    "authenticator_plural": "Authentifikatoren",
    "back": "Zurück",
    "browser": "Browser",
    "cancel": "Stornieren",
    "challengeQuestionNumber": "Herausforderungsfrage {{number}}",
    "change": "Veränderung",
    "chunkLoadErrorMessage": {
        "description": "Beim Bereitstellen der angeforderten Anwendung ist ein Fehler aufgetreten. Bitte versuchen Sie, die App neu zu laden.",
        "heading": "Etwas ist schief gelaufen",
        "primaryActionText": "Laden Sie die App neu"
    },
    "claim": "Beanspruchen",
    "clear": "klar",
    "clientId": "Kunden ID",
    "close": "Schließen",
    "comingSoon": "Kommt bald",
    "completed": "Abgeschlossen",
    "configure": "Konfigurieren",
    "confirm": "Bestätigen",
    "contains": "enthält",
    "continue": "Fortsetzen",
    "copyToClipboard": "In die Zwischenablage kopieren",
    "create": "Erstellen",
    "createdOn": " Angelegt am ",
    "dangerZone": "Gefahrenzone",
    "darkMode": "Dunkler Modus",
    "delete": "Löschen",
    "description": "Beschreibung",
    "deviceModel": "Gerätemodell",
    "disable": "Deaktivieren",
    "disabled": "Deaktiviert",
    "docs": "Dokumente",
    "documentation": "Dokumentation",
    "done": "Getan",
    "download": "Download",
    "drag": "Ziehen",
    "duplicateURLError": "Dieser Wert ist bereits hinzugefügt",
    "edit": "Bearbeiten",
    "enable": "Aktivieren",
    "enabled": "aktiviert",
    "endsWith": "endet auf",
    "equals": "Gleich",
    "exitFullScreen": "Beenden Sie den Vollbildmodus",
    "explore": "Entdecken",
    "export": "Export",
    "featureAvailable": "Diese Funktion wird in Kürze verfügbar sein!",
    "filter": "Filter",
    "finish": "Fertig",
    "generatePassword": "Generiere Passwort",
    "goBackHome": "Wieder nach Hause gehen",
    "goFullScreen": "Gehe in den Vollbildmodus",
    "good": "Gut",
    "help": "Hilfe",
    "hide": "Verstecken",
    "hidePassword": "Passwort verbergen",
    "identityProviders": "Identitätsanbieter",
    "import": "Importieren",
    "initiator": "Initiator",
    "ipAddress": "IP Adresse",
    "issuer": "Aussteller",
    "lastAccessed": "Zuletzt aufgerufen",
    "lastModified": "Zuletzt bearbeitet",
    "lastSeen": "Zuletzt gesehen",
    "lastUpdatedOn": "Zuletzt aktualisiert am",
    "learnMore": "Mehr erfahren",
    "lightMode": "Lichtmodus",
    "loading": "Wird geladen",
    "loginTime": "Anmeldezeit",
    "logout": "Logout",
    "maxValidation": "Dieser Wert sollte kleiner oder gleich {{max}} sein.",
    "maximize": "Maximieren",
    "minValidation": "Dieser Wert sollte größer oder gleich {{min}} sein.",
    "minimize": "Minimieren",
    "more": "Mehr",
    "myAccount": "Mein Konto",
    "name": "Name",
    "networkErrorMessage": {
        "description": "Bitte versuchen Sie erneut, sich anzumelden.",
        "heading": "Deine Sitzung ist abgelaufen",
        "primaryActionText": "Einloggen"
    },
    "new": "Neu",
    "next": "Nächster",
    "okay": "Okay",
    "operatingSystem": "Betriebssystem",
    "operations": "Betrieb",
    "overview": "Überblick",
    "personalInfo": "Persönliche Informationen",
    "pin": "PIN",
    "pinned": "Gepinnt",
    "preview": "Vorschau",
    "previous": "Bisherige",
    "priority": "Priorität",
    "privacy": "Privatsphäre",
    "properties": "Eigenschaften",
    "ready": "Bereit",
    "regenerate": "Regenerieren",
    "register": "Registrieren",
    "reject": "Ablehnen",
    "release": "Veröffentlichung",
    "remove": "Entfernen",
    "removeAll": "Alles entfernen",
    "required": "Dies ist erforderlich.",
    "reserved": "Reserviert",
    "resetFilters": "Filter zurücksetzen",
    "retry": "Wiederholen",
    "revoke": "Widerrufen",
    "revokeAll": "Alle widerrufen",
    "samples": "Proben",
    "save": "speichern",
    "sdks": "SDKs",
    "search": "Suche",
    "security": "SICHERHEIT",
    "services": "Dienstleistungen",
    "settings": "die Einstellungen",
    "setup": "Konfiguration",
    "show": "Show",
    "showAll": "Zeige alles",
    "showLess": "Weniger anzeigen",
    "showMore": "Zeig mehr",
    "showPassword": "Passwort anzeigen",
    "skip": "Überspringen",
    "startsWith": "fängt an mit",
    "step": "Schritt",
    "strong": "stark",
    "submit": "einreichen",
    "switch": "Schalter",
    "technologies": "Technologien",
    "terminate": "Beenden",
    "terminateAll": "Alle beenden",
    "terminateSession": "Sitzung beenden",
    "tooShort": "Zu kurz",
    "type": "Art",
    "unpin": "Lösen Sie den Stift",
    "unpinned": "Losgelöst",
    "update": "Aktualisieren",
    "user": "Nutzer",
    "verify": "Überprüfen",
    "view": "Aussicht",
    "weak": "Schwach",
    "weakPassword": "Die Passwortstärke sollte zumindest gut sein."
};
