/**
 * Copyright (c) 2023, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { CommonNS } from "../../../models";

/**
 * NOTES: No need to care about the max-len for this file since it's easier to
 * translate the strings to other languages easily with editor translation tools.
 */
/* eslint-disable max-len */
export const common: CommonNS = {
    access: "Acceso",
    actions: "Comportamiento",
    activate: "Activar",
    active: "Activo",
    add: "Añadir",
    addKey: "Agregar secreto",
    addURL: "Agregar URL",
    all: "Todas",
    applicationName: "Nombre de la aplicación",
    applications: "Aplicaciones",
    approvalStatus: "Estado de aprobación",
    approve: "Aprobar",
    apps: "Aplicaciones",
    assignee: "Cesionario",
    assignees: "cesionarios",
    authentication: "Autenticación",
    authenticator: "Autenticador",
    authenticator_plural: "Autenticadores",
    back: "atrás",
    browser: "Navegador",
    cancel: "Cancelar",
    challengeQuestionNumber: "Pregunta de desafío {{number}}",
    change: "Cambio",
    chunkLoadErrorMessage: {
        description: "Ocurrió un error al servir la aplicación solicitada. Intente volver a cargar la aplicación.",
        heading: "Algo salió mal",
        primaryActionText: "Recargar la aplicación"
    },
    claim: "Afirmar",
    clear: "Claro",
    clientId: "Identificación del cliente",
    close: "Cerrar",
    comingSoon: "Próximamente, en breve, pronto",
    completed: "TERMINADO",
    configure: "Configurar",
    confirm: "Confirmar",
    contains: "contiene",
    continue: "SEGUIR",
    copyToClipboard: "Copiar al portapapeles",
    create: "Crear",
    createdOn: "Creado en",
    dangerZone: "Zona peligrosa",
    darkMode: "Modo oscuro",
    delete: "Borrar",
    description: "Descripción",
    deviceModel: "Modelo de dispositivo",
    disable: "Desactivar",
    disabled: "discapacitado",
    docs: "Documentos",
    documentation: "documentación",
    done: "Hecho",
    download: "Descargar",
    drag: "Arrastrar",
    duplicateURLError: "Este valor ya está agregado",
    edit: "Editar",
    enable: "Permitir",
    enabled: "activado",
    endsWith: "Termina con",
    equals: "igual",
    exitFullScreen: "Salir de pantalla completa",
    explore: "Explorar",
    export: "Exportar",
    featureAvailable: "¡Esta característica estará disponible pronto!",
    filter: "Filtrar",
    finish: "Terminar",
    generatePassword: "Generar contraseña",
    goBackHome: "Regresar a casa",
    goFullScreen: "Ir a pantalla completa",
    good: "Bien",
    help: "Ayuda",
    hide: "Esconder",
    hidePassword: "Contraseña oculta",
    identityProviders: "Proveedores de identidad",
    import: "Importar",
    initiator: "Iniciador",
    ipAddress: "dirección IP",
    issuer: "Editor",
    lastAccessed: "Último accedido",
    lastModified: "Última modificación",
    lastSeen: "Ultima vez visto",
    lastUpdatedOn: "Ultima actualización en",
    learnMore: "Aprende más",
    lightMode: "Modo de luz",
    loading: "Cargando",
    loginTime: "Hora de inicio de sesión",
    logout: "Cerrar sesión",
    maxValidation: "Este valor debe ser menor o igual a {{max}}.",
    maximize: "Maximizar",
    minValidation: "Este valor debe ser mayor o igual a {{min}}.",
    minimize: "Minimizar",
    more: "más",
    myAccount: "Mi cuenta",
    name: "Nombre",
    networkErrorMessage: {
        description: "Intente iniciar sesión de nuevo.",
        heading: "Su sesión ha caducado",
        primaryActionText: "Registrarse"
    },
    new: "Nuevo",
    next: "próximo",
    okay: "Okey",
    operatingSystem: "Sistema operativo",
    operations: "Operaciones",
    overview: "Descripción general",
    personalInfo: "Información personal",
    pin: "Alfiler",
    pinned: "Fijado",
    preview: "Avance",
    previous: "Anterior",
    priority: "Prioridad",
    privacy: "intimidad",
    properties: "Propiedades",
    ready: "Listo",
    regenerate: "Regenerado",
    register: "Registrarse",
    reject: "Rechazar",
    release: "Liberación",
    remove: "Eliminar",
    removeAll: "Eliminar todo",
    required: "Esto es requerido.",
    reserved: "Reservado",
    resetFilters: "Restablecer filtros",
    retry: "Rever",
    revoke: "Revocar",
    revokeAll: "revocar todo",
    samples: "Muestras",
    save: "Salvar",
    sdks: "SDK",
    search: "Buscar",
    security: "Seguridad",
    services: "Servicios",
    settings: "AJUSTES",
    setup: "Configurar",
    show: "Show",
    showAll: "Mostrar todo",
    showLess: "Muestra menos",
    showMore: "Mostrar más",
    showPassword: "Mostrar contraseña",
    skip: "Saltar",
    startsWith: "Comienza con",
    step: "Paso",
    strong: "Fuerte",
    submit: "Enviar",
    switch: "Cambiar",
    technologies: "Tecnologías",
    terminate: "Terminar",
    terminateAll: "Terminar todo",
    terminateSession: "Terminar sesión",
    tooShort: "Demasiado corto",
    type: "Escribe",
    unpin: "Desprender",
    unpinned: "Sin fijar",
    update: "Actualizar",
    user: "Usuario",
    verify: "Verificar",
    view: "Vista",
    weak: "Débil",
    weakPassword: "La seguridad de la contraseña debería ser al menos buena."
};
