/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface, TestableComponentInterface } from "@wso2is/core/models";
import { ForwardRefExoticComponent, PropsWithoutRef, ReactNode, RefAttributes } from "react";
import { SidebarProps } from "semantic-ui-react";
import { HelpPanelActionBar } from "./help-panel-action-bar";
import { GenericIconProps } from "../icon";
/**
 * Component ref type.
 */
export declare type HelpPanelRefType = HTMLDivElement;
/**
 * Help side panel component sub component.
 */
export interface HelpPanelSubComponentsInterface {
    ActionBar: typeof HelpPanelActionBar;
}
/**
 * Help panel interface.
 */
export interface HelpPanelPropsInterface extends SidebarProps, IdentifiableComponentInterface, TestableComponentInterface {
    /**
     * Set of actions for the top action bar.
     */
    actions?: HelpPanelActionInterface[];
    /**
     * Enable borders.
     */
    bordered?: "left" | "right" | "bottom" | "top" | boolean;
    /**
     * Array of objects describing tabs.
     */
    tabs: HelpPanelTabInterface[];
    /**
     * Is mini sidebar enabled.
     */
    sidebarMiniEnabled?: boolean;
    /**
     * Tooltip for the sidebar toggle button.
     */
    sidebarToggleTooltip?: string;
    /**
     * Flag to show/hide tab labels on mini sidebar.
     */
    showLabelsOnSidebarMini?: boolean;
    /**
     * Flag to enable/disable showing tool tips on action bar.
     */
    showTooltipsOnActionBar?: boolean;
    /**
     * Flag to enable/disable showing tool tips on sidebar mini.
     */
    showTooltipsOnSidebarMini?: boolean;
    /**
     * Callback to be called on sidebar toggle.
     */
    onSidebarToggle?: () => void;
    /**
     * Called on sidebar mini item click.
     * @param item - Clicked on item.
     */
    onSidebarMiniItemClick?: (item: string) => void;
    /**
     * Should the help panel appear raised.
     */
    raised?: boolean;
    /**
     * Initial tabs active index.
     */
    tabsActiveIndex?: number;
}
/**
 * Interface for help panel actions.
 */
export interface HelpPanelActionInterface extends GenericIconProps {
    /**
     * Tooltip for the button.
     */
    tooltip?: string;
}
/**
 * Help panel component Prop types.
 */
export interface HelpPanelComponentPropsInterface extends HelpPanelPropsInterface, HelpPanelSubComponentsInterface {
}
/**
 * Help panel tab interface.
 */
export interface HelpPanelTabInterface {
    heading: any;
    hidden: boolean;
    content: ReactNode;
    icon: GenericIconProps;
}
/**
 * Help side panel.
 *
 * @param props - Props injected to the component.
 *
 * @returns the help side panel.
 */
export declare const HelpPanel: ForwardRefExoticComponent<PropsWithoutRef<HelpPanelComponentPropsInterface> & RefAttributes<HelpPanelRefType>> & any;
