/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ChildRouteInterface, IdentifiableComponentInterface, TestableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent } from "react";
import { CommonSidePanelPropsInterface } from "./side-panel";
/**
 * Side panel item group component Prop types.
 */
export interface SidePanelItemGroupPropsInterface extends CommonSidePanelPropsInterface, IdentifiableComponentInterface, TestableComponentInterface {
    /**
     * Child routes array.
     */
    childRoutes: ChildRouteInterface[];
    /**
     * Is opened.
     */
    open?: boolean;
    /**
     * Scopes allowed for the user.
     */
    allowedScopes: string;
}
/**
 * Side panel item group component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */
export declare const SidePanelItemGroup: FunctionComponent<SidePanelItemGroupPropsInterface>;
