/**
 * Copyright (c) 2023, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from "react";
import { SemanticCOLORS } from "semantic-ui-react";
/**
 * Prop types for the password validation icons.
 */
export interface IconProps {
    cssClassName: string;
    color: SemanticCOLORS;
}
export interface ValidationContentI18nInterface {
    length?: string;
    numbers?: string;
    case?: string;
    specialChr?: string;
    uniqueChr?: string;
    consecutiveChr?: string;
}
export interface ValidationStatusInterface {
    length?: boolean;
    numbers?: boolean;
    case?: boolean;
    specialChr?: boolean;
    uniqueChr?: boolean;
    consecutiveChr?: boolean;
    empty?: boolean;
}
export interface ValidationProps {
    minLength?: number;
    maxLength?: number;
    minNumbers?: number;
    minUpperCase?: number;
    minLowerCase?: number;
    minSpecialChr?: number;
    minUniqueChr?: number;
    maxConsecutiveChr?: number;
    className?: string;
    password: string;
    translations?: ValidationContentI18nInterface;
    onPasswordValidate?: (isValid: boolean, validationStatus: ValidationStatusInterface) => void;
}
export declare const PasswordValidation: React.FunctionComponent<ValidationProps>;
