import classNames from 'classnames';
import * as React from 'react';
import React__default, { useState, useEffect, isValidElement, useMemo, forwardRef, useRef, createContext, useContext, Component, useCallback, Fragment, Children, cloneElement } from 'react';
import { Accordion, Segment, Popup as Popup$1, Card, Grid, Header as Header$1, Icon, Menu, List, Message as Message$1, Ref, Checkbox, Label, Button as Button$1, Loader, Statistic, Dimmer, Divider, GridColumn, Image, Placeholder, TransitionablePortal, Modal, Dropdown, Item, Flag, Container, Tab, TextArea, Sidebar, Input, Form, Pagination as Pagination$1, Table, Visibility } from 'semantic-ui-react';
import { createMedia } from '@artsy/fresnel';
import { AlertLevels, ProductReleaseTypes } from '@wso2is/core/models';
import NotificationSystem from 'react-notification-system';
import kebabCase from 'lodash-es/kebabCase';
import isObject$g from 'lodash-es/isObject';
import { ImageUtils, CookieStorageUtils, CommonUtils, CertificateManagementUtils, URLUtils, ProfileUtils } from '@wso2is/core/utils';
import { UIConstants, AppConstants, CommonConstants } from '@wso2is/core/constants';
import { resolveUserDisplayName, resolveUsername } from '@wso2is/core/helpers';
import JSBeautify from 'js-beautify';
import { JSHINT } from 'jshint/dist/jshint';
import { UnControlled } from 'react-codemirror2';
import 'codemirror/addon/lint/lint';
import 'codemirror/addon/lint/javascript-lint';
import 'codemirror/addon/hint/sql-hint';
import 'codemirror/mode/javascript/javascript';
import 'codemirror/mode/sql/sql';
import 'codemirror/mode/xml/xml';
import 'codemirror/mode/shell/shell';
import 'codemirror/mode/htmlmixed/htmlmixed';
import 'codemirror/addon/edit/closebrackets';
import 'codemirror/addon/edit/matchbrackets';
import 'codemirror/addon/hint/show-hint';
import 'codemirror/addon/hint/javascript-hint';
import 'codemirror/lib/codemirror.css';
import 'codemirror/theme/material.css';
import 'codemirror/addon/lint/lint.css';
import 'codemirror/addon/hint/show-hint.css';
import isEmpty from 'lodash-es/isEmpty';
import { createPortal } from 'react-dom';
import get$2 from 'lodash-es/get';
import PropTypes from 'prop-types';
import { Link as Link$1, Route, Redirect } from 'react-router-dom';
import { X509, KJUR } from 'jsrsasign';
import * as forge from 'node-forge';
import take from 'lodash-es/take';
import { getGravatarImage } from '@wso2is/core/api';
import inRange from 'lodash-es/inRange';
import { useTrigger, Forms, Field } from '@wso2is/forms';
import { Trans } from 'react-i18next';
import LoadingBar from 'react-top-loading-bar';
import tinycolor from 'tinycolor2';
import { SketchPicker } from 'react-color';
import moment from 'moment';
import ReactMarkdown from 'react-markdown/with-html';
import sortBy from 'lodash-es/sortBy';
import isEqual from 'lodash-es/isEqual';
import cloneDeep from 'lodash-es/cloneDeep';
import { Helmet } from 'react-helmet';

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

var check = function (it) {
  return it && it.Math == Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global$z =
  // eslint-disable-next-line es-x/no-global-this -- safe
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  // eslint-disable-next-line no-restricted-globals -- safe
  check(typeof self == 'object' && self) ||
  check(typeof commonjsGlobal == 'object' && commonjsGlobal) ||
  // eslint-disable-next-line no-new-func -- fallback
  (function () { return this; })() || Function('return this')();

var objectGetOwnPropertyDescriptor = {};

var fails$z = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};

var fails$y = fails$z;

// Detect IE8's incomplete defineProperty implementation
var descriptors = !fails$y(function () {
  // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] != 7;
});

var fails$x = fails$z;

var functionBindNative = !fails$x(function () {
  // eslint-disable-next-line es-x/no-function-prototype-bind -- safe
  var test = (function () { /* empty */ }).bind();
  // eslint-disable-next-line no-prototype-builtins -- safe
  return typeof test != 'function' || test.hasOwnProperty('prototype');
});

var NATIVE_BIND$3 = functionBindNative;

var call$r = Function.prototype.call;

var functionCall = NATIVE_BIND$3 ? call$r.bind(call$r) : function () {
  return call$r.apply(call$r, arguments);
};

var objectPropertyIsEnumerable = {};

var $propertyIsEnumerable = {}.propertyIsEnumerable;
// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor$3 = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor$3 && !$propertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor$3(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;

var createPropertyDescriptor$6 = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

var NATIVE_BIND$2 = functionBindNative;

var FunctionPrototype$2 = Function.prototype;
var bind$a = FunctionPrototype$2.bind;
var call$q = FunctionPrototype$2.call;
var uncurryThis$y = NATIVE_BIND$2 && bind$a.bind(call$q, call$q);

var functionUncurryThis = NATIVE_BIND$2 ? function (fn) {
  return fn && uncurryThis$y(fn);
} : function (fn) {
  return fn && function () {
    return call$q.apply(fn, arguments);
  };
};

var uncurryThis$x = functionUncurryThis;

var toString$f = uncurryThis$x({}.toString);
var stringSlice$9 = uncurryThis$x(''.slice);

var classofRaw$1 = function (it) {
  return stringSlice$9(toString$f(it), 8, -1);
};

var uncurryThis$w = functionUncurryThis;
var fails$w = fails$z;
var classof$c = classofRaw$1;

var $Object$4 = Object;
var split$3 = uncurryThis$w(''.split);

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var indexedObject = fails$w(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !$Object$4('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof$c(it) == 'String' ? split$3(it, '') : $Object$4(it);
} : $Object$4;

// we can't use just `it == null` since of `document.all` special case
// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
var isNullOrUndefined$8 = function (it) {
  return it === null || it === undefined;
};

var isNullOrUndefined$7 = isNullOrUndefined$8;

var $TypeError$h = TypeError;

// `RequireObjectCoercible` abstract operation
// https://tc39.es/ecma262/#sec-requireobjectcoercible
var requireObjectCoercible$9 = function (it) {
  if (isNullOrUndefined$7(it)) throw $TypeError$h("Can't call method on " + it);
  return it;
};

// toObject with fallback for non-array-like ES3 strings
var IndexedObject$3 = indexedObject;
var requireObjectCoercible$8 = requireObjectCoercible$9;

var toIndexedObject$6 = function (it) {
  return IndexedObject$3(requireObjectCoercible$8(it));
};

// `IsCallable` abstract operation
// https://tc39.es/ecma262/#sec-iscallable
var isCallable$r = function (argument) {
  return typeof argument == 'function';
};

var isCallable$q = isCallable$r;

var documentAll = typeof document == 'object' && document.all;

// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
var SPECIAL_DOCUMENT_ALL = typeof documentAll == 'undefined' && documentAll !== undefined;

var isObject$f = SPECIAL_DOCUMENT_ALL ? function (it) {
  return typeof it == 'object' ? it !== null : isCallable$q(it) || it === documentAll;
} : function (it) {
  return typeof it == 'object' ? it !== null : isCallable$q(it);
};

var global$y = global$z;
var isCallable$p = isCallable$r;

var aFunction = function (argument) {
  return isCallable$p(argument) ? argument : undefined;
};

var getBuiltIn$9 = function (namespace, method) {
  return arguments.length < 2 ? aFunction(global$y[namespace]) : global$y[namespace] && global$y[namespace][method];
};

var uncurryThis$v = functionUncurryThis;

var objectIsPrototypeOf = uncurryThis$v({}.isPrototypeOf);

var getBuiltIn$8 = getBuiltIn$9;

var engineUserAgent = getBuiltIn$8('navigator', 'userAgent') || '';

var global$x = global$z;
var userAgent$5 = engineUserAgent;

var process$3 = global$x.process;
var Deno$1 = global$x.Deno;
var versions = process$3 && process$3.versions || Deno$1 && Deno$1.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
  // but their correct versions are not interesting for us
  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}

// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
// so check `userAgent` even if `.v8` exists, but 0
if (!version && userAgent$5) {
  match = userAgent$5.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent$5.match(/Chrome\/(\d+)/);
    if (match) version = +match[1];
  }
}

var engineV8Version = version;

/* eslint-disable es-x/no-symbol -- required for testing */

var V8_VERSION$1 = engineV8Version;
var fails$v = fails$z;

// eslint-disable-next-line es-x/no-object-getownpropertysymbols -- required for testing
var symbolConstructorDetection = !!Object.getOwnPropertySymbols && !fails$v(function () {
  var symbol = Symbol();
  // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
  return !String(symbol) || !(Object(symbol) instanceof Symbol) ||
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION$1 && V8_VERSION$1 < 41;
});

/* eslint-disable es-x/no-symbol -- required for testing */

var NATIVE_SYMBOL$2 = symbolConstructorDetection;

var useSymbolAsUid = NATIVE_SYMBOL$2
  && !Symbol.sham
  && typeof Symbol.iterator == 'symbol';

var getBuiltIn$7 = getBuiltIn$9;
var isCallable$o = isCallable$r;
var isPrototypeOf$7 = objectIsPrototypeOf;
var USE_SYMBOL_AS_UID$1 = useSymbolAsUid;

var $Object$3 = Object;

var isSymbol$3 = USE_SYMBOL_AS_UID$1 ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = getBuiltIn$7('Symbol');
  return isCallable$o($Symbol) && isPrototypeOf$7($Symbol.prototype, $Object$3(it));
};

var $String$3 = String;

var tryToString$6 = function (argument) {
  try {
    return $String$3(argument);
  } catch (error) {
    return 'Object';
  }
};

var isCallable$n = isCallable$r;
var tryToString$5 = tryToString$6;

var $TypeError$g = TypeError;

// `Assert: IsCallable(argument) is true`
var aCallable$a = function (argument) {
  if (isCallable$n(argument)) return argument;
  throw $TypeError$g(tryToString$5(argument) + ' is not a function');
};

var aCallable$9 = aCallable$a;
var isNullOrUndefined$6 = isNullOrUndefined$8;

// `GetMethod` abstract operation
// https://tc39.es/ecma262/#sec-getmethod
var getMethod$7 = function (V, P) {
  var func = V[P];
  return isNullOrUndefined$6(func) ? undefined : aCallable$9(func);
};

var call$p = functionCall;
var isCallable$m = isCallable$r;
var isObject$e = isObject$f;

var $TypeError$f = TypeError;

// `OrdinaryToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-ordinarytoprimitive
var ordinaryToPrimitive$1 = function (input, pref) {
  var fn, val;
  if (pref === 'string' && isCallable$m(fn = input.toString) && !isObject$e(val = call$p(fn, input))) return val;
  if (isCallable$m(fn = input.valueOf) && !isObject$e(val = call$p(fn, input))) return val;
  if (pref !== 'string' && isCallable$m(fn = input.toString) && !isObject$e(val = call$p(fn, input))) return val;
  throw $TypeError$f("Can't convert object to primitive value");
};

var shared$4 = {exports: {}};

var isPure = false;

var global$w = global$z;

// eslint-disable-next-line es-x/no-object-defineproperty -- safe
var defineProperty$a = Object.defineProperty;

var defineGlobalProperty$3 = function (key, value) {
  try {
    defineProperty$a(global$w, key, { value: value, configurable: true, writable: true });
  } catch (error) {
    global$w[key] = value;
  } return value;
};

var global$v = global$z;
var defineGlobalProperty$2 = defineGlobalProperty$3;

var SHARED = '__core-js_shared__';
var store$3 = global$v[SHARED] || defineGlobalProperty$2(SHARED, {});

var sharedStore = store$3;

var store$2 = sharedStore;

(shared$4.exports = function (key, value) {
  return store$2[key] || (store$2[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.25.0',
  mode: 'global',
  copyright: '© 2014-2022 Denis Pushkarev (zloirock.ru)',
  license: 'https://github.com/zloirock/core-js/blob/v3.25.0/LICENSE',
  source: 'https://github.com/zloirock/core-js'
});

var requireObjectCoercible$7 = requireObjectCoercible$9;

var $Object$2 = Object;

// `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject
var toObject$a = function (argument) {
  return $Object$2(requireObjectCoercible$7(argument));
};

var uncurryThis$u = functionUncurryThis;
var toObject$9 = toObject$a;

var hasOwnProperty = uncurryThis$u({}.hasOwnProperty);

// `HasOwnProperty` abstract operation
// https://tc39.es/ecma262/#sec-hasownproperty
// eslint-disable-next-line es-x/no-object-hasown -- safe
var hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty(toObject$9(it), key);
};

var uncurryThis$t = functionUncurryThis;

var id = 0;
var postfix = Math.random();
var toString$e = uncurryThis$t(1.0.toString);

var uid$3 = function (key) {
  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString$e(++id + postfix, 36);
};

var global$u = global$z;
var shared$3 = shared$4.exports;
var hasOwn$g = hasOwnProperty_1;
var uid$2 = uid$3;
var NATIVE_SYMBOL$1 = symbolConstructorDetection;
var USE_SYMBOL_AS_UID = useSymbolAsUid;

var WellKnownSymbolsStore = shared$3('wks');
var Symbol$2 = global$u.Symbol;
var symbolFor = Symbol$2 && Symbol$2['for'];
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol$2 : Symbol$2 && Symbol$2.withoutSetter || uid$2;

var wellKnownSymbol$n = function (name) {
  if (!hasOwn$g(WellKnownSymbolsStore, name) || !(NATIVE_SYMBOL$1 || typeof WellKnownSymbolsStore[name] == 'string')) {
    var description = 'Symbol.' + name;
    if (NATIVE_SYMBOL$1 && hasOwn$g(Symbol$2, name)) {
      WellKnownSymbolsStore[name] = Symbol$2[name];
    } else if (USE_SYMBOL_AS_UID && symbolFor) {
      WellKnownSymbolsStore[name] = symbolFor(description);
    } else {
      WellKnownSymbolsStore[name] = createWellKnownSymbol(description);
    }
  } return WellKnownSymbolsStore[name];
};

var call$o = functionCall;
var isObject$d = isObject$f;
var isSymbol$2 = isSymbol$3;
var getMethod$6 = getMethod$7;
var ordinaryToPrimitive = ordinaryToPrimitive$1;
var wellKnownSymbol$m = wellKnownSymbol$n;

var $TypeError$e = TypeError;
var TO_PRIMITIVE = wellKnownSymbol$m('toPrimitive');

// `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive
var toPrimitive$2 = function (input, pref) {
  if (!isObject$d(input) || isSymbol$2(input)) return input;
  var exoticToPrim = getMethod$6(input, TO_PRIMITIVE);
  var result;
  if (exoticToPrim) {
    if (pref === undefined) pref = 'default';
    result = call$o(exoticToPrim, input, pref);
    if (!isObject$d(result) || isSymbol$2(result)) return result;
    throw $TypeError$e("Can't convert object to primitive value");
  }
  if (pref === undefined) pref = 'number';
  return ordinaryToPrimitive(input, pref);
};

var toPrimitive$1 = toPrimitive$2;
var isSymbol$1 = isSymbol$3;

// `ToPropertyKey` abstract operation
// https://tc39.es/ecma262/#sec-topropertykey
var toPropertyKey$4 = function (argument) {
  var key = toPrimitive$1(argument, 'string');
  return isSymbol$1(key) ? key : key + '';
};

var global$t = global$z;
var isObject$c = isObject$f;

var document$3 = global$t.document;
// typeof document.createElement is 'object' in old IE
var EXISTS$1 = isObject$c(document$3) && isObject$c(document$3.createElement);

var documentCreateElement$2 = function (it) {
  return EXISTS$1 ? document$3.createElement(it) : {};
};

var DESCRIPTORS$h = descriptors;
var fails$u = fails$z;
var createElement$1 = documentCreateElement$2;

// Thanks to IE8 for its funny defineProperty
var ie8DomDefine = !DESCRIPTORS$h && !fails$u(function () {
  // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
  return Object.defineProperty(createElement$1('div'), 'a', {
    get: function () { return 7; }
  }).a != 7;
});

var DESCRIPTORS$g = descriptors;
var call$n = functionCall;
var propertyIsEnumerableModule$1 = objectPropertyIsEnumerable;
var createPropertyDescriptor$5 = createPropertyDescriptor$6;
var toIndexedObject$5 = toIndexedObject$6;
var toPropertyKey$3 = toPropertyKey$4;
var hasOwn$f = hasOwnProperty_1;
var IE8_DOM_DEFINE$1 = ie8DomDefine;

// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
objectGetOwnPropertyDescriptor.f = DESCRIPTORS$g ? $getOwnPropertyDescriptor$1 : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject$5(O);
  P = toPropertyKey$3(P);
  if (IE8_DOM_DEFINE$1) try {
    return $getOwnPropertyDescriptor$1(O, P);
  } catch (error) { /* empty */ }
  if (hasOwn$f(O, P)) return createPropertyDescriptor$5(!call$n(propertyIsEnumerableModule$1.f, O, P), O[P]);
};

var objectDefineProperty = {};

var DESCRIPTORS$f = descriptors;
var fails$t = fails$z;

// V8 ~ Chrome 36-
// https://bugs.chromium.org/p/v8/issues/detail?id=3334
var v8PrototypeDefineBug = DESCRIPTORS$f && fails$t(function () {
  // eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
    value: 42,
    writable: false
  }).prototype != 42;
});

var isObject$b = isObject$f;

var $String$2 = String;
var $TypeError$d = TypeError;

// `Assert: Type(argument) is Object`
var anObject$k = function (argument) {
  if (isObject$b(argument)) return argument;
  throw $TypeError$d($String$2(argument) + ' is not an object');
};

var DESCRIPTORS$e = descriptors;
var IE8_DOM_DEFINE = ie8DomDefine;
var V8_PROTOTYPE_DEFINE_BUG$1 = v8PrototypeDefineBug;
var anObject$j = anObject$k;
var toPropertyKey$2 = toPropertyKey$4;

var $TypeError$c = TypeError;
// eslint-disable-next-line es-x/no-object-defineproperty -- safe
var $defineProperty = Object.defineProperty;
// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var ENUMERABLE = 'enumerable';
var CONFIGURABLE$1 = 'configurable';
var WRITABLE = 'writable';

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
objectDefineProperty.f = DESCRIPTORS$e ? V8_PROTOTYPE_DEFINE_BUG$1 ? function defineProperty(O, P, Attributes) {
  anObject$j(O);
  P = toPropertyKey$2(P);
  anObject$j(Attributes);
  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
    var current = $getOwnPropertyDescriptor(O, P);
    if (current && current[WRITABLE]) {
      O[P] = Attributes.value;
      Attributes = {
        configurable: CONFIGURABLE$1 in Attributes ? Attributes[CONFIGURABLE$1] : current[CONFIGURABLE$1],
        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
        writable: false
      };
    }
  } return $defineProperty(O, P, Attributes);
} : $defineProperty : function defineProperty(O, P, Attributes) {
  anObject$j(O);
  P = toPropertyKey$2(P);
  anObject$j(Attributes);
  if (IE8_DOM_DEFINE) try {
    return $defineProperty(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw $TypeError$c('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

var DESCRIPTORS$d = descriptors;
var definePropertyModule$6 = objectDefineProperty;
var createPropertyDescriptor$4 = createPropertyDescriptor$6;

var createNonEnumerableProperty$9 = DESCRIPTORS$d ? function (object, key, value) {
  return definePropertyModule$6.f(object, key, createPropertyDescriptor$4(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

var makeBuiltIn$3 = {exports: {}};

var DESCRIPTORS$c = descriptors;
var hasOwn$e = hasOwnProperty_1;

var FunctionPrototype$1 = Function.prototype;
// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var getDescriptor = DESCRIPTORS$c && Object.getOwnPropertyDescriptor;

var EXISTS = hasOwn$e(FunctionPrototype$1, 'name');
// additional protection from minified / mangled / dropped function names
var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS$c || (DESCRIPTORS$c && getDescriptor(FunctionPrototype$1, 'name').configurable));

var functionName = {
  EXISTS: EXISTS,
  PROPER: PROPER,
  CONFIGURABLE: CONFIGURABLE
};

var uncurryThis$s = functionUncurryThis;
var isCallable$l = isCallable$r;
var store$1 = sharedStore;

var functionToString = uncurryThis$s(Function.toString);

// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
if (!isCallable$l(store$1.inspectSource)) {
  store$1.inspectSource = function (it) {
    return functionToString(it);
  };
}

var inspectSource$3 = store$1.inspectSource;

var global$s = global$z;
var isCallable$k = isCallable$r;

var WeakMap$1 = global$s.WeakMap;

var weakMapBasicDetection = isCallable$k(WeakMap$1) && /native code/.test(String(WeakMap$1));

var shared$2 = shared$4.exports;
var uid$1 = uid$3;

var keys$2 = shared$2('keys');

var sharedKey$3 = function (key) {
  return keys$2[key] || (keys$2[key] = uid$1(key));
};

var hiddenKeys$4 = {};

var NATIVE_WEAK_MAP = weakMapBasicDetection;
var global$r = global$z;
var uncurryThis$r = functionUncurryThis;
var isObject$a = isObject$f;
var createNonEnumerableProperty$8 = createNonEnumerableProperty$9;
var hasOwn$d = hasOwnProperty_1;
var shared$1 = sharedStore;
var sharedKey$2 = sharedKey$3;
var hiddenKeys$3 = hiddenKeys$4;

var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var TypeError$5 = global$r.TypeError;
var WeakMap = global$r.WeakMap;
var set$2, get$1, has;

var enforce = function (it) {
  return has(it) ? get$1(it) : set$2(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject$a(it) || (state = get$1(it)).type !== TYPE) {
      throw TypeError$5('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP || shared$1.state) {
  var store = shared$1.state || (shared$1.state = new WeakMap());
  var wmget = uncurryThis$r(store.get);
  var wmhas = uncurryThis$r(store.has);
  var wmset = uncurryThis$r(store.set);
  set$2 = function (it, metadata) {
    if (wmhas(store, it)) throw TypeError$5(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    wmset(store, it, metadata);
    return metadata;
  };
  get$1 = function (it) {
    return wmget(store, it) || {};
  };
  has = function (it) {
    return wmhas(store, it);
  };
} else {
  var STATE = sharedKey$2('state');
  hiddenKeys$3[STATE] = true;
  set$2 = function (it, metadata) {
    if (hasOwn$d(it, STATE)) throw TypeError$5(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty$8(it, STATE, metadata);
    return metadata;
  };
  get$1 = function (it) {
    return hasOwn$d(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return hasOwn$d(it, STATE);
  };
}

var internalState = {
  set: set$2,
  get: get$1,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};

var fails$s = fails$z;
var isCallable$j = isCallable$r;
var hasOwn$c = hasOwnProperty_1;
var DESCRIPTORS$b = descriptors;
var CONFIGURABLE_FUNCTION_NAME$2 = functionName.CONFIGURABLE;
var inspectSource$2 = inspectSource$3;
var InternalStateModule$8 = internalState;

var enforceInternalState$3 = InternalStateModule$8.enforce;
var getInternalState$6 = InternalStateModule$8.get;
// eslint-disable-next-line es-x/no-object-defineproperty -- safe
var defineProperty$9 = Object.defineProperty;

var CONFIGURABLE_LENGTH = DESCRIPTORS$b && !fails$s(function () {
  return defineProperty$9(function () { /* empty */ }, 'length', { value: 8 }).length !== 8;
});

var TEMPLATE = String(String).split('String');

var makeBuiltIn$2 = makeBuiltIn$3.exports = function (value, name, options) {
  if (String(name).slice(0, 7) === 'Symbol(') {
    name = '[' + String(name).replace(/^Symbol\(([^)]*)\)/, '$1') + ']';
  }
  if (options && options.getter) name = 'get ' + name;
  if (options && options.setter) name = 'set ' + name;
  if (!hasOwn$c(value, 'name') || (CONFIGURABLE_FUNCTION_NAME$2 && value.name !== name)) {
    if (DESCRIPTORS$b) defineProperty$9(value, 'name', { value: name, configurable: true });
    else value.name = name;
  }
  if (CONFIGURABLE_LENGTH && options && hasOwn$c(options, 'arity') && value.length !== options.arity) {
    defineProperty$9(value, 'length', { value: options.arity });
  }
  try {
    if (options && hasOwn$c(options, 'constructor') && options.constructor) {
      if (DESCRIPTORS$b) defineProperty$9(value, 'prototype', { writable: false });
    // in V8 ~ Chrome 53, prototypes of some methods, like `Array.prototype.values`, are non-writable
    } else if (value.prototype) value.prototype = undefined;
  } catch (error) { /* empty */ }
  var state = enforceInternalState$3(value);
  if (!hasOwn$c(state, 'source')) {
    state.source = TEMPLATE.join(typeof name == 'string' ? name : '');
  } return value;
};

// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
// eslint-disable-next-line no-extend-native -- required
Function.prototype.toString = makeBuiltIn$2(function toString() {
  return isCallable$j(this) && getInternalState$6(this).source || inspectSource$2(this);
}, 'toString');

var isCallable$i = isCallable$r;
var definePropertyModule$5 = objectDefineProperty;
var makeBuiltIn$1 = makeBuiltIn$3.exports;
var defineGlobalProperty$1 = defineGlobalProperty$3;

var defineBuiltIn$d = function (O, key, value, options) {
  if (!options) options = {};
  var simple = options.enumerable;
  var name = options.name !== undefined ? options.name : key;
  if (isCallable$i(value)) makeBuiltIn$1(value, name, options);
  if (options.global) {
    if (simple) O[key] = value;
    else defineGlobalProperty$1(key, value);
  } else {
    try {
      if (!options.unsafe) delete O[key];
      else if (O[key]) simple = true;
    } catch (error) { /* empty */ }
    if (simple) O[key] = value;
    else definePropertyModule$5.f(O, key, {
      value: value,
      enumerable: false,
      configurable: !options.nonConfigurable,
      writable: !options.nonWritable
    });
  } return O;
};

var objectGetOwnPropertyNames = {};

var ceil = Math.ceil;
var floor$6 = Math.floor;

// `Math.trunc` method
// https://tc39.es/ecma262/#sec-math.trunc
// eslint-disable-next-line es-x/no-math-trunc -- safe
var mathTrunc = Math.trunc || function trunc(x) {
  var n = +x;
  return (n > 0 ? floor$6 : ceil)(n);
};

var trunc = mathTrunc;

// `ToIntegerOrInfinity` abstract operation
// https://tc39.es/ecma262/#sec-tointegerorinfinity
var toIntegerOrInfinity$7 = function (argument) {
  var number = +argument;
  // eslint-disable-next-line no-self-compare -- NaN check
  return number !== number || number === 0 ? 0 : trunc(number);
};

var toIntegerOrInfinity$6 = toIntegerOrInfinity$7;

var max$2 = Math.max;
var min$3 = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
var toAbsoluteIndex$4 = function (index, length) {
  var integer = toIntegerOrInfinity$6(index);
  return integer < 0 ? max$2(integer + length, 0) : min$3(integer, length);
};

var toIntegerOrInfinity$5 = toIntegerOrInfinity$7;

var min$2 = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
var toLength$8 = function (argument) {
  return argument > 0 ? min$2(toIntegerOrInfinity$5(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};

var toLength$7 = toLength$8;

// `LengthOfArrayLike` abstract operation
// https://tc39.es/ecma262/#sec-lengthofarraylike
var lengthOfArrayLike$a = function (obj) {
  return toLength$7(obj.length);
};

var toIndexedObject$4 = toIndexedObject$6;
var toAbsoluteIndex$3 = toAbsoluteIndex$4;
var lengthOfArrayLike$9 = lengthOfArrayLike$a;

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod$4 = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject$4($this);
    var length = lengthOfArrayLike$9(O);
    var index = toAbsoluteIndex$3(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

var arrayIncludes = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod$4(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod$4(false)
};

var uncurryThis$q = functionUncurryThis;
var hasOwn$b = hasOwnProperty_1;
var toIndexedObject$3 = toIndexedObject$6;
var indexOf$1 = arrayIncludes.indexOf;
var hiddenKeys$2 = hiddenKeys$4;

var push$7 = uncurryThis$q([].push);

var objectKeysInternal = function (object, names) {
  var O = toIndexedObject$3(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !hasOwn$b(hiddenKeys$2, key) && hasOwn$b(O, key) && push$7(result, key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (hasOwn$b(O, key = names[i++])) {
    ~indexOf$1(result, key) || push$7(result, key);
  }
  return result;
};

// IE8- don't enum bug keys
var enumBugKeys$3 = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];

var internalObjectKeys$1 = objectKeysInternal;
var enumBugKeys$2 = enumBugKeys$3;

var hiddenKeys$1 = enumBugKeys$2.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es-x/no-object-getownpropertynames -- safe
objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys$1(O, hiddenKeys$1);
};

var objectGetOwnPropertySymbols = {};

// eslint-disable-next-line es-x/no-object-getownpropertysymbols -- safe
objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

var getBuiltIn$6 = getBuiltIn$9;
var uncurryThis$p = functionUncurryThis;
var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
var getOwnPropertySymbolsModule$1 = objectGetOwnPropertySymbols;
var anObject$i = anObject$k;

var concat$2 = uncurryThis$p([].concat);

// all object keys, includes non-enumerable and symbols
var ownKeys$1 = getBuiltIn$6('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject$i(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule$1.f;
  return getOwnPropertySymbols ? concat$2(keys, getOwnPropertySymbols(it)) : keys;
};

var hasOwn$a = hasOwnProperty_1;
var ownKeys = ownKeys$1;
var getOwnPropertyDescriptorModule$1 = objectGetOwnPropertyDescriptor;
var definePropertyModule$4 = objectDefineProperty;

var copyConstructorProperties$2 = function (target, source, exceptions) {
  var keys = ownKeys(source);
  var defineProperty = definePropertyModule$4.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule$1.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!hasOwn$a(target, key) && !(exceptions && hasOwn$a(exceptions, key))) {
      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
    }
  }
};

var fails$r = fails$z;
var isCallable$h = isCallable$r;

var replacement = /#|\.prototype\./;

var isForced$3 = function (feature, detection) {
  var value = data[normalize(feature)];
  return value == POLYFILL ? true
    : value == NATIVE ? false
    : isCallable$h(detection) ? fails$r(detection)
    : !!detection;
};

var normalize = isForced$3.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced$3.data = {};
var NATIVE = isForced$3.NATIVE = 'N';
var POLYFILL = isForced$3.POLYFILL = 'P';

var isForced_1 = isForced$3;

var global$q = global$z;
var getOwnPropertyDescriptor$2 = objectGetOwnPropertyDescriptor.f;
var createNonEnumerableProperty$7 = createNonEnumerableProperty$9;
var defineBuiltIn$c = defineBuiltIn$d;
var defineGlobalProperty = defineGlobalProperty$3;
var copyConstructorProperties$1 = copyConstructorProperties$2;
var isForced$2 = isForced_1;

/*
  options.target         - name of the target object
  options.global         - target is the global object
  options.stat           - export as static methods of target
  options.proto          - export as prototype methods of target
  options.real           - real prototype method for the `pure` version
  options.forced         - export even if the native feature is available
  options.bind           - bind methods to the target, required for the `pure` version
  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
  options.sham           - add a flag to not completely full polyfills
  options.enumerable     - export as enumerable property
  options.dontCallGetSet - prevent calling a getter on target
  options.name           - the .name of the function if it does not match the key
*/
var _export = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
  if (GLOBAL) {
    target = global$q;
  } else if (STATIC) {
    target = global$q[TARGET] || defineGlobalProperty(TARGET, {});
  } else {
    target = (global$q[TARGET] || {}).prototype;
  }
  if (target) for (key in source) {
    sourceProperty = source[key];
    if (options.dontCallGetSet) {
      descriptor = getOwnPropertyDescriptor$2(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];
    FORCED = isForced$2(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contained in target
    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty == typeof targetProperty) continue;
      copyConstructorProperties$1(sourceProperty, targetProperty);
    }
    // add a flag to not completely full polyfills
    if (options.sham || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty$7(sourceProperty, 'sham', true);
    }
    defineBuiltIn$c(target, key, sourceProperty, options);
  }
};

var internalObjectKeys = objectKeysInternal;
var enumBugKeys$1 = enumBugKeys$3;

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es-x/no-object-keys -- safe
var objectKeys$2 = Object.keys || function keys(O) {
  return internalObjectKeys(O, enumBugKeys$1);
};

var DESCRIPTORS$a = descriptors;
var uncurryThis$o = functionUncurryThis;
var call$m = functionCall;
var fails$q = fails$z;
var objectKeys$1 = objectKeys$2;
var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
var propertyIsEnumerableModule = objectPropertyIsEnumerable;
var toObject$8 = toObject$a;
var IndexedObject$2 = indexedObject;

// eslint-disable-next-line es-x/no-object-assign -- safe
var $assign = Object.assign;
// eslint-disable-next-line es-x/no-object-defineproperty -- required for testing
var defineProperty$8 = Object.defineProperty;
var concat$1 = uncurryThis$o([].concat);

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
var objectAssign = !$assign || fails$q(function () {
  // should have correct order of operations (Edge bug)
  if (DESCRIPTORS$a && $assign({ b: 1 }, $assign(defineProperty$8({}, 'a', {
    enumerable: true,
    get: function () {
      defineProperty$8(this, 'b', {
        value: 3,
        enumerable: false
      });
    }
  }), { b: 2 })).b !== 1) return true;
  // should work with symbols and should have deterministic property order (V8 bug)
  var A = {};
  var B = {};
  // eslint-disable-next-line es-x/no-symbol -- safe
  var symbol = Symbol();
  var alphabet = 'abcdefghijklmnopqrst';
  A[symbol] = 7;
  alphabet.split('').forEach(function (chr) { B[chr] = chr; });
  return $assign({}, A)[symbol] != 7 || objectKeys$1($assign({}, B)).join('') != alphabet;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars -- required for `.length`
  var T = toObject$8(target);
  var argumentsLength = arguments.length;
  var index = 1;
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  var propertyIsEnumerable = propertyIsEnumerableModule.f;
  while (argumentsLength > index) {
    var S = IndexedObject$2(arguments[index++]);
    var keys = getOwnPropertySymbols ? concat$1(objectKeys$1(S), getOwnPropertySymbols(S)) : objectKeys$1(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS$a || call$m(propertyIsEnumerable, S, key)) T[key] = S[key];
    }
  } return T;
} : $assign;

var $$l = _export;
var assign$1 = objectAssign;

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
// eslint-disable-next-line es-x/no-object-assign -- required for testing
$$l({ target: 'Object', stat: true, arity: 2, forced: Object.assign !== assign$1 }, {
  assign: assign$1
});

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

/**
 * Segmented accordion content component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */

const SegmentedAccordionContent = props => {
  const {
    className,
    children,
    emphasized,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["className", "children", "emphasized", "data-componentid", "data-testid"]);

  const classes = classNames("segmented-accordion-content", "lighter-bg", {
    emphasized
  }, className);
  return /*#__PURE__*/React__default.createElement(Accordion.Content, Object.assign({
    as: Segment,
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), children);
};
/**
 * Default proptypes for the segmented accordion content component.
 */

SegmentedAccordionContent.defaultProps = {
  attached: "bottom",
  "data-componentid": "segmented-accordion-content",
  "data-testid": "segmented-accordion-content",
  secondary: true
};

var objectDefineProperties = {};

var DESCRIPTORS$9 = descriptors;
var V8_PROTOTYPE_DEFINE_BUG = v8PrototypeDefineBug;
var definePropertyModule$3 = objectDefineProperty;
var anObject$h = anObject$k;
var toIndexedObject$2 = toIndexedObject$6;
var objectKeys = objectKeys$2;

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es-x/no-object-defineproperties -- safe
objectDefineProperties.f = DESCRIPTORS$9 && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject$h(O);
  var props = toIndexedObject$2(Properties);
  var keys = objectKeys(Properties);
  var length = keys.length;
  var index = 0;
  var key;
  while (length > index) definePropertyModule$3.f(O, key = keys[index++], props[key]);
  return O;
};

var getBuiltIn$5 = getBuiltIn$9;

var html$2 = getBuiltIn$5('document', 'documentElement');

/* global ActiveXObject -- old IE, WSH */

var anObject$g = anObject$k;
var definePropertiesModule = objectDefineProperties;
var enumBugKeys = enumBugKeys$3;
var hiddenKeys = hiddenKeys$4;
var html$1 = html$2;
var documentCreateElement$1 = documentCreateElement$2;
var sharedKey$1 = sharedKey$3;

var GT = '>';
var LT = '<';
var PROTOTYPE$1 = 'prototype';
var SCRIPT = 'script';
var IE_PROTO$1 = sharedKey$1('IE_PROTO');

var EmptyConstructor = function () { /* empty */ };

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};

// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  activeXDocument = null; // avoid memory leak
  return temp;
};

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement$1('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html$1.appendChild(iframe);
  // https://github.com/zloirock/core-js/issues/475
  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
};

// Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug
var activeXDocument;
var NullProtoObject = function () {
  try {
    activeXDocument = new ActiveXObject('htmlfile');
  } catch (error) { /* ignore */ }
  NullProtoObject = typeof document != 'undefined'
    ? document.domain && activeXDocument
      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
      : NullProtoObjectViaIFrame()
    : NullProtoObjectViaActiveX(activeXDocument); // WSH
  var length = enumBugKeys.length;
  while (length--) delete NullProtoObject[PROTOTYPE$1][enumBugKeys[length]];
  return NullProtoObject();
};

hiddenKeys[IE_PROTO$1] = true;

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
// eslint-disable-next-line es-x/no-object-create -- safe
var objectCreate = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    EmptyConstructor[PROTOTYPE$1] = anObject$g(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE$1] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO$1] = O;
  } else result = NullProtoObject();
  return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
};

var wellKnownSymbol$l = wellKnownSymbol$n;
var create$4 = objectCreate;
var defineProperty$7 = objectDefineProperty.f;

var UNSCOPABLES = wellKnownSymbol$l('unscopables');
var ArrayPrototype$1 = Array.prototype;

// Array.prototype[@@unscopables]
// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
if (ArrayPrototype$1[UNSCOPABLES] == undefined) {
  defineProperty$7(ArrayPrototype$1, UNSCOPABLES, {
    configurable: true,
    value: create$4(null)
  });
}

// add a key to Array.prototype[@@unscopables]
var addToUnscopables$2 = function (key) {
  ArrayPrototype$1[UNSCOPABLES][key] = true;
};

var iterators = {};

var fails$p = fails$z;

var correctPrototypeGetter = !fails$p(function () {
  function F() { /* empty */ }
  F.prototype.constructor = null;
  // eslint-disable-next-line es-x/no-object-getprototypeof -- required for testing
  return Object.getPrototypeOf(new F()) !== F.prototype;
});

var hasOwn$9 = hasOwnProperty_1;
var isCallable$g = isCallable$r;
var toObject$7 = toObject$a;
var sharedKey = sharedKey$3;
var CORRECT_PROTOTYPE_GETTER = correctPrototypeGetter;

var IE_PROTO = sharedKey('IE_PROTO');
var $Object$1 = Object;
var ObjectPrototype$2 = $Object$1.prototype;

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es-x/no-object-getprototypeof -- safe
var objectGetPrototypeOf = CORRECT_PROTOTYPE_GETTER ? $Object$1.getPrototypeOf : function (O) {
  var object = toObject$7(O);
  if (hasOwn$9(object, IE_PROTO)) return object[IE_PROTO];
  var constructor = object.constructor;
  if (isCallable$g(constructor) && object instanceof constructor) {
    return constructor.prototype;
  } return object instanceof $Object$1 ? ObjectPrototype$2 : null;
};

var fails$o = fails$z;
var isCallable$f = isCallable$r;
var isObject$9 = isObject$f;
var getPrototypeOf$3 = objectGetPrototypeOf;
var defineBuiltIn$b = defineBuiltIn$d;
var wellKnownSymbol$k = wellKnownSymbol$n;

var ITERATOR$8 = wellKnownSymbol$k('iterator');
var BUGGY_SAFARI_ITERATORS$1 = false;

// `%IteratorPrototype%` object
// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
var IteratorPrototype$2, PrototypeOfArrayIteratorPrototype, arrayIterator;

/* eslint-disable es-x/no-array-prototype-keys -- safe */
if ([].keys) {
  arrayIterator = [].keys();
  // Safari 8 has buggy iterators w/o `next`
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS$1 = true;
  else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf$3(getPrototypeOf$3(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype$2 = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = !isObject$9(IteratorPrototype$2) || fails$o(function () {
  var test = {};
  // FF44- legacy iterators case
  return IteratorPrototype$2[ITERATOR$8].call(test) !== test;
});

if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype$2 = {};

// `%IteratorPrototype%[@@iterator]()` method
// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
if (!isCallable$f(IteratorPrototype$2[ITERATOR$8])) {
  defineBuiltIn$b(IteratorPrototype$2, ITERATOR$8, function () {
    return this;
  });
}

var iteratorsCore = {
  IteratorPrototype: IteratorPrototype$2,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS$1
};

var defineProperty$6 = objectDefineProperty.f;
var hasOwn$8 = hasOwnProperty_1;
var wellKnownSymbol$j = wellKnownSymbol$n;

var TO_STRING_TAG$4 = wellKnownSymbol$j('toStringTag');

var setToStringTag$6 = function (target, TAG, STATIC) {
  if (target && !STATIC) target = target.prototype;
  if (target && !hasOwn$8(target, TO_STRING_TAG$4)) {
    defineProperty$6(target, TO_STRING_TAG$4, { configurable: true, value: TAG });
  }
};

var IteratorPrototype$1 = iteratorsCore.IteratorPrototype;
var create$3 = objectCreate;
var createPropertyDescriptor$3 = createPropertyDescriptor$6;
var setToStringTag$5 = setToStringTag$6;
var Iterators$4 = iterators;

var returnThis$1 = function () { return this; };

var iteratorCreateConstructor = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
  var TO_STRING_TAG = NAME + ' Iterator';
  IteratorConstructor.prototype = create$3(IteratorPrototype$1, { next: createPropertyDescriptor$3(+!ENUMERABLE_NEXT, next) });
  setToStringTag$5(IteratorConstructor, TO_STRING_TAG, false);
  Iterators$4[TO_STRING_TAG] = returnThis$1;
  return IteratorConstructor;
};

var isCallable$e = isCallable$r;

var $String$1 = String;
var $TypeError$b = TypeError;

var aPossiblePrototype$1 = function (argument) {
  if (typeof argument == 'object' || isCallable$e(argument)) return argument;
  throw $TypeError$b("Can't set " + $String$1(argument) + ' as a prototype');
};

/* eslint-disable no-proto -- safe */

var uncurryThis$n = functionUncurryThis;
var anObject$f = anObject$k;
var aPossiblePrototype = aPossiblePrototype$1;

// `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
// Works with __proto__ only. Old v8 can't work with null proto objects.
// eslint-disable-next-line es-x/no-object-setprototypeof -- safe
var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;
  try {
    // eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
    setter = uncurryThis$n(Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set);
    setter(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) { /* empty */ }
  return function setPrototypeOf(O, proto) {
    anObject$f(O);
    aPossiblePrototype(proto);
    if (CORRECT_SETTER) setter(O, proto);
    else O.__proto__ = proto;
    return O;
  };
}() : undefined);

var $$k = _export;
var call$l = functionCall;
var FunctionName$1 = functionName;
var isCallable$d = isCallable$r;
var createIteratorConstructor$1 = iteratorCreateConstructor;
var getPrototypeOf$2 = objectGetPrototypeOf;
var setPrototypeOf$5 = objectSetPrototypeOf;
var setToStringTag$4 = setToStringTag$6;
var createNonEnumerableProperty$6 = createNonEnumerableProperty$9;
var defineBuiltIn$a = defineBuiltIn$d;
var wellKnownSymbol$i = wellKnownSymbol$n;
var Iterators$3 = iterators;
var IteratorsCore = iteratorsCore;

var PROPER_FUNCTION_NAME$3 = FunctionName$1.PROPER;
var CONFIGURABLE_FUNCTION_NAME$1 = FunctionName$1.CONFIGURABLE;
var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR$7 = wellKnownSymbol$i('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var returnThis = function () { return this; };

var iteratorDefine = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  createIteratorConstructor$1(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
    switch (KIND) {
      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
    } return function () { return new IteratorConstructor(this); };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[ITERATOR$7]
    || IterablePrototype['@@iterator']
    || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY;

  // fix native
  if (anyNativeIterator) {
    CurrentIteratorPrototype = getPrototypeOf$2(anyNativeIterator.call(new Iterable()));
    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
      if (getPrototypeOf$2(CurrentIteratorPrototype) !== IteratorPrototype) {
        if (setPrototypeOf$5) {
          setPrototypeOf$5(CurrentIteratorPrototype, IteratorPrototype);
        } else if (!isCallable$d(CurrentIteratorPrototype[ITERATOR$7])) {
          defineBuiltIn$a(CurrentIteratorPrototype, ITERATOR$7, returnThis);
        }
      }
      // Set @@toStringTag to native iterators
      setToStringTag$4(CurrentIteratorPrototype, TO_STRING_TAG, true);
    }
  }

  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
  if (PROPER_FUNCTION_NAME$3 && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    if (CONFIGURABLE_FUNCTION_NAME$1) {
      createNonEnumerableProperty$6(IterablePrototype, 'name', VALUES);
    } else {
      INCORRECT_VALUES_NAME = true;
      defaultIterator = function values() { return call$l(nativeIterator, this); };
    }
  }

  // export additional methods
  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        defineBuiltIn$a(IterablePrototype, KEY, methods[KEY]);
      }
    } else $$k({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
  }

  // define iterator
  if (IterablePrototype[ITERATOR$7] !== defaultIterator) {
    defineBuiltIn$a(IterablePrototype, ITERATOR$7, defaultIterator, { name: DEFAULT });
  }
  Iterators$3[NAME] = defaultIterator;

  return methods;
};

var toIndexedObject$1 = toIndexedObject$6;
var addToUnscopables$1 = addToUnscopables$2;
var Iterators$2 = iterators;
var InternalStateModule$7 = internalState;
var defineProperty$5 = objectDefineProperty.f;
var defineIterator$1 = iteratorDefine;
var DESCRIPTORS$8 = descriptors;

var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState$6 = InternalStateModule$7.set;
var getInternalState$5 = InternalStateModule$7.getterFor(ARRAY_ITERATOR);

// `Array.prototype.entries` method
// https://tc39.es/ecma262/#sec-array.prototype.entries
// `Array.prototype.keys` method
// https://tc39.es/ecma262/#sec-array.prototype.keys
// `Array.prototype.values` method
// https://tc39.es/ecma262/#sec-array.prototype.values
// `Array.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
// `CreateArrayIterator` internal method
// https://tc39.es/ecma262/#sec-createarrayiterator
var es_array_iterator = defineIterator$1(Array, 'Array', function (iterated, kind) {
  setInternalState$6(this, {
    type: ARRAY_ITERATOR,
    target: toIndexedObject$1(iterated), // target
    index: 0,                          // next index
    kind: kind                         // kind
  });
// `%ArrayIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
}, function () {
  var state = getInternalState$5(this);
  var target = state.target;
  var kind = state.kind;
  var index = state.index++;
  if (!target || index >= target.length) {
    state.target = undefined;
    return { value: undefined, done: true };
  }
  if (kind == 'keys') return { value: index, done: false };
  if (kind == 'values') return { value: target[index], done: false };
  return { value: [index, target[index]], done: false };
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values%
// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
// https://tc39.es/ecma262/#sec-createmappedargumentsobject
var values = Iterators$2.Arguments = Iterators$2.Array;

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables$1('keys');
addToUnscopables$1('values');
addToUnscopables$1('entries');

// V8 ~ Chrome 45- bug
if (DESCRIPTORS$8 && values.name !== 'values') try {
  defineProperty$5(values, 'name', { value: 'values' });
} catch (error) { /* empty */ }

// iterable DOM collections
// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
var domIterables = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};

// in old WebKit versions, `element.classList` is not an instance of global `DOMTokenList`
var documentCreateElement = documentCreateElement$2;

var classList = documentCreateElement('span').classList;
var DOMTokenListPrototype$1 = classList && classList.constructor && classList.constructor.prototype;

var domTokenListPrototype = DOMTokenListPrototype$1 === Object.prototype ? undefined : DOMTokenListPrototype$1;

var global$p = global$z;
var DOMIterables = domIterables;
var DOMTokenListPrototype = domTokenListPrototype;
var ArrayIteratorMethods = es_array_iterator;
var createNonEnumerableProperty$5 = createNonEnumerableProperty$9;
var wellKnownSymbol$h = wellKnownSymbol$n;

var ITERATOR$6 = wellKnownSymbol$h('iterator');
var TO_STRING_TAG$3 = wellKnownSymbol$h('toStringTag');
var ArrayValues = ArrayIteratorMethods.values;

var handlePrototype = function (CollectionPrototype, COLLECTION_NAME) {
  if (CollectionPrototype) {
    // some Chrome versions have non-configurable methods on DOMTokenList
    if (CollectionPrototype[ITERATOR$6] !== ArrayValues) try {
      createNonEnumerableProperty$5(CollectionPrototype, ITERATOR$6, ArrayValues);
    } catch (error) {
      CollectionPrototype[ITERATOR$6] = ArrayValues;
    }
    if (!CollectionPrototype[TO_STRING_TAG$3]) {
      createNonEnumerableProperty$5(CollectionPrototype, TO_STRING_TAG$3, COLLECTION_NAME);
    }
    if (DOMIterables[COLLECTION_NAME]) for (var METHOD_NAME in ArrayIteratorMethods) {
      // some Chrome versions have non-configurable methods on DOMTokenList
      if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME]) try {
        createNonEnumerableProperty$5(CollectionPrototype, METHOD_NAME, ArrayIteratorMethods[METHOD_NAME]);
      } catch (error) {
        CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
      }
    }
  }
};

for (var COLLECTION_NAME in DOMIterables) {
  handlePrototype(global$p[COLLECTION_NAME] && global$p[COLLECTION_NAME].prototype, COLLECTION_NAME);
}

handlePrototype(DOMTokenListPrototype, 'DOMTokenList');

var classof$b = classofRaw$1;
var global$o = global$z;

var engineIsNode = classof$b(global$o.process) == 'process';

var getBuiltIn$4 = getBuiltIn$9;
var definePropertyModule$2 = objectDefineProperty;
var wellKnownSymbol$g = wellKnownSymbol$n;
var DESCRIPTORS$7 = descriptors;

var SPECIES$4 = wellKnownSymbol$g('species');

var setSpecies$4 = function (CONSTRUCTOR_NAME) {
  var Constructor = getBuiltIn$4(CONSTRUCTOR_NAME);
  var defineProperty = definePropertyModule$2.f;

  if (DESCRIPTORS$7 && Constructor && !Constructor[SPECIES$4]) {
    defineProperty(Constructor, SPECIES$4, {
      configurable: true,
      get: function () { return this; }
    });
  }
};

var isPrototypeOf$6 = objectIsPrototypeOf;

var $TypeError$a = TypeError;

var anInstance$5 = function (it, Prototype) {
  if (isPrototypeOf$6(Prototype, it)) return it;
  throw $TypeError$a('Incorrect invocation');
};

var wellKnownSymbol$f = wellKnownSymbol$n;

var TO_STRING_TAG$2 = wellKnownSymbol$f('toStringTag');
var test$1 = {};

test$1[TO_STRING_TAG$2] = 'z';

var toStringTagSupport = String(test$1) === '[object z]';

var TO_STRING_TAG_SUPPORT = toStringTagSupport;
var isCallable$c = isCallable$r;
var classofRaw = classofRaw$1;
var wellKnownSymbol$e = wellKnownSymbol$n;

var TO_STRING_TAG$1 = wellKnownSymbol$e('toStringTag');
var $Object = Object;

// ES3 wrong here
var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) { /* empty */ }
};

// getting tag from ES6+ `Object.prototype.toString`
var classof$a = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (tag = tryGet(O = $Object(it), TO_STRING_TAG$1)) == 'string' ? tag
    // builtinTag case
    : CORRECT_ARGUMENTS ? classofRaw(O)
    // ES3 arguments fallback
    : (result = classofRaw(O)) == 'Object' && isCallable$c(O.callee) ? 'Arguments' : result;
};

var uncurryThis$m = functionUncurryThis;
var fails$n = fails$z;
var isCallable$b = isCallable$r;
var classof$9 = classof$a;
var getBuiltIn$3 = getBuiltIn$9;
var inspectSource$1 = inspectSource$3;

var noop = function () { /* empty */ };
var empty = [];
var construct = getBuiltIn$3('Reflect', 'construct');
var constructorRegExp = /^\s*(?:class|function)\b/;
var exec$6 = uncurryThis$m(constructorRegExp.exec);
var INCORRECT_TO_STRING = !constructorRegExp.exec(noop);

var isConstructorModern = function isConstructor(argument) {
  if (!isCallable$b(argument)) return false;
  try {
    construct(noop, empty, argument);
    return true;
  } catch (error) {
    return false;
  }
};

var isConstructorLegacy = function isConstructor(argument) {
  if (!isCallable$b(argument)) return false;
  switch (classof$9(argument)) {
    case 'AsyncFunction':
    case 'GeneratorFunction':
    case 'AsyncGeneratorFunction': return false;
  }
  try {
    // we can't check .prototype since constructors produced by .bind haven't it
    // `Function#toString` throws on some built-it function in some legacy engines
    // (for example, `DOMQuad` and similar in FF41-)
    return INCORRECT_TO_STRING || !!exec$6(constructorRegExp, inspectSource$1(argument));
  } catch (error) {
    return true;
  }
};

isConstructorLegacy.sham = true;

// `IsConstructor` abstract operation
// https://tc39.es/ecma262/#sec-isconstructor
var isConstructor$3 = !construct || fails$n(function () {
  var called;
  return isConstructorModern(isConstructorModern.call)
    || !isConstructorModern(Object)
    || !isConstructorModern(function () { called = true; })
    || called;
}) ? isConstructorLegacy : isConstructorModern;

var isConstructor$2 = isConstructor$3;
var tryToString$4 = tryToString$6;

var $TypeError$9 = TypeError;

// `Assert: IsConstructor(argument) is true`
var aConstructor$2 = function (argument) {
  if (isConstructor$2(argument)) return argument;
  throw $TypeError$9(tryToString$4(argument) + ' is not a constructor');
};

var anObject$e = anObject$k;
var aConstructor$1 = aConstructor$2;
var isNullOrUndefined$5 = isNullOrUndefined$8;
var wellKnownSymbol$d = wellKnownSymbol$n;

var SPECIES$3 = wellKnownSymbol$d('species');

// `SpeciesConstructor` abstract operation
// https://tc39.es/ecma262/#sec-speciesconstructor
var speciesConstructor$4 = function (O, defaultConstructor) {
  var C = anObject$e(O).constructor;
  var S;
  return C === undefined || isNullOrUndefined$5(S = anObject$e(C)[SPECIES$3]) ? defaultConstructor : aConstructor$1(S);
};

var NATIVE_BIND$1 = functionBindNative;

var FunctionPrototype = Function.prototype;
var apply$4 = FunctionPrototype.apply;
var call$k = FunctionPrototype.call;

// eslint-disable-next-line es-x/no-reflect -- safe
var functionApply = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND$1 ? call$k.bind(apply$4) : function () {
  return call$k.apply(apply$4, arguments);
});

var uncurryThis$l = functionUncurryThis;
var aCallable$8 = aCallable$a;
var NATIVE_BIND = functionBindNative;

var bind$9 = uncurryThis$l(uncurryThis$l.bind);

// optional / simple context binding
var functionBindContext = function (fn, that) {
  aCallable$8(fn);
  return that === undefined ? fn : NATIVE_BIND ? bind$9(fn, that) : function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};

var uncurryThis$k = functionUncurryThis;

var arraySlice$6 = uncurryThis$k([].slice);

var $TypeError$8 = TypeError;

var validateArgumentsLength$3 = function (passed, required) {
  if (passed < required) throw $TypeError$8('Not enough arguments');
  return passed;
};

var userAgent$4 = engineUserAgent;

var engineIsIos = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent$4);

var global$n = global$z;
var apply$3 = functionApply;
var bind$8 = functionBindContext;
var isCallable$a = isCallable$r;
var hasOwn$7 = hasOwnProperty_1;
var fails$m = fails$z;
var html = html$2;
var arraySlice$5 = arraySlice$6;
var createElement = documentCreateElement$2;
var validateArgumentsLength$2 = validateArgumentsLength$3;
var IS_IOS$1 = engineIsIos;
var IS_NODE$4 = engineIsNode;

var set$1 = global$n.setImmediate;
var clear = global$n.clearImmediate;
var process$2 = global$n.process;
var Dispatch = global$n.Dispatch;
var Function$1 = global$n.Function;
var MessageChannel = global$n.MessageChannel;
var String$1 = global$n.String;
var counter = 0;
var queue$1 = {};
var ONREADYSTATECHANGE = 'onreadystatechange';
var location$1, defer, channel, port;

try {
  // Deno throws a ReferenceError on `location` access without `--location` flag
  location$1 = global$n.location;
} catch (error) { /* empty */ }

var run = function (id) {
  if (hasOwn$7(queue$1, id)) {
    var fn = queue$1[id];
    delete queue$1[id];
    fn();
  }
};

var runner = function (id) {
  return function () {
    run(id);
  };
};

var listener = function (event) {
  run(event.data);
};

var post = function (id) {
  // old engines have not location.origin
  global$n.postMessage(String$1(id), location$1.protocol + '//' + location$1.host);
};

// Node.js 0.9+ & IE10+ has setImmediate, otherwise:
if (!set$1 || !clear) {
  set$1 = function setImmediate(handler) {
    validateArgumentsLength$2(arguments.length, 1);
    var fn = isCallable$a(handler) ? handler : Function$1(handler);
    var args = arraySlice$5(arguments, 1);
    queue$1[++counter] = function () {
      apply$3(fn, undefined, args);
    };
    defer(counter);
    return counter;
  };
  clear = function clearImmediate(id) {
    delete queue$1[id];
  };
  // Node.js 0.8-
  if (IS_NODE$4) {
    defer = function (id) {
      process$2.nextTick(runner(id));
    };
  // Sphere (JS game engine) Dispatch API
  } else if (Dispatch && Dispatch.now) {
    defer = function (id) {
      Dispatch.now(runner(id));
    };
  // Browsers with MessageChannel, includes WebWorkers
  // except iOS - https://github.com/zloirock/core-js/issues/624
  } else if (MessageChannel && !IS_IOS$1) {
    channel = new MessageChannel();
    port = channel.port2;
    channel.port1.onmessage = listener;
    defer = bind$8(port.postMessage, port);
  // Browsers with postMessage, skip WebWorkers
  // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
  } else if (
    global$n.addEventListener &&
    isCallable$a(global$n.postMessage) &&
    !global$n.importScripts &&
    location$1 && location$1.protocol !== 'file:' &&
    !fails$m(post)
  ) {
    defer = post;
    global$n.addEventListener('message', listener, false);
  // IE8-
  } else if (ONREADYSTATECHANGE in createElement('script')) {
    defer = function (id) {
      html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
        html.removeChild(this);
        run(id);
      };
    };
  // Rest old browsers
  } else {
    defer = function (id) {
      setTimeout(runner(id), 0);
    };
  }
}

var task$1 = {
  set: set$1,
  clear: clear
};

var userAgent$3 = engineUserAgent;
var global$m = global$z;

var engineIsIosPebble = /ipad|iphone|ipod/i.test(userAgent$3) && global$m.Pebble !== undefined;

var userAgent$2 = engineUserAgent;

var engineIsWebosWebkit = /web0s(?!.*chrome)/i.test(userAgent$2);

var global$l = global$z;
var bind$7 = functionBindContext;
var getOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;
var macrotask = task$1.set;
var IS_IOS = engineIsIos;
var IS_IOS_PEBBLE = engineIsIosPebble;
var IS_WEBOS_WEBKIT = engineIsWebosWebkit;
var IS_NODE$3 = engineIsNode;

var MutationObserver = global$l.MutationObserver || global$l.WebKitMutationObserver;
var document$2 = global$l.document;
var process$1 = global$l.process;
var Promise$1 = global$l.Promise;
// Node.js 11 shows ExperimentalWarning on getting `queueMicrotask`
var queueMicrotaskDescriptor = getOwnPropertyDescriptor$1(global$l, 'queueMicrotask');
var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;

var flush, head, last, notify$1, toggle, node, promise, then;

// modern engines have queueMicrotask method
if (!queueMicrotask) {
  flush = function () {
    var parent, fn;
    if (IS_NODE$3 && (parent = process$1.domain)) parent.exit();
    while (head) {
      fn = head.fn;
      head = head.next;
      try {
        fn();
      } catch (error) {
        if (head) notify$1();
        else last = undefined;
        throw error;
      }
    } last = undefined;
    if (parent) parent.enter();
  };

  // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339
  // also except WebOS Webkit https://github.com/zloirock/core-js/issues/898
  if (!IS_IOS && !IS_NODE$3 && !IS_WEBOS_WEBKIT && MutationObserver && document$2) {
    toggle = true;
    node = document$2.createTextNode('');
    new MutationObserver(flush).observe(node, { characterData: true });
    notify$1 = function () {
      node.data = toggle = !toggle;
    };
  // environments with maybe non-completely correct, but existent Promise
  } else if (!IS_IOS_PEBBLE && Promise$1 && Promise$1.resolve) {
    // Promise.resolve without an argument throws an error in LG WebOS 2
    promise = Promise$1.resolve(undefined);
    // workaround of WebKit ~ iOS Safari 10.1 bug
    promise.constructor = Promise$1;
    then = bind$7(promise.then, promise);
    notify$1 = function () {
      then(flush);
    };
  // Node.js without promises
  } else if (IS_NODE$3) {
    notify$1 = function () {
      process$1.nextTick(flush);
    };
  // for other environments - macrotask based on:
  // - setImmediate
  // - MessageChannel
  // - window.postMessage
  // - onreadystatechange
  // - setTimeout
  } else {
    // strange IE + webpack dev server bug - use .bind(global)
    macrotask = bind$7(macrotask, global$l);
    notify$1 = function () {
      macrotask(flush);
    };
  }
}

var microtask$1 = queueMicrotask || function (fn) {
  var task = { fn: fn, next: undefined };
  if (last) last.next = task;
  if (!head) {
    head = task;
    notify$1();
  } last = task;
};

var global$k = global$z;

var hostReportErrors$1 = function (a, b) {
  var console = global$k.console;
  if (console && console.error) {
    arguments.length == 1 ? console.error(a) : console.error(a, b);
  }
};

var perform$3 = function (exec) {
  try {
    return { error: false, value: exec() };
  } catch (error) {
    return { error: true, value: error };
  }
};

var Queue$1 = function () {
  this.head = null;
  this.tail = null;
};

Queue$1.prototype = {
  add: function (item) {
    var entry = { item: item, next: null };
    if (this.head) this.tail.next = entry;
    else this.head = entry;
    this.tail = entry;
  },
  get: function () {
    var entry = this.head;
    if (entry) {
      this.head = entry.next;
      if (this.tail === entry) this.tail = null;
      return entry.item;
    }
  }
};

var queue = Queue$1;

var global$j = global$z;

var promiseNativeConstructor = global$j.Promise;

/* global Deno -- Deno case */

var engineIsDeno = typeof Deno == 'object' && Deno && typeof Deno.version == 'object';

var IS_DENO$1 = engineIsDeno;
var IS_NODE$2 = engineIsNode;

var engineIsBrowser = !IS_DENO$1 && !IS_NODE$2
  && typeof window == 'object'
  && typeof document == 'object';

var global$i = global$z;
var NativePromiseConstructor$4 = promiseNativeConstructor;
var isCallable$9 = isCallable$r;
var isForced$1 = isForced_1;
var inspectSource = inspectSource$3;
var wellKnownSymbol$c = wellKnownSymbol$n;
var IS_BROWSER = engineIsBrowser;
var IS_DENO = engineIsDeno;
var V8_VERSION = engineV8Version;

NativePromiseConstructor$4 && NativePromiseConstructor$4.prototype;
var SPECIES$2 = wellKnownSymbol$c('species');
var SUBCLASSING = false;
var NATIVE_PROMISE_REJECTION_EVENT$1 = isCallable$9(global$i.PromiseRejectionEvent);

var FORCED_PROMISE_CONSTRUCTOR$5 = isForced$1('Promise', function () {
  var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(NativePromiseConstructor$4);
  var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(NativePromiseConstructor$4);
  // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
  // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
  // We can't detect it synchronously, so just check versions
  if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66) return true;
  // We can't use @@species feature detection in V8 since it causes
  // deoptimization and performance degradation
  // https://github.com/zloirock/core-js/issues/679
  if (!V8_VERSION || V8_VERSION < 51 || !/native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) {
    // Detect correctness of subclassing with @@species support
    var promise = new NativePromiseConstructor$4(function (resolve) { resolve(1); });
    var FakePromise = function (exec) {
      exec(function () { /* empty */ }, function () { /* empty */ });
    };
    var constructor = promise.constructor = {};
    constructor[SPECIES$2] = FakePromise;
    SUBCLASSING = promise.then(function () { /* empty */ }) instanceof FakePromise;
    if (!SUBCLASSING) return true;
  // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test
  } return !GLOBAL_CORE_JS_PROMISE && (IS_BROWSER || IS_DENO) && !NATIVE_PROMISE_REJECTION_EVENT$1;
});

var promiseConstructorDetection = {
  CONSTRUCTOR: FORCED_PROMISE_CONSTRUCTOR$5,
  REJECTION_EVENT: NATIVE_PROMISE_REJECTION_EVENT$1,
  SUBCLASSING: SUBCLASSING
};

var newPromiseCapability$2 = {};

var aCallable$7 = aCallable$a;

var $TypeError$7 = TypeError;

var PromiseCapability = function (C) {
  var resolve, reject;
  this.promise = new C(function ($$resolve, $$reject) {
    if (resolve !== undefined || reject !== undefined) throw $TypeError$7('Bad Promise constructor');
    resolve = $$resolve;
    reject = $$reject;
  });
  this.resolve = aCallable$7(resolve);
  this.reject = aCallable$7(reject);
};

// `NewPromiseCapability` abstract operation
// https://tc39.es/ecma262/#sec-newpromisecapability
newPromiseCapability$2.f = function (C) {
  return new PromiseCapability(C);
};

var $$j = _export;
var IS_NODE$1 = engineIsNode;
var global$h = global$z;
var call$j = functionCall;
var defineBuiltIn$9 = defineBuiltIn$d;
var setPrototypeOf$4 = objectSetPrototypeOf;
var setToStringTag$3 = setToStringTag$6;
var setSpecies$3 = setSpecies$4;
var aCallable$6 = aCallable$a;
var isCallable$8 = isCallable$r;
var isObject$8 = isObject$f;
var anInstance$4 = anInstance$5;
var speciesConstructor$3 = speciesConstructor$4;
var task = task$1.set;
var microtask = microtask$1;
var hostReportErrors = hostReportErrors$1;
var perform$2 = perform$3;
var Queue = queue;
var InternalStateModule$6 = internalState;
var NativePromiseConstructor$3 = promiseNativeConstructor;
var PromiseConstructorDetection = promiseConstructorDetection;
var newPromiseCapabilityModule$3 = newPromiseCapability$2;

var PROMISE = 'Promise';
var FORCED_PROMISE_CONSTRUCTOR$4 = PromiseConstructorDetection.CONSTRUCTOR;
var NATIVE_PROMISE_REJECTION_EVENT = PromiseConstructorDetection.REJECTION_EVENT;
var NATIVE_PROMISE_SUBCLASSING = PromiseConstructorDetection.SUBCLASSING;
var getInternalPromiseState = InternalStateModule$6.getterFor(PROMISE);
var setInternalState$5 = InternalStateModule$6.set;
var NativePromisePrototype$2 = NativePromiseConstructor$3 && NativePromiseConstructor$3.prototype;
var PromiseConstructor = NativePromiseConstructor$3;
var PromisePrototype = NativePromisePrototype$2;
var TypeError$4 = global$h.TypeError;
var document$1 = global$h.document;
var process = global$h.process;
var newPromiseCapability$1 = newPromiseCapabilityModule$3.f;
var newGenericPromiseCapability = newPromiseCapability$1;

var DISPATCH_EVENT = !!(document$1 && document$1.createEvent && global$h.dispatchEvent);
var UNHANDLED_REJECTION = 'unhandledrejection';
var REJECTION_HANDLED = 'rejectionhandled';
var PENDING = 0;
var FULFILLED = 1;
var REJECTED = 2;
var HANDLED = 1;
var UNHANDLED = 2;

var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;

// helpers
var isThenable = function (it) {
  var then;
  return isObject$8(it) && isCallable$8(then = it.then) ? then : false;
};

var callReaction = function (reaction, state) {
  var value = state.value;
  var ok = state.state == FULFILLED;
  var handler = ok ? reaction.ok : reaction.fail;
  var resolve = reaction.resolve;
  var reject = reaction.reject;
  var domain = reaction.domain;
  var result, then, exited;
  try {
    if (handler) {
      if (!ok) {
        if (state.rejection === UNHANDLED) onHandleUnhandled(state);
        state.rejection = HANDLED;
      }
      if (handler === true) result = value;
      else {
        if (domain) domain.enter();
        result = handler(value); // can throw
        if (domain) {
          domain.exit();
          exited = true;
        }
      }
      if (result === reaction.promise) {
        reject(TypeError$4('Promise-chain cycle'));
      } else if (then = isThenable(result)) {
        call$j(then, result, resolve, reject);
      } else resolve(result);
    } else reject(value);
  } catch (error) {
    if (domain && !exited) domain.exit();
    reject(error);
  }
};

var notify = function (state, isReject) {
  if (state.notified) return;
  state.notified = true;
  microtask(function () {
    var reactions = state.reactions;
    var reaction;
    while (reaction = reactions.get()) {
      callReaction(reaction, state);
    }
    state.notified = false;
    if (isReject && !state.rejection) onUnhandled(state);
  });
};

var dispatchEvent = function (name, promise, reason) {
  var event, handler;
  if (DISPATCH_EVENT) {
    event = document$1.createEvent('Event');
    event.promise = promise;
    event.reason = reason;
    event.initEvent(name, false, true);
    global$h.dispatchEvent(event);
  } else event = { promise: promise, reason: reason };
  if (!NATIVE_PROMISE_REJECTION_EVENT && (handler = global$h['on' + name])) handler(event);
  else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
};

var onUnhandled = function (state) {
  call$j(task, global$h, function () {
    var promise = state.facade;
    var value = state.value;
    var IS_UNHANDLED = isUnhandled(state);
    var result;
    if (IS_UNHANDLED) {
      result = perform$2(function () {
        if (IS_NODE$1) {
          process.emit('unhandledRejection', value, promise);
        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
      });
      // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
      state.rejection = IS_NODE$1 || isUnhandled(state) ? UNHANDLED : HANDLED;
      if (result.error) throw result.value;
    }
  });
};

var isUnhandled = function (state) {
  return state.rejection !== HANDLED && !state.parent;
};

var onHandleUnhandled = function (state) {
  call$j(task, global$h, function () {
    var promise = state.facade;
    if (IS_NODE$1) {
      process.emit('rejectionHandled', promise);
    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
  });
};

var bind$6 = function (fn, state, unwrap) {
  return function (value) {
    fn(state, value, unwrap);
  };
};

var internalReject = function (state, value, unwrap) {
  if (state.done) return;
  state.done = true;
  if (unwrap) state = unwrap;
  state.value = value;
  state.state = REJECTED;
  notify(state, true);
};

var internalResolve = function (state, value, unwrap) {
  if (state.done) return;
  state.done = true;
  if (unwrap) state = unwrap;
  try {
    if (state.facade === value) throw TypeError$4("Promise can't be resolved itself");
    var then = isThenable(value);
    if (then) {
      microtask(function () {
        var wrapper = { done: false };
        try {
          call$j(then, value,
            bind$6(internalResolve, wrapper, state),
            bind$6(internalReject, wrapper, state)
          );
        } catch (error) {
          internalReject(wrapper, error, state);
        }
      });
    } else {
      state.value = value;
      state.state = FULFILLED;
      notify(state, false);
    }
  } catch (error) {
    internalReject({ done: false }, error, state);
  }
};

// constructor polyfill
if (FORCED_PROMISE_CONSTRUCTOR$4) {
  // 25.4.3.1 Promise(executor)
  PromiseConstructor = function Promise(executor) {
    anInstance$4(this, PromisePrototype);
    aCallable$6(executor);
    call$j(Internal, this);
    var state = getInternalPromiseState(this);
    try {
      executor(bind$6(internalResolve, state), bind$6(internalReject, state));
    } catch (error) {
      internalReject(state, error);
    }
  };

  PromisePrototype = PromiseConstructor.prototype;

  // eslint-disable-next-line no-unused-vars -- required for `.length`
  Internal = function Promise(executor) {
    setInternalState$5(this, {
      type: PROMISE,
      done: false,
      notified: false,
      parent: false,
      reactions: new Queue(),
      rejection: false,
      state: PENDING,
      value: undefined
    });
  };

  // `Promise.prototype.then` method
  // https://tc39.es/ecma262/#sec-promise.prototype.then
  Internal.prototype = defineBuiltIn$9(PromisePrototype, 'then', function then(onFulfilled, onRejected) {
    var state = getInternalPromiseState(this);
    var reaction = newPromiseCapability$1(speciesConstructor$3(this, PromiseConstructor));
    state.parent = true;
    reaction.ok = isCallable$8(onFulfilled) ? onFulfilled : true;
    reaction.fail = isCallable$8(onRejected) && onRejected;
    reaction.domain = IS_NODE$1 ? process.domain : undefined;
    if (state.state == PENDING) state.reactions.add(reaction);
    else microtask(function () {
      callReaction(reaction, state);
    });
    return reaction.promise;
  });

  OwnPromiseCapability = function () {
    var promise = new Internal();
    var state = getInternalPromiseState(promise);
    this.promise = promise;
    this.resolve = bind$6(internalResolve, state);
    this.reject = bind$6(internalReject, state);
  };

  newPromiseCapabilityModule$3.f = newPromiseCapability$1 = function (C) {
    return C === PromiseConstructor || C === PromiseWrapper
      ? new OwnPromiseCapability(C)
      : newGenericPromiseCapability(C);
  };

  if (isCallable$8(NativePromiseConstructor$3) && NativePromisePrototype$2 !== Object.prototype) {
    nativeThen = NativePromisePrototype$2.then;

    if (!NATIVE_PROMISE_SUBCLASSING) {
      // make `Promise#then` return a polyfilled `Promise` for native promise-based APIs
      defineBuiltIn$9(NativePromisePrototype$2, 'then', function then(onFulfilled, onRejected) {
        var that = this;
        return new PromiseConstructor(function (resolve, reject) {
          call$j(nativeThen, that, resolve, reject);
        }).then(onFulfilled, onRejected);
      // https://github.com/zloirock/core-js/issues/640
      }, { unsafe: true });
    }

    // make `.constructor === Promise` work for native promise-based APIs
    try {
      delete NativePromisePrototype$2.constructor;
    } catch (error) { /* empty */ }

    // make `instanceof Promise` work for native promise-based APIs
    if (setPrototypeOf$4) {
      setPrototypeOf$4(NativePromisePrototype$2, PromisePrototype);
    }
  }
}

$$j({ global: true, constructor: true, wrap: true, forced: FORCED_PROMISE_CONSTRUCTOR$4 }, {
  Promise: PromiseConstructor
});

setToStringTag$3(PromiseConstructor, PROMISE, false);
setSpecies$3(PROMISE);

var wellKnownSymbol$b = wellKnownSymbol$n;
var Iterators$1 = iterators;

var ITERATOR$5 = wellKnownSymbol$b('iterator');
var ArrayPrototype = Array.prototype;

// check on default Array iterator
var isArrayIteratorMethod$3 = function (it) {
  return it !== undefined && (Iterators$1.Array === it || ArrayPrototype[ITERATOR$5] === it);
};

var classof$8 = classof$a;
var getMethod$5 = getMethod$7;
var isNullOrUndefined$4 = isNullOrUndefined$8;
var Iterators = iterators;
var wellKnownSymbol$a = wellKnownSymbol$n;

var ITERATOR$4 = wellKnownSymbol$a('iterator');

var getIteratorMethod$5 = function (it) {
  if (!isNullOrUndefined$4(it)) return getMethod$5(it, ITERATOR$4)
    || getMethod$5(it, '@@iterator')
    || Iterators[classof$8(it)];
};

var call$i = functionCall;
var aCallable$5 = aCallable$a;
var anObject$d = anObject$k;
var tryToString$3 = tryToString$6;
var getIteratorMethod$4 = getIteratorMethod$5;

var $TypeError$6 = TypeError;

var getIterator$4 = function (argument, usingIterator) {
  var iteratorMethod = arguments.length < 2 ? getIteratorMethod$4(argument) : usingIterator;
  if (aCallable$5(iteratorMethod)) return anObject$d(call$i(iteratorMethod, argument));
  throw $TypeError$6(tryToString$3(argument) + ' is not iterable');
};

var call$h = functionCall;
var anObject$c = anObject$k;
var getMethod$4 = getMethod$7;

var iteratorClose$2 = function (iterator, kind, value) {
  var innerResult, innerError;
  anObject$c(iterator);
  try {
    innerResult = getMethod$4(iterator, 'return');
    if (!innerResult) {
      if (kind === 'throw') throw value;
      return value;
    }
    innerResult = call$h(innerResult, iterator);
  } catch (error) {
    innerError = true;
    innerResult = error;
  }
  if (kind === 'throw') throw value;
  if (innerError) throw innerResult;
  anObject$c(innerResult);
  return value;
};

var bind$5 = functionBindContext;
var call$g = functionCall;
var anObject$b = anObject$k;
var tryToString$2 = tryToString$6;
var isArrayIteratorMethod$2 = isArrayIteratorMethod$3;
var lengthOfArrayLike$8 = lengthOfArrayLike$a;
var isPrototypeOf$5 = objectIsPrototypeOf;
var getIterator$3 = getIterator$4;
var getIteratorMethod$3 = getIteratorMethod$5;
var iteratorClose$1 = iteratorClose$2;

var $TypeError$5 = TypeError;

var Result = function (stopped, result) {
  this.stopped = stopped;
  this.result = result;
};

var ResultPrototype = Result.prototype;

var iterate$2 = function (iterable, unboundFunction, options) {
  var that = options && options.that;
  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
  var IS_RECORD = !!(options && options.IS_RECORD);
  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
  var INTERRUPTED = !!(options && options.INTERRUPTED);
  var fn = bind$5(unboundFunction, that);
  var iterator, iterFn, index, length, result, next, step;

  var stop = function (condition) {
    if (iterator) iteratorClose$1(iterator, 'normal', condition);
    return new Result(true, condition);
  };

  var callFn = function (value) {
    if (AS_ENTRIES) {
      anObject$b(value);
      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
    } return INTERRUPTED ? fn(value, stop) : fn(value);
  };

  if (IS_RECORD) {
    iterator = iterable.iterator;
  } else if (IS_ITERATOR) {
    iterator = iterable;
  } else {
    iterFn = getIteratorMethod$3(iterable);
    if (!iterFn) throw $TypeError$5(tryToString$2(iterable) + ' is not iterable');
    // optimisation for array iterators
    if (isArrayIteratorMethod$2(iterFn)) {
      for (index = 0, length = lengthOfArrayLike$8(iterable); length > index; index++) {
        result = callFn(iterable[index]);
        if (result && isPrototypeOf$5(ResultPrototype, result)) return result;
      } return new Result(false);
    }
    iterator = getIterator$3(iterable, iterFn);
  }

  next = IS_RECORD ? iterable.next : iterator.next;
  while (!(step = call$g(next, iterator)).done) {
    try {
      result = callFn(step.value);
    } catch (error) {
      iteratorClose$1(iterator, 'throw', error);
    }
    if (typeof result == 'object' && result && isPrototypeOf$5(ResultPrototype, result)) return result;
  } return new Result(false);
};

var wellKnownSymbol$9 = wellKnownSymbol$n;

var ITERATOR$3 = wellKnownSymbol$9('iterator');
var SAFE_CLOSING = false;

try {
  var called = 0;
  var iteratorWithReturn = {
    next: function () {
      return { done: !!called++ };
    },
    'return': function () {
      SAFE_CLOSING = true;
    }
  };
  iteratorWithReturn[ITERATOR$3] = function () {
    return this;
  };
  // eslint-disable-next-line es-x/no-array-from, no-throw-literal -- required for testing
  Array.from(iteratorWithReturn, function () { throw 2; });
} catch (error) { /* empty */ }

var checkCorrectnessOfIteration$2 = function (exec, SKIP_CLOSING) {
  if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
  var ITERATION_SUPPORT = false;
  try {
    var object = {};
    object[ITERATOR$3] = function () {
      return {
        next: function () {
          return { done: ITERATION_SUPPORT = true };
        }
      };
    };
    exec(object);
  } catch (error) { /* empty */ }
  return ITERATION_SUPPORT;
};

var NativePromiseConstructor$2 = promiseNativeConstructor;
var checkCorrectnessOfIteration$1 = checkCorrectnessOfIteration$2;
var FORCED_PROMISE_CONSTRUCTOR$3 = promiseConstructorDetection.CONSTRUCTOR;

var promiseStaticsIncorrectIteration = FORCED_PROMISE_CONSTRUCTOR$3 || !checkCorrectnessOfIteration$1(function (iterable) {
  NativePromiseConstructor$2.all(iterable).then(undefined, function () { /* empty */ });
});

var $$i = _export;
var call$f = functionCall;
var aCallable$4 = aCallable$a;
var newPromiseCapabilityModule$2 = newPromiseCapability$2;
var perform$1 = perform$3;
var iterate$1 = iterate$2;
var PROMISE_STATICS_INCORRECT_ITERATION$1 = promiseStaticsIncorrectIteration;

// `Promise.all` method
// https://tc39.es/ecma262/#sec-promise.all
$$i({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION$1 }, {
  all: function all(iterable) {
    var C = this;
    var capability = newPromiseCapabilityModule$2.f(C);
    var resolve = capability.resolve;
    var reject = capability.reject;
    var result = perform$1(function () {
      var $promiseResolve = aCallable$4(C.resolve);
      var values = [];
      var counter = 0;
      var remaining = 1;
      iterate$1(iterable, function (promise) {
        var index = counter++;
        var alreadyCalled = false;
        remaining++;
        call$f($promiseResolve, C, promise).then(function (value) {
          if (alreadyCalled) return;
          alreadyCalled = true;
          values[index] = value;
          --remaining || resolve(values);
        }, reject);
      });
      --remaining || resolve(values);
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});

var $$h = _export;
var FORCED_PROMISE_CONSTRUCTOR$2 = promiseConstructorDetection.CONSTRUCTOR;
var NativePromiseConstructor$1 = promiseNativeConstructor;
var getBuiltIn$2 = getBuiltIn$9;
var isCallable$7 = isCallable$r;
var defineBuiltIn$8 = defineBuiltIn$d;

var NativePromisePrototype$1 = NativePromiseConstructor$1 && NativePromiseConstructor$1.prototype;

// `Promise.prototype.catch` method
// https://tc39.es/ecma262/#sec-promise.prototype.catch
$$h({ target: 'Promise', proto: true, forced: FORCED_PROMISE_CONSTRUCTOR$2, real: true }, {
  'catch': function (onRejected) {
    return this.then(undefined, onRejected);
  }
});

// makes sure that native promise-based APIs `Promise#catch` properly works with patched `Promise#then`
if (isCallable$7(NativePromiseConstructor$1)) {
  var method$1 = getBuiltIn$2('Promise').prototype['catch'];
  if (NativePromisePrototype$1['catch'] !== method$1) {
    defineBuiltIn$8(NativePromisePrototype$1, 'catch', method$1, { unsafe: true });
  }
}

var $$g = _export;
var call$e = functionCall;
var aCallable$3 = aCallable$a;
var newPromiseCapabilityModule$1 = newPromiseCapability$2;
var perform = perform$3;
var iterate = iterate$2;
var PROMISE_STATICS_INCORRECT_ITERATION = promiseStaticsIncorrectIteration;

// `Promise.race` method
// https://tc39.es/ecma262/#sec-promise.race
$$g({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
  race: function race(iterable) {
    var C = this;
    var capability = newPromiseCapabilityModule$1.f(C);
    var reject = capability.reject;
    var result = perform(function () {
      var $promiseResolve = aCallable$3(C.resolve);
      iterate(iterable, function (promise) {
        call$e($promiseResolve, C, promise).then(capability.resolve, reject);
      });
    });
    if (result.error) reject(result.value);
    return capability.promise;
  }
});

var $$f = _export;
var call$d = functionCall;
var newPromiseCapabilityModule = newPromiseCapability$2;
var FORCED_PROMISE_CONSTRUCTOR$1 = promiseConstructorDetection.CONSTRUCTOR;

// `Promise.reject` method
// https://tc39.es/ecma262/#sec-promise.reject
$$f({ target: 'Promise', stat: true, forced: FORCED_PROMISE_CONSTRUCTOR$1 }, {
  reject: function reject(r) {
    var capability = newPromiseCapabilityModule.f(this);
    call$d(capability.reject, undefined, r);
    return capability.promise;
  }
});

var anObject$a = anObject$k;
var isObject$7 = isObject$f;
var newPromiseCapability = newPromiseCapability$2;

var promiseResolve$2 = function (C, x) {
  anObject$a(C);
  if (isObject$7(x) && x.constructor === C) return x;
  var promiseCapability = newPromiseCapability.f(C);
  var resolve = promiseCapability.resolve;
  resolve(x);
  return promiseCapability.promise;
};

var $$e = _export;
var getBuiltIn$1 = getBuiltIn$9;
var FORCED_PROMISE_CONSTRUCTOR = promiseConstructorDetection.CONSTRUCTOR;
var promiseResolve$1 = promiseResolve$2;

getBuiltIn$1('Promise');

// `Promise.resolve` method
// https://tc39.es/ecma262/#sec-promise.resolve
$$e({ target: 'Promise', stat: true, forced: FORCED_PROMISE_CONSTRUCTOR }, {
  resolve: function resolve(x) {
    return promiseResolve$1(this, x);
  }
});

/**
 * Generic component to render icons.
 *
 * @param props - Props injected to the component.
 * @returns Generic Icon component.
 */

const GenericIcon = props => {
  const {
    as,
    background,
    bordered,
    className,
    colored,
    defaultIcon,
    disabled,
    fill,
    floated,
    hoverable,
    hoverType,
    icon: Icon,
    inline,
    inverted,
    link,
    linkType,
    onClick,
    relaxed,
    rounded,
    shape,
    size,
    spaced,
    style,
    square,
    transparent,
    twoTone,
    verticalAlign,
    width,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId,
    ["data-tourid"]: tourId
  } = props;
  const [renderedIcon, setRenderedIcon] = useState(null);
  const relaxLevel = relaxed && relaxed === true ? "" : relaxed;
  const classes = classNames({
    [typeof background === "boolean" ? "background-transparent" : `background-${background}`]: background,
    "bordered": bordered,
    "colored": colored,
    "default": defaultIcon,
    "disabled": disabled || Icon === null,
    [typeof fill === "boolean" ? "fill-default" : `fill-${fill}`]: fill,
    [`floated-${floated}`]: floated,
    hoverable,
    [`hover-${hoverType}`]: hoverType,
    "inline": inline,
    inverted,
    link,
    [`link-${linkType}`]: linkType,
    "relaxed": relaxed,
    "rounded": rounded,
    [size === "default" ? "default-size" : size]: size,
    [shape]: shape,
    [`spaced-${spaced}`]: spaced,
    "square": square,
    "transparent": transparent,
    "two-tone": twoTone,
    [`${relaxLevel}`]: relaxLevel,
    [`vertical-aligned-${verticalAlign}`]: verticalAlign,
    [`width-${width}`]: width
  }, className);
  /**
   * Construct the content as soon as the Icon prop is available.
   */

  useEffect(() => {
    constructContent();
  }, [Icon]);
  /**
   * A default icon if the `icon.Icon` null
   * or empty. For usage @see {@link constructContent}
   */

  const defaultIconPlaceholder = () => {
    return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, "");
  };
  /**
   * The icon click action handler. It first checks whether the icon
   * is disabled or not. And if disabled is `true` it will never
   * fire the provided `onClick` handler.
   *
   * @param event - Click event.
   */


  const onIconClickHandler = event => {
    if (disabled || !onClick) {
      return;
    }

    onClick(event);
  };
  /**
   * Constructs the icon. This function is a impure function which depends
   * on `Icon` value above. The `Icon` can be one of type from below list: -
   *
   * 1. `SVGElement`
   * 2. ReactComponent
   * 3. `React.FunctionComponent`
   * 4. `React.Component`
   * 5. `string` URL or BASE-64 encoded.
   */


  const constructContent = () => {
    // If there's no icon passed to this via the parent
    // then it will return a default icon.
    if (!Icon) {
      setRenderedIcon(defaultIconPlaceholder());
      return;
    }

    const setIcon = icon => {
      if (icon.ReactComponent) {
        setRenderedIcon( /*#__PURE__*/React__default.createElement(icon.ReactComponent, null));
        return;
      } else if (icon.default) {
        setRenderedIcon(renderDefaultIcon(icon.default));
        return;
      }

      setRenderedIcon(defaultIconPlaceholder());
    };

    try {
      if (Icon instanceof Promise) {
        Icon.then(response => {
          if (!as) {
            setIcon(response);
            return;
          }

          if (as === "svg") {
            setIcon(response);
            return;
          } else if (as === "data-url" && response.default) {
            setRenderedIcon(renderDefaultIcon(response.default));
            return;
          }

          setRenderedIcon(defaultIconPlaceholder());
        }).catch(() => {
          setRenderedIcon(defaultIconPlaceholder());
        });
        return;
      } // Check if the icon is an SVG element


      if (Icon instanceof SVGElement) {
        setRenderedIcon(Icon);
        return;
      } // Check if the icon is a module and has `ReactComponent` property.
      // Important when used with SVG's imported with `@svgr/webpack`.


      if (Object.prototype.hasOwnProperty.call(Icon, "ReactComponent") && typeof Icon.ReactComponent === "function") {
        setRenderedIcon( /*#__PURE__*/React__default.createElement(Icon.ReactComponent, null));
        return;
      } // Check is icon is a component.


      if (typeof Icon === "function") {
        setRenderedIcon( /*#__PURE__*/React__default.createElement(Icon, null));
        return;
      }

      if ( /*#__PURE__*/isValidElement(Icon)) {
        setRenderedIcon(Icon);
        return;
      } // Check is icon is a component.


      if (typeof Icon === "object") {
        setRenderedIcon( /*#__PURE__*/React__default.createElement(Icon, null));
        return;
      } // Check if icon passed in is a string. Can be a URL or a base64 encoded.


      if (typeof Icon === "string") {
        setRenderedIcon(renderDefaultIcon(Icon));
        return;
      }
    } catch (e) {
      return setRenderedIcon(defaultIconPlaceholder());
    }
  };
  /**
   * Renders the default icon element.
   *
   * @param icon - Data URL.
   * @returns Default icon.
   */


  const renderDefaultIcon = icon => /*#__PURE__*/React__default.createElement("img", {
    src: icon,
    className: "icon",
    alt: "icon"
  });

  return /*#__PURE__*/React__default.createElement("div", {
    className: `theme-icon ${classes}`,
    style: style,
    onClick: onIconClickHandler,
    "data-testid": testId,
    "data-componentid": componentId,
    "data-tourid": tourId
  }, renderedIcon);
};
/**
 * Default proptypes for the Generic Icon component.
 */

GenericIcon.defaultProps = {
  as: "svg",
  background: false,
  bordered: false,
  className: "",
  "data-componentid": "generic-icon",
  "data-testid": "generic-icon",
  "data-tourid": null,
  defaultIcon: false,
  disabled: false,
  floated: null,
  hoverType: "rounded",
  inline: false,
  relaxed: false,
  rounded: false,
  shape: "square",
  size: "auto",
  spaced: null,
  square: false,
  style: {},
  transparent: false,
  twoTone: false
};

/**
 * A wrapper for the semantic Popup component.
 *
 * @param props - Popup Props
 *
 * @returns
 */

const Popup = props => {
  return /*#__PURE__*/React__default.createElement(Popup$1, Object.assign({
    popper: /*#__PURE__*/React__default.createElement("div", {
      style: {
        filter: "none"
      }
    })
  }, props));
};
Popup.Content = Popup$1.Content;
Popup.Header = Popup$1.Header;

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Edit section component.
 *
 * @param props - props for the EditSection component
 *
 * @returns EditSection React Component
 */

const EditSection = props => {
  const {
    marginTop,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames({
    "top-margin": marginTop
  });
  return /*#__PURE__*/React__default.createElement(Segment, {
    padded: true,
    className: `edit-segment ${classes}`,
    "data-componentid": componentId,
    "data-testid": testId
  }, props.children);
};
/**
 * Default proptypes for the markdown component.
 */

EditSection.defaultProps = {
  "data-componentid": "edit-section"
};

var classof$7 = classof$a;

var $String = String;

var toString$d = function (argument) {
  if (classof$7(argument) === 'Symbol') throw TypeError('Cannot convert a Symbol value to a string');
  return $String(argument);
};

var $$d = _export;
var DESCRIPTORS$6 = descriptors;
var global$g = global$z;
var uncurryThis$j = functionUncurryThis;
var hasOwn$6 = hasOwnProperty_1;
var isCallable$6 = isCallable$r;
var isPrototypeOf$4 = objectIsPrototypeOf;
var toString$c = toString$d;
var defineProperty$4 = objectDefineProperty.f;
var copyConstructorProperties = copyConstructorProperties$2;

var NativeSymbol = global$g.Symbol;
var SymbolPrototype = NativeSymbol && NativeSymbol.prototype;

if (DESCRIPTORS$6 && isCallable$6(NativeSymbol) && (!('description' in SymbolPrototype) ||
  // Safari 12 bug
  NativeSymbol().description !== undefined
)) {
  var EmptyStringDescriptionStore = {};
  // wrap Symbol constructor for correct work with undefined description
  var SymbolWrapper = function Symbol() {
    var description = arguments.length < 1 || arguments[0] === undefined ? undefined : toString$c(arguments[0]);
    var result = isPrototypeOf$4(SymbolPrototype, this)
      ? new NativeSymbol(description)
      // in Edge 13, String(Symbol(undefined)) === 'Symbol(undefined)'
      : description === undefined ? NativeSymbol() : NativeSymbol(description);
    if (description === '') EmptyStringDescriptionStore[result] = true;
    return result;
  };

  copyConstructorProperties(SymbolWrapper, NativeSymbol);
  SymbolWrapper.prototype = SymbolPrototype;
  SymbolPrototype.constructor = SymbolWrapper;

  var NATIVE_SYMBOL = String(NativeSymbol('test')) == 'Symbol(test)';
  var thisSymbolValue = uncurryThis$j(SymbolPrototype.valueOf);
  var symbolDescriptiveString = uncurryThis$j(SymbolPrototype.toString);
  var regexp = /^Symbol\((.*)\)[^)]+$/;
  var replace$7 = uncurryThis$j(''.replace);
  var stringSlice$8 = uncurryThis$j(''.slice);

  defineProperty$4(SymbolPrototype, 'description', {
    configurable: true,
    get: function description() {
      var symbol = thisSymbolValue(this);
      if (hasOwn$6(EmptyStringDescriptionStore, symbol)) return '';
      var string = symbolDescriptiveString(symbol);
      var desc = NATIVE_SYMBOL ? stringSlice$8(string, 7, -1) : replace$7(string, regexp, '$1');
      return desc === '' ? undefined : desc;
    }
  });

  $$d({ global: true, constructor: true, forced: true }, {
    Symbol: SymbolWrapper
  });
}

/**
 * Copyright (c) 2022, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const BREAKPOINTS = {
  computer: 992,
  largeScreen: 1200,
  mobile: 320,
  tablet: 768,
  widescreen: 1920
};
const AppMedia = createMedia({
  breakpoints: BREAKPOINTS
});
AppMedia.createMediaStyle();

/**
 * Copyright (c) 2022, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const {
  Media
} = AppMedia;

/**
 * Copyright (c) 2022, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const {
  MediaContextProvider
} = AppMedia;

/**
 * Hook to get specifics ui elements sizes.
 *
 * @param props - Default values for the header and footer.
 * @returns App Header Height & Footer Height.
 */

const useUIElementSizes = props => {
  const {
    footerHeight: _footerHeight,
    headerHeight: _headerHeight,
    topLoadingBarHeight
  } = props;
  const [headerHeight, setHeaderHeight] = useState(_headerHeight);
  const [footerHeight, setFooterHeight] = useState(_footerHeight);
  const appHeader = document.getElementById("app-header");
  const appFooter = document.getElementById("app-footer");
  useEffect(() => {
    if (headerHeight === (appHeader === null || appHeader === void 0 ? void 0 : appHeader.offsetHeight)) {
      return;
    }

    setHeaderHeight((appHeader === null || appHeader === void 0 ? void 0 : appHeader.offsetHeight) - topLoadingBarHeight);
  });
  useEffect(() => {
    if (footerHeight === (appFooter === null || appFooter === void 0 ? void 0 : appFooter.offsetHeight)) {
      return;
    }

    setFooterHeight(appFooter === null || appFooter === void 0 ? void 0 : appFooter.offsetHeight);
  }); // This method has to tracked in both identity apps and extensions to fix the eslint issues,
  // hence it can be fixed later.
  // Tracked here: https://github.com/wso2/product-is/issues/12726#issuecomment-954835957

  return {
    headerHeight,
    // eslint-disable-next-line sort-keys
    footerHeight
  };
};

/**
 * Hook to retrieve the window dimensions.
 *
 * @param initialValues - Initial Values.
 * @returns Window Dimensions.
 */

const useWindowDimensions = (initialValues = {
  height: undefined,
  width: undefined
}) => {
  const [windowDimensions, setWindowDimensions] = useState(initialValues);
  /**
   * Onmount calculate the window dimensions.
   */

  useEffect(() => {
    // Handler to call on window resize.
    const handleResize = () => {
      // Set window width/height to state
      setWindowDimensions({
        height: window.innerHeight,
        width: window.innerWidth
      });
    }; // Add event listener.


    window.addEventListener("resize", handleResize); // Call handler right away so state gets updated with initial window size.

    handleResize(); // Housekeeping, Remove event listener on unmount.

    return () => {
      window.removeEventListener("resize", handleResize);
    };
  }, []);
  return windowDimensions;
};

/**
 * Copyright (c) 2022, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const useInfiniteScroll = (container, lastItem, hasMore, fetcher) => {
  useEffect(() => {
    if (!container.current || !lastItem.current) {
      return;
    }

    const options = {
      root: container.current,
      threshold: 0.1
    };
    const observer = new IntersectionObserver(entries => {
      if (entries[0].isIntersecting && hasMore) {
        fetcher();
      }
    }, options);
    observer.observe(lastItem.current);
    return () => {
      lastItem.current && observer.unobserve(lastItem.current);
    };
  }, [container, lastItem, hasMore]);
};

/**
 * Copyright (c) 2022, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Hook to retrieve the window dimensions.
 *
 * @returns Window Dimensions.
 */

const useMediaContext = () => {
  const {
    findBreakpointAtWidth,
    findBreakpointsForWidths,
    SortedBreakpoints
  } = AppMedia;
  const {
    width
  } = useWindowDimensions();
  const isMobileViewport = useMemo(() => {
    return findBreakpointAtWidth(width) === "mobile" || findBreakpointAtWidth(width) === undefined;
  }, [width]);
  const isGreaterThanMobileViewport = useMemo(() => {
    return width > BREAKPOINTS.mobile;
  }, [width]);
  const isGreaterThanOrEqualMobileViewport = useMemo(() => {
    return width >= BREAKPOINTS.mobile;
  }, [width]);
  const isLessThanMobileViewport = useMemo(() => {
    return width < BREAKPOINTS.mobile;
  }, [width]);
  const isLessThanOrEqualMobileViewport = useMemo(() => {
    return width <= BREAKPOINTS.mobile;
  }, [width]);
  const isTabletViewport = useMemo(() => {
    return findBreakpointAtWidth(width) === "tablet";
  }, [width]);
  const isGreaterThanTabletViewport = useMemo(() => {
    return width > BREAKPOINTS.tablet;
  }, [width]);
  const isGreaterThanOrEqualTabletViewport = useMemo(() => {
    return width >= BREAKPOINTS.tablet;
  }, [width]);
  const isLessThanTabletViewport = useMemo(() => {
    return width < BREAKPOINTS.tablet;
  }, [width]);
  const isLessThanOrEqualTabletViewport = useMemo(() => {
    return width <= BREAKPOINTS.tablet;
  }, [width]);
  const isComputerViewport = useMemo(() => {
    return findBreakpointAtWidth(width) === "computer";
  }, [width]);
  const isGreaterThanComputerViewport = useMemo(() => {
    return width > BREAKPOINTS.computer;
  }, [width]);
  const isGreaterThanOrEqualComputerViewport = useMemo(() => {
    return width >= BREAKPOINTS.computer;
  }, [width]);
  const isLessThanComputerViewport = useMemo(() => {
    return width < BREAKPOINTS.computer;
  }, [width]);
  const isLessThanOrEqualComputerViewport = useMemo(() => {
    return width <= BREAKPOINTS.computer;
  }, [width]);
  return {
    findBreakpointAtWidth,
    findBreakpointsForWidths,
    getBreakpoints: () => SortedBreakpoints,
    getBreakpointsWithWidths: () => BREAKPOINTS,
    isComputerViewport,
    isGreaterThanComputerViewport,
    isGreaterThanMobileViewport,
    isGreaterThanOrEqualComputerViewport,
    isGreaterThanOrEqualMobileViewport,
    isGreaterThanOrEqualTabletViewport,
    isGreaterThanTabletViewport,
    isLessThanComputerViewport,
    isLessThanMobileViewport,
    isLessThanOrEqualComputerViewport,
    isLessThanOrEqualMobileViewport,
    isLessThanOrEqualTabletViewport,
    isLessThanTabletViewport,
    isMobileViewport,
    isTabletViewport
  };
};

/**
 * Section component.
 *
 * @param props - Props injected to the section component.
 * @returns Section component.
 */

const Section = props => {
  const {
    children,
    className,
    contentPadding,
    description,
    connectorEnabled,
    header,
    icon,
    onPrimaryActionClick,
    onSecondaryActionClick,
    placeholder,
    primaryAction,
    primaryActionDisabled,
    primaryActionIcon,
    secondaryAction,
    secondaryActionDisabled,
    secondaryActionIcon,
    showActionBar,
    ["data-componentid"]: testId,
    topActionBar
  } = props;
  const {
    isGreaterThanOrEqualComputerViewport
  } = useMediaContext();
  const classes = classNames({
    "with-top-action-bar": topActionBar !== undefined
  }, className);
  /**
   * Construct the action element.
   *
   * @param action - action which is passed in.
   * @param actionIcon - Icon for the action.
   * @param actionDisabled - Flag to determine if the action should be disabled.
   * @param actionOnClick - On Click handler of the action.
   * @param actionType - Type of the action.
   * @returns Constructed element.
   */

  const constructAction = (action, actionIcon, actionDisabled, actionOnClick, actionType) => {
    // if passed in action is a react component
    if (typeof action === "function" || typeof action === "object") {
      return /*#__PURE__*/React__default.createElement(List.Content, {
        className: actionDisabled ? "disabled" : "",
        floated: actionType === "secondary" ? "right" : "left"
      }, action);
    } // if passed in action is of type `string`.


    if (typeof action === "string") {
      return /*#__PURE__*/React__default.createElement(List.Content, {
        className: actionDisabled ? "disabled" : "",
        floated: actionType === "secondary" ? "right" : "left"
      }, /*#__PURE__*/React__default.createElement(List.Header, {
        className: "action-button-text",
        onClick: actionOnClick
      }, actionIcon ? /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Icon, {
        name: actionIcon
      }), " ") : null, action));
    }

    return null;
  };

  return /*#__PURE__*/React__default.createElement(Card, {
    className: `settings-card ${classes}`,
    fluid: true,
    padded: "very",
    "data-testid": `${testId}-card`
  }, /*#__PURE__*/React__default.createElement(Card.Content, {
    "data-testid": `${testId}-card-content`
  }, /*#__PURE__*/React__default.createElement(Grid, null, isGreaterThanOrEqualComputerViewport ? /*#__PURE__*/React__default.createElement(Grid.Row, {
    className: "header-section",
    columns: 2,
    "data-testid": `${testId}-card-content-header`
  }, /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: connectorEnabled != undefined ? 13 : 16,
    className: "no-padding"
  }, /*#__PURE__*/React__default.createElement(Header$1, {
    as: "h2"
  }, icon ? /*#__PURE__*/React__default.createElement(GenericIcon, {
    size: "micro",
    icon: icon,
    inline: true,
    transparent: true,
    shape: "square",
    style: {
      "display": "inline",
      "verticalAlign": "text-bottom"
    }
  }) : null, header), /*#__PURE__*/React__default.createElement(Card.Meta, null, description)), connectorEnabled !== undefined ? /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: 3,
    className: "no-padding",
    textAlign: "right",
    as: "h5",
    "data-testid": `${testId}-connector-enable-status`
  }, /*#__PURE__*/React__default.createElement(Icon, {
    color: connectorEnabled ? "green" : "grey",
    name: connectorEnabled ? "check circle" : "minus circle"
  }), connectorEnabled ? "Enabled" : "Disabled") : null) : /*#__PURE__*/React__default.createElement(Grid.Row, {
    className: "header-section",
    columns: 2,
    "data-testid": `${testId}-card-content-header`
  }, /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: connectorEnabled != undefined ? 12 : 16,
    className: "no-padding"
  }, /*#__PURE__*/React__default.createElement(Header$1, {
    as: "h2"
  }, header), /*#__PURE__*/React__default.createElement(Card.Meta, null, description)), connectorEnabled !== undefined ? /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: 4,
    className: "no-padding",
    textAlign: "right",
    as: "h5",
    "data-testid": `${testId}-connector-enable-status`
  }, /*#__PURE__*/React__default.createElement(Icon, {
    color: connectorEnabled ? "green" : "grey",
    name: connectorEnabled ? "check circle" : "minus circle"
  }), connectorEnabled ? "Enabled" : "Disabled") : null), /*#__PURE__*/React__default.createElement(Grid.Row, {
    className: `main-content ${contentPadding ? "" : "no-padding"}`,
    columns: 1,
    "data-testid": `${testId}-card-content-items`
  }, /*#__PURE__*/React__default.createElement(Grid.Column, {
    className: "no-padding",
    width: 16
  }, topActionBar ? /*#__PURE__*/React__default.createElement(Menu, {
    className: "top-action-panel no-margin-bottom"
  }, /*#__PURE__*/React__default.createElement(Menu.Menu, {
    position: "right"
  }, topActionBar)) : null, children)))), (primaryAction || secondaryAction || placeholder) && showActionBar ? /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "extra-content",
    extra: true
  }, /*#__PURE__*/React__default.createElement(List, {
    selection: !secondaryAction,
    verticalAlign: "middle"
  }, /*#__PURE__*/React__default.createElement(List.Item, {
    active: true,
    className: "action-button",
    tabIndex: 0,
    disabled: !!placeholder,
    // if both `primaryAction` & `secondaryAction` are passed in,
    // disable list item `onClick`.
    onClick: !(primaryAction && secondaryAction) ? onSecondaryActionClick || onPrimaryActionClick : null,
    "data-testid": primaryAction ? `${testId}-card-primary-button` : secondaryAction ? `${testId}-card-secondary-button` : `${testId}-card-placeholder`,
    onKeyPress: e => {
      if (e.key !== "Enter") {
        return;
      }

      if (onPrimaryActionClick) {
        onPrimaryActionClick(e);
        return;
      }

      if (onSecondaryActionClick) {
        onSecondaryActionClick(e);
        return;
      }
    }
  }, placeholder ? /*#__PURE__*/React__default.createElement(List.Header, {
    className: "action-button-text"
  }, /*#__PURE__*/React__default.createElement(Message$1, {
    info: true
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "info circle"
  }), placeholder)) : /*#__PURE__*/React__default.createElement(React__default.Fragment, null, primaryAction ? constructAction(primaryAction, primaryActionIcon, primaryActionDisabled, primaryAction && secondaryAction ? onPrimaryActionClick : null, "primary") : null, secondaryAction ? constructAction(secondaryAction, secondaryActionIcon, secondaryActionDisabled, primaryAction && secondaryAction ? onSecondaryActionClick : null, "secondary") : null, /*#__PURE__*/React__default.createElement(List.Content, {
    floated: "right"
  }, /*#__PURE__*/React__default.createElement(List.Header, {
    className: "action-button-text"
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "angle right",
    size: "large"
  }))))))) : null);
};
/**
 * Default prop-types for the section component.
 */

Section.defaultProps = {
  className: "",
  contentPadding: false,
  "data-componentid": "section",
  description: "",
  header: "",
  primaryAction: "",
  primaryActionDisabled: false,
  showActionBar: true,
  topActionBar: null
};

/**
 * Emphasized segment component.
 *
 * @param props - Props injected in to the component.
 *
 * @returns React Component
 */

const EmphasizedSegment = /*#__PURE__*/forwardRef((props, ref) => {
  const {
    bordered,
    className,
    children,
    emphasized,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["bordered", "className", "children", "emphasized", "data-componentid", "data-testid"]);

  const classes = classNames({
    bordered,
    emphasized
  }, className);
  return /*#__PURE__*/React__default.createElement(Ref, {
    innerRef: ref
  }, /*#__PURE__*/React__default.createElement(Segment, Object.assign({
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), children));
});
/**
 * Prop types for the component.
 */

EmphasizedSegment.defaultProps = {
  basic: true,
  bordered: true,
  "data-componentid": "emphasized-segment",
  "data-testid": "emphasized-segment",
  emphasized: true
};

/**
 * Segmented accordion title component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Segmented Accordion React Component.
 */

const SegmentedAccordionTitle = props => {
  const {
    active,
    actions,
    attached,
    children,
    className,
    clearing,
    content,
    hideChevron,
    id,
    useEmphasizedSegments,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["active", "actions", "attached", "children", "className", "clearing", "content", "hideChevron", "id", "useEmphasizedSegments", "data-componentid", "data-testid"]);

  const classes = classNames("segmented-accordion-title", {
    clearing
  }, className);
  /**
   * Interferes the click events to stop default propagation.
   *
   * @param callback - onClick or onChange callback.
   * @param e - Event.
   * @param args - Other arguments.
   */

  const handleActionOnClick = (callback, e, ...args) => {
    e.stopPropagation();
    callback(e, ...args);
  };
  /**
   * Resolve the action.
   *
   * @param action - Passed in action.
   * @param index - Array Index.
   *
   * @returns Resolved action.
   */


  const resolveAction = (action, index) => {
    const {
      checked,
      icon,
      label,
      onChange,
      onClick,
      popoverText,
      type,
      disabled
    } = action,
          actionsRest = __rest(action, ["checked", "icon", "label", "onChange", "onClick", "popoverText", "type", "disabled"]);

    switch (type) {
      case "toggle":
        {
          return /*#__PURE__*/React__default.createElement(Checkbox, Object.assign({
            toggle: true,
            label: label,
            disabled: disabled,
            onChange: (e, data) => handleActionOnClick(onChange, e, data, id),
            "data-componentid": `${componentId}-${action.type}-action-${index}`,
            "data-testid": `${testId}-${action.type}-action-${index}`
          }, actionsRest));
        }

      case "checkbox":
        {
          return /*#__PURE__*/React__default.createElement(Checkbox, Object.assign({
            label: label,
            disabled: disabled,
            onChange: (e, data) => handleActionOnClick(onChange, e, data, id),
            "data-componentid": `${componentId}-${action.type}-action-${index}`,
            "data-testid": `${testId}-${action.type}-action-${index}`
          }, actionsRest));
        }

      case "icon":
        {
          if (typeof icon === "string") {
            return /*#__PURE__*/React__default.createElement(Popup, {
              disabled: disabled || !popoverText,
              trigger: /*#__PURE__*/React__default.createElement("div", null, /*#__PURE__*/React__default.createElement(GenericIcon, {
                size: "default",
                defaultIcon: true,
                link: true,
                inline: true,
                disabled: disabled,
                transparent: true,
                verticalAlign: "middle",
                icon: /*#__PURE__*/React__default.createElement(Icon, {
                  name: icon,
                  color: "grey",
                  className: classNames({
                    "disabled": disabled
                  }, "")
                }),
                onClick: e => handleActionOnClick(onClick, e, id),
                "data-componentid": `${componentId}-${action.type}-action-${index}`,
                "data-testid": `${testId}-${action.type}-action-${index}`
              })),
              position: "top center",
              content: popoverText,
              inverted: true
            });
          }

          return /*#__PURE__*/React__default.createElement(Popup, {
            disabled: disabled || !popoverText,
            trigger: /*#__PURE__*/React__default.createElement("div", null, /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
              size: "default",
              defaultIcon: true,
              link: true,
              inline: true,
              disabled: disabled,
              transparent: true,
              verticalAlign: "middle",
              onClick: e => handleActionOnClick(onClick, e, id),
              "data-componentid": `${componentId}-${action.type}-action-${index}`,
              "data-testid": `${testId}-${action.type}-action-${index}`
            }, icon))),
            position: "top center",
            content: popoverText,
            inverted: true
          });
        }

      case "checkbox popup":
        {
          return /*#__PURE__*/React__default.createElement(Popup, {
            disabled: disabled || !popoverText,
            trigger: /*#__PURE__*/React__default.createElement(Checkbox, Object.assign({
              checked: checked,
              label: label,
              disabled: disabled,
              onChange: (e, data) => handleActionOnClick(onChange, e, data, id),
              "data-componentid": `${componentId}-${action.type}-action-${index}`,
              "data-testid": `${testId}-${action.type}-action-${index}`
            }, actionsRest)),
            position: "top center",
            content: popoverText,
            inverted: true
          });
        }

      default:
        {
          return null;
        }
    }
  };

  return /*#__PURE__*/React__default.createElement(Accordion.Title, Object.assign({
    as: useEmphasizedSegments ? EmphasizedSegment : Segment,
    attached: attached && (active ? "top" : false),
    active: active,
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), /*#__PURE__*/React__default.createElement(Grid, null, /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: 10,
    tablet: 8,
    mobile: 16,
    verticalAlign: "middle"
  }, content || children), /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: 6,
    tablet: 8,
    mobile: 16,
    verticalAlign: "middle"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "flex floated right"
  }, actions && actions instanceof Array && actions.length > 0 ? actions.map((action, index) => /*#__PURE__*/React__default.createElement("div", {
    key: index,
    className: "mr-3 m-auto",
    onClick: e => e.stopPropagation(),
    "data-componentid": `${componentId}-${action.type}-action-container-${index}`,
    "data-testid": `${testId}-${action.type}-action-container-${index}`
  }, resolveAction(action, index))) : null, !hideChevron && /*#__PURE__*/React__default.createElement(GenericIcon, {
    size: "default",
    defaultIcon: true,
    link: true,
    inline: true,
    transparent: true,
    verticalAlign: "middle",
    floated: "right",
    "data-componentid": `${componentId}-chevron`,
    "data-testid": `${testId}-chevron`,
    icon: /*#__PURE__*/React__default.createElement(Icon, {
      name: "angle right",
      className: "chevron"
    })
  }))))));
};
/**
 * Default props for the segmented accordion title component.
 */

SegmentedAccordionTitle.defaultProps = {
  attached: true,
  clearing: false,
  "data-componentid": "segmented-accordion-title",
  "data-testid": "segmented-accordion-title",
  disabled: false,
  hideChevron: false,
  useEmphasizedSegments: true
};

/**
 * Segmented accordion component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Segmented Accordion React Component.
 */

const SegmentedAccordion = props => {
  const {
    className,
    children,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId,
    viewType
  } = props,
        rest = __rest(props, ["className", "children", "data-componentid", "data-testid", "viewType"]);

  let classes;

  switch (viewType) {
    case "list-view":
      {
        classes = classNames("segmented-accordion", className);
        break;
      }

    case "table-view":
      {
        classes = classNames("segmented-accordion-table-view", className);
        break;
      }

    default:
      {
        classes = classNames("segmented-accordion", className);
      }
  }

  return /*#__PURE__*/React__default.createElement(Accordion, Object.assign({
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), children);
};
/**
 * Default proptypes for the segmented accordion component.
 */

SegmentedAccordion.defaultProps = {
  "data-componentid": "segmented-accordion",
  "data-testid": "segmented-accordion",
  viewType: "list-view"
};
SegmentedAccordion.Title = SegmentedAccordionTitle;
SegmentedAccordion.Content = SegmentedAccordionContent;

var _circle$3, _path$c, _path2$7, _path3$3;

function _extends$d() { _extends$d = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$d.apply(this, arguments); }

var SvgErrorIcon = function SvgErrorIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$d({
    className: "error-icon_svg__icon",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 506.4 506.4",
    width: 14,
    height: 14,
    xmlSpace: "preserve"
  }, props), _circle$3 || (_circle$3 = /*#__PURE__*/React.createElement("circle", {
    className: "error-icon_svg__path error-icon_svg__fill error-icon_svg__negative",
    cx: 253.2,
    cy: 253.2,
    r: 249.2,
    fill: "#db2828"
  })), _path$c || (_path$c = /*#__PURE__*/React.createElement("path", {
    className: "error-icon_svg__path error-icon_svg__fill error-icon_svg__white",
    fill: "#fff",
    d: "m281.6 253.2 90.8-90.8c4.4-4.4 4.4-12 0-16.4l-11.2-11.2c-4.4-4.4-12-4.4-16.4 0L254 225.6l-90.8-90.8c-4.4-4.4-12-4.4-16.4 0L135.6 146c-4.4 4.4-4.4 12 0 16.4l90.8 90.8-90.8 90.8c-4.4 4.4-4.4 12 0 16.4l11.2 11.6c4.4 4.4 12 4.4 16.4 0l90.8-90.8 90.8 90.8c4.4 4.4 12 4.4 16.4 0l11.2-11.6c4.4-4.4 4.4-12 0-16.4l-90.8-90.8z"
  })), _path2$7 || (_path2$7 = /*#__PURE__*/React.createElement("path", {
    className: "error-icon_svg__path error-icon_svg__fill error-icon_svg__white",
    fill: "#fff",
    d: "M253.2 506.4C113.6 506.4 0 392.8 0 253.2S113.6 0 253.2 0s253.2 113.6 253.2 253.2-113.6 253.2-253.2 253.2zm0-498.4C118 8 8 118 8 253.2s110 245.2 245.2 245.2 245.2-110 245.2-245.2S388.4 8 253.2 8z"
  })), _path3$3 || (_path3$3 = /*#__PURE__*/React.createElement("path", {
    className: "error-icon_svg__path error-icon_svg__fill error-icon_svg__white",
    fill: "#fff",
    d: "M352.8 379.6c-4 0-8-1.6-11.2-4.4l-88-88-88 88c-2.8 2.8-6.8 4.4-11.2 4.4-4 0-8-1.6-11.2-4.4L132 364c-2.8-2.8-4.4-6.8-4.4-11.2 0-4 1.6-8 4.4-11.2l88-88-88-88c-2.8-2.8-4.4-6.8-4.4-11.2 0-4 1.6-8 4.4-11.2l11.2-11.2c6-6 16.4-6 22 0l88 88 88-88c2.8-2.8 6.8-4.4 11.2-4.4 4 0 8 1.6 11.2 4.4l11.2 11.2c6 6 6 16 0 22l-88 88 88 88c2.8 2.8 4.4 6.8 4.4 11.2 0 4-1.6 8-4.4 11.2l-11.2 11.2c-2.8 3.2-6.4 4.8-10.8 4.8zm-99.2-102.4c1.2 0 2 .4 2.8 1.2l90.8 90.8c1.6 1.6 3.2 2.4 5.6 2.4 2 0 4-.8 5.6-2.4l11.6-11.6c1.6-1.6 2.4-3.2 2.4-5.6 0-2-.8-4-2.4-5.6l-90.8-90.8c-.8-.8-1.2-1.6-1.2-2.8s.4-2 1.2-2.8l90.8-90.8c2.8-2.8 2.8-8 0-10.8l-11.2-11.2c-1.6-1.6-3.2-2.4-5.6-2.4-2 0-4 .8-5.6 2.4L256.8 228c-1.6 1.6-4 1.6-5.6 0l-90.8-90.8c-2.8-2.8-8-2.8-10.8 0L138 148.4c-1.6 1.6-2.4 3.2-2.4 5.6s.8 4 2.4 5.6l90.8 90.8c1.6 1.6 1.6 4 0 5.6L138 346.8c-1.6 1.6-2.4 3.2-2.4 5.6 0 2 .8 4 2.4 5.6l11.6 11.6c2.8 2.8 8 2.8 10.8 0l90.8-90.8c.4-1.2 1.2-1.6 2.4-1.6z"
  })));
};

var _circle$2, _g$1, _path$b, _path2$6;

function _extends$c() { _extends$c = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$c.apply(this, arguments); }

var SvgInfoIcon = function SvgInfoIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$c({
    className: "info-icon_svg__icon",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 506.4 506.4",
    width: 14,
    height: 14,
    xmlSpace: "preserve"
  }, props), _circle$2 || (_circle$2 = /*#__PURE__*/React.createElement("circle", {
    className: "info-icon_svg__path info-icon_svg__fill info-icon_svg__info",
    fill: "#7cd25a",
    cx: 253.2,
    cy: 253.2,
    r: 249.2
  })), _g$1 || (_g$1 = /*#__PURE__*/React.createElement("g", {
    fill: "#fff"
  }, /*#__PURE__*/React.createElement("path", {
    className: "info-icon_svg__path info-icon_svg__fill info-icon_svg__white",
    d: "M253.2 332.4c-10.8 0-20-8.8-20-19.6v-174c0-10.8 9.2-19.6 20-19.6s20 8.8 20 19.6v174c0 10.8-9.2 19.6-20 19.6zM253.2 395.6c-5.2 0-10.4-2-14-5.6s-5.6-8.8-5.6-14 2-10.4 5.6-14 8.8-6 14-6 10.4 2 14 6c3.6 3.6 6 8.8 6 14s-2 10.4-6 14c-3.6 3.6-8.8 5.6-14 5.6z"
  }))), _path$b || (_path$b = /*#__PURE__*/React.createElement("path", {
    className: "info-icon_svg__path info-icon_svg__fill info-icon_svg__white",
    fill: "#fff",
    d: "M253.2 506.4C113.6 506.4 0 392.8 0 253.2S113.6 0 253.2 0s253.2 113.6 253.2 253.2-113.6 253.2-253.2 253.2zm0-498.4C118 8 8 118 8 253.2s110 245.2 245.2 245.2 245.2-110 245.2-245.2S388.4 8 253.2 8z"
  })), _path2$6 || (_path2$6 = /*#__PURE__*/React.createElement("path", {
    className: "info-icon_svg__path info-icon_svg__fill info-icon_svg__white",
    fill: "#fff",
    d: "M249.2 336.4c-13.2 0-24-10.8-24-23.6v-174c0-13.2 10.8-23.6 24-23.6s24 10.8 24 23.6v174c0 12.8-10.8 23.6-24 23.6zm0-213.6c-8.8 0-16 7.2-16 15.6v174c0 8.8 7.2 15.6 16 15.6s16-7.2 16-15.6v-174c0-8.4-7.2-15.6-16-15.6zM249.2 399.6c-6.4 0-12.4-2.4-16.8-6.8s-6.8-10.4-6.8-16.8 2.4-12.4 6.8-16.8 10.8-6.8 16.8-6.8c6.4 0 12.4 2.4 16.8 6.8s6.8 10.4 6.8 16.8-2.4 12.4-7.2 16.8c-4 4.4-10 6.8-16.4 6.8zm0-39.6c-4 0-8.4 1.6-11.2 4.8-2.8 2.8-4.4 6.8-4.4 11.2 0 4 1.6 8.4 4.8 11.2 2.8 2.8 7.2 4.8 11.2 4.8s8.4-1.6 11.2-4.8c2.8-2.8 4.8-7.2 4.8-11.2s-1.6-8.4-4.8-11.2c-3.6-3.2-7.6-4.8-11.6-4.8z"
  })));
};

var _circle$1, _path$a, _path2$5, _path3$2;

function _extends$b() { _extends$b = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$b.apply(this, arguments); }

var SvgSuccessIcon = function SvgSuccessIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$b({
    className: "success-icon_svg__icon",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 506.4 506.4",
    width: 14,
    height: 14,
    xmlSpace: "preserve"
  }, props), _circle$1 || (_circle$1 = /*#__PURE__*/React.createElement("circle", {
    className: "success-icon_svg__path success-icon_svg__fill success-icon_svg__positive",
    fill: "#7cd25a",
    cx: 253.2,
    cy: 253.2,
    r: 249.2
  })), _path$a || (_path$a = /*#__PURE__*/React.createElement("path", {
    className: "success-icon_svg__path success-icon_svg__fill success-icon_svg__white",
    fill: "#fff",
    d: "m372.8 200.4-11.2-11.2c-4.4-4.4-12-4.4-16.4 0L232 302.4l-69.6-69.6c-4.4-4.4-12-4.4-16.4 0L134.4 244c-4.4 4.4-4.4 12 0 16.4l89.2 89.2c4.4 4.4 12 4.4 16.4 0l10.4-10.4.8-.8 121.6-121.6c4.4-4.4 4.4-11.6 0-16.4z"
  })), _path2$5 || (_path2$5 = /*#__PURE__*/React.createElement("path", {
    className: "success-icon_svg__path success-icon_svg__fill success-icon_svg__white",
    fill: "#fff",
    d: "M253.2 506.4C113.6 506.4 0 392.8 0 253.2S113.6 0 253.2 0s253.2 113.6 253.2 253.2-113.6 253.2-253.2 253.2zm0-498.4C118 8 8 118 8 253.2s110 245.2 245.2 245.2 245.2-110 245.2-245.2S388.4 8 253.2 8z"
  })), _path3$2 || (_path3$2 = /*#__PURE__*/React.createElement("path", {
    className: "success-icon_svg__path success-icon_svg__fill success-icon_svg__white",
    fill: "#fff",
    d: "M231.6 357.2c-4 0-8-1.6-11.2-4.4l-89.2-89.2c-6-6-6-16 0-22l11.6-11.6c6-6 16.4-6 22 0l66.8 66.8L342 186.4c2.8-2.8 6.8-4.4 11.2-4.4 4 0 8 1.6 11.2 4.4l11.2 11.2c6 6 6 16 0 22L242.8 352.4c-3.2 3.2-7.2 4.8-11.2 4.8zM154 233.6c-2 0-4 .8-5.6 2.4l-11.6 11.6c-2.8 2.8-2.8 8 0 10.8l89.2 89.2c2.8 2.8 8 2.8 10.8 0l132.8-132.8c2.8-2.8 2.8-8 0-10.8l-11.2-11.2c-2.8-2.8-8-2.8-10.8 0L234.4 306c-1.6 1.6-4 1.6-5.6 0l-69.6-69.6c-1.2-2-3.2-2.8-5.2-2.8z"
  })));
};

var _path$9, _g, _path2$4, _path3$1;

function _extends$a() { _extends$a = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$a.apply(this, arguments); }

var SvgWarningIcon = function SvgWarningIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$a({
    className: "warning-icon_svg__icon",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 507.425 507.425",
    width: 14,
    height: 14,
    xmlSpace: "preserve"
  }, props), _path$9 || (_path$9 = /*#__PURE__*/React.createElement("path", {
    className: "warning-icon_svg__path warning-icon_svg__fill warning-icon_svg__warning",
    fill: "#f2c037",
    d: "m329.312 129.112 13.6 22 150.8 242.4c22.4 36 6 65.2-36.8 65.2h-406.4c-42.4 0-59.2-29.6-36.8-65.6l198.8-320.8c22.4-36 58.8-36 81.2 0l35.6 56.8z"
  })), _g || (_g = /*#__PURE__*/React.createElement("g", {
    fill: "#fff"
  }, /*#__PURE__*/React.createElement("path", {
    className: "warning-icon_svg__path warning-icon_svg__fill warning-icon_svg__white",
    d: "M253.712 343.512c-10.8 0-20-8.8-20-20v-143.2c0-10.8 9.2-20 20-20s20 8.8 20 20v143.2c0 10.8-9.2 20-20 20zM253.312 407.112c-5.2 0-10.4-2-14-6-3.6-3.6-6-8.8-6-14s2-10.4 6-14c3.6-3.6 8.8-6 14-6s10.4 2 14 6c3.6 3.6 6 8.8 6 14s-2 10.4-6 14c-3.6 3.6-8.8 6-14 6z"
  }))), _path2$4 || (_path2$4 = /*#__PURE__*/React.createElement("path", {
    className: "warning-icon_svg__path warning-icon_svg__fill warning-icon_svg__white",
    fill: "#fff",
    d: "M456.912 465.512h-406.4c-22 0-38.4-7.6-46-21.6s-5.6-32.8 6-51.2l198.8-321.6c11.6-18.8 27.2-29.2 44.4-29.2 16.8 0 32.4 10 43.6 28.4l35.2 56.4 13.6 22 150.8 243.6c11.6 18.4 13.6 37.2 6 51.2-7.6 14.4-24 22-46 22zm-203.6-415.6c-14 0-27.2 8.8-37.6 25.2l-198.8 321.6c-10 16-12 31.6-5.6 43.2s20.4 17.6 39.2 17.6h406.4c18.8 0 32.8-6.4 39.2-17.6 6.4-11.2 4.4-27.2-5.6-43.2l-150.8-243.6-13.6-22-35.2-56.4c-10.4-16-23.6-24.8-37.6-24.8z"
  })), _path3$1 || (_path3$1 = /*#__PURE__*/React.createElement("path", {
    className: "warning-icon_svg__path warning-icon_svg__fill warning-icon_svg__white",
    fill: "#fff",
    d: "M249.712 347.512c-13.2 0-24-10.8-24-24v-143.2c0-13.2 10.8-24 24-24s24 10.8 24 24v143.2c0 13.2-10.8 24-24 24zm0-183.2c-8.8 0-16 7.2-16 16v143.2c0 8.8 7.2 16 16 16s16-7.2 16-16v-143.2c0-8.8-7.2-16-16-16zM249.712 411.112c-6.4 0-12.4-2.4-16.8-6.8s-6.8-10.8-6.8-16.8c0-6.4 2.4-12.4 6.8-16.8s10.8-7.2 16.8-7.2c6.4 0 12.4 2.4 16.8 7.2 4.4 4.4 7.2 10.4 7.2 16.8s-2.4 12.4-7.2 16.8c-4.4 4-10.4 6.8-16.8 6.8zm0-40c-4 0-8.4 1.6-11.2 4.8-2.8 2.8-4.8 7.2-4.8 11.2 0 4.4 1.6 8.4 4.8 11.2 2.8 2.8 7.2 4.8 11.2 4.8s8.4-1.6 11.2-4.8c2.8-2.8 4.8-7.2 4.8-11.2s-1.6-8.4-4.8-11.2c-2.8-3.2-7.2-4.8-11.2-4.8z"
  })));
};

/**
 * Icons for different alert states.
 */

const AlertIcons = {
  error: SvgErrorIcon,
  info: SvgInfoIcon,
  success: SvgSuccessIcon,
  warning: SvgWarningIcon
};
/**
 * Alert component to show success, error, warning and info notifications on the front end dashboards.
 *
 * @param props - Props injected in to the alert component.
 *
 * @returns the Alert component
 */

const Alert = props => {
  const {
    absolute,
    alert,
    alertsPosition,
    alertSystem,
    dismissible,
    dismissInterval,
    onAlertSystemInitialize,
    withIcon,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const [, setIntermediateDissmissInterval] = useState(dismissInterval);
  const classes = classNames({
    absolute
  }, "");
  const alertRef = useRef(null);
  useEffect(() => {
    onAlertSystemInitialize(alertRef.current);
  }, []);
  /**
   * Triggered when a new alert is available on the redux store.
   */

  useEffect(() => {
    if (!alertSystem || !alert) {
      return;
    }

    let icon = null;

    switch (alert.level) {
      case AlertLevels.SUCCESS:
        {
          icon = AlertIcons.success;
          break;
        }

      case AlertLevels.WARNING:
        {
          icon = AlertIcons.warning;
          break;
        }

      case AlertLevels.ERROR:
        {
          icon = AlertIcons.error;
          break;
        }

      case AlertLevels.INFO:
        {
          icon = AlertIcons.info;
          break;
        }
    }

    alertSystem.addNotification({
      autoDismiss: dismissInterval,
      dismissible,
      level: alert.level,
      message: /*#__PURE__*/React__default.createElement("div", {
        className: "alert-message",
        "data-componentid": `${componentId}-${alert.level}-body`,
        "data-testid": `${testId}-${alert.level}-body`
      }, /*#__PURE__*/React__default.createElement("div", {
        className: "header bold-text",
        "data-componentid": `${componentId}-${alert.level}-message`,
        "data-testid": `${testId}-${alert.level}-message`
      }, alert.message), /*#__PURE__*/React__default.createElement("div", {
        className: "description",
        "data-componentid": `${componentId}-${alert.level}-description`,
        "data-testid": `${testId}-${alert.level}-description`
      }, alert.description)),
      position: alertsPosition,
      title: withIcon ? /*#__PURE__*/React__default.createElement(GenericIcon, {
        icon: icon,
        colored: true,
        floated: "left",
        transparent: true,
        size: "mini",
        inline: true,
        spaced: "right",
        "data-componentid": `${componentId}-${alert.level}-icon`,
        "data-testid": `${testId}-${alert.level}-icon`,
        relaxed: true
      }) : null
    });
  }, [alert]);
  return /*#__PURE__*/React__default.createElement("div", {
    /**
     * onMouseEnter will set the dissmissal value to 0 so untill mouse is left, the notification will
     * be shown.
     */
    onMouseEnter: () => setIntermediateDissmissInterval(0),

    /**
     * onMouseLeave will reset the value to initial value passed via props and will dissmiss the
     * notification once the time is hit.
     */
    onMouseLeave: () => setIntermediateDissmissInterval(dismissInterval),
    className: `alert-wrapper ${classes}`,
    "data-componentid": componentId,
    "data-testid": testId
  }, /*#__PURE__*/React__default.createElement(NotificationSystem, {
    ref: alertRef,
    style: {
      NotificationItem: {
        DefaultStyle: {
          cursor: "unset"
        }
      }
    }
  }));
};
/**
 * Prop types for the Alert component.
 */

Alert.defaultProps = {
  absolute: false,
  alertsPosition: "br",
  "data-componentid": "alert",
  "data-testid": "alert",
  dismissInterval: 15,
  dismissible: true,
  withIcon: true
};

/**
 * This is a React hook that allows you to display an alert within a wizard.
 * This hook returns a state of type `WizardAlert`, a `setState` function and the React alert element.
 *
 * @example
 * ```
 * const [alert, setAlert, alertComponent] = useWizardAlert();
 * ```
 *
 * @returns An array containing the state, setState function and the alert React element.
 */

const useWizardAlert = () => {
  const [alert, setAlert] = useState(null);

  const renderAlert = () => {
    return alert && /*#__PURE__*/React__default.createElement(Message$1, {
      color: alert.level === AlertLevels.SUCCESS ? "olive" : alert.level === AlertLevels.WARNING ? "yellow" : alert.level === AlertLevels.ERROR ? "red" : alert.level === AlertLevels.INFO ? "teal" : null
    }, /*#__PURE__*/React__default.createElement(Message$1.Header, null, alert.message), /*#__PURE__*/React__default.createElement("p", null, alert.description));
  };

  return [alert, setAlert, renderAlert()];
};

/**
 * This is a React hook that allows you to display an alert within a ConfirmationModal.
 * This hook returns a state of type `ConfirmationModalAlert`, a `setState` function and the React alert element.
 *
 * @example
 * ```
 * const [alert, setAlert, alertComponent] = useConfirmationModalAlert();
 * ```
 *
 * @returns An array containing the state, setState function and the
 * alert React element.
 */

const useConfirmationModalAlert = () => {
  const [alert, setAlert] = useState(null);

  const renderAlert = () => {
    return alert && /*#__PURE__*/React__default.createElement(Message$1, {
      color: alert.level === AlertLevels.SUCCESS ? "olive" : alert.level === AlertLevels.WARNING ? "yellow" : alert.level === AlertLevels.ERROR ? "red" : alert.level === AlertLevels.INFO ? "teal" : null
    }, /*#__PURE__*/React__default.createElement(Message$1.Header, null, alert.message), /*#__PURE__*/React__default.createElement("p", null, alert.description));
  };

  return [alert, setAlert, renderAlert()];
};

/**
 * Template card component that can be used to represent application and IDP templates.
 *
 * @param props - Props injected to the components.
 *
 * @returns the Template Card component
 */

const TemplateCard = props => {
  const {
    className,
    description,
    disabled,
    name,
    id,
    inline,
    image,
    imageOptions,
    imageSize,
    onClick,
    overlayOpacity,
    renderDisabledItemsAsGrayscale,
    ribbon,
    selected,
    showTags,
    showTagIcon,
    tagSize,
    tags,
    tagsAs,
    tagsSectionTitle,
    textAlign,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("template-card", {
    disabled,
    grayscale: disabled && renderDisabledItemsAsGrayscale,
    inline,
    selected,
    ["with-image"]: image
  }, className);
  const [, setDimmerState] = useState(false);
  /**
   * Renders the tag based on render type.
   *
   * @param tag - Tag to be rendered.
   * @param as - Render type.
   * @param index - Tag index in array.
   * @returns the tag component for the corresponding render type
   */

  const renderTag = (tag, as, index) => {
    if (typeof tag === "string") {
      return /*#__PURE__*/React__default.createElement("span", {
        className: "tag default",
        key: index
      }, tag, tags.length === 1 || index === tags.length - 1 ? "" : ",");
    }

    if (as === "icon") {
      return /*#__PURE__*/React__default.createElement(Popup, {
        basic: true,
        key: index,
        trigger: /*#__PURE__*/React__default.createElement("div", {
          className: "icon-wrapper",
          "data-componentid": `${componentId}-logo-wrapper`,
          "data-testid": `${testId}-logo-wrapper`
        }, /*#__PURE__*/React__default.createElement(GenericIcon, {
          square: true,
          icon: tag.logo,
          size: tagSize,
          spaced: "right",
          fill: false,
          "data-componentid": `${componentId}-logo`,
          "data-testid": `${testId}-logo`,
          inline: true,
          transparent: true
        })),
        size: "mini",
        position: "top center",
        content: tag.displayName,
        inverted: true
      });
    }

    if (as === "label") {
      return /*#__PURE__*/React__default.createElement(Label, {
        key: index,
        size: "mini",
        "data-componentid": `${componentId}-logo-label`,
        "data-testid": `${testId}-logo-label`
      }, tag.displayName);
    }

    return /*#__PURE__*/React__default.createElement("span", {
      className: "tag default",
      key: index
    }, tag.displayName, tags.length === 1 || index === tags.length - 1 ? "" : ", ");
  };
  /**
   * Inline styles for image container.
   */


  const imageContainerStyles = () => {
    return {
      opacity: disabled ? overlayOpacity : 1
    };
  };
  /**
   * Inline styles for text container.
   */


  const textContainerStyles = () => {
    return {
      textAlign
    };
  };

  return /*#__PURE__*/React__default.createElement(Card, {
    id: id,
    className: classes,
    onClick: onClick,
    link: false,
    as: "div",
    "data-componentid": componentId,
    "data-testid": testId,
    onMouseEnter: () => setDimmerState(true),
    onMouseLeave: () => setDimmerState(false)
  }, image && /*#__PURE__*/React__default.createElement(Card.Content, {
    style: imageContainerStyles(),
    className: "card-image-container"
  }, ribbon && /*#__PURE__*/React__default.createElement("div", {
    className: "ribbon"
  }, ribbon), /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
    square: true,
    transparent: true,
    className: "card-image",
    size: imageSize,
    icon: image,
    "data-componentid": `${componentId}-image`,
    "data-testid": `${testId}-image`
  }, imageOptions))), /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "card-text-container",
    style: textContainerStyles()
  }, /*#__PURE__*/React__default.createElement(Card.Header, {
    "data-componentid": `${componentId}-header`,
    "data-testid": `${testId}-header`
  }, name), /*#__PURE__*/React__default.createElement(Card.Description, {
    "data-componentid": `${componentId}-description`,
    "data-testid": `${testId}-description`
  }, description), showTags && tags && tags instanceof Array && tags.length > 0 ? /*#__PURE__*/React__default.createElement("div", {
    className: "tags-container",
    "data-componentid": `${componentId}-tags-container`,
    "data-testid": `${testId}-tags-container`
  }, tagsSectionTitle && /*#__PURE__*/React__default.createElement("div", {
    className: "title",
    "data-componentid": `${componentId}-tags-title`,
    "data-testid": `${testId}-tags-title`
  }, tagsSectionTitle), /*#__PURE__*/React__default.createElement("div", {
    className: "tags",
    "data-componentid": `${componentId}-tags`,
    "data-testid": `${testId}-tags`
  }, showTagIcon && /*#__PURE__*/React__default.createElement(Icon, {
    name: "tag",
    className: "tag-icon",
    size: "tiny",
    color: "grey"
  }), tags.map((tag, index) => renderTag(tag, tagsAs, index)))) : null));
};
/**
 * Default props for the template card.
 */

TemplateCard.defaultProps = {
  "data-componentid": "template-card",
  "data-testid": "template-card",
  imageSize: "tiny",
  inline: true,
  renderDisabledItemsAsGrayscale: true,
  tagSize: "x22",
  tagsAs: "label",
  textAlign: "center"
};

/**
 * Danger button component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */

const DangerButton = props => {
  const {
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React__default.createElement(Button$1, Object.assign({}, props, {
    negative: true,
    "data-componentid": componentId,
    "data-testid": testId
  }));
};
/**
 * Default props for the danger button component.
 */

DangerButton.defaultProps = {
  "data-componentid": "danger-button",
  "data-testid": "danger-button"
};

/**
 * Default button component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */

const Button = props => {
  const {
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React__default.createElement(Button$1, Object.assign({}, props, {
    "data-componentid": componentId,
    "data-testid": testId
  }));
};
/**
 * Default props for the default button component.
 */

Button.defaultProps = {
  "data-componentid": "default-button",
  "data-testid": "default-button"
};

/**
 * Icon button component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */

const IconButton = props => {
  const {
    children,
    customIcon,
    customIconPosition,
    customIconSize,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React__default.createElement(Button$1, Object.assign({}, props, {
    "data-componentid": componentId,
    "data-testid": testId,
    negative: true
  }), customIcon && /*#__PURE__*/React__default.createElement(GenericIcon, {
    icon: customIcon,
    size: customIconSize,
    transparent: true,
    spaced: "right",
    floated: customIconPosition,
    "data-componentid": `${componentId}-icon`,
    "data-testid": `${testId}-icon`
  }), children);
};
/**
 * Default props for the icon button component.
 */

IconButton.defaultProps = {
  customIconPosition: "left",
  "data-componentid": "icon-button",
  "data-testid": "icon-button"
};

/**
 * Link button component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */

const LinkButton = props => {
  const {
    children,
    className,
    compact,
    hoverType,
    info,
    loading,
    loaderPosition,
    loaderSize,
    warning,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["children", "className", "compact", "hoverType", "info", "loading", "loaderPosition", "loaderSize", "warning", "data-componentid", "data-testid"]);

  const classes = classNames("link-button", {
    compact,
    [`hover-${hoverType}`]: hoverType,
    info,
    [`loader-${loaderPosition}`]: loading && loaderPosition,
    warning
  }, className);
  return /*#__PURE__*/React__default.createElement(Button$1, Object.assign({
    className: classes,
    loading: loading && !loaderPosition,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), loading && loaderPosition === "left" && /*#__PURE__*/React__default.createElement(Loader, {
    active: true,
    inline: true,
    size: loaderSize,
    "data-componentid": `${componentId}-loader`,
    "data-testid": `${testId}-loader`
  }), children, loading && loaderPosition === "right" && /*#__PURE__*/React__default.createElement(Loader, {
    active: true,
    inline: true,
    size: loaderSize,
    "data-componentid": `${componentId}-loader`,
    "data-testid": `${testId}-loader`
  }));
};
/**
 * Prop types for the link button component.
 */

LinkButton.defaultProps = {
  basic: true,
  "data-componentid": "link-button",
  "data-testid": "link-button",
  loaderSize: "mini",
  primary: true
};

/**
 * Primary button component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */

const PrimaryButton = props => {
  const {
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React__default.createElement(Button$1, Object.assign({}, props, {
    primary: true,
    "data-componentid": componentId,
    "data-testid": testId
  }));
};
/**
 * Prop types for the primary button component.
 */

PrimaryButton.defaultProps = {
  "data-componentid": "primary-button",
  "data-testid": "primary-button"
};

/**
 * Secondary button component.
 *
 * @param props - Props injected to the component.
 *
 * @returns SecondaryButton React Component
 */

const SecondaryButton = props => {
  const {
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React__default.createElement(Button$1, Object.assign({}, props, {
    secondary: true,
    "data-componentid": componentId,
    "data-testid": testId
  }));
};
/**
 * Prop types for the secondary button component.
 */

SecondaryButton.defaultProps = {
  "data-componentid": "secondary-button",
  "data-testid": "secondary-button"
};

/**
 * Text with code formatting. Wrapper around `<code>` element.
 *
 * @param props - Props injected to the component.
 *
 * @returns Code React Component
 */

const Code = props => {
  const {
    withBackground,
    children,
    className,
    compact,
    fontColor,
    fontSize,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["withBackground", "children", "className", "compact", "fontColor", "fontSize", "data-componentid", "data-testid"]);

  const classes = classNames("inline-code", {
    compact,
    [`font-size-${fontSize}`]: fontSize,
    [`font-color-${fontColor}`]: fontColor,
    "transparent": !withBackground
  }, className);
  return /*#__PURE__*/React__default.createElement("code", Object.assign({
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), children);
};
/**
 * Default props for the Code component.
 */

Code.defaultProps = {
  "data-componentid": "code",
  "data-testid": "code",
  withBackground: true
};

/**
 * Heading component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Heading React Component
 */

const Heading = props => {
  const {
    bold,
    ellipsis,
    className,
    compact,
    disabled,
    inline,
    subHeading,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["bold", "ellipsis", "className", "compact", "disabled", "inline", "subHeading", "data-componentid", "data-testid"]);

  const classes = classNames("heading", {
    [typeof bold === "boolean" ? "bold" : "bold-" + bold]: bold,
    compact,
    disabled,
    ellipsis,
    inline,
    ["subheading"]: subHeading
  }, className);
  return /*#__PURE__*/React__default.createElement(Header$1, Object.assign({
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest));
};
/**
 * Default props for the transfer component.
 */

Heading.defaultProps = {
  "data-componentid": "heading",
  "data-testid": "heading"
};

/**
 * Default Popup Options
 */

const DEFAULT_POPUP_OPTIONS = {
  hoverable: true,
  position: "top center"
};
/**
 * Hint component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Hint component.
 */

const Hint = props => {
  const {
    children,
    className,
    compact,
    disabled,
    hidden,
    icon,
    inline,
    popup,
    popupOptions,
    warning,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("ui-hint", {
    compact,
    disabled,
    hidden,
    inline: popup ? true : inline,
    popup
  }, className);
  /**
   * Aggregated popup options.
   *
   * @returns Popup props.
   */

  const resolvePopupOptions = () => {
    // If `popupOptions` are externally propvided, merge it with the default.
    if (popupOptions && isObject$g(popupOptions)) {
      return Object.assign(Object.assign({}, DEFAULT_POPUP_OPTIONS), popupOptions);
    }

    return DEFAULT_POPUP_OPTIONS;
  };
  /**
   * Resolves hit icon.
   *
   * @returns Hit icon.
   */


  const resolveIcon = () => {
    let iconType = icon || "info circle";
    let iconColor = "grey";

    if (warning) {
      iconType = "warning sign";
      iconColor = "yellow";
    }

    return /*#__PURE__*/React__default.createElement(Icon, {
      color: iconColor,
      floated: "left",
      name: iconType
    });
  };

  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, popup ? /*#__PURE__*/React__default.createElement(Popup, Object.assign({
    inverted: true,
    trigger: resolveIcon(),
    content: children,
    "data-componentid": `${componentId}-popup`,
    "data-testid": `${testId}-popup`,
    popper: /*#__PURE__*/React__default.createElement("div", {
      style: {
        filter: "none"
      }
    })
  }, resolvePopupOptions())) : /*#__PURE__*/React__default.createElement("div", {
    style: {
      columnGap: ".2rem",
      display: "inline-flex"
    }
  }, resolveIcon(), /*#__PURE__*/React__default.createElement("div", null, children)));
};
/**
 * Default props for the hint component.
 */

Hint.defaultProps = {
  compact: false,
  "data-componentid": "hint",
  "data-testid": "hint",
  inline: false,
  popup: false
};

/**
 * Text component.
 *
 * @param props - Props injected to the component.
 * @returns Text typography component.
 */

const Text = props => {
  const {
    className,
    children,
    compact,
    display,
    inline,
    muted,
    size,
    spaced,
    styles,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId,
    truncate,
    weight,
    width
  } = props,
        rest = __rest(props, ["className", "children", "compact", "display", "inline", "muted", "size", "spaced", "styles", "data-componentid", "data-testid", "truncate", "weight", "width"]);

  const classes = classNames("text-typography", {
    compact,
    "ellipsis": truncate,
    [`spaced-${spaced}`]: spaced,
    inline,
    muted
  }, className);

  const resolveInlineStyles = overrides => {
    let modified = {};

    if (weight) {
      modified = Object.assign(Object.assign({}, modified), {
        fontWeight: weight
      });
    }

    if (display) {
      modified = Object.assign(Object.assign({}, modified), {
        display
      });
    }

    if (width) {
      modified = Object.assign(Object.assign({}, modified), {
        width: width
      });
    }

    if (size) {
      modified = Object.assign(Object.assign({}, modified), {
        fontSize: typeof size === "number" ? `${size}px` : size
      });
    }

    return Object.assign(Object.assign({}, modified), overrides);
  };

  return /*#__PURE__*/React__default.createElement("div", Object.assign({
    style: resolveInlineStyles(styles),
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), children);
};
/**
 * Default props for the text component.
 */

Text.defaultProps = {
  compact: false,
  "data-componentid": "text",
  "data-testid": "text"
};

/**
 * Tooltip component.
 *
 * @param props - Props injected to the component.
 *
 * @returns ReactElement.
 */

const Tooltip = props => {
  const {
    children,
    className,
    compact,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["children", "className", "compact", "data-componentid", "data-testid"]);

  const classes = classNames("ui-tooltip", {
    compact
  }, className);
  return /*#__PURE__*/React__default.createElement(Popup, Object.assign({
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId,
    popper: /*#__PURE__*/React__default.createElement("div", {
      style: {
        filter: "none"
      }
    })
  }, rest), children);
};
/**
 * Default props for the tooltip component.
 */

Tooltip.defaultProps = {
  basic: true,
  compact: false,
  "data-componentid": "tooltip",
  "data-testid": "tooltip",
  inverted: true,
  pinned: true,
  position: "bottom center",
  size: "mini"
};

/**
 * Selection card component.
 *
 * @param props - Props injected to the components.
 * @returns Selection card component.
 */

const InfoCard = props => {
  const {
    action,
    children,
    className,
    description,
    disabled,
    fluid,
    githubRepoCard,
    githubRepoMetaInfo,
    header,
    id,
    inline,
    image,
    imageOptions,
    imageSize,
    noHover,
    onClick,
    selected,
    subHeader,
    ribbon,
    tags,
    showTooltips,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["action", "children", "className", "description", "disabled", "fluid", "githubRepoCard", "githubRepoMetaInfo", "header", "id", "inline", "image", "imageOptions", "imageSize", "noHover", "onClick", "selected", "subHeader", "ribbon", "tags", "showTooltips", "data-componentid", "data-testid"]);

  const classes = classNames("info-card", {
    disabled,
    fluid,
    inline,
    ["no-hover"]: noHover || action || disabled,
    selected,
    ["with-image"]: image
  }, className);
  return /*#__PURE__*/React__default.createElement(Card, Object.assign({
    id: id,
    className: classes,
    link: false,
    as: "div",
    "data-componentid": componentId,
    "data-testid": testId,
    onClick: !action && !disabled && onClick
  }, rest), /*#__PURE__*/React__default.createElement(Card.Content, null, ribbon && /*#__PURE__*/React__default.createElement("div", {
    className: "ribbon"
  }, ribbon), image && /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
    square: true,
    transparent: true,
    "data-componentid": `${componentId}-image`,
    "data-testid": `${testId}-image`,
    className: "card-image",
    size: fluid && !imageSize ? "tiny" : imageSize,
    icon: image,
    floated: "left"
  }, imageOptions)), /*#__PURE__*/React__default.createElement("div", {
    className: "card-header-section"
  }, header && /*#__PURE__*/React__default.createElement(Tooltip, {
    compact: true,
    size: "mini",
    trigger: /*#__PURE__*/React__default.createElement(Card.Header, {
      className: "card-header ellipsis",
      "data-componentid": `${componentId}-header`,
      "data-testid": `${testId}-header`
    }, header),
    content: header,
    disabled: typeof showTooltips === "boolean" ? !showTooltips : !showTooltips.header || typeof header !== "string"
  }), subHeader && /*#__PURE__*/React__default.createElement(Card.Header, {
    className: "card-subheader ellipsis",
    "data-componentid": `${componentId}-sub-header`,
    "data-testid": `${testId}-sub-header`
  }, subHeader), description !== undefined && fluid && /*#__PURE__*/React__default.createElement(Tooltip, {
    compact: true,
    size: "mini",
    trigger: /*#__PURE__*/React__default.createElement(Card.Description, {
      className: "card-description",
      "data-componentid": `${componentId}-description`,
      "data-testid": `${testId}-description`
    }, description),
    content: description,
    disabled: typeof showTooltips === "boolean" ? !showTooltips : !showTooltips.description || typeof description !== "string"
  }), githubRepoCard && githubRepoMetaInfo && fluid && /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "github-meta",
    "data-componentid": `${componentId}-github-repo-meta`,
    "data-testid": `${testId}-github-repo-meta`
  }, githubRepoMetaInfo.languageLogo && /*#__PURE__*/React__default.createElement(Popup, {
    trigger: /*#__PURE__*/React__default.createElement("div", {
      className: "language"
    }, /*#__PURE__*/React__default.createElement(GenericIcon, {
      icon: githubRepoMetaInfo.languageLogo,
      "data-componentid": `${componentId}-github-repo-language-logo`,
      "data-testid": `${testId}-github-repo-language-logo`,
      size: "micro",
      transparent: true,
      inline: true,
      square: true,
      spaced: "right",
      floated: "left"
    })),
    content: githubRepoMetaInfo.language,
    inverted: true
  }), /*#__PURE__*/React__default.createElement(Label.Group, {
    size: "mini",
    "data-componentid": `${componentId}-github-repo-stats`,
    "data-testid": `${testId}-github-repo-stats`
  }, /*#__PURE__*/React__default.createElement(Label, {
    "data-componentid": `${componentId}-github-repo-stars`,
    "data-testid": `${testId}-github-repo-stars`
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "star"
  }), " ", githubRepoMetaInfo.stars), /*#__PURE__*/React__default.createElement(Label, {
    "data-componentid": `${componentId}-github-repo-forks`,
    "data-testid": `${testId}-github-repo-forks`
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "fork"
  }), " ", githubRepoMetaInfo.forks), /*#__PURE__*/React__default.createElement(Label, {
    "data-componentid": `${componentId}-github-repo-watchers`,
    "data-testid": `${testId}-github-repo-watchers`
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "eye"
  }), " ", githubRepoMetaInfo.watchers))))), description !== undefined && !fluid && /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "card-description-container"
  }, /*#__PURE__*/React__default.createElement(Tooltip, {
    compact: true,
    size: "mini",
    trigger: /*#__PURE__*/React__default.createElement(Card.Description, {
      className: "card-description",
      "data-componentid": `${componentId}-description`,
      "data-testid": `${testId}-description`
    }, description),
    content: description,
    disabled: typeof showTooltips === "boolean" ? !showTooltips : !showTooltips.description || typeof description !== "string"
  })), tags && tags instanceof Array ? /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "card-tags",
    "data-componentid": `${componentId}-tags`,
    "data-testid": `${testId}-tags`
  }, /*#__PURE__*/React__default.createElement(Label.Group, {
    size: "mini"
  }, tags.map((tag, index) => /*#__PURE__*/React__default.createElement(Label, {
    key: index
  }, "#", tag)))) : null, githubRepoCard && githubRepoMetaInfo && !fluid && /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "github-meta",
    "data-componentid": `${componentId}-github-repo-meta`,
    "data-testid": `${testId}-github-repo-meta`
  }, githubRepoMetaInfo.languageLogo && /*#__PURE__*/React__default.createElement(Popup, {
    trigger: /*#__PURE__*/React__default.createElement("div", {
      className: "language"
    }, /*#__PURE__*/React__default.createElement(GenericIcon, {
      icon: githubRepoMetaInfo.languageLogo,
      "data-componentid": `${componentId}-github-repo-language-logo`,
      "data-testid": `${testId}-github-repo-language-logo`,
      size: "micro",
      transparent: true,
      inline: true,
      square: true,
      spaced: "right",
      floated: "left"
    })),
    content: githubRepoMetaInfo.language,
    inverted: true
  }), /*#__PURE__*/React__default.createElement(Label.Group, {
    size: "mini",
    "data-componentid": `${componentId}-github-repo-stats`,
    "data-testid": `${testId}-github-repo-stats`
  }, /*#__PURE__*/React__default.createElement(Label, {
    "data-componentid": `${componentId}-github-repo-stars`,
    "data-testid": `${testId}-github-repo-stars`
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "star"
  }), " ", githubRepoMetaInfo.stars), /*#__PURE__*/React__default.createElement(Label, {
    "data-componentid": `${componentId}-github-repo-forks`,
    "data-testid": `${testId}-github-repo-forks`
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "fork"
  }), " ", githubRepoMetaInfo.forks), /*#__PURE__*/React__default.createElement(Label, {
    "data-componentid": `${componentId}-github-repo-watchers`,
    "data-testid": `${testId}-github-repo-watchers`
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "eye"
  }), " ", githubRepoMetaInfo.watchers))), action !== undefined && /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "action-container",
    "data-componentid": `${componentId}-action-container`,
    "data-testid": `${testId}-action-container`
  }, typeof action === "string" ? /*#__PURE__*/React__default.createElement(LinkButton, {
    disabled: disabled,
    hoverType: "underline",
    className: "info-card-inner-action",
    onClick: e => {
      onClick(e, null);
    }
  }, action, /*#__PURE__*/React__default.createElement(Icon, {
    name: "caret right"
  })) : action), children);
};
/**
 * Prop types for the info card component.
 */

InfoCard.defaultProps = {
  "data-componentid": "info-card",
  "data-testid": "info-card",
  imageSize: "mini",
  inline: false,
  onClick: () => null,
  showTooltips: false,
  textAlign: "center"
};

/**
 * Labeled card component.
 *
 * @param props - Props injected to the components.
 *
 * @returns the labeled card component.
 */

const LabeledCard = props => {
  const {
    background,
    basic,
    bottomMargin,
    className,
    disabled,
    fluid,
    id,
    inline,
    image,
    imageOptions,
    imageSize,
    label,
    labelEllipsis,
    multilineLabel,
    onClick,
    onCloseClick,
    padding,
    raiseOnHover,
    selected,
    size,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const wrapperClasses = classNames("labeled-card-wrapper", {
    basic,
    fluid,
    ["hover-raised-none"]: !raiseOnHover,
    inline,
    [`padding-${padding}`]: padding,
    [size]: size,
    ["with-bottom-margin"]: bottomMargin
  }, className);
  const cardClasses = classNames("labeled-card", {
    [`background-${background}`]: background,
    disabled,
    selected,
    ["with-image"]: image
  });
  const cardLabelClasses = classNames("card-label", {
    "ellipsis": !multilineLabel && labelEllipsis,
    "multiline": multilineLabel
  });
  return /*#__PURE__*/React__default.createElement("div", {
    className: wrapperClasses,
    "data-componentid": `${componentId}-wrapper`,
    "data-testid": `${testId}-wrapper`
  }, /*#__PURE__*/React__default.createElement(Card, {
    id: id,
    as: "div",
    className: cardClasses,
    onClick: onClick,
    link: false,
    "data-componentid": componentId,
    "data-testid": testId
  }, onCloseClick && /*#__PURE__*/React__default.createElement(Label, {
    className: "close-button",
    color: "red",
    size: "mini",
    onClick: onCloseClick,
    "data-componentid": `${componentId}-close-button`,
    "data-testid": `${testId}-close-button`,
    floating: true,
    circular: true
  }, "x"), /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "card-image-container"
  }, /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
    className: "card-image",
    size: imageSize,
    icon: image,
    "data-componentid": `${componentId}-image`,
    "data-testid": `${testId}-image`,
    square: true,
    transparent: true
  }, imageOptions)))), /*#__PURE__*/React__default.createElement(Popup, {
    disabled: !labelEllipsis,
    trigger: /*#__PURE__*/React__default.createElement("div", {
      className: cardLabelClasses
    }, label),
    position: "bottom center",
    content: label,
    "data-componentid": `${componentId}-label`,
    "data-testid": `${testId}-label`,
    inverted: true
  }));
};
/**
 * Default props for the labeled card component.
 */

LabeledCard.defaultProps = {
  background: "default",
  basic: false,
  bottomMargin: true,
  "data-componentid": "labeled-card",
  "data-testid": "labeled-card",
  imageSize: "mini",
  inline: true,
  onClick: () => null,
  padding: "default",
  raiseOnHover: true
};

/**
 * Selection card component.
 *
 * @param props - Props injected to the components.
 *
 * @returns the selection card component
 */

const SelectionCard = props => {
  const {
    className,
    contentTopBorder,
    description,
    disabled,
    header,
    id,
    inline,
    image,
    imageInline,
    imageOptions,
    imageSize,
    multilineDescription,
    onClick,
    overlay,
    overlayOpacity,
    renderDisabledItemsAsGrayscale,
    selected,
    selectionType,
    showText,
    showTooltips,
    size,
    spaced,
    textAlign,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["className", "contentTopBorder", "description", "disabled", "header", "id", "inline", "image", "imageInline", "imageOptions", "imageSize", "multilineDescription", "onClick", "overlay", "overlayOpacity", "renderDisabledItemsAsGrayscale", "selected", "selectionType", "showText", "showTooltips", "size", "spaced", "textAlign", "data-componentid", "data-testid"]);

  const classes = classNames("selection-card", {
    disabled,
    "filled-selection": selectionType === "filled",
    grayscale: disabled && renderDisabledItemsAsGrayscale,
    "image-inline": imageInline,
    inline,
    "no-content-top-border": !contentTopBorder,
    selected,
    [size]: size,
    [`spaced-${spaced}`]: spaced,
    "underlined-selection": selectionType === "underlined",
    ["with-image"]: image
  }, className);
  const [dimmerState, setDimmerState] = useState(false);
  /**
   * Inline styles for image container.
   */

  const imageContainerStyles = () => {
    return {
      opacity: disabled ? overlayOpacity : 1
    };
  };

  return /*#__PURE__*/React__default.createElement(Card, Object.assign({
    id: id,
    className: classes,
    onClick: disabled ? () => void 0 : onClick,
    disabled: disabled,
    link: false,
    as: "div",
    "data-componentid": componentId,
    "data-testid": testId,
    onMouseEnter: () => setDimmerState(true),
    onMouseLeave: () => setDimmerState(false)
  }, rest), disabled && dimmerState && overlay, image && !imageInline && /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "card-image-container",
    style: imageContainerStyles()
  }, /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
    className: "card-image",
    size: imageSize,
    icon: image,
    "data-componentid": `${componentId}-image`,
    "data-testid": `${testId}-image`,
    square: true,
    transparent: true
  }, imageOptions))), showText && /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "card-text-container",
    style: {
      textAlign
    }
  }, image && imageInline && /*#__PURE__*/React__default.createElement("div", {
    className: "card-image-container",
    style: imageContainerStyles()
  }, /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
    square: true,
    transparent: true,
    className: "card-image",
    size: imageSize,
    icon: image,
    spaced: "right",
    floated: "left",
    "data-componentid": `${componentId}-image`,
    "data-testid": `${testId}-image`
  }, imageOptions))), /*#__PURE__*/React__default.createElement("div", {
    className: "inner-card-text-container"
  }, header && /*#__PURE__*/React__default.createElement(Tooltip, {
    disabled: !showTooltips,
    content: header,
    trigger: /*#__PURE__*/React__default.createElement(Card.Header, {
      "data-componentid": `${componentId}-header`,
      "data-testid": `${testId}-header`
    }, header)
  }), description && /*#__PURE__*/React__default.createElement(Tooltip, {
    disabled: !showTooltips,
    content: description,
    trigger: /*#__PURE__*/React__default.createElement(Card.Description, {
      className: multilineDescription ? "multiline" : "",
      "data-componentid": `${componentId}-description`,
      "data-testid": `${testId}-description`
    }, description)
  }))));
};
/**
 * Default props for the selection card component.
 */

SelectionCard.defaultProps = {
  contentTopBorder: true,
  "data-componentid": "selection-card",
  "data-testid": "selection-card",
  imageSize: "tiny",
  inline: false,
  onClick: () => null,
  renderDisabledItemsAsGrayscale: true,
  selectionType: "underlined",
  showText: true,
  showTooltips: false,
  size: "default",
  textAlign: "center"
};

/**
 * Stat count card component that can be used to represent statistics.
 *
 * @param props - Props injected to the components.
 *
 * @returns the stat count card component.
 */

const StatCountCard = props => {
  const {
    className,
    disabled,
    fluid,
    inline,
    icon,
    iconOptions,
    iconSize,
    label,
    onClick,
    statOptions,
    textAlign,
    value,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;

  const {
    textAlign: statsTextAlign,
    textTransform: statsTextTransform
  } = statOptions,
        statOptionsRest = __rest(statOptions, ["textAlign", "textTransform"]);

  const cardClasses = classNames("stat-count-card", {
    disabled,
    inline,
    ["with-icon"]: icon
  }, className);
  const statsClasses = classNames("stat-count-card-stats", {
    [`text-${statOptions.textAlign}`]: statsTextAlign,
    ["text-left"]: !statsTextAlign,
    [`text-${statOptions.textTransform}`]: statsTextTransform,
    ["text-unset"]: !statsTextTransform
  });
  return /*#__PURE__*/React__default.createElement(Card, {
    className: cardClasses,
    onClick: onClick,
    link: false,
    fluid: fluid,
    as: "div",
    "data-componentid": componentId,
    "data-testid": testId
  }, /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "stat-count-card-text-container",
    style: {
      textAlign
    }
  }, icon && /*#__PURE__*/React__default.createElement("div", {
    className: "stat-count-card-icon-container"
  }, /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
    className: "stat-count-card-icon",
    size: iconSize,
    icon: icon,
    "data-componentid": `${componentId}-icon`,
    "data-testid": `${testId}-icon`,
    floated: "left",
    shape: "rounded",
    relaxed: "very"
  }, iconOptions))), /*#__PURE__*/React__default.createElement(Statistic, Object.assign({}, statOptionsRest), /*#__PURE__*/React__default.createElement(Statistic.Label, {
    className: statsClasses
  }, label), /*#__PURE__*/React__default.createElement(Statistic.Value, {
    className: statsClasses
  }, value))));
};
/**
 * Default props for the stat count card.
 */

StatCountCard.defaultProps = {
  "data-componentid": "stat-count-card",
  "data-testid": "stat-count-card",
  fluid: false,
  iconSize: "mini",
  inline: true,
  textAlign: "left"
};

/**
 * Technology card component.
 *
 * @param props - Props injected to the components.
 *
 * @returns the TechnologyCard component
 */

const TechnologyCard = props => {
  const {
    className,
    disabled,
    displayName,
    image,
    key,
    onClick,
    overlayOpacity,
    raised,
    featureAvailable,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("tech-selection basic-card rounded mb-1", {
    "disabled no-hover": disabled
  }, className);
  const [dimmerState, setDimmerState] = useState(false);
  /**
   * Inline styles for image container.
   */

  const imageContainerStyles = () => {
    return {
      display: "flex",
      height: "100%",
      justifyContent: "center",
      opacity: disabled ? overlayOpacity : 1
    };
  };

  return /*#__PURE__*/React__default.createElement("div", {
    className: "tech-selection-wrapper"
  }, /*#__PURE__*/React__default.createElement(Card, {
    as: "div",
    link: false,
    key: key,
    raised: raised,
    "data-componentid": componentId !== null && componentId !== void 0 ? componentId : `technology-card-${kebabCase(displayName)}`,
    "data-testid": testId !== null && testId !== void 0 ? testId : `technology-card-${kebabCase(displayName)}`,
    className: classes,
    onClick: !disabled && onClick,
    onMouseEnter: () => setDimmerState(true),
    onMouseLeave: () => setDimmerState(false)
  }, disabled && /*#__PURE__*/React__default.createElement(Dimmer, {
    className: "lighter",
    active: dimmerState
  }, featureAvailable ? featureAvailable : "This feature will be available soon!"), /*#__PURE__*/React__default.createElement(Card.Content, {
    textAlign: "center",
    style: imageContainerStyles()
  }, /*#__PURE__*/React__default.createElement(GenericIcon, {
    transparent: true,
    size: "x50",
    icon: image
  }))), /*#__PURE__*/React__default.createElement("div", {
    "data-componentid": `technology-card-alias-${kebabCase(displayName)}`,
    className: classNames("name", {
      "tech-name-hidden": !dimmerState,
      "tech-name-visible": dimmerState
    })
  }, displayName));
};
/**
 * Default props for the technology card component.
 */

TechnologyCard.defaultProps = {
  "data-componentid": "technology-card",
  "data-testid": "technology-card"
};

var img$5 = "data:image/svg+xml,%3c!-- * Copyright (c) 2023%2c WSO2 LLC. (https://www.wso2.com). All Rights Reserved. * * WSO2 LLC. licenses this file to you under the Apache License%2c * Version 2.0 (the 'License')%3b you may not use this file except * in compliance with the License. * You may obtain a copy of the License at * * http://www.apache.org/licenses/LICENSE-2.0 * * Unless required by applicable law or agreed to in writing%2c * software distributed under the License is distributed on an * 'AS IS' BASIS%2c WITHOUT WARRANTIES OR CONDITIONS OF ANY * KIND%2c either express or implied. See the License for the * specific language governing permissions and limitations * under the License.--%3e%3csvg width='132' height='35' viewBox='0 0 132 35' fill='none' xmlns='http://www.w3.org/2000/svg'%3e %3cpath d='M0 0H132V35H20L0 0Z' fill='%23EFEFEF' /%3e %3cg clip-path='url(%23clip0_440_172)'%3e %3cpath d='M120.67 10L121.098 10.7501L120.624 11.5809H121.571L122 12.331H119.339L120.67 10Z' fill='%23FF7300' /%3e %3cpath d='M117.344 12.331L117.773 11.5809H118.72L118.246 10.7502L118.674 10L120.007 12.3314L117.344 12.331Z' fill='%23FF7300' /%3e %3cpath d='M120.147 14.0814L119.673 13.2507L119.198 14.0814H118.342L119.675 11.75L121.004 14.0814H120.147Z' fill='black' /%3e %3cpath d='M59.7568 20.5482V18.8036H64.1057C64.2976 18.8036 64.4815 18.7264 64.6172 18.5891C64.7529 18.4517 64.8291 18.2654 64.8291 18.0712C64.8291 17.877 64.7529 17.6907 64.6172 17.5533C64.4815 17.416 64.2976 17.3388 64.1057 17.3388H62.2035C61.5547 17.3388 60.9324 17.0778 60.4736 16.6133C60.0148 16.1488 59.7571 15.5187 59.7571 14.8618C59.7571 14.2048 60.0148 13.5748 60.4736 13.1103C60.9324 12.6457 61.5547 12.3848 62.2035 12.3848H66.5524V14.1294H62.2035C62.1086 14.1286 62.0145 14.1469 61.9267 14.1835C61.8389 14.2201 61.7592 14.274 61.6924 14.3423C61.5906 14.4445 61.5211 14.5752 61.4928 14.7175C61.4645 14.8599 61.4786 15.0075 61.5334 15.1417C61.5882 15.2759 61.6812 15.3906 61.8005 15.4711C61.9198 15.5517 62.0601 15.5945 62.2035 15.5942H64.1057C64.7546 15.5942 65.3768 15.8551 65.8356 16.3197C66.2944 16.7842 66.5522 17.4142 66.5522 18.0712C66.5522 18.7281 66.2944 19.3582 65.8356 19.8227C65.3768 20.2872 64.7546 20.5482 64.1057 20.5482H59.7568Z' fill='black' /%3e %3cpath d='M71.2169 20.5493C70.6796 20.5621 70.1451 20.466 69.645 20.2666C69.1448 20.0672 68.6891 19.7686 68.3046 19.3883C67.9201 19.008 67.6145 18.5537 67.4059 18.0522C67.1973 17.5506 67.0898 17.0118 67.0898 16.4676C67.0898 15.9234 67.1973 15.3846 67.4059 14.8831C67.6145 14.3815 67.9201 13.9272 68.3046 13.5469C68.6891 13.1666 69.1448 12.868 69.645 12.6686C70.1451 12.4692 70.6796 12.3731 71.2169 12.3859H74.6147V14.1287H71.2169C70.6247 14.1587 70.0666 14.4181 69.6579 14.8531C69.2493 15.2881 69.0213 15.8655 69.0213 16.4658C69.0213 17.0662 69.2493 17.6436 69.6579 18.0786C70.0666 18.5136 70.6247 18.7729 71.2169 18.8029H72.8934V17.3381H71.6258V15.6025H74.6174V20.5565L71.2169 20.5493Z' fill='black' /%3e %3cpath d='M91.0573 20.5482L87.1684 16.6467V20.5482H85.4453V12.3848H89.7942C90.2788 12.3835 90.7528 12.5282 91.156 12.8002C91.5592 13.0723 91.8735 13.4596 92.0589 13.913C92.2443 14.3663 92.2924 14.8651 92.1971 15.3462C92.1019 15.8273 91.8676 16.2688 91.524 16.6148C91.3227 16.8198 91.0895 16.9901 90.8338 17.1188L90.3204 17.3717L93.4658 20.5496L91.0573 20.5482ZM89.7942 15.6032C89.9861 15.6032 90.17 15.526 90.3057 15.3887C90.4413 15.2513 90.5176 15.065 90.5176 14.8708C90.5176 14.6766 90.4413 14.4903 90.3057 14.3529C90.17 14.2156 89.9861 14.1384 89.7942 14.1384H87.1684V15.6032H89.7942Z' fill='black' /%3e %3cpath d='M94.1045 20.5489V12.3859H97.5023C98.0396 12.3731 98.5741 12.4693 99.0742 12.6686C99.5744 12.868 100.03 13.1666 100.415 13.5469C100.799 13.9272 101.105 14.3815 101.313 14.8831C101.522 15.3846 101.629 15.9234 101.629 16.4676C101.629 17.0118 101.522 17.5506 101.313 18.0522C101.105 18.5537 100.799 19.008 100.415 19.3883C100.03 19.7686 99.5744 20.0672 99.0742 20.2666C98.5741 20.466 98.0396 20.5621 97.5023 20.5494L94.1045 20.5489ZM97.5023 18.8042C98.0945 18.7742 98.6526 18.5149 99.0613 18.0799C99.4699 17.6449 99.6979 17.0675 99.6979 16.4672C99.6979 15.8668 99.4699 15.2894 99.0613 14.8544C98.6526 14.4194 98.0945 14.1601 97.5023 14.1301H95.8276V18.8042H97.5023Z' fill='black' /%3e %3cpath d='M113.494 20.5493C112.563 20.549 111.66 20.2216 110.94 19.623C110.22 19.0243 109.727 18.1914 109.545 17.2661C109.363 16.3409 109.504 15.3804 109.943 14.5484C110.383 13.7164 111.093 13.0643 111.954 12.7032C112.815 12.3421 113.773 12.2943 114.664 12.5679C115.556 12.8416 116.326 13.4198 116.844 14.204C117.362 14.9882 117.595 15.93 117.505 16.8689C117.414 17.8078 117.004 18.6857 116.346 19.3532C115.978 19.7411 115.534 20.0476 115.044 20.2534C114.553 20.4593 114.026 20.56 113.494 20.5493ZM113.494 14.1305C112.96 14.1295 112.441 14.3165 112.027 14.6594C111.613 15.0023 111.329 15.48 111.224 16.011C111.119 16.542 111.199 17.0935 111.451 17.5713C111.703 18.0492 112.11 18.4239 112.604 18.6316C113.098 18.8393 113.648 18.867 114.16 18.7101C114.672 18.5533 115.114 18.2215 115.412 17.7713C115.709 17.3212 115.843 16.7805 115.791 16.2416C115.738 15.7026 115.503 15.1988 115.125 14.8158C114.913 14.5958 114.659 14.4216 114.379 14.3038C114.099 14.186 113.798 14.127 113.494 14.1305Z' fill='black' /%3e %3cpath d='M50 20.5482H51.9267L54.6564 15.762L57.384 20.5482H59.3084L54.6564 12.3848L50 20.5482Z' fill='black' /%3e %3cpath d='M75.3623 20.5482H77.289L80.0165 15.762L82.7441 20.5482H84.669L80.0161 12.3848L75.3623 20.5482Z' fill='black' /%3e %3cpath d='M102.277 20.5229V12.3887H109.013V14.1176H103.996V15.6138H107.759V17.3027H103.996V18.7944H109.013V20.5233L102.277 20.5229Z' fill='black' /%3e %3c/g%3e %3cpath d='M35.1289 21.084C34.4942 21.084 33.9202 20.944 33.4069 20.664C32.9029 20.3747 32.5016 19.95 32.2029 19.39C31.9136 18.83 31.7689 18.13 31.7689 17.29C31.7689 16.45 31.9182 15.75 32.2169 15.19C32.5249 14.63 32.9309 14.21 33.4349 13.93C33.9482 13.65 34.5129 13.51 35.1289 13.51C35.8569 13.51 36.5009 13.6687 37.0609 13.986C37.6209 14.3033 38.0642 14.7467 38.3909 15.316C38.7176 15.876 38.8809 16.534 38.8809 17.29C38.8809 18.046 38.7176 18.7087 38.3909 19.278C38.0642 19.8473 37.6209 20.2907 37.0609 20.608C36.5009 20.9253 35.8569 21.084 35.1289 21.084ZM31.1949 21V10.612H32.5389V15.554L32.3989 17.276L32.4829 18.998V21H31.1949ZM35.0169 19.908C35.4929 19.908 35.9176 19.8007 36.2909 19.586C36.6736 19.3713 36.9722 19.068 37.1869 18.676C37.4109 18.2747 37.5229 17.8127 37.5229 17.29C37.5229 16.758 37.4109 16.3007 37.1869 15.918C36.9722 15.526 36.6736 15.2227 36.2909 15.008C35.9176 14.7933 35.4929 14.686 35.0169 14.686C34.5502 14.686 34.1256 14.7933 33.7429 15.008C33.3696 15.2227 33.0709 15.526 32.8469 15.918C32.6322 16.3007 32.5249 16.758 32.5249 17.29C32.5249 17.8127 32.6322 18.2747 32.8469 18.676C33.0709 19.068 33.3696 19.3713 33.7429 19.586C34.1256 19.8007 34.5502 19.908 35.0169 19.908ZM40.8548 23.8C40.5001 23.8 40.1548 23.7393 39.8188 23.618C39.4828 23.506 39.1935 23.338 38.9508 23.114L39.5248 22.106C39.7115 22.2833 39.9168 22.4187 40.1408 22.512C40.3648 22.6053 40.6028 22.652 40.8548 22.652C41.1815 22.652 41.4521 22.568 41.6668 22.4C41.8815 22.232 42.0821 21.9333 42.2688 21.504L42.7308 20.482L42.8708 20.314L45.7828 13.58H47.0988L43.5008 21.742C43.2861 22.2647 43.0435 22.6753 42.7728 22.974C42.5115 23.2727 42.2221 23.4827 41.9048 23.604C41.5875 23.7347 41.2375 23.8 40.8548 23.8ZM42.6188 21.238L39.2308 13.58H40.6308L43.5148 20.188L42.6188 21.238Z' fill='%23A0A0A0' /%3e %3cdefs%3e %3cclipPath id='clip0_440_172'%3e %3crect width='72' height='18' fill='white' transform='translate(50 10)' /%3e %3c/clipPath%3e %3c/defs%3e%3c/svg%3e";

/**
 * Technology card component.
 *
 * @param props - Props injected to the components.
 *
 * @returns the TechnologyCard component
 */

const LargeTechnologyCard = props => {
  const {
    className,
    disabled,
    displayName,
    image,
    key,
    onQuickstartClick,
    onSampleAppClick,
    overlayOpacity,
    raised,
    featureAvailable,
    ["data-componentid"]: componentId
  } = props;
  const classes = classNames("basic-card mb-1 no-hover", {
    "disabled no-hover": disabled
  }, className);
  const [dimmerState, setDimmerState] = useState(false);
  /**
   * Inline styles for image container.
   */

  const imageContainerStyles = () => {
    return {
      display: "flex",
      height: "100%",
      justifyContent: "center",
      opacity: disabled ? overlayOpacity : 1
    };
  };

  return /*#__PURE__*/React__default.createElement("div", {
    className: "tech-selection-wrapper large"
  }, /*#__PURE__*/React__default.createElement(Card, {
    as: "div",
    link: false,
    key: key,
    raised: raised,
    "data-componentid": componentId !== null && componentId !== void 0 ? componentId : `technology-card-${kebabCase(displayName)}`,
    className: classes,
    onMouseEnter: () => setDimmerState(true),
    onMouseLeave: () => setDimmerState(false)
  }, disabled && /*#__PURE__*/React__default.createElement(Dimmer, {
    className: "lighter",
    active: dimmerState
  }, featureAvailable ? featureAvailable : "This feature will be available soon!"), /*#__PURE__*/React__default.createElement("div", {
    className: "made-by-asgardeo-label"
  }, /*#__PURE__*/React__default.createElement("img", {
    width: "132",
    height: "35",
    src: img$5,
    alt: "Made by Asgardeo label"
  })), /*#__PURE__*/React__default.createElement(Card.Content, {
    textAlign: "center",
    style: imageContainerStyles()
  }, /*#__PURE__*/React__default.createElement(GenericIcon, {
    transparent: true,
    size: "tiny",
    icon: image
  })), /*#__PURE__*/React__default.createElement(Card.Content, {
    textAlign: "center",
    className: "pt-0 pb-4"
  }, /*#__PURE__*/React__default.createElement("div", {
    "data-componentid": `technology-card-alias-${kebabCase(displayName)}`,
    className: "technology-name"
  }, displayName)), /*#__PURE__*/React__default.createElement(Card.Content, {
    className: "mb-4"
  }, /*#__PURE__*/React__default.createElement(LinkButton, {
    "data-componentid": `technology-card-${kebabCase(displayName)}-quickstart-button`,
    className: "tech-card-options mr-3",
    hoverType: "underline",
    onClick: !disabled && onQuickstartClick,
    compact: true
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "bolt"
  }), "Quickstart"), /*#__PURE__*/React__default.createElement(LinkButton, {
    "data-componentid": `technology-card-${kebabCase(displayName)}-sample-app-button`,
    className: "tech-card-options ml-3",
    hoverType: "underline",
    onClick: !disabled && onSampleAppClick,
    compact: true
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "github"
  }), "Sample App"))));
};
/**
 * Default props for the technology card component.
 */

LargeTechnologyCard.defaultProps = {
  "data-componentid": "technology-card"
};

/**
 * Statistics overview widget.
 *
 * @param props - Props injected to the component.
 *
 * @returns Stats Overview Widget.
 */

const StatsOverviewWidget = props => {
  const {
    heading,
    headingAs,
    maxRowCount,
    subHeading,
    subHeadingAs,
    stats,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;

  const resolveStatCountCard = stat => {
    const {
      icon,
      label,
      value,
      iconOptions,
      statOptions
    } = stat,
          statRest = __rest(stat, ["icon", "label", "value", "iconOptions", "statOptions"]);

    return /*#__PURE__*/React__default.createElement(StatCountCard, Object.assign({
      fluid: true,
      icon: icon,
      label: label,
      value: value,
      textAlign: "right",
      statOptions: Object.assign({
        size: "small",
        textAlign: "right"
      }, statOptions),
      iconOptions: Object.assign({
        background: "default",
        fill: "default",
        shape: "circular"
      }, iconOptions)
    }, statRest, {
      "data-componentid": `${componentId}-${kebabCase(label)}-card`,
      "data-testid": `${testId}-${kebabCase(label)}-card`
    }));
  };

  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, heading && /*#__PURE__*/React__default.createElement(Heading, {
    className: "stats-overview-widget-heading inline ellipsis",
    as: headingAs,
    "data-componentid": `${componentId}-heading`,
    "data-testid": `${testId}-heading`,
    compact: true
  }, heading), subHeading && /*#__PURE__*/React__default.createElement(Heading, {
    className: "stats-overview-widget-sub-heading",
    "data-componentid": `${componentId}-sub-heading`,
    "data-testid": `${testId}-sub-heading`,
    as: subHeadingAs,
    subHeading: true,
    ellipsis: true
  }, subHeading), (heading || subHeading) && /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), stats && stats instanceof Array && stats.length > 0 ? /*#__PURE__*/React__default.createElement(Grid, null, /*#__PURE__*/React__default.createElement(Grid.Row, {
    columns: stats.length > maxRowCount ? maxRowCount : stats.length,
    className: stats.length > maxRowCount ? "column-count-exceeded" : ""
  }, stats.map((stat, index) => /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(GridColumn, {
    key: index,
    as: Media,
    width: 16,
    className: "with-bottom-gutters",
    lessThan: "tablet"
  }, resolveStatCountCard(stat)), /*#__PURE__*/React__default.createElement(GridColumn, {
    key: index,
    as: Media,
    greaterThan: "tablet"
  }, resolveStatCountCard(stat)))))) : null);
};
/**
 * Default props for the component.
 */

StatsOverviewWidget.defaultProps = {
  "data-componentid": "stats-overview-widget",
  "data-testid": "stats-overview-widget",
  headingAs: "h3",
  maxRowCount: 4,
  subHeadingAs: "h5"
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Statistics insights preview widget.
 *
 * @param props - Props injected to the component.
 *
 * @returns Statistics insights preview widget.
 */

const StatsInsightsWidget = props => {
  const {
    children,
    heading,
    headingAs,
    onPrimaryActionClick,
    primaryAction,
    showExtraContent,
    subHeading,
    subHeadingAs,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React__default.createElement("div", {
    className: "stats-insights-widget"
  }, heading && /*#__PURE__*/React__default.createElement(Heading, {
    className: "stats-insights-widget-heading inline ellipsis",
    as: headingAs,
    "data-componentid": `${componentId}-heading`,
    "data-testid": `${testId}-heading`,
    compact: true
  }, heading), subHeading && /*#__PURE__*/React__default.createElement(Heading, {
    className: "stats-insights-widget-sub-heading",
    "data-componentid": `${componentId}-sub-heading`,
    "data-testid": `${testId}-sub-heading`,
    as: subHeadingAs,
    subHeading: true,
    ellipsis: true
  }, subHeading), (heading || subHeading) && /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), /*#__PURE__*/React__default.createElement(Card, {
    fluid: true,
    className: "stats-insights-widget-card basic-card",
    "data-componentid": `${componentId}-${kebabCase(heading)}-card`,
    "data-testid": `${testId}-${kebabCase(heading)}-card`
  }, /*#__PURE__*/React__default.createElement(Card.Content, {
    className: `main-content compact ${!showExtraContent ? "hide-extra" : ""} `
  }, children), showExtraContent && /*#__PURE__*/React__default.createElement(Card.Content, {
    extra: true,
    className: "selection",
    "data-componentid": `${componentId}-${kebabCase(heading)}-card-action`,
    "data-testid": `${testId}-${kebabCase(heading)}-card-action`,
    onClick: onPrimaryActionClick
  }, /*#__PURE__*/React__default.createElement(LinkButton, {
    compact: true,
    "data-componentid": `${componentId}-${kebabCase(heading)}-card-action-button`,
    "data-testid": `${testId}-${kebabCase(heading)}-card-action-button`
  }, primaryAction))));
};
/**
 * Default props for the component.
 */

StatsInsightsWidget.defaultProps = {
  "data-componentid": "stats-insights-widget",
  "data-testid": "stats-insights-widget",
  headingAs: "h3",
  showExtraContent: true,
  subHeadingAs: "h5"
};

/**
 * Statistics quick links widget.
 *
 * @param props - Props injected to the component.
 *
 * @returns the StatsQuickLinks Widget
 */

const StatsQuickLinksWidget = props => {
  const {
    heading,
    headingAs,
    subHeading,
    subHeadingAs,
    links,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React__default.createElement("div", {
    className: "stats-quick-links-widget"
  }, heading && /*#__PURE__*/React__default.createElement(Heading, {
    className: "stats-quick-links-widget-heading inline ellipsis",
    as: headingAs,
    "data-componentid": `${componentId}-heading`,
    "data-testid": `${testId}-heading`,
    compact: true
  }, heading), subHeading && /*#__PURE__*/React__default.createElement(Heading, {
    className: "stats-quick-links-widget-sub-heading",
    "data-componentid": `${componentId}-sub-heading`,
    "data-testid": `${testId}-sub-heading`,
    as: subHeadingAs,
    subHeading: true,
    ellipsis: true
  }, subHeading), (heading || subHeading) && /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), links && links instanceof Array && links.length > 0 ? /*#__PURE__*/React__default.createElement(Card.Group, {
    itemsPerRow: 3,
    stackable: true,
    doubling: true,
    className: "stats-quick-links-widget-cards"
  }, links.map((link, index) => {
    const {
      image,
      header,
      description
    } = link,
          linksRest = __rest(link, ["image", "header", "description"]);

    return /*#__PURE__*/React__default.createElement(SelectionCard, Object.assign({
      key: index,
      image: image,
      imageOptions: {
        fill: "default"
      },
      size: "auto",
      header: header,
      imageSize: "mini",
      contentTopBorder: false,
      description: description,
      "data-componentid": `${componentId}-${kebabCase(header)}-card`,
      "data-testid": `${testId}-${kebabCase(header)}-card`,
      multilineDescription: true,
      showTooltips: true
    }, linksRest));
  })) : null);
};
/**
 * Default props for the component.
 */

StatsQuickLinksWidget.defaultProps = {
  "data-componentid": "stats-quick-links-widget",
  "data-testid": "stats-quick-links-widget",
  headingAs: "h3",
  subHeadingAs: "h5"
};

/**
 * Animated avatar component.
 * This is a mosaic of 6x6 squares with random opacity values between `0.8` and `1`.
 *
 * @param props - Props injected in to the component.
 * @returns the Animated Avatar component
 */

const AnimatedAvatar = props => {
  const {
    name,
    primary,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["name", "primary", "data-componentid"]);

  const AnimatedSVGBackground = () => /*#__PURE__*/React__default.createElement("svg", {
    className: "claims-avatar-background",
    xmlns: "http://www.w3.org/2000/svg",
    version: "1.1",
    viewBox: "0 0 1024 1024",
    "data-componentid": componentId
  }, /*#__PURE__*/React__default.createElement("g", null, /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M0.08504+0L170.638+0C170.732+0+170.808+0.0760688+170.808+0.169904L170.808+170.723C170" + ".808+170.817+170.732+170.893+170.638+170.893L0.08504+170.893C-0.00879569+170.893-0." + "0848645+170.817-0.0848645+170.723L-0.0848645+0.169904C-0.0848645+0.0760688-" + "0.00879569+0+0.08504+0Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M170.978+0L341.532+0C341.625+0+341.701+0.0760688+341.701+0.169904L341.701+170.723C341." + "701+170.817+341.625+170.893+341.532+170.893L170.978+170.893C170.884+170.893+170.808+" + "170.817+170.808+170.723L170.808+0.169904C170.808+0.0760688+170.884+0+170.978+0Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M341.277+0L511.83+0C511.924+0+512+0.0760688+512+0.169904L512+170.723C512+170.817+511.924+170" + ".893+511.83+170.893L341.277+170.893C341.183+170.893+341.107+170.817+341.107+170.723L341." + "107+0.169904C341.107+0.0760688+341.183+0+341.277+0Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M512.17+0L682.723+0C682.817+0+682.893+0.0760688+682.893+0.169904L682.893+170.723C682.893" + "+170.817+682.817+170.893+682.723+170.893L512.17+170.893C512.076+170.893+512+170.817+" + "512+170.723L512+0.169904C512+0.0760688+512.076+0+512.17+0Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M683.063+0L853.616+0C853.71+0+853.786+0.0760688+853.786+0.169904L853.786+170.723C853.786+" + "170.817+853.71+170.893+853.616+170.893L683.063+170.893C682.969+170.893+682.893+170.817+" + "682.893+170.723L682.893+0.169904C682.893+0.0760688+682.969+0+683.063+0Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M853.956+0L1024.51+0C1024.6+0+1024.68+0.0760688+1024.68+0.169904L1024.68+170.723C1024.68+" + "170.817+1024.6+170.893+1024.51+170.893L853.956+170.893C853.862+170.893+853.786+170.817+853." + "786+170.723L853.786+0.169904C853.786+0.0760688+853.862+0+853.956+0Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M0.169904+170.893L170.723+170.893C170.817+170.893+170.893+170.969+170.893+171.063L170.893+" + "341.616C170.893+341.71+170.817+341.786+170.723+341.786L0.169904+341.786C0.0760688+341." + "786+0+341.71+0+341.616L0+171.063C0+170.969+0.0760688+170.893+0.169904+170.893Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M171.063+170.893L341.616+170.893C341.71+170.893+341.786+170.969+341.786+171.063L341.786+341." + "616C341.786+341.71+341.71+341.786+341.616+341.786L171.063+341.786C170.969+341.786+170.893+" + "341.71+170.893+341.616L170.893+171.063C170.893+170.969+170.969+170.893+171.063+170.893Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M341.362+170.893L511.915+170.893C512.009+170.893+512.085+170.969+512.085+171.063L512.085" + "+341.616C512.085+341.71+512.009+341.786+511.915+341.786L341.362+341.786C341.268+341." + "786+341.192+341.71+341.192+341.616L341.192+171.063C341.192+170.969+341.268+170." + "893+341.362+170.893Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M512.255+170.893L682.808+170.893C682.902+170.893+682.978+170.969+682.978+171.063L682." + "978+341.616C682.978+341.71+682.902+341.786+682.808+341.786L512.255+341.786C512.161+341." + "786+512.085+341.71+512.085+341.616L512.085+171.063C512.085+170.969+512.161+170." + "893+512.255+170.893Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M683.148+170.893L853.701+170.893C853.795+170.893+853.871+170.969+853.871+171.063L853." + "871+341.616C853.871+341.71+853.795+341.786+853.701+341.786L683.148+341.786C683.054+341." + "786+682.978+341.71+682.978+341.616L682.978+171.063C682.978+170.969+683.054+170." + "893+683.148+170.893Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M854.041+170.893L1024.59+170.893C1024.69+170.893+1024.76+170.969+1024.76+171.063L1024" + ".76+341.616C1024.76+341.71+1024.69+341.786+1024.59+341.786L854.041+341.786C853.947+341." + "786+853.871+341.71+853.871+341.616L853.871+171.063C853.871+170.969+853.947+170." + "893+854.041+170.893Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M-0.594375+341.786L169.959+341.786C170.053+341.786+170.129+341.862+170.129+341.956L170." + "129+512.51C170.129+512.603+170.053+512.679+169.959+512.679L-0.594375+512.679C-0." + "688211+512.679-0.76428+512.603-0.76428+512.51L-0.76428+341.956C-0.76428+341.862-0." + "688211+341.786-0.594375+341.786Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M170.299+341.786L340.852+341.786C340.946+341.786+341.022+341.862+341.022+341.956L341." + "022+512.51C341.022+512.603+340.946+512.679+340.852+512.679L170.299+512.679C170.205+512." + "679+170.129+512.603+170.129+512.51L170.129+341.956C170.129+341.862+170.205+341." + "786+170.299+341.786Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M340.597+341.786L511.151+341.786C511.245+341.786+511.321+341.862+511.321+341.956L511." + "321+512.51C511.321+512.603+511.245+512.679+511.151+512.679L340.597+512.679C340.504+512." + "679+340.427+512.603+340.427+512.51L340.427+341.956C340.427+341.862+340.504+341.786+340." + "597+341.786Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M511.49+341.786L682.044+341.786C682.138+341.786+682.214+341.862+682.214+341.956L682.214+" + "512.51C682.214+512.603+682.138+512.679+682.044+512.679L511.49+512.679C511.397+512.679+" + "511.321+512.603+511.321+512.51L511.321+341.956C511.321+341.862+511.397+341.786+" + "511.49+341.786Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M682.384+341.786L852.937+341.786C853.031+341.786+853.107+341.862+853.107+341.956L853." + "107+512.51C853.107+512.603+853.031+512.679+852.937+512.679L682.384+512.679C682.29+" + "512.679+682.214+512.603+682.214+512.51L682.214+341.956C682.214+341.862+682.29+341." + "786+682.384+341.786Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M853.277+341.786L1023.83+341.786C1023.92+341.786+1024+341.862+1024+341.956L1024+512." + "51C1024+512.603+1023.92+512.679+1023.83+512.679L853.277+512.679C853.183+512.679+853." + "107+512.603+853.107+512.51L853.107+341.956C853.107+341.862+853.183+341.786+853.277+341.786Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M-0.891651+512.679L169.662+512.679C169.756+512.679+169.832+512.755+169.832+512." + "849L169.832+683.403C169.832+683.496+169.756+683.573+169.662+683.573L-0.891651+683." + "573C-0.985486+683.573-1.06155+683.496-1.06155+683.403L-1.06155+512.849C-1.06155+512." + "755-0.985486+512.679-0.891651+512.679Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M170.001+512.679L340.555+512.679C340.649+512.679+340.725+512.755+340.725+512.849L340." + "725+683.403C340.725+683.496+340.649+683.573+340.555+683.573L170.001+683.573C169." + "908+683.573+169.832+683.496+169.832+683.403L169.832+512.849C169.832+512.755+169." + "908+512.679+170.001+512.679Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M340.3+512.679L510.853+512.679C510.947+512.679+511.023+512.755+511.023+512.849L511." + "023+683.403C511.023+683.496+510.947+683.573+510.853+683.573L340.3+683.573C340.206+683." + "573+340.13+683.496+340.13+683.403L340.13+512.849C340.13+512.755+340.206+512.679+340." + "3+512.679Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M511.193+512.679L681.747+512.679C681.84+512.679+681.916+512.755+681.916+512.849L681." + "916+683.403C681.916+683.496+681.84+683.573+681.747+683.573L511.193+683.573C511." + "099+683.573+511.023+683.496+511.023+683.403L511.023+512.849C511.023+512.755+511." + "099+512.679+511.193+512.679Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M682.086+512.679L852.64+512.679C852.734+512.679+852.81+512.755+852.81+512.849L852." + "81+683.403C852.81+683.496+852.734+683.573+852.64+683.573L682.086+683.573C681.993+683." + "573+681.916+683.496+681.916+683.403L681.916+512.849C681.916+512.755+681.993+512." + "679+682.086+512.679Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M852.979+512.679L1023.53+512.679C1023.63+512.679+1023.7+512.755+1023.7+512." + "849L1023.7+683.403C1023.7+683.496+1023.63+683.573+1023.53+683.573L852.979+683." + "573C852.886+683.573+852.81+683.496+852.81+683.403L852.81+512.849C852.81+512.755+852." + "886+512.679+852.979+512.679Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M-0.127371+683.573L170.426+683.573C170.52+683.573+170.596+683.649+170.596+683.7" + "42L170.596+854.296C170.596+854.39+170.52+854.466+170.426+854.466L-0.127371+854." + "466C-0.221207+854.466-0.297275+854.39-0.297275+854.296L-0.297275+683.742C-0.297275+" + "683.649-0.221207+683.573-0.127371+683.573Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M170.766+683.573L341.319+683.573C341.413+683.573+341.489+683.649+341.489+683.742L341." + "489+854.296C341.489+854.39+341.413+854.466+341.319+854.466L170.766+854.466C170.672+" + "854.466+170.596+854.39+170.596+854.296L170.596+683.742C170.596+683.649+170." + "672+683.573+170.766+683.573Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M341.064+683.573L511.618+683.573C511.712+683.573+511.788+683.649+511.788+683.742L511." + "788+854.296C511.788+854.39+511.712+854.466+511.618+854.466L341.064+854.466C340.971+854." + "466+340.894+854.39+340.894+854.296L340.894+683.742C340.894+683.649+340.971+683." + "573+341.064+683.573Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M511.957+683.573L682.511+683.573C682.605+683.573+682.681+683.649+682.681+683.742L682." + "681+854.296C682.681+854.39+682.605+854.466+682.511+854.466L511.957+854.466C511." + "864+854.466+511.788+854.39+511.788+854.296L511.788+683.742C511.788+683.649+511." + "864+683.573+511.957+683.573Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M682.851+683.573L853.404+683.573C853.498+683.573+853.574+683.649+853.574+683.742L853." + "574+854.296C853.574+854.39+853.498+854.466+853.404+854.466L682.851+854.466C682.757+854." + "466+682.681+854.39+682.681+854.296L682.681+683.742C682.681+683.649+682.757+683.573+" + "682.851+683.573Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M853.744+683.573L1024.3+683.573C1024.39+683.573+1024.47+683.649+1024.47+683.742L1024." + "47+854.296C1024.47+854.39+1024.39+854.466+1024.3+854.466L853.744+854.466C853.65+854." + "466+853.574+854.39+853.574+854.296L853.574+683.742C853.574+683.649+853.65+683." + "573+853.744+683.573Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M0.169904+853.107L170.723+853.107C170.817+853.107+170.893+853.183+170.893+853.277L170." + "893+1023.83C170.893+1023.92+170.817+1024+170.723+1024L0.169904+1024C0.0760688+1024" + "+0+1023.92+0+1023.83L0+853.277C0+853.183+0.0760688+853.107+0.169904+853.107Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M171.063+853.107L341.616+853.107C341.71+853.107+341.786+853.183+341.786+853.277L341." + "786+1023.83C341.786+1023.92+341.71+1024+341.616+1024L171.063+1024C170.969+1024+170." + "893+1023.92+170.893+1023.83L170.893+853.277C170.893+853.183+170.969+853.107+171." + "063+853.107Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M341.362+853.107L511.915+853.107C512.009+853.107+512.085+853.183+512.085+853.277L512." + "085+1023.83C512.085+1023.92+512.009+1024+511.915+1024L341.362+1024C341.268+1024+" + "341.192+1023.92+341.192+1023.83L341.192+853.277C341.192+853.183+341.268+853." + "107+341.362+853.107Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M512.255+853.107L682.808+853.107C682.902+853.107+682.978+853.183+682.978+853.277" + "L682.978+1023.83C682.978+1023.92+682.902+1024+682.808+1024L512.255+1024C512.161" + "+1024+512.085+1023.92+512.085+1023.83L512.085+853.277C512.085+853.183+512.161" + "+853.107+512.255+853.107Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M683.148+853.107L853.701+853.107C853.795+853.107+853.871+853.183+853.871+853." + "277L853.871+1023.83C853.871+1023.92+853.795+1024+853.701+1024L683.148+1024C683." + "054+1024+682.978+1023.92+682.978+1023.83L682.978+853.277C682.978+853.183+683." + "054+853.107+683.148+853.107Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  }), /*#__PURE__*/React__default.createElement("path", {
    className: `fill ${primary ? "primary" : "secondary"}`,
    d: "M854.041+853.107L1024.59+853.107C1024.69+853.107+1024.76+853.183+1024.76+" + "853.277L1024.76+1023.83C1024.76+1023.92+1024.69+1024+1024.59+1024L854.041+1024C853" + ".947+1024+853.871+1023.92+853.871+1023.83L853.871+853.277C853.871+853.183+853.947+853." + "107+854.041+853.107Z",
    strokeLinecap: "round",
    opacity: Math.random() * 0.2 + 0.8,
    strokeLinejoin: "round"
  })));
  /**
   * Generates the initials for the avatar.
   *
   * @returns the initials for the avatar
   */


  const generateInitials = name => {
    return name.charAt(0).toUpperCase();
  };

  return name ? /*#__PURE__*/React__default.createElement(Image, Object.assign({
    rounded: true,
    centered: true,
    className: "animated-avatar",
    "data-componentid": `${componentId}-with-initials`
  }, rest), /*#__PURE__*/React__default.createElement(AnimatedSVGBackground, null), /*#__PURE__*/React__default.createElement("span", {
    "data-componentid": `${componentId}-initials`,
    className: "initial"
  }, generateInitials(name))) : /*#__PURE__*/React__default.createElement(AnimatedSVGBackground, null);
};
AnimatedAvatar.defaultProps = {
  "data-componentid": "animated-avatar",
  size: "mini",
  verticalAlign: "middle"
};

var anObject$9 = anObject$k;

// `RegExp.prototype.flags` getter implementation
// https://tc39.es/ecma262/#sec-get-regexp.prototype.flags
var regexpFlags$1 = function () {
  var that = anObject$9(this);
  var result = '';
  if (that.hasIndices) result += 'd';
  if (that.global) result += 'g';
  if (that.ignoreCase) result += 'i';
  if (that.multiline) result += 'm';
  if (that.dotAll) result += 's';
  if (that.unicode) result += 'u';
  if (that.unicodeSets) result += 'v';
  if (that.sticky) result += 'y';
  return result;
};

var fails$l = fails$z;
var global$f = global$z;

// babel-minify and Closure Compiler transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
var $RegExp$2 = global$f.RegExp;

var UNSUPPORTED_Y$3 = fails$l(function () {
  var re = $RegExp$2('a', 'y');
  re.lastIndex = 2;
  return re.exec('abcd') != null;
});

// UC Browser bug
// https://github.com/zloirock/core-js/issues/1008
var MISSED_STICKY$1 = UNSUPPORTED_Y$3 || fails$l(function () {
  return !$RegExp$2('a', 'y').sticky;
});

var BROKEN_CARET = UNSUPPORTED_Y$3 || fails$l(function () {
  // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
  var re = $RegExp$2('^r', 'gy');
  re.lastIndex = 2;
  return re.exec('str') != null;
});

var regexpStickyHelpers = {
  BROKEN_CARET: BROKEN_CARET,
  MISSED_STICKY: MISSED_STICKY$1,
  UNSUPPORTED_Y: UNSUPPORTED_Y$3
};

var fails$k = fails$z;
var global$e = global$z;

// babel-minify and Closure Compiler transpiles RegExp('.', 's') -> /./s and it causes SyntaxError
var $RegExp$1 = global$e.RegExp;

var regexpUnsupportedDotAll = fails$k(function () {
  var re = $RegExp$1('.', 's');
  return !(re.dotAll && re.exec('\n') && re.flags === 's');
});

var fails$j = fails$z;
var global$d = global$z;

// babel-minify and Closure Compiler transpiles RegExp('(?<a>b)', 'g') -> /(?<a>b)/g and it causes SyntaxError
var $RegExp = global$d.RegExp;

var regexpUnsupportedNcg = fails$j(function () {
  var re = $RegExp('(?<a>b)', 'g');
  return re.exec('b').groups.a !== 'b' ||
    'b'.replace(re, '$<a>c') !== 'bc';
});

/* eslint-disable regexp/no-empty-capturing-group, regexp/no-empty-group, regexp/no-lazy-ends -- testing */
/* eslint-disable regexp/no-useless-quantifier -- testing */
var call$c = functionCall;
var uncurryThis$i = functionUncurryThis;
var toString$b = toString$d;
var regexpFlags = regexpFlags$1;
var stickyHelpers$2 = regexpStickyHelpers;
var shared = shared$4.exports;
var create$2 = objectCreate;
var getInternalState$4 = internalState.get;
var UNSUPPORTED_DOT_ALL$1 = regexpUnsupportedDotAll;
var UNSUPPORTED_NCG$1 = regexpUnsupportedNcg;

var nativeReplace = shared('native-string-replace', String.prototype.replace);
var nativeExec = RegExp.prototype.exec;
var patchedExec = nativeExec;
var charAt$7 = uncurryThis$i(''.charAt);
var indexOf = uncurryThis$i(''.indexOf);
var replace$6 = uncurryThis$i(''.replace);
var stringSlice$7 = uncurryThis$i(''.slice);

var UPDATES_LAST_INDEX_WRONG = (function () {
  var re1 = /a/;
  var re2 = /b*/g;
  call$c(nativeExec, re1, 'a');
  call$c(nativeExec, re2, 'a');
  return re1.lastIndex !== 0 || re2.lastIndex !== 0;
})();

var UNSUPPORTED_Y$2 = stickyHelpers$2.BROKEN_CARET;

// nonparticipating capturing group, copied from es5-shim's String#split patch.
var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;

var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y$2 || UNSUPPORTED_DOT_ALL$1 || UNSUPPORTED_NCG$1;

if (PATCH) {
  patchedExec = function exec(string) {
    var re = this;
    var state = getInternalState$4(re);
    var str = toString$b(string);
    var raw = state.raw;
    var result, reCopy, lastIndex, match, i, object, group;

    if (raw) {
      raw.lastIndex = re.lastIndex;
      result = call$c(patchedExec, raw, str);
      re.lastIndex = raw.lastIndex;
      return result;
    }

    var groups = state.groups;
    var sticky = UNSUPPORTED_Y$2 && re.sticky;
    var flags = call$c(regexpFlags, re);
    var source = re.source;
    var charsAdded = 0;
    var strCopy = str;

    if (sticky) {
      flags = replace$6(flags, 'y', '');
      if (indexOf(flags, 'g') === -1) {
        flags += 'g';
      }

      strCopy = stringSlice$7(str, re.lastIndex);
      // Support anchored sticky behavior.
      if (re.lastIndex > 0 && (!re.multiline || re.multiline && charAt$7(str, re.lastIndex - 1) !== '\n')) {
        source = '(?: ' + source + ')';
        strCopy = ' ' + strCopy;
        charsAdded++;
      }
      // ^(? + rx + ) is needed, in combination with some str slicing, to
      // simulate the 'y' flag.
      reCopy = new RegExp('^(?:' + source + ')', flags);
    }

    if (NPCG_INCLUDED) {
      reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
    }
    if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;

    match = call$c(nativeExec, sticky ? reCopy : re, strCopy);

    if (sticky) {
      if (match) {
        match.input = stringSlice$7(match.input, charsAdded);
        match[0] = stringSlice$7(match[0], charsAdded);
        match.index = re.lastIndex;
        re.lastIndex += match[0].length;
      } else re.lastIndex = 0;
    } else if (UPDATES_LAST_INDEX_WRONG && match) {
      re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
    }
    if (NPCG_INCLUDED && match && match.length > 1) {
      // Fix browsers whose `exec` methods don't consistently return `undefined`
      // for NPCG, like IE8. NOTE: This doesn't work for /(.?)?/
      call$c(nativeReplace, match[0], reCopy, function () {
        for (i = 1; i < arguments.length - 2; i++) {
          if (arguments[i] === undefined) match[i] = undefined;
        }
      });
    }

    if (match && groups) {
      match.groups = object = create$2(null);
      for (i = 0; i < groups.length; i++) {
        group = groups[i];
        object[group[0]] = match[group[1]];
      }
    }

    return match;
  };
}

var regexpExec$3 = patchedExec;

var $$c = _export;
var exec$5 = regexpExec$3;

// `RegExp.prototype.exec` method
// https://tc39.es/ecma262/#sec-regexp.prototype.exec
$$c({ target: 'RegExp', proto: true, forced: /./.exec !== exec$5 }, {
  exec: exec$5
});

// TODO: Remove from `core-js@4` since it's moved to entry points

var uncurryThis$h = functionUncurryThis;
var defineBuiltIn$7 = defineBuiltIn$d;
var regexpExec$2 = regexpExec$3;
var fails$i = fails$z;
var wellKnownSymbol$8 = wellKnownSymbol$n;
var createNonEnumerableProperty$4 = createNonEnumerableProperty$9;

var SPECIES$1 = wellKnownSymbol$8('species');
var RegExpPrototype$3 = RegExp.prototype;

var fixRegexpWellKnownSymbolLogic = function (KEY, exec, FORCED, SHAM) {
  var SYMBOL = wellKnownSymbol$8(KEY);

  var DELEGATES_TO_SYMBOL = !fails$i(function () {
    // String methods call symbol-named RegEp methods
    var O = {};
    O[SYMBOL] = function () { return 7; };
    return ''[KEY](O) != 7;
  });

  var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails$i(function () {
    // Symbol-named RegExp methods call .exec
    var execCalled = false;
    var re = /a/;

    if (KEY === 'split') {
      // We can't use real regex here since it causes deoptimization
      // and serious performance degradation in V8
      // https://github.com/zloirock/core-js/issues/306
      re = {};
      // RegExp[@@split] doesn't call the regex's exec method, but first creates
      // a new one. We need to return the patched regex when creating the new one.
      re.constructor = {};
      re.constructor[SPECIES$1] = function () { return re; };
      re.flags = '';
      re[SYMBOL] = /./[SYMBOL];
    }

    re.exec = function () { execCalled = true; return null; };

    re[SYMBOL]('');
    return !execCalled;
  });

  if (
    !DELEGATES_TO_SYMBOL ||
    !DELEGATES_TO_EXEC ||
    FORCED
  ) {
    var uncurriedNativeRegExpMethod = uncurryThis$h(/./[SYMBOL]);
    var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
      var uncurriedNativeMethod = uncurryThis$h(nativeMethod);
      var $exec = regexp.exec;
      if ($exec === regexpExec$2 || $exec === RegExpPrototype$3.exec) {
        if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
          // The native String method already delegates to @@method (this
          // polyfilled function), leasing to infinite recursion.
          // We avoid it by directly calling the native @@method method.
          return { done: true, value: uncurriedNativeRegExpMethod(regexp, str, arg2) };
        }
        return { done: true, value: uncurriedNativeMethod(str, regexp, arg2) };
      }
      return { done: false };
    });

    defineBuiltIn$7(String.prototype, KEY, methods[0]);
    defineBuiltIn$7(RegExpPrototype$3, SYMBOL, methods[1]);
  }

  if (SHAM) createNonEnumerableProperty$4(RegExpPrototype$3[SYMBOL], 'sham', true);
};

var isObject$6 = isObject$f;
var classof$6 = classofRaw$1;
var wellKnownSymbol$7 = wellKnownSymbol$n;

var MATCH$2 = wellKnownSymbol$7('match');

// `IsRegExp` abstract operation
// https://tc39.es/ecma262/#sec-isregexp
var isRegexp = function (it) {
  var isRegExp;
  return isObject$6(it) && ((isRegExp = it[MATCH$2]) !== undefined ? !!isRegExp : classof$6(it) == 'RegExp');
};

var uncurryThis$g = functionUncurryThis;
var toIntegerOrInfinity$4 = toIntegerOrInfinity$7;
var toString$a = toString$d;
var requireObjectCoercible$6 = requireObjectCoercible$9;

var charAt$6 = uncurryThis$g(''.charAt);
var charCodeAt$1 = uncurryThis$g(''.charCodeAt);
var stringSlice$6 = uncurryThis$g(''.slice);

var createMethod$3 = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = toString$a(requireObjectCoercible$6($this));
    var position = toIntegerOrInfinity$4(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = charCodeAt$1(S, position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size
      || (second = charCodeAt$1(S, position + 1)) < 0xDC00 || second > 0xDFFF
        ? CONVERT_TO_STRING
          ? charAt$6(S, position)
          : first
        : CONVERT_TO_STRING
          ? stringSlice$6(S, position, position + 2)
          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

var stringMultibyte = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod$3(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod$3(true)
};

var charAt$5 = stringMultibyte.charAt;

// `AdvanceStringIndex` abstract operation
// https://tc39.es/ecma262/#sec-advancestringindex
var advanceStringIndex$3 = function (S, index, unicode) {
  return index + (unicode ? charAt$5(S, index).length : 1);
};

var toPropertyKey$1 = toPropertyKey$4;
var definePropertyModule$1 = objectDefineProperty;
var createPropertyDescriptor$2 = createPropertyDescriptor$6;

var createProperty$2 = function (object, key, value) {
  var propertyKey = toPropertyKey$1(key);
  if (propertyKey in object) definePropertyModule$1.f(object, propertyKey, createPropertyDescriptor$2(0, value));
  else object[propertyKey] = value;
};

var toAbsoluteIndex$2 = toAbsoluteIndex$4;
var lengthOfArrayLike$7 = lengthOfArrayLike$a;
var createProperty$1 = createProperty$2;

var $Array$3 = Array;
var max$1 = Math.max;

var arraySliceSimple = function (O, start, end) {
  var length = lengthOfArrayLike$7(O);
  var k = toAbsoluteIndex$2(start, length);
  var fin = toAbsoluteIndex$2(end === undefined ? length : end, length);
  var result = $Array$3(max$1(fin - k, 0));
  for (var n = 0; k < fin; k++, n++) createProperty$1(result, n, O[k]);
  result.length = n;
  return result;
};

var call$b = functionCall;
var anObject$8 = anObject$k;
var isCallable$5 = isCallable$r;
var classof$5 = classofRaw$1;
var regexpExec$1 = regexpExec$3;

var $TypeError$4 = TypeError;

// `RegExpExec` abstract operation
// https://tc39.es/ecma262/#sec-regexpexec
var regexpExecAbstract = function (R, S) {
  var exec = R.exec;
  if (isCallable$5(exec)) {
    var result = call$b(exec, R, S);
    if (result !== null) anObject$8(result);
    return result;
  }
  if (classof$5(R) === 'RegExp') return call$b(regexpExec$1, R, S);
  throw $TypeError$4('RegExp#exec called on incompatible receiver');
};

var apply$2 = functionApply;
var call$a = functionCall;
var uncurryThis$f = functionUncurryThis;
var fixRegExpWellKnownSymbolLogic$3 = fixRegexpWellKnownSymbolLogic;
var anObject$7 = anObject$k;
var isNullOrUndefined$3 = isNullOrUndefined$8;
var isRegExp$2 = isRegexp;
var requireObjectCoercible$5 = requireObjectCoercible$9;
var speciesConstructor$2 = speciesConstructor$4;
var advanceStringIndex$2 = advanceStringIndex$3;
var toLength$6 = toLength$8;
var toString$9 = toString$d;
var getMethod$3 = getMethod$7;
var arraySlice$4 = arraySliceSimple;
var callRegExpExec = regexpExecAbstract;
var regexpExec = regexpExec$3;
var stickyHelpers$1 = regexpStickyHelpers;
var fails$h = fails$z;

var UNSUPPORTED_Y$1 = stickyHelpers$1.UNSUPPORTED_Y;
var MAX_UINT32 = 0xFFFFFFFF;
var min$1 = Math.min;
var $push = [].push;
var exec$4 = uncurryThis$f(/./.exec);
var push$6 = uncurryThis$f($push);
var stringSlice$5 = uncurryThis$f(''.slice);

// Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
// Weex JS has frozen built-in prototypes, so use try / catch wrapper
var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails$h(function () {
  // eslint-disable-next-line regexp/no-empty-group -- required for testing
  var re = /(?:)/;
  var originalExec = re.exec;
  re.exec = function () { return originalExec.apply(this, arguments); };
  var result = 'ab'.split(re);
  return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
});

// @@split logic
fixRegExpWellKnownSymbolLogic$3('split', function (SPLIT, nativeSplit, maybeCallNative) {
  var internalSplit;
  if (
    'abbc'.split(/(b)*/)[1] == 'c' ||
    // eslint-disable-next-line regexp/no-empty-group -- required for testing
    'test'.split(/(?:)/, -1).length != 4 ||
    'ab'.split(/(?:ab)*/).length != 2 ||
    '.'.split(/(.?)(.?)/).length != 4 ||
    // eslint-disable-next-line regexp/no-empty-capturing-group, regexp/no-empty-group -- required for testing
    '.'.split(/()()/).length > 1 ||
    ''.split(/.?/).length
  ) {
    // based on es5-shim implementation, need to rework it
    internalSplit = function (separator, limit) {
      var string = toString$9(requireObjectCoercible$5(this));
      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
      if (lim === 0) return [];
      if (separator === undefined) return [string];
      // If `separator` is not a regex, use native split
      if (!isRegExp$2(separator)) {
        return call$a(nativeSplit, string, separator, lim);
      }
      var output = [];
      var flags = (separator.ignoreCase ? 'i' : '') +
                  (separator.multiline ? 'm' : '') +
                  (separator.unicode ? 'u' : '') +
                  (separator.sticky ? 'y' : '');
      var lastLastIndex = 0;
      // Make `global` and avoid `lastIndex` issues by working with a copy
      var separatorCopy = new RegExp(separator.source, flags + 'g');
      var match, lastIndex, lastLength;
      while (match = call$a(regexpExec, separatorCopy, string)) {
        lastIndex = separatorCopy.lastIndex;
        if (lastIndex > lastLastIndex) {
          push$6(output, stringSlice$5(string, lastLastIndex, match.index));
          if (match.length > 1 && match.index < string.length) apply$2($push, output, arraySlice$4(match, 1));
          lastLength = match[0].length;
          lastLastIndex = lastIndex;
          if (output.length >= lim) break;
        }
        if (separatorCopy.lastIndex === match.index) separatorCopy.lastIndex++; // Avoid an infinite loop
      }
      if (lastLastIndex === string.length) {
        if (lastLength || !exec$4(separatorCopy, '')) push$6(output, '');
      } else push$6(output, stringSlice$5(string, lastLastIndex));
      return output.length > lim ? arraySlice$4(output, 0, lim) : output;
    };
  // Chakra, V8
  } else if ('0'.split(undefined, 0).length) {
    internalSplit = function (separator, limit) {
      return separator === undefined && limit === 0 ? [] : call$a(nativeSplit, this, separator, limit);
    };
  } else internalSplit = nativeSplit;

  return [
    // `String.prototype.split` method
    // https://tc39.es/ecma262/#sec-string.prototype.split
    function split(separator, limit) {
      var O = requireObjectCoercible$5(this);
      var splitter = isNullOrUndefined$3(separator) ? undefined : getMethod$3(separator, SPLIT);
      return splitter
        ? call$a(splitter, separator, O, limit)
        : call$a(internalSplit, toString$9(O), separator, limit);
    },
    // `RegExp.prototype[@@split]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@split
    //
    // NOTE: This cannot be properly polyfilled in engines that don't support
    // the 'y' flag.
    function (string, limit) {
      var rx = anObject$7(this);
      var S = toString$9(string);
      var res = maybeCallNative(internalSplit, rx, S, limit, internalSplit !== nativeSplit);

      if (res.done) return res.value;

      var C = speciesConstructor$2(rx, RegExp);

      var unicodeMatching = rx.unicode;
      var flags = (rx.ignoreCase ? 'i' : '') +
                  (rx.multiline ? 'm' : '') +
                  (rx.unicode ? 'u' : '') +
                  (UNSUPPORTED_Y$1 ? 'g' : 'y');

      // ^(? + rx + ) is needed, in combination with some S slicing, to
      // simulate the 'y' flag.
      var splitter = new C(UNSUPPORTED_Y$1 ? '^(?:' + rx.source + ')' : rx, flags);
      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
      if (lim === 0) return [];
      if (S.length === 0) return callRegExpExec(splitter, S) === null ? [S] : [];
      var p = 0;
      var q = 0;
      var A = [];
      while (q < S.length) {
        splitter.lastIndex = UNSUPPORTED_Y$1 ? 0 : q;
        var z = callRegExpExec(splitter, UNSUPPORTED_Y$1 ? stringSlice$5(S, q) : S);
        var e;
        if (
          z === null ||
          (e = min$1(toLength$6(splitter.lastIndex + (UNSUPPORTED_Y$1 ? q : 0)), S.length)) === p
        ) {
          q = advanceStringIndex$2(S, q, unicodeMatching);
        } else {
          push$6(A, stringSlice$5(S, p, q));
          if (A.length === lim) return A;
          for (var i = 1; i <= z.length - 1; i++) {
            push$6(A, z[i]);
            if (A.length === lim) return A;
          }
          q = p = e;
        }
      }
      push$6(A, stringSlice$5(S, p));
      return A;
    }
  ];
}, !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC, UNSUPPORTED_Y$1);

var _circle, _path$8;

function _extends$9() { _extends$9 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$9.apply(this, arguments); }

var SvgCameraIcon = function SvgCameraIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$9({
    className: "camera-icon_svg__icon",
    height: 14,
    width: 14,
    viewBox: "0 0 512 512",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), _circle || (_circle = /*#__PURE__*/React.createElement("circle", {
    className: "camera-icon_svg__path",
    cx: 256,
    cy: 296,
    r: 81
  })), _path$8 || (_path$8 = /*#__PURE__*/React.createElement("path", {
    className: "camera-icon_svg__path",
    d: "m374.297 91-5.177-25.883C366.326 51.143 353.954 41 339.703 41H172.297c-14.25 0-26.623 10.143-29.417 24.117L137.703 91zM467 121H45c-24.813 0-45 20.187-45 45v260c0 24.813 20.187 45 45 45h422c24.813 0 45-20.187 45-45V166c0-24.813-20.187-45-45-45zm-339 94H80c-8.284 0-15-6.716-15-15s6.716-15 15-15h48c8.284 0 15 6.716 15 15s-6.716 15-15 15zm128 192c-61.206 0-111-49.794-111-111s49.794-111 111-111 111 49.794 111 111-49.794 111-111 111z"
  })));
};

const AVATAR_MODULE_CSS_CLASS = "ui-avatar";
/**
 * Avatar component.
 *
 * @param props - Props passed in to the Avatar component.
 * @returns Avatar component.
 */

const Avatar = props => {
  const {
    avatar,
    avatarInitialsLimit,
    children,
    className,
    defaultIcon,
    editable,
    editIcon,
    editIconSize,
    hoverable,
    image,
    initialsColor,
    inline,
    isLoading,
    label,
    name,
    onEditIconClick,
    onClick,
    onMouseOver,
    onMouseOut,
    overflow,
    relaxed,
    rounded,
    shape,
    size,
    spaced,
    transparent,
    width,
    withBackgroundImage,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["avatar", "avatarInitialsLimit", "children", "className", "defaultIcon", "editable", "editIcon", "editIconSize", "hoverable", "image", "initialsColor", "inline", "isLoading", "label", "name", "onEditIconClick", "onClick", "onMouseOver", "onMouseOut", "overflow", "relaxed", "rounded", "shape", "size", "spaced", "transparent", "width", "withBackgroundImage", "data-componentid", "data-testid"]);

  const [isImageValidUrl, setIsImageValidUrl] = useState(false);
  const relaxLevel = relaxed && relaxed === true ? "" : relaxed;
  const wrapperClasses = classNames(`${AVATAR_MODULE_CSS_CLASS}-wrapper`, {
    inline
  }, className);
  const containerClasses = classNames(`${AVATAR_MODULE_CSS_CLASS}-container`, {
    [shape]: shape
  });
  const imgElementClasses = classNames(AVATAR_MODULE_CSS_CLASS, {
    "hoverable": hoverable !== false && onClick !== undefined,
    [`initials-color-${initialsColor}`]: initialsColor,
    relaxed,
    rounded,
    [`${size}`]: size,
    [`spaced-${spaced}`]: spaced,
    [shape]: shape,
    transparent,
    [`${relaxLevel}`]: relaxLevel,
    "with-background-image": withBackgroundImage,
    [`overflow-${overflow}`]: overflow
  });
  const innerImageClasses = classNames("inner-image", {
    [`width-${width}`]: width
  });
  /**
   * Check if `image` is a valid image URL.
   */

  useEffect(() => {
    if (image) {
      if ( /*#__PURE__*/React__default.isValidElement(image)) {
        setIsImageValidUrl(false);
      } else {
        ImageUtils.isValidImageURL(image, isValid => {
          setIsImageValidUrl(isValid);
        });
      }
    }
  }, [image]); // If loading, show the placeholder.

  if (isLoading) {
    return /*#__PURE__*/React__default.createElement(Image, {
      className: imgElementClasses,
      circular: shape === "circular",
      "data-componentid": `${componentId}-loading`,
      "data-testid": `${testId}-loading`
    }, /*#__PURE__*/React__default.createElement(Placeholder, {
      "data-componentid": `${componentId}-loading-placeholder`,
      "data-testid": `${testId}-loading-placeholder`
    }, /*#__PURE__*/React__default.createElement(Placeholder.Image, {
      square: true
    })));
  }
  /**
   * Generates the initials for the avatar. If the name
   * contains two or more words, two letter initial will
   * be generated using the first two words of the name.
   * i.e For the name "Brion Silva", "BS" will be generated.
   * If the name only has one word, then only a single initial
   * will be generated. i.e For "Brion", "B" will be generated.
   *
   * @returns Initials based on the name.
   */


  const generateInitials = () => {
    const nameParts = name.split(" ");

    if (avatarInitialsLimit === 2 && nameParts.length >= 2) {
      return (nameParts[0].charAt(0) + nameParts[1].charAt(0)).toUpperCase();
    }

    return name.charAt(0).toUpperCase();
  };
  /**
   * Renders a floating edit icon.
   *
   * @returns Edit bubble component.
   */


  const renderEditBubble = () => editable && /*#__PURE__*/React__default.createElement("div", {
    className: "edit-icon-container"
  }, /*#__PURE__*/React__default.createElement(GenericIcon, {
    link: true,
    inline: true,
    hoverable: true,
    shape: "circular",
    fill: "default",
    icon: editIcon !== null && editIcon !== void 0 ? editIcon : SvgCameraIcon,
    size: editIconSize,
    onClick: onEditIconClick !== null && onEditIconClick !== void 0 ? onEditIconClick : onClick
  }));
  /**
   * Renders a floating custom label.
   *
   * @returns Custom label.
   */


  const renderCustomLabel = () => label && /*#__PURE__*/React__default.createElement("div", {
    className: "custom-label"
  }, /*#__PURE__*/React__default.createElement(Image, {
    avatar: true,
    circular: true,
    size: "mini",
    src: label
  }));

  if ( /*#__PURE__*/React__default.isValidElement(image)) {
    return /*#__PURE__*/React__default.createElement("div", {
      className: wrapperClasses
    }, /*#__PURE__*/React__default.createElement("div", {
      className: containerClasses
    }, /*#__PURE__*/React__default.createElement(Image, Object.assign({
      className: imgElementClasses,
      circular: shape === "circular",
      onClick: onClick,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut,
      "data-componentid": componentId,
      "data-testid": testId
    }, rest), /*#__PURE__*/React__default.createElement("div", {
      className: "inner-content",
      "data-componentid": `${componentId}-inner-content`,
      "data-testid": `${testId}-inner-content`
    }, image)), renderEditBubble()));
  }

  if (image && isImageValidUrl) {
    return /*#__PURE__*/React__default.createElement("div", {
      className: wrapperClasses
    }, /*#__PURE__*/React__default.createElement("div", {
      className: containerClasses
    }, renderCustomLabel(), /*#__PURE__*/React__default.createElement(Image, Object.assign({
      className: imgElementClasses,
      circular: shape === "circular",
      onClick: onClick,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut,
      "data-componentid": componentId,
      "data-testid": testId
    }, rest), /*#__PURE__*/React__default.createElement("div", {
      className: "inner-content",
      "data-componentid": `${componentId}-inner-content`,
      "data-testid": `${testId}-inner-content`
    }, children, /*#__PURE__*/React__default.createElement("img", {
      className: innerImageClasses,
      alt: "avatar",
      src: image
    }))), renderEditBubble()));
  }

  if (avatar && name) {
    return /*#__PURE__*/React__default.createElement("div", {
      className: wrapperClasses
    }, /*#__PURE__*/React__default.createElement("div", {
      className: containerClasses
    }, /*#__PURE__*/React__default.createElement(Image, Object.assign({
      centered: true,
      className: imgElementClasses,
      verticalAlign: "middle",
      circular: shape === "circular",
      onClick: onClick,
      onMouseOver: onMouseOver,
      onMouseOut: onMouseOut,
      "data-componentid": componentId,
      "data-testid": testId
    }, rest), children, /*#__PURE__*/React__default.createElement("span", {
      className: "initials",
      "data-componentid": `${componentId}-initials`,
      "data-testid": `${testId}-initials`
    }, generateInitials())), renderEditBubble()));
  }

  return /*#__PURE__*/React__default.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/React__default.createElement("div", {
    className: containerClasses
  }, /*#__PURE__*/React__default.createElement(Image, Object.assign({
    centered: true,
    className: imgElementClasses,
    verticalAlign: "middle",
    circular: shape === "circular",
    onClick: onClick,
    onMouseOver: onMouseOver,
    onMouseOut: onMouseOut,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), /*#__PURE__*/React__default.createElement("div", {
    className: "content-wrapper",
    "data-componentid": `${componentId}-image-content-wrapper`,
    "data-testid": `${testId}-image-content-wrapper`
  }, children, /*#__PURE__*/React__default.createElement("img", {
    className: innerImageClasses,
    alt: "avatar",
    src: defaultIcon,
    "data-componentid": `${componentId}-image`,
    "data-testid": `${testId}-image`
  }))), renderEditBubble()));
};
/**
 * Default prop types for the Avatar component.
 */

Avatar.defaultProps = {
  avatar: false,
  avatarInitialsLimit: 1,
  bordered: true,
  className: "",
  "data-componentid": "avatar",
  "data-testid": "avatar",
  editIconSize: "micro",
  initialsColor: "white",
  inline: true,
  isLoading: false,
  label: null,
  onClick: null,
  onMouseOut: null,
  onMouseOver: null,
  relaxed: false,
  shape: "circular",
  size: "mini",
  spaced: null,
  style: {},
  transparent: false
};

var img$4 = "data:image/png;base64,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";

var img$3 = "data:image/svg+xml,%3c!-- * Copyright (c) 2020%2c WSO2 Inc. (http://www.wso2.org) All Rights Reserved. * * WSO2 Inc. licenses this file to you under the Apache License%2c * Version 2.0 (the 'License')%3b you may not use this file except * in compliance with the License. * You may obtain a copy of the License at * * http://www.apache.org/licenses/LICENSE-2.0 * * Unless required by applicable law or agreed to in writing%2c * software distributed under the License is distributed on an * 'AS IS' BASIS%2c WITHOUT WARRANTIES OR CONDITIONS OF ANY * KIND%2c either express or implied. See the License for the * specific language governing permissions and limitations * under the License.--%3e%3csvg class='icon' id='code-icon' height='14px' viewBox='0 -30 512 511' width='14px' xmlns='http://www.w3.org/2000/svg'%3e %3cpath class='path fill primary' fill='white' d='m60.035156 60.546875h30.023438v30h-30.023438zm0 0'/%3e %3cpath class='path fill primary' fill='white' d='m120.085938 60.546875h30.023437v30h-30.023437zm0 0'/%3e %3cpath class='path fill primary' fill='white' d='m180.132812 60.546875h30.023438v30h-30.023438zm0 0'/%3e %3cpath class='path fill secondary' fill='white' d='m0 .5v451.953125h512v-451.953125zm482 30v90.097656h-452v-90.097656zm-452 391.953125v-271.855469h452v271.855469zm0 0'/%3e %3cpath class='path fill primary' fill='white' d='m187.644531 196.867188-70.550781 89.65625 70.550781 89.65625 23.574219-18.550782-55.949219-71.105468 55.949219-71.105469zm0 0'/%3e %3cpath class='path fill primary' fill='white' d='m300.78125 215.417969 55.949219 71.105469-55.949219 71.105468 23.574219 18.550782 70.550781-89.65625-70.550781-89.65625zm0 0'/%3e %3cpath class='path fill secondary' fill='white' d='m241 196.46875h30v180.109375h-30zm0 0'/%3e%3c/svg%3e";

/**
 * App Avatar component.
 *
 * @param props - Props injected in to the app avatar component.
 *
 * @returns the App Avatar component
 */

const AppAvatar = props => {
  const {
    image,
    children,
    className,
    name,
    onCard,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["image", "children", "className", "name", "onCard", "data-componentid", "data-testid"]);

  const appAvatarClassNames = classNames(className);

  if (image) {
    return /*#__PURE__*/React__default.createElement(Avatar, Object.assign({
      avatar: true,
      image: image,
      bordered: false,
      initialsColor: onCard ? "primary" : "white",
      withBackgroundImage: !onCard,
      "data-componentid": componentId,
      "data-testid": testId
    }, rest), children);
  }

  return /*#__PURE__*/React__default.createElement(Avatar, Object.assign({
    avatar: true,
    bordered: true,
    className: appAvatarClassNames,
    style: onCard ? {} : {
      backgroundImage: `url(${img$4})`
    },
    name: name,
    initialsColor: onCard ? "primary" : "white",
    withBackgroundImage: !onCard,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), children);
};
/**
 * Default proptypes for the App avatar component.
 */

AppAvatar.defaultProps = {
  "data-componentid": "app-avatar",
  "data-testid": "app-avatar",
  defaultIcon: img$3,
  image: null,
  name: null,
  onCard: false,
  overflow: "hidden",
  rounded: true,
  shape: "square",
  width: "full"
};

var $$b = _export;
var $includes = arrayIncludes.includes;
var fails$g = fails$z;
var addToUnscopables = addToUnscopables$2;

// FF99+ bug
var BROKEN_ON_SPARSE = fails$g(function () {
  return !Array(1).includes();
});

// `Array.prototype.includes` method
// https://tc39.es/ecma262/#sec-array.prototype.includes
$$b({ target: 'Array', proto: true, forced: BROKEN_ON_SPARSE }, {
  includes: function includes(el /* , fromIndex = 0 */) {
    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
  }
});

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('includes');

var isRegExp$1 = isRegexp;

var $TypeError$3 = TypeError;

var notARegexp = function (it) {
  if (isRegExp$1(it)) {
    throw $TypeError$3("The method doesn't accept regular expressions");
  } return it;
};

var wellKnownSymbol$6 = wellKnownSymbol$n;

var MATCH$1 = wellKnownSymbol$6('match');

var correctIsRegexpLogic = function (METHOD_NAME) {
  var regexp = /./;
  try {
    '/./'[METHOD_NAME](regexp);
  } catch (error1) {
    try {
      regexp[MATCH$1] = false;
      return '/./'[METHOD_NAME](regexp);
    } catch (error2) { /* empty */ }
  } return false;
};

var $$a = _export;
var uncurryThis$e = functionUncurryThis;
var notARegExp = notARegexp;
var requireObjectCoercible$4 = requireObjectCoercible$9;
var toString$8 = toString$d;
var correctIsRegExpLogic = correctIsRegexpLogic;

var stringIndexOf$2 = uncurryThis$e(''.indexOf);

// `String.prototype.includes` method
// https://tc39.es/ecma262/#sec-string.prototype.includes
$$a({ target: 'String', proto: true, forced: !correctIsRegExpLogic('includes') }, {
  includes: function includes(searchString /* , position = 0 */) {
    return !!~stringIndexOf$2(
      toString$8(requireObjectCoercible$4(this)),
      toString$8(notARegExp(searchString)),
      arguments.length > 1 ? arguments[1] : undefined
    );
  }
});

var img$2 = "data:image/png;base64,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";

var img$1 = "data:image/png;base64,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";

/**
 * User Avatar component.
 *
 * @param props - Props injected in to the user avatar component.
 *
 * @returns the User Avatar component
 */

const UserAvatar = props => {
  const {
    authState,
    children,
    className,
    gravatarInfoPopoverText,
    name,
    image,
    profileInfo,
    showGravatarLabel,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["authState", "children", "className", "gravatarInfoPopoverText", "name", "image", "profileInfo", "showGravatarLabel", "data-componentid", "data-testid"]);

  const classes = classNames(className);
  const [userImage, setUserImage] = useState(null);
  const [showPopup, setShowPopup] = useState(false); // Check if the image is a promise, and resolve.

  useEffect(() => {
    if (image instanceof Promise) {
      image.then(response => {
        setUserImage(response);
      }).catch(() => {
        setUserImage(null);
      });
    }
  }, [image]);
  /**
   * Checks if the image is from `Gravatar`.
   *
   * @returns whether the image is from Gravatar
   */

  const isGravatarURL = () => {
    return userImage && userImage.includes(UIConstants.GRAVATAR_URL) || profileInfo && profileInfo.userImage && profileInfo.userImage.includes(UIConstants.GRAVATAR_URL) || profileInfo && profileInfo.profileUrl && profileInfo.profileUrl.includes(UIConstants.GRAVATAR_URL);
  };
  /**
   * Resolves the top label image.
   *
   * @returns the resolved image
   */


  const resolveTopLabel = () => {
    if (isGravatarURL()) {
      return img$2;
    }

    return null;
  };
  /**
   * Resolves the user image for the avatar.
   * @returns the resolved user image for the avatar.
   */


  const resolveAvatarImage = () => {
    // If an image is directly passed, give prominence.
    if (image && !(image instanceof Promise)) {
      return image;
    }

    if (profileInfo) {
      if (profileInfo.profileUrl) {
        return profileInfo.profileUrl;
      } else if (profileInfo.userImage) {
        return profileInfo.userImage;
      }
    }

    return userImage;
  };
  /**
   * Handles the mouse over event.
   */


  const handleOnMouseOver = () => {
    setShowPopup(true);
  };
  /**
   * Handles the mouse out event.
   */


  const handleOnMouseOut = () => {
    setShowPopup(false);
  };

  return /*#__PURE__*/React__default.createElement(Popup, {
    content: gravatarInfoPopoverText,
    position: "top center",
    size: "mini",
    disabled: !(showGravatarLabel && isGravatarURL()),
    inverted: true,
    hoverable: true,
    open: showPopup,
    trigger: /*#__PURE__*/React__default.createElement(Avatar, Object.assign({
      avatar: true,
      shape: "circular",
      bordered: false,
      className: classes,
      image: resolveAvatarImage(),
      label: showGravatarLabel ? resolveTopLabel() : null,
      name: profileInfo ? resolveUserDisplayName(profileInfo, authState) : name || "",
      onMouseOver: handleOnMouseOver,
      onMouseOut: handleOnMouseOut,
      "data-componentid": componentId,
      "data-testid": testId
    }, rest), children),
    "data-componentid": `${componentId}-gravatar-disclaimer-popup`,
    "data-testid": `${testId}-gravatar-disclaimer-popup`
  });
};
/**
 * Default prop types for the User avatar component.
 */

UserAvatar.defaultProps = {
  authState: null,
  "data-componentid": "user-avatar",
  "data-testid": "user-avatar",
  defaultIcon: img$1,
  gravatarInfoPopoverText: null,
  name: null,
  profileInfo: null,
  showGravatarLabel: false
};

var _path$7, _path2$3, _path3;

function _extends$8() { _extends$8 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$8.apply(this, arguments); }

var SvgCookieIcon = function SvgCookieIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$8({
    className: "cookie-icon_svg__icon",
    width: 14,
    height: 14,
    viewBox: "0 0 514.374 514.374",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), _path$7 || (_path$7 = /*#__PURE__*/React.createElement("path", {
    className: "cookie-icon_svg__path",
    d: "M171.277 17.756A185.963 185.963 0 0 1 203.153 15c7.847 0 15.584.503 23.187 1.465l-6.036 14.563c-3.619 8.734-2.347 18.86 3.321 26.426 5.115 6.831 13.219 10.768 21.594 10.768 1.712 0 3.436-.165 5.146-.502l9.026-1.782a26.876 26.876 0 0 0 20.472-18.39l4.279-13.734c57.572 28.316 98.536 85.863 102.74 153.728a7.5 7.5 0 1 0 14.971-.928C395.372 81.971 308.092 0 203.153 0c-11.53 0-23.123 1.002-34.454 2.98a7.5 7.5 0 1 0 2.578 14.776zm94.265 25.33a11.89 11.89 0 0 1-9.056 8.136l-9.026 1.782c-4.462.879-9.104-.902-11.829-4.542a11.952 11.952 0 0 1-1.47-11.691l7.348-17.73a182.859 182.859 0 0 1 28.821 8.678zM97.583 349.933c-49.174-34.484-78.531-90.87-78.531-150.832 0-77.761 49.211-147.491 122.456-173.515a7.501 7.501 0 0 0-5.021-14.135C57.274 39.596 4.052 115.006 4.052 199.101c0 64.847 31.745 125.824 84.918 163.113a7.465 7.465 0 0 0 4.3 1.36 7.5 7.5 0 0 0 4.313-13.641z"
  })), _path2$3 || (_path2$3 = /*#__PURE__*/React.createElement("path", {
    className: "cookie-icon_svg__path",
    d: "M481.048 211.363a14.95 14.95 0 0 0-12.647-7.17c-5.266-.065-10.203 2.587-13.093 7.075-5.885 9.135-15.873 14.588-26.718 14.588a31.83 31.83 0 0 1-23.517-10.416c-4.986-5.491-12.764-7.403-19.815-4.875a34.93 34.93 0 0 1-11.82 2.046c-19.355 0-35.103-15.747-35.103-35.091l.003-2.071c.012-8.067-5.051-15.283-12.597-17.957-9.541-3.381-15.952-12.458-15.952-22.572l.006-3.241a14.746 14.746 0 0 0-4.761-10.862 14.796 14.796 0 0 0-11.254-3.83c-64.588 5.608-122.569 42.597-155.1 98.945-.105.183-.203.37-.293.561l-13.642 29.031c-.089.19-.171.384-.244.582-15.041 40.556-16.387 84.891-3.891 128.213 16.089 55.775 74.32 114.578 129.81 131.083 20.105 5.98 40.585 8.974 60.83 8.973 18.536 0 36.876-2.51 54.544-7.536a7.5 7.5 0 0 0-4.104-14.428c-34.22 9.734-71.219 9.253-106.994-1.388-50.286-14.957-105.09-70.305-119.674-120.862-11.57-40.112-10.381-81.099 3.435-118.547l13.369-28.452c30.065-51.877 83.47-85.946 142.967-91.206l-.005 2.952c0 16.468 10.426 31.226 25.942 36.724 1.562.553 2.608 2.079 2.606 3.796l-.003 2.082c0 27.626 22.476 50.102 50.103 50.102 5.789 0 11.47-.985 16.884-2.927 1.342-.48 2.739-.16 3.647.84 8.85 9.743 21.469 15.331 34.621 15.331 15.967 0 30.669-8.024 39.328-21.465.165-.256.356-.195.345-.184 17.702 28.856 27.059 62.091 27.059 96.111 0 35.359-10.048 69.702-29.059 99.314-18.518 28.846-44.601 51.92-75.429 66.73a7.5 7.5 0 1 0 6.495 13.521c33.335-16.013 61.537-40.961 81.557-72.147 20.565-32.035 31.436-69.179 31.436-107.417.002-36.791-10.12-72.738-29.272-103.956zM132.273 119.812a19.407 19.407 0 0 0 13.812 5.722c10.771 0 19.534-8.763 19.534-19.534V79.544c0-10.771-8.763-19.533-19.534-19.533H131.33c-10.771 0-19.534 8.763-19.534 19.533v11.7a19.404 19.404 0 0 0 5.722 13.812zm-5.477-40.268c0-2.5 2.034-4.533 4.534-4.533h14.755c2.5 0 4.534 2.034 4.534 4.533V106a4.54 4.54 0 0 1-4.534 4.534 4.503 4.503 0 0 1-3.205-1.328l-14.755-14.755a4.506 4.506 0 0 1-1.329-3.206zM92.299 199.057c6.321-6.195 7.868-15.656 3.851-23.542l-2.169-4.257c-4.287-8.417-13.68-12.694-22.845-10.403l-6.848 1.712c-6.092 1.523-11.197 5.882-13.656 11.66l-1.827 4.294a20.163 20.163 0 0 0 6.214 23.832l5.062 3.916a20.082 20.082 0 0 0 12.313 4.188c5.132 0 10.246-1.936 14.122-5.734zM81.8 188.344l-5.781 5.666a5.174 5.174 0 0 1-6.76.395l-5.062-3.917a5.154 5.154 0 0 1-1.589-6.093l1.827-4.294a5.18 5.18 0 0 1 3.492-2.981l6.848-1.712a5.127 5.127 0 0 1 5.841 2.66l2.169 4.257a5.132 5.132 0 0 1-.985 6.019z"
  })), _path3 || (_path3 = /*#__PURE__*/React.createElement("path", {
    className: "cookie-icon_svg__path",
    d: "M226.195 285.933c-2.69 6.346-2.375 13.474.864 19.558s8.978 10.325 15.744 11.635l14.477 2.804a22.817 22.817 0 0 0 17.705-3.942 22.807 22.807 0 0 0 9.186-15.64l1.442-11.892c1.215-10.02-4.431-19.758-13.729-23.682l-10.233-4.319c-11.53-4.866-24.885.55-29.771 12.071zm13.81 5.855 5.685-13.407c1.247-2.943 4.119-4.714 7.133-4.714 1.001 0 2.018.195 2.995.608l10.233 4.319a7.767 7.767 0 0 1 4.671 8.056l-1.442 11.892a7.66 7.66 0 0 1-3.125 5.321 7.653 7.653 0 0 1-6.023 1.341l-14.477-2.804a7.696 7.696 0 0 1-5.355-3.958 7.7 7.7 0 0 1-.295-6.654zM395.671 407.602l12.662-15.051a22.864 22.864 0 0 0-1.011-30.618l-10.824-11.266c-4.299-4.475-10.083-6.974-16.288-7.036-6.172-.091-12.04 2.32-16.428 6.708l-12.521 12.519c-8.134 8.134-8.957 21.126-1.915 30.222l10.681 13.797a22.807 22.807 0 0 0 18.123 8.884 22.797 22.797 0 0 0 17.521-8.159zm-17.689-6.842a7.874 7.874 0 0 1-6.093-3.065l-10.681-13.797a7.924 7.924 0 0 1 .66-10.433l12.521-12.519a7.844 7.844 0 0 1 5.589-2.316h.082a7.846 7.846 0 0 1 5.622 2.428l10.824 11.265a7.893 7.893 0 0 1 .349 10.569l-12.662 15.051a7.945 7.945 0 0 1-6.211 2.817zM372.829 310.49c5.977 0 11.294-3.11 14.224-8.319 2.929-5.209 2.825-11.368-.279-16.475l-8.315-13.68a16.262 16.262 0 0 0-17.801-7.38l-9.601 2.335a16.26 16.26 0 0 0-12.297 18.163l1.621 11.347c1.143 7.987 8.087 14.009 16.154 14.009zm-17.599-16.131-1.621-11.346a1.313 1.313 0 0 1 .993-1.467l9.6-2.335h.001a1.31 1.31 0 0 1 1.436.596l8.315 13.681c.266.437.273.885.023 1.331-.251.446-.638.672-1.149.672h-16.294a1.326 1.326 0 0 1-1.304-1.132zM462.234 327.042a18.128 18.128 0 0 0-.511-14.034l-5.433-11.809a18.333 18.333 0 0 0-10.694-9.651 18.334 18.334 0 0 0-14.364 1.108l-7.131 3.735a18.13 18.13 0 0 0-8.997 10.861 18.125 18.125 0 0 0 1.427 14.03l5.994 11.03c3.278 6.033 9.588 9.525 16.105 9.525 2.498 0 5.028-.513 7.428-1.593l6.571-2.957a18.137 18.137 0 0 0 9.605-10.245zm-14.047-5.262a3.242 3.242 0 0 1-1.713 1.828l-6.571 2.957a3.27 3.27 0 0 1-4.198-1.415l-5.994-11.031c-.567-1.043-.403-2.016-.255-2.503s.554-1.387 1.605-1.938l7.132-3.736a3.234 3.234 0 0 1 2.562-.197 3.234 3.234 0 0 1 1.908 1.722l5.433 11.809a3.244 3.244 0 0 1 .091 2.504zM244.91 418.475l10.68 4.665a23.86 23.86 0 0 0 9.573 2.006c8.774 0 17.199-4.834 21.408-13.117l5.105-10.046c2.954-5.815 3.424-12.417 1.322-18.592-2.102-6.174-6.501-11.119-12.389-13.923l-10.494-4.999c-11.82-5.631-25.736-.903-31.68 10.76l-5.291 10.38a24.074 24.074 0 0 0-1.213 18.973 24.085 24.085 0 0 0 12.979 13.893zm1.598-26.055 5.292-10.38a8.93 8.93 0 0 1 7.972-4.917c1.303 0 2.63.286 3.893.887l10.494 4.999a8.906 8.906 0 0 1 4.64 5.215 8.91 8.91 0 0 1-.495 6.963l-5.105 10.046c-2.152 4.236-7.251 6.063-11.603 4.162l-10.68-4.666c-2.292-1.001-4.018-2.849-4.86-5.204s-.682-4.877.452-7.105zM249.796 220.599h10.427c8.156 0 15.107-5.557 16.903-13.512l4.353-19.274a17.285 17.285 0 0 0-5.653-16.999 17.289 17.289 0 0 0-17.677-2.913l-14.778 5.901c-6.624 2.645-10.903 8.962-10.903 16.094v13.374c-.001 9.555 7.773 17.329 17.328 17.329zm-2.329-30.703c0-.959.575-1.808 1.466-2.164l14.778-5.901c.323-.129.622-.181.894-.181.685 0 1.197.328 1.482.572.4.341 1.03 1.091.761 2.285l-4.353 19.275a2.318 2.318 0 0 1-2.272 1.816h-10.427a2.332 2.332 0 0 1-2.329-2.329zM217.687 87.911h-7.778c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h7.778c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5zM294.273 75.346c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h9.573c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5zM119.621 158.555h11.908c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5h-11.908c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5zM65.712 244.073c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h7.059c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5zM80.67 128.04c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5h-7.899c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5zM206.041 244.393a7.5 7.5 0 0 0-7.5-7.5h-8.975c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h8.975a7.5 7.5 0 0 0 7.5-7.5zM198.541 358.63h7.778c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5h-7.778c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5zM311.221 346.429c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5h-12.162c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5zM308.034 463.102h7.181c4.143 0 7.5-3.358 7.5-7.5s-3.357-7.5-7.5-7.5h-7.181c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5zM446.247 367.328h-7.393c-4.143 0-7.5 3.358-7.5 7.5s3.357 7.5 7.5 7.5h7.393a7.5 7.5 0 0 0 0-15z"
  })));
};

/**
 * Cookie consent cookie name.
 */

const COOKIE_CONSENT_COOKIE_NAME = "accepts-cookies";
/**
 * Banner to get consent for Cookie usage.
 *
 * @param props - Props injected to the components.
 *
 * @returns CookieConsentBanner React Component
 */

const CookieConsentBanner = props => {
  const {
    className,
    confirmButtonText,
    domain,
    domainCookie,
    id,
    inverted,
    style,
    title,
    position,
    onConfirmButtonClick,
    storageStrategy,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["className", "confirmButtonText", "domain", "domainCookie", "id", "inverted", "style", "title", "position", "onConfirmButtonClick", "storageStrategy", "data-componentid", "data-testid"]);

  const [show, setShow] = useState(false);
  const [transitionAnimation, setTransitionAnimation] = useState(undefined);
  const [transitionDuration, setTransitionDuration] = useState(0);
  const classes = classNames("cookie-consent-banner", {
    inverted,
    [`aligned-${position}`]: position
  }, className);
  /**
   * Show the banner id the cookie is not set.
   */

  useEffect(() => {
    if (!isCookieConsentShown()) {
      setShow(true);
    }
  }, []);
  /**
   * Checks if the cookie consent is shown.
   *
   * @returns a boolean
   */

  const isCookieConsentShown = () => {
    return Boolean(CookieStorageUtils.getItem(COOKIE_CONSENT_COOKIE_NAME));
  };
  /**
   * Handle the confirm button click.
   */


  const handleConfirmButton = () => {
    persistConsent();
    setTransitionAnimation("slide up");
    setTransitionDuration(500);
    setShow(false);
    onConfirmButtonClick && typeof onConfirmButtonClick === "function" && onConfirmButtonClick();
  };
  /**
   * Persist the consent.
   */


  const persistConsent = () => {
    if (storageStrategy === "cookie") {
      let cookieString = COOKIE_CONSENT_COOKIE_NAME + "=true;max-age=31536000;path=/";

      if (domainCookie) {
        cookieString = `${cookieString};domain=${domain !== null && domain !== void 0 ? domain : extractDomainFromHost()}`;
      }

      CookieStorageUtils.setItem(cookieString);
      return;
    }

    throw new Error("Invalid storage strategy. Only Cookie is supported.");
  };
  /**
   * Extracts the domain from the hostname.
   * If parsing fails, undefined will be returned.
   *
   * @returns the domain of the current host
   */


  const extractDomainFromHost = () => {
    let domain = undefined;
    /**
     * Extract the domain from the hostname.
     * Ex: If console.wso2-is.com is parsed, `wso2-is.com` will be set as the domain.
     */

    try {
      const hostnameTokens = window.location.hostname.split(".");

      if (hostnameTokens.length > 1) {
        domain = hostnameTokens.slice(hostnameTokens.length - 2, hostnameTokens.length).join(".");
      }
    } catch (e) {// Couldn't parse the hostname. Log the error in debug mode.
      // Tracked here https://github.com/wso2/product-is/issues/11650.
    }

    return domain;
  };

  return /*#__PURE__*/React__default.createElement(TransitionablePortal, {
    open: show,
    closeOnEscape: false,
    closeOnDocumentClick: false,
    transition: {
      animation: transitionAnimation,
      duration: transitionDuration
    }
  }, /*#__PURE__*/React__default.createElement(Segment, Object.assign({
    id: id,
    styles: style,
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), /*#__PURE__*/React__default.createElement("div", {
    className: "banner-image",
    "data-componentid": `${componentId}-image`,
    "data-testid": `${testId}-image`
  }, /*#__PURE__*/React__default.createElement(GenericIcon, {
    transparent: true,
    size: "tiny",
    floated: "left",
    className: "cookie-icon",
    icon: SvgCookieIcon
  })), /*#__PURE__*/React__default.createElement("div", {
    className: "banner-content",
    "data-componentid": `${componentId}-content`,
    "data-testid": `${testId}-content`
  }, title), /*#__PURE__*/React__default.createElement("div", {
    className: "actions",
    "data-componentid": `${componentId}-actions`,
    "data-testid": `${testId}-actions`
  }, /*#__PURE__*/React__default.createElement(PrimaryButton, {
    fluid: true,
    onClick: handleConfirmButton,
    "data-componentid": `${componentId}-confirm-button`,
    "data-testid": `${testId}-confirm-button`
  }, confirmButtonText))));
};
/**
 * Default props for the component.
 */

CookieConsentBanner.defaultProps = {
  "data-componentid": "cookie-consent-banner",
  "data-testid": "cookie-consent-banner",
  domainCookie: false,
  id: "cookie-consent-banner",
  inverted: false,
  position: "right",
  storageStrategy: "cookie"
};

/**
 * Jumbotron: Component to showcase key marketing messages.
 *
 * @param props - Props injected to the components.
 *
 * @returns Jumbotron component.
 */

const Jumbotron = props => {
  const {
    children,
    className,
    contentInline,
    background,
    borderRadius,
    bordered,
    heading,
    headingAs,
    icon,
    iconOptions,
    iconSize,
    matchedPadding,
    style,
    subHeading,
    subHeadingAs,
    topContent,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["children", "className", "contentInline", "background", "borderRadius", "bordered", "heading", "headingAs", "icon", "iconOptions", "iconSize", "matchedPadding", "style", "subHeading", "subHeadingAs", "topContent", "data-componentid", "data-testid"]);

  const classes = classNames("jumbotron", {
    [`background-${background}`]: background,
    [typeof bordered === "boolean" ? "bordered-default" : `bordered-${bordered}`]: bordered,
    [typeof borderRadius === "string" ? `border-radius-${borderRadius}` : ""]: borderRadius,
    ["matched-padding"]: matchedPadding
  }, className);
  const contentWrapperClasses = classNames("jumbotron-content-wrapper", {
    ["inline"]: contentInline
  });
  /**
   * Resolves the custom styles.
   *
   * @returns Styles object.
   */

  const getStyle = () => {
    let modifiedStyle = style;

    if (typeof borderRadius === "number") {
      modifiedStyle = Object.assign(Object.assign({}, modifiedStyle), {
        borderRadius: `${borderRadius}px`
      });
    }

    return modifiedStyle;
  };
  /**
   * Resolves additional properties.
   *
   * @returns Additional props.
   */


  const resolveAdditionalProps = () => {
    let additionalProps = {};

    if (background && !(background === "white" || background === "default")) {
      additionalProps = Object.assign(Object.assign({}, additionalProps), {
        inverted: true
      });
    }

    return additionalProps;
  };

  return /*#__PURE__*/React__default.createElement(Segment, Object.assign({
    className: classes,
    style: getStyle()
  }, resolveAdditionalProps(), rest), topContent, (heading || subHeading || children) && /*#__PURE__*/React__default.createElement("div", {
    className: contentWrapperClasses
  }, heading && (typeof heading === "string" ? /*#__PURE__*/React__default.createElement(Heading, {
    className: "jumbotron-heading inline ellipsis",
    as: headingAs,
    "data-componentid": `${componentId}-heading`,
    "data-testid": `${testId}-heading`,
    compact: true
  }, heading) : heading), subHeading && (typeof subHeading === "string" ? /*#__PURE__*/React__default.createElement(Heading, {
    className: "jumbotron-sub-heading",
    "data-componentid": `${componentId}-sub-heading`,
    "data-testid": `${testId}-sub-heading`,
    as: subHeadingAs,
    subHeading: true,
    ellipsis: true
  }, subHeading) : subHeading), children), icon && /*#__PURE__*/React__default.createElement(Media, {
    greaterThanOrEqual: "computer"
  }, /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
    icon: icon,
    size: iconSize,
    floated: "right",
    transparent: true
  }, iconOptions))));
};
/**
 * Default props for the stat count card.
 */

Jumbotron.defaultProps = {
  background: "default",
  basic: true,
  borderRadius: "default",
  bordered: "bottom",
  clearing: true,
  contentInline: false,
  "data-componentid": "jumbotron",
  "data-testid": "jumbotron",
  headingAs: "h1",
  iconSize: "auto",
  matchedPadding: true,
  subHeadingAs: "h5",
  textAlign: "left"
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Logo component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Logo React Component
 */

const Logo = props => {
  const {
    className,
    image,
    size,
    style,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames(className, "product-logo");
  return /*#__PURE__*/React__default.createElement(GenericIcon, {
    icon: image,
    className: classNames(classes, "product-logo"),
    size: size,
    style: style,
    "data-componentid": componentId,
    "data-testid": testId,
    transparent: true,
    inline: true
  });
};
/**
 * Default props for the logo component.
 */

Logo.defaultProps = {
  "data-componentid": "logo",
  "data-testid": "logo",
  size: "auto"
};

/**
 * Product Brand component.
 *
 * @param props - Props injected to the component.
 *
 * @returns ProductBrand React Component
 */

const ProductBrand = props => {
  const {
    appName,
    children,
    className,
    logo,
    productName,
    style,
    version,
    versionUISettings,
    mobile,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const mainClasses = classNames(className, "product-title");
  const versionLabelClasses = classNames("version-label", {
    "preview-label": version === "PREVIEW",
    "primary": version !== "PREVIEW" && !versionUISettings.labelColor,
    [versionUISettings.labelColor]: versionUISettings.labelColor === "primary" || versionUISettings.labelColor === "secondary"
  });
  /**
   * Resolves the version label color.
   *
   * @returns the esolved color.
   */

  const resolveVersionLabelColor = releaseType => {
    // The label color will be resolved via label class applied.
    if (version === "PREVIEW") {
      return null;
    }

    if ((versionUISettings === null || versionUISettings === void 0 ? void 0 : versionUISettings.labelColor) && !(versionUISettings.labelColor === "auto" || versionUISettings.labelColor === "primary" || versionUISettings.labelColor === "secondary")) {
      return versionUISettings.labelColor;
    }

    if (versionUISettings.labelColor === "primary" || versionUISettings.labelColor === "secondary") {
      return "grey";
    }

    if (releaseType === ProductReleaseTypes.ALPHA) {
      return "red";
    } else if (releaseType === ProductReleaseTypes.BETA) {
      return "teal";
    } else if (releaseType === ProductReleaseTypes.RC) {
      return "green";
    } else if (releaseType === ProductReleaseTypes.MILESTONE) {
      return "violet";
    }

    return "grey";
  };
  /**
   * Resolves the release version.
   *
   * @returns the resolved release version.
   */


  const resolveReleaseVersionLabel = () => {
    const [versionNumber, release, releaseType] = CommonUtils.parseProductVersion(version, versionUISettings.allowSnapshot);
    let constructed = `${versionNumber !== null && versionNumber !== void 0 ? versionNumber : ""} ${release !== null && release !== void 0 ? release : ""}`;

    if (versionUISettings) {
      if (versionUISettings.textCase === "lowercase") {
        constructed = constructed.toLowerCase();
      } else if (versionUISettings.textCase === "uppercase") {
        constructed = constructed.toUpperCase();
      }
    }

    const productTitleMetaClasses = classNames("product-title-meta", {
      "absolute": (versionUISettings === null || versionUISettings === void 0 ? void 0 : versionUISettings.labelPosition) === "absolute"
    });
    return /*#__PURE__*/React__default.createElement("div", {
      className: productTitleMetaClasses
    }, /*#__PURE__*/React__default.createElement(Label, {
      color: resolveVersionLabelColor(releaseType),
      className: versionLabelClasses,
      size: "mini",
      "data-componentid": `${componentId}-version`,
      "data-testid": `${testId}-version`
    }, constructed));
  };

  return /*#__PURE__*/React__default.createElement("div", {
    className: mainClasses,
    style: style,
    "data-testid": testId,
    "data-componentid": componentId
  }, version && resolveReleaseVersionLabel(), /*#__PURE__*/React__default.createElement("div", {
    className: `product-title-main ${mobile ? "mt-4" : ""}`
  }, logo && logo, (appName || productName) && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Heading, {
    className: "product-title-text",
    style: style,
    "data-componentid": `${componentId}-title`,
    "data-testid": `${testId}-title`,
    compact: true
  }, productName, !mobile && appName && /*#__PURE__*/React__default.createElement("span", {
    className: "app-name"
  }, appName)), mobile && appName && /*#__PURE__*/React__default.createElement("span", {
    className: "app-name display-inline-block"
  }, appName)), children));
};
/**
 * Default props for the product brand component.
 */

ProductBrand.defaultProps = {
  "data-componentid": "product-brand",
  "data-testid": "product-brand",
  versionUISettings: {
    allowSnapshot: false,
    labelColor: "primary",
    textCase: "uppercase"
  }
};

var _path$6;

function _extends$7() { _extends$7 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$7.apply(this, arguments); }

var SvgCheckIcon = function SvgCheckIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$7({
    className: "check-icon_svg__icon",
    height: 14,
    viewBox: "0 -46 417.813 417",
    width: 14,
    xmlns: "http://www.w3.org/2000/svg"
  }, props), _path$6 || (_path$6 = /*#__PURE__*/React.createElement("path", {
    d: "M159.988 318.582c-3.988 4.012-9.43 6.25-15.082 6.25s-11.094-2.238-15.082-6.25L9.375 198.113c-12.5-12.5-12.5-32.77 0-45.246l15.082-15.086c12.504-12.5 32.75-12.5 45.25 0l75.2 75.203L348.104 9.781c12.504-12.5 32.77-12.5 45.25 0l15.082 15.086c12.5 12.5 12.5 32.766 0 45.246zm0 0"
  })));
};

var _path$5, _path2$2;

function _extends$6() { _extends$6 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$6.apply(this, arguments); }

var SvgCopyIcon = function SvgCopyIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$6({
    className: "copy-icon_svg__icon",
    xmlns: "http://www.w3.org/2000/svg",
    height: 14,
    width: 14,
    viewBox: "0 0 477.867 477.867",
    style: {
      enableBackground: "new 0 0 477.867 477.867"
    },
    xmlSpace: "preserve"
  }, props), _path$5 || (_path$5 = /*#__PURE__*/React.createElement("path", {
    d: "M341.333 85.333H51.2c-28.277 0-51.2 22.923-51.2 51.2v290.133c0 28.277 22.923 51.2 51.2 51.2h290.133c28.277 0 51.2-22.923 51.2-51.2V136.533c0-28.277-22.923-51.2-51.2-51.2zM358.4 426.667c0 9.426-7.641 17.067-17.067 17.067H51.2c-9.426 0-17.067-7.641-17.067-17.067V136.533c0-9.426 7.641-17.067 17.067-17.067h290.133c9.426 0 17.067 7.641 17.067 17.067v290.134z"
  })), _path2$2 || (_path2$2 = /*#__PURE__*/React.createElement("path", {
    d: "M426.667 0h-307.2c-28.277 0-51.2 22.923-51.2 51.2 0 9.426 7.641 17.067 17.067 17.067S102.4 60.626 102.4 51.2s7.641-17.067 17.067-17.067h307.2c9.426 0 17.067 7.641 17.067 17.067v307.2c0 9.426-7.641 17.067-17.067 17.067s-17.067 7.641-17.067 17.067 7.641 17.067 17.067 17.067c28.277 0 51.2-22.923 51.2-51.2V51.2c0-28.277-22.923-51.2-51.2-51.2z"
  })));
};

function _extends$5() { _extends$5 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$5.apply(this, arguments); }

var SvgMaximizeIcon = function SvgMaximizeIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$5({
    xmlns: "http://www.w3.org/2000/svg",
    className: "maximize-icon_svg__icon",
    width: 14,
    height: 14,
    viewBox: "0 0 317.215 317.215",
    style: {
      enableBackground: "new 0 0 317.215 317.215"
    },
    xmlSpace: "preserve"
  }, props), /*#__PURE__*/React.createElement("path", {
    style: {
      fill: "#231f20"
    },
    d: "M309.715 1.107h-71.223a7.5 7.5 0 0 0-7.5 7.5v20a7.5 7.5 0 0 0 7.5 7.5h18.973l-57.129 57.127a7.501 7.501 0 0 0 0 10.606l14.143 14.143a7.476 7.476 0 0 0 5.304 2.197 7.482 7.482 0 0 0 5.304-2.197l57.129-57.127V79.83a7.5 7.5 0 0 0 7.5 7.5h20a7.5 7.5 0 0 0 7.5-7.5V8.607a7.502 7.502 0 0 0-7.501-7.5zM59.75 36.107h18.973a7.5 7.5 0 0 0 7.5-7.5v-20a7.5 7.5 0 0 0-7.5-7.5H7.5a7.5 7.5 0 0 0-7.5 7.5V79.83a7.5 7.5 0 0 0 7.5 7.5h20a7.5 7.5 0 0 0 7.5-7.5V60.857l57.125 57.126a7.483 7.483 0 0 0 5.305 2.197 7.486 7.486 0 0 0 5.305-2.197l14.142-14.143a7.5 7.5 0 0 0 0-10.606L59.75 36.107zM102.734 199.233a7.503 7.503 0 0 0-10.609 0L35 256.358v-18.974a7.5 7.5 0 0 0-7.5-7.5h-20a7.5 7.5 0 0 0-7.5 7.5v71.223a7.5 7.5 0 0 0 7.5 7.5h71.223a7.5 7.5 0 0 0 7.5-7.5v-20a7.5 7.5 0 0 0-7.5-7.5H59.75l57.126-57.125a7.5 7.5 0 0 0 0-10.606l-14.142-14.143zM309.715 229.885h-20a7.5 7.5 0 0 0-7.5 7.5v18.976l-57.13-57.127a7.5 7.5 0 0 0-10.606 0l-14.143 14.143a7.501 7.501 0 0 0 .001 10.606l57.128 57.125h-18.973a7.5 7.5 0 0 0-7.5 7.5v20a7.5 7.5 0 0 0 7.5 7.5h71.223a7.5 7.5 0 0 0 7.5-7.5v-71.223a7.5 7.5 0 0 0-7.5-7.5z"
  }));
};

var _path$4;

function _extends$4() { _extends$4 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$4.apply(this, arguments); }

var SvgMinimizeIcon = function SvgMinimizeIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$4({
    xmlns: "http://www.w3.org/2000/svg",
    className: "minimize-icon_svg__icon",
    width: 14,
    height: 14,
    viewBox: "0 0 512 512",
    style: {
      enableBackground: "new 0 0 512 512"
    },
    xmlSpace: "preserve"
  }, props), _path$4 || (_path$4 = /*#__PURE__*/React.createElement("path", {
    d: "M505.752 6.248c-8.331-8.331-21.839-8.331-30.17 0L320 161.83V64c0-11.782-9.551-21.333-21.333-21.333-11.782 0-21.333 9.551-21.333 21.333v149.333l.001.022c.001.695.037 1.39.105 2.083.031.318.091.627.136.94.054.375.098.75.171 1.122.071.359.17.708.259 1.061.081.322.151.645.248.964.105.346.234.68.356 1.018.114.318.219.639.349.953.131.316.284.618.43.926.152.323.296.649.465.966.158.295.338.575.509.861.186.311.361.626.564.929.211.316.447.613.674.917.19.253.365.513.568.759a21.422 21.422 0 0 0 2.977 2.977c.246.202.506.378.759.568.304.228.601.463.917.674.303.203.618.379.929.564.286.171.566.351.861.509.317.169.643.313.966.465.308.145.611.299.926.43.314.13.635.235.953.349.338.122.672.251 1.018.356.318.096.642.167.964.248.353.089.701.188 1.061.259.372.074.748.118 1.122.171.314.045.622.104.94.136.693.068 1.388.105 2.083.105l.022.001H448c11.782 0 21.333-9.551 21.333-21.333 0-11.782-9.551-21.333-21.333-21.333h-97.83L505.752 36.418c8.331-8.331 8.331-21.838 0-30.17zM234.56 296.562c-.031-.318-.091-.627-.136-.94-.054-.375-.098-.75-.171-1.122-.071-.359-.17-.708-.259-1.061-.081-.322-.151-.645-.248-.964-.105-.346-.234-.68-.356-1.018-.114-.318-.219-.639-.349-.953-.131-.316-.284-.618-.43-.926-.152-.323-.296-.649-.465-.966-.158-.295-.338-.575-.509-.861-.186-.311-.361-.626-.564-.929-.211-.316-.447-.613-.674-.917-.19-.253-.365-.513-.568-.759a21.422 21.422 0 0 0-2.977-2.977c-.246-.202-.506-.378-.759-.568-.304-.228-.601-.463-.917-.674-.303-.203-.618-.379-.929-.564-.286-.171-.566-.351-.861-.509-.317-.169-.643-.313-.966-.465-.308-.145-.611-.299-.926-.43-.314-.13-.635-.235-.953-.349-.338-.122-.672-.251-1.018-.356-.318-.096-.642-.167-.964-.248-.353-.089-.701-.188-1.061-.259-.372-.074-.748-.118-1.122-.171-.314-.045-.622-.104-.94-.136-.7-.069-1.402-.106-2.105-.106H64c-11.782 0-21.333 9.551-21.333 21.333C42.667 310.449 52.218 320 64 320h97.83L6.248 475.582c-8.331 8.331-8.331 21.839 0 30.17 8.331 8.331 21.839 8.331 30.17 0L192 350.17V448c0 11.782 9.551 21.333 21.333 21.333 11.782 0 21.333-9.551 21.333-21.333V298.667a21.148 21.148 0 0 0-.106-2.105z"
  })));
};

window.JSHINT = JSHINT;
/**
 * Code editor component.
 *
 * @param props - Props injected to the danger zone component.
 *
 * @returns the code editor component.
 */

const CodeEditor = props => {
  const {
    allowFullScreen,
    beautify,
    className,
    controlledFullScreenMode,
    getThemeFromEnvironment,
    height,
    language,
    lineWrapping,
    lint,
    onFullScreenToggle,
    options,
    oneLiner,
    readOnly,
    showLineNumbers,
    smart,
    sourceCode,
    tabSize,
    theme,
    translations,
    triggerFullScreen,
    withClipboardCopy,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["allowFullScreen", "beautify", "className", "controlledFullScreenMode", "getThemeFromEnvironment", "height", "language", "lineWrapping", "lint", "onFullScreenToggle", "options", "oneLiner", "readOnly", "showLineNumbers", "smart", "sourceCode", "tabSize", "theme", "translations", "triggerFullScreen", "withClipboardCopy", "data-componentid", "data-testid"]);

  const [editorInstance, setEditorInstance] = useState(undefined);
  const [copyToClipboardIcon, setCopyToClipboardIcon] = useState(SvgCopyIcon);
  const [fullScreenToggleIcon, setFullScreenToggleIcon] = useState(SvgMaximizeIcon);
  const [isEditorFullScreen, setIsEditorFullScreen] = useState(false);
  const [darkMode, setDarkMode] = useState(false);
  /**
   * Set the internal full screen state based on the externally provided state.
   */

  useEffect(() => {
    if (triggerFullScreen === undefined) {
      return;
    }

    if (triggerFullScreen) {
      setFullScreenToggleIcon(SvgMinimizeIcon);
    } else {
      setFullScreenToggleIcon(SvgMaximizeIcon);
    }

    setIsEditorFullScreen(triggerFullScreen);
    onFullScreenToggle(triggerFullScreen);
  }, [triggerFullScreen]);
  /**
   * Gets the browser color scheme so that the color scheme of the textarea can be decided.
   */

  useEffect(() => {
    // If `getThemeFromEnvironment` is false or `matchMedia` is not supported, fallback to dark theme.
    if (!getThemeFromEnvironment || !window.matchMedia) {
      setDarkMode(true);
      return;
    }

    if (window.matchMedia("(prefers-color-scheme:dark)").matches) {
      setDarkMode(true);
    }

    const callback = e => {
      if (e.matches) {
        setDarkMode(true);
        return;
      }

      setDarkMode(false);
    };

    try {
      window.matchMedia("(prefers-color-scheme:dark)").addEventListener("change", e => callback(e));
    } catch (error) {
      try {
        // Older versions of Safari doesn't support `addEventListener`.
        window.matchMedia("(prefers-color-scheme:dark)").addListener(e => callback(e));
      } catch (error) {
        // Fallback to dark if everything fails.
        setDarkMode(true);
      }
    } // Housekeeping. Remove the listeners.


    return () => {
      try {
        window.matchMedia("(prefers-color-scheme:dark)").removeEventListener("change", e => callback(e));
      } catch (parentError) {
        try {
          // Older versions of Safari doesn't support `addEventListener`.
          window.matchMedia("(prefers-color-scheme:dark)").removeListener(e => callback(e));
        } catch (error) {// TODO: Rather than silently failing, add debug logs here.
        }
      }
    };
  }, [getThemeFromEnvironment]);
  /**
   * Resolves the language mode.
   *
   * @param language - Selected language.
   * @returns the resolved mode.
   */

  const resolveMode = language => {
    if (!language) {
      throw new Error("Please define a language.");
    }

    return {
      json: language === "json",
      name: language === "json" || language === "typescript" ? "javascript" : language,
      statementIndent: 4,
      typescript: language === "typescript"
    };
  };
  /**
   * Resolves the editor theme.
   *
   * @returns the resolved mode.
   */


  const resolveTheme = () => {
    if (getThemeFromEnvironment) {
      return darkMode ? "material" : "default";
    }

    if (!(theme === "dark" || theme === "light")) {
      throw new Error("Please select a supported theme. Only `dark` and `light` are supported at the moment.");
    }

    return theme === "dark" ? "material" : "default";
  };
  /**
   * Beautifies the source code.
   *
   * @returns the beautified source code snippet.
   */


  const beautifyCode = () => {
    let code = sourceCode;

    if (code instanceof Array) {
      code = code.join("");
    }

    if (language === "javascript") {
      return JSBeautify(code, {
        indent_size: tabSize,
        space_in_empty_paren: true
      });
    }

    return code;
  };
  /**
   * Handles clipboard copy event internally.
   */


  const handleCopyToClipboard = () => {
    CommonUtils.copyTextToClipboard(editorInstance.doc.getValue()).then(() => {
      setCopyToClipboardIcon(SvgCheckIcon);
      setTimeout(() => {
        setCopyToClipboardIcon(SvgCopyIcon);
      }, 1000);
    });
  };
  /**
   * Handles Full Screen mode toggle event event.
   */


  const handleFullScreenToggle = () => {
    if (!isEditorFullScreen) {
      setFullScreenToggleIcon(SvgMinimizeIcon);
    } else {
      setFullScreenToggleIcon(SvgMaximizeIcon);
    }

    onFullScreenToggle(!isEditorFullScreen);
    setIsEditorFullScreen(!isEditorFullScreen);
  };

  const classes = classNames("code-editor", {
    "dark": resolveTheme() === "material",
    "light": resolveTheme() === "default",
    "one-liner": oneLiner,
    "with-actions": withClipboardCopy || allowFullScreen
  }, className);
  const fullScreenWrapperClasses = classNames("code-editor-fullscreen-wrapper", {
    theme
  });
  /**
   * Render inner content.
   *
   * @returns the inner content for the code editor
   */

  const renderContent = () => {
    // Renders the full screen toggle.
    const renderFullScreenToggle = () => /*#__PURE__*/React__default.createElement("div", {
      className: "editor-action",
      onClick: handleFullScreenToggle
    }, /*#__PURE__*/React__default.createElement(Tooltip, {
      compact: true,
      trigger: /*#__PURE__*/React__default.createElement("div", null, /*#__PURE__*/React__default.createElement(GenericIcon, {
        hoverable: true,
        size: "mini",
        transparent: true,
        icon: fullScreenToggleIcon
      })),
      content: isEditorFullScreen ? (translations === null || translations === void 0 ? void 0 : translations.exitFullScreen) || "Exit full-Screen" : (translations === null || translations === void 0 ? void 0 : translations.goFullScreen) || "Go full-Screen",
      size: "mini"
    }));

    return /*#__PURE__*/React__default.createElement("div", {
      className: classes
    }, /*#__PURE__*/React__default.createElement("div", {
      className: "editor-actions"
    }, allowFullScreen && ( // If the full screen mode trigger is handled from outside, we don't need to show the
    // embedded `Go full-screen` button.
    !controlledFullScreenMode ? isEditorFullScreen ? renderFullScreenToggle() : null : renderFullScreenToggle()), withClipboardCopy && /*#__PURE__*/React__default.createElement("div", {
      className: "editor-action",
      onClick: handleCopyToClipboard
    }, /*#__PURE__*/React__default.createElement(Tooltip, {
      compact: true,
      trigger: /*#__PURE__*/React__default.createElement("div", null, /*#__PURE__*/React__default.createElement(GenericIcon, {
        hoverable: true,
        size: "mini",
        transparent: true,
        icon: copyToClipboardIcon
      })),
      content: (translations === null || translations === void 0 ? void 0 : translations.copyCode) || "Copy to clipboard",
      size: "mini"
    }))), /*#__PURE__*/React__default.createElement(UnControlled, Object.assign({}, rest, {
      value: beautify ? beautifyCode() : sourceCode,
      editorDidMount: (editor, ...args) => {
        if (height) {
          editor.setSize("", height);
        }

        if (oneLiner) {
          editor.setSize("", "100%");
        }

        setEditorInstance(editor);
        rest.editorDidMount && rest.editorDidMount(editor, ...args);
      },
      options: Object.assign({
        autoCloseBrackets: smart,
        autoCloseTags: smart,
        extraKeys: smart ? {
          "Ctrl-Space": "autocomplete"
        } : {},
        gutters: ["note-gutter", "CodeMirror-linenumbers", "CodeMirror-lint-markers"],
        indentUnit: tabSize,
        lineNumbers: !oneLiner ? showLineNumbers : false,
        lineWrapping,
        lint,
        matchBrackets: smart,
        matchTags: smart,
        mode: (options === null || options === void 0 ? void 0 : options.mode) ? options.mode : resolveMode(language),
        readOnly,
        tabSize,
        theme: resolveTheme()
      }, options),
      "data-componentid": componentId,
      "data-testid": testId
    })));
  };

  return allowFullScreen && isEditorFullScreen ? /*#__PURE__*/React__default.createElement(Modal, {
    open: true,
    size: "fullscreen",
    className: fullScreenWrapperClasses
  }, /*#__PURE__*/React__default.createElement(Modal.Content, {
    className: "editor-content",
    scrolling: true
  }, renderContent())) : renderContent();
};
/**
 * Default props for the code editor component.
 */

CodeEditor.defaultProps = {
  allowFullScreen: false,
  controlledFullScreenMode: true,
  "data-componentid": "code-editor",
  "data-testid": "code-editor",
  language: "javascript",
  lineWrapping: true,
  lint: false,
  readOnly: false,
  showLineNumbers: true,
  smart: false,
  tabSize: 4,
  theme: "dark"
};

var $$9 = _export;
var NativePromiseConstructor = promiseNativeConstructor;
var fails$f = fails$z;
var getBuiltIn = getBuiltIn$9;
var isCallable$4 = isCallable$r;
var speciesConstructor$1 = speciesConstructor$4;
var promiseResolve = promiseResolve$2;
var defineBuiltIn$6 = defineBuiltIn$d;

var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;

// Safari bug https://bugs.webkit.org/show_bug.cgi?id=200829
var NON_GENERIC = !!NativePromiseConstructor && fails$f(function () {
  // eslint-disable-next-line unicorn/no-thenable -- required for testing
  NativePromisePrototype['finally'].call({ then: function () { /* empty */ } }, function () { /* empty */ });
});

// `Promise.prototype.finally` method
// https://tc39.es/ecma262/#sec-promise.prototype.finally
$$9({ target: 'Promise', proto: true, real: true, forced: NON_GENERIC }, {
  'finally': function (onFinally) {
    var C = speciesConstructor$1(this, getBuiltIn('Promise'));
    var isFunction = isCallable$4(onFinally);
    return this.then(
      isFunction ? function (x) {
        return promiseResolve(C, onFinally()).then(function () { return x; });
      } : onFinally,
      isFunction ? function (e) {
        return promiseResolve(C, onFinally()).then(function () { throw e; });
      } : onFinally
    );
  }
});

// makes sure that native promise-based APIs `Promise#finally` properly works with patched `Promise#then`
if (isCallable$4(NativePromiseConstructor)) {
  var method = getBuiltIn('Promise').prototype['finally'];
  if (NativePromisePrototype['finally'] !== method) {
    defineBuiltIn$6(NativePromisePrototype, 'finally', method, { unsafe: true });
  }
}

/**
 * React Wrapper for HTML iframe element.
 *
 * @param props - Props injected to the danger zone component.
 *
 * @returns the React Wrapper component for HTML iframe element.
 */

const Iframe = props => {
  var _a, _b;

  const {
    children,
    className,
    cloneParentStyleSheets,
    injectStyleNodeAfterParentStyles,
    isReady,
    isLoading,
    responsive,
    styles,
    styleNodeInjectionStrategy,
    stylesheets,
    ["data-componentid"]: componentId,
    zoom,
    wrapperStyle
  } = props,
        rest = __rest(props, ["children", "className", "cloneParentStyleSheets", "injectStyleNodeAfterParentStyles", "isReady", "isLoading", "responsive", "styles", "styleNodeInjectionStrategy", "stylesheets", "data-componentid", "zoom", "wrapperStyle"]);

  const contentRef = useRef(null);
  const [isParentStylesheetsCloningCompleted, setIsParentStylesheetsCloningCompleted] = useState(false);
  const [clonedStyleSheets, setClonedStyleSheets] = useState([]);
  const [clonedParentStyleSheets, setClonedParentStyleSheets] = useState([]);
  const iFrameWindow = (_a = contentRef === null || contentRef === void 0 ? void 0 : contentRef.current) === null || _a === void 0 ? void 0 : _a.contentWindow;
  const iFrameBodyNode = (_b = iFrameWindow === null || iFrameWindow === void 0 ? void 0 : iFrameWindow.document) === null || _b === void 0 ? void 0 : _b.body;
  const classes = classNames("ui", "iframe", {
    ["loading"]: isLoading,
    responsive
  }, className);
  /**
   * Clones the parent node's stylesheets to the iframe.
   */

  useEffect(() => {
    var _a, _b; // Check if main body node is loaded before proceeding.


    if (!iFrameBodyNode) {
      return;
    }

    if (!cloneParentStyleSheets) {
      isReady(true);
      return;
    }

    const parentNodeStyleSheets = (_b = (_a = contentRef.current.contentWindow.parent) === null || _a === void 0 ? void 0 : _a.document) === null || _b === void 0 ? void 0 : _b.styleSheets;

    if (!parentNodeStyleSheets || !parentNodeStyleSheets.length || parentNodeStyleSheets.length <= 0) {
      return;
    }

    const styleSheetPromises = [];
    const _clonedParentStyleSheets = [];

    for (const styleSheet of parentNodeStyleSheets) {
      if (isEmpty(styleSheet.href)) {
        continue;
      } // Avoid cloning already cloned stylesheets.


      if (clonedParentStyleSheets.includes(styleSheet.href)) {
        return;
      } else {
        _clonedParentStyleSheets.push(styleSheet.href);
      }

      styleSheetPromises.push(injectStyleSheetToDOM(styleSheet, iFrameWindow.document));
    }

    Promise.all([...styleSheetPromises]).then(() => {
      setClonedParentStyleSheets(_clonedParentStyleSheets);
    }).catch(() => {// Add debug logs here one a logger is added.
      // Tracked here https://github.com/wso2/product-is/issues/11650.
    }).finally(() => {
      // If external stylesheets are not provided, mark as ready.
      if (!stylesheets) {
        isReady(true);
      } else {
        setIsParentStylesheetsCloningCompleted(true);
      }
    });
  }, [iFrameBodyNode, cloneParentStyleSheets]);
  /**
   * Injects externally provided stylesheets to the iframe.
   */

  useEffect(() => {
    // Check if iframe node is loaded before proceeding.
    if (!iFrameWindow) {
      return;
    } // Check if the parent stylesheet cloning is completed.


    if (!isParentStylesheetsCloningCompleted) {
      isReady(false);
      return;
    } // Return if stylesheets are undefined or not an array.


    if (!stylesheets || !Array.isArray(stylesheets)) {
      isReady(true);
      return;
    }

    const styleSheetPromises = [];
    const _clonedStyleSheets = [];

    for (const styleSheet of stylesheets) {
      if (isEmpty(styleSheet)) {
        continue;
      } // Avoid cloning already cloned stylesheets.


      if (clonedStyleSheets.includes(styleSheet)) {
        return;
      } else {
        _clonedStyleSheets.push(styleSheet);
      }

      styleSheetPromises.push(injectStyleSheetToDOM({
        href: styleSheet
      }, iFrameWindow.document));
    }

    Promise.all([...styleSheetPromises]).then(() => {
      setClonedStyleSheets(_clonedStyleSheets);
    }).catch(() => {// Add debug logs here one a logger is added.
      // Tracked here https://github.com/wso2/product-is/issues/11650.
    }).finally(() => {
      isReady(true);
    });
  }, [stylesheets, isParentStylesheetsCloningCompleted]);
  /**
   *
   */

  useEffect(() => {
    // Check if iframe node is loaded before proceeding.
    if (!iFrameWindow) {
      return;
    } // Check if the parent stylesheet cloning is completed.


    if (styles && !isParentStylesheetsCloningCompleted) {
      isReady(false);
      return;
    } // Remove the existing style nodes before adding the new styles to avoid adding the same
    // styles on `style` prop changes.


    const styleNodesCollection = iFrameWindow.document.getElementsByTagName("style");

    for (const node of styleNodesCollection) {
      node.remove();
    }

    const styleNode = iFrameWindow.document.createElement("style");
    styleNode.innerHTML = styles; // If the `injectStyleNodeAfterParentStyles` flag is set, change the inject strategy to append.

    if (injectStyleNodeAfterParentStyles) {
      iFrameWindow.document.head.appendChild(styleNode);
    } else if (styleNodeInjectionStrategy === "append") {
      iFrameWindow.document.head.appendChild(styleNode);
    } else {
      iFrameWindow.document.head.prepend(styleNode);
    }

    isReady(true);
  }, [styles, iFrameWindow, isParentStylesheetsCloningCompleted, injectStyleNodeAfterParentStyles]);
  /**
   * Add styling to the iframe body.
   */

  useEffect(() => {
    // Check if main body node is loaded before proceeding.
    if (!iFrameBodyNode || !zoom) {
      return;
    } // CSSStyleDeclaration doesn't have the `zoom` property.


    iFrameBodyNode.style.zoom = `${zoom}%`;
  }, [iFrameBodyNode, zoom]);
  /**
   * Injects the passed in stylesheet to the Head element of the document passed in as an argument.
   *
   * @param styleSheet - Stylesheet object.
   * @param document - Document.
   * @returns a promise that resolves with a html link.
   */

  const injectStyleSheetToDOM = (styleSheet, document) => {
    return new Promise(function (resolve, reject) {
      const link = document.createElement("link");
      link.href = styleSheet.href;
      link.rel = "stylesheet";

      link.onload = () => resolve(link);

      link.onerror = () => reject(new Error(`Could not load the stylesheet href: ${styleSheet.href}`));

      document.head.append(link);
    });
  };
  /**
   * Renders the iframe element.
   *
   * @param isWrapped - Is the iframe wrapped with a div.
   * @returns the iframe element.
   */


  const _iframe = (isWrapped = responsive) => {
    return /*#__PURE__*/React__default.createElement("iframe", Object.assign({
      className: !isWrapped && classes,
      ref: contentRef,
      "data-componentid": componentId
    }, rest), iFrameBodyNode && /*#__PURE__*/createPortal(children, iFrameBodyNode));
  }; // If not responsive, return the raw iframe element without wrappers.


  if (!responsive) {
    return _iframe();
  }

  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    "data-componentid": `${componentId}-wrapper`,
    style: wrapperStyle
  }, _iframe());
};
/**
 * Default props for the component.
 */

Iframe.defaultProps = {
  "data-componentid": "iframe",
  responsive: true,
  styleNodeInjectionStrategy: "append"
};

/**
 * Image Preview container component.
 *
 * @param props - Props injected to the component.
 * @returns the Image Preview container component.
 */

const ImagePreview = props => {
  const {
    children,
    className,
    label,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["children", "className", "label", "data-componentid"]);

  const classes = classNames("image-preview", className);
  return /*#__PURE__*/React__default.createElement(Segment, Object.assign({
    basic: true,
    secondary: true,
    className: classes,
    "data-componentid": componentId
  }, rest), label && /*#__PURE__*/React__default.createElement(Label, {
    attached: "top right",
    size: "mini"
  }, label), children);
};
/**
 * Default props for the component.
 */

ImagePreview.defaultProps = {
  "data-componentid": "iframe"
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Danger zone component.
 *
 * @param props - Props injected to the danger zone component.
 *
 * @returns Danger Zone component.
 */

const DangerZone = props => {
  const {
    actionTitle,
    header,
    subheader,
    onActionClick,
    toggle,
    isButtonDisabled,
    buttonDisableHint,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const {
    isMobileViewport
  } = useMediaContext();
  return /*#__PURE__*/React__default.createElement(Segment, {
    "data-testid": testId,
    "data-componentid": componentId,
    className: "danger-zone",
    padded: true,
    clearing: true
  }, /*#__PURE__*/React__default.createElement(Header$1, {
    as: "h5",
    color: "red",
    floated: "left",
    "data-componentid": `${componentId}-header`,
    "data-testid": `${testId}-header`
  }, header, /*#__PURE__*/React__default.createElement(Header$1.Subheader, {
    className: "sub-header",
    "data-componentid": `${componentId}-sub-header`,
    "data-testid": `${testId}-sub-header`
  }, subheader)), toggle ? /*#__PURE__*/React__default.createElement(Checkbox, {
    toggle: true,
    id: toggle === null || toggle === void 0 ? void 0 : toggle.id,
    onChange: toggle === null || toggle === void 0 ? void 0 : toggle.onChange,
    checked: toggle === null || toggle === void 0 ? void 0 : toggle.checked,
    className: "danger-zone toggle-switch",
    "data-componentid": `${componentId}-toggle`,
    "data-testid": `${testId}-toggle`
  }) : /*#__PURE__*/React__default.createElement(Popup, {
    trigger: /*#__PURE__*/React__default.createElement("div", {
      className: isMobileViewport ? "mb-1x mt-1x inline-button button-width" : "inline-button"
    }, /*#__PURE__*/React__default.createElement(Button$1, {
      "data-componentid": componentId + "-delete-button",
      "data-testid": testId + "-delete-button",
      fluid: isMobileViewport,
      negative: true,
      onClick: onActionClick,
      disabled: isButtonDisabled
    }, actionTitle)),
    content: buttonDisableHint,
    position: isMobileViewport ? "top center" : "top right",
    size: "mini",
    wide: true,
    disabled: !isButtonDisabled || !buttonDisableHint
  }));
};
/**
 * Default props for the danger zone component.
 */

DangerZone.defaultProps = {
  "data-componentid": "danger-zone",
  "data-testid": "danger-zone"
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Danger zone group component.
 *
 * @param props - Props injected to the danger zone group component.
 *
 * @returns the Danger zone group component
 */

const DangerZoneGroup = props => {
  const {
    sectionHeader,
    children,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React__default.createElement("div", {
    className: "danger-zone-group-wrapper"
  }, /*#__PURE__*/React__default.createElement(Header$1, {
    as: "h5",
    className: "bold-text",
    "data-componentid": `${componentId}-header`,
    "data-testid": `${testId}-header`
  }, sectionHeader), /*#__PURE__*/React__default.createElement(Segment.Group, {
    className: "danger-zone-group",
    "data-componentid": `${componentId}`,
    "data-testid": `${testId}`
  }, children));
};
/**
 * Default props for the danger zone group component.
 */

DangerZoneGroup.defaultProps = {
  "data-componentid": "danger-zone-group",
  "data-testid": "danger-zone-group"
};

/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const DocumentationContext = /*#__PURE__*/createContext(null);

/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Provides documentation links as context
 */

const useDocumentation = () => {
  const config = useContext(DocumentationContext);

  const getLink = key => get$2(config === null || config === void 0 ? void 0 : config.links, key);

  return {
    getLink
  };
};

/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Documentation link anchor tag component.
 *
 * @param props - Props injected to the component.
 *
 * @returns DocumentationLink Component.
 */

const DocumentationLink = props => {
  const {
    children,
    className,
    link,
    isLinkRef,
    target,
    showEmptyLink,
    showIcon,
    ["data-componentid"]: componentId
  } = props;
  const {
    getLink
  } = useDocumentation();

  if (link === undefined) {
    return null;
  }

  const classes = classNames("documentation-link ml-1 link external no-wrap", className);
  const url = isLinkRef ? getLink(link) : link;
  return !(!showEmptyLink && (!url || url === "#")) && /*#__PURE__*/React__default.createElement("a", {
    href: url,
    target: target,
    rel: "noopener noreferrer",
    className: classes,
    "data-componentid": componentId
  }, children, showIcon && /*#__PURE__*/React__default.createElement(Icon, {
    className: "ml-2",
    name: "external alternate"
  }));
};
/**
 * Prop types for the DocumentationLink component.
 */

DocumentationLink.defaultProps = {
  "data-componentid": "documentation-link",
  showEmptyLink: true,
  showIcon: true,
  target: "_blank"
};

/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * DocumentationContext Provider.
 *
 * @param props - Wrap content/elements.
 * @returns DocumentationContext Provider.
 */

const DocumentationProvider = props => {
  const {
    children,
    links
  } = props;
  /**
   * Render state, dispatch and special case actions.
   */

  return /*#__PURE__*/React__default.createElement(DocumentationContext.Provider, {
    value: {
      links
    }
  }, children);
};

var img = "data:image/svg+xml,%3c!-- * Copyright (c) 2021%2c WSO2 Inc. (http://www.wso2.org) All Rights Reserved. * * WSO2 Inc. licenses this file to you under the Apache License%2c * Version 2.0 (the 'License')%3b you may not use this file except * in compliance with the License. * You may obtain a copy of the License at * * http://www.apache.org/licenses/LICENSE-2.0 * * Unless required by applicable law or agreed to in writing%2c * software distributed under the License is distributed on an * 'AS IS' BASIS%2c WITHOUT WARRANTIES OR CONDITIONS OF ANY * KIND%2c either express or implied. See the License for the * specific language governing permissions and limitations * under the License.--%3e%3csvg class='icon' id='app-switch-icon' xmlns='http://www.w3.org/2000/svg' width='20' height='20' viewBox='0 0 20 20'%3e %3cpath id='apps' d='M-4188.615-10845.308a2.309%2c2.309%2c0%2c0%2c1%2c2.308-2.309%2c2.309%2c2.309%2c0%2c0%2c1%2c2.308%2c2.309%2c2.307%2c2.307%2c0%2c0%2c1-2.308%2c2.307A2.307%2c2.307%2c0%2c0%2c1-4188.615-10845.308Zm-7.693%2c0a2.309%2c2.309%2c0%2c0%2c1%2c2.308-2.309%2c2.309%2c2.309%2c0%2c0%2c1%2c2.308%2c2.309A2.307%2c2.307%2c0%2c0%2c1-4194-10843%2c2.307%2c2.307%2c0%2c0%2c1-4196.308-10845.308Zm-7.692%2c0a2.309%2c2.309%2c0%2c0%2c1%2c2.308-2.309%2c2.309%2c2.309%2c0%2c0%2c1%2c2.308%2c2.309%2c2.307%2c2.307%2c0%2c0%2c1-2.308%2c2.307A2.307%2c2.307%2c0%2c0%2c1-4204-10845.308Zm15.385-7.693a2.307%2c2.307%2c0%2c0%2c1%2c2.308-2.307A2.307%2c2.307%2c0%2c0%2c1-4184-10853a2.308%2c2.308%2c0%2c0%2c1-2.308%2c2.309A2.307%2c2.307%2c0%2c0%2c1-4188.615-10853Zm-7.693%2c0a2.307%2c2.307%2c0%2c0%2c1%2c2.308-2.307%2c2.307%2c2.307%2c0%2c0%2c1%2c2.308%2c2.307%2c2.308%2c2.308%2c0%2c0%2c1-2.308%2c2.309A2.308%2c2.308%2c0%2c0%2c1-4196.308-10853Zm-7.692%2c0a2.307%2c2.307%2c0%2c0%2c1%2c2.308-2.307%2c2.307%2c2.307%2c0%2c0%2c1%2c2.308%2c2.307%2c2.307%2c2.307%2c0%2c0%2c1-2.308%2c2.309A2.308%2c2.308%2c0%2c0%2c1-4204-10853Zm15.385-7.691a2.309%2c2.309%2c0%2c0%2c1%2c2.308-2.309%2c2.309%2c2.309%2c0%2c0%2c1%2c2.308%2c2.309%2c2.307%2c2.307%2c0%2c0%2c1-2.308%2c2.307A2.307%2c2.307%2c0%2c0%2c1-4188.615-10860.692Zm-7.693%2c0A2.309%2c2.309%2c0%2c0%2c1-4194-10863a2.309%2c2.309%2c0%2c0%2c1%2c2.308%2c2.309%2c2.307%2c2.307%2c0%2c0%2c1-2.308%2c2.307A2.307%2c2.307%2c0%2c0%2c1-4196.308-10860.692Zm-7.692%2c0a2.309%2c2.309%2c0%2c0%2c1%2c2.308-2.309%2c2.309%2c2.309%2c0%2c0%2c1%2c2.308%2c2.309%2c2.307%2c2.307%2c0%2c0%2c1-2.308%2c2.307A2.307%2c2.307%2c0%2c0%2c1-4204-10860.692Z' transform='translate(4204 10863.001)' fill='white'/%3e%3c/svg%3e";

/**
 * App Switcher component to switch between apps.
 */

const AppSwitcher = props => {
  const {
    apps,
    enabled,
    className,
    tooltip,
    tooltipOptions,
    triggerIcon,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["apps", "enabled", "className", "tooltip", "tooltipOptions", "triggerIcon", "data-componentid", "data-testid"]);

  const classes = classNames("header-dropdown", "app-switch-dropdown", className);
  /**
   * Stops the dropdown from closing on click.
   *
   * @param e - Click event.
   */

  const handleDropdownClick = e => {
    e.stopPropagation();
  };

  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, enabled && /*#__PURE__*/React__default.createElement(Tooltip, Object.assign({
    compact: true,
    disabled: tooltip === undefined,
    trigger: /*#__PURE__*/React__default.createElement(Dropdown, Object.assign({
      icon: triggerIcon !== null && triggerIcon !== void 0 ? triggerIcon : /*#__PURE__*/React__default.createElement(GenericIcon, {
        inverted: true,
        transparent: true,
        hoverable: true,
        hoverType: "circular",
        icon: img,
        fill: "white",
        size: "auto"
      }),
      className: classes,
      "data-componentid": componentId,
      "data-testid": testId
    }, rest), /*#__PURE__*/React__default.createElement(Dropdown.Menu, {
      pointing: true,
      className: "header-dropdown-menu",
      onClick: handleDropdownClick
    }, apps && Array.isArray(apps) && apps.length > 0 && apps.map((app, index) => {
      const {
        enabled,
        icon,
        name,
        description
      } = app,
            appRest = __rest(app, ["enabled", "icon", "name", "description"]);

      if (!enabled) {
        return null;
      }

      return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Dropdown.Item, Object.assign({
        key: index,
        className: "header-dropdown-item"
      }, appRest), /*#__PURE__*/React__default.createElement(Item, {
        className: "header-dropdown-item-inner flex"
      }, /*#__PURE__*/React__default.createElement(GenericIcon, {
        "data-componentid": `${appRest["data-componentid"]}-icon`,
        "data-testid": `${appRest["data-testid"]}-icon`,
        inline: true,
        transparent: true,
        icon: icon,
        size: "x30",
        spaced: "right"
      }), /*#__PURE__*/React__default.createElement(Item.Content, {
        verticalAlign: "middle"
      }, /*#__PURE__*/React__default.createElement(Item.Header, {
        "data-componentid": `${appRest["data-componentid"]}-name`,
        "data-testid": `${appRest["data-testid"]}-name`
      }, name), /*#__PURE__*/React__default.createElement(Item.Meta, {
        "data-componentid": `${appRest["data-componentid"]}-description`,
        "data-testid": `${appRest["data-testid"]}-description`
      }, description)))), index !== apps.length - 1 && /*#__PURE__*/React__default.createElement(Dropdown.Divider, null));
    }))),
    content: tooltip,
    size: "mini"
  }, tooltipOptions)));
};
/**
 * Default props for the component.
 */

AppSwitcher.defaultProps = {
  "data-componentid": "app-switcher",
  "data-testid": "app-switcher",
  enabled: true,
  floating: true,
  item: true,
  pointing: "top right",
  tooltip: "Apps"
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Error boundary component to avoid JavaScript errors from breaking
 * the entire app due to an error in a specific UI part.
 * This component is an implementation of the error boundary concept
 * introduced in React 16.
 * @see {@link https://reactjs.org/docs/error-boundaries.html}
 *
 * @param props - Props injected in to the placeholder component.
 * @returns a JSX Element
 */

class ErrorBoundary extends Component {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      errorInfo: null
    };
  }

  componentDidCatch(error, errorInfo) {
    const {
      onChunkLoadError,
      handleError
    } = this.props;
    handleError && handleError(error, errorInfo);

    if (error.name === "ChunkLoadError") {
      onChunkLoadError && onChunkLoadError();
    } // Catch errors in any components below and re-render with error message


    this.setState({
      error,
      errorInfo
    });
  }

  render() {
    const {
      errorInfo
    } = this.state;
    const {
      children,
      fallback
    } = this.props; // If there's an error, render the fallback.

    if (errorInfo) {
      return fallback;
    } // Just render children


    return children;
  }

}

ErrorBoundary.propTypes = {
  children: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.node), PropTypes.node, PropTypes.func]),
  fallback: PropTypes.element,
  handleError: PropTypes.func,
  onChunkLoadError: PropTypes.func
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Language switcher dropdown component.
 *
 * @param props - Props passed in to the language switcher dropdown component.
 *
 * @returns the language switcher dropdown component
 */

const LanguageSwitcherDropdown = props => {
  const {
    direction,
    className,
    language,
    changeLanguage,
    upward,
    supportedLanguages,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;

  const LanguageSwitcherTrigger = () => {
    var _a;

    return /*#__PURE__*/React__default.createElement("span", {
      className: "dropdown-trigger link",
      "data-componentid": `${componentId}-trigger`,
      "data-testid": `${testId}-trigger`
    }, // False alarm. `name` is declared in `SupportedLanguagesInterface`.

    /* eslint-disable-next-line react/prop-types */
    (_a = supportedLanguages[language]) === null || _a === void 0 ? void 0 : _a.name);
  };

  return /*#__PURE__*/React__default.createElement(Dropdown, {
    item: true,
    className: className,
    upward: upward,
    trigger: LanguageSwitcherTrigger(),
    direction: direction,
    "data-componentid": componentId,
    "data-testid": testId,
    floating: true
  }, /*#__PURE__*/React__default.createElement(Dropdown.Menu, null, Object.values(supportedLanguages).map((lang, index) => /*#__PURE__*/React__default.createElement(Dropdown.Item, {
    key: index,
    onClick: changeLanguage,
    value: lang === null || lang === void 0 ? void 0 : lang.code,
    "data-componentid": `${componentId}-language`,
    "data-testid": `${testId}-language`
  }, /*#__PURE__*/React__default.createElement(Flag, {
    name: lang === null || lang === void 0 ? void 0 : lang.flag
  }), lang === null || lang === void 0 ? void 0 : lang.name))));
};
/**
 * Default proptypes for the language switcher dropdown component.
 */

LanguageSwitcherDropdown.defaultProps = {
  "data-componentid": "language-switcher-dropdown",
  "data-testid": "language-switcher-dropdown",
  showCaret: false
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Language switcher component.
 *
 * @param props - Props passed in to the language switcher component.
 *
 * @returns the language switcher component.
 */

const LanguageSwitcher = props => {
  const {
    className,
    currentLanguage,
    direction,
    onLanguageChange,
    showDropdownCaret,
    supportedLanguages,
    upward,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  /**
   * Handles the language change.
   *
   * @param event - Click event.
   * @param data - data object returned from the dropdown item.
   */

  const handleLanguageChange = (event, data) => {
    onLanguageChange(data.value);
  };

  return /*#__PURE__*/React__default.createElement(LanguageSwitcherDropdown, {
    className: className,
    direction: direction,
    upward: upward,
    language: currentLanguage,
    changeLanguage: handleLanguageChange,
    showCaret: showDropdownCaret,
    supportedLanguages: supportedLanguages,
    "data-componentid": componentId,
    "data-testid": testId
  });
};
/**
 * Default proptypes for the language switcher component.
 */

LanguageSwitcher.defaultProps = {
  "data-componentid": "language-switcher",
  "data-testid": "language-switcher",
  direction: "left",
  showDropdownCaret: false,
  upward: true
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Footer component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Footer React Component
 */

const Footer = props => {
  const {
    className,
    copyright,
    currentLanguage,
    fixed,
    fluid,
    links,
    onLanguageChange,
    showLanguageSwitcher,
    showLanguageSwitcherDropdownCaret,
    supportedLanguages,
    ["data-testid"]: testId,
    ["data-componentid"]: componentId
  } = props;
  const classes = classNames("app-footer", {
    ["fluid-footer"]: fluid
  }, className);
  return /*#__PURE__*/React__default.createElement(Menu, {
    stackable: true,
    id: "app-footer",
    className: classes,
    fixed: fixed,
    fluid: fluid,
    borderless: true,
    "data-componentid": componentId,
    "data-testid": testId
  }, /*#__PURE__*/React__default.createElement(Container, {
    fluid: fluid,
    "data-componentid": `${componentId}-container`,
    "data-testid": `${testId}-container`,
    className: "app-footer-container"
  }, /*#__PURE__*/React__default.createElement(Menu.Item, {
    className: "copyright",
    "data-componentid": `${componentId}-copyright`,
    "data-testid": `${testId}-copyright`
  }, copyright), /*#__PURE__*/React__default.createElement(Menu.Menu, {
    position: "right",
    "data-componentid": `${componentId}-menu`,
    "data-testid": `${testId}-menu`
  }, // Only show language switcher if it is set to show and if the required props are passed in.
  showLanguageSwitcher && currentLanguage && onLanguageChange && supportedLanguages ? /*#__PURE__*/React__default.createElement(LanguageSwitcher, {
    className: "footer-dropdown",
    currentLanguage: currentLanguage,
    onLanguageChange: onLanguageChange,
    showDropdownCaret: showLanguageSwitcherDropdownCaret,
    supportedLanguages: supportedLanguages,
    "data-componentid": `${componentId}-language-switcher`,
    "data-testid": `${testId}-language-switcher`
  }) : null, links && links.length && links.length > 0 ? links.map((link, index) => /*#__PURE__*/React__default.createElement(Menu.Item, {
    className: "footer-link",
    as: Link$1,
    key: index,
    to: link.to,
    "data-componentid": `${componentId}-link-${link.name}`,
    "data-testid": `${testId}-link-${link.name}`
  }, link.name)) : null)));
};
/**
 * Default proptypes for the footer component.
 */

Footer.defaultProps = {
  "data-componentid": "app-footer",
  "data-testid": "app-footer",
  fixed: "bottom",
  fluid: false,
  showLanguageSwitcher: false,
  showLanguageSwitcherDropdownCaret: false
};

/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Content to define a form section.
 *
 * @param props - Props injected to the component.
 *
 * @returns FormSection React Component
 */

const FormSection = props => {
  const {
    children,
    className,
    heading,
    headingLevel,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("form-section", className);
  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    "data-testid": testId,
    "data-componentid": componentId
  }, /*#__PURE__*/React__default.createElement(Divider, {
    className: "form-section-top-divider"
  }), /*#__PURE__*/React__default.createElement(Heading, {
    className: "form-section-heading",
    as: headingLevel
  }, heading), /*#__PURE__*/React__default.createElement(Divider, {
    className: "form-section-bottom-divider",
    hidden: true
  }), children);
};
/**
 * Default props for the component.
 */

FormSection.defaultProps = {
  "data-componentid": "form-section",
  "data-testid": "form-section",
  headingLevel: "h5"
};

// a string of all valid unicode whitespaces
var whitespaces$3 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
  '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

var uncurryThis$d = functionUncurryThis;
var requireObjectCoercible$3 = requireObjectCoercible$9;
var toString$7 = toString$d;
var whitespaces$2 = whitespaces$3;

var replace$5 = uncurryThis$d(''.replace);
var whitespace = '[' + whitespaces$2 + ']';
var ltrim = RegExp('^' + whitespace + whitespace + '*');
var rtrim = RegExp(whitespace + whitespace + '*$');

// `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
var createMethod$2 = function (TYPE) {
  return function ($this) {
    var string = toString$7(requireObjectCoercible$3($this));
    if (TYPE & 1) string = replace$5(string, ltrim, '');
    if (TYPE & 2) string = replace$5(string, rtrim, '');
    return string;
  };
};

var stringTrim = {
  // `String.prototype.{ trimLeft, trimStart }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
  start: createMethod$2(1),
  // `String.prototype.{ trimRight, trimEnd }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimend
  end: createMethod$2(2),
  // `String.prototype.trim` method
  // https://tc39.es/ecma262/#sec-string.prototype.trim
  trim: createMethod$2(3)
};

var global$c = global$z;
var fails$e = fails$z;
var uncurryThis$c = functionUncurryThis;
var toString$6 = toString$d;
var trim = stringTrim.trim;
var whitespaces$1 = whitespaces$3;

var $parseInt$1 = global$c.parseInt;
var Symbol$1 = global$c.Symbol;
var ITERATOR$2 = Symbol$1 && Symbol$1.iterator;
var hex = /^[+-]?0x/i;
var exec$3 = uncurryThis$c(hex.exec);
var FORCED$2 = $parseInt$1(whitespaces$1 + '08') !== 8 || $parseInt$1(whitespaces$1 + '0x16') !== 22
  // MS Edge 18- broken with boxed symbols
  || (ITERATOR$2 && !fails$e(function () { $parseInt$1(Object(ITERATOR$2)); }));

// `parseInt` method
// https://tc39.es/ecma262/#sec-parseint-string-radix
var numberParseInt = FORCED$2 ? function parseInt(string, radix) {
  var S = trim(toString$6(string));
  return $parseInt$1(S, (radix >>> 0) || (exec$3(hex, S) ? 16 : 10));
} : $parseInt$1;

var $$8 = _export;
var $parseInt = numberParseInt;

// `parseInt` method
// https://tc39.es/ecma262/#sec-parseint-string-radix
$$8({ global: true, forced: parseInt != $parseInt }, {
  parseInt: $parseInt
});

var call$9 = functionCall;
var hasOwn$5 = hasOwnProperty_1;
var isPrototypeOf$3 = objectIsPrototypeOf;
var regExpFlags = regexpFlags$1;

var RegExpPrototype$2 = RegExp.prototype;

var regexpGetFlags = function (R) {
  var flags = R.flags;
  return flags === undefined && !('flags' in RegExpPrototype$2) && !hasOwn$5(R, 'flags') && isPrototypeOf$3(RegExpPrototype$2, R)
    ? call$9(regExpFlags, R) : flags;
};

var PROPER_FUNCTION_NAME$2 = functionName.PROPER;
var defineBuiltIn$5 = defineBuiltIn$d;
var anObject$6 = anObject$k;
var $toString$2 = toString$d;
var fails$d = fails$z;
var getRegExpFlags$1 = regexpGetFlags;

var TO_STRING = 'toString';
var RegExpPrototype$1 = RegExp.prototype;
var nativeToString = RegExpPrototype$1[TO_STRING];

var NOT_GENERIC = fails$d(function () { return nativeToString.call({ source: 'a', flags: 'b' }) != '/a/b'; });
// FF44- RegExp#toString has a wrong name
var INCORRECT_NAME = PROPER_FUNCTION_NAME$2 && nativeToString.name != TO_STRING;

// `RegExp.prototype.toString` method
// https://tc39.es/ecma262/#sec-regexp.prototype.tostring
if (NOT_GENERIC || INCORRECT_NAME) {
  defineBuiltIn$5(RegExp.prototype, TO_STRING, function toString() {
    var R = anObject$6(this);
    var pattern = $toString$2(R.source);
    var flags = $toString$2(getRegExpFlags$1(R));
    return '/' + pattern + '/' + flags;
  }, { unsafe: true });
}

// eslint-disable-next-line es-x/no-typed-arrays -- safe
var arrayBufferBasicDetection = typeof ArrayBuffer != 'undefined' && typeof DataView != 'undefined';

var defineBuiltIn$4 = defineBuiltIn$d;

var defineBuiltIns$2 = function (target, src, options) {
  for (var key in src) defineBuiltIn$4(target, key, src[key], options);
  return target;
};

var toIntegerOrInfinity$3 = toIntegerOrInfinity$7;
var toLength$5 = toLength$8;

var $RangeError$3 = RangeError;

// `ToIndex` abstract operation
// https://tc39.es/ecma262/#sec-toindex
var toIndex$2 = function (it) {
  if (it === undefined) return 0;
  var number = toIntegerOrInfinity$3(it);
  var length = toLength$5(number);
  if (number !== length) throw $RangeError$3('Wrong length or index');
  return length;
};

// IEEE754 conversions based on https://github.com/feross/ieee754
var $Array$2 = Array;
var abs = Math.abs;
var pow$1 = Math.pow;
var floor$5 = Math.floor;
var log = Math.log;
var LN2 = Math.LN2;

var pack = function (number, mantissaLength, bytes) {
  var buffer = $Array$2(bytes);
  var exponentLength = bytes * 8 - mantissaLength - 1;
  var eMax = (1 << exponentLength) - 1;
  var eBias = eMax >> 1;
  var rt = mantissaLength === 23 ? pow$1(2, -24) - pow$1(2, -77) : 0;
  var sign = number < 0 || number === 0 && 1 / number < 0 ? 1 : 0;
  var index = 0;
  var exponent, mantissa, c;
  number = abs(number);
  // eslint-disable-next-line no-self-compare -- NaN check
  if (number != number || number === Infinity) {
    // eslint-disable-next-line no-self-compare -- NaN check
    mantissa = number != number ? 1 : 0;
    exponent = eMax;
  } else {
    exponent = floor$5(log(number) / LN2);
    c = pow$1(2, -exponent);
    if (number * c < 1) {
      exponent--;
      c *= 2;
    }
    if (exponent + eBias >= 1) {
      number += rt / c;
    } else {
      number += rt * pow$1(2, 1 - eBias);
    }
    if (number * c >= 2) {
      exponent++;
      c /= 2;
    }
    if (exponent + eBias >= eMax) {
      mantissa = 0;
      exponent = eMax;
    } else if (exponent + eBias >= 1) {
      mantissa = (number * c - 1) * pow$1(2, mantissaLength);
      exponent = exponent + eBias;
    } else {
      mantissa = number * pow$1(2, eBias - 1) * pow$1(2, mantissaLength);
      exponent = 0;
    }
  }
  while (mantissaLength >= 8) {
    buffer[index++] = mantissa & 255;
    mantissa /= 256;
    mantissaLength -= 8;
  }
  exponent = exponent << mantissaLength | mantissa;
  exponentLength += mantissaLength;
  while (exponentLength > 0) {
    buffer[index++] = exponent & 255;
    exponent /= 256;
    exponentLength -= 8;
  }
  buffer[--index] |= sign * 128;
  return buffer;
};

var unpack = function (buffer, mantissaLength) {
  var bytes = buffer.length;
  var exponentLength = bytes * 8 - mantissaLength - 1;
  var eMax = (1 << exponentLength) - 1;
  var eBias = eMax >> 1;
  var nBits = exponentLength - 7;
  var index = bytes - 1;
  var sign = buffer[index--];
  var exponent = sign & 127;
  var mantissa;
  sign >>= 7;
  while (nBits > 0) {
    exponent = exponent * 256 + buffer[index--];
    nBits -= 8;
  }
  mantissa = exponent & (1 << -nBits) - 1;
  exponent >>= -nBits;
  nBits += mantissaLength;
  while (nBits > 0) {
    mantissa = mantissa * 256 + buffer[index--];
    nBits -= 8;
  }
  if (exponent === 0) {
    exponent = 1 - eBias;
  } else if (exponent === eMax) {
    return mantissa ? NaN : sign ? -Infinity : Infinity;
  } else {
    mantissa = mantissa + pow$1(2, mantissaLength);
    exponent = exponent - eBias;
  } return (sign ? -1 : 1) * mantissa * pow$1(2, exponent - mantissaLength);
};

var ieee754 = {
  pack: pack,
  unpack: unpack
};

var toObject$6 = toObject$a;
var toAbsoluteIndex$1 = toAbsoluteIndex$4;
var lengthOfArrayLike$6 = lengthOfArrayLike$a;

// `Array.prototype.fill` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.fill
var arrayFill$1 = function fill(value /* , start = 0, end = @length */) {
  var O = toObject$6(this);
  var length = lengthOfArrayLike$6(O);
  var argumentsLength = arguments.length;
  var index = toAbsoluteIndex$1(argumentsLength > 1 ? arguments[1] : undefined, length);
  var end = argumentsLength > 2 ? arguments[2] : undefined;
  var endPos = end === undefined ? length : toAbsoluteIndex$1(end, length);
  while (endPos > index) O[index++] = value;
  return O;
};

var global$b = global$z;
var uncurryThis$b = functionUncurryThis;
var DESCRIPTORS$5 = descriptors;
var NATIVE_ARRAY_BUFFER$1 = arrayBufferBasicDetection;
var FunctionName = functionName;
var createNonEnumerableProperty$3 = createNonEnumerableProperty$9;
var defineBuiltIns$1 = defineBuiltIns$2;
var fails$c = fails$z;
var anInstance$3 = anInstance$5;
var toIntegerOrInfinity$2 = toIntegerOrInfinity$7;
var toLength$4 = toLength$8;
var toIndex$1 = toIndex$2;
var IEEE754 = ieee754;
var getPrototypeOf$1 = objectGetPrototypeOf;
var setPrototypeOf$3 = objectSetPrototypeOf;
var getOwnPropertyNames$2 = objectGetOwnPropertyNames.f;
var defineProperty$3 = objectDefineProperty.f;
var arrayFill = arrayFill$1;
var arraySlice$3 = arraySliceSimple;
var setToStringTag$2 = setToStringTag$6;
var InternalStateModule$5 = internalState;

var PROPER_FUNCTION_NAME$1 = FunctionName.PROPER;
var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
var getInternalState$3 = InternalStateModule$5.get;
var setInternalState$4 = InternalStateModule$5.set;
var ARRAY_BUFFER$1 = 'ArrayBuffer';
var DATA_VIEW = 'DataView';
var PROTOTYPE = 'prototype';
var WRONG_LENGTH$1 = 'Wrong length';
var WRONG_INDEX = 'Wrong index';
var NativeArrayBuffer$1 = global$b[ARRAY_BUFFER$1];
var $ArrayBuffer = NativeArrayBuffer$1;
var ArrayBufferPrototype$1 = $ArrayBuffer && $ArrayBuffer[PROTOTYPE];
var $DataView = global$b[DATA_VIEW];
var DataViewPrototype$1 = $DataView && $DataView[PROTOTYPE];
var ObjectPrototype$1 = Object.prototype;
var Array$1 = global$b.Array;
var RangeError$3 = global$b.RangeError;
var fill = uncurryThis$b(arrayFill);
var reverse = uncurryThis$b([].reverse);

var packIEEE754 = IEEE754.pack;
var unpackIEEE754 = IEEE754.unpack;

var packInt8 = function (number) {
  return [number & 0xFF];
};

var packInt16 = function (number) {
  return [number & 0xFF, number >> 8 & 0xFF];
};

var packInt32 = function (number) {
  return [number & 0xFF, number >> 8 & 0xFF, number >> 16 & 0xFF, number >> 24 & 0xFF];
};

var unpackInt32 = function (buffer) {
  return buffer[3] << 24 | buffer[2] << 16 | buffer[1] << 8 | buffer[0];
};

var packFloat32 = function (number) {
  return packIEEE754(number, 23, 4);
};

var packFloat64 = function (number) {
  return packIEEE754(number, 52, 8);
};

var addGetter$1 = function (Constructor, key) {
  defineProperty$3(Constructor[PROTOTYPE], key, { get: function () { return getInternalState$3(this)[key]; } });
};

var get = function (view, count, index, isLittleEndian) {
  var intIndex = toIndex$1(index);
  var store = getInternalState$3(view);
  if (intIndex + count > store.byteLength) throw RangeError$3(WRONG_INDEX);
  var bytes = getInternalState$3(store.buffer).bytes;
  var start = intIndex + store.byteOffset;
  var pack = arraySlice$3(bytes, start, start + count);
  return isLittleEndian ? pack : reverse(pack);
};

var set = function (view, count, index, conversion, value, isLittleEndian) {
  var intIndex = toIndex$1(index);
  var store = getInternalState$3(view);
  if (intIndex + count > store.byteLength) throw RangeError$3(WRONG_INDEX);
  var bytes = getInternalState$3(store.buffer).bytes;
  var start = intIndex + store.byteOffset;
  var pack = conversion(+value);
  for (var i = 0; i < count; i++) bytes[start + i] = pack[isLittleEndian ? i : count - i - 1];
};

if (!NATIVE_ARRAY_BUFFER$1) {
  $ArrayBuffer = function ArrayBuffer(length) {
    anInstance$3(this, ArrayBufferPrototype$1);
    var byteLength = toIndex$1(length);
    setInternalState$4(this, {
      bytes: fill(Array$1(byteLength), 0),
      byteLength: byteLength
    });
    if (!DESCRIPTORS$5) this.byteLength = byteLength;
  };

  ArrayBufferPrototype$1 = $ArrayBuffer[PROTOTYPE];

  $DataView = function DataView(buffer, byteOffset, byteLength) {
    anInstance$3(this, DataViewPrototype$1);
    anInstance$3(buffer, ArrayBufferPrototype$1);
    var bufferLength = getInternalState$3(buffer).byteLength;
    var offset = toIntegerOrInfinity$2(byteOffset);
    if (offset < 0 || offset > bufferLength) throw RangeError$3('Wrong offset');
    byteLength = byteLength === undefined ? bufferLength - offset : toLength$4(byteLength);
    if (offset + byteLength > bufferLength) throw RangeError$3(WRONG_LENGTH$1);
    setInternalState$4(this, {
      buffer: buffer,
      byteLength: byteLength,
      byteOffset: offset
    });
    if (!DESCRIPTORS$5) {
      this.buffer = buffer;
      this.byteLength = byteLength;
      this.byteOffset = offset;
    }
  };

  DataViewPrototype$1 = $DataView[PROTOTYPE];

  if (DESCRIPTORS$5) {
    addGetter$1($ArrayBuffer, 'byteLength');
    addGetter$1($DataView, 'buffer');
    addGetter$1($DataView, 'byteLength');
    addGetter$1($DataView, 'byteOffset');
  }

  defineBuiltIns$1(DataViewPrototype$1, {
    getInt8: function getInt8(byteOffset) {
      return get(this, 1, byteOffset)[0] << 24 >> 24;
    },
    getUint8: function getUint8(byteOffset) {
      return get(this, 1, byteOffset)[0];
    },
    getInt16: function getInt16(byteOffset /* , littleEndian */) {
      var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
      return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
    },
    getUint16: function getUint16(byteOffset /* , littleEndian */) {
      var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : undefined);
      return bytes[1] << 8 | bytes[0];
    },
    getInt32: function getInt32(byteOffset /* , littleEndian */) {
      return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined));
    },
    getUint32: function getUint32(byteOffset /* , littleEndian */) {
      return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined)) >>> 0;
    },
    getFloat32: function getFloat32(byteOffset /* , littleEndian */) {
      return unpackIEEE754(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 23);
    },
    getFloat64: function getFloat64(byteOffset /* , littleEndian */) {
      return unpackIEEE754(get(this, 8, byteOffset, arguments.length > 1 ? arguments[1] : undefined), 52);
    },
    setInt8: function setInt8(byteOffset, value) {
      set(this, 1, byteOffset, packInt8, value);
    },
    setUint8: function setUint8(byteOffset, value) {
      set(this, 1, byteOffset, packInt8, value);
    },
    setInt16: function setInt16(byteOffset, value /* , littleEndian */) {
      set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
    },
    setUint16: function setUint16(byteOffset, value /* , littleEndian */) {
      set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : undefined);
    },
    setInt32: function setInt32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
    },
    setUint32: function setUint32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : undefined);
    },
    setFloat32: function setFloat32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packFloat32, value, arguments.length > 2 ? arguments[2] : undefined);
    },
    setFloat64: function setFloat64(byteOffset, value /* , littleEndian */) {
      set(this, 8, byteOffset, packFloat64, value, arguments.length > 2 ? arguments[2] : undefined);
    }
  });
} else {
  var INCORRECT_ARRAY_BUFFER_NAME = PROPER_FUNCTION_NAME$1 && NativeArrayBuffer$1.name !== ARRAY_BUFFER$1;
  /* eslint-disable no-new -- required for testing */
  if (!fails$c(function () {
    NativeArrayBuffer$1(1);
  }) || !fails$c(function () {
    new NativeArrayBuffer$1(-1);
  }) || fails$c(function () {
    new NativeArrayBuffer$1();
    new NativeArrayBuffer$1(1.5);
    new NativeArrayBuffer$1(NaN);
    return NativeArrayBuffer$1.length != 1 || INCORRECT_ARRAY_BUFFER_NAME && !CONFIGURABLE_FUNCTION_NAME;
  })) {
    /* eslint-enable no-new -- required for testing */
    $ArrayBuffer = function ArrayBuffer(length) {
      anInstance$3(this, ArrayBufferPrototype$1);
      return new NativeArrayBuffer$1(toIndex$1(length));
    };

    $ArrayBuffer[PROTOTYPE] = ArrayBufferPrototype$1;

    for (var keys$1 = getOwnPropertyNames$2(NativeArrayBuffer$1), j = 0, key; keys$1.length > j;) {
      if (!((key = keys$1[j++]) in $ArrayBuffer)) {
        createNonEnumerableProperty$3($ArrayBuffer, key, NativeArrayBuffer$1[key]);
      }
    }

    ArrayBufferPrototype$1.constructor = $ArrayBuffer;
  } else if (INCORRECT_ARRAY_BUFFER_NAME && CONFIGURABLE_FUNCTION_NAME) {
    createNonEnumerableProperty$3(NativeArrayBuffer$1, 'name', ARRAY_BUFFER$1);
  }

  // WebKit bug - the same parent prototype for typed arrays and data view
  if (setPrototypeOf$3 && getPrototypeOf$1(DataViewPrototype$1) !== ObjectPrototype$1) {
    setPrototypeOf$3(DataViewPrototype$1, ObjectPrototype$1);
  }

  // iOS Safari 7.x bug
  var testView = new $DataView(new $ArrayBuffer(2));
  var $setInt8 = uncurryThis$b(DataViewPrototype$1.setInt8);
  testView.setInt8(0, 2147483648);
  testView.setInt8(1, 2147483649);
  if (testView.getInt8(0) || !testView.getInt8(1)) defineBuiltIns$1(DataViewPrototype$1, {
    setInt8: function setInt8(byteOffset, value) {
      $setInt8(this, byteOffset, value << 24 >> 24);
    },
    setUint8: function setUint8(byteOffset, value) {
      $setInt8(this, byteOffset, value << 24 >> 24);
    }
  }, { unsafe: true });
}

setToStringTag$2($ArrayBuffer, ARRAY_BUFFER$1);
setToStringTag$2($DataView, DATA_VIEW);

var arrayBuffer = {
  ArrayBuffer: $ArrayBuffer,
  DataView: $DataView
};

var $$7 = _export;
var global$a = global$z;
var arrayBufferModule = arrayBuffer;
var setSpecies$2 = setSpecies$4;

var ARRAY_BUFFER = 'ArrayBuffer';
var ArrayBuffer$4 = arrayBufferModule[ARRAY_BUFFER];
var NativeArrayBuffer = global$a[ARRAY_BUFFER];

// `ArrayBuffer` constructor
// https://tc39.es/ecma262/#sec-arraybuffer-constructor
$$7({ global: true, constructor: true, forced: NativeArrayBuffer !== ArrayBuffer$4 }, {
  ArrayBuffer: ArrayBuffer$4
});

setSpecies$2(ARRAY_BUFFER);

var $$6 = _export;
var uncurryThis$a = functionUncurryThis;
var fails$b = fails$z;
var ArrayBufferModule$1 = arrayBuffer;
var anObject$5 = anObject$k;
var toAbsoluteIndex = toAbsoluteIndex$4;
var toLength$3 = toLength$8;
var speciesConstructor = speciesConstructor$4;

var ArrayBuffer$3 = ArrayBufferModule$1.ArrayBuffer;
var DataView$2 = ArrayBufferModule$1.DataView;
var DataViewPrototype = DataView$2.prototype;
var nativeArrayBufferSlice = uncurryThis$a(ArrayBuffer$3.prototype.slice);
var getUint8 = uncurryThis$a(DataViewPrototype.getUint8);
var setUint8 = uncurryThis$a(DataViewPrototype.setUint8);

var INCORRECT_SLICE = fails$b(function () {
  return !new ArrayBuffer$3(2).slice(1, undefined).byteLength;
});

// `ArrayBuffer.prototype.slice` method
// https://tc39.es/ecma262/#sec-arraybuffer.prototype.slice
$$6({ target: 'ArrayBuffer', proto: true, unsafe: true, forced: INCORRECT_SLICE }, {
  slice: function slice(start, end) {
    if (nativeArrayBufferSlice && end === undefined) {
      return nativeArrayBufferSlice(anObject$5(this), start); // FF fix
    }
    var length = anObject$5(this).byteLength;
    var first = toAbsoluteIndex(start, length);
    var fin = toAbsoluteIndex(end === undefined ? length : end, length);
    var result = new (speciesConstructor(this, ArrayBuffer$3))(toLength$3(fin - first));
    var viewSource = new DataView$2(this);
    var viewTarget = new DataView$2(result);
    var index = 0;
    while (first < fin) {
      setUint8(viewTarget, index++, getUint8(viewSource, first++));
    } return result;
  }
});

var typedArrayConstructor = {exports: {}};

var NATIVE_ARRAY_BUFFER = arrayBufferBasicDetection;
var DESCRIPTORS$4 = descriptors;
var global$9 = global$z;
var isCallable$3 = isCallable$r;
var isObject$5 = isObject$f;
var hasOwn$4 = hasOwnProperty_1;
var classof$4 = classof$a;
var tryToString$1 = tryToString$6;
var createNonEnumerableProperty$2 = createNonEnumerableProperty$9;
var defineBuiltIn$3 = defineBuiltIn$d;
var defineProperty$2 = objectDefineProperty.f;
var isPrototypeOf$2 = objectIsPrototypeOf;
var getPrototypeOf = objectGetPrototypeOf;
var setPrototypeOf$2 = objectSetPrototypeOf;
var wellKnownSymbol$5 = wellKnownSymbol$n;
var uid = uid$3;
var InternalStateModule$4 = internalState;

var enforceInternalState$2 = InternalStateModule$4.enforce;
var getInternalState$2 = InternalStateModule$4.get;
var Int8Array$4 = global$9.Int8Array;
var Int8ArrayPrototype$1 = Int8Array$4 && Int8Array$4.prototype;
var Uint8ClampedArray$1 = global$9.Uint8ClampedArray;
var Uint8ClampedArrayPrototype = Uint8ClampedArray$1 && Uint8ClampedArray$1.prototype;
var TypedArray$1 = Int8Array$4 && getPrototypeOf(Int8Array$4);
var TypedArrayPrototype$1 = Int8ArrayPrototype$1 && getPrototypeOf(Int8ArrayPrototype$1);
var ObjectPrototype = Object.prototype;
var TypeError$3 = global$9.TypeError;

var TO_STRING_TAG = wellKnownSymbol$5('toStringTag');
var TYPED_ARRAY_TAG$1 = uid('TYPED_ARRAY_TAG');
var TYPED_ARRAY_CONSTRUCTOR = 'TypedArrayConstructor';
// Fixing native typed arrays in Opera Presto crashes the browser, see #595
var NATIVE_ARRAY_BUFFER_VIEWS$2 = NATIVE_ARRAY_BUFFER && !!setPrototypeOf$2 && classof$4(global$9.opera) !== 'Opera';
var TYPED_ARRAY_TAG_REQUIRED = false;
var NAME, Constructor, Prototype;

var TypedArrayConstructorsList = {
  Int8Array: 1,
  Uint8Array: 1,
  Uint8ClampedArray: 1,
  Int16Array: 2,
  Uint16Array: 2,
  Int32Array: 4,
  Uint32Array: 4,
  Float32Array: 4,
  Float64Array: 8
};

var BigIntArrayConstructorsList = {
  BigInt64Array: 8,
  BigUint64Array: 8
};

var isView = function isView(it) {
  if (!isObject$5(it)) return false;
  var klass = classof$4(it);
  return klass === 'DataView'
    || hasOwn$4(TypedArrayConstructorsList, klass)
    || hasOwn$4(BigIntArrayConstructorsList, klass);
};

var getTypedArrayConstructor = function (it) {
  var proto = getPrototypeOf(it);
  if (!isObject$5(proto)) return;
  var state = getInternalState$2(proto);
  return (state && hasOwn$4(state, TYPED_ARRAY_CONSTRUCTOR)) ? state[TYPED_ARRAY_CONSTRUCTOR] : getTypedArrayConstructor(proto);
};

var isTypedArray$1 = function (it) {
  if (!isObject$5(it)) return false;
  var klass = classof$4(it);
  return hasOwn$4(TypedArrayConstructorsList, klass)
    || hasOwn$4(BigIntArrayConstructorsList, klass);
};

var aTypedArray$4 = function (it) {
  if (isTypedArray$1(it)) return it;
  throw TypeError$3('Target is not a typed array');
};

var aTypedArrayConstructor$2 = function (C) {
  if (isCallable$3(C) && (!setPrototypeOf$2 || isPrototypeOf$2(TypedArray$1, C))) return C;
  throw TypeError$3(tryToString$1(C) + ' is not a typed array constructor');
};

var exportTypedArrayMethod$4 = function (KEY, property, forced, options) {
  if (!DESCRIPTORS$4) return;
  if (forced) for (var ARRAY in TypedArrayConstructorsList) {
    var TypedArrayConstructor = global$9[ARRAY];
    if (TypedArrayConstructor && hasOwn$4(TypedArrayConstructor.prototype, KEY)) try {
      delete TypedArrayConstructor.prototype[KEY];
    } catch (error) {
      // old WebKit bug - some methods are non-configurable
      try {
        TypedArrayConstructor.prototype[KEY] = property;
      } catch (error2) { /* empty */ }
    }
  }
  if (!TypedArrayPrototype$1[KEY] || forced) {
    defineBuiltIn$3(TypedArrayPrototype$1, KEY, forced ? property
      : NATIVE_ARRAY_BUFFER_VIEWS$2 && Int8ArrayPrototype$1[KEY] || property, options);
  }
};

var exportTypedArrayStaticMethod = function (KEY, property, forced) {
  var ARRAY, TypedArrayConstructor;
  if (!DESCRIPTORS$4) return;
  if (setPrototypeOf$2) {
    if (forced) for (ARRAY in TypedArrayConstructorsList) {
      TypedArrayConstructor = global$9[ARRAY];
      if (TypedArrayConstructor && hasOwn$4(TypedArrayConstructor, KEY)) try {
        delete TypedArrayConstructor[KEY];
      } catch (error) { /* empty */ }
    }
    if (!TypedArray$1[KEY] || forced) {
      // V8 ~ Chrome 49-50 `%TypedArray%` methods are non-writable non-configurable
      try {
        return defineBuiltIn$3(TypedArray$1, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS$2 && TypedArray$1[KEY] || property);
      } catch (error) { /* empty */ }
    } else return;
  }
  for (ARRAY in TypedArrayConstructorsList) {
    TypedArrayConstructor = global$9[ARRAY];
    if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
      defineBuiltIn$3(TypedArrayConstructor, KEY, property);
    }
  }
};

for (NAME in TypedArrayConstructorsList) {
  Constructor = global$9[NAME];
  Prototype = Constructor && Constructor.prototype;
  if (Prototype) enforceInternalState$2(Prototype)[TYPED_ARRAY_CONSTRUCTOR] = Constructor;
  else NATIVE_ARRAY_BUFFER_VIEWS$2 = false;
}

for (NAME in BigIntArrayConstructorsList) {
  Constructor = global$9[NAME];
  Prototype = Constructor && Constructor.prototype;
  if (Prototype) enforceInternalState$2(Prototype)[TYPED_ARRAY_CONSTRUCTOR] = Constructor;
}

// WebKit bug - typed arrays constructors prototype is Object.prototype
if (!NATIVE_ARRAY_BUFFER_VIEWS$2 || !isCallable$3(TypedArray$1) || TypedArray$1 === Function.prototype) {
  // eslint-disable-next-line no-shadow -- safe
  TypedArray$1 = function TypedArray() {
    throw TypeError$3('Incorrect invocation');
  };
  if (NATIVE_ARRAY_BUFFER_VIEWS$2) for (NAME in TypedArrayConstructorsList) {
    if (global$9[NAME]) setPrototypeOf$2(global$9[NAME], TypedArray$1);
  }
}

if (!NATIVE_ARRAY_BUFFER_VIEWS$2 || !TypedArrayPrototype$1 || TypedArrayPrototype$1 === ObjectPrototype) {
  TypedArrayPrototype$1 = TypedArray$1.prototype;
  if (NATIVE_ARRAY_BUFFER_VIEWS$2) for (NAME in TypedArrayConstructorsList) {
    if (global$9[NAME]) setPrototypeOf$2(global$9[NAME].prototype, TypedArrayPrototype$1);
  }
}

// WebKit bug - one more object in Uint8ClampedArray prototype chain
if (NATIVE_ARRAY_BUFFER_VIEWS$2 && getPrototypeOf(Uint8ClampedArrayPrototype) !== TypedArrayPrototype$1) {
  setPrototypeOf$2(Uint8ClampedArrayPrototype, TypedArrayPrototype$1);
}

if (DESCRIPTORS$4 && !hasOwn$4(TypedArrayPrototype$1, TO_STRING_TAG)) {
  TYPED_ARRAY_TAG_REQUIRED = true;
  defineProperty$2(TypedArrayPrototype$1, TO_STRING_TAG, { get: function () {
    return isObject$5(this) ? this[TYPED_ARRAY_TAG$1] : undefined;
  } });
  for (NAME in TypedArrayConstructorsList) if (global$9[NAME]) {
    createNonEnumerableProperty$2(global$9[NAME], TYPED_ARRAY_TAG$1, NAME);
  }
}

var arrayBufferViewCore = {
  NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS$2,
  TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQUIRED && TYPED_ARRAY_TAG$1,
  aTypedArray: aTypedArray$4,
  aTypedArrayConstructor: aTypedArrayConstructor$2,
  exportTypedArrayMethod: exportTypedArrayMethod$4,
  exportTypedArrayStaticMethod: exportTypedArrayStaticMethod,
  getTypedArrayConstructor: getTypedArrayConstructor,
  isView: isView,
  isTypedArray: isTypedArray$1,
  TypedArray: TypedArray$1,
  TypedArrayPrototype: TypedArrayPrototype$1
};

/* eslint-disable no-new -- required for testing */

var global$8 = global$z;
var fails$a = fails$z;
var checkCorrectnessOfIteration = checkCorrectnessOfIteration$2;
var NATIVE_ARRAY_BUFFER_VIEWS$1 = arrayBufferViewCore.NATIVE_ARRAY_BUFFER_VIEWS;

var ArrayBuffer$2 = global$8.ArrayBuffer;
var Int8Array$3 = global$8.Int8Array;

var typedArrayConstructorsRequireWrappers = !NATIVE_ARRAY_BUFFER_VIEWS$1 || !fails$a(function () {
  Int8Array$3(1);
}) || !fails$a(function () {
  new Int8Array$3(-1);
}) || !checkCorrectnessOfIteration(function (iterable) {
  new Int8Array$3();
  new Int8Array$3(null);
  new Int8Array$3(1.5);
  new Int8Array$3(iterable);
}, true) || fails$a(function () {
  // Safari (11+) bug - a reason why even Safari 13 should load a typed array polyfill
  return new Int8Array$3(new ArrayBuffer$2(2), 1, undefined).length !== 1;
});

var isObject$4 = isObject$f;

var floor$4 = Math.floor;

// `IsIntegralNumber` abstract operation
// https://tc39.es/ecma262/#sec-isintegralnumber
// eslint-disable-next-line es-x/no-number-isinteger -- safe
var isIntegralNumber$1 = Number.isInteger || function isInteger(it) {
  return !isObject$4(it) && isFinite(it) && floor$4(it) === it;
};

var toIntegerOrInfinity$1 = toIntegerOrInfinity$7;

var $RangeError$2 = RangeError;

var toPositiveInteger$1 = function (it) {
  var result = toIntegerOrInfinity$1(it);
  if (result < 0) throw $RangeError$2("The argument can't be less than 0");
  return result;
};

var toPositiveInteger = toPositiveInteger$1;

var $RangeError$1 = RangeError;

var toOffset$2 = function (it, BYTES) {
  var offset = toPositiveInteger(it);
  if (offset % BYTES) throw $RangeError$1('Wrong offset');
  return offset;
};

var bind$4 = functionBindContext;
var call$8 = functionCall;
var aConstructor = aConstructor$2;
var toObject$5 = toObject$a;
var lengthOfArrayLike$5 = lengthOfArrayLike$a;
var getIterator$2 = getIterator$4;
var getIteratorMethod$2 = getIteratorMethod$5;
var isArrayIteratorMethod$1 = isArrayIteratorMethod$3;
var aTypedArrayConstructor$1 = arrayBufferViewCore.aTypedArrayConstructor;

var typedArrayFrom$1 = function from(source /* , mapfn, thisArg */) {
  var C = aConstructor(this);
  var O = toObject$5(source);
  var argumentsLength = arguments.length;
  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
  var mapping = mapfn !== undefined;
  var iteratorMethod = getIteratorMethod$2(O);
  var i, length, result, step, iterator, next;
  if (iteratorMethod && !isArrayIteratorMethod$1(iteratorMethod)) {
    iterator = getIterator$2(O, iteratorMethod);
    next = iterator.next;
    O = [];
    while (!(step = call$8(next, iterator)).done) {
      O.push(step.value);
    }
  }
  if (mapping && argumentsLength > 2) {
    mapfn = bind$4(mapfn, arguments[2]);
  }
  length = lengthOfArrayLike$5(O);
  result = new (aTypedArrayConstructor$1(C))(length);
  for (i = 0; length > i; i++) {
    result[i] = mapping ? mapfn(O[i], i) : O[i];
  }
  return result;
};

var classof$3 = classofRaw$1;

// `IsArray` abstract operation
// https://tc39.es/ecma262/#sec-isarray
// eslint-disable-next-line es-x/no-array-isarray -- safe
var isArray$1 = Array.isArray || function isArray(argument) {
  return classof$3(argument) == 'Array';
};

var isArray = isArray$1;
var isConstructor$1 = isConstructor$3;
var isObject$3 = isObject$f;
var wellKnownSymbol$4 = wellKnownSymbol$n;

var SPECIES = wellKnownSymbol$4('species');
var $Array$1 = Array;

// a part of `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate
var arraySpeciesConstructor$1 = function (originalArray) {
  var C;
  if (isArray(originalArray)) {
    C = originalArray.constructor;
    // cross-realm fallback
    if (isConstructor$1(C) && (C === $Array$1 || isArray(C.prototype))) C = undefined;
    else if (isObject$3(C)) {
      C = C[SPECIES];
      if (C === null) C = undefined;
    }
  } return C === undefined ? $Array$1 : C;
};

var arraySpeciesConstructor = arraySpeciesConstructor$1;

// `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate
var arraySpeciesCreate$1 = function (originalArray, length) {
  return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
};

var bind$3 = functionBindContext;
var uncurryThis$9 = functionUncurryThis;
var IndexedObject$1 = indexedObject;
var toObject$4 = toObject$a;
var lengthOfArrayLike$4 = lengthOfArrayLike$a;
var arraySpeciesCreate = arraySpeciesCreate$1;

var push$5 = uncurryThis$9([].push);

// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation
var createMethod$1 = function (TYPE) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var IS_FILTER_REJECT = TYPE == 7;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  return function ($this, callbackfn, that, specificCreate) {
    var O = toObject$4($this);
    var self = IndexedObject$1(O);
    var boundFunction = bind$3(callbackfn, that);
    var length = lengthOfArrayLike$4(self);
    var index = 0;
    var create = specificCreate || arraySpeciesCreate;
    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
    var value, result;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (TYPE) {
        if (IS_MAP) target[index] = result; // map
        else if (result) switch (TYPE) {
          case 3: return true;              // some
          case 5: return value;             // find
          case 6: return index;             // findIndex
          case 2: push$5(target, value);      // filter
        } else switch (TYPE) {
          case 4: return false;             // every
          case 7: push$5(target, value);      // filterReject
        }
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
  };
};

var arrayIteration = {
  // `Array.prototype.forEach` method
  // https://tc39.es/ecma262/#sec-array.prototype.foreach
  forEach: createMethod$1(0),
  // `Array.prototype.map` method
  // https://tc39.es/ecma262/#sec-array.prototype.map
  map: createMethod$1(1),
  // `Array.prototype.filter` method
  // https://tc39.es/ecma262/#sec-array.prototype.filter
  filter: createMethod$1(2),
  // `Array.prototype.some` method
  // https://tc39.es/ecma262/#sec-array.prototype.some
  some: createMethod$1(3),
  // `Array.prototype.every` method
  // https://tc39.es/ecma262/#sec-array.prototype.every
  every: createMethod$1(4),
  // `Array.prototype.find` method
  // https://tc39.es/ecma262/#sec-array.prototype.find
  find: createMethod$1(5),
  // `Array.prototype.findIndex` method
  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
  findIndex: createMethod$1(6),
  // `Array.prototype.filterReject` method
  // https://github.com/tc39/proposal-array-filtering
  filterReject: createMethod$1(7)
};

var isCallable$2 = isCallable$r;
var isObject$2 = isObject$f;
var setPrototypeOf$1 = objectSetPrototypeOf;

// makes subclassing work correct for wrapped built-ins
var inheritIfRequired$2 = function ($this, dummy, Wrapper) {
  var NewTarget, NewTargetPrototype;
  if (
    // it can work only with native `setPrototypeOf`
    setPrototypeOf$1 &&
    // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
    isCallable$2(NewTarget = dummy.constructor) &&
    NewTarget !== Wrapper &&
    isObject$2(NewTargetPrototype = NewTarget.prototype) &&
    NewTargetPrototype !== Wrapper.prototype
  ) setPrototypeOf$1($this, NewTargetPrototype);
  return $this;
};

var $$5 = _export;
var global$7 = global$z;
var call$7 = functionCall;
var DESCRIPTORS$3 = descriptors;
var TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS = typedArrayConstructorsRequireWrappers;
var ArrayBufferViewCore$4 = arrayBufferViewCore;
var ArrayBufferModule = arrayBuffer;
var anInstance$2 = anInstance$5;
var createPropertyDescriptor$1 = createPropertyDescriptor$6;
var createNonEnumerableProperty$1 = createNonEnumerableProperty$9;
var isIntegralNumber = isIntegralNumber$1;
var toLength$2 = toLength$8;
var toIndex = toIndex$2;
var toOffset$1 = toOffset$2;
var toPropertyKey = toPropertyKey$4;
var hasOwn$3 = hasOwnProperty_1;
var classof$2 = classof$a;
var isObject$1 = isObject$f;
var isSymbol = isSymbol$3;
var create$1 = objectCreate;
var isPrototypeOf$1 = objectIsPrototypeOf;
var setPrototypeOf = objectSetPrototypeOf;
var getOwnPropertyNames$1 = objectGetOwnPropertyNames.f;
var typedArrayFrom = typedArrayFrom$1;
var forEach = arrayIteration.forEach;
var setSpecies$1 = setSpecies$4;
var definePropertyModule = objectDefineProperty;
var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
var InternalStateModule$3 = internalState;
var inheritIfRequired$1 = inheritIfRequired$2;

var getInternalState$1 = InternalStateModule$3.get;
var setInternalState$3 = InternalStateModule$3.set;
var enforceInternalState$1 = InternalStateModule$3.enforce;
var nativeDefineProperty = definePropertyModule.f;
var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
var round = Math.round;
var RangeError$2 = global$7.RangeError;
var ArrayBuffer$1 = ArrayBufferModule.ArrayBuffer;
var ArrayBufferPrototype = ArrayBuffer$1.prototype;
var DataView$1 = ArrayBufferModule.DataView;
var NATIVE_ARRAY_BUFFER_VIEWS = ArrayBufferViewCore$4.NATIVE_ARRAY_BUFFER_VIEWS;
var TYPED_ARRAY_TAG = ArrayBufferViewCore$4.TYPED_ARRAY_TAG;
var TypedArray = ArrayBufferViewCore$4.TypedArray;
var TypedArrayPrototype = ArrayBufferViewCore$4.TypedArrayPrototype;
var aTypedArrayConstructor = ArrayBufferViewCore$4.aTypedArrayConstructor;
var isTypedArray = ArrayBufferViewCore$4.isTypedArray;
var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';
var WRONG_LENGTH = 'Wrong length';

var fromList = function (C, list) {
  aTypedArrayConstructor(C);
  var index = 0;
  var length = list.length;
  var result = new C(length);
  while (length > index) result[index] = list[index++];
  return result;
};

var addGetter = function (it, key) {
  nativeDefineProperty(it, key, { get: function () {
    return getInternalState$1(this)[key];
  } });
};

var isArrayBuffer = function (it) {
  var klass;
  return isPrototypeOf$1(ArrayBufferPrototype, it) || (klass = classof$2(it)) == 'ArrayBuffer' || klass == 'SharedArrayBuffer';
};

var isTypedArrayIndex = function (target, key) {
  return isTypedArray(target)
    && !isSymbol(key)
    && key in target
    && isIntegralNumber(+key)
    && key >= 0;
};

var wrappedGetOwnPropertyDescriptor = function getOwnPropertyDescriptor(target, key) {
  key = toPropertyKey(key);
  return isTypedArrayIndex(target, key)
    ? createPropertyDescriptor$1(2, target[key])
    : nativeGetOwnPropertyDescriptor(target, key);
};

var wrappedDefineProperty = function defineProperty(target, key, descriptor) {
  key = toPropertyKey(key);
  if (isTypedArrayIndex(target, key)
    && isObject$1(descriptor)
    && hasOwn$3(descriptor, 'value')
    && !hasOwn$3(descriptor, 'get')
    && !hasOwn$3(descriptor, 'set')
    // TODO: add validation descriptor w/o calling accessors
    && !descriptor.configurable
    && (!hasOwn$3(descriptor, 'writable') || descriptor.writable)
    && (!hasOwn$3(descriptor, 'enumerable') || descriptor.enumerable)
  ) {
    target[key] = descriptor.value;
    return target;
  } return nativeDefineProperty(target, key, descriptor);
};

if (DESCRIPTORS$3) {
  if (!NATIVE_ARRAY_BUFFER_VIEWS) {
    getOwnPropertyDescriptorModule.f = wrappedGetOwnPropertyDescriptor;
    definePropertyModule.f = wrappedDefineProperty;
    addGetter(TypedArrayPrototype, 'buffer');
    addGetter(TypedArrayPrototype, 'byteOffset');
    addGetter(TypedArrayPrototype, 'byteLength');
    addGetter(TypedArrayPrototype, 'length');
  }

  $$5({ target: 'Object', stat: true, forced: !NATIVE_ARRAY_BUFFER_VIEWS }, {
    getOwnPropertyDescriptor: wrappedGetOwnPropertyDescriptor,
    defineProperty: wrappedDefineProperty
  });

  typedArrayConstructor.exports = function (TYPE, wrapper, CLAMPED) {
    var BYTES = TYPE.match(/\d+$/)[0] / 8;
    var CONSTRUCTOR_NAME = TYPE + (CLAMPED ? 'Clamped' : '') + 'Array';
    var GETTER = 'get' + TYPE;
    var SETTER = 'set' + TYPE;
    var NativeTypedArrayConstructor = global$7[CONSTRUCTOR_NAME];
    var TypedArrayConstructor = NativeTypedArrayConstructor;
    var TypedArrayConstructorPrototype = TypedArrayConstructor && TypedArrayConstructor.prototype;
    var exported = {};

    var getter = function (that, index) {
      var data = getInternalState$1(that);
      return data.view[GETTER](index * BYTES + data.byteOffset, true);
    };

    var setter = function (that, index, value) {
      var data = getInternalState$1(that);
      if (CLAMPED) value = (value = round(value)) < 0 ? 0 : value > 0xFF ? 0xFF : value & 0xFF;
      data.view[SETTER](index * BYTES + data.byteOffset, value, true);
    };

    var addElement = function (that, index) {
      nativeDefineProperty(that, index, {
        get: function () {
          return getter(this, index);
        },
        set: function (value) {
          return setter(this, index, value);
        },
        enumerable: true
      });
    };

    if (!NATIVE_ARRAY_BUFFER_VIEWS) {
      TypedArrayConstructor = wrapper(function (that, data, offset, $length) {
        anInstance$2(that, TypedArrayConstructorPrototype);
        var index = 0;
        var byteOffset = 0;
        var buffer, byteLength, length;
        if (!isObject$1(data)) {
          length = toIndex(data);
          byteLength = length * BYTES;
          buffer = new ArrayBuffer$1(byteLength);
        } else if (isArrayBuffer(data)) {
          buffer = data;
          byteOffset = toOffset$1(offset, BYTES);
          var $len = data.byteLength;
          if ($length === undefined) {
            if ($len % BYTES) throw RangeError$2(WRONG_LENGTH);
            byteLength = $len - byteOffset;
            if (byteLength < 0) throw RangeError$2(WRONG_LENGTH);
          } else {
            byteLength = toLength$2($length) * BYTES;
            if (byteLength + byteOffset > $len) throw RangeError$2(WRONG_LENGTH);
          }
          length = byteLength / BYTES;
        } else if (isTypedArray(data)) {
          return fromList(TypedArrayConstructor, data);
        } else {
          return call$7(typedArrayFrom, TypedArrayConstructor, data);
        }
        setInternalState$3(that, {
          buffer: buffer,
          byteOffset: byteOffset,
          byteLength: byteLength,
          length: length,
          view: new DataView$1(buffer)
        });
        while (index < length) addElement(that, index++);
      });

      if (setPrototypeOf) setPrototypeOf(TypedArrayConstructor, TypedArray);
      TypedArrayConstructorPrototype = TypedArrayConstructor.prototype = create$1(TypedArrayPrototype);
    } else if (TYPED_ARRAYS_CONSTRUCTORS_REQUIRES_WRAPPERS) {
      TypedArrayConstructor = wrapper(function (dummy, data, typedArrayOffset, $length) {
        anInstance$2(dummy, TypedArrayConstructorPrototype);
        return inheritIfRequired$1(function () {
          if (!isObject$1(data)) return new NativeTypedArrayConstructor(toIndex(data));
          if (isArrayBuffer(data)) return $length !== undefined
            ? new NativeTypedArrayConstructor(data, toOffset$1(typedArrayOffset, BYTES), $length)
            : typedArrayOffset !== undefined
              ? new NativeTypedArrayConstructor(data, toOffset$1(typedArrayOffset, BYTES))
              : new NativeTypedArrayConstructor(data);
          if (isTypedArray(data)) return fromList(TypedArrayConstructor, data);
          return call$7(typedArrayFrom, TypedArrayConstructor, data);
        }(), dummy, TypedArrayConstructor);
      });

      if (setPrototypeOf) setPrototypeOf(TypedArrayConstructor, TypedArray);
      forEach(getOwnPropertyNames$1(NativeTypedArrayConstructor), function (key) {
        if (!(key in TypedArrayConstructor)) {
          createNonEnumerableProperty$1(TypedArrayConstructor, key, NativeTypedArrayConstructor[key]);
        }
      });
      TypedArrayConstructor.prototype = TypedArrayConstructorPrototype;
    }

    if (TypedArrayConstructorPrototype.constructor !== TypedArrayConstructor) {
      createNonEnumerableProperty$1(TypedArrayConstructorPrototype, 'constructor', TypedArrayConstructor);
    }

    enforceInternalState$1(TypedArrayConstructorPrototype).TypedArrayConstructor = TypedArrayConstructor;

    if (TYPED_ARRAY_TAG) {
      createNonEnumerableProperty$1(TypedArrayConstructorPrototype, TYPED_ARRAY_TAG, CONSTRUCTOR_NAME);
    }

    var FORCED = TypedArrayConstructor != NativeTypedArrayConstructor;

    exported[CONSTRUCTOR_NAME] = TypedArrayConstructor;

    $$5({ global: true, constructor: true, forced: FORCED, sham: !NATIVE_ARRAY_BUFFER_VIEWS }, exported);

    if (!(BYTES_PER_ELEMENT in TypedArrayConstructor)) {
      createNonEnumerableProperty$1(TypedArrayConstructor, BYTES_PER_ELEMENT, BYTES);
    }

    if (!(BYTES_PER_ELEMENT in TypedArrayConstructorPrototype)) {
      createNonEnumerableProperty$1(TypedArrayConstructorPrototype, BYTES_PER_ELEMENT, BYTES);
    }

    setSpecies$1(CONSTRUCTOR_NAME);
  };
} else typedArrayConstructor.exports = function () { /* empty */ };

var createTypedArrayConstructor = typedArrayConstructor.exports;

// `Uint8Array` constructor
// https://tc39.es/ecma262/#sec-typedarray-objects
createTypedArrayConstructor('Uint8', function (init) {
  return function Uint8Array(data, byteOffset, length) {
    return init(this, data, byteOffset, length);
  };
});

var toPrimitive = toPrimitive$2;

var $TypeError$2 = TypeError;

// `ToBigInt` abstract operation
// https://tc39.es/ecma262/#sec-tobigint
var toBigInt$1 = function (argument) {
  var prim = toPrimitive(argument, 'number');
  if (typeof prim == 'number') throw $TypeError$2("Can't convert number to bigint");
  // eslint-disable-next-line es-x/no-bigint -- safe
  return BigInt(prim);
};

var ArrayBufferViewCore$3 = arrayBufferViewCore;
var $fill = arrayFill$1;
var toBigInt = toBigInt$1;
var classof$1 = classof$a;
var call$6 = functionCall;
var uncurryThis$8 = functionUncurryThis;
var fails$9 = fails$z;

var aTypedArray$3 = ArrayBufferViewCore$3.aTypedArray;
var exportTypedArrayMethod$3 = ArrayBufferViewCore$3.exportTypedArrayMethod;
var slice = uncurryThis$8(''.slice);

// V8 ~ Chrome < 59, Safari < 14.1, FF < 55, Edge <=18
var CONVERSION_BUG = fails$9(function () {
  var count = 0;
  // eslint-disable-next-line es-x/no-typed-arrays -- safe
  new Int8Array(2).fill({ valueOf: function () { return count++; } });
  return count !== 1;
});

// `%TypedArray%.prototype.fill` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.fill
exportTypedArrayMethod$3('fill', function fill(value /* , start, end */) {
  var length = arguments.length;
  aTypedArray$3(this);
  var actualValue = slice(classof$1(this), 0, 3) === 'Big' ? toBigInt(value) : +value;
  return call$6($fill, this, actualValue, length > 1 ? arguments[1] : undefined, length > 2 ? arguments[2] : undefined);
}, CONVERSION_BUG);

var global$6 = global$z;
var call$5 = functionCall;
var ArrayBufferViewCore$2 = arrayBufferViewCore;
var lengthOfArrayLike$3 = lengthOfArrayLike$a;
var toOffset = toOffset$2;
var toIndexedObject = toObject$a;
var fails$8 = fails$z;

var RangeError$1 = global$6.RangeError;
var Int8Array$2 = global$6.Int8Array;
var Int8ArrayPrototype = Int8Array$2 && Int8Array$2.prototype;
var $set = Int8ArrayPrototype && Int8ArrayPrototype.set;
var aTypedArray$2 = ArrayBufferViewCore$2.aTypedArray;
var exportTypedArrayMethod$2 = ArrayBufferViewCore$2.exportTypedArrayMethod;

var WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS = !fails$8(function () {
  // eslint-disable-next-line es-x/no-typed-arrays -- required for testing
  var array = new Uint8ClampedArray(2);
  call$5($set, array, { length: 1, 0: 3 }, 1);
  return array[1] !== 3;
});

// https://bugs.chromium.org/p/v8/issues/detail?id=11294 and other
var TO_OBJECT_BUG = WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS && ArrayBufferViewCore$2.NATIVE_ARRAY_BUFFER_VIEWS && fails$8(function () {
  var array = new Int8Array$2(2);
  array.set(1);
  array.set('2', 1);
  return array[0] !== 0 || array[1] !== 2;
});

// `%TypedArray%.prototype.set` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.set
exportTypedArrayMethod$2('set', function set(arrayLike /* , offset */) {
  aTypedArray$2(this);
  var offset = toOffset(arguments.length > 1 ? arguments[1] : undefined, 1);
  var src = toIndexedObject(arrayLike);
  if (WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS) return call$5($set, this, src, offset);
  var length = this.length;
  var len = lengthOfArrayLike$3(src);
  var index = 0;
  if (len + offset > length) throw RangeError$1('Wrong length');
  while (index < len) this[offset + index] = src[index++];
}, !WORKS_WITH_OBJECTS_AND_GEERIC_ON_TYPED_ARRAYS || TO_OBJECT_BUG);

var arraySlice$2 = arraySliceSimple;

var floor$3 = Math.floor;

var mergeSort = function (array, comparefn) {
  var length = array.length;
  var middle = floor$3(length / 2);
  return length < 8 ? insertionSort(array, comparefn) : merge(
    array,
    mergeSort(arraySlice$2(array, 0, middle), comparefn),
    mergeSort(arraySlice$2(array, middle), comparefn),
    comparefn
  );
};

var insertionSort = function (array, comparefn) {
  var length = array.length;
  var i = 1;
  var element, j;

  while (i < length) {
    j = i;
    element = array[i];
    while (j && comparefn(array[j - 1], element) > 0) {
      array[j] = array[--j];
    }
    if (j !== i++) array[j] = element;
  } return array;
};

var merge = function (array, left, right, comparefn) {
  var llength = left.length;
  var rlength = right.length;
  var lindex = 0;
  var rindex = 0;

  while (lindex < llength || rindex < rlength) {
    array[lindex + rindex] = (lindex < llength && rindex < rlength)
      ? comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++]
      : lindex < llength ? left[lindex++] : right[rindex++];
  } return array;
};

var arraySort$1 = mergeSort;

var userAgent$1 = engineUserAgent;

var firefox = userAgent$1.match(/firefox\/(\d+)/i);

var engineFfVersion = !!firefox && +firefox[1];

var UA = engineUserAgent;

var engineIsIeOrEdge = /MSIE|Trident/.test(UA);

var userAgent = engineUserAgent;

var webkit = userAgent.match(/AppleWebKit\/(\d+)\./);

var engineWebkitVersion = !!webkit && +webkit[1];

var global$5 = global$z;
var uncurryThis$7 = functionUncurryThis;
var fails$7 = fails$z;
var aCallable$2 = aCallable$a;
var internalSort$1 = arraySort$1;
var ArrayBufferViewCore$1 = arrayBufferViewCore;
var FF$1 = engineFfVersion;
var IE_OR_EDGE$1 = engineIsIeOrEdge;
var V8$1 = engineV8Version;
var WEBKIT$1 = engineWebkitVersion;

var aTypedArray$1 = ArrayBufferViewCore$1.aTypedArray;
var exportTypedArrayMethod$1 = ArrayBufferViewCore$1.exportTypedArrayMethod;
var Uint16Array = global$5.Uint16Array;
var nativeSort$1 = Uint16Array && uncurryThis$7(Uint16Array.prototype.sort);

// WebKit
var ACCEPT_INCORRECT_ARGUMENTS = !!nativeSort$1 && !(fails$7(function () {
  nativeSort$1(new Uint16Array(2), null);
}) && fails$7(function () {
  nativeSort$1(new Uint16Array(2), {});
}));

var STABLE_SORT$1 = !!nativeSort$1 && !fails$7(function () {
  // feature detection can be too slow, so check engines versions
  if (V8$1) return V8$1 < 74;
  if (FF$1) return FF$1 < 67;
  if (IE_OR_EDGE$1) return true;
  if (WEBKIT$1) return WEBKIT$1 < 602;

  var array = new Uint16Array(516);
  var expected = Array(516);
  var index, mod;

  for (index = 0; index < 516; index++) {
    mod = index % 4;
    array[index] = 515 - index;
    expected[index] = index - 2 * mod + 3;
  }

  nativeSort$1(array, function (a, b) {
    return (a / 4 | 0) - (b / 4 | 0);
  });

  for (index = 0; index < 516; index++) {
    if (array[index] !== expected[index]) return true;
  }
});

var getSortCompare$1 = function (comparefn) {
  return function (x, y) {
    if (comparefn !== undefined) return +comparefn(x, y) || 0;
    // eslint-disable-next-line no-self-compare -- NaN check
    if (y !== y) return -1;
    // eslint-disable-next-line no-self-compare -- NaN check
    if (x !== x) return 1;
    if (x === 0 && y === 0) return 1 / x > 0 && 1 / y < 0 ? 1 : -1;
    return x > y;
  };
};

// `%TypedArray%.prototype.sort` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.sort
exportTypedArrayMethod$1('sort', function sort(comparefn) {
  if (comparefn !== undefined) aCallable$2(comparefn);
  if (STABLE_SORT$1) return nativeSort$1(this, comparefn);

  return internalSort$1(aTypedArray$1(this), getSortCompare$1(comparefn));
}, !STABLE_SORT$1 || ACCEPT_INCORRECT_ARGUMENTS);

var global$4 = global$z;
var apply$1 = functionApply;
var ArrayBufferViewCore = arrayBufferViewCore;
var fails$6 = fails$z;
var arraySlice$1 = arraySlice$6;

var Int8Array$1 = global$4.Int8Array;
var aTypedArray = ArrayBufferViewCore.aTypedArray;
var exportTypedArrayMethod = ArrayBufferViewCore.exportTypedArrayMethod;
var $toLocaleString = [].toLocaleString;

// iOS Safari 6.x fails here
var TO_LOCALE_STRING_BUG = !!Int8Array$1 && fails$6(function () {
  $toLocaleString.call(new Int8Array$1(1));
});

var FORCED$1 = fails$6(function () {
  return [1, 2].toLocaleString() != new Int8Array$1([1, 2]).toLocaleString();
}) || !fails$6(function () {
  Int8Array$1.prototype.toLocaleString.call([1, 2]);
});

// `%TypedArray%.prototype.toLocaleString` method
// https://tc39.es/ecma262/#sec-%typedarray%.prototype.tolocalestring
exportTypedArrayMethod('toLocaleString', function toLocaleString() {
  return apply$1(
    $toLocaleString,
    TO_LOCALE_STRING_BUG ? arraySlice$1(aTypedArray(this)) : aTypedArray(this),
    arraySlice$1(arguments)
  );
}, FORCED$1);

// This is a polyfill to support `File.arrayBuffer()` in Safari and IE.

if ("File" in self) File.prototype.arrayBuffer = File.prototype.arrayBuffer || poly;
Blob.prototype.arrayBuffer = Blob.prototype.arrayBuffer || poly;

function poly() {
  // this: File or Blob
  return new Promise(resolve => {
    const fr = new FileReader();

    fr.onload = () => {
      resolve(fr.result);
    };

    fr.readAsArrayBuffer(this);
  });
} // Component constants


const FIRST_FILE_INDEX = 0;
const FIRST_TAB_INDEX = 0;
const SECOND_TAB_INDEX = 1;
const EMPTY_STRING = "";
const FilePicker = props => {
  const {
    fileStrategy,
    onChange,
    dropzoneText,
    pasteAreaPlaceholderText,
    uploadButtonText,
    icon,
    placeholderIcon,
    file: initialFile,
    pastedContent: initialPastedContent,
    normalizeStateOnRemoveOperations,
    emptyFileError,
    emptyFileErrorMsg,
    hidePasteOption,
    ["data-componentid"]: componentId
  } = props; // Document queries

  const hiddenFileUploadInput = useRef(null); // Functional State

  const [dark, setDark] = useState(false);
  const [activeIndex, setActiveIndex] = useState(FIRST_TAB_INDEX);
  const [dragOver, setDragOver] = useState(false); // Behavioural State

  const [file, setFile] = useState(initialFile);
  const [pastedContent, setPastedContent] = useState(initialPastedContent);
  const [serializedData, setSerializedData] = useState(null);
  const [hasError, setHasError] = useState(false);
  const [errorMessage, setErrorMessage] = useState(null);
  const [pasteFieldTouched, setPasteFieldTouched] = useState(false);
  const [fileFieldTouched, setFileFieldTouched] = useState(false); // Hooks

  useEffect(() => {
    if (emptyFileError) {
      setHasError(true);
      setErrorMessage(emptyFileErrorMsg ? emptyFileErrorMsg : "Please add a file");
    }
  }, [emptyFileError]);
  useEffect(() => {
    if (initialFile) {
      addFileToState(initialFile);
      setActiveIndex(FIRST_TAB_INDEX);
      return;
    }

    if (initialPastedContent) {
      addPastedDataToState(initialPastedContent);
      setActiveIndex(SECOND_TAB_INDEX);
      return;
    }
  }, [initialFile, initialPastedContent]);
  useEffect(() => {
    // Query the preferred color scheme.
    const mql = window.matchMedia("(prefers-color-scheme:dark)"); // Check and set the dark mode initially.

    if (mql === null || mql === void 0 ? void 0 : mql.matches) setDark(true); // Callback for triggering the same for change events.

    const triggerColorScheme = event => {
      var _a;

      setDark((_a = event.matches) !== null && _a !== void 0 ? _a : false);
    }; // Check to see if match media API is available with the browser.


    if (mql === null || mql === void 0 ? void 0 : mql.addEventListener) {
      mql.addEventListener("change", triggerColorScheme);
    } // Cleanup logic.


    return () => {
      if (mql === null || mql === void 0 ? void 0 : mql.addEventListener) {
        mql.removeEventListener("change", triggerColorScheme);
      }
    };
  }, []);
  useEffect(() => {
    if (onChange) {
      onChange({
        file: file,
        pastedContent: pastedContent,
        serialized: serializedData,

        /**
         * In order result to be valid. Form should not contain errors,
         * there should be some serialized content, and one of the used
         * input methods. !! is equivalent to val !== null or Boolean(val)
         */
        valid: !hasError && !!serializedData && (!!file || !!pastedContent)
      });
    }
  }, [serializedData, errorMessage, file, pastedContent]); // Functional logic that used by event handlers to
  // update the state of the picker.

  const validate = data => __awaiter(void 0, void 0, void 0, function* () {
    try {
      yield fileStrategy.validate(data);
      setHasError(false);
      setErrorMessage(null);
      return true;
    } catch (error) {
      // Ideally the validation result must be type
      // ValidationResult. However, if for some reason
      // developer overrides it and just send a string
      // or a Error object we need to gracefully handle
      // the result.
      readDynamicErrorAndSetToState(error);
      return false;
    }
  });

  const readDynamicErrorAndSetToState = error => {
    var _a;

    setHasError(true);

    if (error) {
      if (typeof error === "string") {
        setErrorMessage(error);
      } else if (error instanceof Error) {
        setErrorMessage(error === null || error === void 0 ? void 0 : error.message);
      } else if (isTypeValidationResult(error)) {
        setErrorMessage((_a = error.errorMessage) !== null && _a !== void 0 ? _a : EMPTY_STRING);
      } else {
        setErrorMessage("Your input has unknown errors.");
      }
    }
  }; // TODO: As a improvement add multiple tabs option. The implementation
  //       of that is a little tricky. We can achieve the behaviour using
  //       the same strategy pattern but it MUST not complex the concrete
  //       implementation.
  // TODO: As a improvement implement the context component (this)
  //       to support multiple file upload/attach strategy. If attaching
  //       multiple then tabs Paste option should be removed dynamically.
  // TODO: As a improvement compare newly added file or the
  //       pasted content with the previous state and set it
  //       to the state only if its a new change.


  const addFileToState = file => __awaiter(void 0, void 0, void 0, function* () {
    if (yield validate(file)) {
      setFile(file);

      try {
        setSerializedData(yield fileStrategy.serialize(file));
      } catch (error) {
        readDynamicErrorAndSetToState(error);
      }
    }
  });

  const addPastedDataToState = text => __awaiter(void 0, void 0, void 0, function* () {
    if (yield validate(text)) {
      try {
        setSerializedData(yield fileStrategy.serialize(text));
      } catch (error) {
        readDynamicErrorAndSetToState(error);
      }
    }

    setPastedContent(text);
  }); // Events that takes care of the drag drop input. User drops
  // a file onto the drop area.


  const handleOnDrop = event => {
    if (event) {
      event.preventDefault();
      event.stopPropagation();
    }

    setDragOver(false);

    if (event.dataTransfer.files[FIRST_FILE_INDEX]) {
      const file = event.dataTransfer.files[FIRST_FILE_INDEX];

      if (file) {
        addFileToState(file);
        setFileFieldTouched(true);
        setPasteFieldTouched(false);
      } else {
        setFile(null);
      }
    }
  };

  const handleOnDragOver = event => {
    if (event) {
      event.preventDefault();
      event.stopPropagation();
    }

    setDragOver(true);
  };

  const handleOnDragLeave = event => {
    if (event) {
      event.preventDefault();
      event.stopPropagation();
    }

    setDragOver(false);
  }; // Events that takes care of the manual input. Where the user
  // clicks the upload button and related file input field changes.


  const handleOnFileInputChange = event => {
    const file = event.target.files[FIRST_FILE_INDEX];
    event.target.value = null;
    addFileToState(file);
    setFileFieldTouched(true);
    setPasteFieldTouched(false);
  };

  const handleOnUploadButtonClick = event => {
    if (event) {
      event.preventDefault();
      event.stopPropagation();
    }

    hiddenFileUploadInput.current.click();
  };
  /**
   * Once the selected file gets removed. We need to re-evaluate
   * the pasted content properly to send the serialized value to
   * the parent component. This is because the values can differ
   * in both the inputs and can lead to data inconsistencies if
   * not handled properly.
   */


  const normalizeSerializationOnFileRemoval = () => {
    if (pastedContent) {
      addPastedDataToState(pastedContent);
      setActiveIndex(SECOND_TAB_INDEX);
    } else {
      setSerializedData(null);
    }
  };
  /**
   * This should be used when the user removed the entire string
   * from the textarea. Same as above {@link normalizeSerializationOnFileRemoval}
   * scenario we need to re-evaluate the selected file properly and set
   * the serialized value to the parent component since two inputs can
   * have different values simultaneously.
   */


  const normalizeSerializationOnPastedTextClear = () => {
    if (file) {
      addFileToState(file);
      setActiveIndex(FIRST_TAB_INDEX);
    } else {
      setSerializedData(null);
    }
  }; // UI elements and render()


  const dragOption = {
    menuItem: "Upload",
    render: () => {
      const previewPlaceholder = /*#__PURE__*/React__default.createElement(Segment, {
        placeholder: true
      }, /*#__PURE__*/React__default.createElement(Segment, {
        textAlign: "center",
        basic: true
      }, /*#__PURE__*/React__default.createElement(GenericIcon, {
        inline: true,
        transparent: true,
        size: "auto",
        icon: placeholderIcon
      }), /*#__PURE__*/React__default.createElement("p", null, "You have selected ", /*#__PURE__*/React__default.createElement("em", {
        className: "file-name"
      }, file === null || file === void 0 ? void 0 : file.name), " file"), /*#__PURE__*/React__default.createElement("p", null, "Not this file?"), /*#__PURE__*/React__default.createElement(Button$1, {
        inverted: true,
        color: "red",
        onClick: () => {
          setFile(null);
          setFileFieldTouched(false);
          setErrorMessage(null);
          setHasError(false);

          if (normalizeStateOnRemoveOperations) {
            normalizeSerializationOnFileRemoval();
          }
        }
      }, /*#__PURE__*/React__default.createElement(Icon, {
        name: "trash alternate"
      }), " Remove")));
      const dragDropArea = /*#__PURE__*/React__default.createElement("div", {
        onDrop: handleOnDrop,
        onDragOver: handleOnDragOver,
        onDragLeave: handleOnDragLeave,
        "data-testid": "generic-file-upload-dropzone"
      }, /*#__PURE__*/React__default.createElement(Segment, {
        placeholder: true,
        className: `drop-zone ${dragOver && "drag-over"}`
      }, /*#__PURE__*/React__default.createElement("div", {
        className: "certificate-upload-placeholder"
      }, /*#__PURE__*/React__default.createElement(GenericIcon, {
        inline: true,
        transparent: true,
        size: "mini",
        icon: icon
      }), /*#__PURE__*/React__default.createElement("p", {
        className: "description"
      }, dropzoneText), /*#__PURE__*/React__default.createElement("p", {
        className: "description"
      }, "\u2013 or \u2013")), /*#__PURE__*/React__default.createElement(Button$1, {
        basic: true,
        primary: true,
        onClick: handleOnUploadButtonClick
      }, uploadButtonText)));
      return file ? previewPlaceholder : dragDropArea;
    }
  };
  const pasteOption = {
    menuItem: "Paste",
    render: () => {
      return /*#__PURE__*/React__default.createElement(TextArea, {
        rows: 10,
        placeholder: pasteAreaPlaceholderText !== null && pasteAreaPlaceholderText !== void 0 ? pasteAreaPlaceholderText : "Paste your content in this area...",
        value: pastedContent,
        onChange: event => {
          var _a;

          if (event) {
            event.preventDefault();
            event.stopPropagation();
          }

          if ((_a = event === null || event === void 0 ? void 0 : event.target) === null || _a === void 0 ? void 0 : _a.value) {
            addPastedDataToState(event.target.value);
          } else {
            /**
             * CLEAR OPERATION:
             * This block executes when the user have cleared all the content
             * from the textarea and we will evaluate it as a empty string.
             */
            setPastedContent(EMPTY_STRING);
            /**
             * If the string is empty we can't show error messages below the
             * fields. Because, it's like the initial state.
             */

            setErrorMessage(null);
            setHasError(false);

            if (normalizeStateOnRemoveOperations) {
              normalizeSerializationOnPastedTextClear();
            }
          }

          setPasteFieldTouched(true);
          setFileFieldTouched(false);
        },
        spellCheck: false,
        className: `certificate-editor ${dark ? "dark" : "light"}`
      });
    }
  };
  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement("input", {
    hidden: true,
    ref: hiddenFileUploadInput,
    type: "file",
    accept: fileStrategy.mimeTypes.join(","),
    onChange: handleOnFileInputChange,
    "data-componentid": `${componentId}-input`
  }), !hidePasteOption ? /*#__PURE__*/React__default.createElement(Tab, {
    className: "tabs resource-tabs",
    menu: {
      pointing: true,
      secondary: true
    },
    panes: [dragOption, pasteOption],
    activeIndex: activeIndex,
    "data-componentid": `${componentId}-tabs`,
    onTabChange: (event, {
      activeIndex
    }) => {
      const index = parseInt(activeIndex.toString());
      setActiveIndex(index);

      if (index === FIRST_TAB_INDEX && fileFieldTouched && !pastedContent) {
        validate(file);
      } else if (index === SECOND_TAB_INDEX && pasteFieldTouched && !file) {
        validate(pastedContent);
      }
    }
  }) : /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), dragOption.render()), /*#__PURE__*/React__default.createElement(Message$1, {
    error: true,
    visible: hasError,
    "data-testid": "file-picker-error-message",
    "data-componentid": `${componentId}-error-message`
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "file"
  }), errorMessage));
};
FilePicker.defaultProps = {
  "data-componentid": "file-picker",
  hidePasteOption: false
};

function isTypeValidationResult(obj) {
  return obj && ("valid" in obj || "errorMessage" in obj);
} // Concrete strategies implementations.


class DefaultFileStrategy {
  constructor() {
    this.mimeTypes = ["*"];
  }

  serialize() {
    return __awaiter(this, void 0, void 0, function* () {
      return Promise.resolve("");
    });
  }

  validate() {
    return __awaiter(this, void 0, void 0, function* () {
      return Promise.resolve({
        valid: true
      });
    });
  }

}
class XMLFileStrategy {
  constructor(mimeTypes) {
    if (!mimeTypes || mimeTypes.length === 0) this.mimeTypes = XMLFileStrategy.DEFAULT_MIMES;else this.mimeTypes = mimeTypes;
  }

  serialize(data) {
    return __awaiter(this, void 0, void 0, function* () {
      return new Promise((resolve, reject) => {
        if (!data) {
          reject({
            valid: false
          });
          return;
        }

        if (data instanceof File) {
          const reader = new FileReader();
          reader.readAsText(data, XMLFileStrategy.ENCODING);

          reader.onload = () => {
            this.parseXML(reader.result).then(rawXML => {
              resolve(btoa(rawXML));
            }).catch(error => {
              reject({
                errorMessage: error !== null && error !== void 0 ? error : "XML file content is invalid",
                valid: false
              });
            });
          };
        } else {
          this.parseXML(data).then(rawXML => {
            resolve(btoa(rawXML));
          }).catch(error => {
            reject({
              errorMessage: error !== null && error !== void 0 ? error : "XML string is invalid",
              valid: false
            });
          });
        }
      });
    });
  }

  validate(data) {
    return __awaiter(this, void 0, void 0, function* () {
      return new Promise((resolve, reject) => {
        if (data instanceof File) {
          const expected = XMLFileStrategy.MAX_FILE_SIZE * XMLFileStrategy.MEGABYTE;

          if (data.size > expected) {
            reject({
              errorMessage: `File exceeds max size of ${XMLFileStrategy.MAX_FILE_SIZE} MB`,
              valid: false
            });
          }

          const reader = new FileReader();
          reader.readAsText(data, XMLFileStrategy.ENCODING);

          reader.onload = () => {
            this.parseXML(reader.result).then(() => {
              resolve({
                valid: true
              });
            }).catch(error => {
              reject({
                errorMessage: error !== null && error !== void 0 ? error : "XML file has errors",
                valid: false
              });
            });
          };
        } else {
          this.parseXML(data).then(() => {
            resolve({
              valid: true
            });
          }).catch(error => {
            reject({
              errorMessage: error !== null && error !== void 0 ? error : "XML string has errors",
              valid: false
            });
          });
        }
      });
    });
  }

  parseXML(xml) {
    return __awaiter(this, void 0, void 0, function* () {
      const domParser = new DOMParser(); // If the xml is a instance of ArrayBuffer then first
      // convert it to a primitive string.

      if (xml instanceof ArrayBuffer) {
        // TODO: Add the polyfills for IE and older browsers.
        // https://github.com/inexorabletash/text-encoding
        const enc = new TextDecoder(XMLFileStrategy.ENCODING);
        const arr = new Uint8Array(xml);
        xml = enc.decode(arr);
      } // Below this point we can ensure that xml is
      // a string type and proceed to parse.


      const dom = domParser.parseFromString(xml, "text/xml");

      if (dom.getElementsByTagName("parsererror").length > 0) {
        throw "Error while parsing XML file";
      }

      return xml;
    });
  }

}
XMLFileStrategy.ENCODING = "UTF-8";
XMLFileStrategy.DEFAULT_MIMES = ["text/xml", "application/xml"];
XMLFileStrategy.MEGABYTE = 1e+6;
XMLFileStrategy.MAX_FILE_SIZE = 3 * XMLFileStrategy.MEGABYTE;
class CertFileStrategy {
  constructor(mimeTypes) {
    if (!mimeTypes || mimeTypes.length === 0) this.mimeTypes = CertFileStrategy.DEFAULT_MIMES;else this.mimeTypes = mimeTypes;
  }

  serialize(data) {
    if (data instanceof File) {
      return this.convertFromFile(data);
    } else {
      return this.convertFromString(data);
    }
  }

  validate(data) {
    return new Promise((resolve, reject) => {
      if (data instanceof File) {
        this.convertFromFile(data).then(() => {
          resolve({
            valid: true
          });
        }).catch(() => {
          reject({
            errorMessage: "Invalid certificate file. " + "Please use one of the following formats " + this.mimeTypes.join(","),
            valid: false
          });
        });
      } else {
        this.convertFromString(data).then(() => {
          resolve({
            valid: true
          });
        }).catch(() => {
          reject({
            errorMessage: "Invalid certificate pem string.",
            valid: false
          });
        });
      }
    });
  }

  convertFromString(text) {
    return new Promise((resolve, reject) => {
      try {
        const certificateForge = new X509().readCertFromPEM(text);
        resolve({
          forgeObject: certificateForge,
          pem: text,
          pemStripped: CertificateManagementUtils.stripPem(text)
        });
      } catch (_a) {
        try {
          const pemValue = CertificateManagementUtils.enclosePem(text);
          const certificate = forge.pki.certificateFromPem(pemValue);
          const pem = forge.pki.certificateToPem(certificate);
          const certificateForge = new X509();
          certificateForge.readCertPEM(pem);
          resolve({
            forgeObject: certificateForge,
            pem: text,
            pemStripped: CertificateManagementUtils.stripPem(text)
          });
        } catch (error) {
          reject("Failed to decode pem certificate data.");
        }
      }
    });
  }

  convertFromFile(file) {
    return new Promise((resolve, reject) => {
      file.arrayBuffer().then(buf => {
        try {
          const hex = Array.prototype.map.call(new Uint8Array(buf), x => ("00" + x.toString(16)).slice(-2)).join("");
          const cert = new X509();
          cert.readCertHex(hex);
          const certificate = new KJUR.asn1.x509.Certificate(cert.getParam());
          const pem = certificate.getPEM();
          const pemStripped = CertificateManagementUtils.stripPem(pem);
          resolve({
            forgeObject: cert,
            pem: pem,
            pemStripped: pemStripped
          });
        } catch (_a) {
          const byteString = forge.util.createBuffer(buf);

          try {
            const asn1 = forge.asn1.fromDer(byteString);
            const certificate = forge.pki.certificateFromAsn1(asn1);
            const pem = forge.pki.certificateToPem(certificate);
            const cert = new X509();
            cert.readCertPEM(pem);
            const pemStripped = CertificateManagementUtils.stripPem(pem);
            resolve({
              forgeObject: cert,
              pem: pem,
              pemStripped: pemStripped
            });
          } catch (_b) {
            try {
              const cert = new X509();
              cert.readCertPEM(byteString.data);
              const certificate = new KJUR.asn1.x509.Certificate(cert.getParam());
              const pem = certificate.getPEM();
              const pemStripped = CertificateManagementUtils.stripPem(pem);
              resolve({
                forgeObject: cert,
                pem: pem,
                pemStripped: pemStripped
              });
            } catch (_c) {
              try {
                const certificate = forge.pki.certificateFromPem(byteString.data);
                const pem = forge.pki.certificateToPem(certificate);
                const cert = new X509();
                cert.readCertPEM(pem);
                const pemStripped = CertificateManagementUtils.stripPem(pem);
                resolve({
                  forgeObject: cert,
                  pem: pem,
                  pemStripped: pemStripped
                });
              } catch (_d) {
                reject({
                  errorMessage: "Certificate file has errors.",
                  valid: false
                });
              }
            }
          }
        }
      }).catch(error => {
        reject(error);
      });
    });
  }

}
CertFileStrategy.DEFAULT_MIMES = [".pem", ".cer", ".crt", ".cert"];

/**
 * Resource Grid Card component.
 *
 * @param props - Props injected to the component.
 * @returns the Resource grid card component.
 */

const ResourceGridCard = props => {
  const {
    className,
    children,
    comingSoonRibbonLabel,
    disabled,
    editButtonLabel,
    onDelete,
    onEdit,
    isResourceComingSoon,
    resourceCategory,
    resourceDescription,
    resourceImage,
    resourceName,
    showActions,
    showResourceEdit,
    showResourceDelete,
    showTooltips,
    testId,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["className", "children", "comingSoonRibbonLabel", "disabled", "editButtonLabel", "onDelete", "onEdit", "isResourceComingSoon", "resourceCategory", "resourceDescription", "resourceImage", "resourceName", "showActions", "showResourceEdit", "showResourceDelete", "showTooltips", "testId", "data-componentid"]);

  const classes = classNames("resource-grid-card", className);
  return /*#__PURE__*/React__default.createElement(InfoCard, Object.assign({
    className: classes,
    ribbon: isResourceComingSoon && comingSoonRibbonLabel,
    header: resourceName,
    subHeader: resourceCategory,
    description: resourceDescription,
    image: resourceImage,
    disabled: isResourceComingSoon || disabled,
    showTooltips: !(isResourceComingSoon || disabled) && showTooltips,
    action: showActions && /*#__PURE__*/React__default.createElement("div", {
      className: "actions"
    }, showResourceEdit && onEdit && /*#__PURE__*/React__default.createElement(LinkButton, {
      disabled: isResourceComingSoon || disabled,
      hoverType: "underline",
      className: "info-card-inner-action",
      onClick: onEdit,
      "data-componentid": `${componentId}-item-edit-button`,
      "data-testid": `${testId}-item-edit-button`
    }, editButtonLabel, /*#__PURE__*/React__default.createElement(Icon, {
      name: "caret right"
    })), showResourceDelete && onDelete && !(isResourceComingSoon || disabled) && /*#__PURE__*/React__default.createElement(GenericIcon, {
      square: true,
      hoverable: true,
      transparent: true,
      floated: "right",
      className: "delete-button",
      icon: /*#__PURE__*/React__default.createElement(Icon, {
        name: "trash alternate"
      }),
      "data-componentid": `${componentId}-item-delete-button`,
      "data-testid": `${testId}-item-delete-button`,
      onClick: onDelete
    })),
    "data-componentid": componentId
  }, rest), children);
};
/**
 * Default props for the component.
 */

ResourceGridCard.defaultProps = {
  comingSoonRibbonLabel: "Coming Soon",
  "data-componentid": "resource-grid-card",
  "data-testid": "resource-grid-card",
  editButtonLabel: "Configure",
  imageOptions: {
    floated: false,
    inline: true
  },
  imageSize: "micro",
  showTooltips: true
};

/**
 * Resource Grid component.
 * Displays resources as cards on a grid.
 *
 * @param props - Props injected to the component.
 * @returns the resource grid component.
 */

const ResourceGrid = props => {
  const {
    children,
    className,
    emptyPlaceholder,
    isEmpty,
    isLoading,
    isPaginating,
    testId,
    wrapperClassName,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["children", "className", "emptyPlaceholder", "isEmpty", "isLoading", "isPaginating", "testId", "wrapperClassName", "data-componentid"]);

  const classes = classNames("resource-grid", className);
  const wrapperClasses = classNames("resource-grid-wrapper", wrapperClassName);
  const numberOfPlaceholderCards = 4;
  /**
   * Renders the loading state placeholder cards.
   *
   * @returns Loading Placeholder cards.
   */

  const getPlaceholderCards = () => {
    const placeholders = [];

    for (let i = 0; i < numberOfPlaceholderCards; i++) {
      placeholders.push(
      /*#__PURE__*/
      //TODO: Add placeholder style classes.
      React__default.createElement(Card, {
        style: {
          boxShadow: "none",
          width: "220px"
        }
      }, /*#__PURE__*/React__default.createElement(Placeholder, null, /*#__PURE__*/React__default.createElement(Placeholder.Image, {
        style: {
          height: "230px"
        }
      }))));
    }

    return placeholders;
  };

  if (isLoading) {
    return /*#__PURE__*/React__default.createElement(Card.Group, {
      style: {
        marginBottom: "3rem"
      }
    }, getPlaceholderCards());
  }

  return /*#__PURE__*/React__default.createElement("div", {
    className: wrapperClasses,
    "data-componentid": componentId,
    "data-testid": testId
  }, isEmpty ? emptyPlaceholder : /*#__PURE__*/React__default.createElement(Card.Group, Object.assign({
    className: classes
  }, rest), isLoading && !isPaginating ? /*#__PURE__*/React__default.createElement(Loader, {
    active: true,
    inline: "centered"
  }) : isPaginating ? /*#__PURE__*/React__default.createElement(Loader, null, "Loading...") : children));
};
/**
 * Default props for the component.
 */

ResourceGrid.defaultProps = {
  "data-componentid": "resource-grid",
  "data-testid": "resource-grid"
};
ResourceGrid.Card = ResourceGridCard;

/**
 * Initial display limit.
 * TODO: Generate limit dynamically with screen dimensions.
 */

const DEFAULT_PAGINATION_LIMIT = 5;
/**
 * Template grid component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the template grid component.
 */

const TemplateGrid = props => {
  const {
    className,
    emptyPlaceholder,
    heading,
    onTemplateSelect,
    overlayOpacity,
    paginate,
    paginationLimit,
    paginationOptions,
    renderDisabledItemsAsGrayscale,
    showTags,
    showTagIcon,
    subHeading,
    tagsKey,
    tagsSectionTitle,
    templates,
    selectedTemplate,
    templateIcons,
    tagsAs,
    tagSize,
    useSelectionCard,
    onSecondaryTemplateSelect,
    secondaryTemplates,
    templateIconOptions,
    templateIconSize,
    useNameInitialAsImage,
    comingSoonRibbonLabel,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("template-grid", className);
  const [templateList, setTemplateList] = useState([]);
  const [secondaryTemplateList, setSecondaryTemplateList] = useState([]);
  const [isShowMoreClicked, setIsShowMoreClicked] = useState(false);
  useEffect(() => {
    if (paginate && !isShowMoreClicked) {
      setTemplateList(take(templates, paginationLimit));
      return;
    }

    setTemplateList(templates);
  }, [templates]);
  useEffect(() => {
    if (secondaryTemplates) {
      if (paginate && !isShowMoreClicked) {
        let balanceLimit = paginationLimit - templates.length;
        balanceLimit = balanceLimit < 0 ? 0 : balanceLimit;
        setSecondaryTemplateList(take(secondaryTemplates, balanceLimit));
        return;
      }

      setSecondaryTemplateList(secondaryTemplates);
    }
  }, [secondaryTemplates, templates]);
  /**
   * Checks if the template image URL is a valid image URL and if not checks if it's
   * available in the passed in icon set.
   *
   * @param image - Input image.
   *
   * @returns the predefined image if available. If not, return input parameter.
   */

  const resolveTemplateImage = image => {
    var _a;

    if (image) {
      if (typeof image !== "string") {
        return image;
      }

      if ((URLUtils.isHttpsUrl(image) || URLUtils.isHttpUrl(image)) && ImageUtils.isValidImageExtension(image)) {
        return image;
      }

      if (URLUtils.isDataUrl(image)) {
        return image;
      }

      if (!templateIcons) {
        return image;
      }
    }

    const match = Object.keys(templateIcons).find(key => key.toString() === image);
    return match ? templateIcons[match] : (_a = templateIcons["default"]) !== null && _a !== void 0 ? _a : image;
  };
  /**
   * Handles the view more button action.
   */


  const viewMoreTemplates = () => {
    setIsShowMoreClicked(true);
    setTemplateList(templates);

    if (secondaryTemplates) {
      setSecondaryTemplateList(secondaryTemplates);
    }
  };
  /**
   * Handles the view less button action.
   */


  const viewLessTemplates = () => {
    setIsShowMoreClicked(false);
    setTemplateList(take(templates, paginationLimit));

    if (secondaryTemplates) {
      let balanceLimit = paginationLimit - templates.length;
      balanceLimit = balanceLimit < 0 ? 0 : balanceLimit;
      setSecondaryTemplateList(take(secondaryTemplates, balanceLimit));
    }
  };

  const resolveCardListing = (templateList, onClick, useNameImage) => {
    if (templateList.length > 0) {
      return templateList.map((template, index) => /*#__PURE__*/React__default.createElement(SelectionCard, {
        key: index,
        inline: true,
        id: template.id,
        header: template.name,
        image: useNameImage ? /*#__PURE__*/React__default.createElement(UserAvatar, {
          name: template.name,
          size: "tiny"
        }) : resolveTemplateImage(template.image),
        imageOptions: templateIconOptions,
        onClick: onClick,
        selected: (selectedTemplate === null || selectedTemplate === void 0 ? void 0 : selectedTemplate.id) === template.id,
        "data-componentid": `${componentId}-selection-card`,
        "data-testid": `${testId}-selection-card`
      }));
    }

    return null;
  };
  /**
   * Calculate pagination limit exceeded or not
   */


  const paginationLimitExceed = () => {
    let exceeded = false;
    let length = 0;

    if (secondaryTemplates && secondaryTemplates instanceof Array) {
      length += secondaryTemplates.length;
    }

    if (templates && templates instanceof Array) {
      length += templates.length;
    }

    if (length > paginationLimit) {
      exceeded = true;
    }

    return exceeded;
  };

  return /*#__PURE__*/React__default.createElement(Grid, {
    className: classes,
    "data-testid": testId,
    "data-componentid": componentId
  }, heading || subHeading ? /*#__PURE__*/React__default.createElement(Grid.Row, {
    columns: 2
  }, /*#__PURE__*/React__default.createElement(Grid.Column, null, heading && /*#__PURE__*/React__default.createElement(Heading, {
    as: "h4",
    compact: true,
    "data-componentid": `${componentId}-heading`,
    "data-testid": `${testId}-heading`
  }, heading), subHeading && /*#__PURE__*/React__default.createElement(Heading, {
    subHeading: true,
    ellipsis: true,
    as: "h6",
    "data-componentid": `${componentId}-sub-heading`,
    "data-testid": `${testId}-sub-heading`
  }, subHeading)), paginate && /*#__PURE__*/React__default.createElement(Grid.Column, {
    textAlign: "right"
  }, paginationLimitExceed() ? isShowMoreClicked ? /*#__PURE__*/React__default.createElement(LinkButton, {
    onClick: viewLessTemplates,
    "data-componentid": `${componentId}-show-less-button`,
    "data-testid": `${testId}-show-less-button`
  }, paginationOptions.showLessButtonLabel) : /*#__PURE__*/React__default.createElement(LinkButton, {
    onClick: viewMoreTemplates,
    "data-componentid": `${componentId}-show-more-button`,
    "data-testid": `${testId}-show-more-button`
  }, paginationOptions.showMoreButtonLabel) : null)) : null, /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, null, useSelectionCard ? templateList && templateList instanceof Array && templateList.length > 0 || secondaryTemplateList && secondaryTemplateList instanceof Array && secondaryTemplateList.length > 0 ? /*#__PURE__*/React__default.createElement(React__default.Fragment, null, resolveCardListing(templateList, onTemplateSelect, false), resolveCardListing(secondaryTemplateList, onSecondaryTemplateSelect, useNameInitialAsImage)) : emptyPlaceholder && emptyPlaceholder : templateList && templateList instanceof Array && templateList.length > 0 ? /*#__PURE__*/React__default.createElement(Card.Group, null, templateList.map((template, index) => /*#__PURE__*/React__default.createElement(TemplateCard, {
    key: index,
    description: template.description,
    image: resolveTemplateImage(template.image),
    imageOptions: templateIconOptions,
    tagsSectionTitle: tagsSectionTitle,
    tags: get$2(template, tagsKey),
    tagsAs: tagsAs,
    showTags: showTags,
    showTagIcon: showTagIcon,
    name: template.name,
    id: template.id,
    onClick: template.disabled || template.comingSoon ? null : onTemplateSelect,
    overlayOpacity: overlayOpacity,
    imageSize: templateIconSize,
    renderDisabledItemsAsGrayscale: renderDisabledItemsAsGrayscale,
    tagSize: tagSize,
    "data-componentid": template.id,
    "data-testid": template.id,
    disabled: template.disabled || template.comingSoon,
    ribbon: template.comingSoon ? comingSoonRibbonLabel : null
  }))) : emptyPlaceholder && emptyPlaceholder)));
};
/**
 * Default props for template grid component.
 */

TemplateGrid.defaultProps = {
  "data-componentid": "template-grid",
  "data-testid": "template-grid",
  iconSize: "tiny",
  paginate: true,
  paginationLimit: DEFAULT_PAGINATION_LIMIT,
  paginationOptions: {
    showLessButtonLabel: "Show less",
    showMoreButtonLabel: "Show more"
  },
  useSelectionCard: false
};

var _path$3;

function _extends$3() { _extends$3 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$3.apply(this, arguments); }

var SvgCrossIcon = function SvgCrossIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$3({
    className: "cross-icon_svg__icon",
    xmlns: "http://www.w3.org/2000/svg",
    width: 14,
    height: 14,
    viewBox: "0 0 357 357",
    xmlSpace: "preserve"
  }, props), _path$3 || (_path$3 = /*#__PURE__*/React.createElement("path", {
    className: "cross-icon_svg__path cross-icon_svg__fill cross-icon_svg__primary",
    d: "M357 35.7 321.3 0 178.5 142.8 35.7 0 0 35.7l142.8 142.8L0 321.3 35.7 357l142.8-142.8L321.3 357l35.7-35.7-142.8-142.8z"
  })));
};

var _path$2, _path2$1;

function _extends$2() { _extends$2 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$2.apply(this, arguments); }

var SvgSpeakerOutline = function SvgSpeakerOutline(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$2({
    className: "speaker-outline_svg__icon",
    width: 14,
    height: 14,
    viewBox: "0 0 18 18",
    xmlns: "http://www.w3.org/2000/svg"
  }, props), _path$2 || (_path$2 = /*#__PURE__*/React.createElement("path", {
    d: "m9.397 1.56-.143.04-3.713 3.642-3.146.863C.675 6.577-.351 8.395.11 10.156c.413 1.576 1.876 2.578 3.411 2.436L3.463 16.5l3.48-.955.058-3.854.213-.059 4.994 1.253.143-.04c.921-.252 1.47-1.226 1.223-2.17l-2.057-7.861c-.247-.944-1.198-1.506-2.12-1.253ZM5.803 14.636l-1.163.319.035-2.37 1.164-.32-.036 2.37Zm3.077-3.801-1.68-.421-3.432.941c-1.106.304-2.247-.371-2.543-1.504-.296-1.132.362-2.3 1.468-2.604l3.433-.942L7.374 5.08l1.506 5.754Zm3.58.147a.597.597 0 0 1-.292.677l-2.01-.504-1.833-7.006 1.494-1.466a.58.58 0 0 1 .584.438l2.057 7.86ZM14.04 3.695l-.584 1.035a3.662 3.662 0 0 1 1.2 1.892 3.735 3.735 0 0 1-.115 2.253l1.01.597a4.942 4.942 0 0 0 .22-3.156 4.84 4.84 0 0 0-1.731-2.621Z",
    fillOpacity: 0.74
  })), _path2$1 || (_path2$1 = /*#__PURE__*/React.createElement("path", {
    d: "M15.078 1.853 14.5 2.88a5.77 5.77 0 0 1 2.153 3.195 5.895 5.895 0 0 1-.305 3.869l1.002.593c.661-1.44.85-3.115.417-4.768a6.943 6.943 0 0 0-2.689-3.915Z",
    fillOpacity: 0.74
  })));
};

/**
 * Announcement component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the Announcement component
 */

const Announcement = props => {
  var _a, _b;

  const {
    children,
    isFeatureAnnouncement,
    color,
    className,
    message,
    onDismiss,
    showCloseIcon,
    visible,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["children", "isFeatureAnnouncement", "color", "className", "message", "onDismiss", "showCloseIcon", "visible", "data-componentid", "data-testid"]);

  const classes = classNames("announcement", {
    [color]: (_a = !isFeatureAnnouncement) !== null && _a !== void 0 ? _a : color
  }, className);
  return visible ? /*#__PURE__*/React__default.createElement(Message$1, Object.assign({
    className: !isFeatureAnnouncement ? classes : `${classes} feature-announcement`,
    "data-testid": testId,
    "data-componentid": componentId
  }, rest), /*#__PURE__*/React__default.createElement(React__default.Fragment, null, isFeatureAnnouncement && /*#__PURE__*/React__default.createElement(GenericIcon, {
    icon: SvgSpeakerOutline,
    size: "x22",
    onClick: e => onDismiss(e),
    inline: true,
    transparent: true,
    verticalAlign: "middle",
    className: "mr-3 mt-1"
  }), message, children, showCloseIcon && /*#__PURE__*/React__default.createElement(GenericIcon, {
    icon: SvgCrossIcon,
    size: "nano",
    floated: "right",
    onClick: e => onDismiss(e),
    fill: (_b = !isFeatureAnnouncement) !== null && _b !== void 0 ? _b : "white",
    inline: true,
    link: true,
    transparent: true
  }))) : null;
};
/**
 * Default prop types for the component.
 */

Announcement.defaultProps = {
  color: "primary",
  "data-componentid": "announcement",
  "data-testid": "announcement",
  fluid: false,
  showCloseIcon: true,
  visible: true
};

var aCallable$1 = aCallable$a;
var toObject$3 = toObject$a;
var IndexedObject = indexedObject;
var lengthOfArrayLike$2 = lengthOfArrayLike$a;

var $TypeError$1 = TypeError;

// `Array.prototype.{ reduce, reduceRight }` methods implementation
var createMethod = function (IS_RIGHT) {
  return function (that, callbackfn, argumentsLength, memo) {
    aCallable$1(callbackfn);
    var O = toObject$3(that);
    var self = IndexedObject(O);
    var length = lengthOfArrayLike$2(O);
    var index = IS_RIGHT ? length - 1 : 0;
    var i = IS_RIGHT ? -1 : 1;
    if (argumentsLength < 2) while (true) {
      if (index in self) {
        memo = self[index];
        index += i;
        break;
      }
      index += i;
      if (IS_RIGHT ? index < 0 : length <= index) {
        throw $TypeError$1('Reduce of empty array with no initial value');
      }
    }
    for (;IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
      memo = callbackfn(memo, self[index], index, O);
    }
    return memo;
  };
};

var arrayReduce = {
  // `Array.prototype.reduce` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduce
  left: createMethod(false),
  // `Array.prototype.reduceRight` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
  right: createMethod(true)
};

var fails$5 = fails$z;

var arrayMethodIsStrict$2 = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !!method && fails$5(function () {
    // eslint-disable-next-line no-useless-call -- required for testing
    method.call(null, argument || function () { return 1; }, 1);
  });
};

var $$4 = _export;
var $reduce = arrayReduce.left;
var arrayMethodIsStrict$1 = arrayMethodIsStrict$2;
var CHROME_VERSION = engineV8Version;
var IS_NODE = engineIsNode;

var STRICT_METHOD$1 = arrayMethodIsStrict$1('reduce');
// Chrome 80-82 has a critical bug
// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83;

// `Array.prototype.reduce` method
// https://tc39.es/ecma262/#sec-array.prototype.reduce
$$4({ target: 'Array', proto: true, forced: !STRICT_METHOD$1 || CHROME_BUG }, {
  reduce: function reduce(callbackfn /* , initialValue */) {
    var length = arguments.length;
    return $reduce(this, callbackfn, length, length > 1 ? arguments[1] : undefined);
  }
});

/**
 * Header component.
 *
 * @param props - Props injected to the component.
 * @returns Header Component.
 */

const Header = props => {
  const {
    announcement,
    brand,
    brandLink,
    basicProfileInfo,
    children,
    className,
    extensions,
    featureAnnouncement,
    fixed,
    fluid,
    isProfileInfoLoading,
    isPrivilegedUser,
    linkedAccounts,
    profileInfo,
    userDropdownInfoAction,
    showSidePanelToggle,
    showUserDropdown,
    showUserDropdownTriggerBars,
    showUserDropdownTriggerLabel,
    showOrganizationLabel,
    organizationLabel,
    onLinkedAccountSwitch,
    onSidePanelToggleClick,
    userDropdownIcon,
    userDropdownLinks,
    userDropdownPointing,
    onAvatarClick,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("app-header", {
    ["fluid-header"]: fluid,
    ["has-announcement"]: announcement !== undefined,
    ["has-feature-announcement"]: featureAnnouncement == true,
    "show-hamburger": showSidePanelToggle
  }, className);
  /**
   * Renders the User dropdown trigger.
   * @returns User Dropdown rigger component.
   */

  const renderUserDropdownTrigger = () => {
    const renderUserDropdownTriggerAvatar = hoverable => /*#__PURE__*/React__default.createElement(UserAvatar, {
      hoverable: hoverable,
      isLoading: isProfileInfoLoading,
      authState: basicProfileInfo,
      profileInfo: profileInfo,
      size: "mini",
      "data-componentid": `${componentId}-user-avatar`,
      "data-testid": `${testId}-user-avatar`,
      "data-suppress": ""
    });

    return /*#__PURE__*/React__default.createElement("span", {
      className: "user-dropdown-trigger",
      "data-componentid": `${componentId}-user-dropdown-trigger`,
      "data-testid": `${testId}-user-dropdown-trigger`
    }, showUserDropdownTriggerLabel && /*#__PURE__*/React__default.createElement(Media, {
      greaterThan: "mobile",
      className: "username",
      "data-componentid": `${componentId}-user-display-name`,
      "data-testid": `${testId}-user-display-name`
    }, isProfileInfoLoading ? /*#__PURE__*/React__default.createElement(Placeholder, {
      "data-componentid": `${componentId}-username-loading-placeholder`,
      "data-testid": `${testId}-username-loading-placeholder`
    }, /*#__PURE__*/React__default.createElement(Placeholder.Line, null)) : resolveUserDisplayName(profileInfo, basicProfileInfo)), !showUserDropdownTriggerLabel && showUserDropdownTriggerBars ? /*#__PURE__*/React__default.createElement("div", {
      className: "user-dropdown-trigger-with-bars-wrapper"
    }, /*#__PURE__*/React__default.createElement(Icon, {
      name: "bars",
      size: "large",
      "data-componentid": `${componentId}-hamburger-icon`,
      "data-testid": `${testId}-hamburger-icon`,
      link: true
    }), renderUserDropdownTriggerAvatar(false)) : renderUserDropdownTriggerAvatar(true));
  };
  /**
   * Stops the dropdown from closing on click.
   *
   * @param e - Click event.
   */


  const handleUserDropdownClick = e => {
    e.stopPropagation();
  };
  /**
   * Handles the account switch click event.
   *
   * @param account - Target account.
   */


  const handleLinkedAccountSwitch = account => {
    onLinkedAccountSwitch(account);
  };

  const resolveAuthenticatedUserEmail = () => {
    var _a, _b;

    if (!profileInfo || !profileInfo.userName) {
      return null;
    }

    if (typeof profileInfo.userName === "string") {
      return ((_a = profileInfo === null || profileInfo === void 0 ? void 0 : profileInfo.userName) === null || _a === void 0 ? void 0 : _a.split("/").length) > 1 ? profileInfo.userName.split("/")[1] : profileInfo.userName;
    } else if (typeof profileInfo.userName === "object") {
      return ((_b = profileInfo === null || profileInfo === void 0 ? void 0 : profileInfo.userName) === null || _b === void 0 ? void 0 : _b.value.split("/").length) > 1 ? profileInfo.userName.value.split("/")[1] : profileInfo.userName.value;
    }

    return null;
  };
  /**
   * Renders the list of linked accounts.
   *
   * @param accounts - Linked accounts.
   * @returns Link Accounts list.
   */


  const renderLinkedAccounts = accounts => {
    if (!(accounts && Array.isArray(accounts) && accounts.length > 0)) {
      return null;
    }

    return /*#__PURE__*/React__default.createElement(Item.Group, {
      unstackable: true,
      className: "linked-accounts-list",
      "data-componentid": `${componentId}-linked-accounts-container`,
      "data-testid": `${testId}-linked-accounts-container`
    }, accounts.map((association, index) => /*#__PURE__*/React__default.createElement(Item, {
      className: "linked-account",
      key: `${association.userId}-${index}`,
      onClick: () => handleLinkedAccountSwitch(association)
    }, /*#__PURE__*/React__default.createElement(UserAvatar, {
      bordered: true,
      avatar: true,
      size: "little",
      image: getGravatarImage(association.email),
      name: association.username,
      "data-componentid": `${componentId}-la-avatar`,
      "data-testid": `${testId}-la-avatar`,
      spaced: "right",
      "data-suppress": ""
    }), /*#__PURE__*/React__default.createElement(Item.Content, {
      verticalAlign: "middle"
    }, /*#__PURE__*/React__default.createElement(Item.Description, null, /*#__PURE__*/React__default.createElement("div", {
      className: "name",
      "data-componentid": `${componentId}-la-name`,
      "data-testid": `${testId}-la-name`
    }, resolveUsername(association.username, association.userStoreDomain)), /*#__PURE__*/React__default.createElement("div", {
      className: "email",
      "data-componentid": `${componentId}-la-email`,
      "data-testid": `${testId}-la-email`
    }, association.tenantDomain))))));
  };
  /**
   * Renders the links in the dropdown.
   *
   * @returns User Dropdown links.
   */


  const renderUserDropdownLinks = () => {
    if (!(userDropdownLinks && userDropdownLinks.length && userDropdownLinks.length > 0)) {
      return null;
    }

    const adjustedUserDropdownLinks = userDropdownLinks.reduce((previous, current) => {
      const {
        category,
        categoryLabel,
        links
      } = current;

      if (isPrivilegedUser && category === "APPS") {
        // Remove my account app from privileged users.
        return previous;
      }

      const findObj = [...previous].find(obj => obj.category === category);

      if (!findObj) {
        previous.push({
          category,
          categoryLabel,
          links
        });
      } else {
        findObj.links.push(...links);
      }

      return previous;
    }, []);
    return adjustedUserDropdownLinks.map((category, categoryIndex) => {
      if (!(category.links && Array.isArray(category.links) && category.links.length > 0)) {
        return null;
      }

      return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, (category === null || category === void 0 ? void 0 : category.categoryLabel) && /*#__PURE__*/React__default.createElement(Dropdown.Header, {
        className: "user-dropdown-links-category-header",
        content: category.categoryLabel
      }), category.links.map((link, linkIndex) => {
        if (!link) {
          return;
        }

        const {
          content,
          "data-componentid": linkComponentId,
          "data-testid": linkTestId,
          icon,
          name,
          onClick
        } = link;
        return /*#__PURE__*/React__default.createElement(Dropdown.Item, {
          key: linkIndex,
          className: "action-panel user-dropdown-link",
          onClick: onClick,
          "data-componentid": linkComponentId,
          "data-testid": linkTestId
        }, icon && /*#__PURE__*/React__default.createElement(GenericIcon, {
          transparent: true,
          icon: icon,
          size: "micro",
          spaced: "right"
        }), name, content);
      }), categoryIndex !== userDropdownLinks.length - 1 && /*#__PURE__*/React__default.createElement(Dropdown.Divider, null));
    });
  };
  /**
   * Renders the header extensions.
   *
   * @param floated - Floated direction.
   * @returns Header Extension links.
   */


  const renderHeaderExtensionLinks = floated => {
    return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, extensions.map((extension, index) => {
      if (extension.floated !== floated || !extension.component) {
        return;
      }

      if (typeof extension.component === "string") {
        return /*#__PURE__*/React__default.createElement("div", {
          key: index,
          "data-componentid": extension["data-componentid"],
          "data-testid": extension["data-testid"],
          className: "header-link"
        }, extension.component);
      }

      return extension.component;
    }));
  };

  return /*#__PURE__*/React__default.createElement(Menu, {
    id: "app-header",
    className: classes,
    fixed: fixed,
    borderless: true,
    "data-componentid": componentId,
    "data-testid": testId
  }, announcement, /*#__PURE__*/React__default.createElement(Container, {
    fluid: fluid,
    "data-componentid": `${componentId}-container`,
    "data-testid": `${testId}-container`,
    className: "app-header-container"
  }, showSidePanelToggle ? /*#__PURE__*/React__default.createElement(Media, {
    lessThan: "tablet"
  }, (className, renderChildren) => /*#__PURE__*/React__default.createElement("span", {
    className: className
  }, renderChildren && /*#__PURE__*/React__default.createElement(Menu.Item, {
    className: "bars-container"
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "bars",
    size: "large",
    onClick: onSidePanelToggleClick,
    "data-componentid": `${componentId}-hamburger-icon`,
    "data-testid": `${testId}-hamburger-icon`,
    link: true
  })))) : null, brand && /*#__PURE__*/React__default.createElement(Media, {
    greaterThan: "mobile"
  }, (className, renderChildren) => /*#__PURE__*/React__default.createElement("span", {
    className: className
  }, renderChildren && /*#__PURE__*/React__default.createElement(Menu.Item, {
    className: "brand-container"
  }, /*#__PURE__*/React__default.createElement(Menu.Item, {
    as: Link$1,
    to: brandLink,
    header: true,
    "data-componentid": `${componentId}-brand-container`,
    "data-testid": `${testId}-brand-container`
  }, brand)))), extensions && extensions instanceof Array && extensions.length > 0 && extensions.some(extension => extension.floated === "left") && /*#__PURE__*/React__default.createElement(Menu.Menu, {
    position: "left",
    className: "header-extensions left",
    "data-componentid": `${componentId}-left-extensions`,
    "data-testid": `${testId}-left-extensions`
  }, renderHeaderExtensionLinks("left")), /*#__PURE__*/React__default.createElement(Menu.Menu, {
    position: "right",
    className: "header-extensions right",
    "data-componentid": `${componentId}-user-dropdown-container`,
    "data-testid": `${testId}-user-dropdown-container`
  }, renderHeaderExtensionLinks("right"), showUserDropdown && /*#__PURE__*/React__default.createElement(Menu.Item, {
    className: "user-dropdown-menu-trigger",
    key: "user-dropdown-trigger"
  }, /*#__PURE__*/React__default.createElement(Dropdown, {
    item: true,
    trigger: renderUserDropdownTrigger(),
    floating: true,
    pointing: userDropdownPointing,
    icon: userDropdownIcon,
    className: "user-dropdown",
    "data-componentid": `${componentId}-user-dropdown`,
    "data-testid": `${testId}-user-dropdown`
  }, /*#__PURE__*/React__default.createElement(Dropdown.Menu, {
    className: "user-dropdown-menu",
    onClick: handleUserDropdownClick
  }, showOrganizationLabel && organizationLabel, /*#__PURE__*/React__default.createElement(Item.Group, {
    className: "authenticated-user",
    unstackable: true
  }, /*#__PURE__*/React__default.createElement(Item, {
    className: "header",
    key: `logged-in-user-${profileInfo.userName}`,
    onClick: onAvatarClick
  }, /*#__PURE__*/React__default.createElement(UserAvatar, {
    hoverable: false,
    authState: basicProfileInfo,
    profileInfo: profileInfo,
    isLoading: isProfileInfoLoading,
    "data-componentid": `${componentId}-user-dropdown-avatar`,
    "data-testid": `${testId}-user-dropdown-avatar`,
    size: "x50",
    onClick: onAvatarClick,
    "data-suppress": ""
  }), /*#__PURE__*/React__default.createElement(Item.Content, {
    verticalAlign: "middle"
  }, /*#__PURE__*/React__default.createElement(Item.Description, {
    className: onAvatarClick ? "linked" : ""
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "name",
    "data-componentid": `${componentId}-user-dropdown-display-name`,
    "data-testid": `${testId}-user-dropdown-display-name`,
    "data-suppress": ""
  }, isProfileInfoLoading ? /*#__PURE__*/React__default.createElement(Placeholder, null, /*#__PURE__*/React__default.createElement(Placeholder.Line, null)) : resolveUserDisplayName(profileInfo, basicProfileInfo)), profileInfo.emails !== undefined && profileInfo.emails !== null && resolveAuthenticatedUserEmail() !== resolveUserDisplayName(profileInfo, basicProfileInfo) && /*#__PURE__*/React__default.createElement("div", {
    className: "email",
    "data-componentid": `${componentId}-user-dropdown-email`,
    "data-testid": `${testId}-user-dropdown-email`
  }, isProfileInfoLoading ? /*#__PURE__*/React__default.createElement(Placeholder, null, /*#__PURE__*/React__default.createElement(Placeholder.Line, null)) : resolveAuthenticatedUserEmail()), userDropdownInfoAction && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), userDropdownInfoAction))))), renderLinkedAccounts(linkedAccounts), renderUserDropdownLinks()))))), children);
};
/**
 * Default prop types for the header component.
 */

Header.defaultProps = {
  "data-componentid": "app-header",
  "data-testid": "app-header",
  fixed: "top",
  fluid: false,
  isPrivilegedUser: false,
  onLinkedAccountSwitch: () => null,
  onSidePanelToggleClick: () => null,
  showSidePanelToggle: true,
  showUserDropdown: true,
  showUserDropdownTriggerBars: true,
  showUserDropdownTriggerLabel: true,
  userDropdownIcon: null,
  userDropdownPointing: "top right"
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Help side panel action bar.
 *
 * @param props - props injected to component
 *
 * @returns the help panel action bar
 */

const HelpPanelActionBar = props => {
  const {
    children,
    clearing,
    className,
    floated,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("help-panel-action-bar", {
    clearing,
    [`floated-${floated}`]: floated
  }, className);
  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "actions-group",
    "data-componentid": `${componentId}-action-group`,
    "data-testid": `${testId}-action-group`
  }, React__default.Children.map(children, (action, index) => /*#__PURE__*/React__default.createElement("div", {
    key: index,
    className: "action",
    "data-componentid": `${componentId}-action-${index}`,
    "data-testid": `${testId}-action-${index}`
  }, action))));
};
/**
 * Default props for the help panel action bar.
 */

HelpPanelActionBar.defaultProps = {
  clearing: true,
  "data-componentid": "help-panel-action-bar",
  "data-testid": "help-panel-action-bar",
  floated: "right"
};

var _path$1, _path2;

function _extends$1() { _extends$1 = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends$1.apply(this, arguments); }

var SvgCaretLeftIcon = function SvgCaretLeftIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends$1({
    className: "caret-left-icon_svg__icon",
    height: 14,
    width: 14,
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 -1 8 14",
    xmlSpace: "preserve"
  }, props), _path$1 || (_path$1 = /*#__PURE__*/React.createElement("path", {
    className: "caret-left-icon_svg__path",
    d: "m5.89 11.583.671-.671-4.883-4.884 4.883-4.884L5.89.473.336 6.028Z"
  })), _path2 || (_path2 = /*#__PURE__*/React.createElement("path", {
    className: "caret-left-icon_svg__path",
    d: "M5.89 11.919a.721.721 0 0 0 1.006-1.006c-.544-.753-4.883-4.884-4.883-4.884s4.456-4.392 4.884-4.884S6.485-.371 5.89.139 0 6.029 0 6.029s5.349 5.44 5.89 5.89Zm.335-1.006-.335.335L.671 6.029 5.89.81l.335.335-4.883 4.884Z"
  })));
};

/**
 * Resource tab pane component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the React component for the resource tab pane
 */

const ResourceTabPane = props => {
  const {
    children,
    className,
    controlledSegmentation,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["children", "className", "controlledSegmentation", "data-componentid", "data-testid"]);

  const classes = classNames("resource-tab-pane", {
    "controlled-segments": controlledSegmentation
  }, className);
  return /*#__PURE__*/React__default.createElement(Tab.Pane, Object.assign({
    className: classes,
    attached: false,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), children);
};
/**
 * Default props for the resource tab pane component.
 */

ResourceTabPane.defaultProps = {
  attached: false,
  controlledSegmentation: false,
  "data-componentid": "resource-tab-pane",
  "data-testid": "resource-tab-pane"
};

/**
 * Resource tab component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Resource tab component
 */

const ResourceTab = props => {
  var _a;

  const {
    isLoading,
    attached,
    className,
    onInitialize,
    panes,
    defaultActiveIndex,
    loadingStateOptions,
    pointing,
    secondary,
    onTabChange,
    isAutomaticTabRedirectionEnabled,
    tabIdentifier,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["isLoading", "attached", "className", "onInitialize", "panes", "defaultActiveIndex", "loadingStateOptions", "pointing", "secondary", "onTabChange", "isAutomaticTabRedirectionEnabled", "tabIdentifier", "data-componentid", "data-testid"]);

  const classes = classNames("tabs resource-tabs", {
    "attached": attached
  }, className);
  const [activeIndex, setActiveIndex] = useState(defaultActiveIndex);
  const [isTabChanged, setIsTabChanged] = useState(false);
  /**
   * Called to set the pane index as the active tab index if it is needed to redirect to a specific tab
   */

  useEffect(() => {
    if (isTabChanged) {
      return;
    }

    if (!isAutomaticTabRedirectionEnabled) {
      setActiveIndex(defaultActiveIndex);
      return;
    }

    const tabIndex = panes.indexOf(panes.find(element => element["data-tabid"] === tabIdentifier));

    if (inRange(tabIndex, 0, panes.length)) {
      if (tabIndex === activeIndex) {
        return;
      }

      setActiveIndex(tabIndex);
    } else {
      setActiveIndex(defaultActiveIndex);
    }
  }, [defaultActiveIndex]);
  /**
   * Called to set the panes list length initially.
   */

  useEffect(() => {
    if (onInitialize && typeof onInitialize === "function") {
      onInitialize({
        panesLength: panes.length
      });
    }
  }, []);
  /**
   * Handles the tab change.
   */

  const handleTabChange = (e, activeIndex) => {
    setIsTabChanged(true);
    setActiveIndex(activeIndex);
  }; //TODO - Add style classes to placeholders.


  if (isLoading) {
    return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Card.Group, {
      style: {
        marginBottom: "3rem"
      }
    }, [...Array((_a = loadingStateOptions === null || loadingStateOptions === void 0 ? void 0 : loadingStateOptions.count) !== null && _a !== void 0 ? _a : 0)].map(() => {
      return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Card, {
        style: {
          boxShadow: "none",
          width: "10%"
        }
      }, /*#__PURE__*/React__default.createElement(Placeholder, null, /*#__PURE__*/React__default.createElement(Placeholder.Image, {
        style: {
          height: "30px"
        }
      }))));
    })), /*#__PURE__*/React__default.createElement(Placeholder, null, [...Array(3)].map(() => {
      return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Placeholder.Line, {
        length: "very short"
      }), /*#__PURE__*/React__default.createElement(Placeholder.Image, {
        style: {
          height: "38px"
        }
      }), /*#__PURE__*/React__default.createElement(Placeholder.Line, null), /*#__PURE__*/React__default.createElement(Placeholder.Line, null));
    })));
  }

  return /*#__PURE__*/React__default.createElement(Tab, Object.assign({
    onTabChange: (e, data) => {
      handleTabChange(e, data.activeIndex);
      onTabChange && typeof onTabChange === "function" && onTabChange(e, data);
    },
    className: classes,
    menu: {
      attached,
      pointing,
      secondary
    },
    panes: panes,
    activeIndex: activeIndex,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest));
};
/**
 * Default props for the resource tab component.
 */

ResourceTab.defaultProps = {
  attached: false,
  "data-componentid": "resource-tabs",
  "data-testid": "resource-tabs",
  isAutomaticTabRedirectionEnabled: false,
  isLoading: false,
  pointing: true,
  secondary: true,
  tabIdentifierURLFrag: ""
};
ResourceTab.Pane = ResourceTabPane;

/**
 * Help side panel.
 *
 * @param props - Props injected to the component.
 *
 * @returns the help side panel.
 */

const HelpPanel = /*#__PURE__*/forwardRef((props, ref) => {
  const {
    actions,
    bordered,
    children,
    className,
    onSidebarToggle,
    tabs,
    raised,
    showLabelsOnSidebarMini,
    showTooltipsOnSidebarMini,
    sidebarMiniEnabled,
    sidebarToggleTooltip,
    visible,
    tabsActiveIndex,
    onSidebarMiniItemClick,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["actions", "bordered", "children", "className", "onSidebarToggle", "tabs", "raised", "showLabelsOnSidebarMini", "showTooltipsOnSidebarMini", "sidebarMiniEnabled", "sidebarToggleTooltip", "visible", "tabsActiveIndex", "onSidebarMiniItemClick", "data-componentid", "data-testid"]);

  const [activeIndex, setActiveIndex] = useState(tabsActiveIndex);
  const [tabPanes, setTabPanes] = useState([]);
  const classes = classNames("help-panel", {
    [typeof bordered === "boolean" ? "bordered-default" : `bordered-${bordered}`]: bordered,
    mini: sidebarMiniEnabled && !visible,
    raised
  }, className);
  /**
  * Called on tab active index change.
  */

  useEffect(() => {
    if (!tabsActiveIndex || tabsActiveIndex === activeIndex) {
      return;
    }

    setActiveIndex(tabsActiveIndex);
  }, [tabsActiveIndex]);
  /**
  * Called on tabs array change.
  */

  useEffect(() => {
    if (!tabs) {
      return;
    }

    setTabPanes(tabs.map(tab => {
      return {
        icon: tab.icon,
        menuItem: tab.heading,
        render: () => /*#__PURE__*/React__default.createElement(ResourceTab.Pane, {
          attached: false
        }, tab.content)
      };
    }));
  }, [tabs]);
  return /*#__PURE__*/React__default.createElement(Sidebar, Object.assign({
    animation: "overlay",
    className: classes,
    visible: sidebarMiniEnabled || visible,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), /*#__PURE__*/React__default.createElement("div", {
    className: "help-panel-content-container",
    ref: ref
  }, sidebarMiniEnabled && !visible && /*#__PURE__*/React__default.createElement("div", {
    className: "sidebar-mini-menu"
  }, tabPanes && tabPanes instanceof Array && tabPanes.length > 1 && /*#__PURE__*/React__default.createElement(Menu.Item, {
    as: "a",
    onClick: onSidebarToggle,
    "data-componentid": `${componentId}-visibility-toggle`,
    "data-testid": `${testId}-visibility-toggle`
  }, /*#__PURE__*/React__default.createElement(Tooltip, {
    compact: true,
    trigger: /*#__PURE__*/React__default.createElement("div", null, /*#__PURE__*/React__default.createElement(GenericIcon, {
      link: true,
      hoverable: true,
      defaultIcon: true,
      transparent: true,
      icon: SvgCaretLeftIcon,
      size: "default",
      hoverType: "circular",
      "data-componentid": `${componentId}-visibility-toggle-icon`,
      "data-testid": `${testId}-visibility-toggle-icon`
    })),
    content: sidebarToggleTooltip,
    size: "mini"
  })), tabPanes && tabPanes instanceof Array && tabPanes.length > 0 && tabPanes.map((pane, index) => /*#__PURE__*/React__default.createElement(Menu.Item, {
    as: "a",
    key: index,
    onClick: () => onSidebarMiniItemClick(pane.menuItem),
    "data-componentid": `${componentId}-sidebar-mini-item-${index}`,
    "data-testid": `${testId}-sidebar-mini-item-${index}`
  }, /*#__PURE__*/React__default.createElement(Tooltip, {
    compact: true,
    disabled: showLabelsOnSidebarMini || !showTooltipsOnSidebarMini,
    trigger: /*#__PURE__*/React__default.createElement("div", null, /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
      link: true,
      hoverable: true,
      defaultIcon: true,
      transparent: true,
      size: "default",
      hoverType: "circular",
      "data-componentid": `${componentId}-sidebar-mini-item-${index}-icon`,
      "data-testid": `${testId}-sidebar-mini-item-${index}-icon`
    }, pane.icon))),
    content: pane.menuItem,
    size: "mini"
  }), showLabelsOnSidebarMini && pane.menuItem))), visible && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, actions && actions instanceof Array && actions.length > 0 && /*#__PURE__*/React__default.createElement(HelpPanel.ActionBar, {
    "data-componentid": `${componentId}-action-bar`,
    "data-testid": `${testId}-action-bar`
  }, actions.map((action, index) => /*#__PURE__*/React__default.createElement(Tooltip, {
    compact: true,
    key: index,
    // TODO: Enable after fixing the flickering issue.
    disabled: true,
    trigger: /*#__PURE__*/React__default.createElement("div", null, /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
      link: true,
      inline: true,
      hoverable: true,
      transparent: true,
      defaultIcon: true,
      size: "default",
      "data-componentid": `${componentId}-action-bar-action-${index}`,
      "data-testid": `${testId}-action-bar-action-${index}`
    }, action))),
    content: action.tooltip,
    size: "mini"
  }))), /*#__PURE__*/React__default.createElement(ResourceTab, {
    className: "help-panel-tabs",
    panes: tabPanes,
    defaultActiveIndex: tabsActiveIndex,
    "data-componentid": `${componentId}-tabs`,
    "data-testid": `${testId}-tabs`
  }), children)));
});
/**
 * Default props for the help panel component.
 */

HelpPanel.defaultProps = {
  bordered: "left",
  "data-componentid": "help-panel",
  "data-testid": "help-panel",
  direction: "right",
  raised: false,
  showLabelsOnSidebarMini: false,
  showTooltipsOnActionBar: true,
  showTooltipsOnSidebarMini: true,
  sidebarMiniEnabled: true,
  sidebarToggleTooltip: "Open help panel",
  visible: true
};
HelpPanel.ActionBar = HelpPanelActionBar;

var uncurryThis$6 = functionUncurryThis;
var toObject$2 = toObject$a;

var floor$2 = Math.floor;
var charAt$4 = uncurryThis$6(''.charAt);
var replace$4 = uncurryThis$6(''.replace);
var stringSlice$4 = uncurryThis$6(''.slice);
var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d{1,2}|<[^>]*>)/g;
var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d{1,2})/g;

// `GetSubstitution` abstract operation
// https://tc39.es/ecma262/#sec-getsubstitution
var getSubstitution$1 = function (matched, str, position, captures, namedCaptures, replacement) {
  var tailPos = position + matched.length;
  var m = captures.length;
  var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
  if (namedCaptures !== undefined) {
    namedCaptures = toObject$2(namedCaptures);
    symbols = SUBSTITUTION_SYMBOLS;
  }
  return replace$4(replacement, symbols, function (match, ch) {
    var capture;
    switch (charAt$4(ch, 0)) {
      case '$': return '$';
      case '&': return matched;
      case '`': return stringSlice$4(str, 0, position);
      case "'": return stringSlice$4(str, tailPos);
      case '<':
        capture = namedCaptures[stringSlice$4(ch, 1, -1)];
        break;
      default: // \d\d?
        var n = +ch;
        if (n === 0) return match;
        if (n > m) {
          var f = floor$2(n / 10);
          if (f === 0) return match;
          if (f <= m) return captures[f - 1] === undefined ? charAt$4(ch, 1) : captures[f - 1] + charAt$4(ch, 1);
          return match;
        }
        capture = captures[n - 1];
    }
    return capture === undefined ? '' : capture;
  });
};

var apply = functionApply;
var call$4 = functionCall;
var uncurryThis$5 = functionUncurryThis;
var fixRegExpWellKnownSymbolLogic$2 = fixRegexpWellKnownSymbolLogic;
var fails$4 = fails$z;
var anObject$4 = anObject$k;
var isCallable$1 = isCallable$r;
var isNullOrUndefined$2 = isNullOrUndefined$8;
var toIntegerOrInfinity = toIntegerOrInfinity$7;
var toLength$1 = toLength$8;
var toString$5 = toString$d;
var requireObjectCoercible$2 = requireObjectCoercible$9;
var advanceStringIndex$1 = advanceStringIndex$3;
var getMethod$2 = getMethod$7;
var getSubstitution = getSubstitution$1;
var regExpExec$2 = regexpExecAbstract;
var wellKnownSymbol$3 = wellKnownSymbol$n;

var REPLACE = wellKnownSymbol$3('replace');
var max = Math.max;
var min = Math.min;
var concat = uncurryThis$5([].concat);
var push$4 = uncurryThis$5([].push);
var stringIndexOf$1 = uncurryThis$5(''.indexOf);
var stringSlice$3 = uncurryThis$5(''.slice);

var maybeToString = function (it) {
  return it === undefined ? it : String(it);
};

// IE <= 11 replaces $0 with the whole match, as if it was $&
// https://stackoverflow.com/questions/6024666/getting-ie-to-replace-a-regex-with-the-literal-string-0
var REPLACE_KEEPS_$0 = (function () {
  // eslint-disable-next-line regexp/prefer-escape-replacement-dollar-char -- required for testing
  return 'a'.replace(/./, '$0') === '$0';
})();

// Safari <= 13.0.3(?) substitutes nth capture where n>m with an empty string
var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = (function () {
  if (/./[REPLACE]) {
    return /./[REPLACE]('a', '$0') === '';
  }
  return false;
})();

var REPLACE_SUPPORTS_NAMED_GROUPS = !fails$4(function () {
  var re = /./;
  re.exec = function () {
    var result = [];
    result.groups = { a: '7' };
    return result;
  };
  // eslint-disable-next-line regexp/no-useless-dollar-replacements -- false positive
  return ''.replace(re, '$<a>') !== '7';
});

// @@replace logic
fixRegExpWellKnownSymbolLogic$2('replace', function (_, nativeReplace, maybeCallNative) {
  var UNSAFE_SUBSTITUTE = REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE ? '$' : '$0';

  return [
    // `String.prototype.replace` method
    // https://tc39.es/ecma262/#sec-string.prototype.replace
    function replace(searchValue, replaceValue) {
      var O = requireObjectCoercible$2(this);
      var replacer = isNullOrUndefined$2(searchValue) ? undefined : getMethod$2(searchValue, REPLACE);
      return replacer
        ? call$4(replacer, searchValue, O, replaceValue)
        : call$4(nativeReplace, toString$5(O), searchValue, replaceValue);
    },
    // `RegExp.prototype[@@replace]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@replace
    function (string, replaceValue) {
      var rx = anObject$4(this);
      var S = toString$5(string);

      if (
        typeof replaceValue == 'string' &&
        stringIndexOf$1(replaceValue, UNSAFE_SUBSTITUTE) === -1 &&
        stringIndexOf$1(replaceValue, '$<') === -1
      ) {
        var res = maybeCallNative(nativeReplace, rx, S, replaceValue);
        if (res.done) return res.value;
      }

      var functionalReplace = isCallable$1(replaceValue);
      if (!functionalReplace) replaceValue = toString$5(replaceValue);

      var global = rx.global;
      if (global) {
        var fullUnicode = rx.unicode;
        rx.lastIndex = 0;
      }
      var results = [];
      while (true) {
        var result = regExpExec$2(rx, S);
        if (result === null) break;

        push$4(results, result);
        if (!global) break;

        var matchStr = toString$5(result[0]);
        if (matchStr === '') rx.lastIndex = advanceStringIndex$1(S, toLength$1(rx.lastIndex), fullUnicode);
      }

      var accumulatedResult = '';
      var nextSourcePosition = 0;
      for (var i = 0; i < results.length; i++) {
        result = results[i];

        var matched = toString$5(result[0]);
        var position = max(min(toIntegerOrInfinity(result.index), S.length), 0);
        var captures = [];
        // NOTE: This is equivalent to
        //   captures = result.slice(1).map(maybeToString)
        // but for some reason `nativeSlice.call(result, 1, result.length)` (called in
        // the slice polyfill when slicing native arrays) "doesn't work" in safari 9 and
        // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.
        for (var j = 1; j < result.length; j++) push$4(captures, maybeToString(result[j]));
        var namedCaptures = result.groups;
        if (functionalReplace) {
          var replacerArgs = concat([matched], captures, position, S);
          if (namedCaptures !== undefined) push$4(replacerArgs, namedCaptures);
          var replacement = toString$5(apply(replaceValue, undefined, replacerArgs));
        } else {
          replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);
        }
        if (position >= nextSourcePosition) {
          accumulatedResult += stringSlice$3(S, nextSourcePosition, position) + replacement;
          nextSourcePosition = position + matched.length;
        }
      }
      return accumulatedResult + stringSlice$3(S, nextSourcePosition);
    }
  ];
}, !REPLACE_SUPPORTS_NAMED_GROUPS || !REPLACE_KEEPS_$0 || REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE);

/**
 * Advanced search component.
 *
 * @param props - Props injected to the component.
 *
 * @returns React element.
 */

const AdvancedSearch = props => {
  const {
    aligned,
    clearIcon,
    className,
    children,
    clearButtonPopupLabel,
    defaultSearchStrategy,
    disableSearchFilterDropdown,
    dropdownPosition,
    dropdownTriggerPopupLabel,
    enableQuerySearch,
    externalSearchQuery,
    fill,
    filterAttributeOptions,
    filterConditionOptions,
    inputSize,
    onExternalSearchQueryClear,
    onSearchQuerySubmit,
    placeholder,
    resetSubmittedState,
    searchOptionsHeader,
    sessionTimedOut,
    style,
    submitted,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId,
    triggerClearQuery
  } = props;
  const searchInputRef = useRef();
  const [internalSearchQuery, setInternalSearchQuery] = useState("");
  const [showSearchFieldHint, setShowSearchFieldHint] = useState(false);
  const [isDropdownVisible, setIsDropdownVisible] = useState(false);
  const [internalQueryClearTriggerState, setInternalQueryClearTriggerState] = useState(false);
  /**
   * useEffect hook to handle `sessionTimedOut` change.
   */

  useEffect(() => {
    if (sessionTimedOut) {
      setIsDropdownVisible(false);
    }
  }, [sessionTimedOut]);
  /**
   * useEffect hook to handle `internalSearchQuery` change.
   */

  useEffect(() => {
    if (!internalSearchQuery) {
      setShowSearchFieldHint(false);
    }

    if (internalSearchQuery && !isDropdownVisible && externalSearchQuery !== internalSearchQuery) {
      setShowSearchFieldHint(true);
    }
  }, [internalSearchQuery]);
  /**
   * useEffect hook to handle `externalSearchQuery` changes.
   */

  useEffect(() => {
    setInternalSearchQuery(externalSearchQuery);
  }, [externalSearchQuery]);
  /**
   * useEffect hook to handle `submitted` prop changes.
   */

  useEffect(() => {
    if (submitted) {
      setIsDropdownVisible(false);
      resetSubmittedState();
    }
  }, [submitted]);
  useEffect(() => {
    if (triggerClearQuery === undefined || internalQueryClearTriggerState === triggerClearQuery) {
      return;
    }

    clearSearchQuery();
    setInternalQueryClearTriggerState(triggerClearQuery);
  }, [triggerClearQuery]);
  /**
   * Wrapper `div` style classes.
   */

  const wrapperClasses = classNames({
    ["search-hint-active"]: enableQuerySearch && showSearchFieldHint,
    [`aligned-${aligned}`]: aligned,
    [`fill-${fill}`]: fill
  }, className);
  /**
   * Search field style classes.
   */

  const searchFieldClasses = classNames({
    active: internalSearchQuery
  }, className);
  /**
   * Handles the search input field `onChange` event.
   *
   * @param e - Input change event.
   */

  const handleSearchQueryChange = e => {
    const {
      value
    } = e.target;
    setInternalSearchQuery(value);
  };
  /**
   * Handles the show options dropdown `onClick` event.
   */


  const handleShowOptionsClick = () => {
    setIsDropdownVisible(!isDropdownVisible);
  };
  /**
   * Handles the clear query button `onClick` event.
   */


  const clearSearchQuery = () => {
    setInternalSearchQuery("");
    onSearchQuerySubmit(false, null);
    onExternalSearchQueryClear();
  };
  /**
   * Handles search query submit by keyboard events.
   *
   * @param e - Keyboard event.
   */


  const handleSearchQuerySubmit = e => {
    const {
      key,
      shiftKey
    } = e;
    let query = ""; // If only enter key is pressed perform the default filter strategy.

    if (!shiftKey && key === "Enter") {
      if (internalSearchQuery === "") {
        query = null;
      } else {
        let advancedSearch = false;
        const terms = internalSearchQuery.split(" ");

        if (terms.length > 2) {
          const attributes = filterAttributeOptions.filter(attribute => {
            return attribute.value === terms[0];
          });

          if (attributes.length > 0) {
            const conditions = filterConditionOptions.filter(condition => {
              return condition.value === terms[1];
            });

            if (conditions.length > 0) {
              advancedSearch = true;
            }
          }
        }

        if (advancedSearch) {
          query = internalSearchQuery;
        } else {
          query = defaultSearchStrategy.replace(/%search-value%/g, internalSearchQuery);
        }
      }

      onSearchQuerySubmit(false, query);
      setShowSearchFieldHint(false);
    } // If both `Enter` key and `Shift` key are pressed, treat the input
    // as a query and perform the search.


    if (shiftKey && key === "Enter" && enableQuerySearch) {
      query = internalSearchQuery;
      onSearchQuerySubmit(true, query);
      setShowSearchFieldHint(false);
    }
  };
  /**
   * Handles the search field blur.
   */


  const handleSearchFieldBlur = () => {
    setShowSearchFieldHint(false);
  };
  /**
   * Handles the dropdown close event.
   */


  const handleSearchDropdownClose = () => {
    setIsDropdownVisible(false);
  };

  return /*#__PURE__*/React__default.createElement("div", {
    className: `advanced-search-wrapper ${wrapperClasses}`,
    "data-componentid": componentId,
    "data-testid": testId
  }, /*#__PURE__*/React__default.createElement("div", {
    ref: searchInputRef
  }, /*#__PURE__*/React__default.createElement(Input, {
    "data-componentid": `${componentId}-input`,
    "data-testid": `${testId}-input`,
    action: /*#__PURE__*/React__default.createElement(React__default.Fragment, null, internalSearchQuery ? /*#__PURE__*/React__default.createElement(Popup, {
      disabled: !clearButtonPopupLabel,
      trigger: /*#__PURE__*/React__default.createElement(Button$1, {
        "data-componentid": `${componentId}-clear-button`,
        "data-testid": `${testId}-clear-button`,
        basic: true,
        compact: true,
        className: "input-add-on",
        onClick: clearSearchQuery
      }, /*#__PURE__*/React__default.createElement(GenericIcon, {
        size: "nano",
        defaultIcon: true,
        transparent: true,
        icon: clearIcon ? clearIcon : SvgCrossIcon
      })),
      position: "top center",
      content: clearButtonPopupLabel,
      inverted: true
    }) : null, !disableSearchFilterDropdown && /*#__PURE__*/React__default.createElement(Popup, {
      disabled: !dropdownTriggerPopupLabel || isDropdownVisible,
      trigger: /*#__PURE__*/React__default.createElement(Button$1, {
        "data-componentid": `${componentId}-options-button`,
        "data-testid": `${testId}-options-button`,
        basic: true,
        compact: true,
        className: "input-add-on",
        onClick: handleShowOptionsClick
      }, /*#__PURE__*/React__default.createElement(Icon, {
        name: "caret down"
      })),
      position: "top center",
      content: dropdownTriggerPopupLabel,
      inverted: true
    })),
    className: `advanced-search with-add-on ${searchFieldClasses}`,
    size: inputSize,
    style: style,
    icon: "search",
    iconPosition: "left",
    placeholder: placeholder,
    value: internalSearchQuery,
    onBlur: handleSearchFieldBlur,
    onChange: handleSearchQueryChange,
    onKeyDown: handleSearchQuerySubmit
  })), /*#__PURE__*/React__default.createElement(Popup, {
    context: searchInputRef,
    content: /*#__PURE__*/React__default.createElement("div", {
      className: "search-filters-dropdown"
    }, /*#__PURE__*/React__default.createElement(Heading, {
      as: "h6",
      bold: "500",
      compact: true,
      "data-componentid": `${componentId}-header`,
      "data-testid": `${testId}-header`
    }, searchOptionsHeader), /*#__PURE__*/React__default.createElement(Divider, {
      className: "compact"
    }), /*#__PURE__*/React__default.createElement("div", {
      className: "form-wrapper",
      "data-componentid": `${componentId}-form-wrapper`,
      "data-testid": `${testId}-form-wrapper`
    }, children)),
    on: "click",
    position: dropdownPosition,
    open: isDropdownVisible,
    onClose: handleSearchDropdownClose,
    closeOnPortalMouseLeave: false,
    "data-componentid": `${componentId}-dropdown`,
    "data-testid": `${testId}-dropdown`,
    hoverable: true,
    pinned: true,
    className: "advanced-search"
  }));
};
/**
 * Default proptypes for the Advanced search component.
 */

AdvancedSearch.defaultProps = {
  aligned: "left",
  className: null,
  clearButtonPopupLabel: null,
  "data-componentid": "advanced-search",
  "data-testid": "advanced-search",
  disableSearchFilterDropdown: false,
  dropdownPosition: "bottom left",
  dropdownTriggerPopupLabel: null,
  enableQuerySearch: true,
  externalSearchQuery: "",
  fill: "default",
  hintActionKeys: "Enter",
  hintLabel: "Search for",
  onExternalSearchQueryClear: null,
  placeholder: null,
  searchOptionsHeader: "Advanced Search",
  submitted: false
};

/**
 * Copy to clipboard input field component.
 *
 * @param props - Props injected to the component.
 * @returns Copy Input Field Component.
 */

const CopyInputField = props => {
  const {
    value,
    className,
    hideSecretLabel,
    secret,
    showSecretLabel,
    label,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("copy-input", className);
  const inputRef = useRef(null);
  const copyButtonRef = useRef(null);
  const [copied, setCopied] = useState(false);
  const [show, setShow] = useState(false);
  useEffect(() => {
    if (copied) {
      copyButtonRef.current.focus();
    }
  }, [copied]);
  /**
   * Copies the value to the users clipboard.
   *
   * @param event - MouseEvent<HTMLButtonElement>
   */

  const copyValueToClipboard = event => __awaiter(void 0, void 0, void 0, function* () {
    var _a, _b;

    event.stopPropagation();
    /**
     * Since the reference input component is a {@link Input} we can
     * directly get the current value from props itself.
     */

    const _selection = (_b = (_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.props["value"]) !== null && _b !== void 0 ? _b : "";

    yield CommonUtils.copyTextToClipboard(_selection);
    setCopied(true);
  });

  return /*#__PURE__*/React__default.createElement(Input, {
    label: label,
    ref: inputRef,
    value: value,
    labelPosition: "right",
    readOnly: true,
    action: /*#__PURE__*/React__default.createElement(Button$1, {
      "data-tooltip": copied ? "Copied!" : "Copy to clipboard",
      "data-inverted": "",
      className: "copy-input-action",
      icon: "copy",
      type: "button",
      onMouseEnter: () => {
        setCopied(false);
      },
      ref: copyButtonRef,
      onClick: copyValueToClipboard
    }),
    fluid: true,
    className: classes,
    type: !secret ? "text" : show ? "text" : "password",
    icon: secret && /*#__PURE__*/React__default.createElement(Popup, {
      trigger: /*#__PURE__*/React__default.createElement(Icon, {
        className: "copy-input-eye-icon",
        name: !show ? "eye" : "eye slash",
        disabled: !value,
        link: true,
        onClick: () => {
          setShow(!show);
        }
      }),
      position: "top center",
      content: !show ? showSecretLabel : hideSecretLabel,
      inverted: true,
      popper: /*#__PURE__*/React__default.createElement("div", {
        style: {
          filter: "none"
        }
      })
    }),
    "data-componentid": `${componentId}-wrapper`,
    "data-testid": `${testId}-wrapper`
  });
};
/**
 * Default proptypes for the copy input component.
 */

CopyInputField.defaultProps = {
  "data-componentid": "copy-input",
  "data-testid": "copy-input",
  hideSecretLabel: "Show",
  secret: false,
  showSecretLabel: "Hide"
};

/**
 * This displays a key-value pair of fields that can be dynamically added or removed.
 *
 * @param props - Props injected to the component.
 * @returns DynamicField component.
 */

const DynamicField = props => {
  const {
    bottomMargin,
    data,
    keyType,
    keyData,
    submit,
    update,
    keyName,
    valueName,
    keyRequiredMessage,
    valueRequiredErrorMessage,
    listen,
    requiredField,
    duplicateKeyErrorMsg,
    readOnly,
    ["data-testid"]: testId
  } = props;
  const [fields, setFields] = useState();
  const [editIndex, setEditIndex] = useState(null);
  const [editValue, setEditValue] = useState("");
  const [editKey, setEditKey] = useState("");
  const [updateMapIndex, setUpdateMapIndex] = useState(null);
  const [showAddErrorMsg, setAddShowErrorMsg] = useState(false);
  const [showEditErrorMsg, setShowEditErrorMsg] = useState(false);
  const initRender = useRef(true);
  const [add, setAdd] = useTrigger();
  const [reset, setReset] = useTrigger();
  const [updateTrigger, setUpdateTrigger] = useTrigger();
  /**
   * Resets edit states when when editIndex becomes null
   */

  useEffect(() => {
    if (editIndex === null) {
      setEditKey("");
      setEditValue("");
    }
  }, [editIndex]);
  /**
   * Pushes the existing pairs to the state
   */

  useEffect(() => {
    const tempFields = new Map();
    data === null || data === void 0 ? void 0 : data.forEach((field, index) => {
      tempFields.set(index, field);
    });
    setFields(tempFields);
  }, []);
  /**
   * Prevent submit from being triggered during initial render
   */

  useEffect(() => {
    if (!update) {
      return;
    }

    if (initRender.current) {
      initRender.current = false;
    } else if (fields) {
      update(Array.from(fields.values()));
    }
  }, [submit]);
  /**
   * Triggers an update when the index of the pair to be updated is set
   */

  useEffect(() => {
    if (updateMapIndex !== null) {
      setUpdateTrigger();
    }
  }, [updateMapIndex]);
  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, (keyData === null || keyData === void 0 ? void 0 : keyData.length) !== (fields === null || fields === void 0 ? void 0 : fields.size) ? /*#__PURE__*/React__default.createElement(React__default.Fragment, null, showAddErrorMsg && /*#__PURE__*/React__default.createElement(Message$1, {
    error: true
  }, duplicateKeyErrorMsg), /*#__PURE__*/React__default.createElement(Forms, {
    onSubmit: values => {
      if (!showAddErrorMsg) {
        const tempFields = new Map(fields);
        const newIndex = tempFields.size > 0 ? Array.from(tempFields.keys())[tempFields.size - 1] + 1 : 0;
        tempFields.set(newIndex, {
          key: values.get("key").toString(),
          value: values.get("value").toString()
        });
        setFields(tempFields);

        if (listen) {
          listen(Array.from(tempFields.values()));
        }

        setReset();
      }
    },
    submitState: add,
    resetState: reset
  }, /*#__PURE__*/React__default.createElement(List, {
    className: "dynamic-field"
  }, /*#__PURE__*/React__default.createElement(List.Item, null, keyType === "dropdown" ? /*#__PURE__*/React__default.createElement(Field, {
    type: keyType,
    placeholder: `Enter a ${keyName}`,
    required: requiredField,
    requiredErrorMessage: keyRequiredMessage,
    name: "key",
    fluid: true,
    children: keyType === "dropdown" ? keyData === null || keyData === void 0 ? void 0 : keyData.map(key => {
      return {
        key: key.id,
        text: key.value,
        value: key.value
      };
    }) : [],
    displayErrorOn: "submit",
    validation: value => {
      let isSameUserStore = false;

      for (const mapping of fields) {
        if (mapping[1].key === value) {
          isSameUserStore = true;
          break;
        }
      }

      setAddShowErrorMsg(false);

      if (isSameUserStore) {
        setAddShowErrorMsg(true);
      }
    },
    readOnly: readOnly,
    "data-testid": `${testId}-${keyType}`
  }) : /*#__PURE__*/React__default.createElement(Field, {
    type: keyType,
    placeholder: `Enter a ${keyName}`,
    required: requiredField,
    requiredErrorMessage: keyRequiredMessage,
    name: "key",
    readOnly: readOnly,
    "data-testid": `${testId}-${keyType}`
  })), /*#__PURE__*/React__default.createElement(List.Item, null, /*#__PURE__*/React__default.createElement(Field, {
    type: "text",
    placeholder: `Enter a ${valueName}`,
    required: true,
    requiredErrorMessage: valueRequiredErrorMessage,
    name: "value",
    readOnly: readOnly,
    "data-testid": `${testId}-input`
  })), /*#__PURE__*/React__default.createElement(List.Item, null, /*#__PURE__*/React__default.createElement(Popup, {
    disabled: readOnly,
    trigger: /*#__PURE__*/React__default.createElement(Button$1, {
      type: "button",
      className: "list-icon",
      size: "small",
      icon: "add",
      onClick: () => {
        setAdd();
      },
      disabled: readOnly
    }),
    position: "top center",
    content: "Add",
    inverted: true
  })))), bottomMargin && /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  })) : null, fields ? /*#__PURE__*/React__default.createElement(React__default.Fragment, null, showEditErrorMsg && /*#__PURE__*/React__default.createElement(Message$1, {
    error: true
  }, duplicateKeyErrorMsg), /*#__PURE__*/React__default.createElement(Forms, {
    onSubmit: values => {
      if (!showEditErrorMsg) {
        const tempFields = new Map(fields);
        tempFields.set(updateMapIndex, {
          key: values.get("editKey").toString(),
          value: values.get("editValue").toString()
        });
        setFields(tempFields);

        if (listen) {
          listen(Array.from(tempFields.values()));
        }

        setEditIndex(null);
        setUpdateMapIndex(null);
      }
    },
    submitState: updateTrigger
  }, Array.from(fields).map(([mapIndex, field], index) => {
    return /*#__PURE__*/React__default.createElement(List, {
      className: "dynamic-field",
      key: index
    }, /*#__PURE__*/React__default.createElement(List.Item, null, editIndex === index ? keyType === "dropdown" ? /*#__PURE__*/React__default.createElement(Field, {
      type: keyType,
      placeholder: `Enter a ${keyName}`,
      required: requiredField,
      requiredErrorMessage: keyRequiredMessage,
      name: "editKey",
      children: keyType === "dropdown" ? keyData === null || keyData === void 0 ? void 0 : keyData.map(key => {
        return {
          key: key.id,
          text: key.value,
          value: key.value
        };
      }) : [],
      value: editKey,
      displayErrorOn: "blur",
      validation: value => {
        let isSameUserStore = false;

        for (const mapping of fields) {
          if (mapping[1].key === value && mapping[1] !== field) {
            isSameUserStore = true;
            break;
          }
        }

        setShowEditErrorMsg(false);

        if (isSameUserStore) {
          setShowEditErrorMsg(true);
        }
      },
      "data-testid": `${testId}-${keyType}`
    }) : /*#__PURE__*/React__default.createElement(Field, {
      type: keyType,
      placeholder: `Enter a ${keyName}`,
      required: requiredField,
      requiredErrorMessage: keyRequiredMessage,
      name: "editKey",
      value: editKey,
      "data-testid": `${testId}-${keyType}`
    }) : /*#__PURE__*/React__default.createElement(Label, {
      size: "large",
      className: "properties-label"
    }, field.key)), /*#__PURE__*/React__default.createElement(List.Item, null, editIndex === index ? /*#__PURE__*/React__default.createElement(Field, {
      name: "editValue",
      required: requiredField,
      requiredErrorMessage: valueRequiredErrorMessage,
      type: "text",
      value: editValue,
      placeholder: `Enter a ${valueName}`
    }) : /*#__PURE__*/React__default.createElement(Label, {
      size: "large",
      className: "properties-label"
    }, field.value)), /*#__PURE__*/React__default.createElement(List.Item, null, editIndex === index ? /*#__PURE__*/React__default.createElement(Popup, {
      trigger: /*#__PURE__*/React__default.createElement(Button$1, {
        type: "button",
        className: "list-icon",
        size: "small",
        icon: "checkmark",
        onClick: () => {
          setUpdateMapIndex(mapIndex);
        }
      }),
      position: "top center",
      content: "Update",
      inverted: true
    }) : /*#__PURE__*/React__default.createElement(Popup, {
      trigger: /*#__PURE__*/React__default.createElement(Button$1, {
        type: "button",
        className: "list-icon",
        size: "small",
        icon: "pencil",
        onClick: () => {
          setEditIndex(index);
          setEditKey(field.key);
          setEditValue(field.value);
        }
      }),
      position: "top center",
      content: "Edit",
      inverted: true
    }), editIndex === index ? /*#__PURE__*/React__default.createElement(Popup, {
      trigger: /*#__PURE__*/React__default.createElement(Button$1, {
        type: "button",
        className: "list-icon",
        size: "small",
        icon: "close",
        onClick: () => {
          setEditIndex(null);
        }
      }),
      position: "top center",
      content: "Cancel",
      inverted: true
    }) : null, /*#__PURE__*/React__default.createElement(Popup, {
      trigger: /*#__PURE__*/React__default.createElement(Button$1, {
        type: "button",
        className: "list-icon",
        size: "small",
        icon: "trash",
        onClick: () => {
          setEditIndex(null);
          const tempFields = new Map(fields);
          tempFields.delete(mapIndex);
          setFields(tempFields);

          if (listen) {
            listen(Array.from(tempFields.values()));
          }
        }
      }),
      position: "top center",
      content: "Delete",
      inverted: true
    })));
  }))) : null);
}; // Set default props

DynamicField.defaultProps = {
  bottomMargin: true,
  "data-testid": "dynamic-field",
  duplicateKeyErrorMsg: "This is key is already selected. Please choose another key.",
  requiredField: false
};

/**
 * Component to upload file and read the content.
 * TODO: Pass localized strings and remove the hardcoded text.
 *
 * @param props - Props injected to the component.
 * @returns file upload component
 */

const FileUpload = props => {
  const {
    dropzoneIcon: DropzoneIcon,
    initialName,
    initialFile,
    initialPasteValue,
    initialContent,
    updateFileName,
    updateFile,
    updateContent,
    updatePasteContent,
    encode,
    triggerEmptyFileError,
    fileTypeToUpload,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const [name, setName] = useState("");
  const [file, setFile] = useState(null);
  const [content, setContent] = useState("");
  const [pasteContent, setPasteContent] = useState("");
  const [encodedContent, setEncodedContent] = useState("");
  const [, setNameError] = useState(false);
  const [fileError, setFileError] = useState(false);
  const [, setEncodeError] = useState(false);
  const [dragOver, setDragOver] = useState(false);
  const [activeIndex, setActiveIndex] = useState(0);
  const [dark, setDark] = useState(false);
  const fileUpload = useRef(null);
  const loadedInitValue = useRef(false);
  /**
   * Set initialValues.
   */

  useEffect(() => {
    if (initialName) {
      setName(initialName);
    }
  }, [initialName]);
  /**
   * Set initialValues.
   */

  useEffect(() => {
    if (initialFile) {
      setFile(initialFile);
    }
  }, [initialFile]);
  /**
   * Set initialValues.
   */

  useEffect(() => {
    if (initialName) {
      setName(initialName);
    }

    if (initialFile) {
      setFile(initialFile);
    }

    if (initialPasteValue) {
      setPasteContent(initialPasteValue);
    }

    if (!loadedInitValue.current) {
      loadedInitValue.current = true;
    }

    if (initialContent) {
      // Check if initial content is not equal to initial  paste content or not
      if (!(initialPasteValue && (encode && initialContent === btoa(initialPasteValue) || !encode && initialContent === initialPasteValue))) {
        if (encode) {
          setEncodedContent(initialContent);
          return;
        }

        setContent(initialContent);
      }
    }
  }, []);
  /**
   * Trigger file error.
   */

  useEffect(() => {
    if (triggerEmptyFileError) {
      setFileError(true);
    }
  }, [triggerEmptyFileError]);
  /**
   * Update file name.
   */

  useEffect(() => {
    if (name || loadedInitValue.current) {
      if (name) {
        setNameError(false);
      }

      updateFileName(name);
    }
  }, [name]);
  /***
   * Update file.
   */

  useEffect(() => {
    if (file || loadedInitValue.current) {
      if (file) {
        setFileError(false);
      }

      updateFile(file);
    }
  }, [file]);
  /**
   * Update content if encoded content is updated.
   */

  useEffect(() => {
    if (encode && (encodedContent || loadedInitValue.current)) {
      updateContent(encodedContent);
    }
  }, [encodedContent]);
  /**
   * Update content if content is updated.
   */

  useEffect(() => {
    if (!encode && (content || loadedInitValue.current)) {
      updateContent(content);
    }
  }, [content]);
  /**
   * Update content if paste content is updated.
   */

  useEffect(() => {
    if (pasteContent) {
      updatePasteContent(pasteContent);

      if (encode) {
        updateContent(btoa(pasteContent));
        return;
      }

      updateContent(pasteContent);
    } else {
      if (loadedInitValue.current) {
        updatePasteContent(pasteContent);
      }
    }
  }, [pasteContent]);
  /**
   * Update contents if paste value or file content removed.
   */

  useEffect(() => {
    const fileContent = encode ? encodedContent : content;
    const newPasteContent = encode ? btoa(pasteContent) : pasteContent;

    if (isEmpty(fileContent) && !isEmpty(newPasteContent)) {
      updateContent(newPasteContent);
    } else if (!isEmpty(fileContent) && isEmpty(newPasteContent)) {
      updateContent(fileContent);
    } else if (isEmpty(fileContent) && isEmpty(newPasteContent)) {
      updateContent("");
    }
  }, [content, encodedContent, pasteContent]);
  useEffect(() => {
    if (window.matchMedia("(prefers-color-scheme:dark)").matches) {
      setDark(true);
    }

    const callback = e => {
      if (e.matches) {
        setDark(true);
      } else {
        setDark(false);
      }
    };

    window.matchMedia("(prefers-color-scheme:dark)").addEventListener("change", callback);
    return () => {
      window.matchMedia("(prefers-color-scheme:dark)").removeEventListener("change", callback);
    };
  }, []);
  const panes = [{
    menuItem: "Upload",
    render: () => !file ? /*#__PURE__*/React__default.createElement("div", {
      onDrop: event => {
        event.preventDefault();
        event.stopPropagation();
        setDragOver(false);

        if (event.dataTransfer.files[0]) {
          const file = event.dataTransfer.files[0];
          addFile(file);
        }
      },
      onDragOver: event => {
        event.preventDefault();
        event.stopPropagation();
        setDragOver(true);
      },
      onDragLeave: () => {
        setDragOver(false);
      },
      "data-componentid": `${componentId}-drop-zone`,
      "data-testid": `${testId}-drop-zone`
    }, /*#__PURE__*/React__default.createElement(Segment, {
      placeholder: true,
      className: `drop-zone ${dragOver ? "drag-over" : ""}`
    }, /*#__PURE__*/React__default.createElement("div", {
      className: "certificate-upload-placeholder"
    }, /*#__PURE__*/React__default.createElement(DropzoneIcon, null), /*#__PURE__*/React__default.createElement("p", {
      className: "description"
    }, "Drag and drop file here"), /*#__PURE__*/React__default.createElement("p", {
      className: "description"
    }, "\u2013 or \u2013")), /*#__PURE__*/React__default.createElement(Button$1, {
      basic: true,
      primary: true,
      onClick: event => {
        event.preventDefault();
        fileUpload.current.click();
      }
    }, "Upload"))) : /*#__PURE__*/React__default.createElement(Segment, {
      placeholder: true
    }, /*#__PURE__*/React__default.createElement(Segment, {
      textAlign: "center",
      basic: true
    }, /*#__PURE__*/React__default.createElement(Icon, {
      name: "file code outline",
      size: "huge"
    }), /*#__PURE__*/React__default.createElement("p", {
      className: "file-name"
    }, file.name), /*#__PURE__*/React__default.createElement(Icon, {
      name: "trash alternate",
      link: true,
      onClick: () => {
        setFile(null);
        setContent("");
        setEncodedContent("");
        setFileError(false);
      }
    })))
  }, {
    menuItem: "Paste",
    render: () => /*#__PURE__*/React__default.createElement(Form, null, /*#__PURE__*/React__default.createElement(TextArea, {
      rows: 13,
      placeholder: "Paste the content File",
      value: pasteContent,
      onChange: event => {
        setPasteContent(event.target.value);
        setEncodeError(false);
        setFileError(false);
      },
      spellCheck: false,
      className: `certificate-editor ${dark ? "dark" : "light"}`,
      "data-componentid": `${componentId}-paste-content-textarea`,
      "data-testid": `${testId}-paste-content-textarea`
    }))
  }];
  /**
   * Add the file.
   * @param file - File to be added.
   */

  const addFile = file => {
    setFile(file);
    setEncodeError(false);
    setFileError(false);
    const fileName = file.name.split("."); // removes the file extension

    fileName.pop();
    !name && setName(fileName.join("."));
    readFile(file);
  };

  const readFile = newFile => {
    const reader = new FileReader();
    reader.readAsText(newFile);

    reader.onload = () => {
      setContent(reader.result);
      setEncodedContent(btoa(reader.result));
    };
  };

  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement("input", {
    ref: fileUpload,
    type: "file",
    accept: fileTypeToUpload,
    hidden: true,
    onChange: event => {
      const file = event.target.files[0];
      event.target.value = null;
      addFile(file);
    },
    "data-componentid": componentId,
    "data-testid": testId
  }), fileError ? /*#__PURE__*/React__default.createElement(Message$1, {
    negative: true,
    attached: "bottom"
  }, /*#__PURE__*/React__default.createElement(Message$1.Header, null, " Either add a file or paste the content of the file")) : /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), /*#__PURE__*/React__default.createElement(Tab, {
    className: "tabs resource-tabs",
    menu: {
      pointing: true,
      secondary: true
    },
    panes: panes,
    activeIndex: activeIndex,
    onTabChange: (event, {
      activeIndex
    }) => {
      setActiveIndex(parseInt(activeIndex.toString()));
    }
  }));
};
/**
 * Default props for the file upload component.
 */

FileUpload.defaultProps = {
  "data-componentid": "file-upload",
  "data-testid": "file-upload",
  encode: false,
  fileTypeToUpload: "text/xml"
};

var PROPER_FUNCTION_NAME = functionName.PROPER;
var fails$3 = fails$z;
var whitespaces = whitespaces$3;

var non = '\u200B\u0085\u180E';

// check that a method works with the correct list
// of whitespaces and has a correct name
var stringTrimForced = function (METHOD_NAME) {
  return fails$3(function () {
    return !!whitespaces[METHOD_NAME]()
      || non[METHOD_NAME]() !== non
      || (PROPER_FUNCTION_NAME && whitespaces[METHOD_NAME].name !== METHOD_NAME);
  });
};

var $$3 = _export;
var $trim = stringTrim.trim;
var forcedStringTrimMethod = stringTrimForced;

// `String.prototype.trim` method
// https://tc39.es/ecma262/#sec-string.prototype.trim
$$3({ target: 'String', proto: true, forced: forcedStringTrimMethod('trim') }, {
  trim: function trim() {
    return $trim(this);
  }
});

/**
 * Content loader component.
 *
 * @param props - Props injected to the global loader component.
 *
 * @returns the content loader component
 */

const LabelWithPopup = props => {
  const {
    className,
    popupHeader,
    popupSubHeader,
    popupContent,
    popupFooterRightActions,
    popupFooterLeftContent,
    popupOptions,
    labelColor,
    trigger,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["className", "popupHeader", "popupSubHeader", "popupContent", "popupFooterRightActions", "popupFooterLeftContent", "popupOptions", "labelColor", "trigger", "data-componentid"]);

  const classes = classNames("label-with-popup", className);
  return /*#__PURE__*/React__default.createElement(Popup, Object.assign({
    wide: true,
    size: "small",
    className: classes,
    position: "right center",
    trigger: trigger !== null && trigger !== void 0 ? trigger : /*#__PURE__*/React__default.createElement(Label, Object.assign({
      circular: true,
      size: "mini",
      className: "micro spaced-right status-label-with-popup",
      color: labelColor
    }, rest)),
    on: "hover",
    "data-componentid": componentId
  }, popupOptions), /*#__PURE__*/React__default.createElement(Popup.Content, {
    "data-componentid": `${componentId}-content-container`
  }, /*#__PURE__*/React__default.createElement(Grid, null, (popupHeader || popupSubHeader) && /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, null, popupHeader && /*#__PURE__*/React__default.createElement(Popup.Header, {
    "data-componentid": `${componentId}-header`
  }, /*#__PURE__*/React__default.createElement("strong", null, popupHeader)), popupSubHeader)), popupContent && /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    "data-componentid": `${componentId}-content`
  }, popupContent)), (popupFooterLeftContent || popupFooterRightActions) && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Divider, null), /*#__PURE__*/React__default.createElement(Grid.Row, null, popupFooterLeftContent && /*#__PURE__*/React__default.createElement(Grid.Column, {
    verticalAlign: "middle",
    floated: "left",
    width: 10,
    "data-componentid": `${componentId}-footer-left-content`
  }, popupFooterLeftContent), popupFooterRightActions && /*#__PURE__*/React__default.createElement(Grid.Column, {
    verticalAlign: "middle",
    floated: "right",
    width: 6,
    "data-componentid": `${componentId}-footer-right-actions`
  }, popupFooterRightActions))))));
};
/**
 * Default proptypes for component.
 */

LabelWithPopup.defaultProps = {
  "data-componentid": "label-with-popup",
  "data-testid": "label-with-popup"
};

const FormInputLabel = props => {
  const {
    children,
    htmlFor,
    disabled,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["children", "htmlFor", "disabled", "data-componentid", "data-testid"]);

  return /*#__PURE__*/React__default.createElement("label", Object.assign({
    "data-componentid": componentId,
    "data-testid": testId,
    htmlFor: htmlFor,
    className: classNames({
      disabled
    })
  }, rest), children);
};
FormInputLabel.defaultProps = {
  "data-componentid": "form-input-label",
  "data-testid": "form-input-label"
};

/**
 * URL Input component.
 *
 * @param props - Props injected to the component.
 *
 * @returns React Element.
 */

const URLInput = props => {
  const {
    addURLTooltip,
    allowEmptyValues,
    restrictSecondaryContent,
    customLabel,
    duplicateURLErrorMessage,
    emptyErrorMessage,
    isAllowEnabled,
    allowedOrigins,
    handleAddAllowedOrigin,
    handleRemoveAllowedOrigin,
    labelEnabled,
    showError,
    setShowError,
    urlState,
    setURLState,
    validation,
    validationErrorMsg,
    placeholder,
    productName,
    labelName,
    value,
    hint,
    required,
    disabled,
    hideComponent,
    showPredictions,
    computerWidth,
    readOnly,
    getSubmit,
    tenantDomain,
    onlyOrigin,
    skipValidation,
    skipInternalValidation,
    isCustom,
    addOriginByDefault,
    popupHeaderPositive,
    popupHeaderNegative,
    popupContentPositive,
    popupContentNegative,
    popupDetailedContentPositive,
    popupDetailedContentNegative,
    insecureURLDescription,
    showLessContent,
    showMoreContent,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const [changeUrl, setChangeUrl] = useState("");
  const [predictValue, setPredictValue] = useState([]);
  const [validURL, setValidURL] = useState(true);
  const [duplicateURL, setDuplicateURL] = useState(false);
  const [keepFocus, setKeepFocus] = useState(false);
  const [hideEntireComponent, setHideEntireComponent] = useState(false);
  const [showMore, setShowMore] = useState(false);
  /**
   * Add URL to the URL list.
   *
   * @returns URLs.
   */

  const addUrl = useCallback(() => {
    let url = changeUrl;
    /**
     * If the entered URL is a invalid i.e not a standard URL input, then we won't add
     * the input to the state.
     */

    if (!(skipValidation || skipInternalValidation) && !URLUtils.isURLValid(url, true)) {
      setValidURL(false);
      return;
    }

    const urlValid = skipValidation ? true : validation(url);
    setValidURL(urlValid);
    /*
     * If the entered URL is valid and it is intended to be an origin URL,
     * and it has a trailing "/" at the end, it is sliced to get the valid origin.
    */

    if (urlValid && onlyOrigin && url.charAt(url.length - 1) === "/") {
      url = url.slice(0, -1);
    }

    if (urlValid && (urlState === "" || urlState === undefined)) {
      setURLState(url);

      if (addOriginByDefault) {
        const originOfURL = URLUtils.urlComponents(url).origin;
        handleAddAllowedOrigin(originOfURL);
        allowedOrigins.push(originOfURL);
      }

      setChangeUrl("");
      return url;
    } else {
      const duplicate = checkDuplicateUrl(url);
      urlValid && setDuplicateURL(duplicate);

      if (urlValid && !duplicate) {
        setURLState(url + "," + urlState);

        if (addOriginByDefault) {
          handleAddAllowedOrigin(url);
          allowedOrigins.push(url);
        }

        setChangeUrl("");
        return url + "," + urlState;
      }
    }

    return;
  }, [changeUrl, setURLState, urlState, validation]);
  /**
   * This submits the URL and calls the callback function passing the URL as an argument.
   *
   * @param callback - A callback function that accepts the url as an optional argument.
   */

  const externalSubmit = callback => {
    if (getChangeUrl()) {
      const url = addUrl();

      if (url) {
        callback(url);
      }
    } else {
      callback();
    }
  };
  /**
   * Initial prediction for the URL.
   * @param changeValue - input by the user.
   */


  const getPredictions = changeValue => {
    return ["https://", "http://"].filter(item => item.toLowerCase().indexOf(changeValue.toLowerCase()) !== -1);
  };
  /**
   * Enter button option.
   * @param e - keypress event.
   */


  const keyPressed = e => {
    const key = e.which || e.charCode || e.keyCode;

    if (key === 13) {
      e.preventDefault();
      addUrl();
    }
  };
  /**
   * Checks whether the given URL is duplicated with the current values
   * @param url - URL to be checked
   *
   * @returns A boolean value denoting whether the URL is duplicated or not
   */


  const checkDuplicateUrl = useCallback(url => {
    const availableURls = !urlState ? [] : urlState === null || urlState === void 0 ? void 0 : urlState.split(",");
    const urls = new Set([...(onlyOrigin ? allowedOrigins !== null && allowedOrigins !== void 0 ? allowedOrigins : [] : []), ...(availableURls !== null && availableURls !== void 0 ? availableURls : [])]);

    if (url.charAt(url.length - 1) === "/") {
      return urls.has(url) || urls.has(url.slice(0, -1));
    } else {
      return urls.has(url) || urls.has(url + "/");
    }
  }, [urlState, onlyOrigin, allowedOrigins]);
  /**
   * Handle change event of the input.
   *
   * @param event - change event.
   */

  const handleChange = event => {
    const changeValue = event.target.value;
    let predictions = [];

    if (changeValue.length > 0) {
      predictions = getPredictions(changeValue);
    }

    if (!validURL) {
      setValidURL(true);
    }

    const isDuplicate = checkDuplicateUrl(changeValue);
    setDuplicateURL(isDuplicate);
    setKeepFocus(true);
    setPredictValue(predictions);
    setChangeUrl(changeValue.toString().trim());
  };
  /**
   * Handle blur event.
   */


  const handleOnBlur = () => {
    // TODO introduce a different method to handle this
    // if (!isEmpty(changeUrl)) {
    //     addUrl();
    // }
    setKeepFocus(false);
  };
  /**
   * When the predicted element is clicked select the predict.
   * @param predict - filter prediction.
   */


  const onPredictClick = predict => {
    setChangeUrl(predict);
    setPredictValue([]);
  };

  const addFormButton = e => {
    e.preventDefault();
    addUrl();
  };
  /**
   * Remove the URL from the listed URLS.
   * @param removeURL - URL to be removed.
   */


  const removeValue = removeURL => {
    let urlsAfterRemoved = urlState;

    if (urlState.split(",").length > 1) {
      const urls = urlsAfterRemoved.split(",");
      const removeIndex = urls.findIndex(url => url === removeURL);
      urls.splice(removeIndex, 1);
      urlsAfterRemoved = urls.join(",");
    } else {
      urlsAfterRemoved = "";
    }

    setURLState(urlsAfterRemoved); // If defined only, perform allowed origins related housekeeping tasks.

    if (!allowedOrigins) {
      return;
    }

    if (allowedOrigins.includes(removeURL)) {
      allowedOrigins.splice(allowedOrigins.indexOf(removeURL), 1);
    }

    handleRemoveAllowedOrigin(removeURL);
  };
  /**
   * Returns the changeUrl value.
   *
   * @returns the change URL.
   */


  const getChangeUrl = useCallback(() => {
    return changeUrl;
  }, [changeUrl]);
  /**
   * Calls the prop method by passing the `addUrl` and `getChangeUrl` methods as arguments.
   */

  useEffect(() => {
    if (getSubmit) {
      getSubmit(externalSubmit);
    }
  }, [getSubmit, addUrl, getChangeUrl]);
  useEffect(() => {
    setURLState(value);
  }, [value]);
  useEffect(() => {
    if (urlState && urlState !== "" && !validURL) {
      setValidURL(true);
    }
  }, [urlState]);
  useEffect(() => {
    if (showError) {
      setValidURL(false);
      setShowError(false);
    }
  }, [showError]);
  useEffect(() => {
    if (hideComponent) {
      setHideEntireComponent(hideComponent);
    }
  }, [hideComponent]);
  /**
   * Once clicked this function will immediately delegates the
   * action to the parent above this component. Calls -
   * {@link React.MouseEvent.preventDefault} to avoid accidental
   * form submission events.
   *
   * @param event - React mousevent
   * @param url - user input url
   */

  const onAllowOriginClick = (event, url) => {
    event.preventDefault();
    handleAddAllowedOrigin(url);
    allowedOrigins.push(url);
  };

  const computerSize = computerWidth ? computerWidth : 8;

  const resolveCORSStatusLabel = url => {
    const {
      origin,
      href
    } = URLUtils.urlComponents(url);
    const positive = isOriginIsKnownAndAllowed(url);
    const isValid = URLUtils.isURLValid(url, true) && (URLUtils.isHttpUrl(url) || URLUtils.isHttpsUrl(url));
    /**
     * TODO : React Components should not depend on the product
     * locale bundles.
     * Issue to track. {@link https://github.com/wso2/product-is/issues/10693}
     */

    return !isCustom || isValid ? /*#__PURE__*/React__default.createElement(LabelWithPopup, {
      className: "cors-details-popup",
      trigger: /*#__PURE__*/React__default.createElement(Icon, {
        className: "p-1",
        name: positive ? "check" : "exclamation triangle",
        color: positive ? "green" : "grey"
      }),
      popupHeader: positive ? popupHeaderPositive ? popupHeaderPositive : "CORS is Allowed for" : popupHeaderNegative ? popupHeaderNegative : "CORS is not Allowed for",
      popupSubHeader: /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Icon, {
        name: positive ? "check" : "times",
        color: positive ? "green" : "red"
      }), origin && origin !== "null" ? origin : href),
      popupContent: /*#__PURE__*/React__default.createElement(React__default.Fragment, null, positive ? popupContentPositive ? popupContentPositive : "The origin of this URL is allowed to make requests to " + `${productName} APIs from a browser.` : popupContentNegative ? popupContentNegative : "You need to enable CORS for the origin of this URL to make requests" + ` to ${productName} from a browser.`, !restrictSecondaryContent && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement("a", {
        onClick: () => setShowMore(!showMore)
      }, "\u00A0", showMore ? showLessContent ? showLessContent : "Show less" : showMoreContent ? showMoreContent : "Show more"), /*#__PURE__*/React__default.createElement("br", null), showMore && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, positive ? popupDetailedContentPositive ? popupDetailedContentPositive : "" : popupDetailedContentNegative ? popupDetailedContentNegative : "", /*#__PURE__*/React__default.createElement("br", null), /*#__PURE__*/React__default.createElement(Trans, {
        i18nKey: positive ? "console:develop.features.URLInput." + "withLabel.positive.detailedContent.1" : "console:develop.features.URLInput." + "withLabel.negative.detailedContent.1",
        tOptions: {
          tenantName: tenantDomain
        }
      }, "Therefore enabling CORS for this origin will allow you to access Identity Server APIs from the applications registered in the", /*#__PURE__*/React__default.createElement("strong", null, tenantDomain), " organization.")))),
      popupOptions: {
        basic: true,
        on: "hover"
      },
      labelColor: positive ? "green" : "red"
    }) : null;
  };
  /**
   * Resolves the error label.
   *
   * @returns the resolved error label.
   */


  const resolveValidationLabel = () => {
    if (!validURL && !changeUrl && emptyErrorMessage) {
      return /*#__PURE__*/React__default.createElement(Label, {
        "data-componentid": `${componentId}-empty-error-message`,
        className: "prompt",
        basic: true,
        color: "red",
        pointing: true
      }, emptyErrorMessage);
    }

    if (!validURL) {
      return /*#__PURE__*/React__default.createElement(Label, {
        "data-componentid": `${componentId}-valid-url-error-message`,
        basic: true,
        className: "prompt",
        color: "red",
        pointing: true
      }, validationErrorMsg);
    }

    if (duplicateURL) {
      return /*#__PURE__*/React__default.createElement(Label, {
        "data-componentid": `${componentId}-duplicate-error-message`,
        basic: true,
        className: "prompt",
        color: "red",
        pointing: true
      }, duplicateURLErrorMessage);
    }

    return customLabel;
  };
  /**
   * This function is a predicate that checks whether a given
   * URL is already allowed or not. It evaluates against the
   * list {@link allowedOrigins}
   *
   * In this function `origin` refers to the url containing
   * `<scheme>://<host>:<port>` you should not confuse origin
   * with host.
   *
   * Why check the scheme diff for origin?
   * {@link https://tools.ietf.org/html/rfc6454#section-3.2.1}
   * {@link https://stackoverflow.com/a/19542686}
   *
   * @param url - a URL i.e., https://myapp.io/x/y/z
   * @returns a boolean that indicates whether the origin is allowed or not
   */


  const isOriginIsKnownAndAllowed = url => {
    const urlComponents = URLUtils.urlComponents(url);

    if (!urlComponents) {
      return false;
    } // `origin` contains <scheme>://<host>:<port> (port if exists)


    const {
      origin: checkingOrigin
    } = urlComponents; // This is just a "make sure" operation that cleans out any attached
    // paths from the url. Also, if theres any trailing slashes it will
    // even out with the checkingOrigin vice versa. + We need it because
    // {@link Set} uses "same-value-zero equality" in has() operation.

    const normalizedOrigins = allowedOrigins === null || allowedOrigins === void 0 ? void 0 : allowedOrigins.map(url => {
      var _a;

      return (_a = URLUtils.urlComponents(url)) === null || _a === void 0 ? void 0 : _a.origin;
    });
    return new Set(normalizedOrigins !== null && normalizedOrigins !== void 0 ? normalizedOrigins : []).has(checkingOrigin);
  };

  const shouldShowAllowOriginAction = origin => {
    return labelEnabled && isAllowEnabled && !isOriginIsKnownAndAllowed(origin);
  };
  /**
   * Chip widget that contains the origin or href with a
   * following remove button.
   *
   * @param url - origin url
   */


  const urlTextWidget = url => {
    const {
      protocol,
      host
    } = URLUtils.urlComponents(url);
    let {
      pathWithoutProtocol
    } = URLUtils.urlComponents(url); // `pathWithoutProtocol` is taken from the `href` attribute returned when parsed using URL constructor.
    // It always appends a `/` if the URL doesn't have it. Need to get rid of this additional `/`.

    if (url.slice(-1) !== "/") {
      pathWithoutProtocol = pathWithoutProtocol.replace(/\/$/, "");
    }

    return /*#__PURE__*/React__default.createElement("span", null, !URLUtils.isHTTPS(url) && !onlyOrigin && !isCustom ? /*#__PURE__*/React__default.createElement(Popup, {
      trigger: /*#__PURE__*/React__default.createElement("span", {
        style: {
          color: "red",
          textDecoration: "line-through"
        }
      }, protocol),
      content: insecureURLDescription ? insecureURLDescription : "The entered URL is a non-TLS URL. Please proceed with caution.",
      position: "top left",
      size: "mini",
      hoverable: true,
      inverted: true,
      popper: /*#__PURE__*/React__default.createElement("div", {
        style: {
          filter: "none"
        }
      })
    }) : /*#__PURE__*/React__default.createElement("span", null, protocol), /*#__PURE__*/React__default.createElement("span", null, "://"), /*#__PURE__*/React__default.createElement("span", {
      className: "decoded-path"
    }, onlyOrigin ? decodeURIComponent(host) : decodeURIComponent(pathWithoutProtocol)));
  };
  /**
   * Added url remove button. In the click event it will send
   * the full url regardless of the type onlyOrigin.
   *
   * @param url - origin url
   */


  const urlRemoveButtonWidget = url => {
    return /*#__PURE__*/React__default.createElement(Icon, {
      name: "delete",
      onClick: () => removeValue(url),
      "data-componentid": `${componentId}-${url}-delete-button`,
      "data-testid": `${testId}-${url}-delete-button`
    });
  };

  const urlChipItemWidget = url => {
    const {
      origin
    } = URLUtils.urlComponents(url);
    return /*#__PURE__*/React__default.createElement(Grid.Row, {
      key: url,
      className: "urlComponentTagRow"
    }, /*#__PURE__*/React__default.createElement(Grid.Column, {
      mobile: 16,
      tablet: 16,
      computer: computerSize
    }, /*#__PURE__*/React__default.createElement("p", null, /*#__PURE__*/React__default.createElement(Label, {
      "data-componentid": `${componentId}-${url}`,
      "data-testid": `${testId}-${url}`
    }, urlTextWidget(url), !readOnly && urlRemoveButtonWidget(url)), "\u00A0", labelEnabled && resolveCORSStatusLabel(url), shouldShowAllowOriginAction(origin) && /*#__PURE__*/React__default.createElement("span", {
      className: "grey"
    }, "\u00A0", /*#__PURE__*/React__default.createElement("em", null, "CORS not allowed for origin of this URL.")), shouldShowAllowOriginAction(origin) && /*#__PURE__*/React__default.createElement(LinkButton, {
      className: "m-1 p-1 with-no-border orange",
      onClick: e => {
        onAllowOriginClick(e, origin);
      },
      "data-componentid": `${componentId}-${url}-allow-button`,
      "data-testid": `${testId}-${url}-allow-button`
    }, /*#__PURE__*/React__default.createElement("span", {
      style: {
        fontWeight: "bold"
      }
    }, "Allow")))));
  };

  return !hideEntireComponent && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Grid.Row, {
    columns: 1,
    className: "urlComponentLabelRow"
  }, /*#__PURE__*/React__default.createElement(Grid.Column, {
    mobile: 16,
    tablet: 16,
    computer: computerSize
  }, required ? /*#__PURE__*/React__default.createElement("div", {
    className: "required field"
  }, /*#__PURE__*/React__default.createElement("label", null, labelName)) : /*#__PURE__*/React__default.createElement("div", {
    className: "field"
  }, /*#__PURE__*/React__default.createElement("label", null, labelName)))), /*#__PURE__*/React__default.createElement(Grid.Row, {
    className: "urlComponentInputRow"
  }, /*#__PURE__*/React__default.createElement(Grid.Column, {
    mobile: 14,
    tablet: 14,
    computer: computerSize
  }, /*#__PURE__*/React__default.createElement(Input, {
    fluid: true,
    error: !(validURL && !duplicateURL),
    focus: keepFocus,
    value: changeUrl,
    onKeyDown: keyPressed,
    onChange: handleChange,
    onBlur: handleOnBlur,
    placeholder: placeholder,
    action: true,
    readOnly: readOnly,
    "data-componentid": componentId,
    "data-testid": testId
  }, /*#__PURE__*/React__default.createElement("input", {
    disabled: disabled ? disabled : false
  }), /*#__PURE__*/React__default.createElement(Popup, {
    disabled: readOnly,
    trigger: /*#__PURE__*/React__default.createElement(Button$1, {
      onClick: e => addFormButton(e),
      icon: "add",
      type: "button",
      disabled: readOnly || disabled || !allowEmptyValues && !changeUrl,
      "data-componentid": `${componentId}-add-button`,
      "data-testid": `${testId}-add-button`
    }),
    position: "top center",
    content: addURLTooltip,
    inverted: true,
    popper: /*#__PURE__*/React__default.createElement("div", {
      style: {
        filter: "none"
      }
    })
  })), resolveValidationLabel())), showPredictions && /*#__PURE__*/React__default.createElement(Grid.Row, {
    className: "urlComponentInputRow"
  }, /*#__PURE__*/React__default.createElement(Grid.Column, {
    mobile: 14,
    tablet: 14,
    computer: computerSize
  }, predictValue.length > 0 && predictValue.map(predict => {
    return /*#__PURE__*/React__default.createElement(Label, {
      key: predict,
      basic: true,
      color: "grey",
      onClick: () => onPredictClick(predict)
    }, predict);
  }))), urlState && urlState.split(",").map(url => {
    if (url !== "") {
      if (skipValidation || skipInternalValidation) {
        return /*#__PURE__*/React__default.createElement(Grid.Row, {
          key: url,
          className: "urlComponentTagRow"
        }, /*#__PURE__*/React__default.createElement(Grid.Column, {
          mobile: 16,
          tablet: 16,
          computer: computerSize
        }, /*#__PURE__*/React__default.createElement("p", null, /*#__PURE__*/React__default.createElement(Label, {
          "data-componentid": `${componentId}-${url}`,
          "data-testid": `${testId}-${url}`
        }, /*#__PURE__*/React__default.createElement("span", null, url), !readOnly && urlRemoveButtonWidget(url)))));
      }

      if (URLUtils.isURLValid(url, true)) {
        return urlChipItemWidget(url);
      }
    }
  }), hint && /*#__PURE__*/React__default.createElement(Grid.Row, {
    className: "urlComponentTagRow"
  }, /*#__PURE__*/React__default.createElement(Grid.Column, {
    mobile: 16,
    tablet: 16,
    computer: computerSize
  }, /*#__PURE__*/React__default.createElement(Hint, null, hint))));
};
/**
 * Default props for the URL input component.
 */

URLInput.defaultProps = {
  addOriginByDefault: false,
  addURLTooltip: "Add a URL",
  allowEmptyValues: false,
  "data-componentid": "url-input",
  "data-testid": "url-input",
  duplicateURLErrorMessage: "This URL is already added. Please select a different one.",
  isAllowEnabled: true,
  isCustom: false,
  labelEnabled: false,
  onlyOrigin: false,
  restrictSecondaryContent: true,
  showPredictions: true
};

/**
 * Password component
 * @param props - Props injected to the component.
 */

const Password = props => {
  const [isShow, setIsShow] = useState(false);

  const {
    label,
    value,
    error,
    width,
    type,
    placeholder,
    name,
    onBlur,
    onChange,
    showPassword,
    hidePassword,
    autoFocus,
    readOnly,
    disabled,
    required,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["label", "value", "error", "width", "type", "placeholder", "name", "onBlur", "onChange", "showPassword", "hidePassword", "autoFocus", "readOnly", "disabled", "required", "data-componentid", "data-testid"]);

  return /*#__PURE__*/React__default.createElement(Form.Input, Object.assign({
    label: label,
    value: value,
    error: error,
    type: isShow ? "text" : type,
    placeholder: placeholder,
    name: name,
    width: width,
    onBlur: onBlur,
    onChange: onChange,
    icon: /*#__PURE__*/React__default.createElement(Popup, {
      trigger: /*#__PURE__*/React__default.createElement(Icon, {
        name: !isShow ? "eye" : "eye slash",
        disabled: !value,
        link: true,
        onClick: () => {
          setIsShow(!isShow);
        }
      }),
      position: "top center",
      content: !isShow ? showPassword : hidePassword,
      inverted: true,
      popper: /*#__PURE__*/React__default.createElement("div", {
        style: {
          filter: "none"
        }
      })
    }),
    autoFocus: autoFocus || false,
    readOnly: readOnly,
    disabled: disabled,
    required: required,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest));
};
/**
 * Default props for the component.
 */

Password.defaultProps = {
  "data-componentid": "password-input-field"
};

var defineProperty$1 = objectDefineProperty.f;

var proxyAccessor$1 = function (Target, Source, key) {
  key in Target || defineProperty$1(Target, key, {
    configurable: true,
    get: function () { return Source[key]; },
    set: function (it) { Source[key] = it; }
  });
};

var DESCRIPTORS$2 = descriptors;
var global$3 = global$z;
var uncurryThis$4 = functionUncurryThis;
var isForced = isForced_1;
var inheritIfRequired = inheritIfRequired$2;
var createNonEnumerableProperty = createNonEnumerableProperty$9;
var getOwnPropertyNames = objectGetOwnPropertyNames.f;
var isPrototypeOf = objectIsPrototypeOf;
var isRegExp = isRegexp;
var toString$4 = toString$d;
var getRegExpFlags = regexpGetFlags;
var stickyHelpers = regexpStickyHelpers;
var proxyAccessor = proxyAccessor$1;
var defineBuiltIn$2 = defineBuiltIn$d;
var fails$2 = fails$z;
var hasOwn$2 = hasOwnProperty_1;
var enforceInternalState = internalState.enforce;
var setSpecies = setSpecies$4;
var wellKnownSymbol$2 = wellKnownSymbol$n;
var UNSUPPORTED_DOT_ALL = regexpUnsupportedDotAll;
var UNSUPPORTED_NCG = regexpUnsupportedNcg;

var MATCH = wellKnownSymbol$2('match');
var NativeRegExp = global$3.RegExp;
var RegExpPrototype = NativeRegExp.prototype;
var SyntaxError = global$3.SyntaxError;
var exec$2 = uncurryThis$4(RegExpPrototype.exec);
var charAt$3 = uncurryThis$4(''.charAt);
var replace$3 = uncurryThis$4(''.replace);
var stringIndexOf = uncurryThis$4(''.indexOf);
var stringSlice$2 = uncurryThis$4(''.slice);
// TODO: Use only proper RegExpIdentifierName
var IS_NCG = /^\?<[^\s\d!#%&*+<=>@^][^\s!#%&*+<=>@^]*>/;
var re1 = /a/g;
var re2 = /a/g;

// "new" should create a new object, old webkit bug
var CORRECT_NEW = new NativeRegExp(re1) !== re1;

var MISSED_STICKY = stickyHelpers.MISSED_STICKY;
var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;

var BASE_FORCED = DESCRIPTORS$2 &&
  (!CORRECT_NEW || MISSED_STICKY || UNSUPPORTED_DOT_ALL || UNSUPPORTED_NCG || fails$2(function () {
    re2[MATCH] = false;
    // RegExp constructor can alter flags and IsRegExp works correct with @@match
    return NativeRegExp(re1) != re1 || NativeRegExp(re2) == re2 || NativeRegExp(re1, 'i') != '/a/i';
  }));

var handleDotAll = function (string) {
  var length = string.length;
  var index = 0;
  var result = '';
  var brackets = false;
  var chr;
  for (; index <= length; index++) {
    chr = charAt$3(string, index);
    if (chr === '\\') {
      result += chr + charAt$3(string, ++index);
      continue;
    }
    if (!brackets && chr === '.') {
      result += '[\\s\\S]';
    } else {
      if (chr === '[') {
        brackets = true;
      } else if (chr === ']') {
        brackets = false;
      } result += chr;
    }
  } return result;
};

var handleNCG = function (string) {
  var length = string.length;
  var index = 0;
  var result = '';
  var named = [];
  var names = {};
  var brackets = false;
  var ncg = false;
  var groupid = 0;
  var groupname = '';
  var chr;
  for (; index <= length; index++) {
    chr = charAt$3(string, index);
    if (chr === '\\') {
      chr = chr + charAt$3(string, ++index);
    } else if (chr === ']') {
      brackets = false;
    } else if (!brackets) switch (true) {
      case chr === '[':
        brackets = true;
        break;
      case chr === '(':
        if (exec$2(IS_NCG, stringSlice$2(string, index + 1))) {
          index += 2;
          ncg = true;
        }
        result += chr;
        groupid++;
        continue;
      case chr === '>' && ncg:
        if (groupname === '' || hasOwn$2(names, groupname)) {
          throw new SyntaxError('Invalid capture group name');
        }
        names[groupname] = true;
        named[named.length] = [groupname, groupid];
        ncg = false;
        groupname = '';
        continue;
    }
    if (ncg) groupname += chr;
    else result += chr;
  } return [result, named];
};

// `RegExp` constructor
// https://tc39.es/ecma262/#sec-regexp-constructor
if (isForced('RegExp', BASE_FORCED)) {
  var RegExpWrapper = function RegExp(pattern, flags) {
    var thisIsRegExp = isPrototypeOf(RegExpPrototype, this);
    var patternIsRegExp = isRegExp(pattern);
    var flagsAreUndefined = flags === undefined;
    var groups = [];
    var rawPattern = pattern;
    var rawFlags, dotAll, sticky, handled, result, state;

    if (!thisIsRegExp && patternIsRegExp && flagsAreUndefined && pattern.constructor === RegExpWrapper) {
      return pattern;
    }

    if (patternIsRegExp || isPrototypeOf(RegExpPrototype, pattern)) {
      pattern = pattern.source;
      if (flagsAreUndefined) flags = getRegExpFlags(rawPattern);
    }

    pattern = pattern === undefined ? '' : toString$4(pattern);
    flags = flags === undefined ? '' : toString$4(flags);
    rawPattern = pattern;

    if (UNSUPPORTED_DOT_ALL && 'dotAll' in re1) {
      dotAll = !!flags && stringIndexOf(flags, 's') > -1;
      if (dotAll) flags = replace$3(flags, /s/g, '');
    }

    rawFlags = flags;

    if (MISSED_STICKY && 'sticky' in re1) {
      sticky = !!flags && stringIndexOf(flags, 'y') > -1;
      if (sticky && UNSUPPORTED_Y) flags = replace$3(flags, /y/g, '');
    }

    if (UNSUPPORTED_NCG) {
      handled = handleNCG(pattern);
      pattern = handled[0];
      groups = handled[1];
    }

    result = inheritIfRequired(NativeRegExp(pattern, flags), thisIsRegExp ? this : RegExpPrototype, RegExpWrapper);

    if (dotAll || sticky || groups.length) {
      state = enforceInternalState(result);
      if (dotAll) {
        state.dotAll = true;
        state.raw = RegExpWrapper(handleDotAll(pattern), rawFlags);
      }
      if (sticky) state.sticky = true;
      if (groups.length) state.groups = groups;
    }

    if (pattern !== rawPattern) try {
      // fails in old engines, but we have no alternatives for unsupported regex syntax
      createNonEnumerableProperty(result, 'source', rawPattern === '' ? '(?:)' : rawPattern);
    } catch (error) { /* empty */ }

    return result;
  };

  for (var keys = getOwnPropertyNames(NativeRegExp), index = 0; keys.length > index;) {
    proxyAccessor(RegExpWrapper, NativeRegExp, keys[index++]);
  }

  RegExpPrototype.constructor = RegExpWrapper;
  RegExpWrapper.prototype = RegExpPrototype;
  defineBuiltIn$2(global$3, 'RegExp', RegExpWrapper, { constructor: true });
}

// https://tc39.es/ecma262/#sec-get-regexp-@@species
setSpecies('RegExp');

var call$3 = functionCall;
var fixRegExpWellKnownSymbolLogic$1 = fixRegexpWellKnownSymbolLogic;
var anObject$3 = anObject$k;
var isNullOrUndefined$1 = isNullOrUndefined$8;
var toLength = toLength$8;
var toString$3 = toString$d;
var requireObjectCoercible$1 = requireObjectCoercible$9;
var getMethod$1 = getMethod$7;
var advanceStringIndex = advanceStringIndex$3;
var regExpExec$1 = regexpExecAbstract;

// @@match logic
fixRegExpWellKnownSymbolLogic$1('match', function (MATCH, nativeMatch, maybeCallNative) {
  return [
    // `String.prototype.match` method
    // https://tc39.es/ecma262/#sec-string.prototype.match
    function match(regexp) {
      var O = requireObjectCoercible$1(this);
      var matcher = isNullOrUndefined$1(regexp) ? undefined : getMethod$1(regexp, MATCH);
      return matcher ? call$3(matcher, regexp, O) : new RegExp(regexp)[MATCH](toString$3(O));
    },
    // `RegExp.prototype[@@match]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@match
    function (string) {
      var rx = anObject$3(this);
      var S = toString$3(string);
      var res = maybeCallNative(nativeMatch, rx, S);

      if (res.done) return res.value;

      if (!rx.global) return regExpExec$1(rx, S);

      var fullUnicode = rx.unicode;
      rx.lastIndex = 0;
      var A = [];
      var n = 0;
      var result;
      while ((result = regExpExec$1(rx, S)) !== null) {
        var matchStr = toString$3(result[0]);
        A[n] = matchStr;
        if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
        n++;
      }
      return n === 0 ? null : A;
    }
  ];
});

/**
 * Inline edit input field component.
 *
 * @param props - props required for the inline edit component.
 * @returns inline edit input component
 */

const InlineEditInput = props => {
  const {
    errorHandler,
    text,
    textPrefix,
    textPostfix,
    inputPlaceholderText,
    validation,
    onChangesSaved,
    onEdit,
    maxLength,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const [editMode, setEditMode] = useState(false);
  const [prevText, setPrevText] = useState(text);
  const [textValue, setTextValue] = useState(text);
  const [regExValidation, setRegExValidation] = useState();
  const [fieldError, setFieldError] = useState(false);
  useEffect(() => {
    setTextValue(text);
    setPrevText(text);
  }, [text]);
  useEffect(() => {
    if (validation) {
      const regEx = new RegExp(validation);
      setRegExValidation(regEx);
    }
  }, [validation]);
  return editMode ? /*#__PURE__*/React__default.createElement(Grid, {
    verticalAlign: "middle"
  }, /*#__PURE__*/React__default.createElement(Grid.Row, {
    columns: 2
  }, /*#__PURE__*/React__default.createElement(GridColumn, {
    width: 12
  }, /*#__PURE__*/React__default.createElement(Input, {
    fluid: true,
    size: "mini",
    placeholder: inputPlaceholderText,
    value: textValue,
    error: fieldError,
    maxLength: maxLength,
    onChange: (event, data) => {
      setTextValue(data.value.trim());
    },
    "data-componentid": `${componentId}-input`,
    "data-testid": `${testId}-input`
  })), /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: 4
  }, /*#__PURE__*/React__default.createElement(Popup, {
    trigger: /*#__PURE__*/React__default.createElement(Icon, {
      className: "mr-3",
      name: "check",
      link: true,
      onClick: () => {
        if (textValue === "" || validation && !textValue.match(regExValidation)) {
          setFieldError(true);

          if (errorHandler) {
            errorHandler(true);
          }

          return;
        }

        onEdit(false);
        setEditMode(false);
        onChangesSaved(textValue);
      }
    }),
    content: "Save Changes",
    position: "top center",
    inverted: true
  }), /*#__PURE__*/React__default.createElement(Popup, {
    trigger: /*#__PURE__*/React__default.createElement(Icon, {
      name: "cancel",
      link: true,
      onClick: () => {
        setEditMode(false);
        onEdit(false);
        errorHandler(false);
        setTextValue(prevText);
      }
    }),
    content: "Cancel Changes",
    position: "top center",
    inverted: true
  })))) : /*#__PURE__*/React__default.createElement(Grid, {
    columns: "equal",
    verticalAlign: "middle"
  }, /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(GridColumn, {
    width: "16"
  }, text && text !== "" && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement("span", {
    className: "mr-3"
  }, textPrefix && textPrefix, /*#__PURE__*/React__default.createElement("b", null, text && text), textPostfix && textPostfix), /*#__PURE__*/React__default.createElement(Popup, {
    trigger: /*#__PURE__*/React__default.createElement(Icon, {
      className: "mr-3",
      name: "pencil",
      link: true,
      onClick: () => {
        setEditMode(true);
        onEdit(true);
      }
    }),
    content: "Edit changes",
    position: "top center",
    inverted: true
  })))));
};
/**
 * Default props for the component.
 */

InlineEditInput.defaultProps = {
  "data-componentid": "inline-edit-field"
};

/**
 * Search box with filter labels.
 *
 * @param props - Props injected to the component.
 *
 * @returns the search box with filter labels.
 */

const SearchWithFilterLabels = props => {
  const {
    className,
    filterLabels,
    onFilter,
    onSearch,
    isLoading,
    icon,
    placeholder,
    searchInput,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["className", "filterLabels", "onFilter", "onSearch", "isLoading", "icon", "placeholder", "searchInput", "data-componentid", "data-testid"]);

  const [searchQuery, setSearchQuery] = useState(null);
  const [selectedFilterLabels, setSelectedFilterLabels] = useState([]);
  const classes = classNames("search-with-filter-labels", className);
  /**
   * Handles the Search input onchange.
   *
   * @param e - Change event.
   * @param value - Input value.
   */

  const handleQuerySearch = (e, {
    value
  }) => {
    setSearchQuery(value);
    onSearch(value, selectedFilterLabels);
  };
  /**
   * Handles filters on click.
   *
   * @param newFilter - Newly selected label.
   */


  const handleFilter = newFilter => {
    let selectedFilters = [];

    if (selectedFilterLabels.includes(newFilter)) {
      selectedFilters = selectedFilterLabels.filter(selectedLabel => selectedLabel !== newFilter);
    } else {
      selectedFilters = [...selectedFilterLabels, newFilter];
    }

    setSelectedFilterLabels(selectedFilters);
    onFilter(searchQuery, selectedFilters);
  };

  const numberOfPlaceholderCards = 4;
  /**
   * Renders the loading state placeholder cards.
   *
   * @returns Loading Placeholder cards.
   */

  const getPlaceholderCards = () => {
    const placeholders = [];

    for (let i = 0; i < numberOfPlaceholderCards; i++) {
      placeholders.push(
      /*#__PURE__*/
      //TODO: Add placeholder style classes.
      React__default.createElement(Card, {
        style: {
          borderRadius: "50px",
          boxShadow: "none",
          width: "65px"
        }
      }, /*#__PURE__*/React__default.createElement(Placeholder, {
        className: "testPlaceholder",
        style: {
          borderRadius: "10px"
        }
      }, /*#__PURE__*/React__default.createElement(Placeholder.Image, {
        style: {
          borderRadius: "10px!important",
          height: "25px"
        }
      }))));
    }

    return placeholders;
  };

  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, searchInput ? /*#__PURE__*/React__default.createElement("div", {
    className: "search-input-wrapper"
  }, searchInput) : /*#__PURE__*/React__default.createElement("div", {
    className: "search-input-wrapper"
  }, /*#__PURE__*/React__default.createElement(Input, Object.assign({
    fluid: true,
    loading: isLoading,
    icon: icon !== null && icon !== void 0 ? icon : /*#__PURE__*/React__default.createElement(Icon, {
      name: "search"
    }),
    value: searchQuery,
    iconPosition: "left",
    onChange: handleQuerySearch,
    placeholder: placeholder
  }, rest))), isLoading ? /*#__PURE__*/React__default.createElement(Card.Group, {
    style: {
      borderRadius: "50px"
    }
  }, getPlaceholderCards()) : filterLabels && Array.isArray(filterLabels) && filterLabels.length > 0 && /*#__PURE__*/React__default.createElement(Label.Group, null, filterLabels.map((label, index) => {
    const isSelected = selectedFilterLabels.includes(label);
    return /*#__PURE__*/React__default.createElement(Label, {
      basic: true,
      key: index,
      as: "a",
      className: `filter-label ${isSelected ? "active" : ""}`,
      onClick: () => handleFilter(label)
    }, label, isSelected && /*#__PURE__*/React__default.createElement(Icon, {
      name: "check"
    }));
  })));
};
/**
 * Default proptypes for the component.
 */

SearchWithFilterLabels.defaultProps = {
  "data-componentid": "search-with-filters",
  "data-testid": "search-with-filters",
  placeholder: "Search"
};

/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Link component.
 *
 * @param props - Props injected to the component.
 * @returns the link component.
 */

const Link = props => {
  const {
    children,
    className,
    external,
    icon,
    iconPosition,
    link,
    onClick,
    target,
    ["data-componentid"]: componentId
  } = props;
  const classes = classNames("link pointing", {
    external
  }, className);

  if (!link) {
    return null;
  }

  return /*#__PURE__*/React__default.createElement("a", {
    href: link,
    target: target,
    rel: "noopener noreferrer",
    className: classes,
    onClick: e => {
      // If `onClick` is not defined, going further will break the behaviour of anchor.
      if (!onClick) {
        return;
      }

      e.preventDefault();
      onClick(e);
    },
    "data-componentid": componentId
  }, external && icon && iconPosition === "left" && /*#__PURE__*/React__default.createElement(Icon, {
    className: "mr-1",
    name: icon
  }), children, external && icon && iconPosition === "right" && /*#__PURE__*/React__default.createElement(Icon, {
    className: "ml-1",
    name: icon
  }));
};
/**
 * Prop types for the component.
 */

Link.defaultProps = {
  "data-componentid": "link",
  external: true,
  icon: "external",
  iconPosition: "right",
  link: "#",
  target: "_blank"
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Resource list header component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the resource list header component.
 */

const ResourceListHeader = props => {
  const {
    children,
    className,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("resource-list-header", className);
  return /*#__PURE__*/React__default.createElement(List.Item, {
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, React__default.Children.count(children) > 0 && /*#__PURE__*/React__default.createElement(Grid, null, /*#__PURE__*/React__default.createElement(Grid.Row, {
    columns: React__default.Children.count(children)
  }, React__default.Children.map(children, (heading, index) => /*#__PURE__*/React__default.createElement(React__default.Fragment, null, heading.props.offset && /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: heading.props.offset
  }), /*#__PURE__*/React__default.createElement(Grid.Column, {
    key: index,
    width: heading.props.width
  }, /*#__PURE__*/React__default.createElement(List.Header, {
    "data-componentid": `${componentId}-heading`,
    "data-testid": `${testId}-heading`
  }, heading)))))));
};
/**
 * Default props for resource list header component.
 */

ResourceListHeader.defaultProps = {
  "data-componentid": "resource-list-header",
  "data-testid": "resource-list-header"
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Resource list header cell component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the resource list header cell component.
 */

const ResourceListHeaderCell = props => {
  const {
    children,
    className,
    floated,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("resource-list-header-cell", className);
  return /*#__PURE__*/React__default.createElement(List.Content, {
    className: classes,
    floated: floated,
    "data-componentid": componentId,
    "data-testid": testId
  }, children);
};
/**
 * Default props for resource list header component.
 */

ResourceListHeaderCell.defaultProps = {
  "data-componentid": "resource-list-header-cell",
  "data-testid": "resource-list-header-cell"
};

/**
 * Resource list item component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the resource list item component.
 */

const ResourceListItem = props => {
  const {
    actions,
    actionsColumnWidth,
    actionsFloated,
    avatar,
    className,
    descriptionColumnWidth,
    itemDescription,
    itemHeader,
    metaContent,
    metaColumnWidth,
    popupHeader,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["actions", "actionsColumnWidth", "actionsFloated", "avatar", "className", "descriptionColumnWidth", "itemDescription", "itemHeader", "metaContent", "metaColumnWidth", "popupHeader", "data-componentid", "data-testid"]);

  const classes = classNames("resource-list-item", className);
  return /*#__PURE__*/React__default.createElement(List.Item, Object.assign({
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), /*#__PURE__*/React__default.createElement(Grid, null, /*#__PURE__*/React__default.createElement(Grid.Row, {
    columns: metaContent instanceof Array ? metaContent.length + 2 : itemHeader || itemDescription ? 3 : 2
  }, itemDescription || itemHeader ? /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: descriptionColumnWidth,
    className: "resource-item-column"
  }, avatar, /*#__PURE__*/React__default.createElement(List.Content, null, /*#__PURE__*/React__default.createElement(List.Header, {
    className: "list-item-name",
    "data-componentid": `${componentId}-heading`,
    "data-testid": `${testId}-heading`
  }, itemHeader), itemDescription && /*#__PURE__*/React__default.createElement(List.Description, {
    className: "list-item-description",
    "data-componentid": `${componentId}-description`,
    "data-testid": `${testId}-description`
  }, itemDescription))) : null, metaContent instanceof Array ? metaContent === null || metaContent === void 0 ? void 0 : metaContent.map((content, index) => {
    return /*#__PURE__*/React__default.createElement(Grid.Column, {
      key: index,
      width: metaColumnWidth,
      verticalAlign: "middle"
    }, /*#__PURE__*/React__default.createElement(List.Content, {
      "data-componentid": `${componentId}-meta-content-${index}`,
      "data-testid": `${testId}-meta-content-${index}`
    }, content));
  }) : /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: metaColumnWidth,
    verticalAlign: "middle"
  }, /*#__PURE__*/React__default.createElement(List.Content, {
    "data-componentid": `${componentId}-meta-content`,
    "data-testid": `${testId}-meta-content`
  }, metaContent)), /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: actionsColumnWidth
  }, /*#__PURE__*/React__default.createElement(List.Content, {
    floated: actionsFloated,
    className: "list-item-action-panel",
    "data-componentid": `${componentId}-actions`,
    "data-testid": `${testId}-actions`
  }, actions && actions.length && actions.length > 0 ? actions.map((action, index) => !action.hidden && /*#__PURE__*/React__default.createElement("div", {
    className: "list-item-action",
    key: index
  }, action.type === "dropdown" ? /*#__PURE__*/React__default.createElement(Dropdown, {
    direction: "left",
    icon: null,
    trigger: /*#__PURE__*/React__default.createElement(Popup, {
      disabled: action.disabled,
      trigger: /*#__PURE__*/React__default.createElement(Icon, {
        "data-componentid": action["data-componentid"],
        "data-testid": action["data-testid"],
        link: true,
        className: "list-icon",
        disabled: action.disabled,
        size: "small",
        color: "grey",
        name: action.icon,
        onClick: action.onClick
      }),
      position: "top center",
      content: action.popupText,
      inverted: true
    }),
    options: action.subActions,
    "data-componentid": `${componentId}-action-${action.type}-${index}`,
    "data-testid": `${testId}-action-${action.type}-${index}`
  }) : /*#__PURE__*/React__default.createElement(Popup, {
    header: popupHeader,
    trigger: /*#__PURE__*/React__default.createElement("div", null, /*#__PURE__*/React__default.createElement(Icon, {
      "data-componentid": action["data-componentid"],
      "data-testid": action["data-testid"],
      link: true,
      className: "list-icon",
      disabled: action.disabled,
      size: "small",
      color: "grey",
      name: action.icon,
      onClick: action.disabled ? e => {
        e === null || e === void 0 ? void 0 : e.preventDefault();
      } : action.onClick
    })),
    position: "top center",
    content: action.popupText,
    inverted: true
  }))) : null)))));
};
/**
 * Default proptypes for the resource list item component.
 */

ResourceListItem.defaultProps = {
  actionsColumnWidth: 5,
  actionsFloated: "left",
  "data-componentid": "resource-list-item",
  "data-testid": "resource-list-item",
  descriptionColumnWidth: 7,
  metaColumnWidth: 4,
  popupHeader: null
};

/**
 * Resource list component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the resource list component.
 */

const ResourceList = props => {
  const {
    celled,
    children,
    className,
    fill,
    isLoading,
    loadingStateOptions,
    transparent,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["celled", "children", "className", "fill", "isLoading", "loadingStateOptions", "transparent", "data-componentid", "data-testid"]);

  const classes = classNames("resource-list", {
    transparent,
    [typeof fill === "boolean" ? "fill-default" : `fill-${fill}`]: fill
  }, className);
  /**
   * Shows the loading state placeholder rows.
   *
   * @returns an array of placeholders
   */

  const showPlaceholders = () => {
    const placeholders = [];

    for (let i = 0; i < loadingStateOptions.count; i++) {
      placeholders.push( /*#__PURE__*/React__default.createElement(ResourceListItem, {
        key: i,
        avatar: /*#__PURE__*/React__default.createElement(Avatar, {
          image: /*#__PURE__*/React__default.createElement(Placeholder, {
            style: {
              height: 35,
              width: 35
            }
          }, /*#__PURE__*/React__default.createElement(Placeholder.Image, null)),
          isLoading: true,
          shape: loadingStateOptions.imageType,
          size: "mini",
          floated: "left"
        }),
        itemHeader: /*#__PURE__*/React__default.createElement(Placeholder, {
          style: {
            width: "300px"
          }
        }, /*#__PURE__*/React__default.createElement(Placeholder.Header, null, /*#__PURE__*/React__default.createElement(Placeholder.Line, null), /*#__PURE__*/React__default.createElement(Placeholder.Line, null))),
        "data-componentid": `${componentId}-loading-placeholder`,
        "data-testid": `${testId}-loading-placeholder`
      }));
    }

    return placeholders;
  };

  return /*#__PURE__*/React__default.createElement(List, Object.assign({
    className: classes,
    divided: celled,
    relaxed: "very",
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), isLoading ? showPlaceholders() : children);
};
/**
 * Default props for the component.
 */

ResourceList.defaultProps = {
  celled: true,
  "data-componentid": "resource-list",
  "data-testid": "resource-list",
  isLoading: false,
  loadingStateOptions: {
    count: 10,
    imageType: "square"
  },
  transparent: true
};
ResourceList.Header = ResourceListHeader;
ResourceList.HeaderCell = ResourceListHeaderCell;
ResourceList.Item = ResourceListItem;

/**
 * Content loader component.
 *
 * @param props - Props injected to the global loader component.
 *
 * @returns the content loader component.
 */

const ContentLoader = props => {
  const {
    className,
    dimmer,
    text,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["className", "dimmer", "text", "data-componentid", "data-testid"]);

  const classes = classNames("loaders content-loader", className);
  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    "data-componentid": `${componentId}-wrapper`,
    "data-testid": `${testId}-wrapper`
  }, /*#__PURE__*/React__default.createElement(Dimmer, {
    active: dimmer,
    "data-componentid": `${componentId}-dimmer`,
    "data-testid": `${testId}-dimmer`,
    inverted: true
  }, /*#__PURE__*/React__default.createElement(Loader, Object.assign({}, rest, {
    "data-componentid": componentId,
    "data-testid": testId,
    inverted: true
  }), text)));
};
/**
 * Content loader component default props.
 */

ContentLoader.defaultProps = {
  "data-componentid": "content-loader",
  "data-testid": "content-loader",
  dimmer: true,
  text: null
};

/**
 * Top loading bar component component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the top loading bar component.
 */

const TopLoadingBar = props => {
  const {
    height,
    visibility,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const [loaderRef, setLoaderRef] = useState(null);
  useEffect(() => {
    if (!loaderRef) {
      return;
    }

    if (visibility) {
      loaderRef.continuousStart();
      return;
    }

    loaderRef.complete();
  }, [visibility]);
  return /*#__PURE__*/React__default.createElement(LoadingBar, {
    className: "app-top-loading-bar",
    onRef: ref => setLoaderRef(ref),
    height: height,
    "data-componentid": componentId,
    "data-testid": testId
  });
};
/**
 * Top loading bar component default props.
 */

TopLoadingBar.defaultProps = {
  "data-componentid": "top-loading-bar",
  "data-testid": "top-loading-bar",
  height: 3,
  visibility: true
};

/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * MessageInfo component.
 *
 * @deprecated Use the new `Message` component from `@wso2is/react-components` instead.
 * @param props - Props injected in to the messageInfo component.
 * @returns Message info component.
 */

const MessageInfo = props => {
  const {
    header,
    content,
    ["data-componentid"]: componentid,
    ["data-testid"]: testId
  } = props;

  const generateContent = () => {
    return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Divider, {
      hidden: true,
      className: "message-info-text"
    }), /*#__PURE__*/React__default.createElement("div", null, content));
  };

  return /*#__PURE__*/React__default.createElement(Message$1, {
    info: true,
    header: /*#__PURE__*/React__default.createElement(Header$1, {
      as: "h4"
    }, /*#__PURE__*/React__default.createElement(Header$1.Content, null, /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Icon, {
      name: "info circle"
    }), header))),
    content: generateContent(),
    "data-componentid": componentid,
    "data-testid": testId
  });
};
/**
 * Default proptypes for the message info component.
 */

MessageInfo.defaultProps = {
  content: null,
  "data-componentid": "message-info",
  "data-testid": "message-info",
  header: null
};

/**
 * Message with icon component.
 *
 * @param props - Props injected in to the message with icon component.
 * @returns Message with icon component.
 */

const Message = props => {
  const {
    className,
    type,
    header,
    content,
    visible,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["className", "type", "header", "content", "visible", "data-componentid", "data-testid"]);

  const classes = classNames(`${type}-message-with-icon`, className);

  const resolveMessageIcon = () => {
    switch (type) {
      case "info":
        return /*#__PURE__*/React__default.createElement(Icon, {
          name: "info circle"
        });

      case "warning":
        return /*#__PURE__*/React__default.createElement(Icon, {
          name: "warning circle"
        });

      case "success":
        return /*#__PURE__*/React__default.createElement(Icon, {
          name: "check circle"
        });

      case "error":
        return /*#__PURE__*/React__default.createElement(Icon, {
          name: "times circle"
        });

      default:
        return /*#__PURE__*/React__default.createElement(Icon, {
          name: "info circle"
        });
    }
  };

  return /*#__PURE__*/React__default.createElement(Message$1, Object.assign({
    className: classes,
    visible: visible,
    header: header ? /*#__PURE__*/React__default.createElement(Header$1, {
      as: "h5",
      className: !(props === null || props === void 0 ? void 0 : props.icon) ? "mb-3" : null
    }, /*#__PURE__*/React__default.createElement(Header$1.Content, null, /*#__PURE__*/React__default.createElement(React__default.Fragment, null, !(props === null || props === void 0 ? void 0 : props.icon) ? resolveMessageIcon() : null, header))) : undefined,
    content: header ? /*#__PURE__*/React__default.createElement("div", null, content) : /*#__PURE__*/React__default.createElement("div", null, resolveMessageIcon(), content),
    "data-componentid": componentId,
    "data-testid": testId,
    info: type === "info",
    warning: type === "warning",
    error: type === "error",
    success: type === "success"
  }, rest));
};
/**
 * Default proptypes for the message with icon component.
 */

Message.defaultProps = {
  "data-componentid": "message-info",
  "data-testid": "message-info",
  visible: true
};

/**
 * Confirmation modal content component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the confirmation modal content component.
 */

const ConfirmationModalContent = props => {
  const {
    children,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["children", "data-componentid", "data-testid"]);

  return /*#__PURE__*/React__default.createElement(Modal.Content, Object.assign({
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), children);
};
/**
 * Default proptypes for the confirmation modal content component.
 */

ConfirmationModalContent.defaultProps = {
  "data-componentid": "confirmation-modal-content",
  "data-testid": "confirmation-modal-content"
};

/**
 * Confirmation modal description component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the description component of the confirmation modal.
 */

const ConfirmationModalDescription = props => {
  const {
    children,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["children", "data-componentid", "data-testid"]);

  return /*#__PURE__*/React__default.createElement(Modal.Description, Object.assign({
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), children);
};
/**
 * Default proptypes for the confirmation modal description component.
 */

ConfirmationModalDescription.defaultProps = {
  "data-componentid": "confirmation-modal-description",
  "data-testid": "confirmation-modal-description"
};

/**
 * Confirmation modal header component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the header of the confirmation modal.
 */

const ConfirmationModalHeader = props => {
  const {
    children,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["children", "data-componentid", "data-testid"]);

  return /*#__PURE__*/React__default.createElement(Modal.Header, Object.assign({
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), children);
};
/**
 * Default proptypes for the confirmation modal header component.
 */

ConfirmationModalHeader.defaultProps = {
  "data-componentid": "confirmation-modal-header",
  "data-testid": "confirmation-modal-header"
};

/**
 * Confirmation modal message component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the confirmation modal message component.
 */

const ConfirmationModalMessage = props => {
  const {
    attached,
    children,
    className,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["attached", "children", "className", "data-componentid", "data-testid"]);

  const classes = classNames("confirmation-modal-message", {
    attached
  }, className);
  return /*#__PURE__*/React__default.createElement(Message$1, Object.assign({
    "data-testid": testId,
    "data-componentid": componentId
  }, rest, {
    className: classes
  }), children);
};
/**
 * Default proptypes for the confirmation modal message component.
 */

ConfirmationModalMessage.defaultProps = {
  "data-componentid": "confirmation-modal-message",
  "data-testid": "confirmation-modal-message"
};

/**
 * Confirmation modal component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Confirmation Modal Component.
 */

const ConfirmationModal = props => {
  const {
    animated,
    assertion,
    assertionHint,
    assertionType,
    children,
    className,
    type,
    primaryAction,
    primaryActionFluid,
    secondaryAction,
    onPrimaryActionClick,
    onSecondaryActionClick,
    skipAssertion,
    textAlign,
    primaryActionLoading,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId,
    open
  } = props,
        rest = __rest(props, ["animated", "assertion", "assertionHint", "assertionType", "children", "className", "type", "primaryAction", "primaryActionFluid", "secondaryAction", "onPrimaryActionClick", "onSecondaryActionClick", "skipAssertion", "textAlign", "primaryActionLoading", "data-componentid", "data-testid", "open"]);

  const [assertionInput, setAssertionInput] = useState("");
  const [confirmed, setConfirmed] = useState(false);
  const [assertionDisabled, setAssertionDisabled] = useState(false);
  useEffect(() => {
    if (open) {
      setAssertionInput("");
      setConfirmed(false);
      setAssertionDisabled(false);
    }
  }, [open]);
  /**
  * Called when the assertion input changes.
  */

  useEffect(() => {
    setConfirmed(assertionInput === assertion);
  }, [assertionInput]);
  const classes = classNames("confirmation-modal", {
    [textAlign === "justified" ? "justified" : `${textAlign} aligned`]: textAlign
  }, className);
  /**
  * Handler for the secondary button click event.
  */

  const handleSecondaryActionClick = e => {
    onSecondaryActionClick(e);
  };
  /**
  * Handler for the primary button click event.
  */


  const handlePrimaryActionClick = e => {
    setAssertionDisabled(true);
    onPrimaryActionClick(e);
  };
  /**
  * Handler for the enter key press down.
  */


  const handleKeyDown = (k, e) => {
    if (k.key === "Enter" && confirmed) {
      onPrimaryActionClick(e);
    }
  };
  /**
  * Resolves the animated icon.
  *
  * @param type - Type of the modal.
  *
  * @returns Animated Icon.
  */


  const resolveIcon = type => {
    if (type === "positive") {
      return /*#__PURE__*/React__default.createElement("div", {
        className: "svg-box",
        "data-componentid": `${componentId}-${type}-animated-icon`,
        "data-testid": `${testId}-${type}-animated-icon`
      }, /*#__PURE__*/React__default.createElement("svg", {
        className: "circular positive-stroke"
      }, /*#__PURE__*/React__default.createElement("circle", {
        className: "path",
        cx: "75",
        cy: "75",
        r: "50",
        fill: "none",
        strokeWidth: "5",
        strokeMiterlimit: "10"
      })), /*#__PURE__*/React__default.createElement("svg", {
        className: "positive-icon positive-stroke"
      }, /*#__PURE__*/React__default.createElement("g", {
        transform: "matrix(0.79961,8.65821e-32,8.39584e-32,0.79961,-489.57,-205.679)"
      }, /*#__PURE__*/React__default.createElement("path", {
        className: "positive-icon__check",
        fill: "none",
        d: "M616.306,283.025L634.087,300.805L673.361,261.53"
      }))));
    } else if (type === "negative") {
      return /*#__PURE__*/React__default.createElement("div", {
        className: "svg-box",
        "data-componentid": `${componentId}-${type}-animated-icon`,
        "data-testid": `${testId}-${type}-animated-icon`
      }, /*#__PURE__*/React__default.createElement("svg", {
        className: "circular negative-stroke"
      }, /*#__PURE__*/React__default.createElement("circle", {
        className: "path",
        cx: "75",
        cy: "75",
        r: "50",
        fill: "none",
        strokeWidth: "5",
        strokeMiterlimit: "10"
      })), /*#__PURE__*/React__default.createElement("svg", {
        className: "negative-icon negative-stroke"
      }, /*#__PURE__*/React__default.createElement("g", {
        transform: "matrix(0.79961,8.65821e-32,8.39584e-32,0.79961,-502.652,-204.518)"
      }, /*#__PURE__*/React__default.createElement("path", {
        className: "first-line",
        d: "M634.087,300.805L673.361,261.53",
        fill: "none"
      })), /*#__PURE__*/React__default.createElement("g", {
        transform: "matrix(-1.28587e-16,-0.79961,0.79961,-1.28587e-16,-204.752,543.031)"
      }, /*#__PURE__*/React__default.createElement("path", {
        className: "second-line",
        d: "M634.087,300.805L673.361,261.53"
      }))));
    } else if (type === "warning") {
      return /*#__PURE__*/React__default.createElement("div", {
        className: "svg-box",
        "data-componentid": `${componentId}-${type}-animated-icon`,
        "data-testid": `${testId}-${type}-animated-icon`
      }, /*#__PURE__*/React__default.createElement("svg", {
        className: "circular warning-stroke"
      }, /*#__PURE__*/React__default.createElement("circle", {
        className: "path",
        cx: "75",
        cy: "75",
        r: "50",
        fill: "none",
        strokeWidth: "5",
        strokeMiterlimit: "10"
      })), /*#__PURE__*/React__default.createElement("svg", {
        className: "warning-icon warning-stroke"
      }, /*#__PURE__*/React__default.createElement("g", {
        transform: "matrix(1,0,0,1,-615.516,-257.346)"
      }, /*#__PURE__*/React__default.createElement("g", {
        transform: "matrix(0.56541,-0.56541,0.56541,0.56541,93.7153,495.69)"
      }, /*#__PURE__*/React__default.createElement("path", {
        className: "line",
        d: "M634.087,300.805L673.361,261.53",
        fill: "none"
      })), /*#__PURE__*/React__default.createElement("g", {
        transform: "matrix(2.27612,-2.46519e-32,0,2.27612,-792.339,-404.147)"
      }, /*#__PURE__*/React__default.createElement("circle", {
        className: "dot",
        cx: "621.52",
        cy: "316.126",
        r: "1.318"
      })))));
    } else {
      return /*#__PURE__*/React__default.createElement(Icon, {
        className: "modal-icon",
        name: "info circle",
        size: "huge",
        color: "blue",
        "data-componentid": `${componentId}-info-animated-icon`,
        "data-testid": `${testId}-info-animated-icon`
      });
    }
  };
  /**
  * Resolves the assertion input.
  *
  * @param type - Type of the assertion.
  *
  * @returns Assertion Input.
  */


  const resolveAssertionInput = type => {
    if (type === "input") {
      return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, assertionHint && typeof assertionHint === "string" ? /*#__PURE__*/React__default.createElement("p", null, assertionHint) : assertionHint, /*#__PURE__*/React__default.createElement(Input, {
        disabled: assertionDisabled,
        "data-componentid": `${componentId}-assertion-input`,
        "data-testid": `${testId}-assertion-input`,
        onChange: e => {
          var _a;

          return setAssertionInput((_a = e.target) === null || _a === void 0 ? void 0 : _a.value);
        },
        onKeyDown: handleKeyDown,
        value: assertionInput,
        fluid: true
      }));
    } else if (type === "checkbox") {
      if (typeof assertionHint !== "string") {
        throw new Error("Unsupported hint format. Checkboxes can only have hints of type string.");
      }

      return /*#__PURE__*/React__default.createElement(Checkbox, {
        disabled: assertionDisabled,
        label: assertionHint,
        checked: confirmed,
        onChange: () => setConfirmed(!confirmed),
        "data-componentid": `${componentId}-assertion-checkbox`,
        "data-testid": `${testId}-assertion-checkbox`
      });
    }

    throw new Error("Unsupported assertion input type. Only `string` and `checkbox` is supported.");
  };

  return /*#__PURE__*/React__default.createElement(Modal, Object.assign({
    "data-componentid": componentId,
    "data-testid": testId,
    open: open
  }, rest, {
    className: classes
  }), animated && /*#__PURE__*/React__default.createElement("div", {
    className: "animated-icon"
  }, resolveIcon(type)), children, assertionType && /*#__PURE__*/React__default.createElement(Modal.Content, {
    className: "no-margin-top"
  }, resolveAssertionInput(assertionType)), (primaryAction || secondaryAction) && /*#__PURE__*/React__default.createElement(Modal.Actions, null, secondaryAction && onSecondaryActionClick && /*#__PURE__*/React__default.createElement(LinkButton, {
    "data-componentid": componentId + "-cancel-button",
    "data-testid": testId + "-cancel-button",
    positive: type === "positive",
    negative: type === "negative",
    warning: type === "warning",
    info: type === "info",
    onClick: handleSecondaryActionClick
  }, secondaryAction), primaryAction && onPrimaryActionClick && /*#__PURE__*/React__default.createElement(Button$1, {
    loading: primaryActionLoading,
    "data-componentid": componentId + "-confirm-button",
    "data-testid": testId + "-confirm-button",
    className: `${type} ${primaryActionFluid ? "fluid" : ""}`,
    disabled: primaryActionLoading || (!skipAssertion ? !(!assertionType || confirmed) : false),
    onClick: handlePrimaryActionClick,
    fluid: primaryActionFluid
  }, primaryAction)));
};
/**
 * Default proptypes for the confirmation modal component.
 */

ConfirmationModal.defaultProps = {
  "data-componentid": "confirmation-modal",
  "data-testid": "confirmation-modal",
  dimmer: "blurring",
  primaryActionLoading: false,
  size: "tiny",
  textAlign: "left"
};
ConfirmationModal.Header = ConfirmationModalHeader;
ConfirmationModal.Content = ConfirmationModalContent;
ConfirmationModal.Description = ConfirmationModalDescription;
ConfirmationModal.Message = ConfirmationModalMessage;

const GRAVATAR_IMAGE_MIN_SIZE = 80;
const SystemGeneratedAvatars = new Map([["Initials", "system_gen_i_1"]]);
/**
 * Different Avatar types.
 */

var AvatarTypes;

(function (AvatarTypes) {
  AvatarTypes["SYSTEM_GENERATED"] = "SYSTEM_GENERATED";
  AvatarTypes["GRAVATAR"] = "GRAVATAR";
  AvatarTypes["URL"] = "URL";
})(AvatarTypes || (AvatarTypes = {}));
/**
 * Edit Avatar modal.
 *
 * @param props - Props injected to the component.
 * @returns Edit Avatar modal component.
 */


const EditAvatarModal = props => {
  const {
    cancelButtonText,
    className,
    emails,
    heading,
    imageUrl,
    name,
    onCancel,
    onSubmit,
    showHostedURLOption,
    showOptionTitle,
    submitButtonText,
    isSubmitting,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId,
    translations
  } = props,
        rest = __rest(props, ["cancelButtonText", "className", "emails", "heading", "imageUrl", "name", "onCancel", "onSubmit", "showHostedURLOption", "showOptionTitle", "submitButtonText", "isSubmitting", "data-componentid", "data-testid", "translations"]);

  const [selectedGravatarEmail, setSelectedGravatarEmail] = useState(undefined);
  const [selectedGravatarSize, setSelectedGravatarSize] = useState(undefined);
  const [isInitialGravatarRequestLoading, setIsInitialGravatarRequestLoading] = useState(false);
  const [isGravatarQualified, setIsGravatarQualified] = useState(undefined);
  const [gravatarURLs, setGravatarURLs] = useState(undefined);
  const [selectedAvatarType, setSelectedAvatarType] = useState(undefined);
  const [hostedURL, setHostedURL] = useState(undefined);
  const [isGravatarUrl, setIsGravatarUrl] = useState(false);
  const [hostedURLError, setHostedURLError] = useState(undefined);
  const [outputURL, setOutputURL] = useState(undefined);
  const [isHostedURLValid, setIsHostedURLValid] = useState(undefined);
  const [isHostedURLValidationRequestLoading, setIsHostedURLValidationRequestLoading] = useState(false);
  const classes = classNames("edit-avatar-modal", className);
  /**
   * Triggered on component mount.
   */

  useEffect(() => {
    setSelectedGravatarSize(GRAVATAR_IMAGE_MIN_SIZE);
  }, []);
  /**
   * Init selected gravatar email once `emails` prop is valid.
   */

  useEffect(() => {
    if (!emails || !Array.isArray(emails) || emails.length < 1) {
      return;
    }

    setSelectedGravatarEmail(emails[0]);
  }, [emails]);
  /**
   * Triggered when selected gravatar email changes.
   */

  useEffect(() => {
    if (!selectedGravatarEmail) {
      return;
    }

    setIsInitialGravatarRequestLoading(true);
    getGravatarImage(selectedGravatarEmail).then(() => {
      setIsGravatarQualified(true);
    }).catch(() => {
      setIsGravatarQualified(false);
    }).finally(() => {
      setIsInitialGravatarRequestLoading(false);
    });
  }, [selectedGravatarEmail]);
  /**
   * Triggered when selected gravatar email or `isGravatarQualified` flag chages.
   */

  useEffect(() => {
    if (!selectedGravatarEmail || isGravatarQualified === undefined) {
      return;
    }

    const getURL = (fallback, forceDefault = true) => ProfileUtils.buildGravatarURL(selectedGravatarEmail, selectedGravatarSize, null, fallback, forceDefault);

    const urls = new Map();

    if (isGravatarQualified) {
      urls.set("Gravatar", getURL("default", false));
    }

    urls.set("Retro", getURL("retro")).set("Default", getURL("default")).set("Person", getURL("mp")).set("Identicon", getURL("identicon")).set("Monster", getURL("monsterid")).set("Wavatar", getURL("wavatar")).set("Robot", getURL("robohash"));
    setGravatarURLs(urls);
  }, [selectedGravatarEmail, isGravatarQualified]);
  /**
   * Set the Avatar types based on imageUrl.
   */

  useEffect(() => {
    if (imageUrl) {
      if (isGravatarUrl) {
        setOutputURL(imageUrl);
        setSelectedAvatarType(AvatarTypes.GRAVATAR);
      } else {
        setHostedURL(imageUrl);
        setSelectedAvatarType(AvatarTypes.URL);
      }
    } else {
      setSelectedAvatarType(AvatarTypes.SYSTEM_GENERATED);
    }
  }, [imageUrl, isGravatarUrl]);
  /**
   * Check the type of imageUrl.
   */

  useEffect(() => {
    if (gravatarURLs && imageUrl) {
      for (const [, value] of gravatarURLs) {
        if (imageUrl.localeCompare(value) == 0) {
          setIsGravatarUrl(true);
          break;
        }
      }
    }
  }, [gravatarURLs]);
  /**
   * Handles selected gravatar email change.
   *
   * @param e - Event.
   * @param data - Dropdown data.
   */

  const handleGravatarEmailDropdownChange = (e, data) => {
    var _a;

    const {
      value
    } = data;
    setSelectedGravatarEmail(value); // Once the email selection is changed, switch the selected type to `Gravatar`.

    setSelectedAvatarType(AvatarTypes.GRAVATAR); // Set the default option.

    if (gravatarURLs) {
      setOutputURL((_a = gravatarURLs.get("Gravatar")) !== null && _a !== void 0 ? _a : gravatarURLs.get("Retro"));
    }
  };
  /**
   * Render the different gravatar options.
   *
   * @returns Gravatar options.
   */


  const renderGravatarOptions = () => {
    if (!gravatarURLs) {
      return;
    }

    const elemArray = [];

    for (const [key, value] of gravatarURLs) {
      elemArray.push( /*#__PURE__*/React__default.createElement(SelectionCard, {
        id: value,
        size: "x100",
        showText: showOptionTitle,
        header: key,
        image: /*#__PURE__*/React__default.createElement(UserAvatar, {
          size: "little",
          image: value
        }),
        selected: outputURL === value,
        onClick: handleGravatarOptionChange
      }));
    }

    return elemArray;
  };
  /**
   * Handle selected avatar type change.
   *
   * @param e - Event.
   * @param data - Checkbox data.
   */


  const handleSelectedAvatarTypeChange = (e, data) => {
    const {
      value
    } = data;
    setSelectedAvatarType(value);
    resolveOutputURLsOnAvatarTypeChange(value);
    resolveHostedURLFieldErrors(value, isHostedURLValid);
  };
  /**
   * Resolves the default option when the avatar type changes.
   *
   * @param avatarType - Avatar Type.
   */


  const resolveOutputURLsOnAvatarTypeChange = avatarType => {
    var _a;

    if (avatarType === AvatarTypes.SYSTEM_GENERATED) {
      setOutputURL(SystemGeneratedAvatars.get("Initials"));
      return;
    }

    if (avatarType === AvatarTypes.GRAVATAR && gravatarURLs) {
      setOutputURL((_a = gravatarURLs.get("Gravatar")) !== null && _a !== void 0 ? _a : gravatarURLs.get("Retro"));
      return;
    }

    setOutputURL(hostedURL);
  };
  /**
   * Handles gravatar option change,
   *
   * @param e - Event.
   * @param data - Card data.
   */


  const handleGravatarOptionChange = (e, data) => {
    const {
      id
    } = data;
    setOutputURL(id);
    setSelectedAvatarType(AvatarTypes.GRAVATAR);
  };
  /**
   * Handles system generated avatar option change.
   *
   * @param e - Event.
   * @param data - Card data.
   */


  const handleSystemGeneratedAvatarChange = (e, data) => {
    const {
      id
    } = data;
    setOutputURL(id);
    setSelectedAvatarType(AvatarTypes.SYSTEM_GENERATED);
  };
  /**
   * Handle Hosted URL field on change event.
   *
   * @param e - Event.
   * @param value - Input value.
   */


  const handleHostedURLFieldOnChange = (e, {
    value
  }) => {
    setHostedURL(value);
    setOutputURL(value);
    validateHostedURL(value);
  };
  /**
   * Validates the Hosted Image URL.
   *
   * @param url - Image URL.
   */


  const validateHostedURL = url => {
    const isImageValid = isValid => {
      setIsHostedURLValid(isValid);
      resolveHostedURLFieldErrors(selectedAvatarType, isValid);
      setIsHostedURLValidationRequestLoading(false);
    };

    setIsHostedURLValidationRequestLoading(true);
    ImageUtils.isValidImageURL(url, isImageValid);
  };
  /**
   * Handles focus event of hosted URL input field.
   */


  const handleHostedURLFieldOnFocus = () => {
    setSelectedAvatarType(AvatarTypes.URL);
  };
  /**
   * Handles modal submit.
   *
   * @param e - Event.
   */


  const handleModalSubmit = e => {
    onSubmit(e, outputURL === SystemGeneratedAvatars.get("Initials") ? "" : outputURL);
  };
  /**
   * Resolves the errors of the hosted image URL field.
   *
   * @param avatarType - Selected avatar type.
   * @param isValid - Is avatar valid.
   */


  const resolveHostedURLFieldErrors = (avatarType, isValid) => {
    if (isValid === true) {
      setHostedURLError(null);
      return;
    }

    if (avatarType !== AvatarTypes.URL) {
      setHostedURLError(null);
      return;
    }

    if (avatarType === AvatarTypes.URL && isValid === false) {
      setHostedURLError({
        content: translations.hostedAvatar.input.errors.invalid.content,
        pointing: "above"
      });
      return;
    }
  };
  /**
   * Resolves gravatar options validation message.
   *
   * @returns Gravatar options message.
   */


  const resolveGravatarOptionsMessage = () => {
    if (isInitialGravatarRequestLoading || isGravatarQualified) {
      return null;
    }

    return /*#__PURE__*/React__default.createElement(Message$1, {
      warning: true,
      visible: true,
      size: "tiny"
    }, /*#__PURE__*/React__default.createElement(Message$1.Header, null, translations.gravatar.errors.noAssociation.header), /*#__PURE__*/React__default.createElement(Message$1.Content, null, "It seems like the selected email is not registered on Gravatar. Sign up for a Gravatar account by visiting \u00A0", /*#__PURE__*/React__default.createElement("a", {
      href: "https://www.gravatar.com"
    }, "Gravatar Official Website"), "\u00A0or use one of the following."));
  };
  /**
   * Resolves hosted URL validation message.
   *
   * @returns Hosted URL message component.
   */


  const resolveHostedURLMessage = () => {
    if (isHostedURLValidationRequestLoading || hostedURLError || !hostedURL) {
      return null;
    }

    if (URLUtils.isHttpUrl(hostedURL)) {
      return /*#__PURE__*/React__default.createElement(Message$1, {
        warning: true,
        visible: true,
        size: "tiny",
        header: translations.hostedAvatar.input.errors.http.header,
        content: translations.hostedAvatar.input.errors.http.content
      });
    }

    if (URLUtils.isDataUrl(hostedURL)) {
      return /*#__PURE__*/React__default.createElement(Message$1, {
        warning: true,
        visible: true,
        size: "tiny",
        header: translations.hostedAvatar.input.warnings.dataURL.header,
        content: translations.hostedAvatar.input.warnings.dataURL.content
      });
    }

    return null;
  };

  return /*#__PURE__*/React__default.createElement(Modal, Object.assign({
    "data-componentid": componentId,
    "data-testid": testId,
    className: classes,
    closeOnDimmerClick: false
  }, rest), /*#__PURE__*/React__default.createElement(Modal.Header, null, heading), /*#__PURE__*/React__default.createElement(Modal.Content, null, /*#__PURE__*/React__default.createElement(Form, null, /*#__PURE__*/React__default.createElement(Grid, null, name && /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: 16
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "avatar-from-system"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "mb-3"
  }, /*#__PURE__*/React__default.createElement(Form.Field, null, /*#__PURE__*/React__default.createElement(Checkbox, {
    radio: true,
    value: AvatarTypes.SYSTEM_GENERATED,
    label: translations.systemGenAvatars.heading,
    checked: selectedAvatarType === AvatarTypes.SYSTEM_GENERATED,
    onChange: handleSelectedAvatarTypeChange
  }))), /*#__PURE__*/React__default.createElement(Card.Group, {
    className: "avatar-from-system-card-group"
  }, /*#__PURE__*/React__default.createElement(SelectionCard, {
    id: SystemGeneratedAvatars.get("Initials"),
    size: "x100",
    showText: showOptionTitle,
    header: translations.systemGenAvatars.types.initials,
    image: /*#__PURE__*/React__default.createElement(UserAvatar, {
      size: "little",
      name: name
    }),
    selected: outputURL === SystemGeneratedAvatars.get("Initials"),
    onClick: handleSystemGeneratedAvatarChange
  }))))), selectedGravatarEmail && /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: 16
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "avatar-from-gravatar"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "mb-3"
  }, /*#__PURE__*/React__default.createElement(Form.Field, null, /*#__PURE__*/React__default.createElement(Checkbox, {
    radio: true,
    value: AvatarTypes.GRAVATAR,
    label: /*#__PURE__*/React__default.createElement("label", null, /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement("span", null, translations.gravatar.heading), /*#__PURE__*/React__default.createElement(Dropdown, {
      text: selectedGravatarEmail,
      options: emails.map((email, index) => {
        return {
          key: index,
          text: email,
          value: email
        };
      }),
      onChange: handleGravatarEmailDropdownChange
    }))),
    checked: selectedAvatarType === AvatarTypes.GRAVATAR,
    onChange: handleSelectedAvatarTypeChange
  }))), !isInitialGravatarRequestLoading ? /*#__PURE__*/React__default.createElement(React__default.Fragment, null, resolveGravatarOptionsMessage(), /*#__PURE__*/React__default.createElement(Card.Group, {
    className: "avatar-from-gravatar-card-group"
  }, renderGravatarOptions())) : /*#__PURE__*/React__default.createElement("div", {
    className: "avatar-types-loader-container"
  }, /*#__PURE__*/React__default.createElement(ContentLoader, null))))), showHostedURLOption && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Grid.Row, {
    className: "pb-0"
  }, /*#__PURE__*/React__default.createElement(Grid.Column, {
    width: 16
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "avatar-from-url-label"
  }, /*#__PURE__*/React__default.createElement(Form.Field, null, /*#__PURE__*/React__default.createElement(Checkbox, {
    radio: true,
    value: AvatarTypes.URL,
    label: translations.hostedAvatar.heading,
    checked: selectedAvatarType === AvatarTypes.URL,
    onChange: handleSelectedAvatarTypeChange
  })), resolveHostedURLMessage()))), /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: 10,
    tablet: 10,
    mobile: 16
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "avatar-from-url-field"
  }, /*#__PURE__*/React__default.createElement(Form.Field, {
    fluid: true,
    className: "hosted-url-input",
    control: Input,
    placeholder: translations.hostedAvatar.input.placeholder,
    onFocus: handleHostedURLFieldOnFocus,
    onChange: handleHostedURLFieldOnChange,
    error: hostedURLError,
    loading: isHostedURLValidationRequestLoading,
    value: hostedURL
  }), hostedURL && isHostedURLValid && /*#__PURE__*/React__default.createElement(UserAvatar, {
    spaced: "left",
    size: "mini",
    isLoading: isHostedURLValidationRequestLoading,
    image: hostedURL
  })), /*#__PURE__*/React__default.createElement(Hint, null, translations.hostedAvatar.input.hint))))))), /*#__PURE__*/React__default.createElement(Modal.Actions, null, /*#__PURE__*/React__default.createElement(LinkButton, {
    onClick: onCancel
  }, cancelButtonText), /*#__PURE__*/React__default.createElement(PrimaryButton, {
    disabled: isInitialGravatarRequestLoading || isHostedURLValidationRequestLoading || !outputURL || selectedAvatarType === AvatarTypes.URL && !isHostedURLValid || selectedAvatarType === AvatarTypes.URL && hostedURL === imageUrl || isSubmitting,
    loading: isSubmitting,
    onClick: handleModalSubmit
  }, submitButtonText)));
};
/**
 * Default props for the component.
 */

EditAvatarModal.defaultProps = {
  cancelButtonText: "Cancel",
  "data-componentid": "edit-avatar-modal",
  "data-testid": "edit-avatar-modal",
  dimmer: "blurring",
  heading: "Update profile picture",
  showHostedURLOption: false,
  showOptionTitle: false,
  submitButtonText: "Save",
  translations: {
    gravatar: {
      errors: {
        noAssociation: {
          content: "It seems like the selected email is not registered on Gravatar. Sign up for a " + "Gravatar account by visiting Gravatar official website or use one of the following.",
          header: "No matching Gravatar image found!"
        }
      },
      heading: "Gravatar based on "
    },
    hostedAvatar: {
      heading: "Hosted Image",
      input: {
        errors: {
          http: {
            content: "The selected URL points to an insecure image served over HTTP. " + "Please proceed with caution.",
            header: "Insecure Content!"
          },
          invalid: {
            content: "Please enter a valid image URL",
            pointing: "above"
          }
        },
        hint: "Enter a valid image URL which is hosted on a third party location.",
        placeholder: "Enter URL for the image.",
        warnings: {
          dataURL: {
            content: "Using Data URLs with large character count might result in database issues. " + "Proceed with caution.",
            header: "Double check the entered Data URL!"
          }
        }
      }
    },
    systemGenAvatars: {
      heading: "System generated avatar",
      types: {
        initials: "Initials"
      }
    }
  }
};

/**
 * Session Timeout modal.
 *
 * @param props - Props injected to the component.
 * @returns the session timeout modal.
 */

const SessionTimeoutModal = props => {
  const {
    description,
    heading,
    sessionTimeOut,
    onSecondaryActionClick,
    onPrimaryActionClick,
    primaryButtonText,
    secondaryButtonText,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["description", "heading", "sessionTimeOut", "onSecondaryActionClick", "onPrimaryActionClick", "primaryButtonText", "secondaryButtonText", "data-componentid", "data-testid"]);

  return /*#__PURE__*/React__default.createElement(ConfirmationModal, Object.assign({
    animated: true,
    type: "warning",
    textAlign: "center",
    primaryAction: primaryButtonText,
    secondaryAction: sessionTimeOut ? null : secondaryButtonText,
    onSecondaryActionClick: sessionTimeOut ? null : onSecondaryActionClick,
    onPrimaryActionClick: onPrimaryActionClick,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest), /*#__PURE__*/React__default.createElement(ConfirmationModal.Content, {
    "data-componentid": `${componentId}-content`
  }, /*#__PURE__*/React__default.createElement(Heading, {
    as: "h3",
    "data-componentid": `${componentId}-heading`
  }, heading), /*#__PURE__*/React__default.createElement("p", {
    "data-componentid": `${componentId}-description`
  }, description)));
};
/**
 * Default props for the component.
 */

SessionTimeoutModal.defaultProps = {
  "data-componentid": "session-timeout-modal",
  "data-testid": "session-timeout-modal",
  description: "You will be logged out of the current session due to inactivity." + "\nPlease choose Stay logged in if you would like to continue the session.",
  heading: "You will be logged out!",
  primaryButtonText: "Stay logged in",
  secondaryButtonText: "Logout"
};

/**
 * This component listens to the `network_error_event` Event and pops up a modal
 * when this Event is dispatched.
 *
 * This is used to show an error message when an API call fails due to a `401` error
 * or a network-timeout error.
 *
 * @param props - The props passed into the component.
 *
 * @returns the component that pops up a modal when there is a network error.
 */

const NetworkErrorModal = props => {
  const {
    heading,
    description,
    primaryActionText,
    primaryAction,
    ["data-componentid"]: componentId
  } = props;
  const [showModal, setShowModal] = useState(false);
  /**
   * Show modal.
   */

  const showErrorModal = () => {
    setShowModal(true);
  };
  /**
   * Called on mount and unmount to add/remove the event listener.
   */


  useEffect(() => {
    addEventListener(AppConstants.NETWORK_ERROR_EVENT, showErrorModal);
    return () => {
      removeEventListener(AppConstants.NETWORK_ERROR_EVENT, showErrorModal);
    };
  }, []);
  return /*#__PURE__*/React__default.createElement(ConfirmationModal, {
    animated: true,
    type: "warning",
    textAlign: "center",
    primaryAction: primaryActionText,
    onPrimaryActionClick: () => {
      primaryAction();
    },
    "data-componentid": componentId,
    "data-testid": "network-error-modal",
    open: showModal
  }, /*#__PURE__*/React__default.createElement(ConfirmationModal.Content, null, /*#__PURE__*/React__default.createElement(Heading, {
    as: "h3"
  }, heading), /*#__PURE__*/React__default.createElement("p", null, description)));
};
/**
 * Default props for the component.
 */

NetworkErrorModal.defaultProps = {
  "data-componentid": "network-error-modal"
};

/**
 * This component listens to the `chunk load error` and pops up a modal
 * when this error is occurred.
 */

const ChunkErrorModal = props => {
  const {
    heading,
    description,
    primaryActionText,
    ["data-componentid"]: componentId
  } = props;
  const [showModal, setShowModal] = useState(false);
  /**
   * Called on mount and unmount to add/remove the event listener.
   */

  useEffect(() => {
    addEventListener(AppConstants.CHUNK_LOAD_ERROR_EVENT, () => setShowModal(true));
    return () => {
      removeEventListener(AppConstants.CHUNK_LOAD_ERROR_EVENT, () => setShowModal(true));
    };
  }, []);
  return /*#__PURE__*/React__default.createElement(ConfirmationModal, {
    animated: true,
    type: "warning",
    textAlign: "center",
    primaryAction: primaryActionText,
    onPrimaryActionClick: () => {
      location.reload();
    },
    "data-componentid": "chunk-error-modal",
    "data-testid": componentId,
    open: showModal
  }, /*#__PURE__*/React__default.createElement(ConfirmationModal.Content, null, /*#__PURE__*/React__default.createElement(Heading, {
    as: "h3"
  }, heading), /*#__PURE__*/React__default.createElement("p", null, description)));
};
/**
 * Default proptypes for the component.
 */

ChunkErrorModal.defaultProps = {
  "data-componentid": "chunk-error-modal"
};

/**
 * Page header component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the page header component
 */

const PageHeader = props => {
  const {
    action,
    actionColumnWidth,
    backButton,
    bottomMargin,
    className,
    description,
    headingColumnWidth,
    image,
    isLoading,
    imageSpaced,
    loadingStateOptions,
    showBottomDivider,
    title,
    titleAs,
    titleTextAlign,
    pageHeaderMaxWidth,
    truncateContent,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const wrapperClasses = classNames("page-header-wrapper", {
    ["with-image"]: image
  }, className);
  const innerClasses = classNames("page-header-inner", {
    ["with-image"]: image
  });
  const backButtonClasses = classNames("back-button", {
    "fluid": isLoading
  });
  const headerContentClasses = classNames("page-header", {
    "ellipsis": truncateContent,
    "no-max-width": !pageHeaderMaxWidth
  });
  const subHeaderContentClasses = classNames("sub-header", {
    "ellipsis": truncateContent
  });
  const headingContent = /*#__PURE__*/React__default.createElement("div", {
    className: innerClasses
  }, image && /*#__PURE__*/React__default.createElement(GenericIcon, {
    icon: isLoading ? /*#__PURE__*/React__default.createElement("div", {
      className: "fluid"
    }, /*#__PURE__*/React__default.createElement(Placeholder, {
      style: (loadingStateOptions === null || loadingStateOptions === void 0 ? void 0 : loadingStateOptions.imageType) === "circular" ? {
        borderRadius: "100%",
        height: 85,
        width: 85
      } : {
        height: 85,
        width: 85
      }
    }, /*#__PURE__*/React__default.createElement(Placeholder.Image, {
      square: true
    }))) : image,
    size: "tiny",
    transparent: true,
    spaced: typeof imageSpaced === "boolean" && !imageSpaced ? null : "right",
    "data-componentid": `${componentId}-image`,
    "data-testid": `${testId}-image`
  }), isLoading ? /*#__PURE__*/React__default.createElement(Header$1, {
    className: "page-header ellipsis",
    as: titleAs,
    textAlign: titleTextAlign,
    "data-componentid": `${componentId}-text-wrapper-loading`,
    "data-testid": `${testId}-text-wrapper-loading`
  }, /*#__PURE__*/React__default.createElement("div", {
    style: {
      width: "250px"
    }
  }, /*#__PURE__*/React__default.createElement(Placeholder, {
    fluid: true
  }, /*#__PURE__*/React__default.createElement(Placeholder.Header, null, /*#__PURE__*/React__default.createElement(Placeholder.Line, null), description && /*#__PURE__*/React__default.createElement(Placeholder.Line, null))))) : /*#__PURE__*/React__default.createElement(Header$1, {
    className: headerContentClasses,
    as: titleAs,
    textAlign: titleTextAlign,
    "data-componentid": `${componentId}-text-wrapper`,
    "data-testid": `${testId}-text-wrapper`
  }, /*#__PURE__*/React__default.createElement("span", {
    "data-componentid": `${componentId}-title`,
    "data-testid": `${testId}-title`
  }, title ? title : /*#__PURE__*/React__default.createElement("div", {
    style: {
      width: "400px"
    }
  }, /*#__PURE__*/React__default.createElement(Placeholder, {
    fluid: true
  }, /*#__PURE__*/React__default.createElement(Placeholder.Header, null, /*#__PURE__*/React__default.createElement(Placeholder.Line, null))))), description && /*#__PURE__*/React__default.createElement(Header$1.Subheader, {
    className: subHeaderContentClasses,
    "data-componentid": `${componentId}-sub-title`,
    "data-testid": `${testId}-sub-title`
  }, description)));
  return title || description ? /*#__PURE__*/React__default.createElement("div", {
    className: wrapperClasses,
    "data-componentid": componentId,
    "data-testid": testId
  }, backButton && backButton.text && (isLoading ? /*#__PURE__*/React__default.createElement("div", {
    className: backButtonClasses
  }, /*#__PURE__*/React__default.createElement(Placeholder, null, /*#__PURE__*/React__default.createElement(Placeholder.Line, {
    length: "short"
  }))) : /*#__PURE__*/React__default.createElement("div", {
    "data-componentid": backButton["data-componentid"],
    "data-testid": backButton["data-testid"],
    className: backButtonClasses,
    onClick: backButton.onClick
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: "arrow left"
  }), backButton.text)), action ? /*#__PURE__*/React__default.createElement(Grid, null, /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: headingColumnWidth,
    className: "heading-wrapper"
  }, headingContent), /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: actionColumnWidth,
    className: "action-wrapper"
  }, action && /*#__PURE__*/React__default.createElement("div", {
    className: "floated right action"
  }, action)))) : headingContent, bottomMargin && /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), showBottomDivider && /*#__PURE__*/React__default.createElement(Divider, null)) : null;
};
/**
 * Default proptypes for the page header component.
 */

PageHeader.defaultProps = {
  actionColumnWidth: 6,
  bottomMargin: true,
  "data-componentid": "page-header",
  "data-testid": "page-header",
  headingColumnWidth: 10,
  imageSpaced: "right",
  showBottomDivider: false,
  titleAs: "h1"
};

/**
 * Pagination component.
 *
 * @param props - Props injected in to the component.
 *
 * @returns the pagination component
 */

const Pagination = props => {
  const [activePage, setActivePage] = useState(1);
  const init = useRef(true);

  const {
    className,
    disableNextButton,
    disablePreviousButton,
    hidden,
    itemsPerPageDropdownLabel,
    itemsPerPageDropdownLowerLimit,
    itemsPerPageDropdownMultiple,
    itemsPerPageDropdownUpperLimit,
    minimal,
    nextButtonText,
    onItemsPerPageDropdownChange,
    onPageChange,
    previousButtonText,
    resetPagination,
    showItemsPerPageDropdown,
    showPagesOnMinimalMode,
    totalPages,
    activePage: activePageProp,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["className", "disableNextButton", "disablePreviousButton", "hidden", "itemsPerPageDropdownLabel", "itemsPerPageDropdownLowerLimit", "itemsPerPageDropdownMultiple", "itemsPerPageDropdownUpperLimit", "minimal", "nextButtonText", "onItemsPerPageDropdownChange", "onPageChange", "previousButtonText", "resetPagination", "showItemsPerPageDropdown", "showPagesOnMinimalMode", "totalPages", "activePage", "data-componentid", "data-testid"]);

  const classes = classNames("pagination-bar", {
    hidden
  }, className);
  useEffect(() => {
    if (activePageProp === undefined || activePageProp === null) {
      return;
    }

    setActivePage(activePageProp);
  }, [activePageProp]);
  useEffect(() => {
    if (init.current) {
      init.current = false;
    } else {
      setActivePage(1);
    }
  }, [resetPagination]);

  const generatePageCountDropdownOptions = () => {
    const options = [];

    for (let i = itemsPerPageDropdownLowerLimit; i <= itemsPerPageDropdownUpperLimit; i += itemsPerPageDropdownMultiple) {
      options.push({
        key: i,
        text: i,
        value: i
      });
    }

    return options;
  };
  /**
   * Reset the pagination page if the page limit changes.
   */


  const resetAll = () => {
    setActivePage(1);
    onPageChange(null, {
      activePage: 1,
      totalPages: totalPages
    });
  };
  /**
   * This is called when page change occurs.
   *
   * @param event - Mouse event.
   * @param data - Semantic pagination props.
   */


  const pageChangeHandler = (event, data) => {
    setActivePage(parseInt(data.activePage.toString()));
    onPageChange(event, data);
  };
  /**
   * Renders the content based on the mode.
   * @returns the child content
   */


  const renderChildren = () => {
    const ItemsPerPageDropdown = showItemsPerPageDropdown && /*#__PURE__*/React__default.createElement("label", {
      className: "page-limit-label"
    }, itemsPerPageDropdownLabel, /*#__PURE__*/React__default.createElement(Dropdown, {
      "data-componentid": `${componentId}-items-per-page-dropdown`,
      "data-testid": `${testId}-items-per-page-dropdown`,
      className: "labeled horizontal right page-limit-dropdown",
      compact: true,
      defaultValue: itemsPerPageDropdownLowerLimit,
      options: generatePageCountDropdownOptions(),
      onChange: (event, data) => {
        resetAll();
        onItemsPerPageDropdownChange(event, data);
      },
      selection: true
    }));

    if (minimal) {
      return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, ItemsPerPageDropdown, /*#__PURE__*/React__default.createElement(Pagination$1, Object.assign({}, rest, {
        totalPages: totalPages,
        className: "list-pagination",
        "data-componentid": `${componentId}-steps`,
        "data-testid": `${testId}-steps`,
        activePage: activePage,
        onPageChange: pageChangeHandler,
        ellipsisItem: null,
        firstItem: null,
        lastItem: null,
        pageItem: showPagesOnMinimalMode ? undefined : null,
        prevItem: {
          "aria-label": "Previous Page",
          content: previousButtonText,
          disabled: disablePreviousButton !== undefined ? disablePreviousButton : activePage === 1
        },
        nextItem: {
          "aria-label": "Next Page",
          content: nextButtonText,
          disabled: disableNextButton !== undefined ? disableNextButton : activePage === totalPages
        }
      })));
    }

    return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, ItemsPerPageDropdown, /*#__PURE__*/React__default.createElement(Pagination$1, Object.assign({}, rest, {
      totalPages: totalPages,
      className: "list-pagination",
      "data-componentid": `${componentId}-steps`,
      "data-testid": `${testId}-steps`,
      activePage: activePage,
      onPageChange: pageChangeHandler
    })));
  };

  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, renderChildren());
};
/**
 * Prop types for the Pagination component.
 */

Pagination.defaultProps = {
  "data-componentid": "pagination",
  "data-testid": "pagination",
  float: "right",
  itemsPerPageDropdownLabel: "Items per page",
  itemsPerPageDropdownLowerLimit: 10,
  itemsPerPageDropdownMultiple: 10,
  itemsPerPageDropdownUpperLimit: 50,
  minimal: false,
  nextButtonText: "Next",
  previousButtonText: "Previous",
  showItemsPerPageDropdown: false,
  showPagesOnMinimalMode: false
};

/**
 * Copyright (c) 2022, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Converts a RGB | RGBA color to hex.
 *
 * @example
 *  rgbToHex(65, 131, 196);
 *  // Returns '4183c4'
 * @param value - The value to be converted.
 * @returns a convered HEX value.
 */

const rgbToHex = value => {
  return tinycolor(value).toHex8String();
};

/**
 * Color Picker Component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the color picker React component.
 */

const ColorPicker = props => {
  const {
    className,
    ["data-componentid"]: componentId,
    picker: Picker,
    show: controlledShow,
    popup
  } = props,
        rest = __rest(props, ["className", "data-componentid", "picker", "show", "popup"]);

  const [show, setShow] = useState(controlledShow);
  /**
   * Sets the internal state based on the externally controlled visibility toggle.
   */

  useEffect(() => {
    setShow(controlledShow);
  }, [controlledShow]);
  const classes = classNames("color-picker", {
    popup
  }, className);
  return show ? /*#__PURE__*/React__default.createElement(Picker, Object.assign({
    "data-componentid": componentId,
    className: classes
  }, rest)) : null;
};
/**
 * Default props for the component.
 */

ColorPicker.defaultProps = {
  "data-componentid": "color-picker",
  picker: SketchPicker
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Placeholder component.
 *
 * @param props - Props injected in to the placeholder component.
 *
 * @returns the placeholder React component
 */

const EmptyPlaceholder = props => {
  const {
    action,
    className,
    image,
    imageSize,
    subtitle,
    title,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("empty-placeholder", className);
  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, image ? /*#__PURE__*/React__default.createElement("div", {
    className: "image-container"
  }, /*#__PURE__*/React__default.createElement(GenericIcon, {
    fill: "default",
    icon: image,
    size: imageSize,
    "data-componentid": `${componentId}-icon`,
    "data-testid": `${testId}-icon`,
    transparent: true
  })) : null, title && /*#__PURE__*/React__default.createElement(Header$1, {
    as: "h4",
    className: "title",
    "data-componentid": `${componentId}-header`,
    "data-testid": `${testId}-header`
  }, title), subtitle ? Array.isArray(subtitle) && subtitle.length > 0 && subtitle.map((line, index) => /*#__PURE__*/React__default.createElement("div", {
    key: index,
    className: "subtitle",
    "data-componentid": `${componentId}-sub-header-line-${index}`,
    "data-testid": `${testId}-sub-header-line-${index}`
  }, line)) : /*#__PURE__*/React__default.createElement("div", {
    className: "subtitle",
    "data-componentid": `${componentId}-sub-header`,
    "data-testid": `${testId}-sub-header`
  }, subtitle), action ? /*#__PURE__*/React__default.createElement("div", {
    className: "action-container",
    "data-componentid": `${componentId}-action-container`,
    "data-testid": `${testId}-action-container`
  }, action) : null);
};
/**
 * Default proptypes for the empty placeholder component.
 */

EmptyPlaceholder.defaultProps = {
  action: null,
  "data-componentid": "empty-placeholder",
  "data-testid": "empty-placeholder",
  image: null,
  imageSize: "auto"
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * This renders the certificate component that displays the details of a certificate.
 *
 * @param props - Props injected to the component.
 * @returns the certificate component
 */

const Certificate = props => {
  const {
    labels,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const {
    version,
    issuerDN,
    validFrom,
    validTill
  } = props.certificate;
  /**
   * Creates the validity icon.
   */

  const showValidTillIcon = () => {
    let icon = null;
    let iconColor = null;
    let popupText = "";
    const currentDate = moment(new Date());
    const expiryDate = moment(validTill);
    const isValid = new Date() <= validTill;

    if (isValid) {
      if (Math.abs(moment.duration(currentDate.diff(expiryDate)).months()) > 1) {
        icon = "check circle";
        iconColor = "green";
        popupText = "Certificate is valid.";
      } else {
        icon = "exclamation circle";
        iconColor = "yellow";
        popupText = "Certificate is soon to be expired.";
      }
    } else {
      icon = "times circle";
      iconColor = "red";
      popupText = "Certificate is expired.";
    }

    return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Popup, {
      trigger: /*#__PURE__*/React__default.createElement(Icon, {
        name: icon,
        color: iconColor
      }),
      content: popupText,
      inverted: true,
      position: "top center",
      size: "mini"
    }));
  };
  /**
   * Creates the validity icon for expiry date.
   */


  const showValidFromIcon = () => {
    let icon = null;
    let iconColor = null;
    let popupText = "";
    const currentDate = moment(new Date());
    const expiryDate = moment(validFrom);
    const isValid = new Date() >= validFrom;

    if (isValid) {
      icon = "check circle";
      iconColor = "green";
      popupText = "Certificate is valid.";
    } else {
      if (Math.abs(moment.duration(currentDate.diff(expiryDate)).months()) > 1) {
        icon = "times circle";
        iconColor = "red";
        popupText = "Certificate is still not valid.";
      } else {
        icon = "exclamation circle";
        iconColor = "yellow";
        popupText = "Certificate is soon to be valid.";
      }
    }

    return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Popup, {
      trigger: /*#__PURE__*/React__default.createElement(Icon, {
        name: icon,
        color: iconColor
      }),
      content: popupText,
      inverted: true,
      position: "top center",
      size: "mini"
    }));
  };

  return /*#__PURE__*/React__default.createElement(Segment, {
    className: "certificate",
    compact: true,
    "data-testid": testId,
    "data-componentid": componentId
  }, /*#__PURE__*/React__default.createElement(Grid, null, /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: 16,
    mobile: 16,
    tablet: 16
  }, /*#__PURE__*/React__default.createElement("p", {
    className: "certificate-field"
  }, /*#__PURE__*/React__default.createElement("span", null, /*#__PURE__*/React__default.createElement("strong", null, labels.validFrom)), /*#__PURE__*/React__default.createElement("span", {
    className: "valid-before-date"
  }, validFrom.toLocaleString("en-us", {
    day: "numeric",
    hour: "numeric",
    hour12: true,
    minute: "numeric",
    month: "long",
    timeZoneName: "short",
    weekday: "short",
    year: "numeric"
  }), showValidFromIcon())), /*#__PURE__*/React__default.createElement("p", {
    className: "certificate-field"
  }, /*#__PURE__*/React__default.createElement("span", null, /*#__PURE__*/React__default.createElement("strong", null, labels.validTill)), /*#__PURE__*/React__default.createElement("span", {
    className: "valid-till-date"
  }, validTill.toLocaleString("en-us", {
    day: "numeric",
    hour: "numeric",
    hour12: true,
    minute: "numeric",
    month: "long",
    timeZoneName: "short",
    weekday: "short",
    year: "numeric"
  }), showValidTillIcon()))))), /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), /*#__PURE__*/React__default.createElement(Grid, {
    className: "certificate-issuer"
  }, /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: 4,
    mobile: 4,
    tablet: 4
  }), /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: 6,
    mobile: 6,
    tablet: 6
  }, /*#__PURE__*/React__default.createElement("p", {
    className: "certificate-field"
  }, /*#__PURE__*/React__default.createElement("span", null, /*#__PURE__*/React__default.createElement("strong", null, labels.issuerDN)))), /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: 6,
    mobile: 6,
    tablet: 6
  }, /*#__PURE__*/React__default.createElement("p", {
    className: "certificate-field"
  }, /*#__PURE__*/React__default.createElement("span", null, /*#__PURE__*/React__default.createElement("strong", null, labels.subjectDN))))), issuerDN.map((attribute, index) => /*#__PURE__*/React__default.createElement(Fragment, {
    key: index
  }, /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: 4,
    mobile: 4,
    tablet: 4
  }, /*#__PURE__*/React__default.createElement("p", {
    className: "certificate-field"
  }, /*#__PURE__*/React__default.createElement("span", null, /*#__PURE__*/React__default.createElement("strong", null, Object.entries(attribute)[0][0])))), /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: 6,
    mobile: 6,
    tablet: 6
  }, /*#__PURE__*/React__default.createElement("p", {
    className: "certificate-field"
  }, /*#__PURE__*/React__default.createElement("span", null, Object.entries(attribute)[0][1]))), /*#__PURE__*/React__default.createElement(Grid.Column, {
    computer: 6,
    mobile: 6,
    tablet: 6
  }, /*#__PURE__*/React__default.createElement("p", {
    className: "certificate-field"
  }, /*#__PURE__*/React__default.createElement("span", null, Object.entries(attribute)[0][1]))))))), /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), /*#__PURE__*/React__default.createElement("p", {
    className: "certificate-version"
  }, /*#__PURE__*/React__default.createElement("span", null, labels.version), " ", version + " "));
};
/**
 * Default props for the component.
 */

Certificate.defaultProps = {
  "data-componentid": "certificate",
  "data-testid": "certificate"
};

/**
 * Markdown renderer component.
 *
 * @param props - Props injected in to the component.
 *
 * @returns the markdown renderer component
 */

const Markdown = props => {
  const {
    className,
    textAlign,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["className", "textAlign", "data-componentid", "data-testid"]);

  const classes = classNames("markdown", {
    [`text-align-${textAlign}`]: textAlign
  }, className);
  return /*#__PURE__*/React__default.createElement(ReactMarkdown, Object.assign({
    className: classes,
    escapeHtml: false,
    "data-componentid": componentId,
    "data-testid": testId
  }, rest));
};
/**
 * Default proptypes for the markdown component.
 */

Markdown.defaultProps = {
  "data-componentid": "markdown-renderer",
  "data-testid": "markdown-renderer",
  textAlign: "left"
};

/**
 * Protected route component.
 *
 * @param props - Props injected in to the component.
 *
 * @returns protect route component
 */

const ProtectedRoute = props => {
  const {
    component: Component,
    currentPath,
    isAuthorized,
    onAuthCallbackUrlUpdate,
    loginPath,
    loginErrorPath,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props,
        rest = __rest(props, ["component", "currentPath", "isAuthorized", "onAuthCallbackUrlUpdate", "loginPath", "loginErrorPath", "data-componentid", "data-testid"]);
  /**
   * Update existing location path in the state to recall upon page refresh or authentication callback.
   * The login path and the login error path have been skipped.
   */


  if (currentPath !== loginPath && currentPath !== loginErrorPath) {
    onAuthCallbackUrlUpdate(currentPath);
  }

  return /*#__PURE__*/React__default.createElement(Route, Object.assign({
    render: props => isAuthorized ? /*#__PURE__*/React__default.createElement(Component, Object.assign({}, props)) : /*#__PURE__*/React__default.createElement(Redirect, {
      to: loginPath
    }),
    "data-componentid": componentId,
    "data-testid": testId
  }, rest));
};

/**
 * Side panel item group component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */

const SidePanelItemGroup = props => {
  const {
    allowedScopes,
    childRoutes,
    open,
    sidePanelItemHeight,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("child-routes", {
    open
  });
  const styles = {
    maxHeight: open ? `${childRoutes.length * sidePanelItemHeight}px` : 0
  };
  return /*#__PURE__*/React__default.createElement(Menu.Menu, {
    className: classes,
    style: styles,
    "data-testid": testId,
    "data-componentid": componentId
  }, childRoutes.map((route, index) => /*#__PURE__*/React__default.createElement(SidePanelItem, Object.assign({
    key: route.level ? `level-${route.level}-${index}` : `level-${0}-${index}`,
    route: route,
    iconSize: "nano",
    allowedScopes: allowedScopes,
    "data-componentid": `${componentId}-child-item`,
    "data-testid": `${testId}-child-item`
  }, props))));
};
/**
 * Default props for the side panel item group component.
 */

SidePanelItemGroup.defaultProps = {
  "data-componentid": "side-panel-item-group",
  "data-testid": "side-panel-item-group"
};

/**
 * Side panel item component.
 *
 * @param props - Props injected to the component.
 *
 * @returns SidePanelItem React Component
 */

const SidePanelItem = props => {
  var _a;

  const {
    allowedScopes,
    caretIcon,
    categorized,
    footerHeight,
    headerHeight,
    iconSize,
    onSidePanelItemClick,
    route,
    selected,
    showEllipsis,
    translationHook,
    sidePanelItemHeight,
    hoverType,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("side-panel-item", {
    [`hover-${hoverType}`]: hoverType,
    "active": selected && selected.path === route.path,
    categorized,
    "ellipsis": showEllipsis
  });
  const featureStatusLabelClasses = classNames("feature-status-label", {
    [kebabCase((_a = route.featureStatus) === null || _a === void 0 ? void 0 : _a.toLocaleLowerCase())]: route.featureStatus
  });
  /**
   * Validates if any of the child routes is supposed to be shown
   * on the side panel.
   *
   * @param children - Child routes.
   * @returns a boolean that indicates whether the passed child routes are valid or not.
   */

  const validateChildren = children => {
    if (!(children && children instanceof Array && children.length > 0)) {
      return false;
    }

    return children.some(child => {
      return child.showOnSidePanel === true;
    });
  };
  /**
   * Checks if the child item is the selected, if so opens
   * the child items section automatically to improve UX.
   *
   * @param isOpen - Passed as a prop when manually clicked.
   * @param selectedRoute - The selected route.
   * @param children - Child routes.
   * @returns a boolean that indicates whether the child item section should be opened or not.
   */


  const validateOpenState = (isOpen, selectedRoute, children) => {
    if (isOpen) {
      return true;
    }

    const recurse = childrenArr => {
      for (const child of childrenArr) {
        if (child.id === (selectedRoute === null || selectedRoute === void 0 ? void 0 : selectedRoute.id)) {
          return true;
        }

        if (child.children) {
          recurse(child.children);
        }
      }

      return false;
    };

    return recurse(children);
  };

  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, route && /*#__PURE__*/React__default.createElement(Menu.Item, {
    name: route.name,
    className: classes,
    disabled: route.isFeatureEnabled === false,
    active: selected && selected.path === route.path,
    onClick: () => onSidePanelItemClick(route),
    "data-componentid": `${componentId}-${kebabCase(route.id)}`,
    "data-testid": `${testId}-${kebabCase(route.id)}`
  }, /*#__PURE__*/React__default.createElement(GenericIcon, Object.assign({
    transparent: true,
    className: "left-icon",
    size: iconSize,
    floated: "left",
    spaced: "right"
  }, route.icon, {
    "data-componentid": `${componentId}-icon`,
    "data-testid": `${testId}-icon`
  })), /*#__PURE__*/React__default.createElement("span", {
    className: "route-name",
    "data-componentid": `${componentId}-label`,
    "data-testid": `${testId}-label`
  }, translationHook ? translationHook(route.name) : route.name, route.featureStatus && /*#__PURE__*/React__default.createElement(Label, {
    className: featureStatusLabelClasses,
    size: "mini",
    "data-componentid": `${componentId}-version`,
    "data-testid": `${testId}-version`
  }, translationHook(route.featureStatusLabel))), // Check if any of the child items are defined to be shown on the side panel.
  // If not hides the caret icon.
  caretIcon && validateChildren(route.children) ? /*#__PURE__*/React__default.createElement(GenericIcon, {
    className: `caret ${route.open ? "down" : "right"}`,
    icon: caretIcon,
    size: "auto",
    floated: "right",
    "data-componentid": `${componentId}-caret`,
    "data-testid": `${testId}-caret`,
    transparent: true
  }) : null), route.children && route.children.length && route.children.length > 0 ? /*#__PURE__*/React__default.createElement(SidePanelItemGroup, {
    caretIcon: caretIcon,
    hoverType: hoverType,
    categorized: categorized,
    childRoutes: route.children,
    footerHeight: footerHeight,
    headerHeight: headerHeight,
    onSidePanelItemClick: onSidePanelItemClick,
    selected: selected,
    open: validateOpenState(route.open, selected, route.children),
    sidePanelItemHeight: sidePanelItemHeight,
    translationHook: translationHook,
    allowedScopes: allowedScopes
  }) : null);
};
/**
 * Default props for the side panel item component.
 */

SidePanelItem.defaultProps = {
  "data-componentid": "side-panel-item",
  "data-testid": "side-panel-item",
  iconSize: "micro"
};

/**
 * Side panel items component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */

const SidePanelItems = props => {
  const {
    allowedScopes,
    desktopContentTopSpacing,
    headerHeight,
    relaxed,
    routes,
    showCategoryDividers,
    sidePanelPosition,
    sidePanelTopMargin,
    skipCategoryLabelForSingleItemCategories,
    type,
    translationHook,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const menuClasses = classNames("side-panel", {
    relaxed,
    [type]: type
  });
  const categoryClasses = classNames("side-panel-category", {
    "with-dividers": showCategoryDividers
  });

  const calcSidePanelTopMargin = () => {
    if (!sidePanelTopMargin) {
      return undefined;
    }

    if (typeof sidePanelTopMargin === "number") {
      return `${sidePanelTopMargin}px`;
    } else if (typeof sidePanelTopMargin === "boolean" && sidePanelTopMargin === true) {
      return `${headerHeight + desktopContentTopSpacing}px`;
    }

    return undefined;
  };

  const style = type === "desktop" ? {
    position: sidePanelPosition,
    top: calcSidePanelTopMargin()
  } : null;
  /**
   * Renders a re-usable side panel item.
   *
   * @param route - Route object.
   * @param index - Index.
   * @returns a React component
   */

  const renderItem = (route, index) => /*#__PURE__*/React__default.createElement(SidePanelItem, Object.assign({
    key: route.level ? `level-${route.level}-${index}` : `level-${0}-${index}`,
    route: route,
    "data-componentid": `${componentId}-item`,
    "data-testid": `${testId}-item`,
    allowedScopes: allowedScopes
  }, props));

  return /*#__PURE__*/React__default.createElement(Menu, {
    className: menuClasses,
    style: style,
    "data-componentid": componentId,
    "data-testid": testId,
    vertical: true,
    fluid: true
  }, routes && (routes instanceof Array ? routes.map((route, index) => renderItem(route, index)) : Object.entries(routes).map(([key, value]) => /*#__PURE__*/React__default.createElement(Fragment, {
    key: key
  }, skipCategoryLabelForSingleItemCategories ? value instanceof Array && value.length > 1 && /*#__PURE__*/React__default.createElement("div", {
    className: categoryClasses
  }, translationHook ? translationHook(key) : key) : /*#__PURE__*/React__default.createElement("div", {
    className: categoryClasses
  }, translationHook ? translationHook(key) : key), value instanceof Array && value.map((route, index) => renderItem(route, index))))));
};
/**
 * Default props for the side panel items component.
 */

SidePanelItems.defaultProps = {
  "data-componentid": "side-panel-items",
  "data-testid": "side-panel-items"
};

/**
 * Side panel base component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Side panel base component.
 */

const SidePanel = props => {
  const {
    allowedScopes,
    bordered,
    categorized,
    children,
    desktopContentTopSpacing,
    footerHeight,
    fluid,
    headerHeight,
    mobileSidePanelVisibility,
    ordered,
    onSidePanelItemClick,
    onSidePanelPusherClick,
    routes,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const [items, setItems] = useState(routes);
  const wrapperClasses = classNames("side-panel-wrapper", {
    bordered,
    [typeof bordered === "boolean" ? "all" : `${bordered}`]: bordered
  });
  const mainLayoutStyles = {
    paddingBottom: `${footerHeight}px`,
    paddingTop: `${headerHeight}px`
  };
  const desktopContentStyle = {
    minHeight: `calc(100vh - ${headerHeight + footerHeight}px`,
    paddingTop: `${desktopContentTopSpacing}px`
  };
  /**
   * Update items when the routes prop changes
   */

  useEffect(() => {
    setItems(routes);
  }, [routes]);
  /**
   * Evaluate if the child item section should be extended or not. If so, adds
   * `open` attribute to the route section.
   *
   * @param routesArray - Array of routes.
   * @param route - Evaluating route.
   * @returns Modified set of routes.
   */

  const evaluateSidePanelItemExtension = (routesArray, route) => {
    return [...routesArray].filter(evalRoute => {
      if (evalRoute.id === route.id) {
        evalRoute.open = !evalRoute.open;
      }

      if (evalRoute.children) {
        evaluateSidePanelItemExtension(evalRoute.children, route);
      }

      return true;
    });
  };
  /**
   * Handles side panel item onclick.
   *
   * @param route - Clicked on route.
   */


  const handleItemOnClick = route => {
    setItems(evaluateSidePanelItemExtension(routes, route));
    onSidePanelItemClick(route);
  };
  /**
   * Categorize the routes.
   *
   * @param routes - Routes array.
   * @returns Categorized routes.
   */


  const getCategorizedItems = routes => {
    const categorizedRoutes = {};

    for (const route of sortRoutes(routes, "order")) {
      if (route.category) {
        if (categorizedRoutes[route.category]) {
          categorizedRoutes[route.category].push(route);
          continue;
        }

        categorizedRoutes[route.category] = [route];
      }
    }

    return categorizedRoutes;
  };
  /**
   * Sorted routes based on the provided criteria.
   *
   * @param routes - Routes array.
   * @param criteria - Sorting criteria.
   * @returns Sorted routes.
   */


  const sortRoutes = (routes, criteria = "order") => {
    return sortBy(routes, criteria);
  };

  return /*#__PURE__*/React__default.createElement("div", {
    style: mainLayoutStyles,
    className: "layout-content"
  }, /*#__PURE__*/React__default.createElement(Media, {
    lessThan: "tablet",
    className: "mobile-container"
  }, /*#__PURE__*/React__default.createElement(Sidebar.Pushable, null, /*#__PURE__*/React__default.createElement(Sidebar, {
    animation: "push",
    visible: mobileSidePanelVisibility,
    "data-componentid": componentId,
    "data-testid": testId
  }, /*#__PURE__*/React__default.createElement(SidePanelItems, Object.assign({}, props, {
    type: "mobile",
    onSidePanelItemClick: handleItemOnClick,
    routes: categorized ? getCategorizedItems(items) : ordered ? sortRoutes(items) : items,
    "data-componentid": `${componentId}-items`,
    "data-testid": `${testId}-items`,
    allowedScopes: allowedScopes
  }))), /*#__PURE__*/React__default.createElement(Sidebar.Pusher, {
    onClick: onSidePanelPusherClick,
    className: "side-panel-pusher"
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "content-wrapper"
  }, children)))), /*#__PURE__*/React__default.createElement(Media, {
    greaterThanOrEqual: "tablet"
  }, /*#__PURE__*/React__default.createElement(Container, {
    className: "desktop-container",
    fluid: fluid,
    style: desktopContentStyle
  }, /*#__PURE__*/React__default.createElement("div", {
    className: wrapperClasses,
    "data-testid": testId,
    "data-componentid": componentId
  }, /*#__PURE__*/React__default.createElement(SidePanelItems, Object.assign({}, props, {
    type: "desktop",
    onSidePanelItemClick: handleItemOnClick,
    routes: categorized ? getCategorizedItems(items) : ordered ? sortRoutes(items) : items,
    "data-componentid": `${componentId}-items`,
    "data-testid": `${testId}-items`
  }))), /*#__PURE__*/React__default.createElement("div", {
    className: "content-wrapper"
  }, children))));
};
/**
 * Default props for the side panel items component.
 */

SidePanel.defaultProps = {
  categorized: false,
  "data-componentid": "side-panel",
  "data-testid": "side-panel",
  desktopContentTopSpacing: UIConstants.DEFAULT_DASHBOARD_LAYOUT_DESKTOP_CONTENT_TOP_SPACING,
  fluid: false,
  hoverType: "highlighted",
  ordered: true,
  showCategoryDividers: true,
  showEllipsis: true,
  sidePanelItemHeight: UIConstants.DEFAULT_SIDE_PANEL_ITEM_HEIGHT,
  sidePanelTopMargin: false,
  skipCategoryLabelForSingleItemCategories: true,
  translationHook: null
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Step component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */

const Step = props => {
  const {
    className,
    icon,
    style,
    status,
    title,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("step", {
    [status]: status
  }, className);
  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    style: style,
    "data-testid": testId,
    "data-componentid": componentId
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "step-icon-wrapper"
  }, /*#__PURE__*/React__default.createElement(GenericIcon, {
    className: "step-icon",
    icon: icon,
    size: "micro",
    "data-testid": `${testId}-icon`,
    "data-componentid": `${componentId}-icon`,
    inline: true,
    transparent: true
  }), /*#__PURE__*/React__default.createElement("div", {
    className: "step-checked",
    "data-componentid": `${componentId}-checked`,
    "data-testid": `${testId}-checked`
  })), title && /*#__PURE__*/React__default.createElement("div", {
    className: "step-title",
    "data-componentid": `${componentId}-title`,
    "data-testid": `${testId}-title`
  }, title));
};
/**
 * Default props for the steps component.
 */

Step.defaultProps = {
  "data-componentid": "step",
  "data-testid": "step",
  status: undefined
};

/**
 * Steps component.
 *
 * @param props - Props injected to the component.
 *
 * @returns a React component
 */

const Steps = props => {
  const {
    children,
    className,
    current,
    header,
    initial,
    style,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const [filteredChildren, setFilteredChildren] = useState([]);
  const classes = classNames("steps", className);
  useEffect(() => {
    setFilteredChildren(React__default.Children.toArray(children).filter(child => !!child));
  }, [children]);
  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    style: style,
    "data-testid": testId,
    "data-componentid": componentId
  }, header && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement("div", {
    className: "header",
    "data-componentid": `${componentId}-header`,
    "data-testid": `${testId}-header`
  }, header), /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  })), Children.map(filteredChildren, (child, index) => {
    if (!child) {
      return null;
    }

    const stepNumber = initial + index;
    const childProps = Object.assign({
      stepNumber: `${stepNumber + 1}`
    }, child.props);

    if (!child.props.status) {
      if (stepNumber === current) {
        childProps.status = "active";
      } else if (stepNumber < current) {
        childProps.status = "completed";
      } else {
        childProps.status = undefined;
      }
    }

    childProps.active = stepNumber === current;
    return /*#__PURE__*/cloneElement(child, childProps);
  }));
};
Steps.Group = Steps;
Steps.Step = Step;
/**
 * Wizard component default props.
 */

Steps.defaultProps = {
  current: 0,
  "data-componentid": "steps",
  "data-testid": "steps",
  initial: 0
};

/**
 * Sticks the children to the specified position.
 *
 * @param props - Props injected to the component.
 *
 * @returns StickyBar
 */

const StickyBar = props => {
  var _a;

  const {
    updateButtonRef,
    isFormStale,
    containerRef
  } = props;
  const [stickyBarWidth, setStickyBarWidth] = useState(0);
  const [padding, setPadding] = useState(0);
  const [showStickyBar, setShowStickyBar] = useState(false);
  useEffect(() => {
    if (!updateButtonRef.current) {
      return;
    }

    const observer = new IntersectionObserver(entries => {
      const entry = entries[0];

      if (entry.isIntersecting) {
        setShowStickyBar(false);
      } else {
        setShowStickyBar(true);
      }
    }, {
      root: null,
      threshold: 0.1
    });
    observer.observe(updateButtonRef.current);
    return () => {
      observer.disconnect();
    };
  }, [updateButtonRef.current]);
  useEffect(() => {
    var _a;

    setStickyBarWidth((_a = containerRef === null || containerRef === void 0 ? void 0 : containerRef.current) === null || _a === void 0 ? void 0 : _a.offsetWidth);
    const containerPadding = window.getComputedStyle(containerRef === null || containerRef === void 0 ? void 0 : containerRef.current, null).getPropertyValue("padding-left");
    const containerPaddingValue = parseInt(containerPadding === null || containerPadding === void 0 ? void 0 : containerPadding.replace("px", ""), 10);
    setPadding(containerPaddingValue - 14);
  }, [containerRef.current]);
  return showStickyBar && isFormStale && /*#__PURE__*/React__default.createElement(Segment, {
    className: "sticky-bar",
    style: {
      marginLeft: `-${padding}px`,
      width: `calc(${(_a = stickyBarWidth - 2) !== null && _a !== void 0 ? _a : 0}px`
    }
  }, props.children);
};

const FIRST_ELEMENT_INDEX = 0;
const EMPTY_OBJECT = {};
/**
 * Check every option has icon value in place.
 * @param options - switcher props
 */

const canButtonGroupHaveIcons = options => {
  return options.every(optionHas => Boolean(optionHas === null || optionHas === void 0 ? void 0 : optionHas.icon));
};
/**
 * This is a dynamic switcher component that offers below
 * functionality:-
 *
 *  1) Given the options, it can render a grouped set of
 *     buttons that is selectable.
 *
 *  2) A {@link StrictSwitcher.defaultOptionValue} value
 *     can be set to enforce the matching value to be
 *     selected initially. If the defaultOptionValue is
 *     unavailable the first element will be the default.
 *
 *  3) Support three switch options. Optionally this can be
 *     adjusted if the use-case requires more options. Ideally
 *     it should be little because its a group and overflows
 *     will not be handle by this component at this time.
 *
 *  4) Fire a initial event for the default value. This will
 *     be triggered when provided/not-provided {@link defaultOptionValue}
 *     nonetheless.
 *
 * How can I use this interface? As a example refer below block.
 *
 * ```
 *  <Switcher
 *      defaultOptionValue="option2"
 *      onChange={ (selectedOption: SwitcherOptionProps) => {
 *          // Will be triggered initially and on value change.
 *          console.log(selectedOption.value);
 *      } }
 *      options=\{ [
 *          {
 *              value: "option1",
 *              label: "My option 1",
 *              icon: "cogs"
 *          },
 *          {
 *              value: "option2",
 *              label: "My option 2",
 *              icon: "file"
 *          }
 *      ] }
 *  />
 *```
 * @param props - props injected to the component
 */


const Switcher = props => {
  const {
    disabledMessage,
    selectedValue,
    options,
    onChange,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["disabledMessage", "selectedValue", "options", "onChange", "data-componentid"]);

  const [selectedOption, setSelectedOption] = useState();
  /**
   * Trigger the initial event. This makes sure parent gets notified
   * initially when the component renders successfully and allow the
   * parent to know the initial value.
   */

  useEffect(() => {
    triggerInitial();
  }, []);
  /**
   * Whenever parent changes this value make sure to update
   * it as necessary.
   */

  useEffect(() => {
    triggerInitial();
  }, [selectedValue]);

  const triggerInitial = () => {
    // If user didn't provide a value for {@link selectedValue}
    // try to set the first option as the default value.
    let specifiedDefault = options.find(({
      value
    }) => value === selectedValue);

    if (!specifiedDefault) {
      specifiedDefault = options[FIRST_ELEMENT_INDEX];
    }

    if (onChange) {
      onChange(specifiedDefault);
      setSelectedOption(specifiedDefault);
    }
  };
  /**
   * On {@link SwitcherOptionProps} button click this function will
   * be triggered with the event and the data passed to the
   * {@link Button} element. It uses the `data.value`
   * to access the event source value.
   *
   * @param event - alias for {@link React.MouseEvent}
   * @param data - passed props for the button element.
   */


  const onSwitchOptionButtonClick = (event, data) => {
    if (event) {
      event.preventDefault();
      event.stopPropagation();
    }

    if (onChange) {
      onChange(data);
    } else {
      // If the onChange is present then onSelect will never
      // be called. This is because onChange pretty much offer
      // the same functionality. Hence, no need to invoke two
      // handlers at the same time.
      const fromActiveState = data.active;

      if (!fromActiveState && (data === null || data === void 0 ? void 0 : data.onSelect)) {
        data.onSelect(data);
      }
    }

    setSelectedOption(data);
  };

  return /*#__PURE__*/React__default.createElement(Button$1.Group, Object.assign({
    labeled: true,
    basic: true,
    icon: canButtonGroupHaveIcons(options),
    widths: options.length,
    "data-componentid": componentId
  }, rest !== null && rest !== void 0 ? rest : EMPTY_OBJECT), options.map((opt, index) => {
    const {
      value,
      label,
      disabled,
      "data-componentid": optionComponentId
    } = opt,
          optRest = __rest(opt, ["value", "label", "disabled", "data-componentid"]);

    if (disabled) {
      return /*#__PURE__*/React__default.createElement(Popup, {
        key: index,
        content: disabledMessage !== null && disabledMessage !== void 0 ? disabledMessage : DEFAULT_DISABLED_MESSAGE,
        // Why a <div> wrapping the button? Well, buttons doesn't
        // trigger hovers when they're disabled...
        // Popup only triggers: {hover, click, focus} events.
        // https://react.semantic-ui.com/modules/popup/
        // https://github.com/Semantic-Org/Semantic-UI-React/issues/1413
        trigger: /*#__PURE__*/React__default.createElement("div", null, /*#__PURE__*/React__default.createElement(Button$1, {
          style: STYLED_BUTTON,
          disabled: true,
          key: index,
          value: value,
          content: label,
          onClick: OPERATION_PASS,
          "data-componentid": `${optionComponentId}-disabled`
        })),
        "data-componentid": `${optionComponentId}-popup`
      });
    }

    return /*#__PURE__*/React__default.createElement(Button$1, Object.assign({
      key: index,
      value: value,
      content: label,
      active: (selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.value) === value,
      disabled: Boolean(disabled),
      onClick: onSwitchOptionButtonClick,
      "data-componentid": optionComponentId
    }, optRest !== null && optRest !== void 0 ? optRest : EMPTY_OBJECT));
  }));
};
/**
 * Default props for the component.
 */

Switcher.defaultProps = {
  "data-componentid": "switcher"
}; // Component constants

const DEFAULT_DISABLED_MESSAGE = "This action is disabled.";
const STYLED_BUTTON = {
  height: "100%"
};

const OPERATION_PASS = event => {
  event === null || event === void 0 ? void 0 : event.preventDefault();
  event === null || event === void 0 ? void 0 : event.stopPropagation();
};

/**
 * Data Table Body component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Data Table Body component
 */

const DataTableBody = props => {
  const {
    children,
    className,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["children", "className", "data-componentid"]);

  const classes = classNames("data-table-body", className);
  return /*#__PURE__*/React__default.createElement(Table.Body, Object.assign({
    className: classes,
    "data-componentid": componentId
  }, rest), children);
};
/**
 * Default props for the component.
 */

DataTableBody.defaultProps = {
  "data-componentid": "data-table-body",
  "data-testid": "data-table-body"
};

/**
 * Data Table Cell component.
 *
 * @param props - Props injected to the component.
 *
 * @returns DataTableCell component
 */

const DataTableCell = props => {
  const {
    children,
    className,
    action,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["children", "className", "action", "data-componentid"]);

  const classes = classNames("data-table-cell", className, action && "actions-cell", action && `items-${React__default.Children.count(children)}`);
  return /*#__PURE__*/React__default.createElement(Table.Cell, Object.assign({
    className: classes,
    "data-componentid": componentId
  }, rest), children);
};
/**
 * Default props for the component.
 */

DataTableCell.defaultProps = {
  "data-componentid": "data-table-cell",
  "data-testid": "data-table-cell"
};

var _path;

function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var SvgColumnIcon = function SvgColumnIcon(props) {
  return /*#__PURE__*/React.createElement("svg", _extends({
    className: "column-icon_svg__icon",
    xmlns: "http://www.w3.org/2000/svg",
    width: 14,
    height: 14,
    viewBox: "0 0 23.976 19.074"
  }, props), _path || (_path = /*#__PURE__*/React.createElement("path", {
    className: "column-icon_svg__path",
    d: "M0 0h5.305v5.305H0ZM6.994 0h16.985v5.305H6.994ZM0 6.884h5.305v5.305H0ZM6.994 6.884h16.985v5.305H6.994ZM0 13.768h5.305v5.306H0ZM6.994 13.768h16.985v5.306H6.994Zm0 0",
    fill: "#4b4b4b"
  })));
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Data table column selector.
 *
 * @param props - Props injected to the component.
 * @returns Table column selector component
 */

const DataTableColumnSelector = props => {
  const {
    columnSelectorHeader,
    columnSelectorWidth,
    columns,
    floated,
    onColumnSelectionChange,
    showToggleDisallowedColumns,
    triggerIcon,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  /**
   * Checks if the column selector should be rendered or not.
   *
   * @param columns - Table columns.
   * @returns whether the column selector should be rendered
   */

  const isColumnSelectorValid = columns => {
    return columns.some(column => column.allowToggleVisibility) || showToggleDisallowedColumns;
  };
  /**
   * Handles column selector checkbox onchange event.
   *
   * @param e - Event.
   * @param uniqueId - Unique ID of the column.
   */


  const handleColumnVisibilityChange = (e, {
    uniqueId
  }) => {
    const clone = cloneDeep(columns);
    clone.forEach(column => {
      if (column.id !== uniqueId) {
        return;
      }

      column.hidden = !column.hidden;
    });
    onColumnSelectionChange(clone);
  };

  return isColumnSelectorValid(columns) ? /*#__PURE__*/React__default.createElement("div", {
    className: "data-table-column-selector",
    "data-componentid": componentId,
    "data-testid": testId
  }, /*#__PURE__*/React__default.createElement(Popup, {
    flowing: true,
    basic: true,
    pinned: true,
    className: "data-table-column-selector-popup",
    style: {
      width: `${columnSelectorWidth}px`
    },
    content: /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement("div", {
      className: "data-table-column-selector-popup-heading-container"
    }, /*#__PURE__*/React__default.createElement(Heading, {
      as: "h6"
    }, columnSelectorHeader)), /*#__PURE__*/React__default.createElement("div", {
      className: "data-table-column-selector-popup-content"
    }, /*#__PURE__*/React__default.createElement(Form, null, columns.map((column, index) => {
      if (!showToggleDisallowedColumns && !column.allowToggleVisibility) {
        return;
      }

      return /*#__PURE__*/React__default.createElement(Form.Field, {
        key: index,
        disabled: showToggleDisallowedColumns && !column.allowToggleVisibility
      }, /*#__PURE__*/React__default.createElement(Checkbox // using id here gives weird behaviour with SUI.
      , {
        // using id here gives weird behaviour with SUI.
        uniqueId: column.id,
        checked: !column.hidden,
        disabled: showToggleDisallowedColumns && !column.allowToggleVisibility,
        label: column.title,
        onChange: handleColumnVisibilityChange
      }));
    })))),
    position: "bottom right",
    on: "click",
    trigger: /*#__PURE__*/React__default.createElement(GenericIcon, {
      fill: true,
      link: true,
      hoverable: true,
      transparent: true,
      floated: floated,
      icon: triggerIcon,
      size: "micro"
    })
  })) : null;
};
/**
 * Default props for the component.
 */

DataTableColumnSelector.defaultProps = {
  columnSelectorHeader: "Show/Hide Columns",
  columnSelectorWidth: 240,
  "data-componentid": "data-table-column-selector",
  "data-testid": "data-table-column-selector",
  floated: "right",
  showToggleDisallowedColumns: false,
  triggerIcon: SvgColumnIcon
};

/**
 * Data Table Footer component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the Data Table Footer component
 */

const DataTableFooter = props => {
  const {
    children,
    className,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["children", "className", "data-componentid"]);

  const classes = classNames("data-table-footer", className);
  return /*#__PURE__*/React__default.createElement(Table.Footer, Object.assign({
    className: classes,
    "data-componentid": componentId
  }, rest), children);
};
/**
 * Default props for the component.
 */

DataTableFooter.defaultProps = {
  "data-componentid": "data-table-footer",
  "data-testid": "data-table-footer"
};

/**
 * Data Table Header component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the Data Table Header component
 */

const DataTableHeader = props => {
  const {
    children,
    className,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["children", "className", "data-componentid"]);

  const classes = classNames("data-table-header", className);
  return /*#__PURE__*/React__default.createElement(Table.Header, Object.assign({
    className: classes,
    "data-componentid": componentId
  }, rest), children);
};
/**
 * Default props for the component.
 */

DataTableHeader.defaultProps = {
  "data-componentid": "data-table-header",
  "data-testid": "data-table-header"
};

/**
 * Data Table Header Cell component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the Data Table Header Cell component
 */

const DataTableHeaderCell = props => {
  const {
    children,
    className,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["children", "className", "data-componentid"]);

  const classes = classNames("data-table-header-cell", className);
  return /*#__PURE__*/React__default.createElement(Table.HeaderCell, Object.assign({
    className: classes,
    "data-componentid": componentId
  }, rest), children);
};
/**
 * Default props for the component.
 */

DataTableHeaderCell.defaultProps = {
  "data-componentid": "data-table-header-cell",
  "data-testid": "data-table-header-cell"
};

/**
 * Data Table Row component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the Data Table Row component
 */

const DataTableRow = props => {
  const {
    children,
    className,
    selectable,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["children", "className", "selectable", "data-componentid"]);

  const classes = classNames("data-table-row", className, !selectable && "no-selectable");
  return /*#__PURE__*/React__default.createElement(Table.Row, Object.assign({
    className: classes,
    "data-componentid": componentId
  }, rest), children);
};
/**
 * Default props for the component.
 */

DataTableRow.defaultProps = {
  "data-componentid": "data-table-row",
  "data-testid": "data-table-row"
};

/**
 * Data Driven Table Component.
 *
 * @param props - Props injected to the component.
 * @returns Data Driven Table Component.
 */

const DataTable = props => {
  const {
    actions,
    cellUIProps,
    className,
    columnSelectorHeader,
    columnSelectorWidth,
    columnSelectorTriggerIcon,
    columns: initialColumns,
    data,
    extensions,
    externalSearch,
    isLoading,
    loadingStateOptions,
    onColumnSelectionChange,
    onRowClick,
    placeholders: externalPlaceholders,
    rowUIProps,
    selectable,
    showColumnSelector,
    showHeader,
    showOperationsHeader,
    showSearch,
    showToggleDisallowedColumns,
    testId,
    isRowSelectable,
    transparent,
    ["data-componentid"]: componentId
  } = props,
        rest = __rest(props, ["actions", "cellUIProps", "className", "columnSelectorHeader", "columnSelectorWidth", "columnSelectorTriggerIcon", "columns", "data", "extensions", "externalSearch", "isLoading", "loadingStateOptions", "onColumnSelectionChange", "onRowClick", "placeholders", "rowUIProps", "selectable", "showColumnSelector", "showHeader", "showOperationsHeader", "showSearch", "showToggleDisallowedColumns", "testId", "isRowSelectable", "transparent", "data-componentid"]);

  const classes = classNames("data-table", {
    transparent
  }, className);
  const [columns, setColumns] = useState(initialColumns);
  const [dynamicTableProps, setDynamicTableProps] = useState(undefined);
  useEffect(() => {
    if (!initialColumns) {
      return;
    } // Changing the data on sort order change results in the triggering of this
    // hook which resets the column state. This will be problematic if the columns
    // are dynamically changed from outside.


    const moderatedColumns = [...initialColumns];
    const internalColumns = [...columns];

    for (const moderatedColumn of moderatedColumns) {
      for (const internalColumn of internalColumns) {
        if (moderatedColumn.id === internalColumn.id) {
          moderatedColumn.sortOrder = internalColumn.sortOrder;
          break;
        }
      }
    }

    setColumns(moderatedColumns);
    evaluateColumnProps(moderatedColumns);
  }, [initialColumns]);
  /**
   * Evaluate column props.
   *
   * @param columns - Columns.
   */

  const evaluateColumnProps = columns => {
    if (!isColumnsValid(columns)) {
      return;
    } // Check if any of the columns have sortable prop. If yes, set `sortable` prop in the parent
    // `Table` component to true.


    const isSortable = columns.some(column => column.sortable);

    if (isSortable) {
      setDynamicTableProps(Object.assign(Object.assign({}, dynamicTableProps), {
        celled: true,
        sortable: true
      }));
    }
  };

  const isColumnsValid = columns => {
    return columns && Array.isArray(columns) && columns.length > 0;
  };

  const isDataValid = data => {
    return data && Array.isArray(data) && data.length > 0;
  };

  const isActionsValid = actions => {
    return actions && Array.isArray(actions) && actions.length > 0;
  };

  const isExtensionsValid = (extensions, checkIfRenderable = false) => {
    return extensions && Array.isArray(extensions) && extensions.length > 0 && (checkIfRenderable ? extensions.some(extension => extension.component) : true);
  };

  const isTableRenderable = data => {
    return isDataValid(data);
  };

  const renderActions = (item, action, index) => {
    const {
      component: actionComponent,
      disabled: actionDisabled,
      hidden: actionHidden,
      icon: actionIcon,
      onClick: actionOnClick,
      popupText: actionPopupText,
      renderer: actionRenderer,
      link: actionLink,
      subActions
    } = action,
          rest = __rest(action, ["component", "disabled", "hidden", "icon", "onClick", "popupText", "renderer", "link", "subActions"]);

    if (actionHidden && actionHidden(item)) {
      return null;
    }

    const resolvedIcon = actionIcon(item);
    const resolvedPopupText = actionPopupText(item);

    if (actionRenderer === "dropdown") {
      return /*#__PURE__*/React__default.createElement(Dropdown, {
        key: index,
        direction: "left",
        icon: null,
        trigger: /*#__PURE__*/React__default.createElement(Popup, {
          disabled: actionDisabled,
          trigger: /*#__PURE__*/React__default.createElement(Icon, Object.assign({
            link: actionLink && actionLink(item),
            className: "list-icon",
            disabled: actionDisabled,
            size: "small",
            color: "grey",
            name: resolvedIcon,
            onClick: e => {
              e.stopPropagation();
              actionOnClick(e, item);
            }
          }, rest)),
          position: "top center",
          content: resolvedPopupText,
          inverted: true
        }),
        options: subActions
      });
    }

    if (actionRenderer === "semantic-icon") {
      return /*#__PURE__*/React__default.createElement(Popup, {
        key: index,
        disabled: actionDisabled,
        trigger: /*#__PURE__*/React__default.createElement(Icon, Object.assign({
          link: actionLink && actionLink(item),
          className: "list-icon data-table-list-icon",
          disabled: actionDisabled,
          size: "small",
          color: "grey",
          name: resolvedIcon,
          onClick: e => {
            e.stopPropagation();
            actionOnClick(e, item);
          }
        }, rest)),
        position: "top center",
        content: resolvedPopupText,
        inverted: true
      });
    }

    if (actionComponent) {
      return /*#__PURE__*/React__default.createElement(Popup, {
        key: index,
        disabled: actionDisabled,
        trigger: actionComponent,
        position: "top center",
        content: resolvedPopupText,
        inverted: true
      });
    }

    return null;
  };

  const renderCell = (item, column) => {
    if (column.dataIndex === "action" && isActionsValid(actions)) {
      return actions.map((action, index) => {
        if (!action) {
          return;
        }

        return renderActions(item, action, index);
      });
    }

    return get$2(item, column.dataIndex);
  };

  const renderHeaderCell = (column, index) => {
    if (!column) {
      return null;
    }

    const {
      key: columnKey,
      textAlign: columnTextAlign,
      title: columnTitle,
      hidden: columnHidden,
      getSortOrder: getColumnSortOrder,
      onClick: columnOnClick,
      sortOrder: columnSortOrder,
      sortable: columnSortable
    } = column,
          rest = __rest(column, ["key", "textAlign", "title", "hidden", "getSortOrder", "onClick", "sortOrder", "sortable"]);

    if (columnHidden) {
      return;
    }

    const handleHeaderCellClick = e => {
      columnOnClick && columnOnClick(e);

      if (!columnSortable) {
        return;
      }

      const modifiedColumns = [...columns];
      modifiedColumns.forEach(evalColumn => {
        if (!isEqual(evalColumn, column)) {
          return;
        }

        const newOrder = evalColumn.sortOrder === "ascending" ? "descending" : "ascending";
        getColumnSortOrder && getColumnSortOrder(newOrder, column);
        evalColumn.sortOrder = newOrder;
      });
      setColumns(modifiedColumns);
    };

    const resolveSortOrder = order => {
      if (order === "ascending") {
        return "ascending";
      }

      if (order === "descending") {
        return "descending";
      }

      return null;
    };

    return /*#__PURE__*/React__default.createElement(DataTable.HeaderCell, Object.assign({
      key: columnKey !== null && columnKey !== void 0 ? columnKey : index,
      textAlign: columnTextAlign,
      onClick: handleHeaderCellClick,
      sorted: resolveSortOrder(columnSortOrder)
    }, rest), columnTitle);
  };

  const showPlaceholders = () => {
    if (isLoading) {
      return showLoadingPlaceholders();
    }

    return /*#__PURE__*/React__default.createElement(DataTable.Row, {
      className: "no-hover"
    }, /*#__PURE__*/React__default.createElement(DataTable.Cell, null, externalPlaceholders));
  };
  /**
   * Shows the loading state placeholder rows.
   *
   * @returns Loading Placeholders.
   */


  const showLoadingPlaceholders = () => {
    const placeholders = [];

    for (let i = 0; i < (loadingStateOptions === null || loadingStateOptions === void 0 ? void 0 : loadingStateOptions.count); i++) {
      placeholders.push( /*#__PURE__*/React__default.createElement(DataTable.Row, {
        key: i
      }, /*#__PURE__*/React__default.createElement(DataTable.Cell, null, /*#__PURE__*/React__default.createElement(Header$1, {
        as: "h6",
        image: true
      }, (loadingStateOptions === null || loadingStateOptions === void 0 ? void 0 : loadingStateOptions.imageType) && /*#__PURE__*/React__default.createElement(Avatar, {
        image: /*#__PURE__*/React__default.createElement(Placeholder, {
          style: {
            height: 35,
            width: 35
          }
        }, /*#__PURE__*/React__default.createElement(Placeholder.Image, null)),
        shape: loadingStateOptions === null || loadingStateOptions === void 0 ? void 0 : loadingStateOptions.imageType,
        isLoading: true,
        avatarType: (loadingStateOptions === null || loadingStateOptions === void 0 ? void 0 : loadingStateOptions.imageType) === "circular" ? "user" : "app",
        size: "mini",
        floated: "left"
      }), /*#__PURE__*/React__default.createElement(Header$1.Content, null, /*#__PURE__*/React__default.createElement(Placeholder, {
        style: {
          width: "300px"
        }
      }, /*#__PURE__*/React__default.createElement(Placeholder.Header, null, /*#__PURE__*/React__default.createElement(Placeholder.Line, null), /*#__PURE__*/React__default.createElement(Placeholder.Line, null))))))));
    }

    return placeholders;
  };

  const handleColumnSelectorChange = columns => {
    setColumns(columns);
    onColumnSelectionChange(columns);
  };

  return /*#__PURE__*/React__default.createElement(Table, Object.assign({
    className: classes,
    selectable: !isLoading && selectable,
    "data-componentid": componentId,
    "data-testid": testId
  }, dynamicTableProps, rest), isTableRenderable(data) ? /*#__PURE__*/React__default.createElement(React__default.Fragment, null, isExtensionsValid(extensions, true) && extensions.map((extension, index) => {
    const {
      component,
      isExternalRendererProvided,
      position
    } = extension;
    return position === "top" ? isExternalRendererProvided ? /*#__PURE__*/React__default.createElement(Fragment, {
      key: index
    }, component) : /*#__PURE__*/React__default.createElement(DataTable.Header, {
      fullWidth: true
    }, /*#__PURE__*/React__default.createElement(DataTable.Row, null, /*#__PURE__*/React__default.createElement(DataTable.HeaderCell, {
      colSpan: isColumnsValid(columns) && columns.length
    }, component))) : null;
  }), showOperationsHeader && (showSearch || showColumnSelector) && /*#__PURE__*/React__default.createElement(DataTable.Header, {
    fullWidth: true
  }, /*#__PURE__*/React__default.createElement(DataTable.Row, null, /*#__PURE__*/React__default.createElement(DataTable.HeaderCell, {
    colSpan: isColumnsValid(columns) && columns.length
  }, /*#__PURE__*/React__default.createElement(Grid, null, /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    mobile: 16,
    tablet: 8,
    computer: 8
  }, showSearch && /*#__PURE__*/React__default.createElement("div", {
    className: "data-table-search"
  }, externalSearch)), /*#__PURE__*/React__default.createElement(Grid.Column, {
    as: Media,
    greaterThanOrEqual: "mobile",
    mobile: 16,
    tablet: 8,
    computer: 8,
    textAlign: "right"
  }, showColumnSelector && isColumnsValid(columns) && /*#__PURE__*/React__default.createElement(DataTableColumnSelector, {
    columns: columns,
    columnSelectorHeader: columnSelectorHeader,
    columnSelectorWidth: columnSelectorWidth,
    floated: "right",
    onColumnSelectionChange: handleColumnSelectorChange,
    showToggleDisallowedColumns: showToggleDisallowedColumns,
    triggerIcon: columnSelectorTriggerIcon
  })), /*#__PURE__*/React__default.createElement(Grid.Column, {
    as: Media,
    lessThan: "mobile",
    mobile: 16,
    tablet: 8,
    computer: 8,
    textAlign: "left"
  }, showColumnSelector && isColumnsValid(columns) && /*#__PURE__*/React__default.createElement(DataTableColumnSelector, {
    columns: columns,
    columnSelectorHeader: columnSelectorHeader,
    columnSelectorWidth: columnSelectorWidth,
    floated: "left",
    onColumnSelectionChange: handleColumnSelectorChange,
    showToggleDisallowedColumns: showToggleDisallowedColumns,
    triggerIcon: columnSelectorTriggerIcon
  }))))))), isColumnsValid(columns) && showHeader && /*#__PURE__*/React__default.createElement(DataTable.Header, null, /*#__PURE__*/React__default.createElement(DataTable.Row, null, columns.map((column, index) => renderHeaderCell(column, index)))), /*#__PURE__*/React__default.createElement(DataTable.Body, null, isColumnsValid(columns) ? data.map((item, index) => {
    if (!item) {
      return;
    }

    const {
      key: itemKey,
      rendererProps,
      textAlign: itemTextAlign,
      width: itemWidth
    } = item;
    const {
      cellUIProps: cellUIPropOverrides,
      rowUIProps: rowUIPropOverrides
    } = rendererProps || {};
    return /*#__PURE__*/React__default.createElement(DataTable.Row, Object.assign({
      key: itemKey !== null && itemKey !== void 0 ? itemKey : index,
      onClick: e => selectable && isRowSelectable(item) && onRowClick(e, item),
      selectable: isRowSelectable(item)
    }, rowUIProps, rowUIPropOverrides), columns.map((column, index) => {
      const {
        textAlign: columnTextAlign,
        width: columnWidth,
        hidden: columnHidden,
        render: columnRenderer
      } = column;

      if (columnHidden) {
        return;
      }

      return /*#__PURE__*/React__default.createElement(DataTable.Cell, Object.assign({
        key: index,
        action: column.dataIndex === "action",
        textAlign: itemTextAlign || columnTextAlign,
        width: itemWidth !== null && itemWidth !== void 0 ? itemWidth : columnWidth
      }, cellUIProps, cellUIPropOverrides), columnRenderer ? columnRenderer(item) : renderCell(item, column));
    }));
  }) : null), isExtensionsValid(extensions, true) && extensions.map((extension, index) => {
    const {
      component,
      isExternalRendererProvided,
      position
    } = extension;
    return position === "bottom" ? isExternalRendererProvided ? /*#__PURE__*/React__default.createElement(Fragment, {
      key: index
    }, component) : /*#__PURE__*/React__default.createElement(DataTable.Footer, {
      fullWidth: true
    }, /*#__PURE__*/React__default.createElement(DataTable.Row, null, /*#__PURE__*/React__default.createElement(DataTable.HeaderCell, {
      colSpan: isColumnsValid(columns) && columns.length
    }, component))) : null;
  })) : /*#__PURE__*/React__default.createElement(DataTable.Body, null, showPlaceholders()));
};
DataTable.defaultProps = {
  "data-componentid": "data-table",
  "data-testid": "data-table",
  isRowSelectable: () => true,
  selectable: true,
  showHeader: true,
  stackable: true
};
DataTable.Body = DataTableBody;
DataTable.Cell = DataTableCell;
DataTable.Footer = DataTableFooter;
DataTable.Header = DataTableHeader;
DataTable.HeaderCell = DataTableHeaderCell;
DataTable.Row = DataTableRow;

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Transfer list component.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */

const TransferListSearch = props => {
  const {
    handleListSearch,
    placeholder,
    isLoading,
    iconPosition,
    disabled,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React__default.createElement(Grid.Column, {
    mobile: 16,
    tablet: 16,
    computer: 8
  }, /*#__PURE__*/React__default.createElement(Input, {
    loading: isLoading,
    "data-componentid": componentId,
    "data-testid": testId,
    icon: /*#__PURE__*/React__default.createElement(Icon, {
      name: "search"
    }),
    iconPosition: iconPosition,
    fluid: true,
    onChange: handleListSearch,
    placeholder: placeholder,
    disabled: disabled
  }));
};
/**
 * Default props for the transfer list search component.
 */

TransferListSearch.defaultProps = {
  "data-componentid": "transfer-list-search",
  "data-testid": "transfer-list-search",
  disabled: false,
  isLoading: false
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Transfer list component.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */

const TransferComponent = props => {
  const {
    addItems,
    basic,
    bordered,
    compact,
    className,
    iconPosition,
    isLoading,
    removeItems,
    children,
    selectAllCheckboxLabel,
    searchPlaceholder,
    selectionComponent,
    handleUnelectedListSearch,
    handleSelectedListSearch,
    handleHeaderCheckboxChange,
    isHeaderCheckboxChecked,
    showSelectAllCheckbox,
    showListSearch,
    disabled,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("transfer-list", {
    bordered,
    compact
  }, className);
  return /*#__PURE__*/React__default.createElement(Grid, {
    className: classes
  }, React__default.Children.count(children) > 0 && /*#__PURE__*/React__default.createElement(Grid.Row, {
    columns: 3,
    className: "transfer-list-row"
  }, React__default.Children.map(children, (list, index) => {
    return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, list.props.listType === "unselected" && /*#__PURE__*/React__default.createElement(Grid.Column, {
      width: 7,
      className: "transfer-list-column transfer-list-unassigned-column"
    }, /*#__PURE__*/React__default.createElement(Segment, {
      basic: basic,
      disabled: isLoading || disabled,
      "data-componentid": `${componentId}-unselected-groups`,
      "data-testid": `${testId}-unselected-groups`,
      className: "transfer-segment"
    }, showListSearch && /*#__PURE__*/React__default.createElement(TransferListSearch, {
      "data-componentid": componentId + "-unselected-groups-search-input",
      "data-testid": testId + "-unselected-groups-search-input",
      handleListSearch: handleUnelectedListSearch,
      iconPosition: iconPosition,
      placeholder: searchPlaceholder,
      disabled: disabled
    }), !isLoading && showSelectAllCheckbox && selectionComponent && /*#__PURE__*/React__default.createElement(Checkbox, {
      className: "all-select",
      label: selectAllCheckboxLabel,
      checked: isHeaderCheckboxChecked,
      onChange: handleHeaderCheckboxChange,
      disabled: isLoading || disabled
    }), /*#__PURE__*/React__default.createElement(Segment, {
      className: "transfer-list-segment",
      disabled: disabled
    }, list))), index === 0 && !selectionComponent && /*#__PURE__*/React__default.createElement(Grid.Column, {
      verticalAlign: "middle",
      width: 1,
      className: "transfer-list-button-column"
    }, /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Button$1, {
      "data-componentid": `${componentId}-unselected-groups-add-button`,
      "data-testid": `${testId}-unselected-groups-add-button`,
      type: "button",
      basic: true,
      size: "mini",
      onClick: addItems,
      disabled: disabled
    }, /*#__PURE__*/React__default.createElement(Icon, {
      name: "chevron right"
    }))), /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Button$1, {
      "data-componentid": componentId + "-unselected-groups-remove-button",
      "data-testid": testId + "-unselected-groups-remove-button",
      type: "button",
      basic: true,
      size: "mini",
      onClick: removeItems,
      disabled: disabled
    }, /*#__PURE__*/React__default.createElement(Icon, {
      name: "chevron left"
    })))), list.props.listType === "selected" && /*#__PURE__*/React__default.createElement(Grid.Column, {
      width: 7,
      className: "transfer-list-column transfer-list-assigned-column"
    }, /*#__PURE__*/React__default.createElement(Segment, {
      basic: basic,
      disabled: isLoading || disabled,
      "data-componentid": `${componentId}-selected-groups`,
      "data-testid": `${testId}-selected-groups`,
      className: "transfer-segment"
    }, /*#__PURE__*/React__default.createElement(TransferListSearch, {
      "data-componentid": `${componentId}-selected-groups-search-input`,
      "data-testid": `${testId}-selected-groups-search-input`,
      handleListSearch: handleSelectedListSearch,
      iconPosition: iconPosition,
      placeholder: searchPlaceholder,
      disabled: disabled
    }), /*#__PURE__*/React__default.createElement(Segment, {
      className: "transfer-list-segment",
      disabled: disabled
    }, list))));
  })));
};
/**
 * Default props for the transfer component.
 */

TransferComponent.defaultProps = {
  basic: false,
  bordered: true,
  "data-componentid": "transfer-component",
  "data-testid": "transfer-component",
  disabled: false,
  isLoading: false,
  selectAllCheckboxLabel: "Select all",
  showListSearch: true
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Transfer list component.
 *
 * @param props - Props injected to the component.
 * @returns
 */

const TransferList = props => {
  const {
    children,
    listHeaders,
    isListEmpty,
    handleHeaderCheckboxChange,
    isHeaderCheckboxChecked,
    emptyPlaceholderContent,
    selectionComponent,
    isLoading,
    emptyPlaceholderDefaultContent,
    disabled,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, !isListEmpty ? isLoading ? /*#__PURE__*/React__default.createElement(ContentLoader, null) : /*#__PURE__*/React__default.createElement(Table, null, listHeaders instanceof Array && /*#__PURE__*/React__default.createElement(Table.Header, null, /*#__PURE__*/React__default.createElement(Table.Row, null, !selectionComponent && /*#__PURE__*/React__default.createElement(Table.HeaderCell, null, /*#__PURE__*/React__default.createElement(Checkbox, {
    "data-componentid": componentId,
    "data-testid": testId,
    checked: isHeaderCheckboxChecked,
    onChange: handleHeaderCheckboxChange,
    disabled: disabled
  })), listHeaders === null || listHeaders === void 0 ? void 0 : listHeaders.map((header, index) => {
    return /*#__PURE__*/React__default.createElement(Table.HeaderCell, {
      key: index
    }, /*#__PURE__*/React__default.createElement("strong", null, header));
  }))), /*#__PURE__*/React__default.createElement(Table.Body, null, children)) :
  /*#__PURE__*/

  /**
   * TODO : React Components should not depend on the product
   * locale bundles.
   * Issue to track. {@link https://github.com/wso2/product-is/issues/10693}
   */
  React__default.createElement("div", {
    className: "empty-placeholder-center"
  }, /*#__PURE__*/React__default.createElement(EmptyPlaceholder, {
    subtitle: [emptyPlaceholderContent ? emptyPlaceholderContent : emptyPlaceholderDefaultContent ? emptyPlaceholderDefaultContent : "There are no items in this list at the moment."],
    "data-componentid": `${componentId}-placeholder`,
    "data-testid": `${testId}-placeholder`
  })));
};
/**
 * Default props for the transfer list component.
 */

TransferList.defaultProps = {
  "data-componentid": "transfer-list",
  "data-testid": "transfer-list",
  disabled: false
};

/**
 * Transfer list item component.
 *
 * @param props - Props injected to the component.
 *
 * @returns
 */

const TransferListItem = props => {
  const {
    listItem,
    listItemId,
    listItemIndex,
    listItemTypeLabel,
    isItemChecked,
    handleItemChange,
    handleItemClick,
    showSecondaryActions,
    handleOpenPermissionModal,
    showListSubItem,
    listSubItem,
    readOnly,
    disabled,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;

  const resolveDataTestID = () => {
    let listItemValue = "";

    if (typeof listItem === "string") {
      listItemValue = listItem;
    } else {
      listItemValue = listItem.listItemValue;
    }

    return (listItemValue === null || listItemValue === void 0 ? void 0 : listItemValue.split(" ").length) > 0 ? listItemValue === null || listItemValue === void 0 ? void 0 : listItemValue.replace(" ", "-") : listItemValue;
  };

  return /*#__PURE__*/React__default.createElement(Table.Row, {
    key: listItemIndex
  }, /*#__PURE__*/React__default.createElement(Table.Cell, {
    id: listItemId,
    collapsing: true
  }, /*#__PURE__*/React__default.createElement(Checkbox, {
    "data-componentid": `${componentId}-${resolveDataTestID()}-checkbox`,
    "data-testid": `${testId}-${resolveDataTestID()}-checkbox`,
    checked: isItemChecked,
    onChange: handleItemChange,
    onClick: handleItemClick,
    readOnly: readOnly,
    disabled: disabled
  })), listItemTypeLabel && /*#__PURE__*/React__default.createElement(Table.Cell, {
    collapsing: true,
    key: listItemIndex
  }, /*#__PURE__*/React__default.createElement(Label, {
    color: listItemTypeLabel.labelColor,
    content: listItemTypeLabel.labelText,
    size: "mini",
    className: listItemTypeLabel.name
  })), showListSubItem ? /*#__PURE__*/React__default.createElement(Table.Cell, {
    id: listItemId
  }, typeof listItem === "string" ? /*#__PURE__*/React__default.createElement("div", null, listItem) : listItem.listItemElement, /*#__PURE__*/React__default.createElement("div", {
    className: "transfer-list-sub-content"
  }, listSubItem)) : /*#__PURE__*/React__default.createElement(Table.Cell, {
    id: listItemId
  }, typeof listItem === "string" ? /*#__PURE__*/React__default.createElement("div", null, listItem) : listItem.listItemElement), showSecondaryActions && /*#__PURE__*/React__default.createElement(Table.Cell, {
    collapsing: true
  }, /*#__PURE__*/React__default.createElement(Popup, {
    disabled: disabled,
    inverted: true,
    basic: true,
    content: "View permissions",
    trigger: /*#__PURE__*/React__default.createElement(Icon, {
      "data-componentid": `${componentId}-${resolveDataTestID()}-icon`,
      "data-testid": `${testId}-${resolveDataTestID()}-icon`,
      color: "grey",
      name: "key",
      onClick: handleOpenPermissionModal
    })
  })));
};
/**
 * Default props for the transfer list item component.
 */

TransferListItem.defaultProps = {
  "data-componentid": "transfer-list-item",
  "data-testid": "transfer-list-item",
  disabled: false,
  showListSubItem: false
};

const createRenderer = render => props => {
  const {
    input,
    type,
    label,
    placeholder,
    fieldClass,
    meta,
    selectOptions,
    checkboxLabel,
    componentClass,
    disabled,
    onLabel,
    offLabel,
    children,
    fieldOptions
  } = props,
        rest = __rest(props, ["input", "type", "label", "placeholder", "fieldClass", "meta", "selectOptions", "checkboxLabel", "componentClass", "disabled", "onLabel", "offLabel", "children", "fieldOptions"]);

  return render(input, label, fieldClass, placeholder, type, selectOptions, meta, checkboxLabel, componentClass, disabled, onLabel, offLabel, children, fieldOptions, rest);
};

createRenderer.defaultProps = {
  checkboxLabel: null,
  componentClass: null,
  disabled: false,
  fieldClass: null,
  label: null,
  meta: {},
  offLabel: null,
  onLabel: null,
  placeholder: null,
  required: false,
  selectOptions: []
};
const RenderInput = createRenderer((input, label, fieldClass, placeholder, type, selectOptions, meta, checkboxLabel, componentClass, disabled, onLabel, offLabel, children, fieldOptions, rest) => {
  return /*#__PURE__*/React__default.createElement(Form.Input, Object.assign({}, input, {
    className: fieldClass,
    placeholder: placeholder,
    type: type,
    disabled: disabled,
    label: label,
    error: meta.touched && (meta.error && {
      content: meta.error,
      pointing: "above"
    } || meta.warning && {
      content: meta.warning,
      pointing: "above"
    })
  }, rest));
});
const RenderToggle = createRenderer((input, label, fieldClass, placeholder, type, selectOptions, meta, checkboxLabel, componentClass, disabled, onLabel, offLabel, children, fieldOptions, rest) => {
  const {
    value,
    onChange
  } = input,
        inputRest = __rest(input, ["value", "onChange"]);

  return /*#__PURE__*/React__default.createElement(Form.Checkbox, Object.assign({}, inputRest, {
    className: fieldClass,
    placeholder: placeholder,
    checked: !!value,
    onClick: (event, data) => onChange(data.checked),
    label: label,
    error: meta.touched && (meta.error && {
      content: meta.error,
      pointing: "left"
    } || meta.warning && {
      content: meta.warning,
      pointing: "left"
    }),
    toggle: true
  }, rest));
});
const RenderCheckBox = createRenderer((input, label, fieldClass, placeholder, type, selectOptions, meta, checkboxLabel, componentClass, disabled, onLabel, offLabel, children, fieldOptions, rest) => {
  const {
    value,
    onChange
  } = input,
        inputRest = __rest(input, ["value", "onChange"]);

  return /*#__PURE__*/React__default.createElement(Form.Checkbox, Object.assign({}, inputRest, {
    className: fieldClass,
    componentClass: componentClass,
    placeholder: placeholder,
    checked: !!value,
    onClick: (event, data) => onChange(data.checked),
    label: label,
    error: meta.touched && (meta.error && {
      content: meta.error,
      pointing: "left"
    } || meta.warning && {
      content: meta.warning,
      pointing: "left"
    })
  }, rest));
});

var tryToString = tryToString$6;

var $TypeError = TypeError;

var deletePropertyOrThrow$1 = function (O, P) {
  if (!delete O[P]) throw $TypeError('Cannot delete property ' + tryToString(P) + ' of ' + tryToString(O));
};

var $$2 = _export;
var uncurryThis$3 = functionUncurryThis;
var aCallable = aCallable$a;
var toObject$1 = toObject$a;
var lengthOfArrayLike$1 = lengthOfArrayLike$a;
var deletePropertyOrThrow = deletePropertyOrThrow$1;
var toString$2 = toString$d;
var fails$1 = fails$z;
var internalSort = arraySort$1;
var arrayMethodIsStrict = arrayMethodIsStrict$2;
var FF = engineFfVersion;
var IE_OR_EDGE = engineIsIeOrEdge;
var V8 = engineV8Version;
var WEBKIT = engineWebkitVersion;

var test = [];
var nativeSort = uncurryThis$3(test.sort);
var push$3 = uncurryThis$3(test.push);

// IE8-
var FAILS_ON_UNDEFINED = fails$1(function () {
  test.sort(undefined);
});
// V8 bug
var FAILS_ON_NULL = fails$1(function () {
  test.sort(null);
});
// Old WebKit
var STRICT_METHOD = arrayMethodIsStrict('sort');

var STABLE_SORT = !fails$1(function () {
  // feature detection can be too slow, so check engines versions
  if (V8) return V8 < 70;
  if (FF && FF > 3) return;
  if (IE_OR_EDGE) return true;
  if (WEBKIT) return WEBKIT < 603;

  var result = '';
  var code, chr, value, index;

  // generate an array with more 512 elements (Chakra and old V8 fails only in this case)
  for (code = 65; code < 76; code++) {
    chr = String.fromCharCode(code);

    switch (code) {
      case 66: case 69: case 70: case 72: value = 3; break;
      case 68: case 71: value = 4; break;
      default: value = 2;
    }

    for (index = 0; index < 47; index++) {
      test.push({ k: chr + index, v: value });
    }
  }

  test.sort(function (a, b) { return b.v - a.v; });

  for (index = 0; index < test.length; index++) {
    chr = test[index].k.charAt(0);
    if (result.charAt(result.length - 1) !== chr) result += chr;
  }

  return result !== 'DGBEFHACIJK';
});

var FORCED = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD || !STABLE_SORT;

var getSortCompare = function (comparefn) {
  return function (x, y) {
    if (y === undefined) return -1;
    if (x === undefined) return 1;
    if (comparefn !== undefined) return +comparefn(x, y) || 0;
    return toString$2(x) > toString$2(y) ? 1 : -1;
  };
};

// `Array.prototype.sort` method
// https://tc39.es/ecma262/#sec-array.prototype.sort
$$2({ target: 'Array', proto: true, forced: FORCED }, {
  sort: function sort(comparefn) {
    if (comparefn !== undefined) aCallable(comparefn);

    var array = toObject$1(this);

    if (STABLE_SORT) return comparefn === undefined ? nativeSort(array) : nativeSort(array, comparefn);

    var items = [];
    var arrayLength = lengthOfArrayLike$1(array);
    var itemsLength, index;

    for (index = 0; index < arrayLength; index++) {
      if (index in array) push$3(items, array[index]);
    }

    internalSort(items, getSortCompare(comparefn));

    itemsLength = lengthOfArrayLike$1(items);
    index = 0;

    while (index < itemsLength) array[index] = items[index++];
    while (index < arrayLength) deletePropertyOrThrow(array, index++);

    return array;
  }
});

const PasswordValidation = props => {
  const {
    minLength,
    maxLength,
    minUpperCase,
    minLowerCase,
    minNumbers,
    minSpecialChr,
    minUniqueChr,
    maxConsecutiveChr,
    password,
    translations,
    onPasswordValidate
  } = props;
  const [validationStatus] = useState(undefined);
  const lowerCaseLetters = /[a-z]/g;
  const upperCaseLetters = /[A-Z]/g;
  const numbers = /[0-9]/g;
  const chars = /[!#$%&'()*+,\-./:;<=>?@[\]^_{|}~]/g;
  const consecutive = /([^])\1+/g;
  const EMPTY_STRING = "";
  useEffect(() => {
    validate(password);
  }, [password]);
  /**
   * Validate the password.
   *
   * @param password - password.
   */

  const validate = password => {
    let _validationStatus = Object.assign({}, validationStatus);

    if (password === EMPTY_STRING) {
      _validationStatus = Object.assign(Object.assign({}, _validationStatus), {
        empty: true
      });
      onPasswordValidate(false, _validationStatus);
      return;
    }

    if (password.length >= minLength && password.length <= maxLength) {
      _validationStatus = Object.assign(Object.assign({}, _validationStatus), {
        length: true
      });
    }

    if ((minUpperCase <= 0 || password.match(upperCaseLetters) && password.match(upperCaseLetters).length >= minUpperCase) && (minLowerCase <= 0 || password.match(lowerCaseLetters) && password.match(lowerCaseLetters).length >= minLowerCase)) {
      _validationStatus = Object.assign(Object.assign({}, _validationStatus), {
        case: true
      });
    }

    if (minNumbers <= 0 || password.match(numbers) && password.match(numbers).length >= minNumbers) {
      _validationStatus = Object.assign(Object.assign({}, _validationStatus), {
        numbers: true
      });
    }

    if (minSpecialChr <= 0 || password.match(chars) && password.match(chars).length >= minSpecialChr) {
      _validationStatus = Object.assign(Object.assign({}, _validationStatus), {
        specialChr: true
      });
    }

    const unique = password.split("");
    const set = new Set(unique);

    if (minUniqueChr <= 0 || set.size >= minUniqueChr) {
      _validationStatus = Object.assign(Object.assign({}, _validationStatus), {
        uniqueChr: true
      });
    }

    let _consValid = true;

    if (password.match(consecutive) && password.match(consecutive).length > 0) {
      const largest = password.match(consecutive).sort(function (a, b) {
        return b.length - a.length;
      })[0];

      if (maxConsecutiveChr >= 1 && largest.length > maxConsecutiveChr) {
        _consValid = false;
      }
    }

    if (_consValid) {
      _validationStatus = Object.assign(Object.assign({}, _validationStatus), {
        consecutiveChr: true
      });
    } // isValid if all the attr in the object are true and not empty.


    const isValid = !_validationStatus.empty && _validationStatus.length && _validationStatus.numbers && _validationStatus.case && _validationStatus.specialChr && _validationStatus.uniqueChr && _validationStatus.consecutiveChr; // _validationStatus pass the original for more finegrained control from outside

    onPasswordValidate(isValid, _validationStatus);
    return;
  };
  /**
   * Returns Icon Props which are needed to set state of Password Validation Icons.
   */


  const getIconProps = id => {
    const DEFAULT = {
      color: "grey",
      cssClassName: "circle thin"
    };
    const POSITIVE = {
      color: "green",
      cssClassName: "check circle"
    };
    const NEGATIVE = {
      color: "red",
      cssClassName: "remove circle"
    };

    if (id === "password-validation-length") {
      if (password === EMPTY_STRING) {
        return DEFAULT;
      } else if (password.length >= minLength && password.length <= maxLength) {
        return POSITIVE;
      } else {
        return NEGATIVE;
      }
    } else if (id === "password-validation-case") {
      if (password === EMPTY_STRING) {
        return DEFAULT;
      } else if ((minUpperCase <= 0 || password.match(upperCaseLetters) && password.match(upperCaseLetters).length >= minUpperCase) && (minLowerCase <= 0 || password.match(lowerCaseLetters) && password.match(lowerCaseLetters).length >= minLowerCase)) {
        return POSITIVE;
      } else {
        return NEGATIVE;
      }
    } else if (id === "password-validation-number") {
      if (password === EMPTY_STRING) {
        return DEFAULT;
      } else if (password.match(numbers) && password.match(numbers).length >= minNumbers) {
        return POSITIVE;
      } else {
        return NEGATIVE;
      }
    } else if (id === "password-validation-chars") {
      if (password === EMPTY_STRING) {
        return DEFAULT;
      } else if (password.match(chars) && password.match(chars).length >= minSpecialChr) {
        return POSITIVE;
      } else {
        return NEGATIVE;
      }
    } else if (id === "password-validation-unique-chars") {
      const unique = password.split("");
      const set = new Set(unique);

      if (password === EMPTY_STRING) {
        return DEFAULT;
      } else if (set.size >= minUniqueChr) {
        return POSITIVE;
      } else {
        return NEGATIVE;
      }
    } else if (id === "password-validation-cons-chars") {
      let valid = true;

      if (password.match(consecutive) && password.match(consecutive).length > 0) {
        const largest = password.match(consecutive).sort(function (a, b) {
          return b.length - a.length;
        })[0];

        if (maxConsecutiveChr >= 1 && largest.length > maxConsecutiveChr) {
          valid = false;
        }
      }

      if (password === EMPTY_STRING) {
        return DEFAULT;
      } else if (valid) {
        return POSITIVE;
      } else {
        return NEGATIVE;
      }
    }
  };

  return /*#__PURE__*/React__default.createElement("div", null, (minLength > 0 || maxLength > 0) && /*#__PURE__*/React__default.createElement("div", {
    className: "password-policy-description"
  }, /*#__PURE__*/React__default.createElement(Icon, {
    id: "password-validation-length",
    className: getIconProps("password-validation-length").cssClassName,
    color: getIconProps("password-validation-length").color,
    inverted: true
  }), /*#__PURE__*/React__default.createElement("p", null, translations.length)), (minUpperCase > 0 || minLowerCase > 0) && /*#__PURE__*/React__default.createElement("div", {
    className: "password-policy-description"
  }, /*#__PURE__*/React__default.createElement(Icon, {
    id: "password-validation-case",
    className: getIconProps("password-validation-case").cssClassName,
    color: getIconProps("password-validation-case").color,
    inverted: true
  }), /*#__PURE__*/React__default.createElement("p", null, translations.case)), minNumbers > 0 && /*#__PURE__*/React__default.createElement("div", {
    className: "password-policy-description"
  }, /*#__PURE__*/React__default.createElement(Icon, {
    id: "password-validation-number",
    className: getIconProps("password-validation-number").cssClassName,
    color: getIconProps("password-validation-number").color,
    inverted: true
  }), /*#__PURE__*/React__default.createElement("p", null, translations.numbers)), minSpecialChr > 0 && /*#__PURE__*/React__default.createElement("div", {
    className: "password-policy-description"
  }, /*#__PURE__*/React__default.createElement(Icon, {
    id: "password-validation-chars",
    className: getIconProps("password-validation-chars").cssClassName,
    color: getIconProps("password-validation-chars").color,
    inverted: true
  }), /*#__PURE__*/React__default.createElement("p", null, translations.specialChr)), minUniqueChr > 0 && /*#__PURE__*/React__default.createElement("div", {
    className: "password-policy-description"
  }, /*#__PURE__*/React__default.createElement(Icon, {
    id: "password-validation-chars",
    className: getIconProps("password-validation-unique-chars").cssClassName,
    color: getIconProps("password-validation-unique-chars").color,
    inverted: true
  }), /*#__PURE__*/React__default.createElement("p", null, translations.uniqueChr)), maxConsecutiveChr > 0 && /*#__PURE__*/React__default.createElement("div", {
    className: "password-policy-description"
  }, /*#__PURE__*/React__default.createElement(Icon, {
    id: "password-validation-chars",
    className: getIconProps("password-validation-cons-chars").cssClassName,
    color: getIconProps("password-validation-cons-chars").color,
    inverted: true
  }), /*#__PURE__*/React__default.createElement("p", null, translations.consecutiveChr)));
};
/**
 * Default proptypes for the page header component.
 */

PasswordValidation.defaultProps = {
  maxConsecutiveChr: 0,
  maxLength: 30,
  minLength: 8,
  minLowerCase: 0,
  minNumbers: 0,
  minSpecialChr: 0,
  minUniqueChr: 0,
  minUpperCase: 0,
  translations: {
    case: "At least one uppercase and one lowercase letters",
    consecutiveChr: "No more than one repeated character",
    length: "Must be between 8 and 30 characters",
    numbers: "At least one number",
    specialChr: "At least {minSpecialChr} of the symbols !@#$%^&*",
    uniqueChr: "At least one unique character"
  }
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Main app layout.
 * Used to render all the layouts that's being used inside the app.
 *
 * @param props - Props injected to the component.
 * @returns App layout component.
 */

const AppLayout = props => {
  const {
    children
  } = props;
  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, children);
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Base layout.
 * This layout contains the alert & top loader and can be used by any other
 * layout to inherit them.
 *
 * @param props - Props injected to the component.
 *
 * @returns the Base Layout component
 */

const BaseLayout = props => {
  const {
    alert,
    children,
    className,
    fluid,
    topLoadingBar
  } = props;
  const classes = classNames("layout", "base-layout", className);
  return /*#__PURE__*/React__default.createElement(Container, {
    className: classes,
    fluid: fluid
  }, topLoadingBar, children, alert);
};
/**
 * Default props for the base layout.
 */

BaseLayout.defaultProps = {
  fluid: true
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Auth layout.
 * Used to render the authentication related components.
 *
 * @param props - Props injected to the component.
 *
 * @returns the Auth layout component
 */

const AuthLayout = props => {
  const {
    children,
    className,
    fluid
  } = props;
  const classes = classNames("layout", "auth-layout", {
    ["fluid-auth-layout"]: fluid
  }, className);
  return /*#__PURE__*/React__default.createElement(Container, {
    className: classes,
    fluid: fluid
  }, children);
};
/**
 * Default props for the auth layout.
 */

AuthLayout.defaultProps = {
  fluid: true
};

/**
 * Copyright (c) 2019, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Default layout.
 *
 * @param props - Props injected to the component.
 * @returns Default Layout component.
 */

const DefaultLayout = props => {
  const {
    alert,
    children,
    className,
    desktopContentTopSpacing,
    footer,
    footerHeight,
    fluid,
    header,
    headerHeight,
    topLoadingBar
  } = props;
  const classes = classNames("layout", "default-layout", {
    ["fluid-default-layout"]: fluid
  }, className);
  const mainLayoutStyles = {
    paddingBottom: `${footerHeight}px`,
    paddingTop: `${headerHeight}px`
  };
  const mainContentStyle = {
    minHeight: `calc(100vh - ${headerHeight + footerHeight}px`,
    paddingTop: `${desktopContentTopSpacing}px`
  };
  return /*#__PURE__*/React__default.createElement(BaseLayout, {
    alert: alert,
    topLoadingBar: topLoadingBar
  }, /*#__PURE__*/React__default.createElement(Container, {
    fluid: fluid,
    className: classes
  }, header, /*#__PURE__*/React__default.createElement("div", {
    style: mainLayoutStyles,
    className: "layout-content-wrapper"
  }, /*#__PURE__*/React__default.createElement("div", {
    style: mainContentStyle,
    className: "layout-content"
  }, children)), footer));
};
/**
 * Default props for the default layout.
 */

DefaultLayout.defaultProps = {
  fluid: true
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Error layout.
 *
 * @param props - Props injected to the component.
 *
 * @returns the Error Layout component
 */

const ErrorLayout = props => {
  const {
    children,
    className,
    fluid
  } = props;
  const classes = classNames("layout", "error-layout", {
    ["fluid-error-layout"]: fluid
  }, className);
  return /*#__PURE__*/React__default.createElement(Container, {
    className: classes
  }, /*#__PURE__*/React__default.createElement(Divider, {
    className: "x4",
    hidden: true
  }), children, /*#__PURE__*/React__default.createElement(Divider, {
    className: "x3",
    hidden: true
  }));
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Full screen layout.
 * Used to render features which has to be rendered in full screen mode.
 *
 * @param props - Props injected to the component.
 *
 * @returns the full screen layout component
 */

const FullScreenLayout = props => {
  const {
    children
  } = props;
  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, children);
};

// `SameValue` abstract operation
// https://tc39.es/ecma262/#sec-samevalue
// eslint-disable-next-line es-x/no-object-is -- safe
var sameValue$1 = Object.is || function is(x, y) {
  // eslint-disable-next-line no-self-compare -- NaN check
  return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;
};

var call$2 = functionCall;
var fixRegExpWellKnownSymbolLogic = fixRegexpWellKnownSymbolLogic;
var anObject$2 = anObject$k;
var isNullOrUndefined = isNullOrUndefined$8;
var requireObjectCoercible = requireObjectCoercible$9;
var sameValue = sameValue$1;
var toString$1 = toString$d;
var getMethod = getMethod$7;
var regExpExec = regexpExecAbstract;

// @@search logic
fixRegExpWellKnownSymbolLogic('search', function (SEARCH, nativeSearch, maybeCallNative) {
  return [
    // `String.prototype.search` method
    // https://tc39.es/ecma262/#sec-string.prototype.search
    function search(regexp) {
      var O = requireObjectCoercible(this);
      var searcher = isNullOrUndefined(regexp) ? undefined : getMethod(regexp, SEARCH);
      return searcher ? call$2(searcher, regexp, O) : new RegExp(regexp)[SEARCH](toString$1(O));
    },
    // `RegExp.prototype[@@search]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@search
    function (string) {
      var rx = anObject$2(this);
      var S = toString$1(string);
      var res = maybeCallNative(nativeSearch, rx, S);

      if (res.done) return res.value;

      var previousLastIndex = rx.lastIndex;
      if (!sameValue(previousLastIndex, 0)) rx.lastIndex = 0;
      var result = regExpExec(rx, S);
      if (!sameValue(rx.lastIndex, previousLastIndex)) rx.lastIndex = previousLastIndex;
      return result === null ? -1 : result.index;
    }
  ];
});

/**
 * Grid layout component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the React component for Grid layout.
 */

const GridLayout = props => {
  const {
    isPaginating,
    search,
    searchPosition,
    children,
    className,
    isLoading,
    leftActionPanel,
    paginate,
    rightActionPanel,
    showTopActionPanel,
    translations,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const classes = classNames("layout", "grid-layout", className);
  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, !isLoading ? /*#__PURE__*/React__default.createElement(Fragment, null, showTopActionPanel && /*#__PURE__*/React__default.createElement(Fragment, null, /*#__PURE__*/React__default.createElement("div", {
    className: "top-action-panel",
    "data-componentid": `${componentId}-top-action-panel`,
    "data-testid": `${testId}-top-action-panel`
  }, /*#__PURE__*/React__default.createElement(Grid, null, /*#__PURE__*/React__default.createElement(Grid.Row, null, /*#__PURE__*/React__default.createElement(Grid.Column, {
    mobile: 16,
    tablet: 8,
    computer: 8
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "left-aligned actions"
  }, searchPosition === "left" && search, leftActionPanel)), /*#__PURE__*/React__default.createElement(Grid.Column, {
    mobile: 16,
    tablet: 8,
    computer: 8
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "actions right-aligned"
  }, searchPosition === "right" && search, rightActionPanel))))), /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  })), paginate ? /*#__PURE__*/React__default.createElement(Visibility, {
    once: true,
    onBottomVisible: () => paginate()
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "list-container"
  }, children), isPaginating && /*#__PURE__*/React__default.createElement("div", {
    className: "pagination-loader-container"
  }, /*#__PURE__*/React__default.createElement(Loader, {
    active: true,
    indeterminate: true,
    size: "small",
    inline: "centered"
  }, (translations === null || translations === void 0 ? void 0 : translations.loading) || "Loading..."))) : /*#__PURE__*/React__default.createElement("div", {
    className: "list-container"
  }, children)) : /*#__PURE__*/React__default.createElement(Loader, {
    active: true,
    inline: "centered"
  }));
};
/**
 * Default props for the component.
 */

GridLayout.defaultProps = {
  "data-componentid": "grid-layout",
  "data-testid": "grid-layout",
  searchPosition: "left",
  showTopActionPanel: true
};

/**
 * Help panel layout.
 *
 * @param props - Props injected to the component.
 *
 * @returns the Help panel layout component.
 */

const HelpPanelLayout = props => {
  const sidebarRef = useRef();
  const contentRef = useRef();

  const {
    children,
    className,
    closeButtonTooltip,
    enabled,
    icons,
    onHelpPanelPinToggle,
    onHelpPanelVisibilityChange,
    isPinned,
    pinButtonTooltip,
    sidebarDirection,
    tabs,
    activeIndex,
    unpinButtonTooltip,
    visible
  } = props,
        rest = __rest(props, ["children", "className", "closeButtonTooltip", "enabled", "icons", "onHelpPanelPinToggle", "onHelpPanelVisibilityChange", "isPinned", "pinButtonTooltip", "sidebarDirection", "tabs", "activeIndex", "unpinButtonTooltip", "visible"]);

  const [helpSidebarVisibility, setHelpSidebarVisibility] = useState(false);
  const [helpPanelTabsActiveIndex, setHelpPanelTabsActiveIndex] = useState(0);
  const layoutClasses = classNames("layout", "help-panel-layout", className);
  const layoutContentClasses = classNames("layout-content");
  useEffect(() => {
    if (activeIndex == undefined || activeIndex == 0) {
      return;
    }

    setHelpPanelTabsActiveIndex(activeIndex);
  }, [activeIndex]);
  useEffect(() => {
    var _a, _b;

    if (!((_a = sidebarRef === null || sidebarRef === void 0 ? void 0 : sidebarRef.current) === null || _a === void 0 ? void 0 : _a.clientWidth)) {
      return;
    }

    contentRef.current.style.width = "calc(100% - " + ((_b = sidebarRef === null || sidebarRef === void 0 ? void 0 : sidebarRef.current) === null || _b === void 0 ? void 0 : _b.clientWidth) + "px)";
  }, [helpSidebarVisibility]);
  useEffect(() => {
    if (visible === undefined) {
      return;
    }

    setHelpSidebarVisibility(visible);
  }, [visible]);
  useEffect(() => {
    if (isPinned) {
      setHelpSidebarVisibility(true);
    }
  }, [isPinned]);
  /**
   * Handles sidebar mini item click event.
   *
   * @param item - Clicked item.
   */

  const handleSidebarMiniItemClick = item => {
    getFilteredHelpPanelTabs().forEach((pane, index) => {
      if (pane.heading === item) {
        setHelpPanelTabsActiveIndex(index);
      }
    });
    setHelpSidebarVisibility(true);
    onHelpPanelVisibilityChange(true);
  };
  /**
   * Filter the help panel tabs and remove hidden tabs.
   *
   * @returns an array of Modified tabs.
   */


  const getFilteredHelpPanelTabs = () => {
    return tabs.filter(tab => !tab.hidden);
  };
  /**
   * Handles the help panel pin toggle action.
   */


  const handleHelpPanelPinToggle = () => {
    onHelpPanelPinToggle(); // If developer unpin the help panel, we are closing the help panel also.

    if (isPinned) {
      setHelpSidebarVisibility(!helpSidebarVisibility);
      onHelpPanelVisibilityChange(!helpSidebarVisibility);
    }
  };
  /**
   * Handles the help panel toggle action.
   */


  const handleHelpPanelToggle = () => {
    setHelpSidebarVisibility(!helpSidebarVisibility);
    onHelpPanelVisibilityChange(!helpSidebarVisibility);
  };

  return enabled ? /*#__PURE__*/React__default.createElement(Sidebar.Pushable, {
    className: layoutClasses
  }, /*#__PURE__*/React__default.createElement(HelpPanel, Object.assign({
    as: Menu,
    direction: sidebarDirection,
    visible: helpSidebarVisibility,
    ref: sidebarRef,
    actions: [{
      icon: isPinned ? icons.pin : icons.unpin,
      onClick: handleHelpPanelPinToggle,
      tooltip: isPinned ? unpinButtonTooltip : pinButtonTooltip
    }, {
      icon: icons.close,
      onClick: handleHelpPanelToggle,
      tooltip: closeButtonTooltip
    }],
    tabsActiveIndex: helpPanelTabsActiveIndex,
    tabs: getFilteredHelpPanelTabs(),
    onSidebarMiniItemClick: handleSidebarMiniItemClick,
    onSidebarToggle: handleHelpPanelToggle
  }, rest)), /*#__PURE__*/React__default.createElement(Sidebar.Pusher, {
    className: layoutContentClasses
  }, /*#__PURE__*/React__default.createElement("div", {
    ref: contentRef
  }, children))) : /*#__PURE__*/React__default.createElement(React__default.Fragment, null, children);
};
/**
 * Default props for the sidebar pusher layout.
 */

HelpPanelLayout.defaultProps = {
  animation: "overlay",
  bordered: "left",
  enabled: true,
  icon: "labeled",
  pinButtonTooltip: "Pin",
  raised: false,
  showLabelsOnSidebarMini: false,
  showTooltipsOnActionBar: true,
  showTooltipsOnSidebarMini: true,
  sidebarMiniEnabled: true,
  unpinButtonTooltip: "Unpin",
  vertical: true
};

/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Dashboard layout.
 *
 * @param props - Props injected to the component.
 * @returns Dashboard Layout component.
 */

const DashboardLayout = props => {
  const {
    alert,
    children,
    className,
    footer,
    fluid,
    header,
    sidePanel,
    topLoadingBar
  } = props;
  const classes = classNames("layout", "dashboard-layout", {
    ["fluid-dashboard-layout"]: fluid
  }, className);
  return /*#__PURE__*/React__default.createElement(BaseLayout, {
    alert: alert,
    topLoadingBar: topLoadingBar
  }, /*#__PURE__*/React__default.createElement("div", {
    className: classes
  }, header, /*#__PURE__*/React__default.cloneElement(sidePanel, {
    children: children
  }), footer));
};
/**
 * Default props for the dashboard layout.
 */

DashboardLayout.defaultProps = {
  fluid: true
};

/**
 * List layout.
 *
 * @param props - Props injected to the component.
 *
 * @returns React element.
 */

const ListLayout = props => {
  const {
    advancedSearch,
    advancedSearchPosition,
    children,
    className,
    defaultListItemLimit,
    disableLeftActionPanel,
    disableRightActionPanel,
    isLoading,
    leftActionPanel,
    minimalPagination,
    onItemsPerPageDropdownChange,
    onPageChange,
    onSortStrategyChange,
    onSortOrderChange,
    paginationOptions,
    resetPagination,
    rightActionPanel,
    showPagination,
    showPaginationPageLimit,
    showTopActionPanel,
    sortOptions,
    sortStrategy,
    totalListSize,
    totalPages,
    activePage,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId
  } = props;
  const [isAscending, setIsAscending] = useState(true);
  const classes = classNames("layout", "list-layout", className);
  return /*#__PURE__*/React__default.createElement("div", {
    className: classes,
    "data-componentid": componentId,
    "data-testid": testId
  }, showTopActionPanel && /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement("div", {
    className: "top-action-panel",
    "data-componentid": `${componentId}-top-action-panel`,
    "data-testid": `${testId}-top-action-panel`
  }, /*#__PURE__*/React__default.createElement(Grid, null, /*#__PURE__*/React__default.createElement(Grid.Row, null, !disableLeftActionPanel ? /*#__PURE__*/React__default.createElement(Grid.Column, {
    mobile: 16,
    tablet: 16,
    computer: disableRightActionPanel ? 16 : 8
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "left-aligned actions"
  }, advancedSearchPosition === "left" && advancedSearch, leftActionPanel)) : null, !disableRightActionPanel ? /*#__PURE__*/React__default.createElement(Grid.Column, {
    mobile: 16,
    tablet: 16,
    computer: disableLeftActionPanel ? 16 : 8
  }, /*#__PURE__*/React__default.createElement("div", {
    className: "actions right-aligned"
  }, advancedSearchPosition === "right" && advancedSearch, rightActionPanel, sortOptions && sortStrategy && onSortStrategyChange && onSortOrderChange && /*#__PURE__*/React__default.createElement("div", {
    className: "sort-list"
  }, /*#__PURE__*/React__default.createElement(Dropdown, {
    onChange: onSortStrategyChange,
    options: sortOptions,
    placeholder: "Sort by",
    selection: true,
    value: (sortOptions === null || sortOptions === void 0 ? void 0 : sortOptions.length) === 1 ? sortOptions[0].value : sortStrategy.value,
    disabled: (sortOptions === null || sortOptions === void 0 ? void 0 : sortOptions.length) === 1,
    "data-componentid": `${componentId}-sort`,
    "data-testid": `${testId}-sort`
  }), /*#__PURE__*/React__default.createElement(Button$1, {
    "data-tooltip": isAscending ? "Sort in the descending order" : "Sort in the ascending order",
    "data-position": "top right",
    "data-inverted": "",
    icon: true,
    onClick: () => {
      setIsAscending(!isAscending);
      onSortOrderChange(!isAscending);
    },
    className: "left-aligned-action"
  }, /*#__PURE__*/React__default.createElement(Icon, {
    name: isAscending ? "sort amount down" : "sort amount up"
  }))))) : null))), /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  })), /*#__PURE__*/React__default.createElement("div", {
    className: "list-container"
  }, isLoading ? /*#__PURE__*/React__default.createElement(DataTable, {
    isLoading: true,
    loadingStateOptions: {
      count: defaultListItemLimit !== null && defaultListItemLimit !== void 0 ? defaultListItemLimit : UIConstants.DEFAULT_RESOURCE_LIST_ITEM_LIMIT,
      imageType: "square"
    },
    columns: [],
    data: [],
    onRowClick: null
  }) : children, showPagination ? /*#__PURE__*/React__default.createElement(Pagination, Object.assign({
    minimal: minimalPagination,
    showItemsPerPageDropdown: showPaginationPageLimit,
    "data-componentid": `${componentId}-pagination`,
    "data-testid": `${testId}-pagination`,
    resetPagination: resetPagination,
    totalListSize: totalListSize,
    totalPages: totalPages,
    onPageChange: onPageChange,
    onItemsPerPageDropdownChange: onItemsPerPageDropdownChange,
    hidden: totalListSize === 0 || totalListSize === undefined
  }, paginationOptions, {
    activePage: activePage
  })) : null));
};
/**
 * Default props for the list layout.
 */

ListLayout.defaultProps = {
  advancedSearchPosition: "left",
  "data-componentid": "list-layout",
  "data-testid": "list-layout",
  disableLeftActionPanel: false,
  disableRightActionPanel: false,
  minimalPagination: true,
  showPagination: false,
  showPaginationPageLimit: true,
  showTopActionPanel: true
};

/**
 * Page layout.
 *
 * @param props - Props injected to the component.
 *
 * @returns Page Layout
 */

const PageLayout = props => {
  const {
    action,
    children,
    contentTopMargin,
    className,
    ["data-componentid"]: componentId,
    ["data-testid"]: testId,
    padded,
    pageTitle,
    componentAbovePageHeader,
    isLoading
  } = props,
        rest = __rest(props, ["action", "children", "contentTopMargin", "className", "data-componentid", "data-testid", "padded", "pageTitle", "componentAbovePageHeader", "isLoading"]);

  const layoutClasses = classNames("layout", "page-layout", className);
  const layoutContentClasses = classNames("layout-content", {
    padded
  });
  return /*#__PURE__*/React__default.createElement(React__default.Fragment, null, /*#__PURE__*/React__default.createElement(Helmet, null, /*#__PURE__*/React__default.createElement("title", null, pageTitle)), /*#__PURE__*/React__default.createElement("div", {
    className: layoutClasses,
    "data-testid": testId,
    "data-componentid": componentId
  }, /*#__PURE__*/React__default.createElement("div", {
    className: layoutContentClasses
  }, componentAbovePageHeader && componentAbovePageHeader, /*#__PURE__*/React__default.createElement(PageHeader, Object.assign({
    isLoading: isLoading,
    action: action,
    "data-testid": `${testId}-page-header`,
    "data-componentid": `${componentId}-page-header`
  }, rest)), contentTopMargin && /*#__PURE__*/React__default.createElement(Divider, {
    hidden: true
  }), children)));
};
/**
 * Default props for the page layout.
 */

PageLayout.defaultProps = {
  contentTopMargin: true,
  "data-componentid": "page-layout",
  "data-testid": "page-layout",
  padded: true,
  titleTextAlign: "left"
};

/**
 * Tab Page layout.
 *
 * @param props - Props injected to the component.
 *
 * @returns Tab Page Layout
 */

const TabPageLayout = props => {
  const {
    isLoading,
    children
  } = props,
        rest = __rest(props, ["isLoading", "children"]);

  if (isLoading) {
    return /*#__PURE__*/React__default.createElement(PageLayout, Object.assign({
      isLoading: true
    }, rest), /*#__PURE__*/React__default.createElement(ResourceTab, Object.assign({
      isLoading: true
    }, rest)));
  }

  return /*#__PURE__*/React__default.createElement(PageLayout, Object.assign({}, rest), children);
};
/**
 * Default props for the tab page layout.
 */

TabPageLayout.defaultProps = {
  loadingStateOptions: {
    count: 5,
    imageType: "square"
  }
};

var charAt$2 = stringMultibyte.charAt;
var toString = toString$d;
var InternalStateModule$2 = internalState;
var defineIterator = iteratorDefine;

var STRING_ITERATOR = 'String Iterator';
var setInternalState$2 = InternalStateModule$2.set;
var getInternalState = InternalStateModule$2.getterFor(STRING_ITERATOR);

// `String.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-string.prototype-@@iterator
defineIterator(String, 'String', function (iterated) {
  setInternalState$2(this, {
    type: STRING_ITERATOR,
    string: toString(iterated),
    index: 0
  });
// `%StringIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
}, function next() {
  var state = getInternalState(this);
  var string = state.string;
  var index = state.index;
  var point;
  if (index >= string.length) return { value: undefined, done: true };
  point = charAt$2(string, index);
  state.index += point.length;
  return { value: point, done: false };
});

var fails = fails$z;
var wellKnownSymbol$1 = wellKnownSymbol$n;
var IS_PURE = isPure;

var ITERATOR$1 = wellKnownSymbol$1('iterator');

var urlConstructorDetection = !fails(function () {
  // eslint-disable-next-line unicorn/relative-url-style -- required for testing
  var url = new URL('b?a=1&b=2&c=3', 'http://a');
  var searchParams = url.searchParams;
  var result = '';
  url.pathname = 'c%20d';
  searchParams.forEach(function (value, key) {
    searchParams['delete']('b');
    result += key + value;
  });
  return (IS_PURE && !url.toJSON)
    || !searchParams.sort
    || url.href !== 'http://a/c%20d?a=1&c=3'
    || searchParams.get('c') !== '3'
    || String(new URLSearchParams('?a=1')) !== 'a=1'
    || !searchParams[ITERATOR$1]
    // throws in Edge
    || new URL('https://a@b').username !== 'a'
    || new URLSearchParams(new URLSearchParams('a=b')).get('a') !== 'b'
    // not punycoded in Edge
    || new URL('http://тест').host !== 'xn--e1aybc'
    // not escaped in Chrome 62-
    || new URL('http://a#б').hash !== '#%D0%B1'
    // fails in Chrome 66-
    || result !== 'a1c3'
    // throws in Safari
    || new URL('http://x', undefined).host !== 'x';
});

var makeBuiltIn = makeBuiltIn$3.exports;
var defineProperty = objectDefineProperty;

var defineBuiltInAccessor$1 = function (target, name, descriptor) {
  if (descriptor.get) makeBuiltIn(descriptor.get, name, { getter: true });
  if (descriptor.set) makeBuiltIn(descriptor.set, name, { setter: true });
  return defineProperty.f(target, name, descriptor);
};

var anObject$1 = anObject$k;
var iteratorClose = iteratorClose$2;

// call something on iterator step with safe closing on error
var callWithSafeIterationClosing$1 = function (iterator, fn, value, ENTRIES) {
  try {
    return ENTRIES ? fn(anObject$1(value)[0], value[1]) : fn(value);
  } catch (error) {
    iteratorClose(iterator, 'throw', error);
  }
};

var bind$2 = functionBindContext;
var call$1 = functionCall;
var toObject = toObject$a;
var callWithSafeIterationClosing = callWithSafeIterationClosing$1;
var isArrayIteratorMethod = isArrayIteratorMethod$3;
var isConstructor = isConstructor$3;
var lengthOfArrayLike = lengthOfArrayLike$a;
var createProperty = createProperty$2;
var getIterator$1 = getIterator$4;
var getIteratorMethod$1 = getIteratorMethod$5;

var $Array = Array;

// `Array.from` method implementation
// https://tc39.es/ecma262/#sec-array.from
var arrayFrom$1 = function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
  var O = toObject(arrayLike);
  var IS_CONSTRUCTOR = isConstructor(this);
  var argumentsLength = arguments.length;
  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
  var mapping = mapfn !== undefined;
  if (mapping) mapfn = bind$2(mapfn, argumentsLength > 2 ? arguments[2] : undefined);
  var iteratorMethod = getIteratorMethod$1(O);
  var index = 0;
  var length, result, step, iterator, next, value;
  // if the target is not iterable or it's an array with the default iterator - use a simple case
  if (iteratorMethod && !(this === $Array && isArrayIteratorMethod(iteratorMethod))) {
    iterator = getIterator$1(O, iteratorMethod);
    next = iterator.next;
    result = IS_CONSTRUCTOR ? new this() : [];
    for (;!(step = call$1(next, iterator)).done; index++) {
      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
      createProperty(result, index, value);
    }
  } else {
    length = lengthOfArrayLike(O);
    result = IS_CONSTRUCTOR ? new this(length) : $Array(length);
    for (;length > index; index++) {
      value = mapping ? mapfn(O[index], index) : O[index];
      createProperty(result, index, value);
    }
  }
  result.length = index;
  return result;
};

// based on https://github.com/bestiejs/punycode.js/blob/master/punycode.js
var uncurryThis$2 = functionUncurryThis;

var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1
var base = 36;
var tMin = 1;
var tMax = 26;
var skew = 38;
var damp = 700;
var initialBias = 72;
var initialN = 128; // 0x80
var delimiter = '-'; // '\x2D'
var regexNonASCII = /[^\0-\u007E]/; // non-ASCII chars
var regexSeparators = /[.\u3002\uFF0E\uFF61]/g; // RFC 3490 separators
var OVERFLOW_ERROR = 'Overflow: input needs wider integers to process';
var baseMinusTMin = base - tMin;

var $RangeError = RangeError;
var exec$1 = uncurryThis$2(regexSeparators.exec);
var floor$1 = Math.floor;
var fromCharCode = String.fromCharCode;
var charCodeAt = uncurryThis$2(''.charCodeAt);
var join$2 = uncurryThis$2([].join);
var push$2 = uncurryThis$2([].push);
var replace$2 = uncurryThis$2(''.replace);
var split$2 = uncurryThis$2(''.split);
var toLowerCase$1 = uncurryThis$2(''.toLowerCase);

/**
 * Creates an array containing the numeric code points of each Unicode
 * character in the string. While JavaScript uses UCS-2 internally,
 * this function will convert a pair of surrogate halves (each of which
 * UCS-2 exposes as separate characters) into a single code point,
 * matching UTF-16.
 */
var ucs2decode = function (string) {
  var output = [];
  var counter = 0;
  var length = string.length;
  while (counter < length) {
    var value = charCodeAt(string, counter++);
    if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
      // It's a high surrogate, and there is a next character.
      var extra = charCodeAt(string, counter++);
      if ((extra & 0xFC00) == 0xDC00) { // Low surrogate.
        push$2(output, ((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
      } else {
        // It's an unmatched surrogate; only append this code unit, in case the
        // next code unit is the high surrogate of a surrogate pair.
        push$2(output, value);
        counter--;
      }
    } else {
      push$2(output, value);
    }
  }
  return output;
};

/**
 * Converts a digit/integer into a basic code point.
 */
var digitToBasic = function (digit) {
  //  0..25 map to ASCII a..z or A..Z
  // 26..35 map to ASCII 0..9
  return digit + 22 + 75 * (digit < 26);
};

/**
 * Bias adaptation function as per section 3.4 of RFC 3492.
 * https://tools.ietf.org/html/rfc3492#section-3.4
 */
var adapt = function (delta, numPoints, firstTime) {
  var k = 0;
  delta = firstTime ? floor$1(delta / damp) : delta >> 1;
  delta += floor$1(delta / numPoints);
  while (delta > baseMinusTMin * tMax >> 1) {
    delta = floor$1(delta / baseMinusTMin);
    k += base;
  }
  return floor$1(k + (baseMinusTMin + 1) * delta / (delta + skew));
};

/**
 * Converts a string of Unicode symbols (e.g. a domain name label) to a
 * Punycode string of ASCII-only symbols.
 */
var encode = function (input) {
  var output = [];

  // Convert the input in UCS-2 to an array of Unicode code points.
  input = ucs2decode(input);

  // Cache the length.
  var inputLength = input.length;

  // Initialize the state.
  var n = initialN;
  var delta = 0;
  var bias = initialBias;
  var i, currentValue;

  // Handle the basic code points.
  for (i = 0; i < input.length; i++) {
    currentValue = input[i];
    if (currentValue < 0x80) {
      push$2(output, fromCharCode(currentValue));
    }
  }

  var basicLength = output.length; // number of basic code points.
  var handledCPCount = basicLength; // number of code points that have been handled;

  // Finish the basic string with a delimiter unless it's empty.
  if (basicLength) {
    push$2(output, delimiter);
  }

  // Main encoding loop:
  while (handledCPCount < inputLength) {
    // All non-basic code points < n have been handled already. Find the next larger one:
    var m = maxInt;
    for (i = 0; i < input.length; i++) {
      currentValue = input[i];
      if (currentValue >= n && currentValue < m) {
        m = currentValue;
      }
    }

    // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>, but guard against overflow.
    var handledCPCountPlusOne = handledCPCount + 1;
    if (m - n > floor$1((maxInt - delta) / handledCPCountPlusOne)) {
      throw $RangeError(OVERFLOW_ERROR);
    }

    delta += (m - n) * handledCPCountPlusOne;
    n = m;

    for (i = 0; i < input.length; i++) {
      currentValue = input[i];
      if (currentValue < n && ++delta > maxInt) {
        throw $RangeError(OVERFLOW_ERROR);
      }
      if (currentValue == n) {
        // Represent delta as a generalized variable-length integer.
        var q = delta;
        var k = base;
        while (true) {
          var t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
          if (q < t) break;
          var qMinusT = q - t;
          var baseMinusT = base - t;
          push$2(output, fromCharCode(digitToBasic(t + qMinusT % baseMinusT)));
          q = floor$1(qMinusT / baseMinusT);
          k += base;
        }

        push$2(output, fromCharCode(digitToBasic(q)));
        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
        delta = 0;
        handledCPCount++;
      }
    }

    delta++;
    n++;
  }
  return join$2(output, '');
};

var stringPunycodeToAscii = function (input) {
  var encoded = [];
  var labels = split$2(replace$2(toLowerCase$1(input), regexSeparators, '\u002E'), '.');
  var i, label;
  for (i = 0; i < labels.length; i++) {
    label = labels[i];
    push$2(encoded, exec$1(regexNonASCII, label) ? 'xn--' + encode(label) : label);
  }
  return join$2(encoded, '.');
};

// TODO: in core-js@4, move /modules/ dependencies to public entries for better optimization by tools like `preset-env`

var $$1 = _export;
var global$2 = global$z;
var call = functionCall;
var uncurryThis$1 = functionUncurryThis;
var DESCRIPTORS$1 = descriptors;
var USE_NATIVE_URL$1 = urlConstructorDetection;
var defineBuiltIn$1 = defineBuiltIn$d;
var defineBuiltIns = defineBuiltIns$2;
var setToStringTag$1 = setToStringTag$6;
var createIteratorConstructor = iteratorCreateConstructor;
var InternalStateModule$1 = internalState;
var anInstance$1 = anInstance$5;
var isCallable = isCallable$r;
var hasOwn$1 = hasOwnProperty_1;
var bind$1 = functionBindContext;
var classof = classof$a;
var anObject = anObject$k;
var isObject = isObject$f;
var $toString$1 = toString$d;
var create = objectCreate;
var createPropertyDescriptor = createPropertyDescriptor$6;
var getIterator = getIterator$4;
var getIteratorMethod = getIteratorMethod$5;
var validateArgumentsLength$1 = validateArgumentsLength$3;
var wellKnownSymbol = wellKnownSymbol$n;
var arraySort = arraySort$1;

var ITERATOR = wellKnownSymbol('iterator');
var URL_SEARCH_PARAMS = 'URLSearchParams';
var URL_SEARCH_PARAMS_ITERATOR = URL_SEARCH_PARAMS + 'Iterator';
var setInternalState$1 = InternalStateModule$1.set;
var getInternalParamsState = InternalStateModule$1.getterFor(URL_SEARCH_PARAMS);
var getInternalIteratorState = InternalStateModule$1.getterFor(URL_SEARCH_PARAMS_ITERATOR);
// eslint-disable-next-line es-x/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// Avoid NodeJS experimental warning
var safeGetBuiltIn = function (name) {
  if (!DESCRIPTORS$1) return global$2[name];
  var descriptor = getOwnPropertyDescriptor(global$2, name);
  return descriptor && descriptor.value;
};

var nativeFetch = safeGetBuiltIn('fetch');
var NativeRequest = safeGetBuiltIn('Request');
var Headers = safeGetBuiltIn('Headers');
var RequestPrototype = NativeRequest && NativeRequest.prototype;
var HeadersPrototype = Headers && Headers.prototype;
var RegExp$1 = global$2.RegExp;
var TypeError$2 = global$2.TypeError;
var decodeURIComponent$1 = global$2.decodeURIComponent;
var encodeURIComponent$1 = global$2.encodeURIComponent;
var charAt$1 = uncurryThis$1(''.charAt);
var join$1 = uncurryThis$1([].join);
var push$1 = uncurryThis$1([].push);
var replace$1 = uncurryThis$1(''.replace);
var shift$1 = uncurryThis$1([].shift);
var splice = uncurryThis$1([].splice);
var split$1 = uncurryThis$1(''.split);
var stringSlice$1 = uncurryThis$1(''.slice);

var plus = /\+/g;
var sequences = Array(4);

var percentSequence = function (bytes) {
  return sequences[bytes - 1] || (sequences[bytes - 1] = RegExp$1('((?:%[\\da-f]{2}){' + bytes + '})', 'gi'));
};

var percentDecode = function (sequence) {
  try {
    return decodeURIComponent$1(sequence);
  } catch (error) {
    return sequence;
  }
};

var deserialize = function (it) {
  var result = replace$1(it, plus, ' ');
  var bytes = 4;
  try {
    return decodeURIComponent$1(result);
  } catch (error) {
    while (bytes) {
      result = replace$1(result, percentSequence(bytes--), percentDecode);
    }
    return result;
  }
};

var find = /[!'()~]|%20/g;

var replacements = {
  '!': '%21',
  "'": '%27',
  '(': '%28',
  ')': '%29',
  '~': '%7E',
  '%20': '+'
};

var replacer = function (match) {
  return replacements[match];
};

var serialize = function (it) {
  return replace$1(encodeURIComponent$1(it), find, replacer);
};

var URLSearchParamsIterator = createIteratorConstructor(function Iterator(params, kind) {
  setInternalState$1(this, {
    type: URL_SEARCH_PARAMS_ITERATOR,
    iterator: getIterator(getInternalParamsState(params).entries),
    kind: kind
  });
}, 'Iterator', function next() {
  var state = getInternalIteratorState(this);
  var kind = state.kind;
  var step = state.iterator.next();
  var entry = step.value;
  if (!step.done) {
    step.value = kind === 'keys' ? entry.key : kind === 'values' ? entry.value : [entry.key, entry.value];
  } return step;
}, true);

var URLSearchParamsState = function (init) {
  this.entries = [];
  this.url = null;

  if (init !== undefined) {
    if (isObject(init)) this.parseObject(init);
    else this.parseQuery(typeof init == 'string' ? charAt$1(init, 0) === '?' ? stringSlice$1(init, 1) : init : $toString$1(init));
  }
};

URLSearchParamsState.prototype = {
  type: URL_SEARCH_PARAMS,
  bindURL: function (url) {
    this.url = url;
    this.update();
  },
  parseObject: function (object) {
    var iteratorMethod = getIteratorMethod(object);
    var iterator, next, step, entryIterator, entryNext, first, second;

    if (iteratorMethod) {
      iterator = getIterator(object, iteratorMethod);
      next = iterator.next;
      while (!(step = call(next, iterator)).done) {
        entryIterator = getIterator(anObject(step.value));
        entryNext = entryIterator.next;
        if (
          (first = call(entryNext, entryIterator)).done ||
          (second = call(entryNext, entryIterator)).done ||
          !call(entryNext, entryIterator).done
        ) throw TypeError$2('Expected sequence with length 2');
        push$1(this.entries, { key: $toString$1(first.value), value: $toString$1(second.value) });
      }
    } else for (var key in object) if (hasOwn$1(object, key)) {
      push$1(this.entries, { key: key, value: $toString$1(object[key]) });
    }
  },
  parseQuery: function (query) {
    if (query) {
      var attributes = split$1(query, '&');
      var index = 0;
      var attribute, entry;
      while (index < attributes.length) {
        attribute = attributes[index++];
        if (attribute.length) {
          entry = split$1(attribute, '=');
          push$1(this.entries, {
            key: deserialize(shift$1(entry)),
            value: deserialize(join$1(entry, '='))
          });
        }
      }
    }
  },
  serialize: function () {
    var entries = this.entries;
    var result = [];
    var index = 0;
    var entry;
    while (index < entries.length) {
      entry = entries[index++];
      push$1(result, serialize(entry.key) + '=' + serialize(entry.value));
    } return join$1(result, '&');
  },
  update: function () {
    this.entries.length = 0;
    this.parseQuery(this.url.query);
  },
  updateURL: function () {
    if (this.url) this.url.update();
  }
};

// `URLSearchParams` constructor
// https://url.spec.whatwg.org/#interface-urlsearchparams
var URLSearchParamsConstructor = function URLSearchParams(/* init */) {
  anInstance$1(this, URLSearchParamsPrototype);
  var init = arguments.length > 0 ? arguments[0] : undefined;
  setInternalState$1(this, new URLSearchParamsState(init));
};

var URLSearchParamsPrototype = URLSearchParamsConstructor.prototype;

defineBuiltIns(URLSearchParamsPrototype, {
  // `URLSearchParams.prototype.append` method
  // https://url.spec.whatwg.org/#dom-urlsearchparams-append
  append: function append(name, value) {
    validateArgumentsLength$1(arguments.length, 2);
    var state = getInternalParamsState(this);
    push$1(state.entries, { key: $toString$1(name), value: $toString$1(value) });
    state.updateURL();
  },
  // `URLSearchParams.prototype.delete` method
  // https://url.spec.whatwg.org/#dom-urlsearchparams-delete
  'delete': function (name) {
    validateArgumentsLength$1(arguments.length, 1);
    var state = getInternalParamsState(this);
    var entries = state.entries;
    var key = $toString$1(name);
    var index = 0;
    while (index < entries.length) {
      if (entries[index].key === key) splice(entries, index, 1);
      else index++;
    }
    state.updateURL();
  },
  // `URLSearchParams.prototype.get` method
  // https://url.spec.whatwg.org/#dom-urlsearchparams-get
  get: function get(name) {
    validateArgumentsLength$1(arguments.length, 1);
    var entries = getInternalParamsState(this).entries;
    var key = $toString$1(name);
    var index = 0;
    for (; index < entries.length; index++) {
      if (entries[index].key === key) return entries[index].value;
    }
    return null;
  },
  // `URLSearchParams.prototype.getAll` method
  // https://url.spec.whatwg.org/#dom-urlsearchparams-getall
  getAll: function getAll(name) {
    validateArgumentsLength$1(arguments.length, 1);
    var entries = getInternalParamsState(this).entries;
    var key = $toString$1(name);
    var result = [];
    var index = 0;
    for (; index < entries.length; index++) {
      if (entries[index].key === key) push$1(result, entries[index].value);
    }
    return result;
  },
  // `URLSearchParams.prototype.has` method
  // https://url.spec.whatwg.org/#dom-urlsearchparams-has
  has: function has(name) {
    validateArgumentsLength$1(arguments.length, 1);
    var entries = getInternalParamsState(this).entries;
    var key = $toString$1(name);
    var index = 0;
    while (index < entries.length) {
      if (entries[index++].key === key) return true;
    }
    return false;
  },
  // `URLSearchParams.prototype.set` method
  // https://url.spec.whatwg.org/#dom-urlsearchparams-set
  set: function set(name, value) {
    validateArgumentsLength$1(arguments.length, 1);
    var state = getInternalParamsState(this);
    var entries = state.entries;
    var found = false;
    var key = $toString$1(name);
    var val = $toString$1(value);
    var index = 0;
    var entry;
    for (; index < entries.length; index++) {
      entry = entries[index];
      if (entry.key === key) {
        if (found) splice(entries, index--, 1);
        else {
          found = true;
          entry.value = val;
        }
      }
    }
    if (!found) push$1(entries, { key: key, value: val });
    state.updateURL();
  },
  // `URLSearchParams.prototype.sort` method
  // https://url.spec.whatwg.org/#dom-urlsearchparams-sort
  sort: function sort() {
    var state = getInternalParamsState(this);
    arraySort(state.entries, function (a, b) {
      return a.key > b.key ? 1 : -1;
    });
    state.updateURL();
  },
  // `URLSearchParams.prototype.forEach` method
  forEach: function forEach(callback /* , thisArg */) {
    var entries = getInternalParamsState(this).entries;
    var boundFunction = bind$1(callback, arguments.length > 1 ? arguments[1] : undefined);
    var index = 0;
    var entry;
    while (index < entries.length) {
      entry = entries[index++];
      boundFunction(entry.value, entry.key, this);
    }
  },
  // `URLSearchParams.prototype.keys` method
  keys: function keys() {
    return new URLSearchParamsIterator(this, 'keys');
  },
  // `URLSearchParams.prototype.values` method
  values: function values() {
    return new URLSearchParamsIterator(this, 'values');
  },
  // `URLSearchParams.prototype.entries` method
  entries: function entries() {
    return new URLSearchParamsIterator(this, 'entries');
  }
}, { enumerable: true });

// `URLSearchParams.prototype[@@iterator]` method
defineBuiltIn$1(URLSearchParamsPrototype, ITERATOR, URLSearchParamsPrototype.entries, { name: 'entries' });

// `URLSearchParams.prototype.toString` method
// https://url.spec.whatwg.org/#urlsearchparams-stringification-behavior
defineBuiltIn$1(URLSearchParamsPrototype, 'toString', function toString() {
  return getInternalParamsState(this).serialize();
}, { enumerable: true });

setToStringTag$1(URLSearchParamsConstructor, URL_SEARCH_PARAMS);

$$1({ global: true, constructor: true, forced: !USE_NATIVE_URL$1 }, {
  URLSearchParams: URLSearchParamsConstructor
});

// Wrap `fetch` and `Request` for correct work with polyfilled `URLSearchParams`
if (!USE_NATIVE_URL$1 && isCallable(Headers)) {
  var headersHas = uncurryThis$1(HeadersPrototype.has);
  var headersSet = uncurryThis$1(HeadersPrototype.set);

  var wrapRequestOptions = function (init) {
    if (isObject(init)) {
      var body = init.body;
      var headers;
      if (classof(body) === URL_SEARCH_PARAMS) {
        headers = init.headers ? new Headers(init.headers) : new Headers();
        if (!headersHas(headers, 'content-type')) {
          headersSet(headers, 'content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
        }
        return create(init, {
          body: createPropertyDescriptor(0, $toString$1(body)),
          headers: createPropertyDescriptor(0, headers)
        });
      }
    } return init;
  };

  if (isCallable(nativeFetch)) {
    $$1({ global: true, enumerable: true, dontCallGetSet: true, forced: true }, {
      fetch: function fetch(input /* , init */) {
        return nativeFetch(input, arguments.length > 1 ? wrapRequestOptions(arguments[1]) : {});
      }
    });
  }

  if (isCallable(NativeRequest)) {
    var RequestConstructor = function Request(input /* , init */) {
      anInstance$1(this, RequestPrototype);
      return new NativeRequest(input, arguments.length > 1 ? wrapRequestOptions(arguments[1]) : {});
    };

    RequestPrototype.constructor = RequestConstructor;
    RequestConstructor.prototype = RequestPrototype;

    $$1({ global: true, constructor: true, dontCallGetSet: true, forced: true }, {
      Request: RequestConstructor
    });
  }
}

var web_urlSearchParams_constructor = {
  URLSearchParams: URLSearchParamsConstructor,
  getState: getInternalParamsState
};

// TODO: in core-js@4, move /modules/ dependencies to public entries for better optimization by tools like `preset-env`

var $ = _export;
var DESCRIPTORS = descriptors;
var USE_NATIVE_URL = urlConstructorDetection;
var global$1 = global$z;
var bind = functionBindContext;
var uncurryThis = functionUncurryThis;
var defineBuiltIn = defineBuiltIn$d;
var defineBuiltInAccessor = defineBuiltInAccessor$1;
var anInstance = anInstance$5;
var hasOwn = hasOwnProperty_1;
var assign = objectAssign;
var arrayFrom = arrayFrom$1;
var arraySlice = arraySliceSimple;
var codeAt = stringMultibyte.codeAt;
var toASCII = stringPunycodeToAscii;
var $toString = toString$d;
var setToStringTag = setToStringTag$6;
var validateArgumentsLength = validateArgumentsLength$3;
var URLSearchParamsModule = web_urlSearchParams_constructor;
var InternalStateModule = internalState;

var setInternalState = InternalStateModule.set;
var getInternalURLState = InternalStateModule.getterFor('URL');
var URLSearchParams$1 = URLSearchParamsModule.URLSearchParams;
var getInternalSearchParamsState = URLSearchParamsModule.getState;

var NativeURL = global$1.URL;
var TypeError$1 = global$1.TypeError;
var parseInt$1 = global$1.parseInt;
var floor = Math.floor;
var pow = Math.pow;
var charAt = uncurryThis(''.charAt);
var exec = uncurryThis(/./.exec);
var join = uncurryThis([].join);
var numberToString = uncurryThis(1.0.toString);
var pop = uncurryThis([].pop);
var push = uncurryThis([].push);
var replace = uncurryThis(''.replace);
var shift = uncurryThis([].shift);
var split = uncurryThis(''.split);
var stringSlice = uncurryThis(''.slice);
var toLowerCase = uncurryThis(''.toLowerCase);
var unshift = uncurryThis([].unshift);

var INVALID_AUTHORITY = 'Invalid authority';
var INVALID_SCHEME = 'Invalid scheme';
var INVALID_HOST = 'Invalid host';
var INVALID_PORT = 'Invalid port';

var ALPHA = /[a-z]/i;
// eslint-disable-next-line regexp/no-obscure-range -- safe
var ALPHANUMERIC = /[\d+-.a-z]/i;
var DIGIT = /\d/;
var HEX_START = /^0x/i;
var OCT = /^[0-7]+$/;
var DEC = /^\d+$/;
var HEX = /^[\da-f]+$/i;
/* eslint-disable regexp/no-control-character -- safe */
var FORBIDDEN_HOST_CODE_POINT = /[\0\t\n\r #%/:<>?@[\\\]^|]/;
var FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT = /[\0\t\n\r #/:<>?@[\\\]^|]/;
var LEADING_AND_TRAILING_C0_CONTROL_OR_SPACE = /^[\u0000-\u0020]+|[\u0000-\u0020]+$/g;
var TAB_AND_NEW_LINE = /[\t\n\r]/g;
/* eslint-enable regexp/no-control-character -- safe */
var EOF;

// https://url.spec.whatwg.org/#ipv4-number-parser
var parseIPv4 = function (input) {
  var parts = split(input, '.');
  var partsLength, numbers, index, part, radix, number, ipv4;
  if (parts.length && parts[parts.length - 1] == '') {
    parts.length--;
  }
  partsLength = parts.length;
  if (partsLength > 4) return input;
  numbers = [];
  for (index = 0; index < partsLength; index++) {
    part = parts[index];
    if (part == '') return input;
    radix = 10;
    if (part.length > 1 && charAt(part, 0) == '0') {
      radix = exec(HEX_START, part) ? 16 : 8;
      part = stringSlice(part, radix == 8 ? 1 : 2);
    }
    if (part === '') {
      number = 0;
    } else {
      if (!exec(radix == 10 ? DEC : radix == 8 ? OCT : HEX, part)) return input;
      number = parseInt$1(part, radix);
    }
    push(numbers, number);
  }
  for (index = 0; index < partsLength; index++) {
    number = numbers[index];
    if (index == partsLength - 1) {
      if (number >= pow(256, 5 - partsLength)) return null;
    } else if (number > 255) return null;
  }
  ipv4 = pop(numbers);
  for (index = 0; index < numbers.length; index++) {
    ipv4 += numbers[index] * pow(256, 3 - index);
  }
  return ipv4;
};

// https://url.spec.whatwg.org/#concept-ipv6-parser
// eslint-disable-next-line max-statements -- TODO
var parseIPv6 = function (input) {
  var address = [0, 0, 0, 0, 0, 0, 0, 0];
  var pieceIndex = 0;
  var compress = null;
  var pointer = 0;
  var value, length, numbersSeen, ipv4Piece, number, swaps, swap;

  var chr = function () {
    return charAt(input, pointer);
  };

  if (chr() == ':') {
    if (charAt(input, 1) != ':') return;
    pointer += 2;
    pieceIndex++;
    compress = pieceIndex;
  }
  while (chr()) {
    if (pieceIndex == 8) return;
    if (chr() == ':') {
      if (compress !== null) return;
      pointer++;
      pieceIndex++;
      compress = pieceIndex;
      continue;
    }
    value = length = 0;
    while (length < 4 && exec(HEX, chr())) {
      value = value * 16 + parseInt$1(chr(), 16);
      pointer++;
      length++;
    }
    if (chr() == '.') {
      if (length == 0) return;
      pointer -= length;
      if (pieceIndex > 6) return;
      numbersSeen = 0;
      while (chr()) {
        ipv4Piece = null;
        if (numbersSeen > 0) {
          if (chr() == '.' && numbersSeen < 4) pointer++;
          else return;
        }
        if (!exec(DIGIT, chr())) return;
        while (exec(DIGIT, chr())) {
          number = parseInt$1(chr(), 10);
          if (ipv4Piece === null) ipv4Piece = number;
          else if (ipv4Piece == 0) return;
          else ipv4Piece = ipv4Piece * 10 + number;
          if (ipv4Piece > 255) return;
          pointer++;
        }
        address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
        numbersSeen++;
        if (numbersSeen == 2 || numbersSeen == 4) pieceIndex++;
      }
      if (numbersSeen != 4) return;
      break;
    } else if (chr() == ':') {
      pointer++;
      if (!chr()) return;
    } else if (chr()) return;
    address[pieceIndex++] = value;
  }
  if (compress !== null) {
    swaps = pieceIndex - compress;
    pieceIndex = 7;
    while (pieceIndex != 0 && swaps > 0) {
      swap = address[pieceIndex];
      address[pieceIndex--] = address[compress + swaps - 1];
      address[compress + --swaps] = swap;
    }
  } else if (pieceIndex != 8) return;
  return address;
};

var findLongestZeroSequence = function (ipv6) {
  var maxIndex = null;
  var maxLength = 1;
  var currStart = null;
  var currLength = 0;
  var index = 0;
  for (; index < 8; index++) {
    if (ipv6[index] !== 0) {
      if (currLength > maxLength) {
        maxIndex = currStart;
        maxLength = currLength;
      }
      currStart = null;
      currLength = 0;
    } else {
      if (currStart === null) currStart = index;
      ++currLength;
    }
  }
  if (currLength > maxLength) {
    maxIndex = currStart;
    maxLength = currLength;
  }
  return maxIndex;
};

// https://url.spec.whatwg.org/#host-serializing
var serializeHost = function (host) {
  var result, index, compress, ignore0;
  // ipv4
  if (typeof host == 'number') {
    result = [];
    for (index = 0; index < 4; index++) {
      unshift(result, host % 256);
      host = floor(host / 256);
    } return join(result, '.');
  // ipv6
  } else if (typeof host == 'object') {
    result = '';
    compress = findLongestZeroSequence(host);
    for (index = 0; index < 8; index++) {
      if (ignore0 && host[index] === 0) continue;
      if (ignore0) ignore0 = false;
      if (compress === index) {
        result += index ? ':' : '::';
        ignore0 = true;
      } else {
        result += numberToString(host[index], 16);
        if (index < 7) result += ':';
      }
    }
    return '[' + result + ']';
  } return host;
};

var C0ControlPercentEncodeSet = {};
var fragmentPercentEncodeSet = assign({}, C0ControlPercentEncodeSet, {
  ' ': 1, '"': 1, '<': 1, '>': 1, '`': 1
});
var pathPercentEncodeSet = assign({}, fragmentPercentEncodeSet, {
  '#': 1, '?': 1, '{': 1, '}': 1
});
var userinfoPercentEncodeSet = assign({}, pathPercentEncodeSet, {
  '/': 1, ':': 1, ';': 1, '=': 1, '@': 1, '[': 1, '\\': 1, ']': 1, '^': 1, '|': 1
});

var percentEncode = function (chr, set) {
  var code = codeAt(chr, 0);
  return code > 0x20 && code < 0x7F && !hasOwn(set, chr) ? chr : encodeURIComponent(chr);
};

// https://url.spec.whatwg.org/#special-scheme
var specialSchemes = {
  ftp: 21,
  file: null,
  http: 80,
  https: 443,
  ws: 80,
  wss: 443
};

// https://url.spec.whatwg.org/#windows-drive-letter
var isWindowsDriveLetter = function (string, normalized) {
  var second;
  return string.length == 2 && exec(ALPHA, charAt(string, 0))
    && ((second = charAt(string, 1)) == ':' || (!normalized && second == '|'));
};

// https://url.spec.whatwg.org/#start-with-a-windows-drive-letter
var startsWithWindowsDriveLetter = function (string) {
  var third;
  return string.length > 1 && isWindowsDriveLetter(stringSlice(string, 0, 2)) && (
    string.length == 2 ||
    ((third = charAt(string, 2)) === '/' || third === '\\' || third === '?' || third === '#')
  );
};

// https://url.spec.whatwg.org/#single-dot-path-segment
var isSingleDot = function (segment) {
  return segment === '.' || toLowerCase(segment) === '%2e';
};

// https://url.spec.whatwg.org/#double-dot-path-segment
var isDoubleDot = function (segment) {
  segment = toLowerCase(segment);
  return segment === '..' || segment === '%2e.' || segment === '.%2e' || segment === '%2e%2e';
};

// States:
var SCHEME_START = {};
var SCHEME = {};
var NO_SCHEME = {};
var SPECIAL_RELATIVE_OR_AUTHORITY = {};
var PATH_OR_AUTHORITY = {};
var RELATIVE = {};
var RELATIVE_SLASH = {};
var SPECIAL_AUTHORITY_SLASHES = {};
var SPECIAL_AUTHORITY_IGNORE_SLASHES = {};
var AUTHORITY = {};
var HOST = {};
var HOSTNAME = {};
var PORT = {};
var FILE = {};
var FILE_SLASH = {};
var FILE_HOST = {};
var PATH_START = {};
var PATH = {};
var CANNOT_BE_A_BASE_URL_PATH = {};
var QUERY = {};
var FRAGMENT = {};

var URLState = function (url, isBase, base) {
  var urlString = $toString(url);
  var baseState, failure, searchParams;
  if (isBase) {
    failure = this.parse(urlString);
    if (failure) throw TypeError$1(failure);
    this.searchParams = null;
  } else {
    if (base !== undefined) baseState = new URLState(base, true);
    failure = this.parse(urlString, null, baseState);
    if (failure) throw TypeError$1(failure);
    searchParams = getInternalSearchParamsState(new URLSearchParams$1());
    searchParams.bindURL(this);
    this.searchParams = searchParams;
  }
};

URLState.prototype = {
  type: 'URL',
  // https://url.spec.whatwg.org/#url-parsing
  // eslint-disable-next-line max-statements -- TODO
  parse: function (input, stateOverride, base) {
    var url = this;
    var state = stateOverride || SCHEME_START;
    var pointer = 0;
    var buffer = '';
    var seenAt = false;
    var seenBracket = false;
    var seenPasswordToken = false;
    var codePoints, chr, bufferCodePoints, failure;

    input = $toString(input);

    if (!stateOverride) {
      url.scheme = '';
      url.username = '';
      url.password = '';
      url.host = null;
      url.port = null;
      url.path = [];
      url.query = null;
      url.fragment = null;
      url.cannotBeABaseURL = false;
      input = replace(input, LEADING_AND_TRAILING_C0_CONTROL_OR_SPACE, '');
    }

    input = replace(input, TAB_AND_NEW_LINE, '');

    codePoints = arrayFrom(input);

    while (pointer <= codePoints.length) {
      chr = codePoints[pointer];
      switch (state) {
        case SCHEME_START:
          if (chr && exec(ALPHA, chr)) {
            buffer += toLowerCase(chr);
            state = SCHEME;
          } else if (!stateOverride) {
            state = NO_SCHEME;
            continue;
          } else return INVALID_SCHEME;
          break;

        case SCHEME:
          if (chr && (exec(ALPHANUMERIC, chr) || chr == '+' || chr == '-' || chr == '.')) {
            buffer += toLowerCase(chr);
          } else if (chr == ':') {
            if (stateOverride && (
              (url.isSpecial() != hasOwn(specialSchemes, buffer)) ||
              (buffer == 'file' && (url.includesCredentials() || url.port !== null)) ||
              (url.scheme == 'file' && !url.host)
            )) return;
            url.scheme = buffer;
            if (stateOverride) {
              if (url.isSpecial() && specialSchemes[url.scheme] == url.port) url.port = null;
              return;
            }
            buffer = '';
            if (url.scheme == 'file') {
              state = FILE;
            } else if (url.isSpecial() && base && base.scheme == url.scheme) {
              state = SPECIAL_RELATIVE_OR_AUTHORITY;
            } else if (url.isSpecial()) {
              state = SPECIAL_AUTHORITY_SLASHES;
            } else if (codePoints[pointer + 1] == '/') {
              state = PATH_OR_AUTHORITY;
              pointer++;
            } else {
              url.cannotBeABaseURL = true;
              push(url.path, '');
              state = CANNOT_BE_A_BASE_URL_PATH;
            }
          } else if (!stateOverride) {
            buffer = '';
            state = NO_SCHEME;
            pointer = 0;
            continue;
          } else return INVALID_SCHEME;
          break;

        case NO_SCHEME:
          if (!base || (base.cannotBeABaseURL && chr != '#')) return INVALID_SCHEME;
          if (base.cannotBeABaseURL && chr == '#') {
            url.scheme = base.scheme;
            url.path = arraySlice(base.path);
            url.query = base.query;
            url.fragment = '';
            url.cannotBeABaseURL = true;
            state = FRAGMENT;
            break;
          }
          state = base.scheme == 'file' ? FILE : RELATIVE;
          continue;

        case SPECIAL_RELATIVE_OR_AUTHORITY:
          if (chr == '/' && codePoints[pointer + 1] == '/') {
            state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
            pointer++;
          } else {
            state = RELATIVE;
            continue;
          } break;

        case PATH_OR_AUTHORITY:
          if (chr == '/') {
            state = AUTHORITY;
            break;
          } else {
            state = PATH;
            continue;
          }

        case RELATIVE:
          url.scheme = base.scheme;
          if (chr == EOF) {
            url.username = base.username;
            url.password = base.password;
            url.host = base.host;
            url.port = base.port;
            url.path = arraySlice(base.path);
            url.query = base.query;
          } else if (chr == '/' || (chr == '\\' && url.isSpecial())) {
            state = RELATIVE_SLASH;
          } else if (chr == '?') {
            url.username = base.username;
            url.password = base.password;
            url.host = base.host;
            url.port = base.port;
            url.path = arraySlice(base.path);
            url.query = '';
            state = QUERY;
          } else if (chr == '#') {
            url.username = base.username;
            url.password = base.password;
            url.host = base.host;
            url.port = base.port;
            url.path = arraySlice(base.path);
            url.query = base.query;
            url.fragment = '';
            state = FRAGMENT;
          } else {
            url.username = base.username;
            url.password = base.password;
            url.host = base.host;
            url.port = base.port;
            url.path = arraySlice(base.path);
            url.path.length--;
            state = PATH;
            continue;
          } break;

        case RELATIVE_SLASH:
          if (url.isSpecial() && (chr == '/' || chr == '\\')) {
            state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
          } else if (chr == '/') {
            state = AUTHORITY;
          } else {
            url.username = base.username;
            url.password = base.password;
            url.host = base.host;
            url.port = base.port;
            state = PATH;
            continue;
          } break;

        case SPECIAL_AUTHORITY_SLASHES:
          state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
          if (chr != '/' || charAt(buffer, pointer + 1) != '/') continue;
          pointer++;
          break;

        case SPECIAL_AUTHORITY_IGNORE_SLASHES:
          if (chr != '/' && chr != '\\') {
            state = AUTHORITY;
            continue;
          } break;

        case AUTHORITY:
          if (chr == '@') {
            if (seenAt) buffer = '%40' + buffer;
            seenAt = true;
            bufferCodePoints = arrayFrom(buffer);
            for (var i = 0; i < bufferCodePoints.length; i++) {
              var codePoint = bufferCodePoints[i];
              if (codePoint == ':' && !seenPasswordToken) {
                seenPasswordToken = true;
                continue;
              }
              var encodedCodePoints = percentEncode(codePoint, userinfoPercentEncodeSet);
              if (seenPasswordToken) url.password += encodedCodePoints;
              else url.username += encodedCodePoints;
            }
            buffer = '';
          } else if (
            chr == EOF || chr == '/' || chr == '?' || chr == '#' ||
            (chr == '\\' && url.isSpecial())
          ) {
            if (seenAt && buffer == '') return INVALID_AUTHORITY;
            pointer -= arrayFrom(buffer).length + 1;
            buffer = '';
            state = HOST;
          } else buffer += chr;
          break;

        case HOST:
        case HOSTNAME:
          if (stateOverride && url.scheme == 'file') {
            state = FILE_HOST;
            continue;
          } else if (chr == ':' && !seenBracket) {
            if (buffer == '') return INVALID_HOST;
            failure = url.parseHost(buffer);
            if (failure) return failure;
            buffer = '';
            state = PORT;
            if (stateOverride == HOSTNAME) return;
          } else if (
            chr == EOF || chr == '/' || chr == '?' || chr == '#' ||
            (chr == '\\' && url.isSpecial())
          ) {
            if (url.isSpecial() && buffer == '') return INVALID_HOST;
            if (stateOverride && buffer == '' && (url.includesCredentials() || url.port !== null)) return;
            failure = url.parseHost(buffer);
            if (failure) return failure;
            buffer = '';
            state = PATH_START;
            if (stateOverride) return;
            continue;
          } else {
            if (chr == '[') seenBracket = true;
            else if (chr == ']') seenBracket = false;
            buffer += chr;
          } break;

        case PORT:
          if (exec(DIGIT, chr)) {
            buffer += chr;
          } else if (
            chr == EOF || chr == '/' || chr == '?' || chr == '#' ||
            (chr == '\\' && url.isSpecial()) ||
            stateOverride
          ) {
            if (buffer != '') {
              var port = parseInt$1(buffer, 10);
              if (port > 0xFFFF) return INVALID_PORT;
              url.port = (url.isSpecial() && port === specialSchemes[url.scheme]) ? null : port;
              buffer = '';
            }
            if (stateOverride) return;
            state = PATH_START;
            continue;
          } else return INVALID_PORT;
          break;

        case FILE:
          url.scheme = 'file';
          if (chr == '/' || chr == '\\') state = FILE_SLASH;
          else if (base && base.scheme == 'file') {
            if (chr == EOF) {
              url.host = base.host;
              url.path = arraySlice(base.path);
              url.query = base.query;
            } else if (chr == '?') {
              url.host = base.host;
              url.path = arraySlice(base.path);
              url.query = '';
              state = QUERY;
            } else if (chr == '#') {
              url.host = base.host;
              url.path = arraySlice(base.path);
              url.query = base.query;
              url.fragment = '';
              state = FRAGMENT;
            } else {
              if (!startsWithWindowsDriveLetter(join(arraySlice(codePoints, pointer), ''))) {
                url.host = base.host;
                url.path = arraySlice(base.path);
                url.shortenPath();
              }
              state = PATH;
              continue;
            }
          } else {
            state = PATH;
            continue;
          } break;

        case FILE_SLASH:
          if (chr == '/' || chr == '\\') {
            state = FILE_HOST;
            break;
          }
          if (base && base.scheme == 'file' && !startsWithWindowsDriveLetter(join(arraySlice(codePoints, pointer), ''))) {
            if (isWindowsDriveLetter(base.path[0], true)) push(url.path, base.path[0]);
            else url.host = base.host;
          }
          state = PATH;
          continue;

        case FILE_HOST:
          if (chr == EOF || chr == '/' || chr == '\\' || chr == '?' || chr == '#') {
            if (!stateOverride && isWindowsDriveLetter(buffer)) {
              state = PATH;
            } else if (buffer == '') {
              url.host = '';
              if (stateOverride) return;
              state = PATH_START;
            } else {
              failure = url.parseHost(buffer);
              if (failure) return failure;
              if (url.host == 'localhost') url.host = '';
              if (stateOverride) return;
              buffer = '';
              state = PATH_START;
            } continue;
          } else buffer += chr;
          break;

        case PATH_START:
          if (url.isSpecial()) {
            state = PATH;
            if (chr != '/' && chr != '\\') continue;
          } else if (!stateOverride && chr == '?') {
            url.query = '';
            state = QUERY;
          } else if (!stateOverride && chr == '#') {
            url.fragment = '';
            state = FRAGMENT;
          } else if (chr != EOF) {
            state = PATH;
            if (chr != '/') continue;
          } break;

        case PATH:
          if (
            chr == EOF || chr == '/' ||
            (chr == '\\' && url.isSpecial()) ||
            (!stateOverride && (chr == '?' || chr == '#'))
          ) {
            if (isDoubleDot(buffer)) {
              url.shortenPath();
              if (chr != '/' && !(chr == '\\' && url.isSpecial())) {
                push(url.path, '');
              }
            } else if (isSingleDot(buffer)) {
              if (chr != '/' && !(chr == '\\' && url.isSpecial())) {
                push(url.path, '');
              }
            } else {
              if (url.scheme == 'file' && !url.path.length && isWindowsDriveLetter(buffer)) {
                if (url.host) url.host = '';
                buffer = charAt(buffer, 0) + ':'; // normalize windows drive letter
              }
              push(url.path, buffer);
            }
            buffer = '';
            if (url.scheme == 'file' && (chr == EOF || chr == '?' || chr == '#')) {
              while (url.path.length > 1 && url.path[0] === '') {
                shift(url.path);
              }
            }
            if (chr == '?') {
              url.query = '';
              state = QUERY;
            } else if (chr == '#') {
              url.fragment = '';
              state = FRAGMENT;
            }
          } else {
            buffer += percentEncode(chr, pathPercentEncodeSet);
          } break;

        case CANNOT_BE_A_BASE_URL_PATH:
          if (chr == '?') {
            url.query = '';
            state = QUERY;
          } else if (chr == '#') {
            url.fragment = '';
            state = FRAGMENT;
          } else if (chr != EOF) {
            url.path[0] += percentEncode(chr, C0ControlPercentEncodeSet);
          } break;

        case QUERY:
          if (!stateOverride && chr == '#') {
            url.fragment = '';
            state = FRAGMENT;
          } else if (chr != EOF) {
            if (chr == "'" && url.isSpecial()) url.query += '%27';
            else if (chr == '#') url.query += '%23';
            else url.query += percentEncode(chr, C0ControlPercentEncodeSet);
          } break;

        case FRAGMENT:
          if (chr != EOF) url.fragment += percentEncode(chr, fragmentPercentEncodeSet);
          break;
      }

      pointer++;
    }
  },
  // https://url.spec.whatwg.org/#host-parsing
  parseHost: function (input) {
    var result, codePoints, index;
    if (charAt(input, 0) == '[') {
      if (charAt(input, input.length - 1) != ']') return INVALID_HOST;
      result = parseIPv6(stringSlice(input, 1, -1));
      if (!result) return INVALID_HOST;
      this.host = result;
    // opaque host
    } else if (!this.isSpecial()) {
      if (exec(FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT, input)) return INVALID_HOST;
      result = '';
      codePoints = arrayFrom(input);
      for (index = 0; index < codePoints.length; index++) {
        result += percentEncode(codePoints[index], C0ControlPercentEncodeSet);
      }
      this.host = result;
    } else {
      input = toASCII(input);
      if (exec(FORBIDDEN_HOST_CODE_POINT, input)) return INVALID_HOST;
      result = parseIPv4(input);
      if (result === null) return INVALID_HOST;
      this.host = result;
    }
  },
  // https://url.spec.whatwg.org/#cannot-have-a-username-password-port
  cannotHaveUsernamePasswordPort: function () {
    return !this.host || this.cannotBeABaseURL || this.scheme == 'file';
  },
  // https://url.spec.whatwg.org/#include-credentials
  includesCredentials: function () {
    return this.username != '' || this.password != '';
  },
  // https://url.spec.whatwg.org/#is-special
  isSpecial: function () {
    return hasOwn(specialSchemes, this.scheme);
  },
  // https://url.spec.whatwg.org/#shorten-a-urls-path
  shortenPath: function () {
    var path = this.path;
    var pathSize = path.length;
    if (pathSize && (this.scheme != 'file' || pathSize != 1 || !isWindowsDriveLetter(path[0], true))) {
      path.length--;
    }
  },
  // https://url.spec.whatwg.org/#concept-url-serializer
  serialize: function () {
    var url = this;
    var scheme = url.scheme;
    var username = url.username;
    var password = url.password;
    var host = url.host;
    var port = url.port;
    var path = url.path;
    var query = url.query;
    var fragment = url.fragment;
    var output = scheme + ':';
    if (host !== null) {
      output += '//';
      if (url.includesCredentials()) {
        output += username + (password ? ':' + password : '') + '@';
      }
      output += serializeHost(host);
      if (port !== null) output += ':' + port;
    } else if (scheme == 'file') output += '//';
    output += url.cannotBeABaseURL ? path[0] : path.length ? '/' + join(path, '/') : '';
    if (query !== null) output += '?' + query;
    if (fragment !== null) output += '#' + fragment;
    return output;
  },
  // https://url.spec.whatwg.org/#dom-url-href
  setHref: function (href) {
    var failure = this.parse(href);
    if (failure) throw TypeError$1(failure);
    this.searchParams.update();
  },
  // https://url.spec.whatwg.org/#dom-url-origin
  getOrigin: function () {
    var scheme = this.scheme;
    var port = this.port;
    if (scheme == 'blob') try {
      return new URLConstructor(scheme.path[0]).origin;
    } catch (error) {
      return 'null';
    }
    if (scheme == 'file' || !this.isSpecial()) return 'null';
    return scheme + '://' + serializeHost(this.host) + (port !== null ? ':' + port : '');
  },
  // https://url.spec.whatwg.org/#dom-url-protocol
  getProtocol: function () {
    return this.scheme + ':';
  },
  setProtocol: function (protocol) {
    this.parse($toString(protocol) + ':', SCHEME_START);
  },
  // https://url.spec.whatwg.org/#dom-url-username
  getUsername: function () {
    return this.username;
  },
  setUsername: function (username) {
    var codePoints = arrayFrom($toString(username));
    if (this.cannotHaveUsernamePasswordPort()) return;
    this.username = '';
    for (var i = 0; i < codePoints.length; i++) {
      this.username += percentEncode(codePoints[i], userinfoPercentEncodeSet);
    }
  },
  // https://url.spec.whatwg.org/#dom-url-password
  getPassword: function () {
    return this.password;
  },
  setPassword: function (password) {
    var codePoints = arrayFrom($toString(password));
    if (this.cannotHaveUsernamePasswordPort()) return;
    this.password = '';
    for (var i = 0; i < codePoints.length; i++) {
      this.password += percentEncode(codePoints[i], userinfoPercentEncodeSet);
    }
  },
  // https://url.spec.whatwg.org/#dom-url-host
  getHost: function () {
    var host = this.host;
    var port = this.port;
    return host === null ? ''
      : port === null ? serializeHost(host)
      : serializeHost(host) + ':' + port;
  },
  setHost: function (host) {
    if (this.cannotBeABaseURL) return;
    this.parse(host, HOST);
  },
  // https://url.spec.whatwg.org/#dom-url-hostname
  getHostname: function () {
    var host = this.host;
    return host === null ? '' : serializeHost(host);
  },
  setHostname: function (hostname) {
    if (this.cannotBeABaseURL) return;
    this.parse(hostname, HOSTNAME);
  },
  // https://url.spec.whatwg.org/#dom-url-port
  getPort: function () {
    var port = this.port;
    return port === null ? '' : $toString(port);
  },
  setPort: function (port) {
    if (this.cannotHaveUsernamePasswordPort()) return;
    port = $toString(port);
    if (port == '') this.port = null;
    else this.parse(port, PORT);
  },
  // https://url.spec.whatwg.org/#dom-url-pathname
  getPathname: function () {
    var path = this.path;
    return this.cannotBeABaseURL ? path[0] : path.length ? '/' + join(path, '/') : '';
  },
  setPathname: function (pathname) {
    if (this.cannotBeABaseURL) return;
    this.path = [];
    this.parse(pathname, PATH_START);
  },
  // https://url.spec.whatwg.org/#dom-url-search
  getSearch: function () {
    var query = this.query;
    return query ? '?' + query : '';
  },
  setSearch: function (search) {
    search = $toString(search);
    if (search == '') {
      this.query = null;
    } else {
      if ('?' == charAt(search, 0)) search = stringSlice(search, 1);
      this.query = '';
      this.parse(search, QUERY);
    }
    this.searchParams.update();
  },
  // https://url.spec.whatwg.org/#dom-url-searchparams
  getSearchParams: function () {
    return this.searchParams.facade;
  },
  // https://url.spec.whatwg.org/#dom-url-hash
  getHash: function () {
    var fragment = this.fragment;
    return fragment ? '#' + fragment : '';
  },
  setHash: function (hash) {
    hash = $toString(hash);
    if (hash == '') {
      this.fragment = null;
      return;
    }
    if ('#' == charAt(hash, 0)) hash = stringSlice(hash, 1);
    this.fragment = '';
    this.parse(hash, FRAGMENT);
  },
  update: function () {
    this.query = this.searchParams.serialize() || null;
  }
};

// `URL` constructor
// https://url.spec.whatwg.org/#url-class
var URLConstructor = function URL(url /* , base */) {
  var that = anInstance(this, URLPrototype);
  var base = validateArgumentsLength(arguments.length, 1) > 1 ? arguments[1] : undefined;
  var state = setInternalState(that, new URLState(url, false, base));
  if (!DESCRIPTORS) {
    that.href = state.serialize();
    that.origin = state.getOrigin();
    that.protocol = state.getProtocol();
    that.username = state.getUsername();
    that.password = state.getPassword();
    that.host = state.getHost();
    that.hostname = state.getHostname();
    that.port = state.getPort();
    that.pathname = state.getPathname();
    that.search = state.getSearch();
    that.searchParams = state.getSearchParams();
    that.hash = state.getHash();
  }
};

var URLPrototype = URLConstructor.prototype;

var accessorDescriptor = function (getter, setter) {
  return {
    get: function () {
      return getInternalURLState(this)[getter]();
    },
    set: setter && function (value) {
      return getInternalURLState(this)[setter](value);
    },
    configurable: true,
    enumerable: true
  };
};

if (DESCRIPTORS) {
  // `URL.prototype.href` accessors pair
  // https://url.spec.whatwg.org/#dom-url-href
  defineBuiltInAccessor(URLPrototype, 'href', accessorDescriptor('serialize', 'setHref'));
  // `URL.prototype.origin` getter
  // https://url.spec.whatwg.org/#dom-url-origin
  defineBuiltInAccessor(URLPrototype, 'origin', accessorDescriptor('getOrigin'));
  // `URL.prototype.protocol` accessors pair
  // https://url.spec.whatwg.org/#dom-url-protocol
  defineBuiltInAccessor(URLPrototype, 'protocol', accessorDescriptor('getProtocol', 'setProtocol'));
  // `URL.prototype.username` accessors pair
  // https://url.spec.whatwg.org/#dom-url-username
  defineBuiltInAccessor(URLPrototype, 'username', accessorDescriptor('getUsername', 'setUsername'));
  // `URL.prototype.password` accessors pair
  // https://url.spec.whatwg.org/#dom-url-password
  defineBuiltInAccessor(URLPrototype, 'password', accessorDescriptor('getPassword', 'setPassword'));
  // `URL.prototype.host` accessors pair
  // https://url.spec.whatwg.org/#dom-url-host
  defineBuiltInAccessor(URLPrototype, 'host', accessorDescriptor('getHost', 'setHost'));
  // `URL.prototype.hostname` accessors pair
  // https://url.spec.whatwg.org/#dom-url-hostname
  defineBuiltInAccessor(URLPrototype, 'hostname', accessorDescriptor('getHostname', 'setHostname'));
  // `URL.prototype.port` accessors pair
  // https://url.spec.whatwg.org/#dom-url-port
  defineBuiltInAccessor(URLPrototype, 'port', accessorDescriptor('getPort', 'setPort'));
  // `URL.prototype.pathname` accessors pair
  // https://url.spec.whatwg.org/#dom-url-pathname
  defineBuiltInAccessor(URLPrototype, 'pathname', accessorDescriptor('getPathname', 'setPathname'));
  // `URL.prototype.search` accessors pair
  // https://url.spec.whatwg.org/#dom-url-search
  defineBuiltInAccessor(URLPrototype, 'search', accessorDescriptor('getSearch', 'setSearch'));
  // `URL.prototype.searchParams` getter
  // https://url.spec.whatwg.org/#dom-url-searchparams
  defineBuiltInAccessor(URLPrototype, 'searchParams', accessorDescriptor('getSearchParams'));
  // `URL.prototype.hash` accessors pair
  // https://url.spec.whatwg.org/#dom-url-hash
  defineBuiltInAccessor(URLPrototype, 'hash', accessorDescriptor('getHash', 'setHash'));
}

// `URL.prototype.toJSON` method
// https://url.spec.whatwg.org/#dom-url-tojson
defineBuiltIn(URLPrototype, 'toJSON', function toJSON() {
  return getInternalURLState(this).serialize();
}, { enumerable: true });

// `URL.prototype.toString` method
// https://url.spec.whatwg.org/#URL-stringification-behavior
defineBuiltIn(URLPrototype, 'toString', function toString() {
  return getInternalURLState(this).serialize();
}, { enumerable: true });

if (NativeURL) {
  var nativeCreateObjectURL = NativeURL.createObjectURL;
  var nativeRevokeObjectURL = NativeURL.revokeObjectURL;
  // `URL.createObjectURL` method
  // https://developer.mozilla.org/en-US/docs/Web/API/URL/createObjectURL
  if (nativeCreateObjectURL) defineBuiltIn(URLConstructor, 'createObjectURL', bind(nativeCreateObjectURL, NativeURL));
  // `URL.revokeObjectURL` method
  // https://developer.mozilla.org/en-US/docs/Web/API/URL/revokeObjectURL
  if (nativeRevokeObjectURL) defineBuiltIn(URLConstructor, 'revokeObjectURL', bind(nativeRevokeObjectURL, NativeURL));
}

setToStringTag(URLConstructor, 'URL');

$({ global: true, constructor: true, forced: !USE_NATIVE_URL, sham: !DESCRIPTORS }, {
  URL: URLConstructor
});

/**
 * Copyright (c) 2022, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const SessionTimedOutContext = /*#__PURE__*/createContext(false);

/**
 * Enum for modal types.
 */

var SessionTimeoutModalTypes;

(function (SessionTimeoutModalTypes) {
  /**
   * Auto logout based on the counter.
   */
  SessionTimeoutModalTypes["COUNTER"] = "COUNTER";
  /**
   * Default session timeout modal with warning messages.
   */

  SessionTimeoutModalTypes["DEFAULT"] = "DEFAULT";
})(SessionTimeoutModalTypes || (SessionTimeoutModalTypes = {}));
/**
 * Session management provider component.
 *
 * @param props - Props injected to the component.
 * @returns the session management provider component
 */


const SessionManagementProvider = props => {
  const {
    children,
    onSessionLogout,
    onLoginAgain,
    onSessionTimeoutAbort,
    setSessionTimedOut,
    sessionTimedOut,
    modalOptions,
    type
  } = props;
  const timerIntervalID = useRef(null);
  const [sessionTimeoutEventState, setSessionTimeoutEventState] = useState(undefined);
  const [showSessionTimeoutModal, setShowSessionTimeoutModal] = useState(false);
  const [timerDisplay, setTimerDisplay] = useState(undefined);
  useEffect(() => {
    const sessionTimeoutListener = e => {
      const state = e.data;

      if (!state) {
        return;
      }

      setSessionTimeoutEventState(state);
      const {
        url,
        idleTimeout,
        idleWarningTimeout
      } = state;
      const parsedURL = new URL(url);
      const timeout = parsedURL.searchParams.get(CommonConstants.SESSION_TIMEOUT_WARNING_URL_SEARCH_PARAM_KEY);

      if (timeout === undefined) {
        return;
      }

      if (JSON.parse(timeout) && type === SessionTimeoutModalTypes.COUNTER) {
        startTimer(idleTimeout - idleWarningTimeout);
      }

      setSessionTimedOut && setSessionTimedOut(true);
      setShowSessionTimeoutModal(JSON.parse(timeout));
    };

    window.addEventListener("session-timeout", sessionTimeoutListener);
    return () => {
      performCleanupTasks();
      window.removeEventListener("session-timeout", sessionTimeoutListener);
    };
  }, []);
  /**
  * Handles session timeout abort.
  */

  const handleSessionTimeoutAbort = () => {
    if (sessionTimedOut) {
      handleLoginAgain();
      return;
    }

    const parsedURL = new URL(sessionTimeoutEventState.url);

    if (parsedURL && parsedURL.searchParams) {
      if (parsedURL.searchParams.get(CommonConstants.SESSION_TIMEOUT_WARNING_URL_SEARCH_PARAM_KEY)) {
        parsedURL.searchParams.delete(CommonConstants.SESSION_TIMEOUT_WARNING_URL_SEARCH_PARAM_KEY);
        onSessionTimeoutAbort(parsedURL);
      }
    }

    performCleanupTasks();
    setShowSessionTimeoutModal(false);
    setSessionTimedOut && setSessionTimedOut(false);
  };
  /**
  * Handles session logout click.
  */


  const handleSessionLogout = () => {
    performCleanupTasks();
    setShowSessionTimeoutModal(false);
    setSessionTimedOut && setSessionTimedOut(false);
    onSessionLogout();
  };
  /**
  * Handles login again click.
  */


  const handleLoginAgain = () => {
    performCleanupTasks();
    setShowSessionTimeoutModal(false);
    setSessionTimedOut && setSessionTimedOut(false);
    onLoginAgain();
  };
  /**
  * Handles primary button click.
  */


  const handlePrimaryActionClick = () => {
    // If the counter runs out or if the type of the modal is default, try the login again option.
    if (sessionTimedOut || type === SessionTimeoutModalTypes.DEFAULT) {
      handleLoginAgain();
      setSessionTimedOut && setSessionTimedOut(false);
      return;
    } // If the counter hasn't run out, and the type of modal is other than `default` abort the termination.


    handleSessionTimeoutAbort();
    setSessionTimedOut && setSessionTimedOut(false);
  };
  /**
  * Performs housekeeping tasks.
  */


  const performCleanupTasks = () => {
    setTimerDisplay(undefined);
    window.clearInterval(timerIntervalID.current);
    timerIntervalID.current = null;
  };
  /**
  * Starts the timer.
  * @param duration - Timer duration.
  */


  const startTimer = duration => {
    let timer = duration;
    let minutes = 0;
    let seconds = 0;

    if (!timerIntervalID.current) {
      timerIntervalID.current = window.setInterval(() => {
        minutes = Math.floor(timer / 60);
        seconds = Math.floor(timer % 60);
        setTimerDisplay((minutes < 10 ? "0" + minutes : minutes) + ":" + (seconds < 10 ? "0" + seconds : seconds));

        if (--timer < 0) {
          setSessionTimedOut && setSessionTimedOut(true);
          performCleanupTasks();
        }
      }, 1000);
    }
  };

  return /*#__PURE__*/React__default.createElement(SessionTimedOutContext.Provider, {
    value: sessionTimedOut
  }, /*#__PURE__*/React__default.createElement(React__default.Fragment, null, children, /*#__PURE__*/React__default.createElement(SessionTimeoutModal, {
    closeOnEscape: false,
    closeOnDimmerClick: false,
    open: showSessionTimeoutModal,
    onClose: handleSessionTimeoutAbort,
    onPrimaryActionClick: handlePrimaryActionClick,
    onSecondaryActionClick: handleSessionLogout,
    sessionTimeOut: sessionTimedOut,
    heading: type === SessionTimeoutModalTypes.DEFAULT ? /*#__PURE__*/React__default.createElement(Trans, {
      i18nKey: modalOptions === null || modalOptions === void 0 ? void 0 : modalOptions.headingI18nKey
    }, "It looks like you have been inactive for a long time.") : /*#__PURE__*/React__default.createElement(Trans, {
      i18nKey: !sessionTimedOut ? modalOptions === null || modalOptions === void 0 ? void 0 : modalOptions.headingI18nKey : modalOptions === null || modalOptions === void 0 ? void 0 : modalOptions.sessionTimedOutHeadingI18nKey,
      tOptions: {
        time: timerDisplay
      }
    }, "You will be logged out in ", /*#__PURE__*/React__default.createElement("strong", null, timerDisplay), "."),
    description: type === SessionTimeoutModalTypes.DEFAULT ? modalOptions === null || modalOptions === void 0 ? void 0 : modalOptions.description : sessionTimedOut ? modalOptions === null || modalOptions === void 0 ? void 0 : modalOptions.sessionTimedOutDescription : modalOptions === null || modalOptions === void 0 ? void 0 : modalOptions.description,
    primaryButtonText: type === SessionTimeoutModalTypes.DEFAULT ? modalOptions === null || modalOptions === void 0 ? void 0 : modalOptions.primaryButtonText : sessionTimedOut ? modalOptions === null || modalOptions === void 0 ? void 0 : modalOptions.loginAgainButtonText : modalOptions === null || modalOptions === void 0 ? void 0 : modalOptions.primaryButtonText,
    secondaryButtonText: type === SessionTimeoutModalTypes.COUNTER ? modalOptions === null || modalOptions === void 0 ? void 0 : modalOptions.secondaryButtonText : null
  })));
};
/**
 * Default props for the component.
 */

SessionManagementProvider.defaultProps = {
  type: SessionTimeoutModalTypes.DEFAULT
};

export { AdvancedSearch, Alert, AnimatedAvatar, Announcement, AppAvatar, AppLayout, AppSwitcher, AuthLayout, Avatar, AvatarTypes, BaseLayout, Button, COOKIE_CONSENT_COOKIE_NAME, CertFileStrategy, Certificate, ChunkErrorModal, Code, CodeEditor, ColorPicker, ConfirmationModal, ContentLoader, CookieConsentBanner, CopyInputField, DangerButton, DangerZone, DangerZoneGroup, DashboardLayout, DataTable, DataTableBody, DataTableCell, DataTableFooter, DataTableHeader, DataTableHeaderCell, DataTableRow, DefaultFileStrategy, DefaultLayout, DocumentationLink, DocumentationProvider, DynamicField, EditAvatarModal, EditSection, EmphasizedSegment, EmptyPlaceholder, ErrorBoundary, ErrorLayout, FilePicker, FileUpload, Footer, FormInputLabel, FormSection, FullScreenLayout, GenericIcon, GridLayout, Header, Heading, HelpPanel, HelpPanelActionBar, HelpPanelLayout, Hint, IconButton, Iframe, ImagePreview, InfoCard, InlineEditInput, Jumbotron, LabelWithPopup, LabeledCard, LanguageSwitcher, LargeTechnologyCard, Link, LinkButton, ListLayout, Logo, Markdown, Media, MediaContextProvider, Message, MessageInfo, NetworkErrorModal, PageHeader, PageLayout, Pagination, Password, PasswordValidation, Popup, PrimaryButton, ProductBrand, ProtectedRoute, RenderCheckBox, RenderInput, RenderToggle, ResourceGrid, ResourceGridCard, ResourceList, ResourceListHeader, ResourceListHeaderCell, ResourceListItem, ResourceTab, ResourceTabPane, SearchWithFilterLabels, SecondaryButton, Section, SegmentedAccordion, SegmentedAccordionContent, SegmentedAccordionTitle, SelectionCard, SessionManagementProvider, SessionTimedOutContext, SessionTimeoutModal, SessionTimeoutModalTypes, SidePanel, StatCountCard, StatsInsightsWidget, StatsOverviewWidget, StatsQuickLinksWidget, Step, Steps, StickyBar, Switcher, TabPageLayout, TechnologyCard, TemplateCard, TemplateGrid, Text, Tooltip, TopLoadingBar, TransferComponent, TransferList, TransferListItem, TransferListSearch, URLInput, UserAvatar, XMLFileStrategy, rgbToHex, useConfirmationModalAlert, useDocumentation, useInfiniteScroll, useMediaContext, useUIElementSizes, useWindowDimensions, useWizardAlert };
