/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { TestableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent, PropsWithChildren, ReactNode } from "react";
/**
 * Session Management Provider props interface.
 */
export interface SessionManagementProviderPropsInterface extends TestableComponentInterface {
    /**
     * Session timeout abort callback.
     * @param url - Current URL.
     */
    onSessionTimeoutAbort: (url: URL) => void;
    /**
     * Session logout callback.
     */
    onSessionLogout: () => void;
    /**
     * Login again callback.
     */
    onLoginAgain?: () => void;
    /**
     * Session Timed Out callback.
     */
    setSessionTimedOut?: (sessionTimedOut: boolean) => void;
    /**
     * Session Timed Out variable.
     */
    sessionTimedOut?: boolean;
    /**
     * Modal options.
     */
    modalOptions?: SessionManagementModalOptionsInterface;
    /**
     * Type of the modal.
     */
    type: SessionTimeoutModalTypes;
}
/**
 * Session Management modal options interface.
 */
export interface SessionManagementModalOptionsInterface {
    /**
     * Modal Heading localization key.
     */
    headingI18nKey: string;
    /**
     * Modal Description.
     */
    description: ReactNode;
    /**
     * Primary button text.
     */
    primaryButtonText: string | ReactNode;
    /**
     * Secondary button text.
     */
    secondaryButtonText: string | ReactNode;
    /**
     * Login again button text.
     */
    loginAgainButtonText?: string | ReactNode;
    /**
     * Session timed out message i18n heading.
     */
    sessionTimedOutHeadingI18nKey?: string;
    /**
     * Session timed out description.
     */
    sessionTimedOutDescription?: string | ReactNode;
}
/**
 * Session timeout event state interface.
 */
export interface SessionTimeoutEventStateInterface {
    /**
     * URL.
     */
    url: string;
    /**
     * Idle timeout duration.
     */
    idleTimeout: number;
    /**
     * Idle timeout warning time.
     */
    idleWarningTimeout: number;
}
/**
 * Enum for modal types.
 */
export declare enum SessionTimeoutModalTypes {
    /**
     * Auto logout based on the counter.
     */
    COUNTER = "COUNTER",
    /**
     * Default session timeout modal with warning messages.
     */
    DEFAULT = "DEFAULT"
}
/**
 * Session management provider component.
 *
 * @param props - Props injected to the component.
 * @returns the session management provider component
 */
export declare const SessionManagementProvider: FunctionComponent<PropsWithChildren<SessionManagementProviderPropsInterface>>;
