/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Class containing form field data constants.
 */
export declare class FieldTestConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    private constructor();
    static readonly BUTTON_VALUE: string;
    static readonly HIDE_PASSWORD: string;
    static readonly PASSWORD_LABEL: string;
    static readonly PASSWORD_NAME: string;
    static readonly PASSWORD_PLACEHOLDER: string;
    static readonly PASSWORD_REQUIRED_MESSAGE: string;
    static readonly PASSWORD_VALIDATION_FAILED: string;
    static readonly PASSWORD_VALID_MESSAGE: string;
    static readonly PASSWORD_VALUE: string;
    static readonly SHOW_PASSWORD: string;
    static readonly SUBMIT: string;
    static readonly TEXT_FIELD_LABEL: string;
    static readonly TEXT_FIELD_NAME: string;
    static readonly TEXT_FIELD_PLACEHOLDER: string;
    static readonly TEXT_FIELD_VALIDATION_FAILED: string;
    static readonly TEXT_FIELD_REQUIRED_MESSAGE = "This field is required";
    static readonly TEXT_FIELD_VALID_MESSAGE: string;
    static readonly TEXT_FIELD_VALUE: string;
    static readonly TEXT_FIELD_ARIA_LABEL: string;
    static readonly TEXT_FIELD_TYPE_NAME: string;
    static readonly listen: any;
    static readonly onClick: any;
    static readonly onSubmit: any;
}
