/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent, ReactNode } from "react";
/**
 * Prop type of the `NetworkErrorModal` component.
 */
interface NetworkErrorModalPropTypes extends IdentifiableComponentInterface {
    heading: ReactNode;
    description: ReactNode;
    primaryActionText: ReactNode;
    primaryAction: () => void;
}
/**
 * This component listens to the `network_error_event` Event and pops up a modal
 * when this Event is dispatched.
 *
 * This is used to show an error message when an API call fails due to a `401` error
 * or a network-timeout error.
 *
 * @param props - The props passed into the component.
 *
 * @returns the component that pops up a modal when there is a network error.
 */
export declare const NetworkErrorModal: FunctionComponent<NetworkErrorModalPropTypes>;
export {};
