/**
 * Copyright (c) 2022, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface } from "@wso2is/core/models";
import React, { FunctionComponent, PropsWithChildren } from "react";
import { ColorPickerProps, ColorResult } from "react-color";
import { SketchPickerProps } from "react-color/lib/components/sketch/Sketch";
/**
 * Color Picker component Prop types.
 */
export interface ColorPickerPropsInterface extends ColorPickerProps<SketchPickerProps | any>, IdentifiableComponentInterface {
    /**
     * Additional CSS Classes
     */
    className?: string;
    /**
     * Picker component supported by `react-color`. Default is `SketchPicker`.
     */
    picker?: React.ComponentType<SketchPickerProps | any> | undefined;
    /**
     * Is rendered in a Popup.
     */
    popup?: boolean;
    /**
     * Show/Hide picker.
     */
    show?: boolean;
}
export declare type ColorPickerResponseInterface = ColorResult;
/**
 * Color Picker Component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the color picker React component.
 */
export declare const ColorPicker: FunctionComponent<PropsWithChildren<ColorPickerPropsInterface>>;
