/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the 'License'); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * 'AS IS' BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { DisplayCertificate } from "../models";
/**
 * Class containing certificate related constants which can be used across several applications.
 */
export declare class CertificateManagementConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     * @hideConstructor
     */
    private constructor();
    /**
     * Contains the terminating line of a PEM certificate.
     * @constant
     * @type {string}
     * @default
     */
    static readonly CERTIFICATE_END: string;
    /**
     * Contains the first line of a PEM certificate.
     * @constant
     * @type {string}
     * @default
     */
    static readonly CERTIFICATE_BEGIN: string;
    /**
     * Contains the first line of a PEM certificate.
     * @constant
     * @type {string}
     */
    static readonly END_LINE: string;
    /**
     * Denotes "Not Available"
     */
    static readonly NOT_AVAILABLE = "N/A";
    /**
     * An empty string. Used in case DN or issuers are empty.
     */
    static readonly EMPTY_STRING = "";
    /**
     * Used for unreadable certificates avatar name.
     */
    static readonly QUESTION_MARK = "?";
    /**
     * Used in between intermediate strings in cert interfaces.
     */
    static readonly SPACE_CHARACTER = " ";
    /**
     * An empty pass.
     * @constructor
     */
    static readonly NO_OPERATIONS: () => void;
    /**
     * Dummy certificate as a placeholder.
     */
    static readonly DUMMY_DISPLAY_CERTIFICATE: DisplayCertificate;
    /**
     * Supported key algorithm types.
     * {@link https://www.npmjs.com/package/node-forge#pki}
     */
    static readonly SUPPORTED_KEY_ALGORITHMS: string[];
}
