/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Schema for the common namespace
 */
export interface CommonNS {
    access: string;
    actions: string;
    activate: string;
    active: string;
    add: string;
    addKey: string;
    addURL: string;
    all: string;
    applicationName: string;
    applications: string;
    approvalStatus: string;
    approve: string;
    apps: string;
    assignee: string;
    assignees: string;
    authenticator: string;
    authentication: string;
    authenticator_plural: string;
    back: string;
    browser: string;
    cancel: string;
    challengeQuestionNumber: string;
    change: string;
    chunkLoadErrorMessage: {
        heading: string;
        description: string;
        primaryActionText: string;
    };
    claim: string;
    clear: string;
    clientId: string;
    close: string;
    comingSoon: string;
    completed: string;
    configure: string;
    confirm: string;
    contains: string;
    continue: string;
    copyToClipboard: string;
    createdOn: string;
    create: string;
    dangerZone: string;
    darkMode: string;
    delete: string;
    description: string;
    deviceModel: string;
    docs: string;
    documentation: string;
    done: string;
    download: string;
    drag: string;
    duplicateURLError: string;
    edit: string;
    endsWith: string;
    equals: string;
    exitFullScreen: string;
    explore: string;
    export: string;
    featureAvailable: string;
    filter: string;
    finish: string;
    goBackHome: string;
    goFullScreen: string;
    help: string;
    hide: string;
    hidePassword: string;
    identityProviders: string;
    import: string;
    initiator: string;
    ipAddress: string;
    issuer: string;
    lastAccessed: string;
    lastModified: string;
    lastSeen: string;
    lastUpdatedOn: string;
    learnMore: string;
    lightMode: string;
    loading: string;
    loginTime: string;
    logout: string;
    maximize: string;
    maxValidation: string;
    minimize: string;
    minValidation: string;
    more: string;
    myAccount: string;
    name: string;
    new: string;
    next: string;
    operatingSystem: string;
    operations: string;
    overview: string;
    personalInfo: string;
    pin: string;
    pinned: string;
    preview: string;
    previous: string;
    priority: string;
    privacy: string;
    properties: string;
    ready: string;
    regenerate: string;
    register: string;
    removeAll: string;
    reject: string;
    release: string;
    remove: string;
    reserved: string;
    resetFilters: string;
    retry: string;
    revoke: string;
    revokeAll: string;
    required: string;
    samples: string;
    save: string;
    services: string;
    sdks: string;
    search: string;
    security: string;
    settings: string;
    setup: string;
    show: string;
    showAll: string;
    showLess: string;
    showMore: string;
    showPassword: string;
    skip: string;
    generatePassword: string;
    startsWith: string;
    step: string;
    submit: string;
    switch: string;
    technologies: string;
    terminate: string;
    terminateAll: string;
    terminateSession: string;
    type: string;
    unpin: string;
    unpinned: string;
    update: string;
    user: string;
    verify: string;
    view: string;
    weakPassword: string;
    good: string;
    strong: string;
    weak: string;
    tooShort: string;
    okay: string;
    enabled: string;
    disabled: string;
    enable: string;
    disable: string;
    networkErrorMessage: {
        heading: string;
        description: string;
        primaryActionText: string;
    };
}
