/**
 * Copyright (c) 2019, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from "react";
/**
 * This component renders Form elements based on the provided `type` prop.
 *
 * @param props - The form field.
 */
export declare const Field: React.ForwardRefExoticComponent<(import("../models").ScopesField | import("../models").QueryParamsField | Pick<import("../models").TextField, keyof import("../models").TextField> | Pick<import("../models").PasswordField, keyof import("../models").PasswordField> | Pick<import("../models").FormSubmit, keyof import("../models").FormSubmit> | Pick<import("../models").RadioField, keyof import("../models").RadioField> | Pick<import("../models").DropdownField, keyof import("../models").DropdownField> | Pick<import("../models").CheckboxField, keyof import("../models").CheckboxField> | Pick<import("../models").Reset, keyof import("../models").Reset> | Pick<import("../models").FormButton, keyof import("../models").FormButton> | Pick<import("../models").FormDivider, keyof import("../models").FormDivider> | Pick<import("../models").CustomField, keyof import("../models").CustomField> | Pick<import("../models").ToggleField, keyof import("../models").ToggleField>) & React.RefAttributes<unknown>>;
/**
 * Prop types for the GroupFields component
 */
interface GroupFieldsPropsInterface {
    wrapper: React.ComponentType;
    wrapperProps: any;
}
/**
 * This component groups form elements together.
 *
 * @param props - The children to be grouped.
 */
export declare const GroupFields: (props: React.PropsWithChildren<GroupFieldsPropsInterface>) => JSX.Element;
export {};
