/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
/**
 * Class containing Identity Provider Edit Page constants.
 */
export declare class IdentityProviderEditPageConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    private constructor();
    static readonly PAGE_URL_MATCHER: string;
    static readonly PAGE_LAYOUT_HEADER_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_TITLE_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_SUB_TITLE_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_BACK_BUTTON_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_IMAGE_WRAPPER_DATA_ATTR: string;
    static readonly RESOURCE_TABS_DATA_ATTR: string;
    static readonly RESOURCE_TABS_MENU_DATA_ATTR: string;
    static readonly IDP_NAME_INPUT_DATA_ATTR: string;
    static readonly IDP_DESCRIPTION_INPUT_DATA_ATTR: string;
    static readonly IDP_IMAGE_INPUT_DATA_ATTR: string;
    static readonly GENERAL_SETTINGS_SUBMIT_BUTTON_DATA_ATTR: string;
    static readonly IDP_CERT_RADIO_GROUP_DATA_ATTR: string;
    static readonly IDP_CERT_JWKS_URL_INPUT_DATA_ATTR: string;
    static readonly IDP_CERT_UPDATE_BUTTON_DATA_ATTR: string;
    static readonly DANGER_ZONE_DELETE_BUTTON_DATA_ATTR: string;
    static readonly IDP_DELETE_ASSERTION_DATA_ATTR: string;
    static readonly IDP_DELETE_ASSERTION_INPUT_DATA_ATTR: string;
    static readonly IDP_DELETE_CONFIRM_BUTTON_DATA_ATTR: string;
    static readonly IDP_DELETE_CONFIRM_MODAL_CLOSE_BUTTON_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_WIZARD_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_WIZARD_UNSELECTED_LIST_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_WIZARD_SELECTED_LIST_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_WIZARD_LIST_ADD_BUTTON_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_WIZARD_LIST_REMOVE_BUTTON_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_WIZARD_LIST_SAVE_BUTTON_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_WIZARD_LIST_CANCEL_BUTTON_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_LIST_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_LIST_EMPTY_PLACEHOLDER_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_LIST_EMPTY_PLACEHOLDER_ACTION_DATA_ATTR: string;
    static readonly CLAIM_ATTR_SELECT_LIST_EDIT_BUTTON_DATA_ATTR: string;
    static readonly SUBJECT_ATTRIBUTE_DROPDOWN_DATA_ATTR: string;
}
