/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
/**
 * Class file containing remote configuration constants.
 */
export declare class RemoteConfigurationPageConstants {
    /**
     * Private constructor to avoid object instantiation from outside
     * the class.
     *
     * @hideconstructor
     */
    private constructor();
    static readonly SAVE_CONFIG_DATA_ATTR: string;
    static readonly CONFIG_FORM_DATA_ATTR: string;
    static readonly REMOVE_CONFIG_DATA_ATTR: string;
    static readonly REMOVE_CONFIG_MODAL_DATA_ATTR: string;
    static readonly REMOVE_CONFIG_MODAL_ASSERT_INPUT_DATA_ATTR: string;
    static readonly REMOVE_CONFIG_MODAL_CONFIRM_DATA_ATTR: string;
    static readonly CONFIG_FORM_GIT_URL_DATA_ATTR: string;
    static readonly CONFIG_FORM_GIT_BRANCH_DATA_ATTR: string;
    static readonly CONFIG_FORM_GIT_DIRECTORY_DATA_ATTR: string;
    static readonly CONFIG_FORM_GIT_POLLING_DATA_ATTR: string;
    static readonly CONFIG_FORM_GIT_USERNAME_DATA_ATTR: string;
    static readonly CONFIG_FORM_GIT_ACCESS_TOKEN_DATA_ATTR: string;
    static readonly CONFIG_FORM_GIT_SAVE_CONFIG_DATA_ATTR: string;
    static readonly CONFIG_FORM_GIT_STATUS_DATA_ATTR: string;
    static readonly REMOTE_FETCH_APPLICATION_STATUS: string;
    static readonly REMOTE_FETCH_TRIGGER_CONFIG: string;
    static readonly REMOTE_FETCH_TRIGGER_SUCCESS: string;
    static readonly REMOTE_FETCH_TRIGGER_FAILED: string;
    static readonly PAGE_LAYOUT_HEADER_DATA_ATTR: string;
    static readonly PAGE_LAYOUT_HEADER_TITLE_DATA_ATTR: string;
}
