/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { RouteInterface } from "@wso2is/core/models";
/**
 * A class to contain util functions related to access control
 */
export declare class AccessControlUtils {
    static readonly MANAGE_GETTING_STARTED_ID: string;
    static readonly DEVELOP_GETTING_STARTED_ID: string;
    /**
     * Util method to filter base routes based on user scopes retrieved via the token call.
     *
     * @param routeArray - Un authenticated routes array
     * @param allowedScopes - user scopes
     * @param featureConfig - feature scope configuration
     * @param checkForUIResourceScopes - Specifies if the UI resource scope should be considered
     * @returns filtered route array based on the user scopes
     */
    static getAuthenticatedRoutes<T = any>(routeArray: RouteInterface[], allowedScopes: string, featureConfig: T, // TODO : Properly map FeatureConfigInterface type
    checkForUIResourceScopes?: boolean): RouteInterface[];
    /**
     * Util method to retrieve if a single tab is disabled via iterating routes based on scopes.
     *
     * @param manageRoutes - routes related to manage section
     * @param developRoutes - routes related to develop section
     * @param allowedScopes - allowed scopes
     * @param featureConfig - feature config
     * @param checkForUIResourceScopes - Specifies if the UI resource scope should be considered
     * @returns
     */
    static getDisabledTab<T = any>(manageRoutes: RouteInterface[], developRoutes: RouteInterface[], allowedScopes: string, featureConfig: T, // TODO : Properly map FeatureConfigInterface type
    checkForUIResourceScopes?: boolean): string;
}
