"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RefFindNode = void 0;
var React = require("react");
var ReactDOM = require("react-dom");
var utils_1 = require("./utils");
/**
 * Detects if a passed element is a Fiber object instead of an element. Is needed as `ReactDOM.findDOMNode()` returns
 * a Fiber in `react-test-renderer` that can cause issues with tests. Is used only in non-production env.
 *
 * @see https://github.com/facebook/react/issues/7371#issuecomment-317396864
 * @see https://github.com/Semantic-Org/Semantic-UI-React/issues/4061#issuecomment-694895617
 */
function isFiberRef(node) {
    if (node === null) {
        return false;
    }
    if (node instanceof Element || node instanceof Text) {
        return false;
    }
    return !!(node.type && node.tag);
}
var RefFindNode = /** @class */ (function (_super) {
    __extends(RefFindNode, _super);
    function RefFindNode() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RefFindNode.prototype.componentDidMount = function () {
        var currentNode = ReactDOM.findDOMNode(this);
        if (process.env.NODE_ENV !== 'production') {
            if (isFiberRef(currentNode)) {
                currentNode = null;
            }
        }
        this.prevNode = currentNode;
        utils_1.handleRef(this.props.innerRef, currentNode);
    };
    RefFindNode.prototype.componentDidUpdate = function (prevProps) {
        var currentNode = ReactDOM.findDOMNode(this);
        if (process.env.NODE_ENV !== 'production') {
            if (isFiberRef(currentNode)) {
                currentNode = null;
            }
        }
        if (this.prevNode !== currentNode) {
            this.prevNode = currentNode;
            utils_1.handleRef(this.props.innerRef, currentNode);
        }
        if (prevProps.innerRef !== this.props.innerRef) {
            utils_1.handleRef(this.props.innerRef, currentNode);
        }
    };
    RefFindNode.prototype.componentWillUnmount = function () {
        utils_1.handleRef(this.props.innerRef, null);
        delete this.prevNode;
    };
    RefFindNode.prototype.render = function () {
        var children = this.props.children;
        return children;
    };
    return RefFindNode;
}(React.Component));
exports.RefFindNode = RefFindNode;
