/**
 * This configuration is intended to be applied to ONLY .ts and .tsx files within a
 * React project in an Nx workspace.
 *
 * It should therefore NOT contain any rules or plugins which are generic
 * to all variants of React projects, e.g. TypeScript vs JavaScript, .js vs .jsx etc
 *
 * This configuration is intended to be combined with other configs from this
 * package.
 */
declare const _default: {
    rules: {
        'default-case': string;
        'no-dupe-class-members': string;
        'no-undef': string;
        '@typescript-eslint/consistent-type-assertions': string;
        'no-array-constructor': string;
        '@typescript-eslint/no-array-constructor': string;
        '@typescript-eslint/no-namespace': string;
        'no-use-before-define': string;
        '@typescript-eslint/no-use-before-define': (string | {
            functions: boolean;
            classes: boolean;
            variables: boolean;
            typedefs: boolean;
        })[];
        'no-unused-vars': string;
        '@typescript-eslint/no-unused-vars': (string | {
            args: string;
            ignoreRestSiblings: boolean;
        })[];
        'no-useless-constructor': string;
        '@typescript-eslint/no-useless-constructor': string;
        '@typescript-eslint/no-unused-expressions': (string | {
            allowShortCircuit: boolean;
            allowTernary: boolean;
            allowTaggedTemplates: boolean;
        })[];
    };
};
export default _default;
