export declare function isIdentifierStart(code: number): boolean;
export declare function isIdentifierChar(code: number): boolean;
export declare function isIdentifierName(name: string): boolean;
/**
 * Checks if word is a reserved word in non-strict mode
 */
export declare function isReservedWord(word: string, inModule?: boolean): boolean;
/**
 * Checks if word is a reserved word in non-binding strict mode
 *
 * Includes non-strict reserved words
 */
export declare function isStrictReservedWord(word: string, inModule: boolean): boolean;
/**
 * Checks if word is a reserved word in binding strict mode, but it is allowed as
 * a normal identifier.
 */
export declare function isStrictBindOnlyReservedWord(word: string): boolean;
/**
 * Checks if word is a reserved word in binding strict mode
 *
 * Includes non-strict reserved words and non-binding strict reserved words
 */
export declare function isStrictBindReservedWord(word: string, inModule: boolean): boolean;
export declare function isKeyword(word: string): boolean;
