"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.e2eProjectSchematic = exports.e2eProjectGenerator = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const jest_1 = require("@nrwl/jest");
const typescript_1 = require("@nrwl/workspace/src/utilities/typescript");
const path = require("path");
function normalizeOptions(host, options) {
    var _a;
    const { npmScope, appsDir } = (0, devkit_1.getWorkspaceLayout)(host);
    const projectName = `${options.pluginName}-e2e`;
    const projectRoot = options.projectDirectory
        ? (0, devkit_1.joinPathFragments)(appsDir, `${options.projectDirectory}-e2e`)
        : (0, devkit_1.joinPathFragments)(appsDir, projectName);
    const pluginPropertyName = (0, devkit_1.names)(options.pluginName).propertyName;
    return Object.assign(Object.assign({}, options), { minimal: (_a = options.minimal) !== null && _a !== void 0 ? _a : false, projectName,
        pluginPropertyName,
        projectRoot,
        npmScope });
}
function validatePlugin(host, pluginName) {
    try {
        (0, devkit_1.readProjectConfiguration)(host, pluginName);
    }
    catch (_a) {
        throw new Error(`Project name "${pluginName}" doesn't not exist.`);
    }
}
function addFiles(host, options) {
    (0, devkit_1.generateFiles)(host, path.join(__dirname, './files'), options.projectRoot, Object.assign(Object.assign({}, options), { tmpl: '', rootTsConfigPath: (0, typescript_1.getRelativePathToRootTsConfig)(host, options.projectRoot) }));
}
function updateWorkspaceConfiguration(host, options) {
    (0, devkit_1.addProjectConfiguration)(host, options.projectName, {
        root: options.projectRoot,
        projectType: 'application',
        sourceRoot: `${options.projectRoot}/src`,
        targets: {
            e2e: {
                executor: '@nrwl/nx-plugin:e2e',
                options: { target: `${options.pluginName}:build` },
            },
        },
        tags: [],
        implicitDependencies: [options.pluginName],
    }, options.standaloneConfig);
}
function addJest(host, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        yield (0, jest_1.jestProjectGenerator)(host, {
            project: options.projectName,
            setupFile: 'none',
            supportTsx: false,
            skipSerializers: true,
        });
        const project = (0, devkit_1.readProjectConfiguration)(host, options.projectName);
        const testOptions = project.targets.test.options;
        const e2eOptions = project.targets.e2e.options;
        project.targets.e2e.options = Object.assign(Object.assign({}, e2eOptions), { jestConfig: testOptions.jestConfig });
        // remove the jest build target
        delete project.targets.test;
        (0, devkit_1.updateProjectConfiguration)(host, options.projectName, project);
    });
}
function e2eProjectGenerator(host, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        validatePlugin(host, schema.pluginName);
        const options = normalizeOptions(host, schema);
        addFiles(host, options);
        updateWorkspaceConfiguration(host, options);
        yield addJest(host, options);
        yield (0, devkit_1.formatFiles)(host);
    });
}
exports.e2eProjectGenerator = e2eProjectGenerator;
exports.default = e2eProjectGenerator;
exports.e2eProjectSchematic = (0, devkit_1.convertNxGenerator)(e2eProjectGenerator);
//# sourceMappingURL=e2e.js.map