export declare function patchPackageJsonForPlugin(npmPackageName: string, distPath: string): void;
/**
 * Generate a unique name for running CLI commands
 * @param prefix
 *
 * @returns `'<prefix><random number>'`
 */
export declare function uniq(prefix: string): string;
/**
 * Run the appropriate package manager install command in the e2e directory
 * @param silent silent output from the install
 */
export declare function runPackageManagerInstall(silent?: boolean): string;
/**
 * Creates a new nx project in the e2e directory
 *
 * @param npmPackageName package name to test
 * @param pluginDistPath dist path where the plugin was outputted to
 */
export declare function newNxProject(npmPackageName: string, pluginDistPath: string): void;
/**
 * Ensures that a project has been setup in the e2e directory
 * It will also copy `@nrwl` packages to the e2e directory
 */
export declare function ensureNxProject(npmPackageName?: string, pluginDistPath?: string): void;
