import type { JsonParseOptions } from '@nrwl/devkit';
import { directoryExists, fileExists } from 'nx/src/utils/fileutils';
export { directoryExists, fileExists };
/**
 * Copies module folders from the working directory to the e2e directory
 * @param modules a list of module names or scopes to copy
 */
export declare function copyNodeModules(modules: string[]): void;
/**
 * Assert test output from a asynchronous CLI command.
 *
 * @param output Output from an asynchronous command
 */
export declare function expectTestsPass(output: {
    stdout: string;
    stderr: string;
}): void;
/**
 * Update a file's content in the e2e directory.
 *
 * If the `content` param is a callback, it will provide the original file content as an argument.
 *
 * @param file Path of the file in the e2e directory
 * @param content Content to replace the original content with
 */
export declare function updateFile(file: string, content: string | ((originalFileContent: string) => string)): void;
/**
 * Rename a file or directory within the e2e directory.
 * @param path Original path
 * @param newPath New path
 */
export declare function renameFile(path: string, newPath: string): void;
/**
 * Check if the file or directory exists.
 *
 * If a path starts with `/` or `C:/`, it will check it as absolute. Otherwise it will check within the e2e directory.
 *
 * @param expectedPaths Files or directories to check
 * @usage `checkFileExists('file1', 'file2', '/var/user/file')`
 */
export declare function checkFilesExist(...expectedPaths: string[]): void;
/**
 * Get a list of all files within a directory.
 * @param dirName Directory name within the e2e directory.
 */
export declare function listFiles(dirName: string): string[];
/**
 * Read a JSON file.
 * @param path Path to the JSON file. Absolute or relative to the e2e directory.
 * @param options JSON parse options
 */
export declare function readJson<T extends object = any>(path: string, options?: JsonParseOptions): T;
/**
 * Read a file.
 * @param path Path to the file. Absolute or relative to the e2e directory.
 */
export declare function readFile(path: string): string;
/**
 * Deletes the e2e directory
 */
export declare function cleanup(): void;
/**
 * Remove the dist folder from the e2e directory
 */
export declare function rmDist(): void;
/**
 * Get the currend `cwd` in the process
 */
export declare function getCwd(): string;
/**
 * Check if a file or directory exists.
 * @param path Path to file or directory
 */
export declare function exists(path: string): boolean;
/**
 * Get the size of a file on disk
 * @param filePath Path to the file
 */
export declare function getSize(filePath: string): number;
