"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const dev_server_impl_1 = require("@nrwl/web/src/executors/dev-server/dev-server.impl");
const path_1 = require("path");
const async_iterator_1 = require("../../utils/async-iterator");
function moduleFederationDevServer(options, context) {
    var _a;
    return tslib_1.__asyncGenerator(this, arguments, function* moduleFederationDevServer_1() {
        let iter = (0, dev_server_impl_1.default)(options, context);
        const p = context.workspace.projects[context.projectName];
        const moduleFederationConfigPath = (0, path_1.join)(context.root, p.root, 'module-federation.config.js');
        let moduleFederationConfig;
        try {
            moduleFederationConfig = require(moduleFederationConfigPath);
        }
        catch (_b) {
            // TODO(jack): Add a link to guide
            throw new Error(`Could not load ${moduleFederationConfigPath}. Was this project generated with "@nrwl/react:host"?`);
        }
        const knownRemotes = (_a = moduleFederationConfig.remotes) !== null && _a !== void 0 ? _a : [];
        const devServeApps = !options.devRemotes
            ? []
            : Array.isArray(options.devRemotes)
                ? options.devRemotes
                : [options.devRemotes];
        for (const app of knownRemotes) {
            const [appName] = Array.isArray(app) ? app : [app];
            const isDev = devServeApps.includes(appName);
            iter = (0, async_iterator_1.combineAsyncIterators)(iter, yield tslib_1.__await((0, devkit_1.runExecutor)({
                project: appName,
                target: isDev ? 'serve' : 'serve-static',
                configuration: context.configurationName,
            }, {
                watch: isDev,
            }, context)));
        }
        let numAwaiting = knownRemotes.length + 1; // remotes + host
        return yield tslib_1.__await(yield tslib_1.__await(yield* tslib_1.__asyncDelegator(tslib_1.__asyncValues((0, async_iterator_1.tapAsyncIterator)(iter, (x) => {
            var _a, _b;
            numAwaiting--;
            if (numAwaiting === 0) {
                devkit_1.logger.info(`Host is ready: ${(_a = options.host) !== null && _a !== void 0 ? _a : 'localhost'}:${(_b = options.port) !== null && _b !== void 0 ? _b : 4200}`);
            }
        })))));
    });
}
exports.default = moduleFederationDevServer;
//# sourceMappingURL=module-federation-dev-server.impl.js.map