"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateJestConfig = void 0;
const jest_utils_1 = require("../../../utils/jest-utils");
const devkit_1 = require("@nrwl/devkit");
function updateJestConfig(host, options) {
    if (options.unitTestRunner !== 'jest') {
        return;
    }
    (0, devkit_1.updateJson)(host, `${options.appProjectRoot}/tsconfig.spec.json`, (json) => {
        const offset = (0, devkit_1.offsetFromRoot)(options.appProjectRoot);
        json.files = [
            `${offset}node_modules/@nrwl/react/typings/cssmodule.d.ts`,
            `${offset}node_modules/@nrwl/react/typings/image.d.ts`,
        ];
        if (options.style === 'styled-jsx') {
            json.files.unshift(`${offset}node_modules/@nrwl/react/typings/styled-jsx.d.ts`);
        }
        return json;
    });
    const configPath = `${options.appProjectRoot}/jest.config.${options.js ? 'js' : 'ts'}`;
    const originalContent = host.read(configPath, 'utf-8');
    const content = (0, jest_utils_1.updateJestConfigContent)(originalContent);
    host.write(configPath, content);
}
exports.updateJestConfig = updateJestConfig;
//# sourceMappingURL=update-jest-config.js.map