"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hookSchematic = exports.hookGenerator = void 0;
const tslib_1 = require("tslib");
// TODO(jack): Remove inline renderHook function when RTL releases with its own version
const ts = require("typescript");
const devkit_1 = require("@nrwl/devkit");
const ast_utils_1 = require("../../utils/ast-utils");
function hookGenerator(host, schema) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const options = yield normalizeOptions(host, schema);
        createFiles(host, options);
        addExportsToBarrel(host, options);
        return yield (0, devkit_1.formatFiles)(host);
    });
}
exports.hookGenerator = hookGenerator;
function createFiles(host, options) {
    const hookDir = (0, devkit_1.joinPathFragments)(options.projectSourceRoot, options.directory);
    (0, devkit_1.generateFiles)(host, (0, devkit_1.joinPathFragments)(__dirname, './files'), hookDir, Object.assign(Object.assign({}, options), { tmpl: '' }));
    for (const c of host.listChanges()) {
        let deleteFile = false;
        if (options.skipTests && /.*spec.ts/.test(c.path)) {
            deleteFile = true;
        }
        if (deleteFile) {
            host.delete(c.path);
        }
    }
    if (options.js) {
        (0, devkit_1.toJS)(host);
    }
}
function addExportsToBarrel(host, options) {
    const workspace = (0, devkit_1.getProjects)(host);
    const isApp = workspace.get(options.project).projectType === 'application';
    if (options.export && !isApp) {
        const indexFilePath = (0, devkit_1.joinPathFragments)(options.projectSourceRoot, options.js ? 'index.js' : 'index.ts');
        const indexSource = host.read(indexFilePath, 'utf-8');
        if (indexSource !== null) {
            const indexSourceFile = ts.createSourceFile(indexFilePath, indexSource, ts.ScriptTarget.Latest, true);
            const changes = (0, devkit_1.applyChangesToString)(indexSource, (0, ast_utils_1.addImport)(indexSourceFile, `export * from './${options.directory}/${options.fileName}';`));
            host.write(indexFilePath, changes);
        }
    }
}
function normalizeOptions(host, options) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        assertValidOptions(options);
        let base = options.name;
        if (base.startsWith('use-')) {
            base = base.substring(4);
        }
        else if (base.startsWith('use')) {
            base = base.substring(3);
        }
        const { className, fileName } = (0, devkit_1.names)(base);
        const hookFilename = options.pascalCaseFiles
            ? 'use'.concat(className)
            : 'use-'.concat(fileName);
        const hookName = 'use'.concat(className);
        const hookTypeName = 'Use'.concat(className);
        const project = (0, devkit_1.getProjects)(host).get(options.project);
        if (!project) {
            devkit_1.logger.error(`Cannot find the ${options.project} project. Please double check the project name.`);
            throw new Error();
        }
        const { sourceRoot: projectSourceRoot, projectType } = project;
        const directory = yield getDirectory(host, options, base);
        if (options.export && projectType === 'application') {
            devkit_1.logger.warn(`The "--export" option should not be used with applications and will do nothing.`);
        }
        return Object.assign(Object.assign({}, options), { directory,
            hookName,
            hookTypeName, fileName: hookFilename, projectSourceRoot });
    });
}
function getDirectory(host, options, baseHookName) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const { className, fileName } = (0, devkit_1.names)(baseHookName);
        const hookFileName = options.pascalCaseDirectory === true
            ? 'use'.concat(className)
            : 'use-'.concat(fileName);
        const workspace = (0, devkit_1.getProjects)(host);
        let baseDir;
        if (options.directory) {
            baseDir = options.directory;
        }
        else {
            baseDir =
                workspace.get(options.project).projectType === 'application'
                    ? 'app'
                    : 'lib';
        }
        return options.flat ? baseDir : (0, devkit_1.joinPathFragments)(baseDir, hookFileName);
    });
}
function assertValidOptions(options) {
    const slashes = ['/', '\\'];
    slashes.forEach((s) => {
        if (options.name.indexOf(s) !== -1) {
            const [name, ...rest] = options.name.split(s).reverse();
            let suggestion = rest.map((x) => x.toLowerCase()).join(s);
            if (options.directory) {
                suggestion = `${options.directory}${s}${suggestion}`;
            }
            throw new Error(`Found "${s}" in the hook name. Did you mean to use the --directory option (e.g. \`nx g c ${name} --directory ${suggestion}\`)?`);
        }
    });
}
exports.default = hookGenerator;
exports.hookSchematic = (0, devkit_1.convertNxGenerator)(hookGenerator);
//# sourceMappingURL=hook.js.map