"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addModuleFederationFiles = void 0;
const devkit_1 = require("@nrwl/devkit");
const path_1 = require("path");
const normalize_options_1 = require("../../application/lib/normalize-options");
function addModuleFederationFiles(host, options, defaultRemoteManifest) {
    const templateVariables = Object.assign(Object.assign(Object.assign({}, (0, devkit_1.names)(options.name)), options), { tmpl: '', remotes: defaultRemoteManifest.map(({ name, port }) => {
            const remote = (0, normalize_options_1.normalizeProjectName)(Object.assign(Object.assign({}, options), { name }));
            return Object.assign(Object.assign({}, (0, devkit_1.names)(remote)), { port });
        }) });
    // Module federation requires bootstrap code to be dynamically imported.
    // Renaming original entry file so we can use `import(./bootstrap)` in
    // new entry file.
    host.rename((0, path_1.join)(options.appProjectRoot, 'src/main.tsx'), (0, path_1.join)(options.appProjectRoot, 'src/bootstrap.tsx'));
    // New entry file is created here.
    (0, devkit_1.generateFiles)(host, (0, path_1.join)(__dirname, `../files/module-federation`), options.appProjectRoot, templateVariables);
    (0, devkit_1.generateFiles)(host, (0, path_1.join)(__dirname, `../files/common`), options.appProjectRoot, templateVariables);
}
exports.addModuleFederationFiles = addModuleFederationFiles;
//# sourceMappingURL=add-module-federation-files.js.map