"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.update = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
function update(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const projects = (0, devkit_1.getProjects)(tree);
        projects.forEach((config, name) => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
            var _l, _m, _o, _p, _q, _r;
            let shouldUpdate = false;
            if (((_b = (_a = config.targets) === null || _a === void 0 ? void 0 : _a.build) === null || _b === void 0 ? void 0 : _b.executor) === '@nrwl/web:webpack') {
                shouldUpdate = true;
                (_c = (_l = config.targets.build).defaultConfiguration) !== null && _c !== void 0 ? _c : (_l.defaultConfiguration = 'production');
                (_d = (_m = config.targets.build).configurations) !== null && _d !== void 0 ? _d : (_m.configurations = {});
                (_e = (_o = config.targets.build.configurations).development) !== null && _e !== void 0 ? _e : (_o.development = {
                    extractLicenses: false,
                    optimization: false,
                    sourceMap: true,
                    vendorChunk: true,
                });
            }
            if (((_g = (_f = config.targets) === null || _f === void 0 ? void 0 : _f.serve) === null || _g === void 0 ? void 0 : _g.executor) === '@nrwl/web:dev-server') {
                shouldUpdate = true;
                (_h = (_p = config.targets.serve).defaultConfiguration) !== null && _h !== void 0 ? _h : (_p.defaultConfiguration = 'development');
                (_j = (_q = config.targets.serve).configurations) !== null && _j !== void 0 ? _j : (_q.configurations = {});
                (_k = (_r = config.targets.serve.configurations).development) !== null && _k !== void 0 ? _k : (_r.development = {
                    buildTarget: `${name}:build:development`,
                });
            }
            if (shouldUpdate)
                (0, devkit_1.updateProjectConfiguration)(tree, name, config);
        });
        yield (0, devkit_1.formatFiles)(tree);
    });
}
exports.update = update;
exports.default = update;
//# sourceMappingURL=add-default-development-configurations.js.map