"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateExternalEmotionJsxRuntime = void 0;
const tslib_1 = require("tslib");
const devkit_1 = require("@nrwl/devkit");
const executor_options_utils_1 = require("@nrwl/workspace/src/utilities/executor-options-utils");
function updateExternalEmotionJsxRuntime(tree) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        (0, executor_options_utils_1.forEachExecutorOptions)(tree, '@nrwl/web:rollup', (options, projectName, targetName, configurationName) => {
            const projectConfiguration = (0, devkit_1.readProjectConfiguration)(tree, projectName);
            const config = configurationName
                ? projectConfiguration.targets[targetName].configurations[configurationName]
                : projectConfiguration.targets[targetName].options;
            if (config.external && config.external.length > 0) {
                const hasEmotionStyledBase = config.external.includes('@emotion/styled/base');
                const hasReactJsxRuntime = config.external.includes('react/jsx-runtime');
                if (hasEmotionStyledBase && hasReactJsxRuntime) {
                    // Replace 'react/jsx-runtime' with '@emotion/react/jsx-runtime'
                    config.external.forEach((value, index) => {
                        if (value === 'react/jsx-runtime') {
                            config.external.splice(index, 1, '@emotion/react/jsx-runtime');
                        }
                    });
                    // Remove '@emotion/styled/base'
                    config.external.forEach((value, index) => {
                        if (value === '@emotion/styled/base') {
                            config.external.splice(index, 1);
                        }
                    });
                }
                (0, devkit_1.updateProjectConfiguration)(tree, projectName, projectConfiguration);
            }
        });
    });
}
exports.updateExternalEmotionJsxRuntime = updateExternalEmotionJsxRuntime;
exports.default = updateExternalEmotionJsxRuntime;
//# sourceMappingURL=update-external-emotion-jsx-runtime.js.map