"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadModuleFederationConfigFromContext = void 0;
const path_1 = require("path");
function loadModuleFederationConfigFromContext(context) {
    const p = context.workspace.projects[context.projectName];
    const moduleFederationConfigPath = (0, path_1.join)(context.root, p.root, 'module-federation.config.js');
    try {
        return require(moduleFederationConfigPath);
    }
    catch (_a) {
        // TODO(jack): Add a link to guide
        throw new Error(`Could not load ${moduleFederationConfigPath}. Was this project generated with "@nrwl/react:host"?`);
    }
}
exports.loadModuleFederationConfigFromContext = loadModuleFederationConfigFromContext;
//# sourceMappingURL=load-config.js.map