import { Tree } from '@nrwl/devkit';
import { StorybookConfigureSchema } from './schema';
export declare function addStorybookTask(tree: Tree, projectName: string, uiFramework: string): void;
export declare function addAngularStorybookTask(tree: Tree, projectName: string): void;
export declare function configureTsProjectConfig(tree: Tree, schema: StorybookConfigureSchema): void;
export declare function configureTsSolutionConfig(tree: Tree, schema: StorybookConfigureSchema): void;
/**
 * When adding storybook we need to inform TSLint or ESLint
 * of the additional tsconfig.json file which will be the only tsconfig
 * which includes *.stories files.
 *
 * For TSLint this is done via the builder config, for ESLint this is
 * done within the .eslintrc.json file.
 */
export declare function updateLintConfig(tree: Tree, schema: StorybookConfigureSchema): void;
export declare function normalizeSchema(schema: StorybookConfigureSchema): StorybookConfigureSchema;
export declare function createRootStorybookDir(tree: Tree, js: boolean, tsConfiguration: boolean): void;
export declare function createProjectStorybookDir(tree: Tree, projectName: string, uiFramework: StorybookConfigureSchema['uiFramework'], js: boolean, tsConfiguration: boolean, isNextJs?: boolean, usesSwc?: boolean): void;
export declare function getTsConfigPath(tree: Tree, projectName: string, path?: string): string;
