import { ExecutorContext, TargetConfiguration, Tree } from '@nrwl/devkit';
import { CompilerOptions } from 'typescript';
import { StorybookConfig } from '../executors/models';
import ts = require('typescript');
export declare const Constants: {
    addonDependencies: string[];
    tsConfigExclusions: string[];
    pkgJsonScripts: {
        storybook: string;
    };
    jsonIndentLevel: number;
    coreAddonPrefix: string;
    uiFrameworks: {
        readonly angular: "@storybook/angular";
        readonly react: "@storybook/react";
        readonly html: "@storybook/html";
        readonly 'web-components': "@storybook/web-components";
        readonly vue: "@storybook/vue";
        readonly vue3: "@storybook/vue3";
        readonly svelte: "@storybook/svelte";
        readonly 'react-native': "@storybook/react-native";
    };
};
declare type Constants = typeof Constants;
declare type Framework = {
    type: keyof Constants['uiFrameworks'];
    uiFramework: Constants['uiFrameworks'][keyof Constants['uiFrameworks']];
};
export declare function isFramework(type: Framework['type'], schema: Pick<Framework, 'uiFramework'>): boolean;
export declare function safeFileDelete(tree: Tree, path: string): boolean;
export declare function readCurrentWorkspaceStorybookVersionFromGenerator(tree: Tree): string;
export declare function readCurrentWorkspaceStorybookVersionFromExecutor(): string;
export declare type TsConfig = {
    extends: string;
    compilerOptions: CompilerOptions;
    files?: string[];
    include?: string[];
    exclude?: string[];
    references?: Array<{
        path: string;
    }>;
};
export declare function findOrCreateConfig(config: StorybookConfig, context: ExecutorContext): string;
export declare function dedupe(arr: string[]): string[];
/**
 * This function is used to find the build targets for Storybook
 * and the project (if it's buildable).
 *
 * The reason this function exists is because we cannot assume
 * that the user has not created a custom build target for the project,
 * or that they have not changed the name of the build target
 * from build to anything else.
 *
 * So, in order to find the correct name of the target,
 * we have to look into all the targets, check the executor
 * they are using, and infer from the executor that the target
 * is a build target.
 */
export declare function findStorybookAndBuildTargetsAndCompiler(targets: {
    [targetName: string]: TargetConfiguration;
}): {
    storybookBuildTarget?: string;
    storybookTarget?: string;
    ngBuildTarget?: string;
    nextBuildTarget?: string;
    otherBuildTarget?: string;
    compiler?: string;
};
export declare function isTheFileAStory(tree: Tree, path: string): boolean;
export declare function getTsSourceFile(host: Tree, path: string): ts.SourceFile;
export {};
