'use strict';

var fs = require('fs');
var core$1 = require('@svgr/core');
var pluginutils = require('@rollup/pluginutils');
var core = require('@babel/core');
var svgo = require('@svgr/plugin-svgo');
var jsx = require('@svgr/plugin-jsx');
var presetReact = require('@babel/preset-react');
var presetEnv = require('@babel/preset-env');
var presetTS = require('@babel/preset-typescript');
var pluginTransformReactConstantElements = require('@babel/plugin-transform-react-constant-elements');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n["default"] = e;
  return Object.freeze(n);
}

var fs__namespace = /*#__PURE__*/_interopNamespace(fs);
var svgo__default = /*#__PURE__*/_interopDefaultLegacy(svgo);
var jsx__default = /*#__PURE__*/_interopDefaultLegacy(jsx);
var presetReact__default = /*#__PURE__*/_interopDefaultLegacy(presetReact);
var presetEnv__default = /*#__PURE__*/_interopDefaultLegacy(presetEnv);
var presetTS__default = /*#__PURE__*/_interopDefaultLegacy(presetTS);
var pluginTransformReactConstantElements__default = /*#__PURE__*/_interopDefaultLegacy(pluginTransformReactConstantElements);

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const babelOptions = {
  babelrc: false,
  configFile: false,
  presets: [
    core.createConfigItem(presetReact__default["default"], { type: "preset" }),
    core.createConfigItem([presetEnv__default["default"], { modules: false }], { type: "preset" })
  ],
  plugins: [core.createConfigItem(pluginTransformReactConstantElements__default["default"])]
};
const typeScriptBabelOptions = __spreadProps(__spreadValues({}, babelOptions), {
  presets: [
    ...babelOptions.presets,
    core.createConfigItem([presetTS__default["default"], { allowNamespaces: true, allExtensions: true, isTSX: true }], { type: "preset" })
  ]
});
const plugin = (options = {}) => {
  const EXPORT_REGEX = /(module\.exports *= *|export default)/;
  const filter = pluginutils.createFilter(options.include || "**/*.svg", options.exclude);
  const { babel = true } = options;
  return {
    name: "svgr",
    async transform(data, id) {
      if (!filter(id))
        return null;
      if (id.slice(-4) !== ".svg")
        return null;
      const load = fs__namespace.readFileSync(id, "utf8");
      const previousExport = EXPORT_REGEX.test(data) ? data : null;
      const jsCode = await core$1.transform(load, options, {
        filePath: id,
        caller: {
          name: "@svgr/rollup",
          previousExport,
          defaultPlugins: [svgo__default["default"], jsx__default["default"]]
        }
      });
      if (babel) {
        const result = await core.transformAsync(jsCode, options.typescript ? typeScriptBabelOptions : babelOptions);
        if (!(result == null ? void 0 : result.code)) {
          throw new Error(`Error while transforming using Babel`);
        }
        return { code: result.code, map: null };
      }
      return {
        ast: {
          type: "Program",
          start: 0,
          end: 0,
          sourceType: "module",
          body: []
        },
        code: jsCode,
        map: null
      };
    }
  };
};

module.exports = plugin;
//# sourceMappingURL=index.js.map
