/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/// <reference types="cypress" />
import { ConsoleHeaderDomConstants } from "../../constants";
import { Header } from "../common";
/**
 * Class containing Console Header component objects.
 */
var ConsoleHeader = /** @class */ (function (_super) {
    __extends(ConsoleHeader, _super);
    function ConsoleHeader() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Click on the developer portal switch.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    ConsoleHeader.prototype.clickOnDevelopPortalSwitch = function (options) {
        cy.dataTestId(ConsoleHeaderDomConstants.DEVELOP_SWITCH_DATA_ATTR).click();
    };
    /**
     * Click on the manage portal switch.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    ConsoleHeader.prototype.clickOnManagePortalSwitch = function (options) {
        cy.dataTestId(ConsoleHeaderDomConstants.MANAGE_SWITCH_DATA_ATTR).click();
    };
    return ConsoleHeader;
}(Header));
export { ConsoleHeader };
//# sourceMappingURL=console-header.js.map