/**
 * Copyright (c) 2021, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
/// <reference types="cypress" />
/**
 * Class containing Console Side Panel component objects.
 */
export declare class ConsoleSidePanel {
    /**
     * Click on Applications feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToApplications(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on IDP feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToIdentityProviders(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on Users feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToUsers(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on Groups feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToGroups(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on Roles feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToRoles(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on Userstores feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToUserstores(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on Certificates feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToCertificates(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on Attributes feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToAttributes(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on Dialects feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToDialects(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on OIDC Scopes feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToOIDCScopes(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on Email Templates feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToEmailTemplates(options?: Partial<Cypress.ClickOptions>): void;
    /**
     * Click on Remote Fetch feature from side panel.
     * @param {Partial<ClickOptions>} options - Click options.
     */
    navigateToRemoteFetch(options?: Partial<Cypress.ClickOptions>): void;
}
