/// <reference types="node" />
import { ChildProcess } from 'child_process';
import { ProjectGraph } from '../../config/project-graph';
import { NxJsonConfiguration } from 'nx/src/config/nx-json';
export declare class DaemonClient {
    private readonly nxJson;
    constructor(nxJson: NxJsonConfiguration);
    enabled(): boolean;
    getProjectGraph(): Promise<ProjectGraph>;
    processInBackground(requirePath: string, data: any): Promise<any>;
}
export declare function startInBackground(): Promise<ChildProcess['pid']>;
export declare function startInCurrentProcess(): void;
export declare function stop(): void;
/**
 * As noted in the comments above the createServer() call, in order to reliably (meaning it works
 * cross-platform) check whether the server is available to request a project graph from we
 * need to actually attempt connecting to it.
 *
 * Because of the behavior of named pipes on Windows, we cannot simply treat them as a file and
 * check for their existence on disk (unlike with Unix Sockets).
 */
export declare function isServerAvailable(): Promise<boolean>;
