<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->


















# parse-path

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Travis](https://img.shields.io/travis/IonicaBizau/parse-path.svg)](https://travis-ci.org/IonicaBizau/parse-path/) [![Version](https://img.shields.io/npm/v/parse-path.svg)](https://www.npmjs.com/package/parse-path) [![Downloads](https://img.shields.io/npm/dt/parse-path.svg)](https://www.npmjs.com/package/parse-path) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> Parse paths (local paths, urls: ssh/git/etc)

















## :cloud: Installation

```sh
# Using npm
npm install --save parse-path

# Using yarn
yarn add parse-path
```













## :clipboard: Example



```js
// Dependencies
const parsePath = require("parse-path")

console.log(parsePath("http://ionicabizau.net/blog"))
// {
//   protocols: [ 'http' ],
//   protocol: 'http',
//   port: '',
//   resource: 'ionicabizau.net',
//   user: '',
//   password: '',
//   pathname: '/blog',
//   hash: '',
//   search: '',
//   href: 'http://ionicabizau.net/blog',
//   query: {}
// }

console.log(parsePath("http://domain.com/path/name?foo=bar&bar=42#some-hash"))
// {
//   protocols: [ 'http' ],
//   protocol: 'http',
//   port: '',
//   resource: 'domain.com',
//   user: '',
//   password: '',
//   pathname: '/path/name',
//   hash: 'some-hash',
//   search: 'foo=bar&bar=42',
//   href: 'http://domain.com/path/name?foo=bar&bar=42#some-hash',
//   query: { foo: 'bar', bar: '42' }
// }

console.log(parsePath("git+ssh://git@host.xz/path/name.git"))
// {
//   protocols: [ 'git', 'ssh' ],
//   protocol: 'git',
//   port: '',
//   resource: 'host.xz',
//   user: 'git',
//   password: '',
//   pathname: '/path/name.git',
//   hash: '',
//   search: '',
//   href: 'git+ssh://git@host.xz/path/name.git',
//   query: {}
// }
```











## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:





## :memo: Documentation


### `parsePath(url)`
Parses the input url.

#### Params

- **String** `url`: The input url.

#### Return
- **Object** An object containing the following fields:
   - `protocols` (Array): An array with the url protocols (usually it has one element).
   - `protocol` (String): The first protocol or `"file"`.
   - `port` (String): The domain port (default: `""`).
   - `resource` (String): The url domain (including subdomain and port).
   - `user` (String): The authentication user (default: `""`).
   - `password` (String): The authentication password (default: `""`).
   - `pathname` (String): The url pathname.
   - `hash` (String): The url hash.
   - `search` (String): The url querystring value (excluding `?`).
   - `href` (String): The normalized input url.
   - `query` (Object): The url querystring, parsed as object.














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `parse-url`
 - `@semantic-release/gitlab`
 - `@pvm/gitlab`
 - `eleventy-plugin-embed-soundcloud`
 - `@enkeledi/react-native-week-month-date-picker`
 - `@hemith/react-native-tnk`
 - `native-kakao-login`
 - `npm_one_1_2_3`
 - `react-fsm-router`
 - `react-native-arunmeena1987`
 - `react-native-biometric-authenticate`
 - `react-native-contact-list`
 - `react-native-is7`
 - `react-native-payu-payment-testing`
 - `react-native-kakao-maps`
 - `react-native-my-first-try-arun-ramya`
 - `react-native-ytximkit`
 - `rn-adyen-dropin`
 - `tria-prima`
 - `sm-versioning`
 - `@positionex/position-sdk`
 - `@corelmax/react-native-my2c2p-sdk`
 - `@felipesimmi/react-native-datalogic-module`
 - `@hawkingnetwork/react-native-tab-view`
 - `drowl-base-theme-iconset`
 - `native-apple-login`
 - `react-native-cplus`
 - `npm_qwerty`
 - `react-native-bubble-chart`
 - `react-native-arunjeyam1987`
 - `react-native-flyy`
 - `@saad27/react-native-bottom-tab-tour`
 - `@xudong/semantic-release-gitlab`
 - `candlelabssdk`
 - `@fgreinacher/semantic-release-gitlab`
 - `@geeky-apo/react-native-advanced-clipboard`
 - `react-native-dsphoto-module`
 - `react-native-responsive-size`
 - `react-native-sayhello-module`
 - `@flareapp/ignition-ui`
 - `react-feedback-sdk`
 - `npm_one_12_34_1_`
 - `npm_one_2_2`
 - `payutesting`
 - `semantic-release-gitee`
 - `semantic-release-gitlab-plugin`
 - `@pvm/plugin-conventional-changelog`
 - `@pvm/github`
 - `@con-test/react-native-concent-common`
 - `reac-native-arun-ramya-test`
 - `react-native-arun-ramya-test`
 - `react-native-arunramya151`
 - `react-native-plugpag-wrapper`
 - `react-native-pulsator-native`
 - `react-native-transtracker-library`
 - `semantic-release-version`
 - `@devdiary/semantic-devdiary-release`
 - `luojia-cli-dev`
 - `birken-react-native-community-image-editor`
 - `@screeb/react-native`
 - `@buganto/client`
 - `@cloudoki/donderflow`
 - `@tjoussen/semantic-release-gitlab-mr`
 - `astra-ufo-sdk`
 - `react-native-syan-photo-picker`
 - `@wecraftapps/react-native-use-keyboard`
 - `electron-info`
 - `l2forlerna`
 - `native-google-login`
 - `raact-native-arunramya151`
 - `react-native-modal-progress-bar`
 - `react-native-test-module-hhh`
 - `reddit-title-has-verbatim-quote`
 - `react-native-jsi-device-info`
 - `react-native-badge-control`
 - `rn-tm-notify`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
