/**
* Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
*
* WSO2 Inc. licenses this file to you under the Apache License,
* Version 2.0 (the 'License'); you may not use this file except
* in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* 'AS IS' BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied. See the License for the
* specific language governing permissions and limitations
* under the License.
*/
/**
 * Model of the certificate objects returned by the keystore endpoints.
 */
export interface Certificate {
    alias: string;
    certificate: string;
}
/**
 * Model for the Certificate object to be stored in the state.
 */
export interface DisplayCertificate {
    alias?: string;
    validFrom: Date;
    validTill: Date;
    issuerDN: DistinguishedName[];
    subjectDN: DistinguishedName[];
    version: number;
    serialNumber: string;
    infoUnavailable?: boolean;
}
/**
 * Validity enumerations.
 */
export declare enum CertificateValidity {
    EXPIRED = 0,
    WILL_EXPIRE_SOON = 1,
    VALID = 2
}
/**
 * Model of the Issuer and Subject DN.
 */
export interface DistinguishedName {
    [key: string]: string;
}
