/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ResetAuthenticationActionInterface, SetDefaultTenantActionInterface, SetInitializedActionInterface, SetSignInActionInterface, SetSignOutActionInterface, SetTenantsActionInterface } from "./types";
/**
 * Redux action to set sign in.
 *
 * @return {SetSignInActionInterface} An action of type `SET_SIGN_IN`
 */
export declare const setSignIn: <T>(userInfo: T) => SetSignInActionInterface<T>;
/**
 * Redux action to set sign out.
 *
 * @return {SetSignOutActionInterface} An action of type `SET_SIGN_OUT`
 */
export declare const setSignOut: () => SetSignOutActionInterface;
/**
 * Redux action to set initialized.
 *
 * @return {SetSignOutActionInterface} An action of type `SET_INITIALIZED`.
 */
export declare const setInitialized: (flag: boolean) => SetInitializedActionInterface;
/**
 * Redux action to reset authentication.
 *
 * @return {ResetAuthenticationActionInterface} An action of type `RESET_AUTHENTICATION`
 */
export declare const resetAuthentication: () => ResetAuthenticationActionInterface;
/**
 * Redux action to set default tenant.
 *
 * @return {SetDefaultTenantActionInterface} An action of type `SET_DEFAULT_TENANT`.
 */
export declare const setDefaultTenant: (tenantName: string) => SetDefaultTenantActionInterface;
/**
 * Redux action to set tenants.
 *
 * @return {SetTenantsActionInterface} An action of type `SET_TENANTS`.
 */
export declare const setTenants: <T>(tenants: T[]) => SetTenantsActionInterface;
