/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface, TestableComponentInterface } from "@wso2is/core/models";
import { CSSProperties, FunctionComponent, PropsWithChildren } from "react";
import { InputProps, PopupProps } from "semantic-ui-react";
/**
 *
 * Proptypes for the advanced search component.
 */
export interface AdvancedSearchPropsInterface extends IdentifiableComponentInterface, TestableComponentInterface {
    /**
     * Text alignment.
     */
    aligned?: "left" | "right" | "center";
    /**
     * Additional CSS classes.
     */
    className?: string;
    /**
     * Clear button tooltip label.
     */
    clearButtonPopupLabel?: string;
    /**
     * Clear icon override.
     */
    clearIcon?: any;
    /**
     * Search strategy ex: name co %search-value%.
     */
    defaultSearchStrategy: string;
    /**
     * Disables the dropdown filter for search
     */
    disableSearchFilterDropdown?: boolean;
    /**
     * Dropdown appearing position.
     */
    dropdownPosition?: PopupProps["position"];
    /**
     * Dropdown trigger icon label.
     */
    dropdownTriggerPopupLabel?: string;
    /**
     * Search query from outside.
     */
    externalSearchQuery?: string;
    /**
     * Fill color.
     */
    fill?: "white" | "default";
    /**
     * Hint action keyboard keys.
     */
    hintActionKeys?: string;
    /**
     * Hint label.
     */
    hintLabel?: string;
    /**
     * Search input size.
     */
    inputSize?: InputProps["size"];
    /**
     * Callback for external search query clear.
     */
    onExternalSearchQueryClear?: () => void;
    /**
     * Callback for search query submit.
     * @param processQuery - process flag.
     * @param query - Search query.
     */
    onSearchQuerySubmit: (processQuery: boolean, query: string) => void;
    /**
     * input placeholder.
     */
    placeholder?: string;
    /**
     * Reset trigger.
     */
    resetSubmittedState?: () => void;
    /**
     * Dropdown heading.
     */
    searchOptionsHeader?: string;
    /**
     * Session Timed Out status.
     */
    sessionTimedOut?: boolean;
    /**
     * Custom CSS styles for text input box.
     */
    style?: CSSProperties | undefined;
    /**
     * Is form submitted.
     */
    submitted?: boolean;
    /**
     * Manually trigger query clear action from outside.
     */
    triggerClearQuery?: boolean;
    /**
     * Enable query search with shift and enter.
     */
    enableQuerySearch?: boolean;
    /**
     * Default filter conditions.
     */
    filterConditionOptions?: any;
    /**
     * Default filter attributes.
     */
    filterAttributeOptions?: any;
}
/**
 * Advanced search component.
 *
 * @param props - Props injected to the component.
 *
 * @returns React element.
 */
export declare const AdvancedSearch: FunctionComponent<PropsWithChildren<AdvancedSearchPropsInterface>>;
