/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface, TestableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent } from "react";
export interface InlineEditInputPropsInterface extends IdentifiableComponentInterface, TestableComponentInterface {
    text: string;
    validation?: string;
    errorHandler?: (status: boolean) => void;
    textPrefix?: string;
    textPostfix?: string;
    inputPlaceholderText?: string;
    onChangesSaved: (changedValue: string) => void;
    onEdit?: (editMode: boolean) => void;
    maxLength?: number;
}
/**
 * Inline edit input field component.
 *
 * @param props - props required for the inline edit component.
 * @returns inline edit input component
 */
export declare const InlineEditInput: FunctionComponent<InlineEditInputPropsInterface>;
