/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface, TestableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent } from "react";
import { MessageHeaderProps, MessageProps, SemanticShorthandContent, SemanticShorthandItem } from "semantic-ui-react";
/**
 * Proptypes for the message with icon component.
 */
export interface MessagePropsInterface extends MessageProps, IdentifiableComponentInterface, TestableComponentInterface {
    /**
     * Type of the message.
     */
    type?: "info" | "warning" | "error" | "success";
    /**
     * Additional CSS classes.
     */
    className?: string;
    /**
     * Content of the message.
     * */
    content?: SemanticShorthandContent;
    /**
     * Header of the message.
     * */
    header?: SemanticShorthandItem<MessageHeaderProps>;
    /**
     * Change the visibility of the message.
     * */
    visible?: boolean;
}
/**
 * Message with icon component.
 *
 * @param props - Props injected in to the message with icon component.
 * @returns Message with icon component.
 */
export declare const Message: FunctionComponent<MessagePropsInterface>;
