/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface, LoadingStateOptionsInterface, TestableComponentInterface } from "@wso2is/core/models";
import React, { FunctionComponent } from "react";
import { MenuProps, SemanticShorthandItem, TabPaneProps, TabProps } from "semantic-ui-react";
import { ResourceTabPane } from "./resource-tab-pane";
/**
 * Interface for the resource tab sub components.
 */
export interface ResourceTabSubComponentsInterface {
    Pane: typeof ResourceTabPane;
}
/**
 * Interface for the resource tab pane components.
 */
export interface ResourceTabPaneInterface {
    pane?: SemanticShorthandItem<TabPaneProps>;
    menuItem?: any;
    render?: () => React.ReactNode;
    "data-tabid"?: string;
    componentId?: string;
}
/**
 * Resource tabs component Prop types.
 */
export interface ResourceTabPropsInterface extends TabProps, IdentifiableComponentInterface, TestableComponentInterface {
    /**
     * Custom class for the component.
     */
    className?: string;
    /**
     * Callback to set the panes list length.
     */
    onInitialize?: ({ panesLength }: {
        panesLength: number;
    }) => void;
    /**
     * Is the tab menu and content attached?
     */
    attached?: MenuProps["attached"];
    /**
     * Optional meta for the loading state.
     */
    loadingStateOptions?: LoadingStateOptionsInterface;
    /**
     * Is the tab menu has pointed items.
     */
    pointing?: MenuProps["pointing"];
    /**
     * Is the tab menu in secondary variation.
     */
    secondary?: MenuProps["secondary"];
    /**
     * Is the data still loading.
     */
    isLoading?: boolean;
    /**
     * Specifies if it is needed to redirect to a specific tabindex
     */
    isAutomaticTabRedirectionEnabled?: boolean;
    /**
     * Specifies, to which tab(tabid) it need to redirect.
     */
    tabIdentifier?: string;
}
/**
 * Resource tab component.
 *
 * @param props - Props injected to the component.
 *
 * @returns Resource tab component
 */
export declare const ResourceTab: FunctionComponent<ResourceTabPropsInterface> & ResourceTabSubComponentsInterface;
