/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface, LoadableComponentInterface, TestableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent, PropsWithChildren, ReactNode } from "react";
/**
 * Grid layout component Prop types.
 */
export interface GridLayoutPropsInterface extends IdentifiableComponentInterface, TestableComponentInterface, LoadableComponentInterface {
    /**
     * Is Pagination in-progress.
     */
    isPaginating?: boolean;
    /**
     * Search component.
     */
    search?: ReactNode;
    /**
     * Position of the advanced search component.
     */
    searchPosition?: "left" | "right";
    /**
     * Extra CSS classes.
     */
    className?: string;
    /**
     * Left action panel component.
     */
    leftActionPanel?: ReactNode;
    /**
     * Enable/Disable Pagination.
     */
    paginate?: () => void;
    /**
     * Right action panel component.
     */
    rightActionPanel?: ReactNode;
    /**
     * Flag to toggle top action panel visibility.
     */
    showTopActionPanel?: boolean;
    /**
     * i18n translations for content.
     */
    translations?: GridLayoutContentI18nInterface;
}
/**
 * Interface for the i18n string of the component.
 */
export interface GridLayoutContentI18nInterface {
    loading: ReactNode;
}
/**
 * Grid layout component.
 *
 * @param props - Props injected to the component.
 *
 * @returns the React component for Grid layout.
 */
export declare const GridLayout: FunctionComponent<PropsWithChildren<GridLayoutPropsInterface>>;
