/**
 * Copyright (c) 2020, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface, TestableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent, ReactNode } from "react";
import { IUnControlledCodeMirror } from "react-codemirror2";
import "codemirror/addon/lint/lint";
import "codemirror/addon/lint/javascript-lint";
import "codemirror/addon/hint/sql-hint";
import "codemirror/mode/javascript/javascript";
import "codemirror/mode/sql/sql";
import "codemirror/mode/xml/xml";
import "codemirror/mode/shell/shell";
import "codemirror/mode/htmlmixed/htmlmixed";
import "codemirror/addon/edit/closebrackets";
import "codemirror/addon/edit/matchbrackets";
import "codemirror/addon/hint/show-hint";
import "codemirror/addon/hint/javascript-hint";
import "codemirror/lib/codemirror.css";
import "codemirror/theme/material.css";
import "codemirror/addon/lint/lint.css";
import "codemirror/addon/hint/show-hint.css";
/**
 * Code editor component Prop types.
 */
export interface CodeEditorProps extends IUnControlledCodeMirror, IdentifiableComponentInterface, TestableComponentInterface {
    /**
     * Allow going full screen.
     */
    allowFullScreen?: boolean;
    /**
     * Allow to control the fullscreen mode from outside.
     */
    controlledFullScreenMode?: boolean;
    /**
     * Whether to format the code.
     */
    beautify?: boolean;
    /**
     * Trigger the fullscreen mode.
     */
    triggerFullScreen?: boolean;
    /**
     * Language the code is written in.
     */
    language?: "javascript" | "json" | "typescript" | "htmlmixed" | "shell" | string;
    /**
     * Flat to enable line wrapping.
     */
    lineWrapping?: boolean;
    /**
     * Whether to enable linting or not.
     */
    lint?: boolean;
    /**
     * Should the editor be formatted for a one line command.
     */
    oneLiner?: boolean;
    /**
     * Callback to be triggered on fullscreen toggle.
     */
    onFullScreenToggle?: (isFullScreen: boolean) => void;
    /**
     * If the editor is read only or not.
     */
    readOnly?: boolean | string;
    /**
     * Whether to show line numbers.
     */
    showLineNumbers?: boolean;
    /**
     * Whether to enable smart mode which will enable auto bracket
     * closing etc.
     */
    smart?: boolean;
    /**
     * Code to be displayed on the editor.
     */
    sourceCode?: any;
    /**
     * Tab indent size.
     */
    tabSize?: number;
    /**
     * Height of the editor.
     */
    height?: "100%" | string;
    /**
     * Editor theme.
     */
    theme?: "dark" | "light";
    /**
     * Get theme from the environment.
     */
    getThemeFromEnvironment?: boolean;
    /**
     * i18n translations for content.
     */
    translations?: CodeEditorContentI18nInterface;
    /**
     * Enable clipboard copy option.
     */
    withClipboardCopy?: boolean;
}
/**
 * Interface for the i18n string of the component.
 */
export interface CodeEditorContentI18nInterface {
    copyCode: ReactNode;
    exitFullScreen: ReactNode;
    goFullScreen: ReactNode;
}
/**
 * Code editor component.
 *
 * @param props - Props injected to the danger zone component.
 *
 * @returns the code editor component.
 */
export declare const CodeEditor: FunctionComponent<CodeEditorProps>;
