/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface, TestableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent } from "react";
import { MessageHeaderProps } from "semantic-ui-react/dist/commonjs/collections/Message/MessageHeader";
import { SemanticShorthandContent, SemanticShorthandItem } from "semantic-ui-react/dist/commonjs/generic";
/**
 * Prop-types for the messageInfo component.
 */
export interface MessageInfoProps extends IdentifiableComponentInterface, TestableComponentInterface {
    /**
     * Shorthand for MessageHeader.
     * */
    header?: SemanticShorthandItem<MessageHeaderProps>;
    /**
     * Shorthand for primary content.
     * */
    content?: SemanticShorthandContent;
}
/**
 * MessageInfo component.
 *
 * @deprecated Use the new `Message` component from `@wso2is/react-components` instead.
 * @param props - Props injected in to the messageInfo component.
 * @returns Message info component.
 */
export declare const MessageInfo: FunctionComponent<MessageInfoProps>;
