/**
 * Copyright (c) 2021, WSO2 LLC. (https://www.wso2.com). All Rights Reserved.
 *
 * WSO2 LLC. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { IdentifiableComponentInterface } from "@wso2is/core/models";
import { FunctionComponent, ReactNode } from "react";
/**
 * Prop type of the `ChunkErrorModal` component.
 */
interface ChunkModalPropsInterface extends IdentifiableComponentInterface {
    heading: ReactNode;
    description: ReactNode;
    primaryActionText: ReactNode;
}
/**
 * This component listens to the `chunk load error` and pops up a modal
 * when this error is occurred.
 */
export declare const ChunkErrorModal: FunctionComponent<ChunkModalPropsInterface>;
export {};
