/**
 * Copyright (c) 2022, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { AsgardeoAuthClient, AuthClientConfig, BasicUserInfo, CryptoHelper, CustomGrantConfig, DataLayer, DecodedIDTokenPayload, FetchResponse, GetAuthURLConfig, OIDCEndpoints } from "@asgardeo/auth-js";
import { SPAHelper } from "./spa-helper";
import { SessionManagementHelperInterface } from "..";
import { HttpClientInstance, HttpError, HttpRequestConfig, HttpResponse, MainThreadClientConfig, WebWorkerClientConfig } from "../models";
import { SPACustomGrantConfig } from "../models/request-custom-grant";
export declare class AuthenticationHelper<T extends MainThreadClientConfig | WebWorkerClientConfig> {
    protected _authenticationClient: AsgardeoAuthClient<T>;
    protected _dataLayer: DataLayer<T>;
    protected _spaHelper: SPAHelper<T>;
    constructor(authClient: AsgardeoAuthClient<T>, spaHelper: SPAHelper<T>);
    enableHttpHandler(httpClient: HttpClientInstance): void;
    disableHttpHandler(httpClient: HttpClientInstance): void;
    initializeSessionManger(config: AuthClientConfig<T>, oidcEndpoints: OIDCEndpoints, getSessionState: () => Promise<string>, getAuthzURL: (params?: GetAuthURLConfig) => Promise<string>, sessionManagementHelper: SessionManagementHelperInterface): void;
    requestCustomGrant(config: SPACustomGrantConfig, enableRetrievingSignOutURLFromSession?: (config: SPACustomGrantConfig) => void): Promise<BasicUserInfo | FetchResponse>;
    getCustomGrantConfigData(): Promise<AuthClientConfig<CustomGrantConfig> | null>;
    refreshAccessToken(enableRetrievingSignOutURLFromSession?: (config: SPACustomGrantConfig) => void): Promise<BasicUserInfo>;
    httpRequest(httpClient: HttpClientInstance, requestConfig: HttpRequestConfig, isHttpHandlerEnabled?: boolean, httpErrorCallback?: (error: HttpError) => void | Promise<void>, httpFinishCallback?: () => void, enableRetrievingSignOutURLFromSession?: (config: SPACustomGrantConfig) => void): Promise<HttpResponse>;
    httpRequestAll(requestConfigs: HttpRequestConfig[], httpClient: HttpClientInstance, isHttpHandlerEnabled?: boolean, httpErrorCallback?: (error: HttpError) => void | Promise<void>, httpFinishCallback?: () => void): Promise<HttpResponse[] | undefined>;
    requestAccessToken(authorizationCode?: string, sessionState?: string, checkSession?: () => Promise<void>, pkce?: string, state?: string): Promise<BasicUserInfo>;
    trySignInSilently(constructSilentSignInUrl: () => Promise<string>, requestAccessToken: (authzCode: string, sessionState: string, state: string) => Promise<BasicUserInfo>, sessionManagementHelper: SessionManagementHelperInterface): Promise<BasicUserInfo | boolean>;
    handleSignIn(shouldStopAuthn: () => Promise<boolean>, checkSession: () => Promise<void>, tryRetrievingUserInfo?: () => Promise<BasicUserInfo | undefined>): Promise<BasicUserInfo | undefined>;
    getBasicUserInfo(): Promise<BasicUserInfo>;
    getDecodedIDToken(): Promise<DecodedIDTokenPayload>;
    getDecodedIDPIDToken(): Promise<DecodedIDTokenPayload>;
    getCryptoHelper(): Promise<CryptoHelper>;
    getIDToken(): Promise<string>;
    getOIDCServiceEndpoints(): Promise<OIDCEndpoints>;
    getAccessToken(): Promise<string>;
    getIDPAccessToken(): Promise<string>;
    getDataLayer(): DataLayer<T>;
    isAuthenticated(): Promise<boolean>;
}
//# sourceMappingURL=authentication-helper.d.ts.map