/**
 * Copyright (c) 2020, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { SignOutError } from "..";
export declare class SPAUtils {
    private constructor();
    static removeAuthorizationCode(): void;
    static getPKCE(pkceKey: string): string;
    static setPKCE(pkceKey: string, pkce: string): void;
    static setSignOutURL(url: string): void;
    static getSignOutURL(): string;
    static removePKCE(pkceKey: string): void;
    /**
     * This method is used to discontinue the execution of the `signIn` method if `callOnlyOnRedirect` is true and
     * the method is not called on being redirected from the authorization server.
     *
     * This method can be used to allow the `signIn` method to be called only
     * on being redirected from the authorization server.
     *
     * @param callOnlyOnRedirect {boolean} - True if the method should only be called on redirect.
     * @param authorizationCode {string} - Authorization code.
     *
     * @returns {boolean} - True if the method should be called.
     */
    static canContinueSignIn(callOnlyOnRedirect: boolean, authorizationCode?: string): boolean;
    /**
     * Specifies if `trySilentSignIn` has been called.
     *
     * @returns {boolean} True if the `trySilentSignIn` method has been called once.
     */
    static isInitializedSilentSignIn(): boolean;
    /**
     * Specifies if the `signIn` method has been called.
     *
     * @returns {boolean} True if the `signIn` has been called.
     */
    static wasSignInCalled(): boolean;
    static wasSilentSignInCalled(): boolean;
    static isSignOutSuccessful(): Promise<boolean>;
    static didSignOutFail(): boolean | SignOutError;
    /**
     * Checks if the URL the user agent is redirected to after an authorization request has the state parameter.
     *
     * @returns {boolean} True if there is a session-check state or a silent sign-in state.
     */
    static isSilentStatePresentInURL(): boolean;
    /**
     * Util function to test if `code` and `session_state` are available in the URL as search params.
     * @since 0.2.0
     *
     * @param params - Search params.
     * @return {boolean}
     */
    static hasAuthSearchParamsInURL(params?: string): boolean;
    /**
     * Util function to check if the URL contains an error.
     *
     * @param url - URL to be checked.
     *
     * @returns {boolean} - True if the URL contains an error.
     */
    static hasErrorInURL(url?: string): boolean;
    /**
     * Checks if a prompt none can be sent by checking if a request has already been sent.
     *
     * @since 0.2.3
     *
     * @returns {boolean} - True if a prompt none request has not been sent.
     */
    static canSendPromptNoneRequest(): boolean;
    /**
     * Sets the status of prompt none request.
     *
     * @since 0.2.3
     *
     * @param canSend {boolean} - True if a prompt none request can be sent.
     */
    static setPromptNoneRequestSent(canSend: boolean): void;
    /**
     * Waits for a specified amount of time to give the user agent enough time to redirect.
     *
     * @param time {number} - Time in seconds.
     */
    static waitTillPageRedirect(time?: number): Promise<void>;
}
//# sourceMappingURL=spa-utils.d.ts.map