"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var react_component_ref_1 = require("@fluentui/react-component-ref");
var enzyme_1 = require("enzyme");
var React = require("react");
var fixtures_1 = require("./fixtures");
describe('RefForward', function () {
    describe('innerRef', function () {
        it('works with "forwardRef" API', function () {
            var forwardedRef = React.createRef();
            var innerRef = React.createRef();
            enzyme_1.mount(React.createElement(react_component_ref_1.RefForward, { innerRef: innerRef }, (React.createElement(fixtures_1.ForwardedRef, { ref: forwardedRef }))));
            expect(forwardedRef.current).toBeInstanceOf(Element);
            expect(innerRef.current).toBeInstanceOf(Element);
        });
        it('passes an updated node', function () {
            var innerRef = jest.fn();
            var forwardedRef = jest.fn();
            var updatedForwardedRef = jest.fn();
            var wrapper = enzyme_1.mount(React.createElement(react_component_ref_1.RefForward, { innerRef: innerRef }, (React.createElement(fixtures_1.ForwardedRef, { ref: forwardedRef, key: "first" }))));
            expect(innerRef).toHaveBeenCalledWith(expect.objectContaining({ tagName: 'BUTTON' }));
            expect(forwardedRef).toHaveBeenCalledWith(expect.objectContaining({ tagName: 'BUTTON' }));
            jest.resetAllMocks();
            wrapper.setProps({ children: React.createElement(fixtures_1.ForwardedRef, { ref: updatedForwardedRef, key: "second" }) });
            expect(innerRef).toHaveBeenCalledWith(expect.objectContaining({ tagName: 'BUTTON' }));
            expect(updatedForwardedRef).toHaveBeenCalledWith(expect.objectContaining({ tagName: 'BUTTON' }));
            expect(forwardedRef).not.toHaveBeenCalled();
        });
        it('handles updates of props', function () {
            var initialRef = jest.fn();
            var updatedRef = jest.fn();
            var wrapper = enzyme_1.mount(React.createElement(react_component_ref_1.RefForward, { innerRef: initialRef }, (React.createElement(fixtures_1.ForwardedRef, null))));
            expect(initialRef).toHaveBeenCalled();
            expect(updatedRef).not.toHaveBeenCalled();
            jest.resetAllMocks();
            wrapper.setProps({ innerRef: updatedRef });
            expect(initialRef).not.toHaveBeenCalled();
            expect(updatedRef).toHaveBeenCalled();
        });
    });
});
