"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
function run(task, context) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const res = yield context.hasher.hashTask(task);
        if (task.overrides['hasTypeAwareRules'] === true) {
            return res;
        }
        const deps = allDeps(task.id, context.taskGraph, context.projectGraph);
        const tags = context.hasher.hashArray(deps.map((d) => (context.workspaceConfig.projects[d].tags || []).join('|')));
        const command = res.details['command'];
        const selfSource = res.details.nodes[`${task.target.project}:$filesets`];
        const nodes = {};
        const hashes = [];
        for (const d of Object.keys(res.details.nodes)) {
            if (d.indexOf('$fileset') === -1) {
                nodes[d] = res.details.nodes[d];
                hashes.push(res.details.nodes[d]);
            }
        }
        return {
            value: context.hasher.hashArray([command, selfSource, ...hashes, tags]),
            details: {
                command,
                nodes: Object.assign({ [task.target.project]: selfSource, tags }, nodes),
            },
        };
    });
}
exports.default = run;
function allDeps(taskId, taskGraph, projectGraph) {
    const project = taskGraph.tasks[taskId].target.project;
    const dependencies = projectGraph.dependencies[project]
        .filter((d) => !!projectGraph.nodes[d.target])
        .map((d) => d.target);
    return dependencies;
}
//# sourceMappingURL=hasher.js.map